/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.model;

import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.controller.BoardTypeManager;
import com.huawei.dc.devicemanagement.controller.IBoardTypeManager;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.model.Resource;

public class DeviceModelAdapter {
    public static DeviceType populateDeviceTypeFromDeviceID(int iDeviceID) {
        DeviceType oDeviceType = new DeviceType();
        DeviceInfo oDevice = DCFrameWorkUtil.getDeviceInfoManager().getDevice(iDeviceID);
        if (null == oDevice) {
            return null;
        }
        DeviceTypeInfo oTypeInfo = oDevice.getDeviceTypeInfo();
        oDeviceType.setDeviceTypeID(oTypeInfo.getDevTypeID());
        oDeviceType.setDeviceTypeName(oTypeInfo.getDevTypeName());
        oDeviceType.setDeviceTypeVersionID(oTypeInfo.getDevTypeVersionId());
        oDeviceType.setDeviceTypeVersionName(oTypeInfo.getDevTypeVersionName());
        return oDeviceType;
    }

    public static Resource populateResourceFromDeviceID(int iDeviceID) {
        DeviceInfo oDevice = DCFrameWorkUtil.getDeviceInfoManager().getDevice(iDeviceID);
        if (null == oDevice) {
            return null;
        }
        Resource oResource = new Resource();
        oResource.setDeviceID(iDeviceID);
        oResource.setDeviceIP(oDevice.getDevIPAddress());
        oResource.setDeviceName(oDevice.getDevName());
        oResource.setRoleType(oDevice.getRoleType());
        oResource.setUpgradeMode(oDevice.getUpgradeMode());
        oResource.setUpgradeModeConfig(oDevice.getUpgradeModeConfig());
        if (null == oDevice.getDevVersion()) {
            oResource.setDeviceVersion("");
        } else {
            oResource.setDeviceVersion(oDevice.getDevVersion().getDevVersion());
        }
        return oResource;
    }

    public static Resource populateResourceFromDeviceID(DeviceInfo oDevice) {
        if (null == oDevice) {
            return null;
        }
        Resource oResource = new Resource();
        oResource.setDeviceID(oDevice.getDevId());
        oResource.setDeviceIP(oDevice.getDevIPAddress());
        oResource.setDeviceName(oDevice.getDevName());
        oResource.setRoleType(oDevice.getRoleType());
        oResource.setUpgradeMode(oDevice.getUpgradeMode());
        oResource.setUpgradeModeConfig(oDevice.getUpgradeModeConfig());
        if (null == oDevice.getDevVersion()) {
            oResource.setDeviceVersion("");
        } else {
            oResource.setDeviceVersion(oDevice.getDevVersion().getDevVersion().intern());
        }
        return oResource;
    }

    public static DeviceTypeInfo getDeviceTypeForResource(Resource oResource) {
        if (null == oResource) {
            return null;
        }
        DeviceInfo oDeviceInfo = DCFrameWorkUtil.getDeviceInfoManager().getDevice(oResource.getDeviceID());
        if (null == oDeviceInfo) {
            return null;
        }
        return oDeviceInfo.getDeviceTypeInfo();
    }

    public static String getBoardTypeName(Resource oResource) {
        IBoardTypeManager oBoardMgr = BoardTypeManager.getInstance();
        DeviceTypeInfo oDeviceTypeInfo = DeviceModelAdapter.getDeviceTypeForResource(oResource);
        String strBoardTypeName = oBoardMgr.getBoardTypeDescription(oDeviceTypeInfo.getDevTypeName(), oDeviceTypeInfo.getDevTypeVersionName(), oResource.getBoardType());
        return strBoardTypeName;
    }

    public static Resource populateResourceFromDevice(DeviceInfo oDevInfo) {
        Resource oResource = null;
        if (null == oDevInfo) {
            return oResource;
        }
        oResource = new Resource();
        oResource.setDeviceID(oDevInfo.getDevId());
        oResource.setDeviceIP(oDevInfo.getDevIPAddress());
        oResource.setDeviceName(oDevInfo.getDevName());
        oResource.setRoleType(oDevInfo.getRoleType());
        oResource.setUpgradeMode(oDevInfo.getUpgradeMode());
        oResource.setUpgradeModeConfig(oDevInfo.getUpgradeModeConfig());
        if (null == oDevInfo.getDevVersion()) {
            oResource.setDeviceVersion("");
        } else {
            oResource.setDeviceVersion(oDevInfo.getDevVersion().getDevVersion());
        }
        return oResource;
    }
}

