/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceview.devicetable.devicesearch;

import com.huawei.dc.common.components.deviceselection.DeviceSelectionPanel;
import com.huawei.dc.common.components.deviceselection.dropdown.DeviceSelectionDropDownPanel;
import com.huawei.dc.common.components.devicetreepanel.DeviceTreePanel;
import com.huawei.dc.common.components.tree.devicetree.DeviceTree;
import com.huawei.dc.common.components.tree.devicetree.descriptor.DeviceVersionTreeDescriptor;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.tree.DeviceNodeInfo;
import com.huawei.dc.common.tree.TreeNodeInfo;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceview.devicetable.devicesearch.AbstractDeviceSearchManager;
import com.huawei.dc.devicemanagement.deviceview.devicetable.devicesearch.DeviceSearchCriteria;
import com.huawei.dc.devicemanagement.deviceview.devicetable.devicesearch.IDeviceSearchManager;
import com.huawei.dc.taskmgmt.view.createtask.CreateTaskDeviceSelectionPanel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DeviceSearchOnTreeManger
extends AbstractDeviceSearchManager
implements IDeviceSearchManager {
    private DeviceTreePanel m_oDeviceTreePanel = null;
    private DefaultMutableTreeNode m_oRootNode = null;
    private DefaultMutableTreeNode m_oNewRootNode = null;
    private List m_oAllFoundTreePathLst = new ArrayList();
    private List<DeviceNodeInfo> m_oAllFoundDevNodeLst = new ArrayList<DeviceNodeInfo>();

    public DeviceSearchOnTreeManger(DeviceTreePanel devcieTreePanel) {
        this.m_oDeviceTreePanel = devcieTreePanel;
        this.initRootNode();
    }

    private void initRootNode() {
        DeviceTree deviceTree = this.m_oDeviceTreePanel.getDeviceTree();
        if (null != deviceTree) {
            this.m_oRootNode = deviceTree.getRoot();
        }
    }

    @Override
    public int findNextDevice(Object object) {
        DeviceSearchCriteria oSearchCriteria = (DeviceSearchCriteria)object;
        this.initFoundTreePathLst(oSearchCriteria);
        int iSearchStatus = 0;
        if (0 == oSearchCriteria.getResourceType()) {
            iSearchStatus = this.searchDeviceInLst(oSearchCriteria);
        }
        return iSearchStatus;
    }

    @Override
    public int filterDevice(Object object) {
        DeviceSearchCriteria oSearchCriteria = (DeviceSearchCriteria)object;
        this.initFoundTreePathLst(oSearchCriteria);
        int iSearchStatus = 0;
        if (0 == oSearchCriteria.getResourceType()) {
            iSearchStatus = this.searchFilterDeviceInLst(oSearchCriteria);
        }
        return iSearchStatus;
    }

    private void initFoundTreePathLst(DeviceSearchCriteria searchCriteria) {
        this.m_oAllFoundTreePathLst.clear();
        this.m_oAllFoundDevNodeLst.clear();
        Enumeration<TreeNode> oChildren = this.m_oRootNode.breadthFirstEnumeration();
        DefaultMutableTreeNode oNode = null;
        boolean isDeviceFound = false;
        while (oChildren.hasMoreElements()) {
            TreePath selectionPath;
            DeviceNodeInfo devNodeInfo;
            Object oUserObject;
            oNode = (DefaultMutableTreeNode)oChildren.nextElement();
            if (null == oNode || null == (oUserObject = oNode.getUserObject()) || !(oUserObject instanceof TreeNodeInfo)) continue;
            TreeNodeInfo oTreeNode = (TreeNodeInfo)oUserObject;
            if (4 != oTreeNode.m_iNodeType || !(isDeviceFound = this.compareResource(devNodeInfo = oTreeNode.m_oDevInfo, searchCriteria)) || this.m_oAllFoundTreePathLst.contains(selectionPath = new TreePath(oNode.getPath()))) continue;
            this.m_oAllFoundTreePathLst.add(selectionPath);
            this.m_oAllFoundDevNodeLst.add(devNodeInfo);
        }
    }

    private int searchDeviceInLst(DeviceSearchCriteria oSearchCriteria) {
        if (null == this.m_oAllFoundTreePathLst || this.m_oAllFoundTreePathLst.size() == 0) {
            return 101;
        }
        boolean isDeviceFound = this.isSearchDeviceInLst(oSearchCriteria);
        if (!isDeviceFound) {
            return 101;
        }
        return 100;
    }

    private int searchFilterDeviceInLst(DeviceSearchCriteria oSearchCriteria) {
        boolean isDeviceFound = this.isSearchFileterDeviceInLst(oSearchCriteria);
        if (!isDeviceFound) {
            return 101;
        }
        return 100;
    }

    private boolean isSearchDeviceInLst(DeviceSearchCriteria searchCriteria) {
        boolean isDeviceFound = false;
        TreePath currentSelectedTreePath = this.m_oDeviceTreePanel.getDeviceTree().getSelectionPath();
        int iDirection = searchCriteria.getSearchDirection();
        int currentIndex = this.getCurrentIndex(currentSelectedTreePath, iDirection);
        if (0 == iDirection) {
            if (currentIndex < this.m_oAllFoundTreePathLst.size() - 1) {
                this.markFoundDevice((TreePath)this.m_oAllFoundTreePathLst.get(++currentIndex));
                isDeviceFound = true;
            } else {
                this.markFoundDevice((TreePath)this.m_oAllFoundTreePathLst.get(0));
                isDeviceFound = true;
            }
        } else if (1 == iDirection) {
            if (currentIndex > 0) {
                this.markFoundDevice((TreePath)this.m_oAllFoundTreePathLst.get(--currentIndex));
                isDeviceFound = true;
            } else {
                this.markFoundDevice((TreePath)this.m_oAllFoundTreePathLst.get(this.m_oAllFoundTreePathLst.size() - 1));
                isDeviceFound = true;
            }
        }
        return isDeviceFound;
    }

    private boolean isSearchFileterDeviceInLst(DeviceSearchCriteria searchCriteria) {
        Iterator<DeviceNodeInfo> itor = this.m_oAllFoundDevNodeLst.iterator();
        DeviceInfo[] deviceInfoList = new DeviceInfo[this.m_oAllFoundDevNodeLst.size()];
        ArrayList<DeviceInfo> devLstTmp = new ArrayList<DeviceInfo>();
        if ("".equals(searchCriteria.getSearchString())) {
            DeviceTypeInfo allDevType = new DeviceTypeInfo();
            allDevType.setDevTypeID(-1);
            allDevType.setDevTypeVersionId(-1);
            CreateTaskDeviceSelectionPanel createTaskDeviceSelectionPanel = DCFrameWorkUtil.getCreateTaskDeviceSelectionPanel();
            DeviceSelectionPanel m_oDeviceSelectionPanel = createTaskDeviceSelectionPanel.getDeviceSelectionPanelForFilter();
            DeviceSelectionDropDownPanel m_oDeviceDropDownPanel = m_oDeviceSelectionPanel.getDeviceSelectionDropDownPanel();
            m_oDeviceDropDownPanel.setSelectedDeviceTypeByFilter(allDevType);
            this.initRootNode();
            return true;
        }
        DeviceVersionTreeDescriptor oTreeDescriptor = new DeviceVersionTreeDescriptor(1, ResourceManager.getInstance().getResString("OPERATE_RESULT"));
        oTreeDescriptor.setTreeSelectable(true);
        while (itor.hasNext()) {
            DeviceNodeInfo deviceNodeInfo = itor.next();
            DeviceInfo devInfo = new DeviceInfo();
            devInfo.setDevId(deviceNodeInfo.m_iDeviceID);
            devInfo.setDevIPAddress(deviceNodeInfo.m_strDeviceIP);
            devInfo.setDevName(deviceNodeInfo.m_strDeviceName);
            devInfo.setRoleType(deviceNodeInfo.m_iRoleType);
            devLstTmp.add(devInfo);
        }
        for (int i = 0; i < devLstTmp.size(); ++i) {
            deviceInfoList[i] = (DeviceInfo)devLstTmp.get(i);
        }
        if (deviceInfoList.length == 0) {
            return false;
        }
        this.m_oDeviceTreePanel.updateDeviceTreeByFilter(oTreeDescriptor, true, deviceInfoList, "search result");
        this.initRootNode();
        return true;
    }

    private void markFoundDevice(TreePath treepath) {
        this.m_oDeviceTreePanel.getDeviceTree().setSelectionPath(treepath);
        this.m_oDeviceTreePanel.getDeviceTree().expandPath(treepath);
        this.m_oDeviceTreePanel.getDeviceTree().scrollPathToVisible(treepath);
    }

    private int getCurrentIndex(TreePath currentSelectedTreePath, int iDirection) {
        int currentIndex = -1;
        currentIndex = this.m_oAllFoundTreePathLst.indexOf(currentSelectedTreePath);
        if (-1 == currentIndex) {
            DefaultMutableTreeNode lastNode = (DefaultMutableTreeNode)currentSelectedTreePath.getLastPathComponent();
            for (TreePath treePath : this.m_oAllFoundTreePathLst) {
                int componentCount = treePath.getPathCount();
                for (int i = 0; i < componentCount; ++i) {
                    if (!lastNode.equals(treePath.getPathComponent(i))) continue;
                    currentIndex = this.m_oAllFoundTreePathLst.indexOf(treePath);
                    if (0 == iDirection) {
                        return --currentIndex;
                    }
                    currentIndex = ++currentIndex >= this.m_oAllFoundTreePathLst.size() ? this.m_oAllFoundTreePathLst.size() - 1 : currentIndex;
                    return currentIndex;
                }
            }
        }
        return currentIndex;
    }

    private boolean compareResource(DeviceNodeInfo devNodeInfo, DeviceSearchCriteria oSearchCriteria) {
        boolean isFound = false;
        boolean isWholeWordMatch = oSearchCriteria.isMatchWholeWord();
        boolean isCaseSensitive = oSearchCriteria.isCaseSensitive();
        String strSearchKey = oSearchCriteria.getSearchString();
        String devIP = devNodeInfo.m_strDeviceIP;
        String devName = devNodeInfo.m_strDeviceName;
        isFound = 1 == oSearchCriteria.getSearchMode() ? this.compareIPAddresses(devIP, strSearchKey) : this.compareNames(devName, strSearchKey, isWholeWordMatch, isCaseSensitive);
        return isFound;
    }

    public int findNextDevice(DeviceSearchCriteria oSearchCriteria, boolean bFirstTime) {
        return this.findNextDevice(oSearchCriteria);
    }

    @Override
    public void setToNULL() {
        if (null != this.m_oDeviceTreePanel) {
            this.m_oDeviceTreePanel.disposePanel();
        }
        this.m_oRootNode = null;
        if (null != this.m_oAllFoundTreePathLst) {
            this.m_oAllFoundTreePathLst.clear();
            this.m_oAllFoundTreePathLst = null;
        }
    }
}

