/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceview.devicetable.devicesearch;

import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceview.devicetable.AbstractDeviceTablePanel;
import com.huawei.dc.devicemanagement.deviceview.devicetable.devicesearch.AbstractDeviceSearchManager;
import com.huawei.dc.devicemanagement.deviceview.devicetable.devicesearch.DeviceSearchCriteria;
import com.huawei.dc.devicemanagement.deviceview.devicetable.devicesearch.IColumnInfo;
import com.huawei.dc.devicemanagement.deviceview.devicetable.devicesearch.IDeviceSearchManager;
import com.huawei.dc.devicemanagement.deviceview.devicetable.devicesearch.ISearchManager;
import com.huawei.dc.standalone.model.AbstractDevInfoObj;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class DeviceSearchManager
extends AbstractDeviceSearchManager
implements IDeviceSearchManager {
    private TreeTableNode m_oRoot;
    private JTree m_oTree;
    private ISearchManager m_searchManger;
    private IColumnInfo m_columnInfo;
    private TreeTableNode m_oBeginToSearchNode = null;

    public DeviceSearchManager(ISearchManager searchManager) {
        this.m_searchManger = searchManager;
        this.m_oRoot = this.m_searchManger.getTreeTableModel().getRoot();
        this.m_oTree = this.m_searchManger.getTreeTable().getTree();
        this.m_columnInfo = this.m_searchManger.getColumnInfoForSearch();
    }

    @Override
    public int findNextDevice(Object oSearchObject) {
        int iSearchStatus = 0;
        if (oSearchObject instanceof DeviceSearchCriteria) {
            DeviceSearchCriteria oSearchCriteria = (DeviceSearchCriteria)oSearchObject;
            if (0 == oSearchCriteria.getResourceType()) {
                iSearchStatus = this.searchDeviceInTable(oSearchCriteria);
            } else {
                this.selectAllBoardsInTable();
                iSearchStatus = 101;
            }
        } else {
            int iRowToBeSelected = this.searchForDevicePanel(oSearchObject.toString());
            if (-1 == iRowToBeSelected) {
                iSearchStatus = 101;
            } else {
                this.m_searchManger.makeRowVisible(iRowToBeSelected);
                iSearchStatus = 100;
            }
        }
        return iSearchStatus;
    }

    @Override
    public int filterDevice(Object oSearchCriteria) {
        return 0;
    }

    private TreeTableNode getCurrentSelectedNode(int iDirection) {
        TreePath[] oSelectedTreePaths = this.m_oTree.getSelectionPaths();
        if (null == oSelectedTreePaths || 0 >= oSelectedTreePaths.length) {
            return (TreeTableNode)this.m_oRoot.getChildAt(0);
        }
        int iLastIndex = oSelectedTreePaths.length - 1;
        if (0 == iDirection) {
            return (TreeTableNode)oSelectedTreePaths[0].getLastPathComponent();
        }
        return (TreeTableNode)oSelectedTreePaths[iLastIndex].getLastPathComponent();
    }

    private int searchDeviceInTable(DeviceSearchCriteria oSearchCriteria) {
        if (0 == this.m_oRoot.getChildCount()) {
            return 101;
        }
        int iRowToBeSelected = this.searchForRow(oSearchCriteria);
        if (-1 == iRowToBeSelected) {
            return 101;
        }
        this.m_searchManger.makeRowVisible(iRowToBeSelected);
        return 100;
    }

    private int searchForRow(DeviceSearchCriteria oSearchCriteria) {
        TreeTableNode oNode;
        boolean isWholeWordMatch = oSearchCriteria.isMatchWholeWord();
        boolean isCaseSensitive = oSearchCriteria.isCaseSensitive();
        String strSearchKey = oSearchCriteria.getSearchString();
        int iDirection = oSearchCriteria.getSearchDirection();
        boolean bKeyFound = false;
        int iColumn = this.m_columnInfo.getDevNameColumnIndex();
        if (1 == oSearchCriteria.getSearchMode()) {
            iColumn = this.m_columnInfo.getDevAddressColumnIndex();
        }
        this.m_oBeginToSearchNode = oNode = this.getFirstNode(iDirection);
        while (null != oNode) {
            String strCellValue = this.getValueAtColumn(oNode, iColumn);
            bKeyFound = 0 == oSearchCriteria.getSearchMode() ? this.compareNames(strCellValue, strSearchKey, isWholeWordMatch, isCaseSensitive) : this.compareIPAddresses(strCellValue, strSearchKey);
            if (bKeyFound) {
                this.selectNode(oNode);
                return this.getNodeIndex(oNode);
            }
            if (!this.m_oBeginToSearchNode.equals(oNode = this.getNextNode(oNode, iDirection))) continue;
            break;
        }
        return -1;
    }

    private int searchForDevicePanel(String strSearchKey) {
        TreeTableNode oNode;
        boolean isWholeWordMatch = false;
        boolean isCaseSensitive = false;
        int iDirection = 0;
        boolean bKeyFound = false;
        this.m_oBeginToSearchNode = oNode = this.getFirstNode(iDirection);
        while (null != oNode) {
            String strCellValue = this.getValueAtColumn(oNode, this.m_columnInfo.getDevNameColumnIndex());
            bKeyFound = this.compareNames(strCellValue, strSearchKey, isWholeWordMatch, isCaseSensitive);
            if (!bKeyFound) {
                strCellValue = this.getValueAtColumn(oNode, this.m_columnInfo.getDevAddressColumnIndex());
                bKeyFound = this.compareIPAddresses(strCellValue, strSearchKey);
            }
            if (!bKeyFound) {
                strCellValue = this.getValueAtColumn(oNode, this.m_columnInfo.getDevTypeColumnIndex());
                bKeyFound = this.compareNames(strCellValue, strSearchKey, isWholeWordMatch, isCaseSensitive);
            }
            if (!bKeyFound) {
                strCellValue = this.getValueAtColumn(oNode, this.m_columnInfo.getDevVersionColumnIndex());
                bKeyFound = this.compareNames(strCellValue, strSearchKey, isWholeWordMatch, isCaseSensitive);
            }
            if (!bKeyFound) {
                strCellValue = this.getValueAtColumn(oNode, this.m_columnInfo.getDevOprStatusColumnIndex());
                bKeyFound = this.compareNames(strCellValue, strSearchKey, isWholeWordMatch, isCaseSensitive);
            }
            if (bKeyFound) {
                this.selectNode(oNode);
                return this.getNodeIndex(oNode);
            }
            if (!this.m_oBeginToSearchNode.equals(oNode = this.getNextNode(oNode, iDirection))) continue;
            break;
        }
        return -1;
    }

    private void selectNode(TreeTableNode oNode) {
        TreePath treePath;
        if (null != oNode.getParent()) {
            treePath = new TreePath(((TreeTableNode)oNode.getParent()).getPath());
            this.m_oTree.expandPath(treePath);
        }
        treePath = new TreePath(oNode.getPath());
        this.m_oTree.setSelectionPath(treePath);
        if (this.m_searchManger instanceof AbstractDeviceTablePanel) {
            ((AbstractDeviceTablePanel)this.m_searchManger).refreshTable();
        }
    }

    private TreeTableNode getFirstNode(int iDirection) {
        TreeTableNode oNode = this.getCurrentSelectedNode(iDirection);
        return this.getNextNode(oNode, iDirection);
    }

    private TreeTableNode getNextNode(TreeTableNode oCurrentNode, int iDirection) {
        if (null == oCurrentNode) {
            return null;
        }
        TreeTableNode oReturnNode = null;
        if (0 == iDirection) {
            oReturnNode = (TreeTableNode)oCurrentNode.getNextNode();
            if (null == oReturnNode) {
                oReturnNode = (TreeTableNode)this.m_oRoot.getChildAt(0);
            }
        } else if (1 == iDirection && null == (oReturnNode = (TreeTableNode)oCurrentNode.getPreviousNode())) {
            oReturnNode = (TreeTableNode)this.m_oRoot.getLastLeaf();
        }
        return oReturnNode;
    }

    private int getNodeIndex(TreeTableNode oNode) {
        TreePath treePath;
        int index;
        int iRowCount = this.m_searchManger.getTreeTable().getModel().getRowCount();
        for (index = 0; !(index >= iRowCount || null != (treePath = this.m_oTree.getPathForRow(index)) && oNode.equals(treePath.getLastPathComponent())); ++index) {
        }
        return index;
    }

    private String getValueAtColumn(TreeTableNode oNode, int iColumn) {
        String strValue = null;
        Object oUserObject = oNode.getUserObject();
        if (oUserObject instanceof DeviceInfo) {
            DeviceInfo oDeviceInfo = (DeviceInfo)oUserObject;
            if (iColumn == this.m_columnInfo.getDevNameColumnIndex()) {
                strValue = oDeviceInfo.getDevName();
            } else if (iColumn == this.m_columnInfo.getDevAddressColumnIndex()) {
                strValue = oDeviceInfo.getDevIPAddress();
            }
        } else if (oUserObject instanceof AbstractDevInfoObj) {
            AbstractDevInfoObj oDeviceInfo = (AbstractDevInfoObj)oUserObject;
            if (iColumn == this.m_columnInfo.getDevNameColumnIndex()) {
                strValue = oDeviceInfo.getDevName();
            } else if (iColumn == this.m_columnInfo.getDevAddressColumnIndex()) {
                strValue = oDeviceInfo.getDevAddress();
            }
        }
        return strValue;
    }

    private void selectAllBoardsInTable() {
    }

    @Override
    public void setToNULL() {
        this.m_oRoot = null;
        this.m_oTree = null;
        this.m_columnInfo = null;
        this.m_oBeginToSearchNode = null;
    }
}

