/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceview.devicetable.devicesearch;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.CommonValidationUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.TextFieldFilter;
import com.huawei.dc.devicemanagement.deviceview.devicetable.devicesearch.DeviceSearchCriteria;
import com.huawei.dc.devicemanagement.deviceview.devicetable.devicesearch.DeviceSearchModel;
import com.huawei.dc.devicemanagement.deviceview.devicetable.devicesearch.DeviceSearchPanel;
import com.huawei.dc.devicemanagement.deviceview.devicetable.devicesearch.IDeviceSearchManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.text.AbstractDocument;

public class DeviceSearchDialog
extends DCModalDialog {
    private static final long serialVersionUID = 1L;
    private Container m_oContentPane;
    private JLabel m_oSearchModesLabel;
    private JLabel m_oSearchTextLabel;
    private TextFieldFilter m_oSearchTextFilter;
    private JComboBox m_oDeviceTypesDropDown;
    private JComboBox m_oSearchModesDropDown;
    private JTextField m_oSearchTextField;
    private JCheckBox m_oMatchWholeWordCheckBox;
    private JCheckBox m_oMatchCaseCheckBox;
    private JRadioButton m_oDirectionUpRadioButton;
    private JRadioButton m_oDirectionDownRadioButton;
    private ButtonGroup m_oButtonGroup;
    private JButton m_oFindNextBtn;
    private DefaultComboBoxModel m_oDeviceTypesModel;
    private DefaultComboBoxModel m_oSearchModesModel;
    private IDeviceSearchManager m_oDeviceSearchManager;
    private DeviceSearchPanel m_oSearchPanel;
    private ResourceManager m_oResManager = ResourceManager.getInstance();
    private boolean m_bIsTreeSearch = true;

    public DeviceSearchDialog(DeviceSearchModel oModel, IDeviceSearchManager oSearchManager, Object oPanel, boolean bIsTreeSearch) {
        this.m_bIsTreeSearch = bIsTreeSearch;
        this.initializeDialog();
        this.initializeContentPane();
        this.createLabels();
        this.createFields();
        this.createButtons();
        this.initializeDropdowns(oModel);
        this.initializeKeyEventForEnterBtn();
        this.requestFocusToSearchString();
        this.m_oDeviceSearchManager = oSearchManager;
        if (oPanel instanceof DeviceSearchPanel) {
            this.m_oSearchPanel = (DeviceSearchPanel)oPanel;
        }
    }

    public DeviceSearchDialog(DeviceSearchModel oModel, IDeviceSearchManager oSearchManager, Object oPanel, boolean bIsTreeSearch, DCModalDialog parentDlg) {
        super(parentDlg);
        this.m_bIsTreeSearch = bIsTreeSearch;
        this.initializeDialog();
        this.initializeContentPane();
        this.createLabels();
        this.createFields();
        this.createButtons();
        this.initializeDropdowns(oModel);
        this.initializeKeyEventForEnterBtn();
        this.requestFocusToSearchString();
        this.m_oDeviceSearchManager = oSearchManager;
        if (oPanel instanceof DeviceSearchPanel) {
            this.m_oSearchPanel = (DeviceSearchPanel)oPanel;
        }
    }

    private void setFocusToSearchStringField() {
        this.m_oSearchTextField.requestFocus();
    }

    private void initializeDialog() {
        this.setSize(430, 182);
        this.setTitle(this.m_oResManager.getResString("SEARCH_NE_BUTTON_DLG_TIT"));
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
    }

    private void initializeContentPane() {
        this.m_oContentPane = this.getContentPane();
        this.m_oContentPane.setLayout(null);
    }

    private void createLabels() {
        this.initializeLabels();
        this.addLabelsToPane();
        this.alignLabels();
    }

    private void initializeLabels() {
        this.m_oSearchModesLabel = new JLabel(this.m_oResManager.getResString("SEARCH_DEVICE_MODE_LABEL"));
        this.m_oSearchTextLabel = new JLabel(this.m_oResManager.getResString("SEARCH_DEVICE_SEARCH_TEXT_LABEL"));
    }

    private void alignLabels() {
        this.m_oSearchModesLabel.setBounds(12, 14, 80, 20);
        this.m_oSearchTextLabel.setBounds(12, 48, 80, 20);
    }

    private void addLabelsToPane() {
        this.m_oContentPane.add(this.m_oSearchModesLabel);
        this.m_oContentPane.add(this.m_oSearchTextLabel);
    }

    private void createFields() {
        this.initializeFields();
        this.addFieldsToPane();
        this.alignFields();
    }

    private void initializeFields() {
        this.m_oDeviceTypesDropDown = new JComboBox();
        this.m_oDeviceTypesDropDown.setName("DeviceView_DeviceSearchDialog_m_oDeviceTypesDropDown");
        this.m_oSearchModesDropDown = new JComboBox();
        this.m_oSearchModesDropDown.setName("DeviceView_DeviceSearchDialog_m_oSearchModesDropDown");
        this.m_oSearchModesDropDown.addItemListener(this.generateItemListenerForMode());
        this.m_oSearchTextField = new JTextField();
        this.m_oSearchTextField.setName("DeviceView_DeviceSearchDialog_m_oSearchTextField");
        AbstractDocument ao = (AbstractDocument)this.m_oSearchTextField.getDocument();
        this.m_oSearchTextFilter = new TextFieldFilter(64);
        ao.setDocumentFilter(this.m_oSearchTextFilter);
        this.m_oMatchWholeWordCheckBox = new JCheckBox(this.m_oResManager.getResString("SEARCH_DEVICE_MATCH_WHOLE_WORD_ONLY"));
        this.m_oMatchWholeWordCheckBox.setName("DeviceView_DeviceSearchDialog_m_oMatchWholeWordCheckBox");
        this.m_oMatchWholeWordCheckBox.setFocusable(false);
        this.m_oMatchCaseCheckBox = new JCheckBox(this.m_oResManager.getResString("SEARCH_DEVICE_MATCH_CASE"));
        this.m_oMatchCaseCheckBox.setName("DeviceView_DeviceSearchDialog_m_oMatchCaseCheckBox");
        this.m_oMatchCaseCheckBox.setFocusable(false);
        this.initializeDirectionFields();
    }

    private ItemListener generateItemListenerForMode() {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DeviceSearchDialog.this.searchModeChanged();
            }
        };
    }

    private void searchModeChanged() {
        if (1 == this.m_oSearchModesDropDown.getSelectedIndex()) {
            this.setFieldsForIPSearch();
        } else if (0 == this.m_oSearchModesDropDown.getSelectedIndex()) {
            this.setFieldsForNameSearch();
        }
    }

    private void setFieldsForNameSearch() {
        this.m_oSearchTextField.setText("");
        this.m_oMatchWholeWordCheckBox.setEnabled(true);
        this.m_oMatchCaseCheckBox.setEnabled(true);
        this.m_oSearchTextFilter.setMaxSize(64);
    }

    private void setFieldsForIPSearch() {
        this.m_oMatchWholeWordCheckBox.setSelected(false);
        this.m_oMatchWholeWordCheckBox.setEnabled(false);
        this.m_oMatchCaseCheckBox.setSelected(false);
        this.m_oMatchCaseCheckBox.setEnabled(false);
        this.m_oSearchTextFilter.setMaxSize(15);
    }

    private void addFieldsToPane() {
        this.m_oContentPane.add(this.m_oSearchModesDropDown);
        this.m_oContentPane.add(this.m_oSearchTextField);
        this.m_oContentPane.add(this.m_oMatchWholeWordCheckBox);
        this.m_oContentPane.add(this.m_oMatchCaseCheckBox);
    }

    private void alignFields() {
        this.m_oSearchModesDropDown.setBounds(110, 14, 170, 22);
        this.m_oSearchTextField.setBounds(110, 48, 170, 22);
        this.m_oMatchWholeWordCheckBox.setBounds(30, 88, 160, 20);
        this.m_oMatchWholeWordCheckBox.setMnemonic('M');
        this.m_oMatchCaseCheckBox.setBounds(30, 116, 120, 20);
        this.m_oMatchCaseCheckBox.setMnemonic('C');
    }

    private void initializeDirectionFields() {
        ResourceManager oResManager = ResourceManager.getInstance();
        JPanel oDirectionsPanel = new JPanel();
        this.m_oDirectionUpRadioButton = new JRadioButton(oResManager.getResString("SEARCH_DEVICE_DIRECTION_UP"));
        this.m_oDirectionUpRadioButton.setName("DeviceView_DeviceSearchDialog_m_oDirectionUpRadioButton");
        this.m_oDirectionUpRadioButton.setFocusable(false);
        this.m_oDirectionDownRadioButton = new JRadioButton(oResManager.getResString("SEARCH_DEVICE_DIRECTION_DOWN"));
        this.m_oDirectionDownRadioButton.setName("DeviceView_DeviceSearchDialog_m_oDirectionDownRadioButton");
        this.m_oDirectionDownRadioButton.setFocusable(false);
        this.addFieldsToDirectionPanel(oDirectionsPanel);
        this.m_oButtonGroup = new ButtonGroup();
        this.m_oButtonGroup.add(this.m_oDirectionUpRadioButton);
        this.m_oButtonGroup.add(this.m_oDirectionDownRadioButton);
        this.m_oDirectionDownRadioButton.setSelected(true);
        TitledBorder oTitledBorder = new TitledBorder(BorderFactory.createEtchedBorder(), oResManager.getResString("SEARCH_DEVICE_DIRECTION_LABEL"));
        oDirectionsPanel.setBorder(oTitledBorder);
    }

    private void addFieldsToDirectionPanel(JPanel oDirectionsPanel) {
        oDirectionsPanel.setLayout(null);
        oDirectionsPanel.add(this.m_oDirectionUpRadioButton);
        oDirectionsPanel.add(this.m_oDirectionDownRadioButton);
        this.m_oDirectionUpRadioButton.setBounds(12, 18, 80, 20);
        this.m_oDirectionUpRadioButton.setMnemonic('u');
        this.m_oDirectionDownRadioButton.setBounds(90, 18, 80, 20);
        this.m_oDirectionDownRadioButton.setMnemonic('d');
        this.m_oContentPane.add(oDirectionsPanel);
        oDirectionsPanel.setBounds(230, 88, 180, 50);
    }

    private void createButtons() {
        this.initializeButtons();
        this.addButtonsToPane();
        this.alignButtons();
    }

    private void initializeButtons() {
        this.m_oFindNextBtn = new JButton(this.m_oResManager.getResString("SEARCH_DEVICE_SEARCH_BUTTON_LABEL"));
        if (this.m_bIsTreeSearch) {
            this.m_oFindNextBtn.setMnemonic('F');
        } else {
            this.m_oFindNextBtn.setText(this.m_oResManager.getResString("OK_BTN"));
        }
        this.m_oFindNextBtn.setName("DeviceView_DeviceSearchDialog_m_oFindNextBtn");
        this.m_oCancelBtn.setText(this.m_oResManager.getResString("SEARCH_DEVICE_CANCEL_BUTTON_LABEL"));
        this.m_oCancelBtn.setName("DeviceView_DeviceSearchDialog_m_oCancelBtn");
        this.m_oFindNextBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceSearchDialog.this.performSearch();
            }
        });
    }

    private void addButtonsToPane() {
        this.m_oContentPane.add(this.m_oFindNextBtn);
        this.m_oContentPane.add(this.m_oCancelBtn);
    }

    private void alignButtons() {
        this.m_oFindNextBtn.setBounds(292, 14, 120, 22);
        this.m_oCancelBtn.setBounds(292, 48, 120, 22);
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_VIEW_DEVICE_INFORMATION";
    }

    private void initializeDropdowns(DeviceSearchModel oModel) {
        this.populateDeviceTypesFromModel(oModel);
        this.populateSearchModesFromModel(oModel);
        this.repaint();
    }

    private void populateDeviceTypesFromModel(DeviceSearchModel oModel) {
        Vector oDeviceTypes = oModel.getDeviceTypeList();
        this.m_oDeviceTypesModel = new DefaultComboBoxModel(oDeviceTypes);
        this.m_oDeviceTypesDropDown.setModel(this.m_oDeviceTypesModel);
    }

    private void populateSearchModesFromModel(DeviceSearchModel oModel) {
        Vector oDeviceTypes = oModel.getSearchModeList();
        this.m_oSearchModesModel = new DefaultComboBoxModel(oDeviceTypes);
        this.m_oSearchModesDropDown.setModel(this.m_oSearchModesModel);
    }

    private void performSearch() {
        int iStatus;
        int iStatusCode = this.validateSearchString();
        if (80 != iStatusCode) {
            this.processErrorCode(iStatusCode);
            return;
        }
        DeviceSearchCriteria oSearchCriteria = this.retrieveSearchCriteria();
        if (this.m_bIsTreeSearch && 100 != (iStatus = this.m_oDeviceSearchManager.findNextDevice(oSearchCriteria))) {
            this.processErrorCode(iStatus);
        }
        this.storeSearchCriteria(oSearchCriteria);
        if (!this.m_bIsTreeSearch) {
            this.dispose();
        }
        if (null != this.m_oSearchPanel) {
            this.m_oSearchPanel.getSearchBtn().doClick();
        }
    }

    private void processErrorCode(int errorCode) {
        switch (errorCode) {
            case 83: {
                this.showWarningMessageFor("DEVICE_SEARCH_EMPTY_STRING_ERROR");
                return;
            }
            case 81: {
                this.showWarningMessageFor("DEVICE_IP_ADDRESS_WILD_CHAR_ERROR");
                return;
            }
            case 82: {
                this.showWarningMessageFor("DEVICE_IP_ADDRESS_INVALID_SEGMENT");
                return;
            }
            case 84: {
                this.showWarningMessageFor("DEVICE_NAME_INVALID_WILD_CHAR");
                return;
            }
            case 101: {
                this.showWarningMessageFor("DEVICE_SEARCH_EMPTY_RESULT");
                return;
            }
        }
    }

    protected void showWarningMessageFor(String strErrorMessage) {
        ResourceManager oResManager = ResourceManager.getInstance();
        DCOptionPane.showMessageDialog((Component)((Object)this), oResManager.getResString(strErrorMessage), oResManager.getResString("WARNING"), 2);
    }

    private DeviceSearchCriteria retrieveSearchCriteria() {
        DeviceSearchCriteria oSearchCriteria = new DeviceSearchCriteria();
        oSearchCriteria.setResourceType(this.m_oDeviceTypesDropDown.getSelectedIndex());
        int iSearchMode = this.m_oSearchModesDropDown.getSelectedIndex();
        oSearchCriteria.setSearchMode(iSearchMode);
        oSearchCriteria.setSearchString(this.m_oSearchTextField.getText());
        this.retrieveFieldsForSearchMode(oSearchCriteria, iSearchMode);
        int iDirection = 0;
        if (this.m_oDirectionUpRadioButton.isSelected()) {
            iDirection = 1;
        }
        oSearchCriteria.setSearchDirection(iDirection);
        return oSearchCriteria;
    }

    private void retrieveFieldsForSearchMode(DeviceSearchCriteria oSearchCriteria, int iSearchMode) {
        if (0 == iSearchMode) {
            oSearchCriteria.setMatchWholeWord(this.m_oMatchWholeWordCheckBox.isSelected());
            oSearchCriteria.setCaseSensitive(this.m_oMatchCaseCheckBox.isSelected());
        }
    }

    public int validateSearchString() {
        String strSearchString = this.m_oSearchTextField.getText();
        if (null == strSearchString || 0 == strSearchString.length()) {
            return 83;
        }
        if (0 == this.m_oSearchModesDropDown.getSelectedIndex()) {
            return this.isValidNameSearchString(strSearchString);
        }
        if (1 == this.m_oSearchModesDropDown.getSelectedIndex()) {
            return this.isValidIPSearchString(strSearchString);
        }
        return 80;
    }

    private int isValidNameSearchString(String strSearchName) {
        String strInnerString;
        if (strSearchName.startsWith("*") ? -1 != (strInnerString = strSearchName.substring(1, strSearchName.length())).indexOf("*") : (strSearchName.endsWith("*") ? -1 != (strInnerString = strSearchName.substring(0, strSearchName.length() - 1)).indexOf("*") : -1 != strSearchName.indexOf("*"))) {
            return 84;
        }
        return 80;
    }

    private int isValidIPSearchString(String strSearchIP) {
        int iIPSegmentCount = 4;
        StringTokenizer oIPTokens = new StringTokenizer(strSearchIP, ".");
        if (4 != oIPTokens.countTokens() || strSearchIP.endsWith(".")) {
            return 81;
        }
        String strIPSegment = null;
        boolean bAtleastOneValidSegment = false;
        for (int i = 0; i < 4; ++i) {
            strIPSegment = oIPTokens.nextToken();
            if ("*".equals(strIPSegment)) continue;
            if (!CommonValidationUtil.isValidIPSegment(strIPSegment)) {
                return 82;
            }
            bAtleastOneValidSegment = true;
        }
        if (!bAtleastOneValidSegment) {
            return 81;
        }
        return 80;
    }

    private void storeSearchCriteria(DeviceSearchCriteria oSearchCriteria) {
        if (null == this.m_oSearchPanel) {
            return;
        }
        this.m_oSearchPanel.updateSearchHistoryModel(oSearchCriteria);
    }

    private void initializeKeyEventForEnterBtn() {
        ActionListener EnterKeyHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeviceSearchDialog.this.m_oFindNextBtn.doClick();
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        this.rootPane.registerKeyboardAction(EnterKeyHandler, keyStroke, 2);
    }

    private void requestFocusToSearchString() {
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
                DeviceSearchDialog.this.setFocusToSearchStringField();
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent e) {
                DeviceSearchDialog.this.setFocusToSearchStringField();
            }
        });
    }

    public void updateSearchFiled(Object schConObj) {
        if (schConObj instanceof String) {
            this.m_oSearchModesDropDown.setSelectedItem(this.m_oResManager.getResString("SEARCH_DEVICE_MODE_NAME_OPTION"));
            this.m_oSearchTextField.setText((String)schConObj);
        } else if (schConObj instanceof DeviceSearchCriteria) {
            DeviceSearchCriteria oSearchCriteria = (DeviceSearchCriteria)schConObj;
            this.m_oSearchModesDropDown.setSelectedItem(oSearchCriteria.getSearchModeStr());
            this.m_oSearchTextField.setText(oSearchCriteria.getSearchString());
            if (0 == oSearchCriteria.getSearchDirection()) {
                this.m_oDirectionDownRadioButton.setSelected(true);
                this.m_oDirectionUpRadioButton.setSelected(false);
            } else {
                this.m_oDirectionDownRadioButton.setSelected(false);
                this.m_oDirectionUpRadioButton.setSelected(true);
            }
            if (oSearchCriteria.isCaseSensitive()) {
                this.m_oMatchCaseCheckBox.setSelected(true);
            }
            if (oSearchCriteria.isMatchWholeWord()) {
                this.m_oMatchWholeWordCheckBox.setSelected(true);
            }
        } else {
            DCDebugTracer.trace("updateSearchFiled " + schConObj);
        }
    }
}

