/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceview.devicetable.devicesearch;

import com.huawei.dc.common.framework.utility.ResourceManager;
import java.text.Collator;

public class DeviceSearchCriteria {
    private int m_iResourceType;
    private int m_iSearchMode;
    private String m_oSearchString;
    private boolean m_bMatchWholeWord;
    private boolean m_bCaseSensitive;
    private int m_iDirection;

    public int getResourceType() {
        return this.m_iResourceType;
    }

    public void setResourceType(int deviceType) {
        this.m_iResourceType = deviceType;
    }

    public int getSearchMode() {
        return this.m_iSearchMode;
    }

    public void setSearchMode(int searchMode) {
        this.m_iSearchMode = searchMode;
    }

    public String getSearchString() {
        return this.m_oSearchString;
    }

    public void setSearchString(String searchString) {
        this.m_oSearchString = searchString;
    }

    public boolean isMatchWholeWord() {
        return this.m_bMatchWholeWord;
    }

    public void setMatchWholeWord(boolean matchWholeWord) {
        this.m_bMatchWholeWord = matchWholeWord;
    }

    public boolean isCaseSensitive() {
        return this.m_bCaseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.m_bCaseSensitive = caseSensitive;
    }

    public int getSearchDirection() {
        return this.m_iDirection;
    }

    public void setSearchDirection(int direction) {
        this.m_iDirection = direction;
    }

    public boolean equals(Object oOtherObject) {
        if (this == oOtherObject) {
            return true;
        }
        if (null == oOtherObject || !(oOtherObject instanceof DeviceSearchCriteria)) {
            return false;
        }
        DeviceSearchCriteria oOtherSearchCriteria = (DeviceSearchCriteria)oOtherObject;
        if (this.m_iResourceType != oOtherSearchCriteria.getResourceType()) {
            return false;
        }
        if (this.m_iSearchMode != oOtherSearchCriteria.getSearchMode()) {
            return false;
        }
        if (null == this.m_oSearchString ? null != oOtherSearchCriteria.getSearchString() : !Collator.getInstance().equals(this.m_oSearchString, oOtherSearchCriteria.getSearchString())) {
            return false;
        }
        if (0 == this.m_iSearchMode) {
            if (this.m_bMatchWholeWord != oOtherSearchCriteria.isMatchWholeWord()) {
                return false;
            }
            if (this.m_bCaseSensitive != oOtherSearchCriteria.isCaseSensitive()) {
                return false;
            }
        }
        return this.m_iDirection == oOtherSearchCriteria.getSearchDirection();
    }

    public int hashCode() {
        int iHashCode = Integer.valueOf(this.m_iResourceType).hashCode() + Integer.valueOf(this.m_iSearchMode).hashCode() + String.valueOf(this.m_bMatchWholeWord).hashCode() + String.valueOf(this.m_bMatchWholeWord).hashCode() + Integer.valueOf(this.m_iDirection).hashCode();
        if (null != this.m_oSearchString) {
            iHashCode += this.m_oSearchString.hashCode();
        }
        return iHashCode;
    }

    public String toString() {
        StringBuffer strSearchCriteria = new StringBuffer(10);
        ResourceManager oResManager = ResourceManager.getInstance();
        String cSeperator = "; ";
        char cEquals = '=';
        strSearchCriteria.append(oResManager.getResString("SEARCH_CRITERIA_MODE"));
        strSearchCriteria.append(cEquals);
        strSearchCriteria.append(this.getSearchModeForDisplay(this.m_iSearchMode));
        strSearchCriteria.append(cSeperator);
        if (null != this.m_oSearchString) {
            strSearchCriteria.append(oResManager.getResString("SEARCH_CRITERIA_SEARCH_STRING"));
            strSearchCriteria.append(cEquals);
            strSearchCriteria.append(this.m_oSearchString);
            strSearchCriteria.append(cSeperator);
        }
        if (0 == this.m_iSearchMode) {
            if (this.m_bMatchWholeWord) {
                strSearchCriteria.append(oResManager.getResString("SEARCH_CRITERIA_WHOLE_WORD"));
                strSearchCriteria.append(cSeperator);
            }
            if (this.m_bCaseSensitive) {
                strSearchCriteria.append(ResourceManager.getInstance().getResString("SEARCH_CRITERIA_CASE_SENSITIVE"));
                strSearchCriteria.append(cSeperator);
            }
        }
        strSearchCriteria.append(oResManager.getResString("SEARCH_CRITERIA_DIRECTION"));
        strSearchCriteria.append(cEquals);
        strSearchCriteria.append(this.getSearchDirectionForDisplay(this.m_iDirection));
        return strSearchCriteria.toString();
    }

    private String getSearchModeForDisplay(int iMode) {
        String strMode = null;
        if (0 == iMode) {
            strMode = ResourceManager.getInstance().getResString("SEARCH_DEVICE_MODE_NAME_OPTION");
        } else if (1 == iMode) {
            strMode = ResourceManager.getInstance().getResString("SEARCH_DEVICE_MODE_IP_OPTION");
        }
        return strMode;
    }

    public String getSearchModeStr() {
        return this.getSearchModeForDisplay(this.m_iSearchMode);
    }

    private String getSearchDirectionForDisplay(int iDirection) {
        String strDirection = null;
        if (1 == iDirection) {
            strDirection = ResourceManager.getInstance().getResString("SEARCH_DEVICE_DIRECTION_UP_1");
        } else if (0 == iDirection) {
            strDirection = ResourceManager.getInstance().getResString("SEARCH_DEVICE_DIRECTION_DOWN_1");
        }
        return strDirection;
    }
}

