/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceview.devicetable;

import com.huawei.dc.common.components.treetable.model.TreeTableCellData;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.components.treetable.view.JSortTreeTable;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.ConfigurationInfo;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.security.DCEncryptServiceUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DCSaveFileChooser;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.common.util.StIPAddress;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.controller.BusyDeviceObjectStore;
import com.huawei.dc.devicemanagement.deviceview.common.DeviceIDDataObject;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceTablePanel;
import com.huawei.dc.devicemanagement.model.DeviceModelAdapter;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.deviceoperation.util.OperationStatus;
import com.huawei.dc.security.LoginInfo;
import com.huawei.dc.standalone.model.DCRouterDevTreeTableModel;
import com.huawei.dc.standalone.model.RouterDevInfoObj;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTablePanel;
import com.swimap.iview.templates.print.PrintSupportor;
import com.swimap.iview.templates.print.tools.TablePrintable;
import com.swimap.iview.util.format.TimeDateFormatUtil;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeNode;

public class DeviceTableUtil {
    private static Vector m_oSaveDeviceInfoVec = new Vector();
    private static String m_strSpace = "";
    private static int SPACE_COUNT = 0;
    private static String m_strSpaceForHTML = "";
    private static String m_strSpaceForTXT = "";
    private static String m_strSpaceForCSV = "";
    private static String m_strTreeLine = ResourceManager.getInstance().getResString("TREE_LINE");

    public static boolean isDifferentDeviceTypesSelectedInTable(JSortTreeTable oDeviceTable) {
        int[] arrSelectedRows = oDeviceTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return false;
        }
        DeviceInfo oDeviceInfoBenchMark = DeviceTableUtil.getDeviceInfoForTableRow(oDeviceTable, arrSelectedRows[0]);
        if (null == oDeviceInfoBenchMark) {
            return false;
        }
        int iDevTypeIdBenchMark = oDeviceInfoBenchMark.getDeviceTypeInfo().getDevTypeID();
        int iDevTypeVersionIdBenchMark = oDeviceInfoBenchMark.getDeviceTypeInfo().getDevTypeVersionId();
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            DeviceInfo oDeviceInfo = DeviceTableUtil.getDeviceInfoForTableRow(oDeviceTable, arrSelectedRows[i]);
            if (oDeviceInfo == null) continue;
            int iDevTypeId = oDeviceInfo.getDeviceTypeInfo().getDevTypeID();
            int iDevTypeVersionId = oDeviceInfo.getDeviceTypeInfo().getDevTypeVersionId();
            if (iDevTypeVersionIdBenchMark == iDevTypeVersionId && iDevTypeIdBenchMark == iDevTypeId) continue;
            return true;
        }
        return false;
    }

    public static DeviceInfo getDeviceInfoForTableRow(JSortTreeTable oDeviceTable, int iRowIndex) {
        Object valueAt = oDeviceTable.getValueAt(iRowIndex, 0);
        DeviceInfo oDeviceInfo = null;
        if (valueAt instanceof DeviceInfo) {
            oDeviceInfo = (DeviceInfo)valueAt;
        } else {
            IDeviceInfoManager oDeviceInfoManager = DCFrameWorkUtil.getDeviceInfoManager();
            int iDeviceID = DeviceTableUtil.getDeviceIDForTableRow(oDeviceTable, iRowIndex);
            oDeviceInfo = oDeviceInfoManager.getDevice(iDeviceID);
        }
        return oDeviceInfo;
    }

    public static int getDeviceIDForTableRow(JSortTreeTable oDeviceTable, int iRowIndex) {
        int iDevId = -1;
        if (oDeviceTable.getRowCount() <= iRowIndex) {
            return iDevId;
        }
        Object valueAt = oDeviceTable.getValueAt(iRowIndex, 0);
        if (valueAt instanceof TreeTableCellData) {
            TreeTableCellData oCellData = (TreeTableCellData)oDeviceTable.getValueAt(iRowIndex, 0);
            if (null != oCellData) {
                DeviceIDDataObject oDeviceIDDataObject = (DeviceIDDataObject)oCellData.getCellDataValue();
                iDevId = oDeviceIDDataObject.getDeviceID();
            }
        } else if (valueAt instanceof DeviceInfo) {
            DeviceInfo oDeviceInfo = (DeviceInfo)oDeviceTable.getValueAt(iRowIndex, 0);
            iDevId = oDeviceInfo.getDevId();
        }
        return iDevId;
    }

    public static Vector getDeviceInfoFromTable(DeviceInfo[] theDeviceInfo, JSortTreeTable oDeviceTable) {
        if (null == theDeviceInfo) {
            return null;
        }
        int deviceInfoLength = theDeviceInfo.length;
        Vector deviceInfoVec = new Vector();
        TableColumnModel oTableColumnModel = oDeviceTable.getColumnModel();
        for (int i = 0; i < deviceInfoLength; ++i) {
            Vector<String> deviceVec = new Vector<String>();
            StIPAddress oStIPAddres = new StIPAddress();
            int iLength = oTableColumnModel.getColumnCount();
            block9: for (int index = 0; index < iLength; ++index) {
                switch (oTableColumnModel.getColumn(index).getModelIndex()) {
                    case 1: {
                        deviceVec.add(theDeviceInfo[i].getDevName().trim());
                        oStIPAddres.m_strIPAddress = theDeviceInfo[i].getDevIPAddress().trim();
                        continue block9;
                    }
                    case 2: {
                        deviceVec.add(oStIPAddres.toString());
                        continue block9;
                    }
                    case 3: {
                        if (null == theDeviceInfo[i].getDeviceTypeInfo()) continue block9;
                        String strDevTypeInfo = theDeviceInfo[i].getDeviceTypeInfo().toString();
                        if (!StringUtils.isNullOrEmptyStr(theDeviceInfo[i].getDevBoardType())) {
                            strDevTypeInfo = strDevTypeInfo + "-";
                            strDevTypeInfo = strDevTypeInfo + theDeviceInfo[i].getDevBoardType();
                        }
                        deviceVec.add(strDevTypeInfo);
                        continue block9;
                    }
                    case 4: {
                        deviceVec.add(theDeviceInfo[i].getDevVersion().getDevVersion().trim());
                        continue block9;
                    }
                    case 5: {
                        deviceVec.add(theDeviceInfo[i].getDevVersion().getPatchVersion().trim());
                        continue block9;
                    }
                    case 6: {
                        OperationStatus oStatus = BusyDeviceObjectStore.getInstance().getDeviceProgress(theDeviceInfo[i].getDevId());
                        if (null == oStatus) {
                            oStatus = theDeviceInfo[i].getDeviceOperationStatus();
                        }
                        deviceVec.add(oStatus.getToolTipText());
                        continue block9;
                    }
                }
            }
            deviceInfoVec.add(deviceVec);
            deviceVec = null;
        }
        return deviceInfoVec;
    }

    public static void saveButtonActionPerformed(JSortTreeTable oDeviceTable) {
        if (null == oDeviceTable) {
            return;
        }
        ResourceManager oResourceManager = ResourceManager.getInstance();
        int iTotalRows = oDeviceTable.getRowCount();
        if (iTotalRows <= 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), oResourceManager.getResString("DEVICE_INFORMATION_EMPTY"), oResourceManager.getResString("ERROR_MESSAGE"), 0);
            return;
        }
        String strPath = ConfigurationInfo.getInstance().getAbsoluteBaseDirectory() + File.separator + "report/";
        File fileDoc = new File(strPath);
        if (!fileDoc.exists()) {
            try {
                fileDoc.mkdir();
            }
            catch (Exception ex) {
                DCDebugTracer.trace(ex);
                return;
            }
        }
        DCSaveFileChooser oFileChooserDlg = null;
        oFileChooserDlg = new DCSaveFileChooser(strPath, false);
        oFileChooserDlg.setFileFilter(7);
        oFileChooserDlg.setAcceptAllFileFilterUsed(false);
        oFileChooserDlg.setEncodingEnabled(true);
        String strFileName = ResourceManager.getInstance().getResString("DEVICEINFOPAN_DEFAULT_FILE") + StringUtils.getStrNowTime("yyyyMMddHHmmss");
        strFileName = FileUtil.getFileName(strFileName);
        oFileChooserDlg.setSelectedFile(new File(strFileName));
        int iReturnVal = -1;
        iReturnVal = oFileChooserDlg.showSaveDialog(DCFrameWorkUtil.getMainFrame());
        if (iReturnVal == 0) {
            strFileName = oFileChooserDlg.getFullFileName();
            String userEncoding = (String)DCSaveFileChooser.ENCODING_KEY_VALUE_MAP.get(oFileChooserDlg.getUserEncoding());
            if (null == userEncoding || userEncoding.length() == 0) {
                userEncoding = FileUtil.getSystemEncoding();
            }
            if (strFileName.endsWith(".html") || strFileName.endsWith(".htm") || strFileName.endsWith(".txt") || strFileName.endsWith(".csv") || strFileName.endsWith(".HTML") || strFileName.endsWith(".HTM") || strFileName.endsWith(".TXT") || strFileName.endsWith(".CSV")) {
                DeviceTableUtil.saveDeviceInformation(oDeviceTable, strFileName, userEncoding);
            } else {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SAVE_FILE_TYPE_NOT_SUPP"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
            }
        }
    }

    private static String[] getArrHeaderFields(JSortTreeTable oDeviceTable, boolean isReadFirstColumn) {
        int columnCount = oDeviceTable.getColumnCount();
        int iOffset = 0;
        if (!isReadFirstColumn) {
            iOffset = 1;
        }
        String[] arrHeaderFields = new String[columnCount - iOffset];
        for (int i = 0; i < columnCount - iOffset; ++i) {
            arrHeaderFields[i] = oDeviceTable.getColumnName(i + iOffset);
        }
        return arrHeaderFields;
    }

    private static void saveDeviceInformation(JSortTreeTable oDeviceTable, final String strFileName, final String strEncoding) {
        if (null == oDeviceTable) {
            return;
        }
        m_strSpace = strFileName.endsWith(".html") || strFileName.endsWith(".htm") || strFileName.endsWith(".HTML") || strFileName.endsWith(".HTM") ? m_strSpaceForHTML : (strFileName.endsWith(".csv") || strFileName.endsWith(".CSV") ? m_strSpaceForCSV : m_strSpaceForTXT);
        boolean isReadFirstColumn = false;
        if (oDeviceTable.getTree().getModel() instanceof DCRouterDevTreeTableModel) {
            isReadFirstColumn = true;
            m_oSaveDeviceInfoVec = DeviceTableUtil.getRouterDevInfoFromTable((DCRouterDevTreeTableModel)((Object)oDeviceTable.getTree().getModel()));
        } else {
            int[] iSelectedRows = oDeviceTable.getSelectedRows();
            DeviceInfo[] deviceInfoList = new DeviceInfo[iSelectedRows.length];
            int iSelectedIndex = 0;
            for (int i = 0; i < iSelectedRows.length; ++i) {
                iSelectedIndex = iSelectedRows[i];
                deviceInfoList[i] = DeviceTableUtil.getDeviceInfoForTableRow(oDeviceTable, iSelectedIndex);
            }
            m_oSaveDeviceInfoVec = DeviceTableUtil.getDeviceInfoFromTable(deviceInfoList, oDeviceTable);
        }
        final String[] arrHeaderFields = DeviceTableUtil.getArrHeaderFields(oDeviceTable, isReadFirstColumn);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TablePrintable printable = null;
                String strHeader = ResourceManager.getInstance().getResString("DEVICE_DETAILS");
                String strUserName = "";
                if (!DCFrameWorkUtil.getIsSingleClient()) {
                    LoginInfo loginInfo = DCFrameWorkUtil.getSecurityManager().getLoginInfo();
                    strUserName = loginInfo.getUserName();
                } else {
                    strUserName = null != DCFrameWorkUtil.getSecurityManager() && null != DCFrameWorkUtil.getSecurityManager().getLoginInfo() && null != DCFrameWorkUtil.getSecurityManager().getLoginInfo().getUserName() ? DCFrameWorkUtil.getSecurityManager().getLoginInfo().getUserName() : "admin";
                }
                String strFileType = null;
                strFileType = strFileName.endsWith(".html") || strFileName.endsWith(".htm") || strFileName.endsWith(".HTML") || strFileName.endsWith(".HTM") ? "html" : (strFileName.endsWith(".csv") || strFileName.endsWith(".CSV") ? "csv" : "txt");
                try {
                    printable = new TablePrintable(strHeader, strUserName, "", arrHeaderFields, (Collection)m_oSaveDeviceInfoVec, m_oSaveDeviceInfoVec.size(), true);
                }
                catch (Exception ex) {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SAVE_VECTOR_FAILED"), ResourceManager.getInstance().getResString("INFO"), 1);
                    return;
                }
                boolean bSaveSuccess = PrintSupportor.saveToFileNoCheck((JFrame)DCFrameWorkUtil.getMainFrame(), (String)strFileName, (TablePrintable)printable, (String)strFileType, (String)strEncoding);
                if (!bSaveSuccess) {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SAVE_FAILURE"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
                } else {
                    DCDebugTracer.trace("save NE list success!");
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SAVE_SUCCESS"), ResourceManager.getInstance().getResString("INFO"), 1);
                }
            }
        });
    }

    public static void printDeviceInformation(JSortTreeTable oDeviceTable) {
        if (null == oDeviceTable) {
            return;
        }
        final ResourceManager oResourceManager = ResourceManager.getInstance();
        int iTotalRows = oDeviceTable.getRowCount();
        if (iTotalRows <= 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("DEVICE_INFORMATION_EMPTY"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
            return;
        }
        int[] iSelectRows = oDeviceTable.getSelectedRows();
        DeviceInfo[] deviceIDList = new DeviceInfo[iSelectRows.length];
        int iSelectedRowIndex = 0;
        for (int i = 0; i < iSelectRows.length; ++i) {
            iSelectedRowIndex = iSelectRows[i];
            deviceIDList[i] = DeviceTableUtil.getDeviceInfoForTableRow(oDeviceTable, iSelectedRowIndex);
        }
        final Vector printDeviceInfoVec = DeviceTableUtil.getDeviceInfoFromTable(deviceIDList, oDeviceTable);
        final String[] arrHeaderFields = DeviceTableUtil.getArrHeaderFields(oDeviceTable, false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TablePrintable printable = null;
                String strHeader = oResourceManager.getResString("DEVICE_DETAILS");
                String strUserName = DCFrameWorkUtil.getUserName();
                try {
                    printable = new TablePrintable(strHeader, strUserName, " ", arrHeaderFields, (Collection)printDeviceInfoVec, printDeviceInfoVec.size(), false);
                }
                catch (Exception ex) {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("PRINT_VECTOR_FAILED"), ResourceManager.getInstance().getResString("INFO"), 1);
                    return;
                }
                PrintSupportor.print((JFrame)DCFrameWorkUtil.getMainFrame(), (TablePrintable)printable, (int)printable.getPageCount());
            }
        });
    }

    public static void previewDeviceInformation(JSortTreeTable oDeviceTable) {
        if (null == oDeviceTable) {
            return;
        }
        TableModel oTableModel = oDeviceTable.getModel();
        int iTotalRows = oDeviceTable.getRowCount();
        if (iTotalRows <= 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("DEVICE_INFORMATION_EMPTY"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
            return;
        }
        DeviceInfo[] deviceInfoList = new DeviceInfo[oTableModel.getRowCount()];
        for (int i = 0; i < oTableModel.getRowCount(); ++i) {
            deviceInfoList[i] = DeviceTableUtil.getDeviceInfoForTableRow(oDeviceTable, i);
        }
        Vector previewDeviceInfoVec = DeviceTableUtil.getDeviceInfoFromTable(deviceInfoList, oDeviceTable);
        TablePrintable printable = null;
        String strHeader = ResourceManager.getInstance().getResString("DEVICE_DETAILS");
        String strUserName = DCFrameWorkUtil.getUserName();
        String[] arrHeaderFields = DeviceTableUtil.getArrHeaderFields(oDeviceTable, false);
        try {
            printable = new TablePrintable(strHeader, strUserName, " ", arrHeaderFields, (Collection)previewDeviceInfoVec, previewDeviceInfoVec.size(), false);
        }
        catch (Exception ex) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("PREVIEW_VECTOR_FAILED"), ResourceManager.getInstance().getResString("INFO"), 1);
            return;
        }
        PrintSupportor.preview((JFrame)DCFrameWorkUtil.getMainFrame(), (TablePrintable)printable, (int)printable.getPageCount());
    }

    public static Object getValueForColIndex(DeviceInfo oDeviceInfo, int iColumnIndex) {
        if (null == oDeviceInfo) {
            return "";
        }
        switch (iColumnIndex) {
            case 1: {
                return oDeviceInfo.getDevName();
            }
            case 2: {
                return oDeviceInfo.getDevIpAddressInfo().getDevIp();
            }
            case 3: {
                return oDeviceInfo.getDeviceTypeInfo().toString();
            }
            case 4: {
                String strDeviceVersion = "";
                if (null != oDeviceInfo.getDevVersion()) {
                    strDeviceVersion = oDeviceInfo.getDevVersion().getDevVersion();
                }
                return strDeviceVersion;
            }
            case 0: {
                return new DeviceIDDataObject(oDeviceInfo.getDevId());
            }
            case 6: {
                OperationStatus oStatus = BusyDeviceObjectStore.getInstance().getDeviceProgress(oDeviceInfo.getDevId());
                if (null != oStatus) break;
                OperationStatus operationStatus = oDeviceInfo.getDeviceOperationStatus();
            }
        }
        return "";
    }

    public static boolean isDevDomain(JSortTreeTable oTable, int iDeviceDomain) {
        int[] arrSelectedRow = oTable.getSelectedRows();
        if (null == arrSelectedRow || 0 == arrSelectedRow.length) {
            return false;
        }
        int iSize = arrSelectedRow.length;
        int iDevDomain = -1;
        for (int index = 0; index < iSize; ++index) {
            DeviceTypeInfo oDeviceTypeInfo;
            DeviceInfo oDeviceInfoBenchMark = DeviceTableUtil.getDeviceInfoForTableRow(oTable, arrSelectedRow[index]);
            if (oDeviceInfoBenchMark == null || iDeviceDomain == (iDevDomain = (oDeviceTypeInfo = oDeviceInfoBenchMark.getDeviceTypeInfo()).getDevDomain()) || DeviceTableUtil.isDMSandBMSDevDomain(iDeviceDomain, iDevDomain)) continue;
            return false;
        }
        return true;
    }

    private static boolean isDMSandBMSDevDomain(int iDeviceDomain, int iDevDomain) {
        if (1 == iDeviceDomain && 2 == iDevDomain) {
            return true;
        }
        return 2 == iDeviceDomain && 1 == iDevDomain;
    }

    public static boolean isMultipleDevDomain(JSortTreeTable oTable, Vector<Integer> oDomainList) {
        boolean bState = true;
        int[] arrSelectedRow = oTable.getSelectedRows();
        if (null == arrSelectedRow || 0 == arrSelectedRow.length) {
            return false;
        }
        int iSize = arrSelectedRow.length;
        int iDevDomain = -1;
        for (int index = 0; index < iSize; ++index) {
            DeviceTypeInfo oDeviceTypeInfo;
            DeviceInfo oDeviceInfoBenchMark = DeviceTableUtil.getDeviceInfoForTableRow(oTable, arrSelectedRow[index]);
            if (oDeviceInfoBenchMark == null || oDomainList.contains(iDevDomain = (oDeviceTypeInfo = oDeviceInfoBenchMark.getDeviceTypeInfo()).getDevDomain())) continue;
            bState = false;
            break;
        }
        return bState;
    }

    public static DeviceType createDeviceTypeModel(THashSet<Resource> oResHs) {
        if (null == oResHs || 0 == oResHs.size()) {
            return null;
        }
        Iterator oResItor = oResHs.iterator();
        Resource oRes = null;
        DeviceType oDeviceType = null;
        if (oResItor.hasNext()) {
            oRes = (Resource)oResItor.next();
            oDeviceType = DeviceModelAdapter.populateDeviceTypeFromDeviceID(oRes.getDeviceID());
        }
        if (null != oDeviceType) {
            oDeviceType.setResources(oResHs);
        }
        return oDeviceType;
    }

    public static List<DeviceType> getDeviceTypeList(THashSet<Resource> oResources) {
        if (null == oResources || 0 == oResources.size()) {
            return null;
        }
        ArrayList<DeviceType> oList = new ArrayList<DeviceType>();
        DeviceType oDeviceType = null;
        Iterator oResItor = oResources.iterator();
        Resource oRes = null;
        while (oResItor.hasNext()) {
            oRes = (Resource)oResItor.next();
            oDeviceType = DeviceModelAdapter.populateDeviceTypeFromDeviceID(oRes.getDeviceID());
            if (null != oDeviceType) {
                oDeviceType.addResource(oRes);
            }
            if (oList.contains(oDeviceType)) continue;
            oList.add(oDeviceType);
        }
        return oList;
    }

    public static List<DeviceType> getDeviceTypeList(List<Resource> oResources) {
        ArrayList<DeviceType> oList = new ArrayList<DeviceType>();
        if (null == oResources || 0 == oResources.size()) {
            return null;
        }
        DeviceType oDeviceType = null;
        for (int i = 0; i < oResources.size(); ++i) {
            oDeviceType = DeviceModelAdapter.populateDeviceTypeFromDeviceID(oResources.get(i).getDeviceID());
            if (null != oDeviceType) {
                oDeviceType.addResource(oResources.get(i));
            }
            if (oList.contains(oDeviceType)) continue;
            oList.add(oDeviceType);
        }
        return oList;
    }

    public static ImageIcon getIconForRoleType(int iRoleType) {
        String strIconName = null;
        switch (iRoleType) {
            case 1: {
                strIconName = "reboottask.gif";
                break;
            }
            case 2: {
                strIconName = "ic_frame.gif";
                break;
            }
            default: {
                strIconName = "ic_device.gif";
            }
        }
        return ResourceManager.getInstance().getImage(strIconName);
    }

    private static Vector getRouterDevInfoFromTable(DCRouterDevTreeTableModel oRouterDevTableModel) {
        Vector routerDevInfoVec = new Vector();
        DeviceTableUtil.getRouterDevInfo(oRouterDevTableModel.getRoot(), "", routerDevInfoVec);
        return routerDevInfoVec;
    }

    private static void getRouterDevInfo(TreeNode oNode, String strPrefixForDevName, Vector devInfoVec) {
        TreeTableNode tmpNode = (TreeTableNode)oNode;
        RouterDevInfoObj devInfoObj = (RouterDevInfoObj)tmpNode.getUserObject();
        Vector<Object> deviceVec = new Vector<Object>();
        if (null != devInfoObj) {
            deviceVec.add(strPrefixForDevName + devInfoObj.getDevName());
            deviceVec.add(devInfoObj.getDevAddress());
            deviceVec.add(devInfoObj.getDevType());
            deviceVec.add(devInfoObj.getVersion());
            deviceVec.add(devInfoObj.getPatchVersion());
            deviceVec.add(devInfoObj.getProxyType());
            deviceVec.add(devInfoObj.getProxyNodeType());
            deviceVec.add(devInfoObj.getProtocolType());
            deviceVec.add(devInfoObj.getPort());
            deviceVec.add(devInfoObj.getUserName());
            deviceVec.add(DCEncryptServiceUtil.encrypt(devInfoObj.getPassword()));
            deviceVec.add(DCEncryptServiceUtil.encrypt(devInfoObj.getSuper3Pass()));
            deviceVec.add(devInfoObj.getVPNName());
            deviceVec.add(devInfoObj.getOperationStatus().getToolTipText());
            devInfoVec.add(deviceVec);
            strPrefixForDevName = "".equals(strPrefixForDevName) ? ("".equals(m_strTreeLine) ? m_strSpace : m_strTreeLine) : m_strSpace + strPrefixForDevName;
        } else {
            strPrefixForDevName = "";
        }
        int iChildCount = oNode.getChildCount();
        for (int i = 0; i < iChildCount; ++i) {
            DeviceTableUtil.getRouterDevInfo(oNode.getChildAt(i), strPrefixForDevName, devInfoVec);
        }
    }

    public static boolean isConstainUnsupportNEs(JSortTreeTable oDeviceTable) {
        int[] arrSelectedRows = oDeviceTable.getSelectedRows();
        TIntArrayList oUnsurpportOprNETYpeIDs = DeviceInfoUtil.getIDLst("NOT_SUPPORT_OPERATION_NE_TYPE");
        boolean isContainMetro3000Dev = false;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            DeviceTypeInfo oDevTypeInfo;
            DeviceInfo oDevice = DeviceTableUtil.getDeviceInfoForTableRow(oDeviceTable, arrSelectedRows[i]);
            if (null == oDevice || null == (oDevTypeInfo = oDevice.getDeviceTypeInfo()) || !oUnsurpportOprNETYpeIDs.contains(oDevTypeInfo.getDevTypeID())) continue;
            isContainMetro3000Dev = true;
            break;
        }
        return isContainMetro3000Dev;
    }

    public static List<Integer> getBmsDevID(JSortTreeTable oDeviceTable) {
        ArrayList<Integer> iDevIDLst = new ArrayList<Integer>();
        int[] arrSelectedRows = oDeviceTable.getSelectedRows();
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            DeviceTypeInfo oDevTypeInfo;
            DeviceInfo oDevice = DeviceTableUtil.getDeviceInfoForTableRow(oDeviceTable, arrSelectedRows[i]);
            if (null == oDevice || null == (oDevTypeInfo = oDevice.getDeviceTypeInfo()) || oDevTypeInfo.getDevDomain() != 1) continue;
            iDevIDLst.add(oDevice.getDevId());
        }
        return iDevIDLst;
    }

    public static String getCurDateTimeStr() {
        return TimeDateFormatUtil.getFormatDateTime((Calendar)Calendar.getInstance());
    }

    public static int convertColumnIndexToModel(int iColumn) {
        return DCFrameWorkUtil.getDeviceTablePanel().getDeviceTreeTable().getColumnModel().getColumn(iColumn).getModelIndex();
    }

    public static int convertModelColumnIndexToCurIndex(String[] m_arrHeaderFields, int iColumn) {
        String strModelColHeader = m_arrHeaderFields[iColumn];
        TableColumnModel oTableColumnModel = null;
        if (null != DCFrameWorkUtil.getDCModuleManager() && DCFrameWorkUtil.getDCModuleManager().getDeviceOperationPanel().isActivated()) {
            DeviceTablePanel oDeviceTablePanel = DCFrameWorkUtil.getDeviceTablePanel();
            oTableColumnModel = oDeviceTablePanel.getDeviceTreeTable().getColumnModel();
        } else {
            TaskTablePanel oTaskTablePanel = DCFrameWorkUtil.getTaskTablePanel();
            oTableColumnModel = oTaskTablePanel.getTaskTreeTable().getColumnModel();
        }
        int iLength = oTableColumnModel.getColumnCount();
        for (int i = 0; i < iLength; ++i) {
            if (!oTableColumnModel.getColumn(i).getHeaderValue().toString().equals(strModelColHeader)) continue;
            iColumn = i;
            break;
        }
        return iColumn;
    }

    public static boolean isOneTranNEInRecover(DCSortableTreeTable oDeviceTable) {
        int[] arrSelectedRows = oDeviceTable.getSelectedRows();
        ArrayList<String> oList = new ArrayList<String>();
        String strDevIP = null;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            DeviceInfo oDevice = DeviceTableUtil.getDeviceInfoForTableRow(oDeviceTable, arrSelectedRows[i]);
            if (null == oDevice) continue;
            strDevIP = oDevice.getDevIPAddress();
            DeviceTypeInfo oDevTypeInfo = oDevice.getDeviceTypeInfo();
            if (null == oDevTypeInfo || oDevTypeInfo.getDevDomain() != 4) continue;
            if (oList.contains(strDevIP)) {
                return false;
            }
            oList.add(strDevIP);
        }
        return true;
    }

    static {
        try {
            SPACE_COUNT = Integer.parseInt(ResourceManager.getInstance().getResString("SPACE_COUNT"));
        }
        catch (Exception e) {
            SPACE_COUNT = 4;
        }
        for (int i = 0; i < SPACE_COUNT; ++i) {
            m_strSpaceForHTML = m_strSpaceForHTML + "&nbsp;";
            m_strSpaceForTXT = m_strSpaceForTXT + " ";
            m_strSpaceForCSV = m_strSpaceForCSV + " ";
        }
        if (m_strTreeLine.equals("TREE_LINE")) {
            m_strTreeLine = "";
        }
    }
}

