/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceview.devicetable;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.GatewayConstants;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceLastOperationStatusEnum;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceLst;
import com.huawei.dc.common.asndatacenter.AsnDCExportDeviceReq;
import com.huawei.dc.common.asndatacenter.AsnRoleTypeEnum;
import com.huawei.dc.common.asndatacenter.DCStringList;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.framework.utility.ConfigurationInfo;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.framework.utility.print.PrintSupportor;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCFileChooser;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DCSaveFileChooser;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.controller.BusyDeviceObjectStore;
import com.huawei.dc.devicemanagement.deviceview.devicetable.AbstractDeviceTablePanel;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceTableUtil;
import com.huawei.dc.devicemanagement.model.DeviceModelAdapter;
import com.huawei.dc.standalone.model.T2000DevInfo;
import com.huawei.dc.standalone.snmpparams.model.SnmpParaInfo;
import com.huawei.dc.standalone.view.DeviceProgressDlg;
import com.huawei.dc.taskmgmt.model.Resource;
import com.swimap.iview.util.DebugTracer;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class DeviceTablePanelUtil {
    public static final int DEVICE_ID_COLUMN = 0;
    private static HashMap m_oT2000FileHeaderMap = new HashMap(0);
    private static final int DEVICE_TYPE_ID = 0;
    private static final int VERSION_ID = 1;
    private static final int NE_ID = 2;
    private static final int DEVICE_NAME = 3;
    private static final int PROTOCOL_TYPE = 4;
    private static final int GATEWAY_TYPE = 5;
    private static final int GATEWAY_ADDRESS = 6;
    private static final int PORT = 7;
    private static final int USER_NAME = 8;
    private static final int USER_PASSWORD = 9;
    private static boolean m_bIsMMLProtocol = true;
    private static boolean m_bIsIPGateway = true;
    private static final int COL = 0;
    private static final int ROW = 0;

    private static boolean validateAndSetProtocolType(List<String> oResTokenList, int iProtocolTypeColPosition, T2000DevInfo oDevInfo) {
        String strProtocoType = oResTokenList.get(iProtocolTypeColPosition);
        boolean bResult = DeviceTablePanelUtil.validateAndSetT2000DeviceValue(strProtocoType.trim(), iProtocolTypeColPosition, oDevInfo);
        return bResult;
    }

    private static boolean validateAndSetT2000DeviceValue(String strValue, int iCol, T2000DevInfo oDevInfo) {
        Integer oColInFormat = (Integer)m_oT2000FileHeaderMap.get(iCol);
        int iColInFormat = oColInFormat;
        boolean bResult = false;
        switch (iColInFormat) {
            case 0: {
                bResult = DeviceTablePanelUtil.validateForIntegerValue(strValue);
                if (bResult) {
                    oDevInfo.setDeviceType(Integer.parseInt(strValue));
                }
                return bResult;
            }
            case 1: {
                bResult = DeviceTablePanelUtil.validateForIntegerValue(strValue);
                if (bResult) {
                    oDevInfo.setDeviceTypeVersionId(Integer.parseInt(strValue));
                }
                return bResult;
            }
            case 2: {
                if (strValue.equals("null")) {
                    strValue = "";
                }
                if (m_bIsMMLProtocol) {
                    bResult = DeviceTablePanelUtil.validateForIntegerValue(strValue);
                    if (bResult) {
                        oDevInfo.setMMLProtocolDevPhyId(Integer.parseInt(strValue));
                    }
                } else {
                    bResult = DeviceTablePanelUtil.validateForString(strValue);
                    if (bResult) {
                        oDevInfo.setTL1ProtocolDevPhyId(strValue);
                    }
                }
                return bResult;
            }
            case 3: {
                bResult = DeviceTablePanelUtil.validateForString(strValue);
                if (bResult) {
                    oDevInfo.setDeviceName(strValue);
                }
                return bResult;
            }
            case 4: {
                bResult = DeviceTablePanelUtil.validateForIntegerValue(strValue);
                if (bResult) {
                    oDevInfo.setProtocolType(Integer.parseInt(strValue));
                }
                return bResult;
            }
            case 5: {
                bResult = DeviceTablePanelUtil.validateForIntegerValue(strValue);
                if (bResult) {
                    oDevInfo.setGateWayType(Integer.parseInt(strValue));
                }
                return bResult;
            }
            case 6: {
                if (m_bIsIPGateway) {
                    String strVal = DeviceTablePanelUtil.checkAndFormatFileContent(strValue);
                    if (null == strValue) {
                        return false;
                    }
                    oDevInfo.setGatewayAddress(strVal);
                    return true;
                }
                bResult = DeviceTablePanelUtil.validateForString(strValue);
                if (bResult) {
                    oDevInfo.setGatewayAddress(strValue);
                }
                return bResult;
            }
            case 7: {
                bResult = DeviceTablePanelUtil.validateForIntegerValue(strValue);
                if (bResult) {
                    oDevInfo.setPort(Integer.parseInt(strValue));
                }
                return bResult;
            }
            case 8: {
                bResult = DeviceTablePanelUtil.validateForString(strValue);
                if (bResult) {
                    oDevInfo.setUserName(strValue);
                }
                return bResult;
            }
            case 9: {
                String strPassword = strValue;
                if (null == strPassword) {
                    return false;
                }
                bResult = DeviceTablePanelUtil.validateForString(strPassword);
                if (bResult) {
                    oDevInfo.setPass(strPassword.toCharArray());
                }
                return bResult;
            }
        }
        return false;
    }

    private static String checkAndFormatFileContent(String strIPAddresses) {
        if (null == strIPAddresses || strIPAddresses.equalsIgnoreCase("")) {
            return null;
        }
        String[] strIPPartsArr = new String[4];
        String strSearchedIPAddresses = strIPAddresses.trim();
        int iCounter = 0;
        while (-1 != strSearchedIPAddresses.indexOf(46)) {
            if (iCounter >= 3) {
                return null;
            }
            int iIndex = strSearchedIPAddresses.indexOf(46);
            strIPPartsArr[iCounter] = strSearchedIPAddresses.substring(0, iIndex).trim();
            ++iCounter;
            strSearchedIPAddresses = strSearchedIPAddresses.substring(iIndex + 1).trim();
        }
        if (3 != iCounter) {
            return null;
        }
        strIPPartsArr[iCounter] = strSearchedIPAddresses;
        try {
            int[] iValue = new int[4];
            for (int i = 0; i < 4; ++i) {
                if (strIPPartsArr[i].equals("*")) continue;
                iValue[i] = Integer.parseInt(strIPPartsArr[i]);
                if (iValue[i] < 0 || iValue[i] > 255 || 0 == i && 0 == iValue[i]) {
                    throw new NumberFormatException();
                }
                strIPPartsArr[i] = String.valueOf(iValue[i]);
            }
            if (0 == iValue[0] || 223 < iValue[0]) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException ex) {
            return null;
        }
        return strIPPartsArr[0] + '.' + strIPPartsArr[1] + '.' + strIPPartsArr[2] + '.' + strIPPartsArr[3];
    }

    private static boolean validateForIntegerValue(String strValue) {
        try {
            Integer.parseInt(strValue);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    private static boolean validateForString(String strValue) {
        return 0 != strValue.length();
    }

    private static boolean validateGatewayType(List<String> oResTokenList, int iGatewayTypeColPosition, T2000DevInfo oDevInfo) {
        String strProtocoType = oResTokenList.get(iGatewayTypeColPosition);
        return DeviceTablePanelUtil.validateAndSetT2000DeviceValue(strProtocoType.trim(), iGatewayTypeColPosition, oDevInfo);
    }

    private static boolean validateHeaderList(List<String> oHeaderList) {
        if (null == oHeaderList || GatewayConstants.ARR_T2000_FILE_HEADER_LIST.size() != oHeaderList.size()) {
            return false;
        }
        return DeviceTablePanelUtil.validateHeaderTitle(oHeaderList);
    }

    private static boolean validateHeaderTitle(List<String> oHeaderList) {
        boolean bExist = false;
        int iSize = GatewayConstants.ARR_T2000_FILE_HEADER_LIST.size();
        for (int iHeaderIndex = 0; iHeaderIndex < iSize; ++iHeaderIndex) {
            String strHeaderValue;
            for (int index = 0; index < iSize && !(bExist = (strHeaderValue = oHeaderList.get(iHeaderIndex)).trim().equals(GatewayConstants.ARR_T2000_FILE_HEADER_LIST.get(index).trim())); ++index) {
            }
            if (bExist) continue;
            return false;
        }
        return true;
    }

    private static List<String> getHeaderList(String strLineContent) {
        if (null == strLineContent || 0 == strLineContent.length()) {
            return null;
        }
        ArrayList<String> oHeaderList = new ArrayList<String>(0);
        StringTokenizer oHeaderTokenizer = new StringTokenizer(strLineContent, ",");
        while (oHeaderTokenizer.hasMoreTokens()) {
            String strToken = oHeaderTokenizer.nextToken();
            oHeaderList.add(strToken);
        }
        return oHeaderList;
    }

    private static List<String> getDMSHeaderList(String strLineContent) {
        if (null == strLineContent || 0 == strLineContent.length()) {
            return null;
        }
        ArrayList<String> oHeaderList = new ArrayList<String>(0);
        String m_strLineContent = strLineContent.trim();
        int iCounter = 0;
        if (-1 == strLineContent.indexOf(",")) {
            oHeaderList.add(m_strLineContent);
        } else {
            while (-1 != m_strLineContent.indexOf(",")) {
                if (iCounter >= 18) {
                    return null;
                }
                int iIndex = m_strLineContent.indexOf(",");
                if (m_strLineContent.substring(0, iIndex).trim() == null) {
                    oHeaderList.add("");
                } else {
                    oHeaderList.add(m_strLineContent.substring(0, iIndex).trim());
                }
                ++iCounter;
                m_strLineContent = m_strLineContent.substring(iIndex + 1).trim();
            }
            oHeaderList.add(m_strLineContent);
        }
        return oHeaderList;
    }

    private static void mapColumnsWithStandardFormat(List<String> oHeaderList) {
        int iSize = oHeaderList.size();
        block0: for (int iHeaderIndex = 0; iHeaderIndex < iSize; ++iHeaderIndex) {
            String strHeader = oHeaderList.get(iHeaderIndex);
            for (int index = 0; index < iSize; ++index) {
                if (!strHeader.trim().equals(GatewayConstants.ARR_T2000_FILE_HEADER_LIST.get(index).trim())) continue;
                m_oT2000FileHeaderMap.put(iHeaderIndex, index);
                continue block0;
            }
        }
    }

    private static int getProtocolTypeColPositionInExportFile(List<String> oColumnList) {
        int iSize = oColumnList.size();
        for (int index = 0; index < iSize; ++index) {
            String strCol = oColumnList.get(index);
            if (!strCol.trim().equals(GatewayConstants.ARR_T2000_FILE_HEADER_LIST.get(4).trim())) continue;
            return index;
        }
        return -1;
    }

    private static int getGatewayTypeColPositionInExportFile(List<String> oColumnList) {
        int iSize = oColumnList.size();
        for (int index = 0; index < iSize; ++index) {
            String strCol = oColumnList.get(index);
            if (!strCol.trim().equals(GatewayConstants.ARR_T2000_FILE_HEADER_LIST.get(5).trim())) continue;
            return index;
        }
        return -1;
    }

    public static String getFileName(DCFileChooser oFileChooserDialog, AbstractDeviceTablePanel reference) {
        int iReturnVal = oFileChooserDialog.showOpenDialog(reference);
        String strFileName = "";
        if (iReturnVal == 0) {
            strFileName = oFileChooserDialog.getFullFileName();
        }
        return strFileName;
    }

    public static List<Resource> getDMSResourceList(String strFileName, DeviceProgressDlg oAddDeviceProgressBarDlg) throws IOException, DCException {
        ArrayList<Resource> m_oResList = new ArrayList<Resource>(0);
        FileInputStream oFileStream = null;
        InputStreamReader m_oFileReader = null;
        BufferedReader m_oBufferedReader = null;
        String encoding = null;
        encoding = FileUtil.isUTF8File(strFileName) ? FileUtil.getUTF8Encoding() : FileUtil.getSystemEncoding();
        try {
            oFileStream = new FileInputStream(strFileName);
            m_oFileReader = new InputStreamReader((InputStream)oFileStream, encoding);
            m_oBufferedReader = new BufferedReader(m_oFileReader);
            String strLineContent = m_oBufferedReader.readLine();
            if (null != strLineContent) {
                int ColumnCount = strLineContent.split(",").length;
                while (null != strLineContent) {
                    List<String> oColumnList = DeviceTablePanelUtil.getDMSHeaderList(strLineContent);
                    if (oColumnList == null) {
                        strLineContent = m_oBufferedReader.readLine();
                        continue;
                    }
                    Resource m_oResource = null;
                    if (3 == ColumnCount) {
                        m_oResource = DeviceTablePanelUtil.getDMSResourceListFor1(oColumnList);
                    } else if (6 == ColumnCount) {
                        m_oResource = DeviceTablePanelUtil.getDMSResourceListFor2(oColumnList);
                        oAddDeviceProgressBarDlg.setWriteResoultPath(strFileName);
                    } else if (19 == ColumnCount) {
                        m_oResource = DeviceTablePanelUtil.getDMSResourceListFor3(oColumnList);
                    }
                    if (m_oResource != null && null != m_oResList) {
                        m_oResList.add(m_oResource);
                    }
                    strLineContent = m_oBufferedReader.readLine();
                }
            }
            if (null == m_oResList || 0 == m_oResList.size()) {
                DeviceTablePanelUtil.showInvalidFileContentMsg(ResourceManager.getInstance().getResString("NO_DEVICE_IP_FOUND"));
                List<Resource> list = null;
                return list;
            }
        }
        catch (FileNotFoundException ex) {
            DeviceTablePanelUtil.showErrorMessage(ResourceManager.getInstance().getResString("NOT_EXIST_FILE"));
            throw new IOException();
        }
        finally {
            try {
                if (null != m_oBufferedReader) {
                    m_oBufferedReader.close();
                }
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
            }
            try {
                if (null != m_oFileReader) {
                    m_oFileReader.close();
                }
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
            }
            try {
                if (null != oFileStream) {
                    oFileStream.close();
                }
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
            }
        }
        return m_oResList;
    }

    private static Resource getDMSResourceListFor1(List<String> oColumnList) {
        int iSnmpEnum;
        int iPollInterval;
        int iTimeOut;
        int iRetries;
        int iDevPort;
        Resource m_oResource = new Resource();
        String m_strIP = DeviceTablePanelUtil.checkAndFormatFileContent(oColumnList.get(0));
        if (m_strIP == null) {
            return null;
        }
        m_oResource.setDeviceIP(m_strIP);
        m_oResource.setDeviceName(oColumnList.get(0));
        SnmpParaInfo m_oSnmpParaInfo = new SnmpParaInfo();
        m_oSnmpParaInfo.setGetCommunity(oColumnList.get(1).toCharArray(), true);
        m_oSnmpParaInfo.setSetCommunity(oColumnList.get(2).toCharArray(), true);
        String strTempleate = ResourceManager.getInstance().getResString("m_strTemplate", "config");
        if (strTempleate.equals("m_strTemplate")) {
            strTempleate = "huawei_dc_tool";
        }
        m_oSnmpParaInfo.setTemplate(strTempleate);
        try {
            iDevPort = Integer.parseInt(ResourceManager.getInstance().getResString("m_iDevPort", "config"));
        }
        catch (Exception e) {
            iDevPort = 161;
        }
        m_oSnmpParaInfo.setDevPort(iDevPort);
        try {
            iRetries = Integer.parseInt(ResourceManager.getInstance().getResString("m_iRetries", "config"));
        }
        catch (Exception e) {
            iRetries = 3;
        }
        m_oSnmpParaInfo.setRetries(iRetries);
        try {
            iTimeOut = Integer.parseInt(ResourceManager.getInstance().getResString("m_iTimeOut", "config"));
        }
        catch (Exception e) {
            iTimeOut = 5;
        }
        m_oSnmpParaInfo.setTimeOut(iTimeOut);
        try {
            iPollInterval = Integer.parseInt(ResourceManager.getInstance().getResString("m_iPollIntervals", "config"));
        }
        catch (Exception e) {
            iPollInterval = 1800;
        }
        m_oSnmpParaInfo.setPollInterval(iPollInterval);
        try {
            iSnmpEnum = Integer.parseInt(ResourceManager.getInstance().getResString("m_enSnmpEnum", "config"));
        }
        catch (Exception e) {
            iSnmpEnum = 0;
        }
        m_oSnmpParaInfo.setSnmpEnum(iSnmpEnum);
        m_oResource.setSnmpParaInfo(m_oSnmpParaInfo);
        return m_oResource;
    }

    private static Resource getDMSResourceListFor2(List<String> oColumnList) {
        int iSnmpEnum;
        int iPollInterval;
        int iTimeOut;
        int iRetries;
        int iDevPort;
        Resource m_oResource = new Resource();
        String m_strIP = DeviceTablePanelUtil.checkAndFormatFileContent(oColumnList.get(0));
        if (m_strIP == null) {
            return null;
        }
        m_oResource.setDeviceIP(m_strIP);
        m_oResource.setDeviceName(oColumnList.get(0));
        String m_strUserName = "";
        try {
            m_strUserName = oColumnList.get(1);
            if (m_strUserName == null) {
                m_strUserName = "";
            }
            m_oResource.setUserName(m_strUserName);
        }
        catch (Exception e) {
            m_oResource.setUserName(m_strUserName);
        }
        String m_strPwdContext = "";
        try {
            m_strPwdContext = oColumnList.get(2);
            if (m_strUserName == null) {
                m_strPwdContext = "";
            }
            m_oResource.setPassword(m_strPwdContext.toCharArray());
        }
        catch (Exception e) {
            m_oResource.setPassword(m_strPwdContext.toCharArray());
        }
        String m_strSuperPwdContext = "";
        try {
            m_strSuperPwdContext = oColumnList.get(3);
            if (m_strSuperPwdContext == null) {
                m_strSuperPwdContext = "";
            }
            m_oResource.setSuperPassword(m_strSuperPwdContext.toCharArray());
        }
        catch (Exception e) {
            m_oResource.setSuperPassword(m_strSuperPwdContext.toCharArray());
        }
        SnmpParaInfo m_oSnmpParaInfo = new SnmpParaInfo();
        String strTempleate = ResourceManager.getInstance().getResString("m_strTemplate", "config");
        if (strTempleate.equals("m_strTemplate")) {
            strTempleate = "huawei_dc_tool";
        }
        m_oSnmpParaInfo.setTemplate(strTempleate);
        String strGetCommunity = ResourceManager.getInstance().getResString("m_strGetCommunity", "config");
        if (strGetCommunity.equals("m_strGetCommunity")) {
            strGetCommunity = "public";
        }
        m_oSnmpParaInfo.setGetCommunity(strGetCommunity.toCharArray(), false);
        String strSetCommunity = ResourceManager.getInstance().getResString("m_strSetCommunity", "config");
        if (strSetCommunity.equals("m_strSetCommunity")) {
            strSetCommunity = "private static";
        }
        m_oSnmpParaInfo.setSetCommunity(strSetCommunity.toCharArray(), false);
        try {
            iDevPort = Integer.parseInt(ResourceManager.getInstance().getResString("m_iDevPort", "config"));
        }
        catch (Exception e) {
            iDevPort = 161;
        }
        m_oSnmpParaInfo.setDevPort(iDevPort);
        try {
            iRetries = Integer.parseInt(ResourceManager.getInstance().getResString("m_iRetries", "config"));
        }
        catch (Exception e) {
            iRetries = 3;
        }
        m_oSnmpParaInfo.setRetries(iRetries);
        try {
            iTimeOut = Integer.parseInt(ResourceManager.getInstance().getResString("m_iTimeOut", "config"));
        }
        catch (Exception e) {
            iTimeOut = 5;
        }
        m_oSnmpParaInfo.setTimeOut(iTimeOut);
        try {
            iPollInterval = Integer.parseInt(ResourceManager.getInstance().getResString("m_iPollIntervals", "config"));
        }
        catch (Exception e) {
            iPollInterval = 1800;
        }
        m_oSnmpParaInfo.setPollInterval(iPollInterval);
        try {
            iSnmpEnum = Integer.parseInt(ResourceManager.getInstance().getResString("m_enSnmpEnum", "config"));
        }
        catch (Exception e) {
            iSnmpEnum = 0;
        }
        m_oSnmpParaInfo.setSnmpEnum(iSnmpEnum);
        m_oResource.setSnmpParaInfo(m_oSnmpParaInfo);
        return m_oResource;
    }

    private static Resource getDMSResourceListFor3(List oColumnList) throws DCException {
        Resource m_oResource = new Resource();
        String m_strIP = DeviceTablePanelUtil.checkAndFormatFileContent((String)oColumnList.get(3));
        if (m_strIP == null) {
            return null;
        }
        m_oResource.setDeviceIP(m_strIP);
        m_oResource.setDeviceName((String)oColumnList.get(2));
        try {
            m_oResource.setDevTypeId(Integer.parseInt((String)oColumnList.get(0)));
            m_oResource.setDevVersionID(Integer.parseInt((String)oColumnList.get(1)));
            SnmpParaInfo m_oSnmpParaInfo = new SnmpParaInfo();
            m_oSnmpParaInfo.setGetCommunity(((String)oColumnList.get(6)).toCharArray(), true);
            m_oSnmpParaInfo.setSetCommunity(((String)oColumnList.get(7)).toCharArray(), true);
            m_oSnmpParaInfo.setTemplate((String)oColumnList.get(4));
            m_oSnmpParaInfo.setDevPort(Integer.parseInt((String)oColumnList.get(11)));
            m_oResource.setPortValue(Integer.parseInt((String)oColumnList.get(11)));
            m_oSnmpParaInfo.setRetries(Integer.parseInt((String)oColumnList.get(9)));
            m_oSnmpParaInfo.setTimeOut(Integer.parseInt((String)oColumnList.get(8)));
            m_oSnmpParaInfo.setPollInterval(Integer.parseInt((String)oColumnList.get(10)));
            m_oSnmpParaInfo.setSnmpEnum(Integer.parseInt((String)oColumnList.get(5)));
            m_oSnmpParaInfo.setUserName((String)oColumnList.get(12));
            m_oResource.setUserName((String)oColumnList.get(12));
            m_oSnmpParaInfo.setContextName((String)oColumnList.get(13));
            m_oSnmpParaInfo.setContextId((String)oColumnList.get(14));
            m_oSnmpParaInfo.setDataEncryptionType(Integer.parseInt((String)oColumnList.get(15)));
            m_oSnmpParaInfo.setEncrypPasswd(((String)oColumnList.get(16)).toCharArray(), true);
            m_oSnmpParaInfo.setAuthenticationType(Integer.parseInt((String)oColumnList.get(17)));
            m_oSnmpParaInfo.setAuthenticationPasswd(((String)oColumnList.get(18)).toCharArray(), true);
            m_oResource.setPassword(((String)oColumnList.get(18)).toCharArray());
            m_oResource.setSnmpParaInfo(m_oSnmpParaInfo);
        }
        catch (Exception e) {
            throw new DCException(ResourceManager.getInstance().getResString("INVALID_FILE_MSG"));
        }
        return m_oResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<T2000DevInfo> getT2000ResourceList(String strFileName) throws IOException {
        ArrayList<T2000DevInfo> oResList = new ArrayList<T2000DevInfo>(0);
        FileInputStream oFileStream = null;
        InputStreamReader oFileReader = null;
        BufferedReader oBufferedReader = null;
        String[] encodingInfo = new String[]{FileUtil.getSystemEncoding(), FileUtil.getUTF8Encoding()};
        boolean bValidationResult = false;
        List<String> oColumnList = null;
        try {
            oFileStream = new FileInputStream(strFileName);
            oFileReader = new InputStreamReader((InputStream)oFileStream, FileUtil.getSystemEncoding());
            oBufferedReader = new BufferedReader(oFileReader);
            oColumnList = DeviceTablePanelUtil.getHeaderList(oBufferedReader.readLine());
            bValidationResult = DeviceTablePanelUtil.validateHeaderList(oColumnList);
            if (!bValidationResult) {
                oBufferedReader.close();
                oFileReader.close();
                oFileStream.close();
                oBufferedReader = null;
                oFileReader = null;
                oFileStream = null;
                oFileStream = new FileInputStream(strFileName);
                oFileReader = new InputStreamReader((InputStream)oFileStream, FileUtil.getUTF8Encoding());
                oBufferedReader = new BufferedReader(oFileReader);
                oColumnList = DeviceTablePanelUtil.getHeaderList(oBufferedReader.readLine());
                bValidationResult = DeviceTablePanelUtil.validateHeaderList(oColumnList);
            }
            if (!bValidationResult) {
                List<T2000DevInfo> list = null;
                return list;
            }
            DeviceTablePanelUtil.mapColumnsWithStandardFormat(oColumnList);
            int iProtocolTypeColPosition = DeviceTablePanelUtil.getProtocolTypeColPositionInExportFile(oColumnList);
            int iGatewayTypeColPosition = DeviceTablePanelUtil.getGatewayTypeColPositionInExportFile(oColumnList);
            String strLineContent = null;
            int iRecCount = 0;
            T2000DevInfo oT2000DevInfo = null;
            String[] strInfo = null;
            ArrayList<String> oResTokenList = null;
            if (null != oBufferedReader) {
                strLineContent = oBufferedReader.readLine();
            }
            while (null != strLineContent) {
                String strProtocoType;
                int iProtocolType;
                oT2000DevInfo = new T2000DevInfo();
                strInfo = strLineContent.split(",");
                oResTokenList = new ArrayList<String>(0);
                if (strInfo == null) continue;
                for (int i = 0; i < strInfo.length; ++i) {
                    oResTokenList.add(strInfo[i]);
                }
                if (GatewayConstants.ARR_T2000_FILE_HEADER_LIST.size() != oResTokenList.size()) {
                    DeviceTablePanelUtil.showInvalidFileContentMsg(ResourceManager.getInstance().getResString("INVALID_FILE_MSG"));
                    List<T2000DevInfo> i = null;
                    return i;
                }
                boolean bl = bValidationResult = DeviceTablePanelUtil.validateAndSetProtocolType(oResTokenList, iProtocolTypeColPosition, oT2000DevInfo) && DeviceTablePanelUtil.validateGatewayType(oResTokenList, iGatewayTypeColPosition, oT2000DevInfo);
                if (!bValidationResult) {
                    DeviceTablePanelUtil.showInvalidFileContentMsg(ResourceManager.getInstance().getResString("INVALID_FILE_MSG"));
                }
                m_bIsMMLProtocol = 2 == (iProtocolType = Integer.parseInt((strProtocoType = (String)oResTokenList.get(iProtocolTypeColPosition)).trim()));
                String strGatewayType = (String)oResTokenList.get(iGatewayTypeColPosition);
                int iGatewayType = Integer.parseInt(strGatewayType.trim());
                m_bIsIPGateway = 1 == iGatewayType;
                int iSize = oResTokenList.size();
                for (int index = 0; index < iSize; ++index) {
                    bValidationResult = DeviceTablePanelUtil.validateAndSetT2000DeviceValue(((String)oResTokenList.get(index)).trim(), index, oT2000DevInfo);
                    if (bValidationResult) continue;
                    DeviceTablePanelUtil.showInvalidFileContentMsg(ResourceManager.getInstance().getResString("INVALID_FILE_MSG"));
                    List<T2000DevInfo> list = null;
                    return list;
                }
                oResList.add(oT2000DevInfo);
                ++iRecCount;
                if (null == oBufferedReader) continue;
                strLineContent = oBufferedReader.readLine();
            }
            if (0 == iRecCount) {
                DeviceTablePanelUtil.showInvalidFileContentMsg(ResourceManager.getInstance().getResString("NO_DEVICE_INFO_FOUND"));
            }
        }
        catch (FileNotFoundException ex) {
            String strErrorMsg = ResourceManager.getInstance().getResString("NOT_EXIST_FILE");
            DeviceTablePanelUtil.showErrorMessage(strErrorMsg);
        }
        catch (IOException e) {
            DCDebugTracer.trace(e);
        }
        finally {
            try {
                if (null != oBufferedReader) {
                    oBufferedReader.close();
                }
            }
            catch (IOException e) {
                DebugTracer.trace((Exception)e);
            }
            try {
                if (null != oFileReader) {
                    oFileReader.close();
                }
            }
            catch (IOException e) {
                DebugTracer.trace((Exception)e);
            }
            try {
                if (null != oFileStream) {
                    oFileStream.close();
                }
            }
            catch (IOException e) {
                DebugTracer.trace((Exception)e);
            }
        }
        return oResList;
    }

    private static void showInvalidFileContentMsg(String strMsg) {
        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), strMsg, ResourceManager.getInstance().getResString("ERROR"), 0);
    }

    public static void showErrorMessage(String strError) {
        DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString(strError));
    }

    public static DCFileChooser getFileChooserDlg() {
        PrintSupportor.setIsFileSelection(true);
        DCFileChooser oFileChooserDialog = new DCFileChooser();
        oFileChooserDialog.setTitle(ResourceManager.getInstance().getResString("IMPORT_DEVICE"));
        oFileChooserDialog.setApproveButtonText(ResourceManager.getInstance().getResString("IMPORT_DEVICE"));
        oFileChooserDialog.setApproveButtonMnemonic('I');
        oFileChooserDialog.setApproveButtonToolTipText(ResourceManager.getInstance().getResString("IMPORT_TOOL_TIP"));
        oFileChooserDialog.setFileFilter(2);
        oFileChooserDialog.setAcceptAllFileFilterUsed(false);
        DCHelpManager.getInstance().enableF1HelpKey((Component)((Object)oFileChooserDialog), "HELP_TOPIC_NE_IMPORT");
        return oFileChooserDialog;
    }

    public static boolean checkIfAllDevOpCompleted(DCSortableTreeTable m_oDeviceTreeTable) {
        int[] arrSelectedRow = m_oDeviceTreeTable.getSelectedRows();
        int iRowCount = arrSelectedRow.length;
        for (int i = 0; i < iRowCount; ++i) {
            DeviceInfo oDeviceInfo = (DeviceInfo)m_oDeviceTreeTable.getValueAt(arrSelectedRow[i], 0);
            if (!oDeviceInfo.getDeviceOperationStatus().getIsProgress()) continue;
            return false;
        }
        return true;
    }

    public static boolean checkIfAllDevSameType(DCSortableTreeTable m_oDeviceTreeTable) {
        int[] arrSelectedRow = m_oDeviceTreeTable.getSelectedRows();
        int iRowCount = arrSelectedRow.length;
        DeviceInfo firstDev = (DeviceInfo)m_oDeviceTreeTable.getValueAt(0, 0);
        int devType = firstDev.getDeviceTypeInfo().getDevTypeID();
        for (int i = 0; i < iRowCount; ++i) {
            DeviceInfo oDeviceInfo = (DeviceInfo)m_oDeviceTreeTable.getValueAt(arrSelectedRow[i], 0);
            if (devType == oDeviceInfo.getDeviceTypeInfo().getDevTypeID()) continue;
            return false;
        }
        return true;
    }

    public static void addHeaderNamesInExportFile(BufferedWriter oBufferedWriter, int iDevDomain) {
        block7: {
            block6: {
                if (4 != iDevDomain) break block6;
                int iSize = GatewayConstants.ARR_T2000_FILE_HEADER_LIST_OFFLINE.size();
                for (int index = 0; index < iSize; ++index) {
                    try {
                        oBufferedWriter.write(GatewayConstants.ARR_T2000_FILE_HEADER_LIST_OFFLINE.get(index));
                        if (iSize == index + 1) continue;
                        oBufferedWriter.write(" , ");
                        continue;
                    }
                    catch (IOException e) {
                        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("FILE_EXPORT_FAILED"), ResourceManager.getInstance().getResString("ERROR"), 0);
                    }
                }
                break block7;
            }
            if (2 != iDevDomain && 1 != iDevDomain) break block7;
            int iSize = GatewayConstants.ARR_DMS_FILE_HEADER_LIST.size();
            for (int index = 0; index < iSize; ++index) {
                try {
                    oBufferedWriter.write(GatewayConstants.ARR_DMS_FILE_HEADER_LIST.get(index));
                    if (iSize == index + 1) continue;
                    oBufferedWriter.write(" , ");
                    continue;
                }
                catch (IOException e) {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("FILE_EXPORT_FAILED"), ResourceManager.getInstance().getResString("ERROR"), 0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportSelectedDevices(String strFileName, HashSet<String> oIpStringSet) {
        String strLineSeperator = System.getProperty("line.separator");
        StringBuffer strIPBuffer = new StringBuffer(0);
        boolean bExceptionCought = false;
        FileWriter oFileWriter = null;
        BufferedWriter oBufferedWriter = null;
        try {
            oFileWriter = new FileWriter(strFileName);
            oBufferedWriter = new BufferedWriter(oFileWriter);
            for (String strResourceIp : oIpStringSet) {
                strIPBuffer.append(strResourceIp);
                strIPBuffer.append(strLineSeperator);
            }
            oBufferedWriter.write(strIPBuffer.toString());
        }
        catch (Exception ex) {
            bExceptionCought = true;
        }
        finally {
            try {
                if (null != oBufferedWriter) {
                    oBufferedWriter.close();
                }
                if (null != oFileWriter) {
                    oFileWriter.close();
                }
            }
            catch (IOException e) {
                bExceptionCought = true;
            }
            oBufferedWriter = null;
            oFileWriter = null;
            if (bExceptionCought) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("FILE_EXPORT_FAILED"), ResourceManager.getInstance().getResString("ERROR"), 0);
            } else {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("OPERATION_SUCCESSFUL"), ResourceManager.getInstance().getResString("INFO"), 1);
            }
        }
    }

    public static DCSaveFileChooser initExportDialog(boolean isExportDevTemplate) {
        PrintSupportor.setIsFileSelection(false);
        String strPath = ConfigurationInfo.getInstance().getAbsoluteBaseDirectory() + File.separator + "report/";
        File fileDoc = new File(strPath);
        if (!fileDoc.exists()) {
            try {
                fileDoc.mkdir();
            }
            catch (Exception ex) {
                DCDebugTracer.trace(ex);
                return null;
            }
        }
        DCSaveFileChooser oFileChooserDialog = new DCSaveFileChooser(strPath, false);
        if (isExportDevTemplate) {
            oFileChooserDialog.setTitle(ResourceManager.getInstance().getResString("EXPORT_DEVICE_TEMPLATE_INFO"));
        } else {
            oFileChooserDialog.setTitle(ResourceManager.getInstance().getResString("EXPORT_DEVICE_INFO"));
        }
        DCHelpManager.getInstance().enableF1HelpKey((Component)((Object)oFileChooserDialog), "HELP_TOPIC_NE_EXPORT");
        oFileChooserDialog.setFileFilter(2);
        oFileChooserDialog.setAcceptAllFileFilterUsed(false);
        oFileChooserDialog.setEncodingEnabled(true);
        return oFileChooserDialog;
    }

    public static DeviceInfo getSelectedDevInfoLst(DCSortableTreeTable m_oDeviceTreeTable) {
        JTree tree = m_oDeviceTreeTable.getTree();
        DeviceInfo devInfoObj = null;
        int[] iSelectedRows = m_oDeviceTreeTable.getSelectedRows();
        int iSelectedNodeCount = iSelectedRows.length;
        for (int i = 0; i < iSelectedNodeCount; ++i) {
            TreeTableNode tmpNode;
            Object obj;
            TreePath oTreePath = tree.getPathForRow(iSelectedRows[i]);
            if (null == oTreePath || !((obj = (tmpNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject()) instanceof DeviceInfo)) continue;
            devInfoObj = (DeviceInfo)tmpNode.getUserObject();
        }
        return devInfoObj;
    }

    public static boolean isOperationInProgressForAnyDevice(DCSortableTreeTable m_oDeviceTreeTable) {
        int[] arrSelectedRows = m_oDeviceTreeTable.getSelectedRows();
        BusyDeviceObjectStore oBusyDeviceStore = BusyDeviceObjectStore.getInstance();
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            int iDeviceID = DeviceTableUtil.getDeviceIDForTableRow(m_oDeviceTreeTable, arrSelectedRows[i]);
            if (!oBusyDeviceStore.isDeviceOperationInProgress(iDeviceID)) continue;
            return true;
        }
        return false;
    }

    public static void retainPreviousSelection(ArrayList<DeviceInfo> oSelectedResourceList, DCSortableTreeTable m_oDeviceTreeTable) {
        m_oDeviceTreeTable.clearSelection();
        DeviceInfo oDeviceInfo = null;
        int iSelCount = 0;
        int iRowCount = m_oDeviceTreeTable.getRowCount();
        int iSelectedRowCount = oSelectedResourceList.size();
        for (int i = 0; i < iRowCount; ++i) {
            oDeviceInfo = (DeviceInfo)m_oDeviceTreeTable.getValueAt(i, 0);
            if (null == oDeviceInfo || !oSelectedResourceList.contains(oDeviceInfo)) continue;
            if (0 == iSelCount) {
                m_oDeviceTreeTable.setRowSelectionInterval(i, i);
            } else {
                m_oDeviceTreeTable.addRowSelectionInterval(i, i);
            }
            ++iSelCount;
            if (0 != --iSelectedRowCount) continue;
            Rectangle oRect = m_oDeviceTreeTable.getCellRect(i, 0, true);
            m_oDeviceTreeTable.scrollRectToVisible(oRect);
            break;
        }
    }

    public static DeviceInfo[] getDevIdOfSelectedRow(DCSortableTreeTable m_oDeviceTreeTable) {
        int[] arrSelectedRows = m_oDeviceTreeTable.getSelectedRows();
        DeviceInfo[] arrDevInfo = new DeviceInfo[arrSelectedRows.length];
        DeviceInfo oDeviceInfo = null;
        for (int iSeletedRowIndex = 0; iSeletedRowIndex < arrSelectedRows.length; ++iSeletedRowIndex) {
            arrDevInfo[iSeletedRowIndex] = oDeviceInfo = (DeviceInfo)m_oDeviceTreeTable.getValueAt(arrSelectedRows[iSeletedRowIndex], 0);
        }
        return arrDevInfo;
    }

    public static THashSet<Resource> getSelectedResourcesHs(DCSortableTreeTable m_oDeviceTreeTable) {
        THashSet oResHs = new THashSet();
        int[] arrRows = m_oDeviceTreeTable.getSelectedRows();
        int iLength = arrRows.length;
        Resource oResource = null;
        DeviceInfo oDeviceInfo = null;
        for (int index = 0; index < iLength; ++index) {
            oDeviceInfo = (DeviceInfo)m_oDeviceTreeTable.getValueAt(arrRows[index], 0);
            if (null == oDeviceInfo) continue;
            oResource = DeviceModelAdapter.populateResourceFromDeviceID(oDeviceInfo.getDevId());
            oResHs.add((Object)oResource);
        }
        return oResHs;
    }

    public static List<Resource> getSelectedResources(DCSortableTreeTable m_oDeviceTreeTable) {
        ArrayList<Resource> oResourcelist = new ArrayList<Resource>(0);
        int[] arrRows = m_oDeviceTreeTable.getSelectedRows();
        int iLength = arrRows.length;
        Resource oResource = null;
        DeviceInfo oDeviceInfo = null;
        for (int index = 0; index < iLength; ++index) {
            oDeviceInfo = (DeviceInfo)m_oDeviceTreeTable.getValueAt(arrRows[index], 0);
            if (null == oDeviceInfo) continue;
            oResource = DeviceModelAdapter.populateResourceFromDeviceID(oDeviceInfo.getDevId());
            oResourcelist.add(oResource);
        }
        return oResourcelist;
    }

    public static AsnDCExportDeviceReq getExportDeviceReq(String strFileName, DeviceInfo[] arrDeviceInfo) {
        AsnDCDeviceLst devList;
        DCStringList headList;
        DCDebugTracer.trace("DeviceTablePanelUtil#getExportDeviceReq start");
        DCDebugTracer.trace("save file path  : " + strFileName);
        DeviceInfo oDevInfo = arrDeviceInfo[0];
        DeviceTypeInfo oDevTypeInfo = oDevInfo.getDeviceTypeInfo();
        int iDevDomain = oDevTypeInfo.getDevDomain();
        int iReqId = DCFrameWorkUtil.generateRequestId();
        AsnDCExportDeviceReq oReq = new AsnDCExportDeviceReq();
        oReq.oReqID = BigInteger.valueOf(iReqId);
        oReq.bIsLocale = false;
        oReq.strFilePath = strFileName.getBytes();
        oReq.strYes = ResourceManager.getInstance().getResString("YES").getBytes();
        oReq.strNo = ResourceManager.getInstance().getResString("NO").getBytes();
        oReq.oHeaderLst = headList = new DCStringList();
        if (4 == iDevDomain) {
            oReq.iDomain = BigInteger.valueOf(4L);
            for (String headTemp : GatewayConstants.ARR_T2000_FILE_HEADER_LIST_OFFLINE) {
                headList.add((Object)headTemp.getBytes());
            }
        } else if (1 == iDevDomain) {
            oReq.iDomain = BigInteger.valueOf(1L);
            for (String headTemp : GatewayConstants.ARR_DMS_FILE_HEADER_LIST) {
                headList.add((Object)headTemp.getBytes());
            }
        } else if (2 == iDevDomain) {
            oReq.iDomain = BigInteger.valueOf(2L);
            for (String headTemp : GatewayConstants.ARR_DMS_EXPORT_FILE_HEADER_LIST) {
                headList.add((Object)headTemp.getBytes());
            }
        } else {
            DCDebugTracer.trace("getExportDeviceReq#DevDomain error : " + iDevDomain);
        }
        oReq.oDCDeviceLst = devList = new AsnDCDeviceLst();
        AsnDCDeviceInfo asnDevInfo = null;
        for (DeviceInfo devInfo : arrDeviceInfo) {
            asnDevInfo = new AsnDCDeviceInfo();
            asnDevInfo.iDevId = BigInteger.valueOf(devInfo.getDevId());
            asnDevInfo.strDevName = devInfo.getDevName().getBytes();
            asnDevInfo.strDevIPAddress = devInfo.getDevIPAddress().getBytes();
            oDevTypeInfo = devInfo.getDeviceTypeInfo();
            if (null == oDevTypeInfo) {
                DCDebugTracer.trace("getExportDeviceReq#oDevTypeInfo is null which device id is : " + asnDevInfo.iDevId);
                continue;
            }
            asnDevInfo.iDevTypeId = BigInteger.valueOf(oDevTypeInfo.getDevTypeID());
            asnDevInfo.iDevTypeVersionId = BigInteger.valueOf(oDevTypeInfo.getDevTypeVersionId());
            asnDevInfo.enRoleType = new AsnRoleTypeEnum(devInfo.getRoleType());
            asnDevInfo.oLastOperationState = new AsnDCDeviceLastOperationStatusEnum(devInfo.getLastOperationErrorCode());
            devList.add((Object)asnDevInfo);
        }
        DCDebugTracer.trace("devList : " + devList.size());
        DCDebugTracer.trace("DeviceTablePanelUtil#getExportDeviceReq end..");
        return oReq;
    }

    public static DCSaveFileChooser initExportDialog(String defaultFileName, int fileFilter) {
        PrintSupportor.setIsFileSelection(false);
        DCSaveFileChooser oFileChooserDialog = new DCSaveFileChooser();
        oFileChooserDialog.setTitle(ResourceManager.getInstance().getResString("EXPORT_DEVICE_INFO"));
        DCHelpManager.getInstance().enableF1HelpKey((Component)((Object)oFileChooserDialog), "HELP_TOPIC_NE_EXPORT");
        oFileChooserDialog.setFileFilter(fileFilter);
        oFileChooserDialog.setAcceptAllFileFilterUsed(false);
        defaultFileName = FileUtil.getFileName(defaultFileName);
        oFileChooserDialog.setSelectedFile(new File(defaultFileName));
        return oFileChooserDialog;
    }
}

