/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceview.devicetable;

import com.huawei.dc.adapter.swimap.iview.commstyle.resource.DCResourceMng;
import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.DCGUIUtil;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceBoardNotification;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfo;
import com.huawei.dc.common.asndatacenter.AsnDCExportDeviceReq;
import com.huawei.dc.common.asndatacenter.AsnDCOSPFStatusNotify;
import com.huawei.dc.common.asndatacenter.AsnDCOpertionRsp;
import com.huawei.dc.common.components.devicetreepanel.DeviceTreePanel;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.dialog.ProgressDlg;
import com.huawei.dc.common.components.tree.devicetree.DeviceTree;
import com.huawei.dc.common.controller.AbstractDeviceInfoManager;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.ConfigurationInfo;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCFileChooser;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DCSaveFileChooser;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.common.util.ErrorInfo;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.common.util.TempletExportUtil;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.controller.DeviceInfoSyncCtrller;
import com.huawei.dc.devicemanagement.controller.IDeviceInfoSyncCtrller;
import com.huawei.dc.devicemanagement.deviceoperation.activationdatabase.ActivationDataBaseOperation;
import com.huawei.dc.devicemanagement.deviceoperation.controller.BusyDeviceObjectStore;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.CheckDeviceMemoryUtil;
import com.huawei.dc.devicemanagement.deviceoperation.save.ManualSaveOperation;
import com.huawei.dc.devicemanagement.deviceview.DeviceMainPanel;
import com.huawei.dc.devicemanagement.deviceview.common.DeviceIDDataObject;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.IDeviceInfoSelectionListener;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.SaveBackupFiles;
import com.huawei.dc.devicemanagement.deviceview.devicetable.AbstractDeviceTablePanel;
import com.huawei.dc.devicemanagement.deviceview.devicetable.ConfigOSPFSetDlg;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceManagementPopupMenuManager;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceTableManager;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceTablePanelUtil;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceTableUtil;
import com.huawei.dc.devicemanagement.model.DeviceModelAdapter;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.deviceoperation.IDeviceOperationManager;
import com.huawei.dc.deviceoperation.util.OperationStatus;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.standalone.controller.IDCStandAloneSyncCtrller;
import com.huawei.dc.standalone.controller.StandAloneSyncCtrller;
import com.huawei.dc.standalone.search.view.SearchDeviceDlg;
import com.huawei.dc.standalone.view.AddDevicesDlg;
import com.huawei.dc.standalone.view.DeviceProgressDlg;
import com.huawei.dc.standalone.view.ModifyDeviceDialog;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.Task;
import com.huawei.dc.taskmgmt.view.common.TaskMenuItemHandlerHelper;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;

public class DeviceTablePanel
extends AbstractDeviceTablePanel {
    private static final long serialVersionUID = -6327976204362252613L;

    public DeviceTablePanel(IDeviceInfoManager oDeviceInfoManager, IDeviceOperationManager oDeviceOperationManager, DeviceMainPanel oDeviceMainPanel) {
        super(oDeviceInfoManager, oDeviceOperationManager, oDeviceMainPanel);
    }

    @Override
    public void setVersionProgress(AsnDCDeviceBoardNotification oAsnDCDeviceBoardNotification) {
        if (null == oAsnDCDeviceBoardNotification || 0 == this.m_oDeviceTreeTableModel.getRowCount()) {
            return;
        }
        if (!oAsnDCDeviceBoardNotification.bIsFinal) {
            int iDevId = oAsnDCDeviceBoardNotification.oVersionInfo.iDeviceId.intValue();
            int ErrorCode = oAsnDCDeviceBoardNotification.oErrorInfo.iErrorNo.intValue();
            int getPatchErrorCode = oAsnDCDeviceBoardNotification.oPatchErrorInfo.iErrorNo.intValue();
            String error = "";
            String getPatchError = "";
            if (0 == ErrorCode && 0 == getPatchErrorCode) {
                error = ResourceManager.getInstance().getResString("OPERTION_SUCCESS");
            }
            if (0 != ErrorCode) {
                error = ResourceManager.getInstance().getResString("UPDATE_NE_VERSION") + ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(ErrorCode));
            }
            if (0 != getPatchErrorCode) {
                getPatchError = ResourceManager.getInstance().getResString("UPDATE_PATCH_VERSION") + ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(getPatchErrorCode));
                error = error + getPatchError;
            }
            DeviceInfo deviceInfo = DCFrameWorkUtil.getDeviceInfoManager().getDevice(iDevId);
            String strDisplayName = "";
            if (null != deviceInfo) {
                String devName = deviceInfo.getDevName();
                String devIPAdd = deviceInfo.getDevIPAddress();
                strDisplayName = devName + '(' + devIPAdd + ')';
            } else {
                strDisplayName = ResourceManager.getInstance().getResString("TABLE_DEVICEID") + " : " + iDevId;
                error = ResourceManager.getInstance().getResString("DEVICE_DELETED");
            }
            if (null != this.m_dlg && this.m_dlg.getProgressDlgId() == oAsnDCDeviceBoardNotification.oProgressInfo.oReqID.intValue()) {
                this.m_dlg.setProgress(strDisplayName, error, oAsnDCDeviceBoardNotification.oProgressInfo.iPercentageProgress.intValue(), iDevId, new ErrorInfo(oAsnDCDeviceBoardNotification.oErrorInfo));
            }
            if (0 == oAsnDCDeviceBoardNotification.oErrorInfo.iErrorNo.intValue() && null != deviceInfo) {
                this.updateVersionInfo(deviceInfo.getDevVersion());
            }
            DeviceTreePanel oDeviceTreePanel = DCFrameWorkUtil.getDeviceTreePanel();
            DeviceTree oDeviceTree = oDeviceTreePanel.getDeviceTree();
            AsnDCDeviceSubmapNtfnInfo oAsnInfo = new AsnDCDeviceSubmapNtfnInfo();
            oAsnInfo.oDeviceInfo = new AsnDCDeviceInfo();
            oAsnInfo.oDeviceInfo.iDevId = BigInteger.valueOf(iDevId);
            oDeviceTree.processEvent(2, oAsnInfo);
            if (100 == oAsnDCDeviceBoardNotification.oProgressInfo.iPercentageProgress.intValue()) {
                DCFrameWorkUtil.updateUI(this.m_oDeviceMainPanel);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    DCDebugTracer.trace(e);
                }
                this.m_oTableManager.setIgnoreNotifications(false);
            }
        }
    }

    @Override
    public void setCancelOperationProgress(AsnDCDeviceBoardNotification oAsnDCDeviceBoardNotification) {
        if (null == oAsnDCDeviceBoardNotification) {
            return;
        }
        if (!oAsnDCDeviceBoardNotification.bIsFinal) {
            int iDevId = oAsnDCDeviceBoardNotification.oVersionInfo.iDeviceId.intValue();
            int ErrorCode = oAsnDCDeviceBoardNotification.oErrorInfo.iErrorNo.intValue();
            String error = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(ErrorCode));
            DeviceInfo deviceInfo = DCFrameWorkUtil.getDeviceInfoManager().getDevice(iDevId);
            String strDisplayName = "";
            if (null != deviceInfo) {
                String devName = deviceInfo.getDevName();
                String devIPAdd = deviceInfo.getDevIPAddress();
                strDisplayName = devName + '(' + devIPAdd + ')';
            } else {
                strDisplayName = ResourceManager.getInstance().getResString("TABLE_DEVICEID") + " : " + iDevId;
                error = ResourceManager.getInstance().getResString("DEVICE_DELETED");
            }
            if (null != this.m_dlg && this.m_dlg.getProgressDlgId() == oAsnDCDeviceBoardNotification.oProgressInfo.oReqID.intValue()) {
                this.m_dlg.setProgress(strDisplayName, error, oAsnDCDeviceBoardNotification.oProgressInfo.iPercentageProgress.intValue(), iDevId);
            }
        }
    }

    public AbstractDeviceInfoManager getInfomanagerImpl() {
        return (AbstractDeviceInfoManager)DCFrameWorkUtil.getDeviceInfoManager();
    }

    public void createDeviceTableManager(IDeviceInfoManager oDeviceInfoManager, IDeviceOperationManager oDeviceOperationManager) {
        this.m_oTableManager = new DeviceTableManager(this, oDeviceInfoManager, oDeviceOperationManager);
        DeviceInfoManagerImpl.getInstance().getDeviceFromDCServerWithParent(4);
        this.m_oTableManager.initializeTableManager();
    }

    @Override
    public void backup() {
        boolean isBackupAllow;
        boolean m_backupServerPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(43823);
        boolean m_backupThirdPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(44095);
        boolean bl = isBackupAllow = m_backupServerPrivilege || m_backupThirdPrivilege;
        if (!DCFrameWorkUtil.getIsSingleClient() && !isBackupAllow) {
            DCOptionPane.showMessageDialog(null, ResourceManager.getInstance().getResString("NO_PRIVILEGE_BACKUP"), ResourceManager.getInstance().getResString("SUGGESTION"), 1);
            return;
        }
        if (!this.isCanDoOperation()) {
            return;
        }
        DeviceInfo[] arrDeviceInfo = DeviceTablePanelUtil.getDevIdOfSelectedRow(this.m_oDeviceTreeTable);
        this.m_oDevCommonManualOpr.backup(arrDeviceInfo);
        DCFrameWorkUtil.updateUI(this);
    }

    @Override
    public void modifyDevice() {
        DeviceIDDataObject oDeviceId;
        String strDevIP;
        if (0 > this.m_oDeviceTreeTable.getSelectedRow()) {
            DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("SELETE_Modify_NE"), DCFrameWorkUtil.getLocalizedString("ERROR_MESSAGE"), 0);
            return;
        }
        DeviceInfo[] arrDevInfo = DeviceTablePanelUtil.getDevIdOfSelectedRow(this.m_oDeviceTreeTable);
        DeviceInfo oDevInfo = arrDevInfo[0];
        DeviceTypeInfo oDevTypeInfo = oDevInfo.getDeviceTypeInfo();
        int iDevDomain = oDevTypeInfo.getDevDomain();
        if (4 == iDevDomain) {
            this.modifyT2000Device(arrDevInfo);
            return;
        }
        if (1 != arrDevInfo.length) {
            return;
        }
        DefaultMutableTreeNode oNode = this.getRowForDeviceID(arrDevInfo[0].getDevId());
        DeviceInfo oRowData = (DeviceInfo)oNode.getUserObject();
        String strDevName = oRowData.getDevName();
        int iDeviceid = -1;
        if (null == strDevName) {
            strDevName = "";
        }
        if (null == (strDevIP = oRowData.getDevIPAddress())) {
            strDevIP = "";
        }
        if (null != (oDeviceId = new DeviceIDDataObject(oRowData.getDevId()))) {
            iDeviceid = oDeviceId.getDeviceID();
        }
        Resource oResource = new Resource();
        oResource.setDeviceName(strDevName);
        oResource.setDeviceIP(strDevIP);
        oResource.setDeviceID(iDeviceid);
        try {
            if (2 != oDevTypeInfo.getDeviceType()) {
                ModifyDeviceDialog oModifyDevDlg = new ModifyDeviceDialog(oResource);
                if (2 == oModifyDevDlg.getSNMPVersion()) {
                    oModifyDevDlg.setSize(580, 370);
                } else {
                    oModifyDevDlg.setSize(580, 250);
                }
                oModifyDevDlg.setVisible(true);
            }
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode(), this.m_oResourceMgr.getResString("ERROR"), 0);
            return;
        }
    }

    @Override
    public void recover() {
        boolean isRecoverAllow;
        boolean m_recoverServerPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(43824);
        boolean m_recoverClientPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(43868);
        boolean m_recoverThirdPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(44096);
        boolean bl = isRecoverAllow = m_recoverServerPrivilege || m_recoverClientPrivilege || m_recoverThirdPrivilege;
        if (!DCFrameWorkUtil.getIsSingleClient() && !isRecoverAllow) {
            DCOptionPane.showMessageDialog(null, ResourceManager.getInstance().getResString("NO_PRIVILEGE_RECOVER"), ResourceManager.getInstance().getResString("SUGGESTION"), 1);
            return;
        }
        if (!this.isCanDoOperation()) {
            return;
        }
        if (!DeviceTableUtil.isOneTranNEInRecover(this.m_oDeviceTreeTable)) {
            DCOptionPane.showMessageDialog(null, ResourceManager.getInstance().getResString("NO_SUPPORT_MORE_GATE_NE_IN_RECOVER"), ResourceManager.getInstance().getResString("SUGGESTION"), 1);
            return;
        }
        DeviceInfo[] arrDeviceInfo = DeviceTablePanelUtil.getDevIdOfSelectedRow(this.m_oDeviceTreeTable);
        this.m_oDevCommonManualOpr.recover(arrDeviceInfo, false);
    }

    public void setCam() {
        DCDebugTracer.trace("method cam start");
        DeviceInfo[] arrDeviceInfo = DeviceTablePanelUtil.getDevIdOfSelectedRow(this.m_oDeviceTreeTable);
        this.m_oDevCommonManualOpr.recover(arrDeviceInfo, true);
        DCDebugTracer.trace("method cam end");
    }

    public void telnetTerminal() {
        DeviceInfo[] arrDevInfo = DeviceTablePanelUtil.getDevIdOfSelectedRow(this.m_oDeviceTreeTable);
        if (1 != arrDevInfo.length) {
            return;
        }
        int[] iSelectedDevIds = new int[]{arrDevInfo[0].getDevId()};
        this.m_oDevCommonManualOpr.telnetTerminal(iSelectedDevIds);
    }

    public void cancel() {
        int iVal = this.showConfirmationDlg("CANCEL_OPERATION_CONFIRM_MSG");
        if (0 == iVal) {
            this.m_oArrDevInfo = DeviceTablePanelUtil.getDevIdOfSelectedRow(this.m_oDeviceTreeTable);
            int devCount = this.m_oArrDevInfo.length;
            HashMap<Integer, String> devIDAndOprIDMap = new HashMap<Integer, String>();
            for (int i = 0; i < devCount; ++i) {
                OperationStatus oprStatus = BusyDeviceObjectStore.getInstance().getDeviceProgress(this.m_oArrDevInfo[i].getDevId());
                devIDAndOprIDMap.put(this.m_oArrDevInfo[i].getDevId(), oprStatus.getOperationId());
            }
            int iReqId = DCFrameWorkUtil.getInstallMode();
            this.initializeProgressDialog(iReqId, this.m_oArrDevInfo, 43978);
            try {
                this.m_oDeviceOperationMgr.cancelOperation(iReqId, devIDAndOprIDMap);
            }
            catch (DCException e) {
                this.m_dlg.dispose();
                DCDebugTracer.trace(e);
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DeviceTablePanel.this.m_dlg.setVisible(true);
                }
            });
        }
    }

    public void rollbackSoftware() {
        int iVal = DCOptionPane.showExtConfirmDialog(this, ResourceManager.getInstance().getResString("ROLLBACK_SOFTWARE_CONFIRM_MSG"), ResourceManager.getInstance().getResString("WARNING"), 0, 2);
        if (0 == iVal) {
            this.update(this.getGraphics());
            DeviceInfo[] arrSelectedDevInfo = DeviceTablePanelUtil.getDevIdOfSelectedRow(this.m_oDeviceTreeTable);
            AsnDCOpertionRsp rollbackRsp = this.m_oDeviceOperationMgr.rollbackSoftware(arrSelectedDevInfo);
            if (rollbackRsp == null) {
                DCDebugTracer.trace("rollbackSoftware ->rollbackRsp is null.");
                return;
            }
            if (0 != rollbackRsp.oErrorInfo.iErrorNo.intValue()) {
                DCOptionPane.showMessageDialog((Component)this, BigInteger.valueOf(rollbackRsp.oErrorInfo.iErrorNo.intValue()), ResourceManager.getInstance().getResString("ERROR"), 0);
                return;
            }
            this.updateDevStatus(arrSelectedDevInfo, 37);
        }
    }

    public void deleteDataBase() {
        int iVal;
        String strMsg = ResourceManager.getInstance().getResString("DELETE_DATABASE_CONFIRM_MSG_PTN_RTN");
        String strTitle = ResourceManager.getInstance().getResString("WARNING");
        DeviceInfo[] arrSelectedDevInfo = DeviceTablePanelUtil.getDevIdOfSelectedRow(this.m_oDeviceTreeTable);
        if (DCCommonUtil.isNGWDMandMSTPDevType(arrSelectedDevInfo)) {
            strMsg = ResourceManager.getInstance().getResString("DELETE_DATABASE_CONFIRM_MSG_NGWDM_MSTP");
        }
        if (0 == (iVal = DCOptionPane.showExtConfirmDialog(this, strMsg, strTitle, 2, 2))) {
            this.update(this.getGraphics());
            int iErrorcode = this.m_oDeviceOperationMgr.deleteDataBase(arrSelectedDevInfo);
            if (0 != iErrorcode) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SEND_FAIL"), ResourceManager.getInstance().getResString("ERROR"), 0);
                return;
            }
            this.updateDevStatus(arrSelectedDevInfo, 22);
        }
    }

    public void initializeDatabase() {
        int iVal;
        String strMsg = ResourceManager.getInstance().getResString("INITIALIZE_DATABASE_MSG");
        String strTitle = ResourceManager.getInstance().getResString("WARNING");
        DeviceInfo[] arrSelectedDevInfo = DeviceTablePanelUtil.getDevIdOfSelectedRow(this.m_oDeviceTreeTable);
        if (DCCommonUtil.isNGWDMandMSTPDevType(arrSelectedDevInfo)) {
            strMsg = ResourceManager.getInstance().getResString("INITIALIZE_DATABASE_MSG");
        }
        if (0 == (iVal = DCOptionPane.showExtConfirmDialog(this, strMsg, strTitle, 2, 2))) {
            this.update(this.getGraphics());
            int iErrorcode = this.m_oDeviceOperationMgr.initializeDataBase(arrSelectedDevInfo);
            if (0 != iErrorcode) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SEND_FAIL"), ResourceManager.getInstance().getResString("ERROR"), 0);
                return;
            }
            this.updateDevStatus(arrSelectedDevInfo, 48);
        }
    }

    public void activateDataBase() {
        int iVal = DCOptionPane.showExtConfirmDialog(this, ResourceManager.getInstance().getResString("ACTIVATE_DATABASE_MSG"), ResourceManager.getInstance().getResString("WARNING"), 0, 2);
        if (0 == iVal) {
            DeviceInfo[] arrDeviceInfo = DeviceTablePanelUtil.getDevIdOfSelectedRow(this.m_oDeviceTreeTable);
            DeviceInfo oDeviceInfo = arrDeviceInfo[0];
            if (null == oDeviceInfo || null == oDeviceInfo.getDeviceTypeInfo()) {
                DCDebugTracer.trace("DC::activateDataBase error ,dev or dev type is null");
                return;
            }
            int[] iDeviceIdLst = new int[]{oDeviceInfo.getDevId()};
            IDeviceTypeConfigModel deviceTypeConfigmodel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDeviceInfo.getDeviceTypeInfo(), iDeviceIdLst);
            if (null != deviceTypeConfigmodel) {
                ActivationDataBaseOperation oActivationDataBaseOperation = (ActivationDataBaseOperation)deviceTypeConfigmodel.getCloneOperationObj(0, 20);
                oActivationDataBaseOperation.setSelectedRowDevId(arrDeviceInfo);
                oActivationDataBaseOperation.setDeviceTable(this.m_oDeviceTreeTable);
                oActivationDataBaseOperation.setDeviceTableModel(this.m_oDeviceTreeTableModel);
                oActivationDataBaseOperation.getView(0);
            }
        }
    }

    public void rollbackdatabase() {
        int iVal = this.showConfirmationDlg("ROLLBACK_DATABASE_CONFIRM_MSG");
        if (0 == iVal) {
            this.update(this.getGraphics());
            DeviceInfo[] arrSelectedDevInfo = DeviceTablePanelUtil.getDevIdOfSelectedRow(this.m_oDeviceTreeTable);
            int iErrorcode = this.m_oDeviceOperationMgr.rollbackDataBase(arrSelectedDevInfo);
            if (0 != iErrorcode) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SEND_FAIL"), ResourceManager.getInstance().getResString("ERROR"), 0);
                return;
            }
            this.updateDevStatus(arrSelectedDevInfo, 23);
        }
    }

    @Override
    public void setOperationStartedStatusForDevice(DeviceInfo oDevInfo, int iOperationType) {
        BusyDeviceObjectStore oBusyDeviceStore = BusyDeviceObjectStore.getInstance();
        if (oBusyDeviceStore.isDeviceOperationInProgress(oDevInfo.getDevId())) {
            return;
        }
        OperationStatus oOprStatus = oDevInfo.getDeviceOperationStatus();
        oDevInfo.setDeviceOperationStatus(oOprStatus);
        oOprStatus.setProgress(0);
        oOprStatus.setIsProgress(true);
        oOprStatus.setOperationType(iOperationType);
        oBusyDeviceStore.updateOperationStatusForDevice(oDevInfo, oOprStatus);
        this.handleButtonForProgress(oDevInfo.getDevId(), false);
        this.updateTable();
    }

    @Override
    public synchronized void getVersion() {
        if (0 >= this.m_oDeviceTreeTable.getSelectedRowCount()) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("NO_DEVICES_SELECTED"));
            return;
        }
        if (DeviceTableUtil.isConstainUnsupportNEs(this.m_oDeviceTreeTable)) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("NO_DEVICES_SUPPORT_PATCH_MANAGEMENT"));
            return;
        }
        this.m_oArrDevInfo = DeviceTablePanelUtil.getDevIdOfSelectedRow(this.m_oDeviceTreeTable);
        int iTotalRows = this.m_oArrDevInfo.length;
        if (0 == iTotalRows) {
            return;
        }
        int iReqId = DCFrameWorkUtil.generateRequestId();
        this.initializeProgressDialog(iReqId, this.m_oArrDevInfo, 43829);
        try {
            DCFrameWorkUtil.getDeviceInfoManager().getDevicesVersion(iReqId, this.m_oArrDevInfo);
        }
        catch (DCException e) {
            this.m_dlg.dispose();
            DCDebugTracer.trace(e);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e) {
                    DCDebugTracer.trace(e);
                }
                DeviceTablePanel.this.m_dlg.showDetailInfo();
                ProgressDlg progressDlg = DeviceTablePanel.this.m_dlg;
                DCFrameWorkUtil.getDCModuleManager();
                DCGUIUtil.setInnerModalDialogParent(progressDlg, 1, true);
                DeviceTablePanel.this.m_dlg.setVisible(true);
            }
        });
    }

    public void copyDatabase() {
        int iVal = this.showConfirmationDlg("COPY_DATABASE_CONFIRM_MSG");
        if (0 == iVal) {
            DeviceInfo[] arrSelectedDevInfo = DeviceTablePanelUtil.getDevIdOfSelectedRow(this.m_oDeviceTreeTable);
            int iErrorcode = this.m_oDeviceOperationMgr.copyDataBase(arrSelectedDevInfo);
            if (0 != iErrorcode) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SEND_FAIL"), ResourceManager.getInstance().getResString("ERROR"), 0);
                return;
            }
            this.updateDevStatus(arrSelectedDevInfo, 38);
        }
    }

    public void save() {
        DeviceInfo[] arrDevInfo = DeviceTablePanelUtil.getDevIdOfSelectedRow(this.m_oDeviceTreeTable);
        DeviceInfo oDeviceInfo = arrDevInfo[0];
        int[] iDeviceIdLst = new int[]{oDeviceInfo.getDevId()};
        IDeviceTypeConfigModel deviceTypeConfigmodel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDeviceInfo.getDeviceTypeInfo(), iDeviceIdLst);
        if (null != deviceTypeConfigmodel) {
            ManualSaveOperation oManualSave = (ManualSaveOperation)deviceTypeConfigmodel.getCloneOperationObj(0, 1);
            oManualSave.setManualOperation(this);
            oManualSave.setSelectedDeviceId(DeviceTablePanelUtil.getDevIdOfSelectedRow(this.m_oDeviceTreeTable));
            oManualSave.setDeviceOperationManager(this.m_oDeviceOperationMgr);
            Component oSaveOpView = oManualSave.getView(0);
            if (oSaveOpView instanceof DCModalDialog) {
                DCModalDialog dCModalDialog = (DCModalDialog)((Object)oSaveOpView);
                DCFrameWorkUtil.getDCModuleManager();
                DCGUIUtil.setInnerModalDialogParent(dCModalDialog, 1, true);
            }
            oSaveOpView.setVisible(true);
        }
    }

    @Override
    public void getPatch() {
        if (!this.isCanDoOperation()) {
            return;
        }
        if (DeviceTableUtil.isDifferentDeviceTypesSelectedInTable(this.m_oDeviceTreeTable)) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("GET_PATCH_NOT_SUPPORTED_FOR_DIFFERENT_DEV_TYPE"));
            return;
        }
        DeviceInfo[] arrDevInfo = DeviceTablePanelUtil.getDevIdOfSelectedRow(this.m_oDeviceTreeTable);
        if (null != arrDevInfo && 0 < arrDevInfo.length) {
            int iDevCount = arrDevInfo.length;
            int[] iSelectedDevIds = new int[iDevCount];
            for (int i = 0; i < iDevCount; ++i) {
                iSelectedDevIds[i] = arrDevInfo[i].getDevId();
            }
            this.m_oDeviceMainPanel.openPatchManagement(iSelectedDevIds);
        }
    }

    public void rollbackPatch() {
        int iVal = this.showConfirmationDlg("ROLLBACK_PATCH_CONFIRM_MSG");
        if (0 == iVal) {
            this.update(this.getGraphics());
            DeviceInfo[] arrSelectedDevInfo = DeviceTablePanelUtil.getDevIdOfSelectedRow(this.m_oDeviceTreeTable);
            int iErrorcode = this.m_oDeviceOperationMgr.rollBackPatch(arrSelectedDevInfo);
            if (0 != iErrorcode) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SEND_FAIL"), ResourceManager.getInstance().getResString("ERROR"), 0);
                return;
            }
            this.updateDevStatus(arrSelectedDevInfo, 13);
        }
    }

    public void saveAsBackupFiles() {
        List<Resource> oList = DeviceTablePanelUtil.getSelectedResources(this.m_oDeviceTreeTable);
        if (null != oList) {
            ArrayList<Integer> oDevIDList = new ArrayList<Integer>();
            int iSize = oList.size();
            for (int i = 0; i < iSize; ++i) {
                oDevIDList.add(oList.get(i).getDeviceID());
            }
            SaveBackupFiles oSaveBackupFiles = new SaveBackupFiles(oDevIDList);
            oSaveBackupFiles.saveAsBackupFiles();
        }
    }

    @Override
    public void patchUpdate() {
        if (!DCFrameWorkUtil.getIsSingleClient() && !DCFrameWorkUtil.hasUserOperationPrivilege(43871)) {
            DCOptionPane.showMessageDialog(null, ResourceManager.getInstance().getResString("NO_PRIVILEGE_CREATE_TASK"), ResourceManager.getInstance().getResString("SUGGESTION"), 1);
            return;
        }
        if (this.checkOtherTaskIsCreating()) {
            return;
        }
        DeviceTypeInfo[] arrDeviceTypes = this.m_oDeviceInfoMgr.getAddedDeviceTypes();
        if (0 == arrDeviceTypes.length) {
            ResourceManager oResManager = ResourceManager.getInstance();
            DCOptionPane.showMessageDialog((Component)this, oResManager.getResString(oResManager.getResString("DEVICES_NOT_ADDED")), oResManager.getResString("SYSTEM_INFO_ERROR"), 0);
            return;
        }
        this.openTaskMainPanelFromDevicepanel();
        Task oTaskObj = new Task();
        oTaskObj.setTaskTypeId(2);
        oTaskObj.setDeviceTypes(DeviceTableUtil.getDeviceTypeList(DeviceTablePanelUtil.getSelectedResourcesHs(this.m_oDeviceTreeTable)));
        if (1 == oTaskObj.getDeviceTypesList().size()) {
            oTaskObj.setDeviceTypes(null);
        }
        oTaskObj.setDeviceType(DeviceTableUtil.createDeviceTypeModel(DeviceTablePanelUtil.getSelectedResourcesHs(this.m_oDeviceTreeTable)));
        TaskMenuItemHandlerHelper.createTaskDialog(oTaskObj, true);
    }

    @Override
    public void softwareUpgradeDowngrade() {
        if (!DCFrameWorkUtil.getIsSingleClient() && !DCFrameWorkUtil.hasUserOperationPrivilege(43871)) {
            DCOptionPane.showMessageDialog(null, ResourceManager.getInstance().getResString("NO_PRIVILEGE_CREATE_TASK"), ResourceManager.getInstance().getResString("SUGGESTION"), 1);
            return;
        }
        if (this.checkOtherTaskIsCreating()) {
            return;
        }
        DeviceTypeInfo[] arrDeviceTypes = this.m_oDeviceInfoMgr.getAddedDeviceTypes();
        if (0 == arrDeviceTypes.length) {
            ResourceManager oResManager = ResourceManager.getInstance();
            DCOptionPane.showMessageDialog((Component)this, oResManager.getResString(oResManager.getResString("DEVICES_NOT_ADDED")), oResManager.getResString("SYSTEM_INFO_ERROR"), 0);
            return;
        }
        this.openTaskMainPanelFromDevicepanel();
        Task oTaskObj = new Task();
        oTaskObj.setDeviceTypes(DeviceTableUtil.getDeviceTypeList(DeviceTablePanelUtil.getSelectedResourcesHs(this.m_oDeviceTreeTable)));
        if (1 == oTaskObj.getDeviceTypesList().size()) {
            oTaskObj.setDeviceTypes(null);
        }
        oTaskObj.setDeviceType(DeviceTableUtil.createDeviceTypeModel(DeviceTablePanelUtil.getSelectedResourcesHs(this.m_oDeviceTreeTable)));
        oTaskObj.setTaskTypeId(0);
        TaskMenuItemHandlerHelper.createTaskDialog(oTaskObj, true);
    }

    @Override
    public void addDevices() {
        AddDevicesDlg oAddDeviceDlg = new AddDevicesDlg(false);
        oAddDeviceDlg.setVisible(true);
    }

    public void addOffLineDevices() {
        AddDevicesDlg oAddDeviceDlg = new AddDevicesDlg(true);
        oAddDeviceDlg.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deleteDevices() {
        if (0 > this.m_oDeviceTreeTable.getSelectedRow()) {
            DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("SELETE_Delete_NE"), DCFrameWorkUtil.getLocalizedString("ERROR_MESSAGE"), 0);
            return;
        }
        boolean isDevBusy = false;
        isDevBusy = DeviceTablePanelUtil.isOperationInProgressForAnyDevice(this.m_oDeviceTreeTable);
        if (isDevBusy) return;
        int iConfirm = DCOptionPane.showConfirmDialog((Component)this, this.m_oResourceMgr.getResString("DELETE_DEVICES_CONFIRMATION_MSG"), this.m_oResourceMgr.getResString("CONFIRMATION_DIALOG_TITLE"), 0);
        if (0 != iConfirm) {
            return;
        }
        byte[] byArray = this.m_oSyncObject;
        synchronized (this.m_oSyncObject) {
            List<Resource> oResourceList = DeviceTablePanelUtil.getSelectedResources(this.m_oDeviceTreeTable);
            final DeviceProgressDlg oAddDeviceProgressBarDlg = new DeviceProgressDlg(1, this.m_oSyncObject);
            oAddDeviceProgressBarDlg.setTotalDev(oResourceList.size());
            IDCStandAloneSyncCtrller oStandAloneSyncCtrller = StandAloneSyncCtrller.getInstance();
            try {
                int iReqId = DCFrameWorkUtil.generateRequestId();
                oStandAloneSyncCtrller.deleteDevices(iReqId, oResourceList, true);
            }
            catch (DCException ex) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ex.getErrorCode(), this.m_oResourceMgr.getResString("ERROR"), 0);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
            oAddDeviceProgressBarDlg.setProgressBarState(true);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public synchronized void run() {
                    try {
                        oAddDeviceProgressBarDlg.setVisible(true);
                    }
                    catch (Exception e) {
                        DCDebugTracer.trace(e);
                    }
                }
            });
            return;
        }
    }

    public void softwareStatistics() {
        DeviceInfo[] arrDeviceInfo = DeviceTablePanelUtil.getDevIdOfSelectedRow(this.m_oDeviceTreeTable);
        int iSize = arrDeviceInfo.length;
        if (0 == iSize) {
            return;
        }
        int iReqId = DCFrameWorkUtil.generateRequestId();
        DeviceProgressDlg oProgressDlg = new DeviceProgressDlg(4, this.m_oSyncObject);
        oProgressDlg.setName("DeviceView_DeviceTablePanel_oProgressDlg");
        oProgressDlg.setDeviceIdList(arrDeviceInfo);
        oProgressDlg.setTotalDev(arrDeviceInfo.length);
        oProgressDlg.setProgressDlgId(iReqId);
        oProgressDlg.setProgressBarState(true);
        IDCStandAloneSyncCtrller oStandAloneSyncCtrller = StandAloneSyncCtrller.getInstance();
        try {
            oStandAloneSyncCtrller.getSoftwareStatisticsInfo(iReqId, arrDeviceInfo);
        }
        catch (DCException e) {
            oProgressDlg.dispose();
            DCOptionPane.showMessageDialog((Component)this, e.getMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        oProgressDlg.setVisible(true);
    }

    @Override
    public void exportDevices() {
        DCDebugTracer.trace("DeviceTablePanel#exportDevices start");
        String strDstString = "";
        if (DCFrameWorkUtil.getIsSingleClient()) {
            if (0 > this.m_oDeviceTreeTable.getSelectedRow()) {
                DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("SELETE_Export_NE"), DCFrameWorkUtil.getLocalizedString("ERROR_MESSAGE"), 0);
                return;
            }
            DCFileChooser m_oSaveasFileChooser = new DCFileChooser();
            m_oSaveasFileChooser.setTitle(DCFrameWorkUtil.getLocalizedString("EXPORT_DEVICE_INFO"));
            m_oSaveasFileChooser.setFileSelectionMode(1);
            int returnValue = m_oSaveasFileChooser.showDialog(DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("OK"));
            if (0 != returnValue) {
                return;
            }
            strDstString = m_oSaveasFileChooser.getSelectedFile().getAbsolutePath();
        } else {
            SystemManager temp = new SystemManager();
            strDstString = temp.getSystemRootDirectory();
            if (strDstString.startsWith("/")) {
                if (strDstString.endsWith("/")) {
                    strDstString = strDstString + "dc/update";
                } else {
                    strDstString = strDstString + "/";
                    strDstString = strDstString + "dc/update";
                }
            } else if (strDstString.endsWith("/")) {
                strDstString = strDstString + DCConstants.UPDATE;
            } else {
                strDstString = strDstString + File.separator;
                strDstString = strDstString + DCConstants.UPDATE;
            }
        }
        DeviceInfo[] arrDeviceInfo = DeviceTablePanelUtil.getDevIdOfSelectedRow(this.m_oDeviceTreeTable);
        AsnDCExportDeviceReq oReq = DeviceTablePanelUtil.getExportDeviceReq(strDstString, arrDeviceInfo);
        IDeviceInfoSyncCtrller oSyncController = DeviceInfoSyncCtrller.getInstance();
        oSyncController.exportDevices(oReq);
        DCDebugTracer.trace("DeviceTablePanel#exportDevices end..");
    }

    @Override
    public void exportDevicesTemplate() {
        this.isExportDevTemplate = true;
        DCSaveFileChooser oFileChooserDialog = DeviceTablePanelUtil.initExportDialog(this.isExportDevTemplate);
        if (null == oFileChooserDialog) {
            return;
        }
        this.isExportDevTemplate = false;
        int iRetVal = -1;
        iRetVal = oFileChooserDialog.showSaveDialog(DCFrameWorkUtil.getMainFrame());
        if (iRetVal != 0) {
            return;
        }
        StringBuffer strFileName = new StringBuffer(oFileChooserDialog.getSelectedFile().getAbsolutePath());
        if (strFileName.length() > 1 && !strFileName.toString().toLowerCase(DCResourceMng.getInstance().getLocale()).endsWith(".csv")) {
            strFileName.append(".csv");
        }
        String oldFileName = DCConstants.S_SERIES_DEV_TEMPLATE_CSV_FILE_NAME;
        String oldpath = ConfigurationInfo.getInstance().getStyleDirectory();
        String newpath = oFileChooserDialog.getSelectFilePath();
        int index = newpath.lastIndexOf("\\");
        newpath = newpath.substring(0, index);
        index = oFileChooserDialog.getFullFileName().lastIndexOf("\\");
        String newFileName = oFileChooserDialog.getFullFileName();
        if (FileUtil.copyFile(oldpath, newpath, oldFileName, newFileName = newFileName.substring(index + 1, newFileName.length()))) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("FILE_EXPORT_SUCCESSFULLY"), ResourceManager.getInstance().getResString("SUGGESTION"), 1);
        } else {
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SAVE_AS_OPERATION_FAILED"));
        }
    }

    public void mimicPackageUpgrade() {
        if (!DCFrameWorkUtil.getIsSingleClient() && !DCFrameWorkUtil.hasUserOperationPrivilege(43871)) {
            DCOptionPane.showMessageDialog(null, ResourceManager.getInstance().getResString("NO_PRIVILEGE_CREATE_TASK"), ResourceManager.getInstance().getResString("SUGGESTION"), 1);
            return;
        }
        if (this.checkOtherTaskIsCreating()) {
            return;
        }
        this.openTaskMainPanelFromDevicepanel();
        Task oTaskObj = new Task();
        oTaskObj.setTaskTypeId(3);
        oTaskObj.setDeviceTypes(DeviceTableUtil.getDeviceTypeList(DeviceTablePanelUtil.getSelectedResourcesHs(this.m_oDeviceTreeTable)));
        if (1 == oTaskObj.getDeviceTypesList().size()) {
            oTaskObj.setDeviceTypes(null);
        }
        oTaskObj.setDeviceType(DeviceTableUtil.createDeviceTypeModel(DeviceTablePanelUtil.getSelectedResourcesHs(this.m_oDeviceTreeTable)));
        TaskMenuItemHandlerHelper.createTaskDialog(oTaskObj, true);
    }

    public void packageUpgradedowngradetask() {
        if (!DCFrameWorkUtil.getIsSingleClient() && !DCFrameWorkUtil.hasUserOperationPrivilege(43871)) {
            DCOptionPane.showMessageDialog(null, ResourceManager.getInstance().getResString("NO_PRIVILEGE_CREATE_TASK"), ResourceManager.getInstance().getResString("SUGGESTION"), 1);
            return;
        }
        if (this.checkOtherTaskIsCreating()) {
            return;
        }
        this.openTaskMainPanelFromDevicepanel();
        Task oTaskObj = new Task();
        oTaskObj.setTaskTypeId(4);
        oTaskObj.setDeviceTypes(DeviceTableUtil.getDeviceTypeList(DeviceTablePanelUtil.getSelectedResourcesHs(this.m_oDeviceTreeTable)));
        if (1 == oTaskObj.getDeviceTypesList().size()) {
            oTaskObj.setDeviceTypes(null);
        }
        oTaskObj.setDeviceType(DeviceTableUtil.createDeviceTypeModel(DeviceTablePanelUtil.getSelectedResourcesHs(this.m_oDeviceTreeTable)));
        TaskMenuItemHandlerHelper.createTaskDialog(oTaskObj, true);
    }

    public void packageDiffusionUpgradeDowngrade() {
        if (!DCFrameWorkUtil.getIsSingleClient() && !DCFrameWorkUtil.hasUserOperationPrivilege(43871)) {
            DCOptionPane.showMessageDialog(null, ResourceManager.getInstance().getResString("NO_PRIVILEGE_CREATE_TASK"), ResourceManager.getInstance().getResString("SUGGESTION"), 1);
            return;
        }
        if (this.checkOtherTaskIsCreating()) {
            return;
        }
        this.openTaskMainPanelFromDevicepanel();
        Task oTaskObj = new Task();
        oTaskObj.setTaskTypeId(5);
        oTaskObj.setDeviceTypes(DeviceTableUtil.getDeviceTypeList(DeviceTablePanelUtil.getSelectedResourcesHs(this.m_oDeviceTreeTable)));
        if (1 == oTaskObj.getDeviceTypesList().size()) {
            oTaskObj.setDeviceTypes(null);
        }
        oTaskObj.setDeviceType(DeviceTableUtil.createDeviceTypeModel(DeviceTablePanelUtil.getSelectedResourcesHs(this.m_oDeviceTreeTable)));
        ArrayList<DeviceType> oDeviceTypes = new ArrayList<DeviceType>();
        List<Resource> resList = DeviceTablePanelUtil.getSelectedResources(this.m_oDeviceTreeTable);
        int iSize = resList.size();
        for (int i = 0; i < iSize; ++i) {
            DeviceType oDeviceType = DeviceModelAdapter.populateDeviceTypeFromDeviceID(resList.get(i).getDeviceID());
            if (oDeviceTypes.size() == 0) {
                oDeviceTypes.add(oDeviceType);
                continue;
            }
            if (oDeviceTypes.contains(oDeviceType)) continue;
            oDeviceTypes.add(oDeviceType);
        }
        if (oDeviceTypes.size() > 0) {
            oTaskObj.setDeviceTypes(oDeviceTypes);
        }
        TaskMenuItemHandlerHelper.createTaskDialog(oTaskObj, true);
    }

    @Override
    public void searchDevice() {
        SearchDeviceDlg oSearchDeviceDlg = null;
        try {
            oSearchDeviceDlg = new SearchDeviceDlg();
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog((Component)this, e.getMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        oSearchDeviceDlg.setVisible(true);
    }

    public void disposePanel() {
        DCDebugTracer.trace("DeviceTablePanel::disposepanel::begin");
        if (null != this.m_oListeners) {
            int iListenerCount = this.m_oListeners.size();
            for (int i = 0; i < iListenerCount; ++i) {
                this.removeDevInfoSelectionListener((IDeviceInfoSelectionListener)this.m_oListeners.get(i));
            }
            this.m_oListeners = null;
        }
        if (null != this.m_oDeviceTableScrollPane) {
            this.m_oDeviceTableScrollPane.removeAll();
            this.m_oDeviceTableScrollPane = null;
        }
        if (null != this.m_oTableManager) {
            this.m_oTableManager.cleanUp();
            this.m_oTableManager = null;
        }
        if (null != this.m_oButtonPanel) {
            this.m_oButtonPanel.disposePanel();
            this.m_oButtonPanel = null;
        }
        if (null != this.m_oDeviceTreeTable) {
            this.m_oDeviceTreeTable.doClean();
            this.m_oDeviceTreeTable = null;
        }
        this.m_oDeviceTree = null;
        this.m_oDeviceTreeTableModel = null;
        if (null != this.m_dlg) {
            this.m_dlg.dispose();
        }
        this.m_dlg = null;
        this.m_oDeviceMainPanel = null;
        this.m_oDeviceInfoMgr = null;
        this.m_oResourceMgr = null;
        this.m_oDeviceOperationMgr = null;
        this.m_devInfoColumnInfo = null;
        this.m_oDevCommonManualOpr = null;
        this.removeAll();
        DCDebugTracer.trace("DeviceTablePanel::disposepanel::end");
    }

    @Override
    public void importDevices() {
        DCFileChooser oFileChooserDialog = DeviceTablePanelUtil.getFileChooserDlg();
        String strFileName = DeviceTablePanelUtil.getFileName(oFileChooserDialog, this);
        if (null == strFileName || 0 == strFileName.length()) {
            return;
        }
        List<Object> oResList = new ArrayList(0);
        List<Resource> oDMSResList = null;
        try {
            oResList = DeviceTablePanelUtil.getT2000ResourceList(strFileName);
        }
        catch (IOException e) {
            DCDebugTracer.trace(e);
            return;
        }
        DeviceProgressDlg oAddDeviceProgressBarDlg = new DeviceProgressDlg(0, this.m_oSyncObject);
        if (null == oResList || 0 == oResList.size()) {
            try {
                oDMSResList = DeviceTablePanelUtil.getDMSResourceList(strFileName, oAddDeviceProgressBarDlg);
                if (oDMSResList == null || oDMSResList.size() == 0) {
                    oAddDeviceProgressBarDlg = null;
                    return;
                }
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
                oAddDeviceProgressBarDlg = null;
                return;
            }
            catch (DCException e) {
                DCDebugTracer.trace(e);
                oAddDeviceProgressBarDlg = null;
                DCOptionPane.showMessageDialog((Component)this, e.getMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
                return;
            }
        }
        IDCStandAloneSyncCtrller oStandAloneSyncCtrller = StandAloneSyncCtrller.getInstance();
        try {
            int iReqID = DCFrameWorkUtil.generateRequestId();
            if (oDMSResList != null) {
                oAddDeviceProgressBarDlg.setProgressDlgId(iReqID);
                oStandAloneSyncCtrller.addDevice(iReqID, oDMSResList, 1);
                oAddDeviceProgressBarDlg.setTotalDev(oDMSResList.size());
            } else {
                oStandAloneSyncCtrller.addDevice(iReqID, -1, -1, oResList);
                oAddDeviceProgressBarDlg.setTotalDev(oResList.size());
            }
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
            oAddDeviceProgressBarDlg = null;
            DCOptionPane.showMessageDialog((Component)this, e.getErrorCode(), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        oAddDeviceProgressBarDlg.setProgressBarState(true);
        oAddDeviceProgressBarDlg.getCancelBtn().setEnabled(true);
        oAddDeviceProgressBarDlg.setVisible(true);
    }

    public void setAutoLoadPolicy() {
        this.m_oArrDevInfo = DeviceTablePanelUtil.getDevIdOfSelectedRow(this.m_oDeviceTreeTable);
        int iTotalRows = this.m_oArrDevInfo.length;
        if (0 >= iTotalRows) {
            return;
        }
        int iReqId = DCFrameWorkUtil.generateRequestId();
        this.initializeProgressDialog(iReqId, this.m_oArrDevInfo, 43974);
        try {
            this.m_oDeviceOperationMgr.setAutoLoadPolicy(iReqId, this.m_iArrdeviceIds);
        }
        catch (DCException e) {
            this.m_dlg.dispose();
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DeviceTablePanel.this.m_dlg.setVisible(true);
            }
        });
    }

    public void print() {
        DeviceTableUtil.printDeviceInformation(this.m_oDeviceTreeTable);
    }

    public void setOSPFStatus() {
        int iVal = DCOptionPane.showExtConfirmDialog(this, ResourceManager.getInstance().getResString("SET_OSPF_STATUS_CONFIRM_MSG"), ResourceManager.getInstance().getResString("WARNING"), 0, 2);
        if (0 == iVal) {
            DeviceInfo[] arrDeviceIds = DeviceTablePanelUtil.getDevIdOfSelectedRow(this.m_oDeviceTreeTable);
            int iTotalRows = arrDeviceIds.length;
            if (iTotalRows == 0) {
                return;
            }
            LinkedList<Integer> devIDLst = new LinkedList<Integer>();
            for (int i = 0; i < arrDeviceIds.length; ++i) {
                devIDLst.add(arrDeviceIds[i].getDevId());
            }
            final ConfigOSPFSetDlg ospfDlg = new ConfigOSPFSetDlg(this, devIDLst);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ospfDlg.setVisible(true);
                }
            });
        }
    }

    public void handleOSPFStatusResponse(AsnDCOSPFStatusNotify asnDCOSPFStatusNotify) {
        if (null == asnDCOSPFStatusNotify || null == this.m_oCommonProgressDlg || this.m_oCommonProgressDlg.getProgressDlgId() != asnDCOSPFStatusNotify.oReqID.intValue()) {
            return;
        }
        final int iDevID = asnDCOSPFStatusNotify.iDevID.intValue();
        int iErrorCode = asnDCOSPFStatusNotify.oErrorInfo.iErrorNo.intValue();
        String strErrMsg = ErrorCodeReader.getInstance().getErrorDesc(asnDCOSPFStatusNotify.oErrorInfo.iErrorNo);
        if (null != asnDCOSPFStatusNotify.oErrorInfo.strResult) {
            strErrMsg = new String(asnDCOSPFStatusNotify.oErrorInfo.strResult);
        }
        final String sErrMgs = strErrMsg;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DeviceTablePanel.this.refreshProgressDlg(iDevID, sErrMgs);
            }
        });
        boolean bOpenOspf = asnDCOSPFStatusNotify.bOpenOSPF;
        int iOperationType = -1;
        iOperationType = bOpenOspf ? 34 : 35;
        this.refreshDeviceOperationResult(iDevID, iOperationType, iErrorCode, strErrMsg);
    }

    public void deleteMemory() {
        int iVal = DCOptionPane.showExtConfirmDialog(this, ResourceManager.getInstance().getResString("DELETE_FILES_FROM_DEVICE_CONFIRM"), ResourceManager.getInstance().getResString("WARNING"), 0, 2);
        if (0 == iVal) {
            DeviceInfo deviceInfo = DeviceTablePanelUtil.getSelectedDevInfoLst(this.m_oDeviceTreeTable);
            DeviceInfo oTmpDevInfo = DeviceInfoManagerImpl.getInstance().getDevice(deviceInfo.getDevId());
            if (!DeviceInfoUtil.isSupportUpgradeMode(oTmpDevInfo, 4096)) {
                this.m_bCancelPressed = false;
                boolean isTelnet = this.refreshUpmode(new DeviceInfo[]{deviceInfo});
                if (null == this.m_oValidationProgressDlg) {
                    return;
                }
                if (!isTelnet) {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("NO_DEVICES_SUPPORT_PATCH_MANAGEMENT"), DCFrameWorkUtil.getLocalizedString("SUGGESTION"), 1);
                    return;
                }
            }
            Resource m_oResource = new Resource();
            m_oResource.setDeviceID(deviceInfo.getDevId());
            m_oResource.setDeviceName(deviceInfo.getDevName());
            m_oResource.setDeviceIP(deviceInfo.getDevIPAddress());
            this.m_oResList = new ArrayList(0);
            this.m_oResList.add(m_oResource);
            ArrayList oFileList = new ArrayList(0);
            HashMap<Integer, List<String>> oFileInfoMap = new HashMap<Integer, List<String>>();
            oFileInfoMap.put(m_oResource.getDeviceID(), oFileList);
            CheckDeviceMemoryUtil checkDevMemoryUtil = new CheckDeviceMemoryUtil(oFileInfoMap);
            this.m_oDeviceMemoryInfoMap = checkDevMemoryUtil.checkDeviceMemory();
            if (this.m_oDeviceMemoryInfoMap.size() > 0) {
                this.showDeleteDeviceFileDialog();
            }
        }
    }

    @Override
    public void exportCheckItemTemp() {
        TempletExportUtil exportCheckItem = new TempletExportUtil(ResourceManager.getInstance().getResString("EXPORT_CHECK_ITEM_MODEL_ORG"), ResourceManager.getInstance().getResString("EXPORT_CHECK_ITEM_MODEL"), ResourceManager.getInstance().getResString("EXPORT_CHECK_ITEM_MODEL"));
        exportCheckItem.exportTemple();
    }

    private boolean isCanDoOperation() {
        if (0 >= this.m_oDeviceTreeTable.getSelectedRowCount()) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("NO_DEVICES_SELECTED"));
            return false;
        }
        DeviceManagementPopupMenuManager oPopupMenuMgr = this.getDevicePopupMgr();
        if (oPopupMenuMgr.isOperationInProgressForAnyDevice()) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("INFO_FOR_PART_DEVICES_IN_PROGRESS_NOTICE"));
            return false;
        }
        if (DeviceTableUtil.isConstainUnsupportNEs(this.m_oDeviceTreeTable)) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("NO_DEVICES_SUPPORT_PATCH_MANAGEMENT"));
            return false;
        }
        return true;
    }
}

