/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceview.devicetable;

import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfoLst;
import com.huawei.dc.common.asndatacenter.AsnStatusEnum;
import com.huawei.dc.common.components.dialog.ProgressDlg;
import com.huawei.dc.common.components.treetable.model.DeviceTreeTableModel;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableNodeCellData;
import com.huawei.dc.common.components.treetable.view.JSortTreeTable;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.event.DCDeviceTreeNodeSelectionEventObject;
import com.huawei.dc.common.framework.event.DCEventObject;
import com.huawei.dc.common.framework.interfaces.DCTreeEventListener;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.tree.SubMapNodeInfo;
import com.huawei.dc.common.tree.TreeNodeInfo;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.MenuUtil;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.controller.DeviceOperationProgressController;
import com.huawei.dc.devicemanagement.deviceview.common.DeviceIDDataObject;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.DeviceSelectionEvent;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceTablePanel;
import com.huawei.dc.devicemanagement.event.DeviceInfoEvent;
import com.huawei.dc.devicemanagement.event.DeviceInfoNotifier;
import com.huawei.dc.devicemanagement.event.IDeviceInfoListener;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubMapInfo;
import com.huawei.dc.deviceoperation.IDeviceOperationManager;
import com.huawei.dc.deviceoperation.deviceconfigchange.DeviceConfigEventReceiver;
import com.huawei.dc.deviceoperation.deviceconfigchange.IDeviceConfigChangeListener;
import com.huawei.dc.deviceoperation.util.OperationStatus;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.standalone.StandAloneDomainInfo;
import com.swimap.iview.framework.menumanagement.MenuManager;
import java.math.BigInteger;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.tree.TreePath;

public class DeviceTableManager
implements IDeviceConfigChangeListener,
DCTreeEventListener,
IDeviceInfoListener {
    public static final int DEVICE_TABLE_OPERATION_STATUS_COLUMN = 5;
    private DeviceTablePanel m_oDeviceTablePanel;
    private DeviceTreeTableModel m_oDeviceTreeTableModel;
    private TreeTableNode m_oRootNode;
    private DCDeviceTreeNodeSelectionEventObject m_oDeviceTreeSelectionEvent;
    private IDeviceInfoManager m_oDeviceInfoManager;
    private IDeviceOperationManager m_oDeviceOperationMgr;
    private ResourceManager m_oResourceManager;
    public static final int DEVICE_TABLE_DEVICEID_COLUMN = 0;
    public static final int DEVICE_TABLE_DEVICENAME_COLUMN = 1;
    public static final int DEVICE_TABLE_DEVICEIP_COLUMN = 2;
    public static final int DEVICE_TABLE_TYPE_COLUMN = 3;
    public static final int DEVICE_TABLE_VERSION_COLUMN = 4;
    public static final int DEVICE_TABLE_STATUS_COLUMN = 5;
    public static final int DEVICE_NOTIFICATION_TYPE_ADD = 0;
    public static final int DEVICE_NOTIFICATION_TYPE_DELETE = 1;
    public static final int DEVICE_NOTIFICATION_TYPE_MODIFY = 2;
    private static final String DEVICE_ICON_PARENT = "reboottask.gif";
    private static final String DEVICE_ICON_NORMAL = "ic_device.gif";
    private static final String DEVICE_ICON_CHILD = "ic_frame.gif";
    private static final int BACKUP_OPERATION = 3;
    private boolean m_bIgnoreNotifications = false;
    private final long firstOpenClientTime;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.firstOpenClientTime ^ this.firstOpenClientTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceTableManager other = (DeviceTableManager)obj;
        return this.firstOpenClientTime == other.firstOpenClientTime;
    }

    public DeviceTableManager(DeviceTablePanel oDeviceTablePanel, IDeviceInfoManager oDeviceInfoManager, IDeviceOperationManager oDeviceOperationManager) {
        this.m_oDeviceTablePanel = oDeviceTablePanel;
        this.firstOpenClientTime = System.nanoTime();
        this.m_oDeviceOperationMgr = oDeviceOperationManager;
        this.m_oDeviceTreeTableModel = this.m_oDeviceTablePanel.getDeviceTreeTableModel();
        this.m_oRootNode = this.m_oDeviceTreeTableModel.getRoot();
        this.m_oDeviceInfoManager = oDeviceInfoManager;
        this.m_oResourceManager = ResourceManager.getInstance();
    }

    public void initializeTableManager() {
        DeviceInfo[] oDeviceList = this.getSupportedDevInfos(this.m_oDeviceInfoManager.getDevices());
        if (!DCFrameWorkUtil.getIsClientFrmTopo()) {
            this.populateTableModel(oDeviceList);
        } else {
            DCFrameWorkUtil.getDeviceTreePanel().getDeviceTree().setSelectionRow(0);
            this.updateDeviceInfoLst(oDeviceList);
        }
        DeviceInfoNotifier.getInstance().addDeviceNotificationListener(this);
        this.registerForServerNotifications();
        this.registerForDeviceTreeNotifications();
    }

    private void updateDeviceInfoLst(DeviceInfo[] oDeviceList) {
        int iNosDevices = oDeviceList.length;
        int[] arrDevIds = DCFrameWorkUtil.getDeviceIds();
        if (null == arrDevIds) {
            return;
        }
        int iNosSelectedDev = arrDevIds.length;
        ArrayList<DeviceInfo> oDevInfoLst = new ArrayList<DeviceInfo>(iNosSelectedDev);
        block0: for (int i = iNosDevices - 1; i >= 0; --i) {
            DeviceInfo oDevInfo = oDeviceList[i];
            for (int j = 0; j < iNosSelectedDev; ++j) {
                int iDevId = arrDevIds[j];
                if (iDevId != oDevInfo.getDevId()) continue;
                oDevInfoLst.add(oDevInfo);
                continue block0;
            }
        }
        DeviceInfo[] arrDevInfo = oDevInfoLst.toArray(new DeviceInfo[0]);
        this.populateTableModel(arrDevInfo);
    }

    public void registerForServerNotifications() {
        DeviceConfigEventReceiver.getInstance().resigterForConfigChangeEvent(this);
        this.m_oDeviceOperationMgr.registerNotification(this);
        DeviceOperationProgressController.getInstance().addDeviceNotificationListener(this);
    }

    public void registerForDeviceTreeNotifications() {
        this.m_oDeviceTablePanel.getDeviceTreePanel().addDCEventListener(this);
    }

    public synchronized void populateTableModel(DeviceInfo[] deviceInfoList) {
        this.m_oRootNode.removeAllChildren();
        if (this.isNullDevies(deviceInfoList)) {
            this.m_oDeviceTablePanel.displayStatusbarMessageForNoDevice();
            if (null != this.m_oDeviceTablePanel.getDeviceTreeTable()) {
                this.m_oDeviceTablePanel.getDeviceTreeTable().repaint();
            }
            this.m_oDeviceTablePanel.refreshTable();
            return;
        }
        for (int index = 0; index < deviceInfoList.length; ++index) {
            if (null == deviceInfoList[index]) continue;
            this.addDeviceToTable(deviceInfoList[index]);
        }
        try {
            this.wait(100L);
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
        }
        this.m_oDeviceTablePanel.getDeviceTreeTable().updateUI();
        this.m_oDeviceTablePanel.refreshTable();
    }

    public TreeTableNodeCellData getHGMPImage(DeviceInfo deviceInfo) {
        int iRoleTypeEnum = deviceInfo.getRoleType();
        TreeTableNodeCellData m_oDeviceNodeData = new TreeTableNodeCellData();
        switch (iRoleTypeEnum) {
            case 0: {
                m_oDeviceNodeData.setNodeClosedIcon(DEVICE_ICON_NORMAL);
                m_oDeviceNodeData.setNodeOpenedIcon(DEVICE_ICON_NORMAL);
                m_oDeviceNodeData.setNodeLeafIcon(DEVICE_ICON_NORMAL);
                break;
            }
            case 1: {
                m_oDeviceNodeData.setNodeClosedIcon(DEVICE_ICON_PARENT);
                m_oDeviceNodeData.setNodeOpenedIcon(DEVICE_ICON_PARENT);
                m_oDeviceNodeData.setNodeLeafIcon(DEVICE_ICON_PARENT);
                break;
            }
            case 2: {
                m_oDeviceNodeData.setNodeClosedIcon(DEVICE_ICON_CHILD);
                m_oDeviceNodeData.setNodeOpenedIcon(DEVICE_ICON_CHILD);
                m_oDeviceNodeData.setNodeLeafIcon(DEVICE_ICON_CHILD);
                break;
            }
        }
        m_oDeviceNodeData.setCellDataValue(new DeviceIDDataObject(deviceInfo.getDevId()));
        return m_oDeviceNodeData;
    }

    private void addDeviceToTable(DeviceInfo deviceInfo) {
        TreeTableNode oNode = new TreeTableNode(deviceInfo);
        this.m_oRootNode.add(oNode);
    }

    private void updateTableForNotification(int iType, AsnDCDeviceSubmapNtfnInfo oAsnNotification) {
        int iRoleType;
        DeviceInfo oDevInfo;
        if (oAsnNotification == null) {
            DCDebugTracer.trace("DC:: DeviceTableManager::updateTableForNotification->oAsnNotification= null");
            return;
        }
        DeviceInfo oDeviceInfo = null;
        int iDevId = -1;
        if (null != oAsnNotification.oDeviceInfo) {
            iDevId = oAsnNotification.oDeviceInfo.iDevId.intValue();
        }
        DCDebugTracer.trace("DC:: DeviceTableManager::updateTableForNotification->iType= " + iType);
        if (DCFrameWorkUtil.getIsSingleClient() && 2 == StandAloneDomainInfo.getInstance().getSelectedDomain() && null != (oDevInfo = this.m_oDeviceInfoManager.getDevice(iDevId)) && 1 != (iRoleType = oDevInfo.getRoleType()) && 2 != iRoleType) {
            return;
        }
        switch (iType) {
            case 0: {
                MenuManager oMenuManager;
                oDeviceInfo = this.m_oDeviceInfoManager.getDevice(iDevId);
                this.addDeviceFromNotification(oDeviceInfo);
                if (DCFrameWorkUtil.getDeviceTablePanel().getTreeTable().getRowCount() == 0) {
                    oMenuManager = DCFrameWorkUtil.getDCMenuManager();
                    MenuUtil.enableMenuItem(oMenuManager.getMenuItem("neManageMenu", "neManage", "ModifyDevice"), true);
                    MenuUtil.enableMenuItem(oMenuManager.getMenuItem("neManageMenu", "neManage", "DeleteDevices"), true);
                    MenuUtil.enableMenuItem(oMenuManager.getMenuItem("neManageMenu", "neManage", "ExportDevices"), true);
                }
                DCDebugTracer.trace("DC:: DeviceTableManager::updateTableForNotification->ADD_DEVICE end ");
                break;
            }
            case 1: {
                MenuManager oMenuManager;
                this.removeDeviceFromTableModel(iDevId);
                if (DCFrameWorkUtil.getDeviceTablePanel().getTreeTable().getRowCount() == 1) {
                    oMenuManager = DCFrameWorkUtil.getDCMenuManager();
                    MenuUtil.enableMenuItem(oMenuManager.getMenuItem("neManageMenu", "neManage", "ModifyDevice"), false);
                    MenuUtil.enableMenuItem(oMenuManager.getMenuItem("neManageMenu", "neManage", "DeleteDevices"), false);
                    MenuUtil.enableMenuItem(oMenuManager.getMenuItem("neManageMenu", "neManage", "ExportDevices"), false);
                }
                DCDebugTracer.trace("DC:: DeviceTableManager::updateTableForNotification->DELETE_DEVICE end ");
                break;
            }
            case 2: {
                if (null != oAsnNotification.oAsnDCSubMapInfo) {
                    this.modifyTableModelForSubmapChange(oAsnNotification, true);
                } else {
                    oDeviceInfo = this.m_oDeviceInfoManager.getDevice(iDevId);
                    this.modifyDeviceInTableModel(oDeviceInfo);
                }
                DCDebugTracer.trace("DC:: DeviceTableManager::updateTableForNotification->MODIFY_DEVICE end ");
                break;
            }
            case 5: {
                this.modifyTableModelForSubmapChange(oAsnNotification, false);
                DCDebugTracer.trace("DC:: DeviceTableManager::updateTableForNotification->MODIFY_SUBMAP end ");
                break;
            }
        }
    }

    private void modifyTableModelForSubmapChange(AsnDCDeviceSubmapNtfnInfo oAsnNotification, boolean bIsDeviceChange) {
        block11: {
            SubMapInfo oCurrentSubmapInTree;
            block10: {
                if (null == this.m_oDeviceTreeSelectionEvent) {
                    return;
                }
                TreeNodeInfo oNode = (TreeNodeInfo)this.m_oDeviceTreeSelectionEvent.getSource();
                if (0 != oNode.m_iNodeType) {
                    return;
                }
                oCurrentSubmapInTree = this.m_oDeviceInfoManager.getSubmapForID(oNode.m_oSubMapNodeInfo.m_submapId);
                if (null == oCurrentSubmapInTree || !bIsDeviceChange && null == oAsnNotification.oAsnDCSubMapInfo) {
                    return;
                }
                if (!bIsDeviceChange || null == oAsnNotification.oDeviceInfo) break block10;
                int iDeviceId = oAsnNotification.oDeviceInfo.iDevId.intValue();
                DeviceInfo oMovedDevice = this.m_oDeviceInfoManager.getDevice(iDeviceId);
                boolean bDevicePresentInCurrentSubmap = this.m_oDeviceInfoManager.isDevicePresentInSubMap(iDeviceId, oCurrentSubmapInTree);
                if (bDevicePresentInCurrentSubmap) {
                    this.addDeviceFromNotification(oMovedDevice);
                } else {
                    this.removeDeviceFromTableModel(iDeviceId);
                }
                break block11;
            }
            if (bIsDeviceChange) break block11;
            SubMapInfo oModifiedSubmap = this.m_oDeviceInfoManager.getSubmapForID(new String(oAsnNotification.oAsnDCSubMapInfo.strSubMapID));
            DeviceInfo[] arrModifiedDevices = this.m_oDeviceInfoManager.getDevicesRecursivelyInSubMap(oModifiedSubmap);
            if (0 >= arrModifiedDevices.length) {
                return;
            }
            if (null != this.m_oDeviceInfoManager.getSubmapForID(oModifiedSubmap.m_strSubMapID, oCurrentSubmapInTree)) {
                for (int i = 0; i < arrModifiedDevices.length; ++i) {
                    this.addDeviceFromNotification(arrModifiedDevices[i]);
                }
            } else {
                for (int i = 0; i < arrModifiedDevices.length; ++i) {
                    this.removeDeviceFromTableModel(arrModifiedDevices[i].getDevId());
                }
            }
        }
    }

    private void addDeviceFromNotification(DeviceInfo oDeviceInfo) {
        if (null == oDeviceInfo) {
            return;
        }
        TreeTableNode oNodeAlreadyPresent = this.m_oDeviceTreeTableModel.getNodeForCellInColumn(new DeviceIDDataObject(oDeviceInfo.getDevId()), 0);
        if (null == oNodeAlreadyPresent) {
            boolean bDisplayForCurrentTreeSelection;
            if (!DCFrameWorkUtil.getIsSingleClient() && !(bDisplayForCurrentTreeSelection = this.checkIfDeviceNeedsToBeAdded(oDeviceInfo))) {
                return;
            }
            this.addDeviceToTable(oDeviceInfo);
            this.m_oDeviceTablePanel.updateTableUI();
            this.m_oDeviceTablePanel.refreshSelectedDevCountLabel();
        } else {
            oNodeAlreadyPresent.setUserObject(oDeviceInfo);
            this.m_oDeviceTablePanel.refreshTable();
        }
    }

    private synchronized void removeDeviceFromTableModel(int deviceId) {
        DCDebugTracer.trace("start remove device from device table panel " + deviceId);
        DeviceIDDataObject oCellToBeSearched = new DeviceIDDataObject(deviceId);
        TreeTableNode oNodeAlreadyPresent = null;
        if (null != this.m_oDeviceTreeTableModel) {
            oNodeAlreadyPresent = this.m_oDeviceTreeTableModel.getNodeForCellInColumn(oCellToBeSearched, 0);
        }
        if (null == oNodeAlreadyPresent) {
            DCDebugTracer.trace("devcie id not found " + deviceId);
            return;
        }
        JSortTreeTable oDeviceTreeTable = this.m_oDeviceTablePanel.getDeviceTreeTable();
        int[] arrSelectedRows = oDeviceTreeTable.getSelectedRows();
        if (null != arrSelectedRows && 0 < arrSelectedRows.length) {
            TreeTableNode oNode;
            TreePath oPath;
            for (int i = 0; i < arrSelectedRows.length && (null == (oPath = oDeviceTreeTable.getTree().getPathForRow(arrSelectedRows[i])) || oNodeAlreadyPresent != (oNode = (TreeTableNode)oPath.getLastPathComponent())); ++i) {
            }
        }
        oNodeAlreadyPresent.removeFromParent();
        oNodeAlreadyPresent = null;
        if (!DCFrameWorkUtil.getIsSingleClient()) {
            this.m_oDeviceTablePanel.refreshTable();
        }
    }

    private void modifyDeviceInTableModel(DeviceInfo deviceInfo) {
        DeviceIDDataObject oCellToBeSearched = new DeviceIDDataObject(deviceInfo.getDevId());
        TreeTableNode oNodeAlreadyPresent = this.m_oDeviceTreeTableModel.getNodeForCellInColumn(oCellToBeSearched, 0);
        if (null == oNodeAlreadyPresent) {
            return;
        }
        oNodeAlreadyPresent.setUserObject(deviceInfo);
    }

    @Override
    public void onTreeNodeSelection(DCEventObject oEventObject) {
        if (this.m_bIgnoreNotifications || !(oEventObject.getSource() instanceof TreeNodeInfo) || !(oEventObject instanceof DCDeviceTreeNodeSelectionEventObject)) {
            DCDebugTracer.trace("DC::DEV DeviceTableManager ignore tree node click event " + this.m_bIgnoreNotifications);
            return;
        }
        this.m_oDeviceTreeSelectionEvent = (DCDeviceTreeNodeSelectionEventObject)oEventObject;
        this.refreshTreeTableForTreeSelectionEvent();
    }

    private void refreshTreeTableForTreeSelectionEvent() {
        if (null == this.m_oDeviceTreeSelectionEvent) {
            return;
        }
        DeviceInfo[] oDeviceList = this.getSupportedDevInfos(this.getDeviceListForTreeSelection());
        this.populateTableModel(oDeviceList);
        this.m_oDeviceTablePanel.refreshTable();
    }

    private DeviceInfo[] getDeviceListForTreeSelection() {
        TreeNodeInfo oTreeNodeInfo = (TreeNodeInfo)this.m_oDeviceTreeSelectionEvent.getSource();
        DeviceInfo[] oDeviceList = null;
        if (3 == oTreeNodeInfo.m_iNodeType) {
            oDeviceList = this.m_oDeviceInfoManager.getDevices();
        } else if (1 == oTreeNodeInfo.m_iNodeType) {
            int iDeviceTypeID = oTreeNodeInfo.m_oDevType.getDevTypeID();
            int iDeviceTypeVersionID = oTreeNodeInfo.m_oDevType.getDevTypeVersionId();
            oDeviceList = this.m_oDeviceInfoManager.getDevicesByTypeAndVersion(iDeviceTypeID, iDeviceTypeVersionID);
        } else if (2 == oTreeNodeInfo.m_iNodeType) {
            String strVersionID = oTreeNodeInfo.m_strDeviceVersion;
            DeviceTypeInfo oDeviceTypeInfo = oTreeNodeInfo.m_oDevType;
            oDeviceList = this.m_oDeviceInfoManager.getDevicesForVersion(strVersionID, oDeviceTypeInfo);
        } else if (0 == oTreeNodeInfo.m_iNodeType) {
            SubMapNodeInfo oSubMapNodeInfo = oTreeNodeInfo.m_oSubMapNodeInfo;
            SubMapInfo oSubMapInfo = this.m_oDeviceInfoManager.getSubmapForID(oSubMapNodeInfo.m_submapId);
            oDeviceList = this.m_oDeviceInfoManager.getDevicesRecursivelyInSubMap(oSubMapInfo);
        }
        return oDeviceList;
    }

    private boolean checkIfDeviceNeedsToBeAdded(DeviceInfo oDeviceInfo) {
        if (null == this.m_oDeviceTreeSelectionEvent || null == this.m_oDeviceTreeSelectionEvent.getSource()) {
            return true;
        }
        TreeNodeInfo oTreeNodeInfo = (TreeNodeInfo)this.m_oDeviceTreeSelectionEvent.getSource();
        if (3 == oTreeNodeInfo.m_iNodeType) {
            return true;
        }
        if (1 == oTreeNodeInfo.m_iNodeType) {
            return this.checkIfDeviceIsOfType(oDeviceInfo);
        }
        if (2 == oTreeNodeInfo.m_iNodeType) {
            return this.checkIfDeviceIsOfVersion(oDeviceInfo);
        }
        if (0 == oTreeNodeInfo.m_iNodeType) {
            return this.checkIfDeviceIsInSubMap(oDeviceInfo);
        }
        return false;
    }

    private boolean checkIfDeviceIsOfVersion(DeviceInfo oDeviceInfo) {
        TreeNodeInfo oNode = (TreeNodeInfo)this.m_oDeviceTreeSelectionEvent.getSource();
        if (null == oNode.m_strDeviceVersion || null == oDeviceInfo.getDevVersion()) {
            return false;
        }
        DeviceTypeInfo oDevTypeInfo = oNode.getDeviceTypeInfo();
        DeviceTypeInfo oParaDevTypeInfo = oDeviceInfo.getDeviceTypeInfo();
        if (null != oDevTypeInfo && null != oParaDevTypeInfo && !oDevTypeInfo.equals(oParaDevTypeInfo)) {
            return false;
        }
        String strVersion = oDeviceInfo.getDevVersion().getDevVersion();
        if (null == strVersion || "".equals(strVersion)) {
            return Collator.getInstance().equals(oNode.m_strDeviceVersion, this.m_oResourceManager.getResString("UNKNOWN_VERSION"));
        }
        return oNode.m_strDeviceVersion.equals(strVersion);
    }

    private boolean checkIfDeviceIsOfType(DeviceInfo oDeviceInfo) {
        TreeNodeInfo oNode = (TreeNodeInfo)this.m_oDeviceTreeSelectionEvent.getSource();
        if (null == oDeviceInfo || null == oDeviceInfo.getDeviceTypeInfo()) {
            return false;
        }
        return oNode.m_oDevType.getDevTypeID() == oDeviceInfo.getDeviceTypeInfo().getDevTypeID();
    }

    private boolean checkIfDeviceIsInSubMap(DeviceInfo oDeviceInfo) {
        TreeNodeInfo oNode = (TreeNodeInfo)this.m_oDeviceTreeSelectionEvent.getSource();
        SubMapInfo oSubMapInfo = this.m_oDeviceInfoManager.getSubmapForID(oNode.m_oSubMapNodeInfo.m_submapId);
        int iDeviceID = oDeviceInfo.getDevId();
        return this.m_oDeviceInfoManager.isDevicePresentInSubMap(iDeviceID, oSubMapInfo);
    }

    public DCDeviceTreeNodeSelectionEventObject getTreeSelectionEvent() {
        return this.m_oDeviceTreeSelectionEvent;
    }

    public void makeRowVisible(int iRow) {
        this.m_oDeviceTablePanel.showRow(iRow);
    }

    @Override
    public void onTreeInit(DCEventObject oEventObject) {
    }

    @Override
    public void onDeviceNotification(DeviceInfoEvent oEvent) {
        if (null == oEvent) {
            return;
        }
        if (4 == oEvent.getEventType()) {
            this.processAutoLoadResponse(oEvent);
            return;
        }
        if (2 == oEvent.getEventType() && oEvent.getSource() instanceof OperationStatus) {
            this.setOperationProgressInTable(oEvent.getDeviceID(), (OperationStatus)oEvent.getSource());
        }
        if (null == oEvent.getSource()) {
            return;
        }
        Object oEventSrc = oEvent.getSource();
        if (oEvent.getSource() instanceof OperationStatus && !((OperationStatus)oEventSrc).getIsProgress() && ((OperationStatus)oEventSrc).getOperationType() == 3) {
            DeviceSelectionEvent oDevSelectionEvent = new DeviceSelectionEvent();
            oDevSelectionEvent.setEventType(2);
            oDevSelectionEvent.setSelectedDevIds(new int[]{oEvent.getDeviceID()});
            this.m_oDeviceTablePanel.notifyEvent(oDevSelectionEvent);
        }
    }

    private void setOperationProgressInTable(int iDeviceId, OperationStatus oOperationStatus) {
        DeviceInfo oDeviceInfo = this.m_oDeviceInfoManager.getDevice(iDeviceId);
        if (null != oDeviceInfo) {
            oDeviceInfo.setDeviceOperationStatus(oOperationStatus);
            DCFrameWorkUtil.repaint((JComponent)((Object)this.m_oDeviceTablePanel.getDeviceTreeTable()));
        } else {
            DCDebugTracer.trace("DevProgress:setOperationProgressInTable() oDeviceInfo is null." + iDeviceId);
        }
    }

    public void cleanUp() {
        this.m_oDeviceTablePanel.getDeviceTreePanel().removeDCEventListener(this);
        this.m_oDeviceTablePanel = null;
        this.m_oDeviceTreeTableModel = null;
        if (null != this.m_oRootNode) {
            this.m_oRootNode.removeAllChildren();
            this.m_oRootNode = null;
        }
        this.m_oDeviceTreeSelectionEvent = null;
        this.m_oDeviceInfoManager = null;
        this.m_oDeviceOperationMgr = null;
        this.m_oResourceManager = null;
    }

    public void setIgnoreNotifications(boolean bIgnoreNotifications) {
        this.m_bIgnoreNotifications = bIgnoreNotifications;
    }

    @Override
    public void handleDeviceConfigNotification(int iEventType, AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo = null;
        int iDeviceCount = oDeviceInfoList.size();
        for (int i = 0; i < iDeviceCount; ++i) {
            oAsnDeviceInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(i);
            if (null == oAsnDeviceInfo) continue;
            this.updateTableForNotification(iEventType, oAsnDeviceInfo);
        }
    }

    private void processAutoLoadResponse(DeviceInfoEvent oEvent) {
        Vector<String> oRow;
        ProgressDlg oProgressDlg = this.m_oDeviceTablePanel.getCurrentProgressDlg();
        if (null == oProgressDlg) {
            return;
        }
        if (-1 == oProgressDlg.getProgressDlgId()) {
            DCFrameWorkUtil.pauseThread(300L);
        }
        if (oProgressDlg.getProgressDlgId() != oEvent.getRequestId()) {
            return;
        }
        DeviceInfo oDeviceInfo = this.m_oDeviceInfoManager.getDevice(oEvent.getDeviceID());
        if (null == oDeviceInfo) {
            return;
        }
        StringBuffer strDisplayName = new StringBuffer(0);
        String strResult = null;
        int iOperationStatus = -1;
        strDisplayName.append(oDeviceInfo.getDevName());
        strDisplayName.append('(');
        strDisplayName.append(oDeviceInfo.getDevIPAddress());
        strDisplayName.append(')');
        if (oEvent.getSource() instanceof AsnStatusEnum) {
            AsnStatusEnum oStatus = (AsnStatusEnum)oEvent.getSource();
            iOperationStatus = oStatus.value;
            strResult = this.getOperationResultMessage(oProgressDlg, iOperationStatus, oEvent.getErrorCode());
        } else {
            strResult = this.m_oResourceManager.getResString("OPERATION_NOT_STARTED");
        }
        if (0 == iOperationStatus) {
            strResult = this.m_oResourceManager.getResString("OPERATION_CANCELLED");
        }
        if (null == (oRow = oProgressDlg.getRowForDevice(oDeviceInfo))) {
            oProgressDlg.setProgress(strDisplayName.toString(), strResult, oEvent.getProgress(), oEvent.getDeviceID());
        } else {
            oRow.add(1, strResult);
            oProgressDlg.updateProgress(oEvent.getProgress());
        }
    }

    private String getOperationResultMessage(ProgressDlg oProgressDlg, int iStatus, int iErrorCode) {
        switch (iStatus) {
            case 0: {
                return this.m_oResourceManager.getResString("OPERATION_NOT_STARTED");
            }
            case 1: {
                return this.m_oResourceManager.getResString("OPERATION_IN_PROGRESS");
            }
            case 3: {
                return ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode));
            }
        }
        return ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode));
    }

    private DeviceInfo[] getSupportedDevInfos(DeviceInfo[] oDevInfoArr) {
        if (null == oDevInfoArr) {
            return new DeviceInfo[0];
        }
        DeviceInfo[] oTmpDevInfos = oDevInfoArr;
        if (DCFrameWorkUtil.getIsSingleClient() && 2 == StandAloneDomainInfo.getInstance().getSelectedDomain()) {
            Vector<DeviceInfo> oDevInfoVec = new Vector<DeviceInfo>();
            for (DeviceInfo oDevInfo : oDevInfoArr) {
                int iRoleType = oDevInfo.getRoleType();
                if (1 != iRoleType && 2 != iRoleType) continue;
                oDevInfoVec.add(oDevInfo);
            }
            oTmpDevInfos = oDevInfoVec.toArray(new DeviceInfo[0]);
        }
        return oTmpDevInfos;
    }

    private boolean isNullDevies(DeviceInfo[] oDevInfos) {
        if (null == oDevInfos || oDevInfos.length == 0) {
            return true;
        }
        int iLength = oDevInfos.length;
        DeviceInfo oDev = null;
        for (int i = 0; i < iLength; ++i) {
            oDev = oDevInfos[i];
            if (null == oDev) continue;
            return false;
        }
        return true;
    }
}

