/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceview.devicetable;

import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.PopupMenuManager;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.MenuUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.configuration.licence.LicenseMonitor;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceview.devicetable.AbstractDeviceTablePanel;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceManagementPopupMenuManager;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceTableUtil;
import com.huawei.dc.devicemanagement.deviceview.devicetable.PrivilegeInfo;
import com.huawei.dc.standalone.StandAloneDomainInfo;
import com.huawei.dc.standalone.view.RouterDevInfoPanel;
import com.huawei.dc.taskmgmt.model.TaskModelUtil;
import com.swimap.iview.framework.menumanagement.MenuManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class DeviceTableButtonPanel
extends JPanel {
    private static final long serialVersionUID = -8812847116689725875L;
    private DCSortableTreeTable m_oDeviceTreeTable;
    private String strdate = "";
    private DeviceManagementPopupMenuManager m_oDevOperationPopupMenuMgr;
    private AbstractDeviceTablePanel oReference = null;
    private JButton backupButton;
    private JButton recoverButton;
    private JButton getPatchButton;
    private JButton getVersionButton;
    private JButton m_oNewTaskButton;
    private JPopupMenu m_oNewTaskPopupMenu;
    private HashMap m_oTaskMenuItemMap;
    private JLabel m_oDevCountLabel;
    private String m_sdevCountText = "";
    private JButton saveDevLstButton;

    public DeviceManagementPopupMenuManager getDevOperationPopupMenuMgr() {
        return this.m_oDevOperationPopupMenuMgr;
    }

    public DeviceTableButtonPanel(DCSortableTreeTable oDeviceTreeTable, AbstractDeviceTablePanel reference) {
        this.m_oDeviceTreeTable = oDeviceTreeTable;
        this.oReference = reference;
        this.m_oDevOperationPopupMenuMgr = new DeviceManagementPopupMenuManager(reference, oDeviceTreeTable);
        this.initButtonPanel();
    }

    private void initButtonPanel() {
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(1720, 45));
        this.setMinimumSize(new Dimension(1300, 45));
        this.setPreferredSize(new Dimension(1720, 45));
        this.add((Component)this.getSelectedDevCountLabel(), new GridBagConstraints(0, 0, 1, 7, 1.0, 0.0, 17, 1, new Insets(8, 0, 1, 0), 0, 0));
        this.add((Component)this.getNewTaskButton(), new GridBagConstraints(1, 0, 1, 7, 0.0, 0.0, 17, 0, new Insets(8, 3, 1, 0), 0, 0));
        this.add((Component)this.getVersionButton(), new GridBagConstraints(2, 0, 1, 7, 0.0, 0.0, 10, 0, new Insets(8, 3, 1, 0), 0, 0));
        this.add((Component)this.getPatchButton(), new GridBagConstraints(3, 0, 1, 7, 0.0, 0.0, 13, 0, new Insets(8, 3, 1, 0), 0, 0));
        this.add((Component)this.getBackupButton(), new GridBagConstraints(4, 0, 1, 7, 0.0, 0.0, 17, 0, new Insets(8, 3, 1, 0), 0, 0));
        this.add((Component)this.getRecoverButton(), new GridBagConstraints(5, 0, 1, 7, 0.0, 0.0, 17, 0, new Insets(8, 3, 1, 0), 0, 0));
        this.add((Component)this.getSaveDevLstButton(), new GridBagConstraints(6, 0, 1, 7, 0.0, 0.0, 13, 0, new Insets(8, 3, 1, 0), 0, 0));
        this.handleBtnForiTec();
        this.changeButtonsStatus();
    }

    private JLabel getSelectedDevCountLabel() {
        if (null == this.m_oDevCountLabel) {
            this.m_oDevCountLabel = new JLabel();
            this.m_oDevCountLabel.setPreferredSize(new Dimension(580, 45));
            this.m_oDevCountLabel.setMinimumSize(new Dimension(580, 45));
            this.m_sdevCountText = ResourceManager.getInstance().getResString("LBL_SELECT_DEVICE_COUNT_DATE");
            this.refreshSelectedDevCountLabel();
        }
        this.m_oDevCountLabel.setBackground(Color.BLUE);
        return this.m_oDevCountLabel;
    }

    private JButton getNewTaskButton() {
        if (null == this.m_oNewTaskButton) {
            ImageIcon oIcon = ResourceManager.getInstance().getImage("Down.gif");
            this.m_oNewTaskButton = new JButton(ResourceManager.getInstance().getResString("TASK_NEW_TASK"), oIcon);
            this.m_oNewTaskButton.setToolTipText(ResourceManager.getInstance().getResString("TASK_NEW_TASK"));
            this.m_oNewTaskButton.setMnemonic('N');
            this.m_oNewTaskButton.setMinimumSize(new Dimension(120, 23));
            this.m_oNewTaskButton.setPreferredSize(new Dimension(120, 23));
            this.m_oNewTaskButton.setHorizontalTextPosition(2);
            this.m_oNewTaskButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DeviceTableButtonPanel.this.showPopupMenuForNewTask();
                }
            });
        }
        return this.m_oNewTaskButton;
    }

    private void showPopupMenuForNewTask() {
        if (0 >= this.m_oDeviceTreeTable.getSelectedRowCount()) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("NO_DEVICES_SELECTED"));
            return;
        }
        if (DeviceTableUtil.isConstainUnsupportNEs(this.m_oDeviceTreeTable)) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("NO_DEVICES_SUPPORT_PATCH_MANAGEMENT"));
            return;
        }
        PopupMenuManager oPopupMenuManager = PopupMenuManager.getInstance();
        this.m_oNewTaskPopupMenu = oPopupMenuManager.load(this.oReference, "taskmgmtpopupmenufornewtaskbutton");
        this.m_oTaskMenuItemMap = oPopupMenuManager.getMenuItemMap();
        this.enableTaskMenuItems();
        boolean isShowMenu = false;
        int iCount = this.m_oNewTaskPopupMenu.getComponentCount();
        for (int i = 0; i < iCount; ++i) {
            if (!this.m_oNewTaskPopupMenu.getComponent(i).isVisible()) continue;
            isShowMenu = true;
            break;
        }
        if (!isShowMenu) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("NO_SUPPORTED_TASK_FOR_SELECTED_DEV"));
            return;
        }
        this.m_oNewTaskPopupMenu.show(this.m_oNewTaskButton, 0, this.m_oNewTaskButton.getHeight());
    }

    public JMenuItem getMenuItemForID(String strMenuItemID) {
        JMenuItem tempMenu = null;
        if (null != this.m_oTaskMenuItemMap.get(strMenuItemID)) {
            tempMenu = (JMenuItem)this.m_oTaskMenuItemMap.get(strMenuItemID);
        } else {
            DCDebugTracer.traceError("[menu] get Menu Item  : " + strMenuItemID + " failed, please check taskmgmtpopupmenufortask.xml or taskmgmtpopupmenufordevice.xml file. ");
            tempMenu = new JMenuItem();
        }
        return tempMenu;
    }

    public void changeNewTaskButtonStatus(boolean b) {
        if (null == this.m_oNewTaskButton) {
            return;
        }
        int[] arrSelectedRows = this.m_oDeviceTreeTable.getSelectedRows();
        ArrayList<DeviceTypeInfo> oDeviceTypeList = new ArrayList<DeviceTypeInfo>(0);
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            DeviceInfo oDevice = DeviceTableUtil.getDeviceInfoForTableRow(this.m_oDeviceTreeTable, arrSelectedRows[i]);
            if (null == oDevice || oDeviceTypeList.contains(oDevice.getDeviceTypeInfo())) continue;
            oDeviceTypeList.add(oDevice.getDeviceTypeInfo());
        }
        DeviceTypeInfo[] arrDeviceTypes = oDeviceTypeList.toArray(new DeviceTypeInfo[0]);
        if (null == arrDeviceTypes || 0 == arrDeviceTypes.length) {
            this.m_oNewTaskButton.setEnabled(false);
        } else {
            this.m_oNewTaskButton.setEnabled(b);
        }
    }

    private JButton getBackupButton() {
        if (null == this.backupButton) {
            this.backupButton = new JButton(ResourceManager.getInstance().getResString("DEVICE_NODE_POPUP_MENU_ITEM_BACKUP"));
            this.backupButton.setToolTipText(ResourceManager.getInstance().getResString("DEVICE_NODE_POPUP_MENU_ITEM_BACKUP_TOOLTIP"));
            this.backupButton.setMnemonic('b');
            this.backupButton.setMinimumSize(new Dimension(100, 23));
            this.backupButton.setPreferredSize(new Dimension(100, 23));
            this.backupButton.setEnabled(false);
            this.backupButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DeviceTableButtonPanel.this.oReference.backup();
                }
            });
        }
        return this.backupButton;
    }

    private JButton getRecoverButton() {
        if (null == this.recoverButton) {
            this.recoverButton = new JButton(ResourceManager.getInstance().getResString("DEVICE_NODE_POPUP_MENU_ITEM_RECOVER"));
            this.recoverButton.setToolTipText(ResourceManager.getInstance().getResString("DEVICE_NODE_POPUP_MENU_ITEM_RECOVER_TOOLTIP"));
            this.recoverButton.setMnemonic('r');
            this.recoverButton.setMinimumSize(new Dimension(100, 23));
            this.recoverButton.setPreferredSize(new Dimension(100, 23));
            this.recoverButton.setEnabled(false);
            this.recoverButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DeviceTableButtonPanel.this.oReference.recover();
                }
            });
        }
        return this.recoverButton;
    }

    private JButton getPatchButton() {
        if (null == this.getPatchButton) {
            this.getPatchButton = new JButton(ResourceManager.getInstance().getResString("DEVICETABLE_POPUP_MENU_ITEM_GET_PATCH"));
            this.getPatchButton.setToolTipText(ResourceManager.getInstance().getResString("DEVICETABLE_POPUP_MENU_ITEM_GET_PATCH_TOOLTIP"));
            this.getPatchButton.setMnemonic('G');
            this.getPatchButton.setMinimumSize(new Dimension(120, 23));
            this.getPatchButton.setPreferredSize(new Dimension(120, 23));
            this.getPatchButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DeviceTableButtonPanel.this.oReference.getPatch();
                }
            });
        }
        return this.getPatchButton;
    }

    private JButton getVersionButton() {
        if (null == this.getVersionButton) {
            this.getVersionButton = new JButton(ResourceManager.getInstance().getResString("DEVICETABLE_POPUP_MENU_ITEM_VERSION"));
            this.getVersionButton.setToolTipText(ResourceManager.getInstance().getResString("DEVICETABLE_POPUP_MENU_ITEM_VERSION_TOOLTIP"));
            this.getVersionButton.setMnemonic('V');
            this.getVersionButton.setMinimumSize(new Dimension(130, 23));
            this.getVersionButton.setPreferredSize(new Dimension(130, 23));
            this.getVersionButton.setEnabled(false);
            this.getVersionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DeviceTableButtonPanel.this.oReference.getVersion();
                }
            });
        }
        return this.getVersionButton;
    }

    public void setSaveDevLstBtnStatus(boolean bStatus) {
        if (null != this.saveDevLstButton) {
            this.saveDevLstButton.setEnabled(bStatus);
        }
    }

    private JButton getSaveDevLstButton() {
        if (null == this.saveDevLstButton) {
            this.saveDevLstButton = new JButton(ResourceManager.getInstance().getResString("DEVICETABLE_BUTTON_SAVEDEVLST"));
            this.saveDevLstButton.setToolTipText(ResourceManager.getInstance().getResString("DEVICETABLE_BUTTON_SAVEDEVLST_TOOLTIP"));
            this.saveDevLstButton.setMnemonic('S');
            this.saveDevLstButton.setMinimumSize(new Dimension(130, 23));
            this.saveDevLstButton.setPreferredSize(new Dimension(130, 23));
            this.saveDevLstButton.setEnabled(true);
            this.saveDevLstButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DeviceTableUtil.saveButtonActionPerformed(DeviceTableButtonPanel.this.m_oDeviceTreeTable);
                }
            });
        }
        return this.saveDevLstButton;
    }

    private void handleBtnForiTec() {
        if (DCFrameWorkUtil.isForiTec()) {
            if (null != this.backupButton) {
                this.backupButton.setVisible(false);
            }
            if (null != this.recoverButton) {
                this.recoverButton.setVisible(false);
            }
        }
    }

    void enableButtonForMultipleSelection() {
        try {
            this.m_oDevOperationPopupMenuMgr.loadMenu();
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
            return;
        }
        boolean isEnabledNewTask = this.m_oDevOperationPopupMenuMgr.getMenuItemForID("NewTask").isEnabled();
        this.m_oNewTaskButton.setEnabled(isEnabledNewTask);
        boolean isEnabledBackup = this.m_oDevOperationPopupMenuMgr.getMenuItemForID("Backup").isEnabled();
        this.backupButton.setEnabled(isEnabledBackup);
        boolean isEnabledRecover = this.m_oDevOperationPopupMenuMgr.getMenuItemForID("Recover").isEnabled();
        this.recoverButton.setEnabled(isEnabledRecover);
        boolean isEnabledGetPatch = this.m_oDevOperationPopupMenuMgr.getMenuItemForID("GetPatch").isEnabled();
        this.getPatchButton.setEnabled(isEnabledGetPatch);
        boolean isEnabledGetVersion = this.m_oDevOperationPopupMenuMgr.getMenuItemForID("GetVersion").isEnabled();
        this.getVersionButton.setEnabled(isEnabledGetVersion);
        this.saveDevLstButton.setEnabled(true);
    }

    private void changeButtonsStatus() {
        PrivilegeInfo oPrivilegeInfo = new PrivilegeInfo();
        oPrivilegeInfo.checkUserPrivileges();
        if (null != this.backupButton) {
            this.backupButton.setEnabled(oPrivilegeInfo.isbBackupServerPrivilege() || oPrivilegeInfo.isbBackupClientPrivilege() || oPrivilegeInfo.isbBackupThirdPrivilege());
        }
        if (null != this.recoverButton) {
            this.recoverButton.setEnabled(oPrivilegeInfo.isRecoverPrivilege());
        }
        if (null != this.getPatchButton) {
            this.getPatchButton.setEnabled(oPrivilegeInfo.isGetPatchPrivilege());
        }
        if (null != this.getVersionButton) {
            this.getVersionButton.setEnabled(oPrivilegeInfo.isGetVerPrivilege());
        }
        if (null != this.saveDevLstButton) {
            this.saveDevLstButton.setEnabled(true);
        }
        if (null != this.m_oNewTaskButton) {
            this.m_oNewTaskButton.setEnabled(oPrivilegeInfo.isHasTaskMgrPrivilege());
        }
    }

    public void refreshSelectedDevCountLabel() {
        if (null == this.m_oDevCountLabel) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int iSelectedDevCount = 0;
                int[] arrSelectedRows = DeviceTableButtonPanel.this.m_oDeviceTreeTable.getSelectedRows();
                if (null != arrSelectedRows) {
                    iSelectedDevCount = arrSelectedRows.length;
                }
                int iSelectCurRow = 0;
                if (iSelectedDevCount > 0) {
                    iSelectCurRow = arrSelectedRows[0] + 1;
                }
                int iDevCount = DeviceTableButtonPanel.this.m_oDeviceTreeTable.getRowCount();
                String strDeviceCountMsg = MessageFormat.format(DeviceTableButtonPanel.this.m_sdevCountText, "" + iSelectCurRow, "" + iDevCount, "" + iSelectedDevCount, "" + DeviceTableButtonPanel.this.strdate);
                DeviceTableButtonPanel.this.m_oDevCountLabel.setText(StringUtils.getHtmlString(strDeviceCountMsg));
            }
        });
    }

    private void enableTaskMenuItems() {
        boolean bNewTaskPrivilege = true;
        if (!DCFrameWorkUtil.getIsSingleClient()) {
            bNewTaskPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(43871);
        }
        int[] arrSelectedRows = this.m_oDeviceTreeTable.getSelectedRows();
        ArrayList<DeviceTypeInfo> oDeviceTypeList = new ArrayList<DeviceTypeInfo>(0);
        int[] iDeviceIdLst = new int[arrSelectedRows.length];
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            DeviceInfo oDevice = DeviceTableUtil.getDeviceInfoForTableRow(this.m_oDeviceTreeTable, arrSelectedRows[i]);
            if (null != oDevice) {
                iDeviceIdLst[i] = oDevice.getDevId();
            }
            if (null == oDevice || oDeviceTypeList.contains(oDevice.getDeviceTypeInfo())) continue;
            oDeviceTypeList.add(oDevice.getDeviceTypeInfo());
        }
        DeviceTypeInfo[] arrDeviceTypes = oDeviceTypeList.toArray(new DeviceTypeInfo[0]);
        if (DeviceTableUtil.isDevDomain(this.m_oDeviceTreeTable, 4) && TaskModelUtil.isTaskTypeSupportedForT2000DeviceTypes(5, arrDeviceTypes, iDeviceIdLst)) {
            if (LicenseMonitor.getInstance().isControlTran()) {
                if (LicenseMonitor.getInstance().isCurrStatusValid()) {
                    MenuUtil.enableMenuItem((Component)this.getMenuItemForID("NewTask"), bNewTaskPrivilege);
                    MenuUtil.visibleMenuItem(this.getMenuItemForID("packageDiffusionUpgradeDowngrade"), true);
                    MenuUtil.enableMenuItem((Component)this.getMenuItemForID("packageDiffusionUpgradeDowngrade"), bNewTaskPrivilege);
                } else {
                    MenuUtil.visibleMenuItem(this.getMenuItemForID("packageDiffusionUpgradeDowngrade"), false);
                }
            } else {
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("NewTask"), bNewTaskPrivilege);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("packageDiffusionUpgradeDowngrade"), true);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("packageDiffusionUpgradeDowngrade"), bNewTaskPrivilege);
            }
        } else {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("packageDiffusionUpgradeDowngrade"), false);
        }
        if (DeviceTableUtil.isDevDomain(this.m_oDeviceTreeTable, 4) && TaskModelUtil.isSupportedForDeviceTypes(4, arrDeviceTypes, iDeviceIdLst)) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("NewTask"), bNewTaskPrivilege);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("packageUpgradedowngradetask"), true);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("packageUpgradedowngradetask"), bNewTaskPrivilege);
        } else {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("packageUpgradedowngradetask"), false);
        }
        if (DeviceTableUtil.isDevDomain(this.m_oDeviceTreeTable, 4) && TaskModelUtil.isSupportedForDeviceTypes(3, arrDeviceTypes, iDeviceIdLst)) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("NewTask"), bNewTaskPrivilege);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("MimcPackageUpgrade"), true);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("MimcPackageUpgrade"), bNewTaskPrivilege);
        } else {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("MimcPackageUpgrade"), false);
        }
        Vector<Integer> oDomainListVector = new Vector<Integer>();
        oDomainListVector.add(1);
        oDomainListVector.add(2);
        if (DeviceTableUtil.isMultipleDevDomain(this.m_oDeviceTreeTable, oDomainListVector) && TaskModelUtil.isTaskTypeSupportedForT2000DeviceTypes(0, arrDeviceTypes, iDeviceIdLst)) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("NewTask"), bNewTaskPrivilege);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("UpgradeDowngrade"), true);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("UpgradeDowngrade"), bNewTaskPrivilege);
        } else {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("UpgradeDowngrade"), false);
        }
        if (TaskModelUtil.isSupportedForDeviceTypes(2, arrDeviceTypes, iDeviceIdLst)) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("NewTask"), bNewTaskPrivilege);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("PatchUpdate"), true);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("PatchUpdate"), bNewTaskPrivilege);
        } else {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("PatchUpdate"), false);
        }
        MenuUtil.visibleMenuItem(this.getMenuItemForID("oltUpdate"), false);
    }

    public void refreshDevCountLabel(final int iDevSelectCount, final int iTotalCount) {
        if (null == this.m_oDevCountLabel) {
            return;
        }
        if (iDevSelectCount > iTotalCount) {
            DCDebugTracer.trace("dc error dev count " + iDevSelectCount + " " + iTotalCount);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String strDeviceCountMsg = MessageFormat.format(DeviceTableButtonPanel.this.m_sdevCountText, "" + iDevSelectCount, "" + iTotalCount);
                DeviceTableButtonPanel.this.m_oDevCountLabel.setText(StringUtils.getHtmlString(strDeviceCountMsg));
            }
        });
    }

    public void refreshNEManageButtonStatus(boolean enable) {
        PrivilegeInfo oPrivilegeInfo = new PrivilegeInfo();
        oPrivilegeInfo.checkUserPrivileges();
        if (oPrivilegeInfo.isRecoverPrivilege()) {
            this.recoverButton.setEnabled(enable);
        }
        if (oPrivilegeInfo.isbBackupServerPrivilege() || oPrivilegeInfo.isbBackupClientPrivilege() || oPrivilegeInfo.isbBackupThirdPrivilege()) {
            this.backupButton.setEnabled(enable);
        }
        if (oPrivilegeInfo.isGetPatchPrivilege()) {
            this.getPatchButton.setEnabled(enable);
        }
        if (oPrivilegeInfo.isGetVerPrivilege()) {
            this.getVersionButton.setEnabled(enable);
        }
        if (oPrivilegeInfo.isNewTaskPrivilege()) {
            this.m_oNewTaskButton.setEnabled(enable);
        }
        this.refreshNEManageMenuStatus();
    }

    public void refreshNEManageMenuStatus() {
        int[] arrSelectedRows;
        if (!DCFrameWorkUtil.getIsSingleClient()) {
            return;
        }
        MenuManager oMenuManager = DCFrameWorkUtil.getDCMenuManager();
        Object isForWebLCT = DCFrameWorkUtil.getSystemProperty("StandaloneForWebLCT");
        if (Boolean.TRUE.equals(isForWebLCT)) {
            this.m_oDevOperationPopupMenuMgr.getMenuItemForID("DeviceManagement").setVisible(false);
            this.m_oDevOperationPopupMenuMgr.getSeparatorForID("Seperator0").setVisible(false);
            return;
        }
        MenuUtil.enableMenuItem(oMenuManager.getMenuItem("neManageMenu", "neManage", "ExportDevices"), false);
        MenuUtil.enableMenuItem(oMenuManager.getMenuItem("neManageMenu", "neManage", "ModifyDevice"), false);
        MenuUtil.enableMenuItem(oMenuManager.getMenuItem("neManageMenu", "neManage", "DeleteDevices"), false);
        if (!this.m_oDevOperationPopupMenuMgr.isOperationInProgressForAnyDevice() && null != (arrSelectedRows = this.m_oDeviceTreeTable.getSelectedRows())) {
            int index;
            boolean m_DevInT2000 = false;
            boolean m_DevInSameType = true;
            for (index = 0; index < arrSelectedRows.length; ++index) {
                DeviceInfo oDeviceInfoBenchMark = DeviceTableUtil.getDeviceInfoForTableRow(this.m_oDeviceTreeTable, arrSelectedRows[index]);
                if (oDeviceInfoBenchMark.getDeviceTypeInfo().getDevDomain() != 4) continue;
                m_DevInT2000 = true;
                break;
            }
            for (index = 1; index < arrSelectedRows.length; ++index) {
                DeviceInfo oDeviceInfoBenchMark1 = DeviceTableUtil.getDeviceInfoForTableRow(this.m_oDeviceTreeTable, arrSelectedRows[0]);
                DeviceInfo oDeviceInfoBenchMark = DeviceTableUtil.getDeviceInfoForTableRow(this.m_oDeviceTreeTable, arrSelectedRows[index]);
                if (null == oDeviceInfoBenchMark || null == oDeviceInfoBenchMark1 || oDeviceInfoBenchMark1.getProtocol() == oDeviceInfoBenchMark.getProtocol()) continue;
                m_DevInSameType = false;
                break;
            }
            if (m_DevInT2000) {
                if (m_DevInSameType && !this.m_oDevOperationPopupMenuMgr.isOperationInProgressForAnyDevice()) {
                    MenuUtil.enableMenuItem(oMenuManager.getMenuItem("neManageMenu", "neManage", "ModifyDevice"), true);
                }
            } else if (arrSelectedRows.length == 1 && !this.m_oDevOperationPopupMenuMgr.isOperationInProgressForAnyDevice()) {
                MenuUtil.enableMenuItem(oMenuManager.getMenuItem("neManageMenu", "neManage", "ModifyDevice"), true);
            }
            if (1 <= arrSelectedRows.length) {
                MenuUtil.enableMenuItem(oMenuManager.getMenuItem("neManageMenu", "neManage", "DeleteDevices"), true);
                if (2 == StandAloneDomainInfo.getInstance().getSelectedDomain()) {
                    MenuUtil.enableMenuItem(oMenuManager.getMenuItem("neManageMenu", "neManage", "ModifyDevice"), true);
                }
            }
        }
        if (DeviceTableUtil.isDevDomain(this.m_oDeviceTreeTable, 2) || DeviceTableUtil.isDevDomain(this.m_oDeviceTreeTable, 4) || DeviceTableUtil.isDevDomain(this.m_oDeviceTreeTable, 1)) {
            arrSelectedRows = this.m_oDeviceTreeTable.getSelectedRows();
            if (null != arrSelectedRows && arrSelectedRows.length > 0) {
                MenuUtil.enableMenuItem(oMenuManager.getMenuItem("neManageMenu", "neManage", "ExportDevices"), true);
            }
        } else {
            MenuUtil.enableMenuItem(oMenuManager.getMenuItem("neManageMenu", "neManage", "ExportDevices"), false);
        }
        boolean bRouteDomain = StandAloneDomainInfo.getInstance().getSelectedDomain() == 2;
        RouterDevInfoPanel oRouteDevPanel = DCFrameWorkUtil.getRouterDevInfoPanel();
        boolean isRouteCurrentPanel = null != oRouteDevPanel ? oRouteDevPanel.isCurrentPanel() : false;
        boolean bShowExportTmplate = bRouteDomain && isRouteCurrentPanel;
        MenuUtil.visibleMenuItem(oMenuManager.getMenuItem("neManageMenu", "neManage", "ExportDevicesTemplate"), bShowExportTmplate);
        MenuUtil.enableMenuItem(oMenuManager.getMenuItem("neManageMenu", "neManage", "ExportDevicesTemplate"), bShowExportTmplate);
        MenuUtil.visibleMenuItem(oMenuManager.getMenuItem("neManageMenu", "neManage", "ExportCheckItemTemp"), bShowExportTmplate);
        MenuUtil.enableMenuItem(oMenuManager.getMenuItem("neManageMenu", "neManage", "ExportCheckItemTemp"), bShowExportTmplate);
    }

    public DeviceManagementPopupMenuManager getDevicePopupMgr() {
        return this.m_oDevOperationPopupMenuMgr;
    }

    public void disposePanel() {
        this.m_oDeviceTreeTable = null;
        this.m_oDevOperationPopupMenuMgr = null;
        this.oReference = null;
        this.backupButton = null;
        this.recoverButton = null;
        this.getPatchButton = null;
        this.getVersionButton = null;
        this.m_oNewTaskButton = null;
        this.m_oNewTaskPopupMenu = null;
        this.m_oDevCountLabel = null;
        if (null != this.m_oTaskMenuItemMap) {
            this.m_oTaskMenuItemMap.clear();
            this.m_oTaskMenuItemMap = null;
        }
    }

    public void setRefreshDateTime() {
        this.strdate = DeviceTableUtil.getCurDateTimeStr();
        this.refreshSelectedDevCountLabel();
    }
}

