/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceview.devicetable;

import com.huawei.dc.common.components.treetable.view.JSortTreeTable;
import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.PopupMenuManager;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.common.util.MenuUtil;
import com.huawei.dc.configuration.licence.LicenseMonitor;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.IOperation;
import com.huawei.dc.devicemanagement.deviceoperation.controller.BusyDeviceObjectStore;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceTableUtil;
import com.huawei.dc.devicemanagement.deviceview.devicetable.PrivilegeInfo;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IViewConfiguration;
import com.huawei.dc.deviceoperation.util.OperationStatus;
import com.huawei.dc.standalone.StandAloneDomainInfo;
import com.huawei.dc.taskmgmt.model.TaskModelUtil;
import gnu.trove.TIntArrayList;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class DeviceManagementPopupMenuManager {
    private Map m_oMenuListFromXML;
    private Map m_oSeparatorListFromXML;
    private JPopupMenu m_oDeviceTablePopupMenu;
    private Object m_object;
    private JSortTreeTable m_oDeviceTable;
    PrivilegeInfo oPrivilegeInfo = null;
    private static final int BMS_INDEX = 0;
    private static final int DMS_INDEX = 1;
    private static final int T2000_INDEX = 2;

    public DeviceManagementPopupMenuManager(Object obj, JSortTreeTable oDeviceTable) {
        this.m_object = obj;
        this.m_oDeviceTable = oDeviceTable;
        this.m_oMenuListFromXML = new HashMap(10);
        this.oPrivilegeInfo = new PrivilegeInfo();
        this.oPrivilegeInfo.checkUserPrivileges();
        PopupMenuManager oPopupMenuManager = PopupMenuManager.getInstance();
        this.m_oDeviceTablePopupMenu = oPopupMenuManager.load(this.m_object, "devicetablepopupmenu");
        this.m_oMenuListFromXML = oPopupMenuManager.getMenuItemMap();
        this.m_oSeparatorListFromXML = oPopupMenuManager.getSeparatorMap();
    }

    public boolean[] setSelNeInfo() {
        int[] arrSelectedRows = this.m_oDeviceTable.getSelectedRows();
        boolean bIsBMSDeviceSelected = false;
        boolean bIsDMSDeviceSelected = false;
        boolean bIsT2000DeviceSelected = false;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            DeviceInfo oDevice = (DeviceInfo)this.m_oDeviceTable.getValueAt(arrSelectedRows[i], 0);
            if (null == oDevice) continue;
            DeviceTypeInfo oTypeInfo = oDevice.getDeviceTypeInfo();
            if (oTypeInfo.isT2000Domain()) {
                bIsT2000DeviceSelected = true;
                continue;
            }
            if (oTypeInfo.isBMSDomain()) {
                bIsBMSDeviceSelected = true;
                continue;
            }
            bIsDMSDeviceSelected = true;
            if (bIsT2000DeviceSelected && bIsBMSDeviceSelected) break;
        }
        boolean[] neSelInfo = new boolean[]{bIsBMSDeviceSelected, bIsDMSDeviceSelected, bIsT2000DeviceSelected};
        return neSelInfo;
    }

    public JPopupMenu loadMenu() {
        int[] arrSelectedRows;
        JSeparator sep1;
        DCDebugTracer.traceError("Method loadMenu start");
        this.enableAllMenuItems(false);
        if (DCFrameWorkUtil.isForiTec() && null != (sep1 = this.getSeparatorForID("Seperator1"))) {
            sep1.setVisible(false);
        }
        if (null == (arrSelectedRows = this.m_oDeviceTable.getSelectedRows()) || 0 == arrSelectedRows.length || 0 == this.m_oDeviceTable.getRowCount()) {
            this.enableMenuForNonSelNE();
            return this.m_oDeviceTablePopupMenu;
        }
        if (DeviceTableUtil.isConstainUnsupportNEs(this.m_oDeviceTable)) {
            this.enableAllMenuItems(false);
            if (DCFrameWorkUtil.getIsSingleClient()) {
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("DeviceManagement"), true);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("AddDevices"), true);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("SearchDevice"), true);
                if (1 == arrSelectedRows.length) {
                    MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ModifyDevice"), true);
                }
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("DeleteDevices"), true);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ExportDevices"), true);
                this.removeUnuseMenu();
            }
            return this.m_oDeviceTablePopupMenu;
        }
        boolean[] neSelInfo = this.setSelNeInfo();
        boolean bIsBMSDeviceSelected = neSelInfo[0];
        boolean bIsDMSDeviceSelected = neSelInfo[1];
        boolean bIsT2000DeviceSelected = neSelInfo[2];
        this.displayDomainSpecificMenuItems(bIsT2000DeviceSelected, bIsBMSDeviceSelected);
        boolean bAnyDeviceInProgress = this.isOperationInProgressForAnyDevice();
        this.setCancelMenuItemStatus(bAnyDeviceInProgress);
        this.setBackupMenuItemStatus(bAnyDeviceInProgress);
        this.setRecoverMenuItemStatus(bAnyDeviceInProgress);
        boolean bIsDifferentTypesSelected = DeviceTableUtil.isDifferentDeviceTypesSelectedInTable(this.m_oDeviceTable);
        this.setGetVersionMenuItemStatus(bIsDifferentTypesSelected, bAnyDeviceInProgress);
        if (bIsDifferentTypesSelected) {
            this.enableTaskItemsForMultipleDeviceTypes();
        } else if (!bAnyDeviceInProgress) {
            this.enableMenuItemsForSelectedDevicesTypes();
            this.enableTaskMenuItems();
        }
        this.handleDeviceManagerMenu(bIsBMSDeviceSelected, bIsDMSDeviceSelected, bIsT2000DeviceSelected);
        this.enableMenuCheckItem();
        this.setPrintMenuItemStatus();
        this.setDelMemoryMenuItemStatus();
        this.setSaveAsBackupFilesMenuItemStatus();
        this.checkIsMiniDCForBMS();
        this.removeUnuseMenu();
        this.enableDomainSupportedMenuItem(bIsBMSDeviceSelected, bIsDMSDeviceSelected, bIsT2000DeviceSelected, bAnyDeviceInProgress);
        if (DCFrameWorkUtil.getIsSingleClient() && bIsBMSDeviceSelected) {
            boolean isSupportBackUpOrRecover = false;
            List<Integer> iBmsDevIDLst = DeviceTableUtil.getBmsDevID(this.m_oDeviceTable);
            isSupportBackUpOrRecover = this.enableBackupOrRecoverForBmsInSA(iBmsDevIDLst, "Backup");
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("Backup"), isSupportBackUpOrRecover);
            isSupportBackUpOrRecover = this.enableBackupOrRecoverForBmsInSA(iBmsDevIDLst, "Recover");
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("Recover"), isSupportBackUpOrRecover);
        }
        MenuUtil.enableMenuItem((Component)this.getMenuItemForID("GetVersion"), this.oPrivilegeInfo.isGetVerPrivilege());
        MenuUtil.orgSeparator(this.m_oDeviceTablePopupMenu);
        return this.m_oDeviceTablePopupMenu;
    }

    private boolean enableBackupOrRecoverForBmsInSA(List<Integer> iBmsDevIDLst, String strOpr) {
        boolean bEnableBackUpOrRecoverOpr = true;
        for (int i = 0; i < iBmsDevIDLst.size(); ++i) {
            IViewConfiguration oIViewConfiguration;
            List<String> strOprLst;
            int iDevID = iBmsDevIDLst.get(i);
            int[] m_iDeviceIdLst = new int[]{iDevID};
            DeviceInfo oDeviceInfo = DCFrameWorkUtil.getDeviceInfoManager().getDevice(iDevID);
            if (null == oDeviceInfo) continue;
            DeviceTypeInfo deviceType = oDeviceInfo.getDeviceTypeInfo();
            IDeviceTypeConfigModel oDevTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(deviceType, m_iDeviceIdLst);
            if (oDevTypeConfigModel == null || (strOprLst = (oIViewConfiguration = oDevTypeConfigModel.getViewConfiguration()).getViewConfiguration(0, 0)).contains(strOpr)) continue;
            bEnableBackUpOrRecoverOpr = false;
        }
        return bEnableBackUpOrRecoverOpr;
    }

    private void enableMenuCheckItem() {
        if (DCFrameWorkUtil.getIsSingleClient()) {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("ExportCheckItemTemp"), false);
            return;
        }
        MenuUtil.visibleMenuItem(this.getMenuItemForID("ExportCheckItemTemp"), true);
        MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ExportCheckItemTemp"), this.oPrivilegeInfo.isExportCheckTmpPrivilege());
    }

    private void setGetVersionMenuItemStatus(boolean bIsDifferentTypesSelected, boolean bAnyDeviceInProgress) {
        if (bAnyDeviceInProgress) {
            this.getMenuItemForID("GetVersion").setEnabled(this.oPrivilegeInfo.isGetVerPrivilege());
        } else if (bIsDifferentTypesSelected) {
            this.getMenuItemForID("GetVersion").setEnabled(this.oPrivilegeInfo.isGetVerPrivilege());
        }
    }

    private void setRecoverMenuItemStatus(boolean bAnyDeviceInProgress) {
        MenuUtil.enableMenuItem((Component)this.getMenuItemForID("Recover"), this.oPrivilegeInfo.isRecoverPrivilege());
        if (bAnyDeviceInProgress) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("Recover"), false);
        }
    }

    private void setBackupMenuItemStatus(boolean bAnyDeviceInProgress) {
        MenuUtil.enableMenuItem((Component)this.getMenuItemForID("Backup"), this.oPrivilegeInfo.isbBackupServerPrivilege() || this.oPrivilegeInfo.isbBackupClientPrivilege() || this.oPrivilegeInfo.isbBackupThirdPrivilege());
        if (bAnyDeviceInProgress) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("Backup"), false);
        }
    }

    private void setSaveAsBackupFilesMenuItemStatus() {
        if (!DCFrameWorkUtil.getIsSingleClient()) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("SaveAsBackupFiles"), this.oPrivilegeInfo.isSaveAsBackupFilePrivilege());
            MenuUtil.visibleMenuItem(this.getSeparatorForID("SaveAsBackupFiles"), true);
        } else {
            MenuUtil.visibleMenuItem(this.getSeparatorForID("SaveAsBackupFiles"), false);
            MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator8"), false);
            MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator9"), false);
        }
    }

    private void setPrintMenuItemStatus() {
        if (DCFrameWorkUtil.getIsSingleClient()) {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("Print"), false);
            MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator5"), false);
        } else {
            this.enableMenuItem("Print", true);
        }
    }

    private void setCancelMenuItemStatus(boolean bAnyDeviceInProgress) {
        JMenuItem cancelMenu = this.getMenuItemForID("Cancel");
        if (null != cancelMenu) {
            cancelMenu.setVisible(false);
        }
        if (bAnyDeviceInProgress && null != cancelMenu) {
            if (this.isSupportCancelOperation()) {
                cancelMenu.setVisible(this.oPrivilegeInfo.isCanclePrivilege() && this.oPrivilegeInfo.isHasTaskMgrPrivilege());
                cancelMenu.setEnabled(this.oPrivilegeInfo.isCanclePrivilege() && this.oPrivilegeInfo.isHasTaskMgrPrivilege());
            } else {
                cancelMenu.setVisible(false);
            }
        }
    }

    private void setDelMemoryMenuItemStatus() {
        int[] arrSelectedRows = this.m_oDeviceTable.getSelectedRows();
        boolean bIsEnableDeleteMemory = false;
        boolean bIsVisibleDeleteMemory = true;
        boolean bIsOnlySingleDevice = false;
        if (arrSelectedRows.length == 1) {
            bIsOnlySingleDevice = true;
        }
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            DeviceTypeInfo oTypeInfo;
            DeviceInfo oDevice = (DeviceInfo)this.m_oDeviceTable.getValueAt(arrSelectedRows[i], 0);
            if (null == oDevice || !(oTypeInfo = oDevice.getDeviceTypeInfo()).isDMSDomain() || !bIsOnlySingleDevice) continue;
            if (this.isSupportDeleteNEFileOpr(oTypeInfo, oDevice)) {
                bIsEnableDeleteMemory = true;
            }
            if (bIsEnableDeleteMemory) continue;
            bIsVisibleDeleteMemory = this.isVisibleDeleteNEFileMenu(oTypeInfo, oDevice);
        }
        if (!DCFrameWorkUtil.getIsSingleClient() && bIsEnableDeleteMemory) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("deleteMemory"), this.oPrivilegeInfo.isDeleteMemory());
            MenuUtil.visibleMenuItem(this.getSeparatorForID("deleteMemory"), this.oPrivilegeInfo.isDeleteMemory());
        }
        if (!bIsVisibleDeleteMemory) {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("deleteMemory"), bIsVisibleDeleteMemory);
            MenuUtil.visibleMenuItem(this.getSeparatorForID("deleteMemory"), bIsVisibleDeleteMemory);
        }
    }

    private void removeUnuseMenu() {
        MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator9"), false);
        MenuUtil.visibleMenuItem(this.getMenuItemForID("SetSNMP"), false);
        MenuUtil.enableMenuItem((Component)this.getMenuItemForID("SetSNMP"), false);
        MenuUtil.visibleMenuItem(this.getMenuItemForID("DeleteSNMP"), false);
        MenuUtil.enableMenuItem((Component)this.getMenuItemForID("DeleteSNMP"), false);
    }

    public JPopupMenu loadMenuForDevTableButton() {
        this.enableAllMenuItems(false);
        int[] arrSelectedRows = this.m_oDeviceTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length || 0 == this.m_oDeviceTable.getRowCount()) {
            this.enableMenuForNonSelNE();
            return this.m_oDeviceTablePopupMenu;
        }
        TIntArrayList oUnsurpportOprNETYpeIDs = DeviceInfoUtil.getIDLst("NOT_SUPPORT_OPERATION_NE_TYPE");
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            DeviceInfo oDeviceInfo = DeviceTableUtil.getDeviceInfoForTableRow(this.m_oDeviceTable, arrSelectedRows[i]);
            if (null != oDeviceInfo && null != oDeviceInfo.getDeviceTypeInfo() && !oUnsurpportOprNETYpeIDs.contains(oDeviceInfo.getDeviceTypeInfo().getDevTypeID())) continue;
            this.enableAllMenuItems(false);
            return this.m_oDeviceTablePopupMenu;
        }
        boolean bIsDifferentTypesSelected = DeviceTableUtil.isDifferentDeviceTypesSelectedInTable(this.m_oDeviceTable);
        if (bIsDifferentTypesSelected) {
            this.enableTaskItemsForMultipleDeviceTypes();
        } else {
            this.enableTaskMenuItems();
        }
        MenuUtil.enableMenuItem((Component)this.getMenuItemForID("GetVersion"), this.oPrivilegeInfo.isGetVerPrivilege());
        MenuUtil.enableMenuItem((Component)this.getMenuItemForID("GetPatch"), this.oPrivilegeInfo.isGetPatchPrivilege());
        boolean bAnyDeviceInProgress = this.isOperationInProgressForAnyDevice();
        MenuUtil.enableMenuItem((Component)this.getMenuItemForID("Backup"), (this.oPrivilegeInfo.isbBackupServerPrivilege() || this.oPrivilegeInfo.isbBackupClientPrivilege() || this.oPrivilegeInfo.isbBackupThirdPrivilege()) && !bAnyDeviceInProgress);
        MenuUtil.enableMenuItem((Component)this.getMenuItemForID("Recover"), this.oPrivilegeInfo.isRecoverPrivilege() && !bAnyDeviceInProgress);
        return this.m_oDeviceTablePopupMenu;
    }

    private void enableMenuForNonSelNE() {
        if (!DCFrameWorkUtil.getIsSingleClient()) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("DeviceManagement"), false);
        } else {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("DeviceManagement"), true);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("DeviceManagement"), true);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("AddDevices"), true);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("AddDevices"), true);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("SearchDevice"), true);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("SearchDevice"), true);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("ModifyDevice"), true);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ModifyDevice"), false);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("DeleteDevices"), true);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("DeleteDevices"), false);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("ExportDevices"), true);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ExportDevices"), false);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("ExportDevicesTemplate"), true);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ExportDevicesTemplate"), true);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("ImportDevices"), true);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ImportDevices"), true);
            MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator7"), true);
            this.removeUnuseMenu();
            this.updateMenuBaseOnDomain();
        }
    }

    private void updateMenuBaseOnDomain() {
        if (DCFrameWorkUtil.getIsSingleClient()) {
            int iDomain = StandAloneDomainInfo.getInstance().getSelectedDomain();
            this.enableAllMenuItemVisible();
            if (4 == iDomain) {
                MenuUtil.visibleMenuItem(this.getMenuItemForID("SearchDevice"), true);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("Save"), false);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("DatabaseOperation"), true);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("InitializeDataBase"), true);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("DeleteDatabase"), true);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("Rollbackdatabase"), true);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("ActivationDataBase"), true);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("CopyDataBase"), true);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("setOSPFStatus"), true);
                MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator10"), true);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("setCam"), true);
                MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator11"), true);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("SoftwareStatistics"), true);
            } else if (1 == iDomain) {
                DCDebugTracer.trace("DeviceManagementPopupMenueManagement updateMenuBaseOnDomain");
            } else if (3 == iDomain) {
                MenuUtil.visibleMenuItem(this.getMenuItemForID("RollbackSoftware"), true);
            } else {
                MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator6"), true);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("telnetTerminal"), true);
            }
        }
    }

    private void enableAllMenuItemVisible() {
        MenuUtil.visibleMenuItem(this.getMenuItemForID("SearchDevice"), false);
        MenuUtil.visibleMenuItem(this.getMenuItemForID("RollbackSoftware"), false);
        MenuUtil.visibleMenuItem(this.getMenuItemForID("DatabaseOperation"), false);
        MenuUtil.visibleMenuItem(this.getMenuItemForID("DeleteDatabase"), false);
        MenuUtil.visibleMenuItem(this.getMenuItemForID("InitializeDataBase"), false);
        MenuUtil.visibleMenuItem(this.getMenuItemForID("Rollbackdatabase"), false);
        MenuUtil.visibleMenuItem(this.getMenuItemForID("ActivationDataBase"), false);
        MenuUtil.visibleMenuItem(this.getMenuItemForID("CopyDataBase"), false);
        MenuUtil.visibleMenuItem(this.getMenuItemForID("setOSPFStatus"), false);
        MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator10"), false);
        MenuUtil.visibleMenuItem(this.getMenuItemForID("setCam"), false);
        MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator6"), false);
        MenuUtil.visibleMenuItem(this.getMenuItemForID("telnetTerminal"), false);
        MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator11"), false);
        MenuUtil.visibleMenuItem(this.getMenuItemForID("SoftwareStatistics"), false);
    }

    private void checkIsMiniDCForBMS() {
        if (!DCFrameWorkUtil.getIsSingleClient() && DCFrameWorkUtil.checkIsBmsMiniNMS()) {
            MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator8"), false);
            MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator9"), false);
        }
    }

    private void handleDeviceManagerMenu(boolean bIsBMSDeviceSelected, boolean bIsDMSDeviceSelected, boolean bIsT2000DeviceSelected) {
        boolean isOnlyBMS = DeviceTableUtil.isDevDomain(this.m_oDeviceTable, 1);
        boolean isOnlyDMS = DeviceTableUtil.isDevDomain(this.m_oDeviceTable, 2);
        boolean isOnlyT2000 = DeviceTableUtil.isDevDomain(this.m_oDeviceTable, 4);
        boolean isIsSingleClient = DCFrameWorkUtil.getIsSingleClient();
        if (!isIsSingleClient) {
            this.handleDeviceManagerMenuforSingleClient(bIsBMSDeviceSelected, bIsDMSDeviceSelected, bIsT2000DeviceSelected);
        } else {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("DeviceManagement"), true);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("DeviceManagement"), true);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("AddDevices"), true);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("AddDevices"), true);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("DeleteDevices"), true);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("DeleteDevices"), !this.isOperationInProgressForAnyDevice());
            if (isOnlyDMS) {
                boolean isSingleSelected = this.m_oDeviceTable.getSelectedRowCount() == 1;
                MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator6"), isSingleSelected);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("telnetTerminal"), true);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("telnetTerminal"), isSingleSelected);
            }
            if (isOnlyBMS || isOnlyDMS) {
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("SearchDevice"), false);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("SearchDevice"), false);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ExportDevices"), true);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("ExportDevices"), true);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ExportDevicesTemplate"), true);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("ExportDevicesTemplate"), true);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("ImportDevices"), true);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ImportDevices"), true);
                MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator7"), true);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("SetSNMP"), true);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("SetSNMP"), true);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("DeleteSNMP"), true);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("DeleteSNMP"), true);
                if (isOnlyBMS) {
                    MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator6"), false);
                    MenuUtil.visibleMenuItem(this.getMenuItemForID("telnetTerminal"), false);
                    MenuUtil.enableMenuItem((Component)this.getMenuItemForID("telnetTerminal"), false);
                }
            } else if (isOnlyT2000) {
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("SearchDevice"), true);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("SearchDevice"), true);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ExportDevices"), true);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("ExportDevices"), true);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ExportDevicesTemplate"), true);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("ExportDevicesTemplate"), true);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("ImportDevices"), true);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ImportDevices"), true);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("SetSNMP"), false);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("SetSNMP"), false);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("DeleteSNMP"), false);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("DeleteSNMP"), false);
                MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator7"), false);
                MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator6"), false);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("telnetTerminal"), false);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("telnetTerminal"), false);
            } else if (bIsBMSDeviceSelected && bIsDMSDeviceSelected && !bIsT2000DeviceSelected) {
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("SearchDevice"), false);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("SearchDevice"), false);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ExportDevices"), true);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("ExportDevices"), true);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ExportDevicesTemplate"), true);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("ExportDevicesTemplate"), true);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("ImportDevices"), true);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ImportDevices"), true);
                MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator7"), true);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("SetSNMP"), true);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("SetSNMP"), true);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("DeleteSNMP"), true);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("DeleteSNMP"), true);
                MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator6"), true);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("telnetTerminal"), true);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("telnetTerminal"), false);
            } else if (bIsT2000DeviceSelected) {
                MenuUtil.visibleMenuItem(this.getMenuItemForID("SearchDevice"), true);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("SearchDevice"), true);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("ImportDevices"), true);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ImportDevices"), true);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("ExportDevices"), true);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ExportDevices"), false);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("ExportDevicesTemplate"), true);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ExportDevicesTemplate"), true);
                MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator7"), true);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("SetSNMP"), false);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("SetSNMP"), true);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("DeleteSNMP"), false);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("DeleteSNMP"), true);
                MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator6"), true);
                MenuUtil.visibleMenuItem(this.getMenuItemForID("telnetTerminal"), true);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("telnetTerminal"), false);
            }
            this.modifyDeviceMenu();
        }
    }

    private void modifyDeviceMenu() {
        int index;
        int[] arrSelectedRow = this.m_oDeviceTable.getSelectedRows();
        boolean m_DevInT2000 = true;
        boolean m_DevInSameType = true;
        for (index = 0; index < arrSelectedRow.length; ++index) {
            DeviceInfo oDeviceInfoBenchMark = DeviceTableUtil.getDeviceInfoForTableRow(this.m_oDeviceTable, arrSelectedRow[index]);
            if (oDeviceInfoBenchMark.getDeviceTypeInfo().getDevDomain() == 4) continue;
            m_DevInT2000 = false;
            break;
        }
        for (index = 1; index < arrSelectedRow.length; ++index) {
            DeviceInfo oDeviceInfoBenchMark1 = DeviceTableUtil.getDeviceInfoForTableRow(this.m_oDeviceTable, arrSelectedRow[0]);
            DeviceInfo oDeviceInfoBenchMark = DeviceTableUtil.getDeviceInfoForTableRow(this.m_oDeviceTable, arrSelectedRow[index]);
            if (null == oDeviceInfoBenchMark || null == oDeviceInfoBenchMark1 || oDeviceInfoBenchMark1.getProtocol() == oDeviceInfoBenchMark.getProtocol()) continue;
            m_DevInSameType = false;
            break;
        }
        if (m_DevInT2000) {
            if (m_DevInSameType && !this.isOperationInProgressForAnyDevice()) {
                MenuUtil.visibleMenuItem(this.getMenuItemForID("ModifyDevice"), true);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ModifyDevice"), true);
            } else {
                MenuUtil.visibleMenuItem(this.getMenuItemForID("ModifyDevice"), true);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ModifyDevice"), false);
            }
        } else if (this.m_oDeviceTable.getSelectedRowCount() == 1 && !this.isOperationInProgressForAnyDevice()) {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("ModifyDevice"), true);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ModifyDevice"), true);
        } else {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("ModifyDevice"), true);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ModifyDevice"), false);
        }
    }

    private void handleDeviceManagerMenuforSingleClient(boolean bIsBMSDeviceSelected, boolean bIsDMSDeviceSelected, boolean bIsT2000DeviceSelected) {
        MenuUtil.visibleMenuItem(this.getMenuItemForID("AddDevices"), false);
        MenuUtil.visibleMenuItem(this.getMenuItemForID("SearchDevice"), false);
        MenuUtil.visibleMenuItem(this.getMenuItemForID("ModifyDevice"), false);
        MenuUtil.visibleMenuItem(this.getMenuItemForID("DeleteDevices"), false);
        MenuUtil.visibleMenuItem(this.getMenuItemForID("ImportDevices"), false);
        MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator6"), false);
        MenuUtil.visibleMenuItem(this.getMenuItemForID("SetSNMP"), false);
        MenuUtil.visibleMenuItem(this.getMenuItemForID("DeleteSNMP"), false);
        MenuUtil.visibleMenuItem(this.getMenuItemForID("telnetTerminal"), false);
        if (bIsT2000DeviceSelected) {
            if (bIsBMSDeviceSelected || bIsDMSDeviceSelected) {
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("DeviceManagement"), false);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ExportDevices"), false);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ExportDevicesTemplate"), true);
            } else {
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("DeviceManagement"), this.oPrivilegeInfo.isExportDevInfoPrivilege());
                MenuUtil.visibleMenuItem(this.getMenuItemForID("DeviceManagement"), this.oPrivilegeInfo.isExportDevInfoPrivilege());
                MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator9"), this.oPrivilegeInfo.isExportDevInfoPrivilege());
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ExportDevices"), this.oPrivilegeInfo.isExportDevInfoPrivilege());
                MenuUtil.visibleMenuItem(this.getMenuItemForID("ExportDevices"), this.oPrivilegeInfo.isExportDevInfoPrivilege());
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ExportDevicesTemplate"), this.oPrivilegeInfo.isExportDevInfoPrivilege());
                MenuUtil.visibleMenuItem(this.getMenuItemForID("ExportDevicesTemplate"), this.oPrivilegeInfo.isExportDevInfoPrivilege());
            }
        } else if ((bIsBMSDeviceSelected || bIsDMSDeviceSelected) && !bIsT2000DeviceSelected) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("DeviceManagement"), this.oPrivilegeInfo.isExportDevInfoPrivilege());
            MenuUtil.visibleMenuItem(this.getMenuItemForID("DeviceManagement"), this.oPrivilegeInfo.isExportDevInfoPrivilege());
            MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator9"), this.oPrivilegeInfo.isExportDevInfoPrivilege());
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ExportDevices"), this.oPrivilegeInfo.isExportDevInfoPrivilege());
            MenuUtil.visibleMenuItem(this.getMenuItemForID("ExportDevices"), this.oPrivilegeInfo.isExportDevInfoPrivilege());
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ExportDevicesTemplate"), true);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("ExportDevicesTemplate"), true);
        }
    }

    private void enableDomainSupportedMenuItem(boolean bIsBMSDeviceSelected, boolean bIsDMSDeviceSelected, boolean bIsT2000DeviceSelected, boolean bAnyDeviceInProgress) {
        if (!bIsT2000DeviceSelected) {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("DatabaseOperation"), false);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("ActivationDataBase"), false);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("DeleteDatabase"), false);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("InitializeDataBase"), false);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("Rollbackdatabase"), false);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("SoftwareStatistics"), false);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("setOSPFStatus"), false);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("setCam"), false);
            MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator10"), false);
            MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator7"), false);
            MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator11"), false);
        } else {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("DatabaseOperation"), true);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("DatabaseOperation"), true);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("ActivationDataBase"), true);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("DeleteDatabase"), true);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("InitializeDataBase"), true);
            List<DeviceInfo> devList = this.getSelectDevLst();
            if (DCCommonUtil.isTL1Dev(devList)) {
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("DeleteDatabase"), false);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("InitializeDataBase"), false);
            } else if (bAnyDeviceInProgress) {
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("DeleteDatabase"), false);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("InitializeDataBase"), false);
            } else {
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("DeleteDatabase"), this.oPrivilegeInfo.isDeleteDBPrivilege());
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("InitializeDataBase"), this.oPrivilegeInfo.isInitializeDBPrivilege());
            }
            if (DCCommonUtil.isNGWDMandMSTPDevType(devList) && DCCommonUtil.isPTNandRTNDevType(devList)) {
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("DeleteDatabase"), false);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("InitializeDataBase"), false);
            }
            MenuUtil.visibleMenuItem(this.getMenuItemForID("Rollbackdatabase"), true);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("SoftwareStatistics"), true);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("setOSPFStatus"), true);
            MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator10"), true);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("setCam"), this.oPrivilegeInfo.isSetCamPrivilege());
            if (this.isOperationInProgressForAnyDevice() || bIsBMSDeviceSelected || bIsDMSDeviceSelected) {
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("setCam"), false);
            } else {
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("setCam"), this.oPrivilegeInfo.isSetCamPrivilege());
            }
            MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator7"), true);
            MenuUtil.visibleMenuItem(this.getSeparatorForID("Seperator11"), true);
        }
        if (!bIsT2000DeviceSelected && !bIsBMSDeviceSelected && bIsDMSDeviceSelected) {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("RollbackPatch"), false);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("ExportCheckItemTemp"), true);
        } else {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("RollbackPatch"), true);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("ExportCheckItemTemp"), false);
        }
        if (bIsDMSDeviceSelected) {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("ExportCheckItemTemp"), true);
        }
        if (bIsT2000DeviceSelected && !bIsBMSDeviceSelected && !bIsDMSDeviceSelected) {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("Save"), false);
        } else {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("Save"), true);
            boolean isDeviceInProgress = this.isOperationInProgressForAnyDevice();
            if (!isDeviceInProgress && this.oPrivilegeInfo.isSavePrivilege() && !bIsT2000DeviceSelected) {
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("Save"), true);
            }
        }
        if (bIsBMSDeviceSelected || bIsDMSDeviceSelected) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("DeleteDatabase"), false);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("InitializeDataBase"), false);
        }
        MenuUtil.visibleMenuItem(this.getMenuItemForID("deleteMemory"), bIsDMSDeviceSelected);
        MenuUtil.visibleMenuItem(this.getSeparatorForID("deleteMemory"), bIsDMSDeviceSelected);
        if (bIsDMSDeviceSelected && bAnyDeviceInProgress) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("deleteMemory"), false);
        }
    }

    private void enableTaskItemsForMultipleDeviceTypes() {
        int[] arrSelectedRows = this.m_oDeviceTable.getSelectedRows();
        ArrayList<DeviceTypeInfo> oDeviceTypeList = new ArrayList<DeviceTypeInfo>(0);
        int[] iDeviceIdLst = new int[arrSelectedRows.length];
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            DeviceInfo oDevice = DeviceTableUtil.getDeviceInfoForTableRow(this.m_oDeviceTable, arrSelectedRows[i]);
            if (null != oDevice) {
                iDeviceIdLst[i] = oDevice.getDevId();
            }
            if (null == oDevice || oDeviceTypeList.contains(oDevice.getDeviceTypeInfo())) continue;
            oDeviceTypeList.add(oDevice.getDeviceTypeInfo());
        }
        DeviceTypeInfo[] arrDeviceTypes = oDeviceTypeList.toArray(new DeviceTypeInfo[oDeviceTypeList.size()]);
        if (DeviceTableUtil.isDevDomain(this.m_oDeviceTable, 4) && TaskModelUtil.isTaskTypeSupportedForT2000DeviceTypes(5, arrDeviceTypes, iDeviceIdLst)) {
            if (LicenseMonitor.getInstance().isControlTran()) {
                if (LicenseMonitor.getInstance().isCurrStatusValid()) {
                    MenuUtil.enableMenuItem((Component)this.getMenuItemForID("NewTask"), this.oPrivilegeInfo.isNewTaskPrivilege());
                    MenuUtil.visibleMenuItem(this.getMenuItemForID("packageDiffusionUpgradeDowngrade"), true);
                    MenuUtil.enableMenuItem((Component)this.getMenuItemForID("packageDiffusionUpgradeDowngrade"), true);
                } else {
                    MenuUtil.visibleMenuItem(this.getMenuItemForID("packageDiffusionUpgradeDowngrade"), false);
                }
            } else {
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("NewTask"), this.oPrivilegeInfo.isNewTaskPrivilege());
                MenuUtil.visibleMenuItem(this.getMenuItemForID("packageDiffusionUpgradeDowngrade"), true);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("packageDiffusionUpgradeDowngrade"), true);
            }
        } else {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("packageDiffusionUpgradeDowngrade"), false);
        }
        if (DeviceTableUtil.isDevDomain(this.m_oDeviceTable, 4) && TaskModelUtil.isSupportedForDeviceTypes(4, arrDeviceTypes, iDeviceIdLst)) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("NewTask"), this.oPrivilegeInfo.isNewTaskPrivilege());
            MenuUtil.visibleMenuItem(this.getMenuItemForID("packageUpgradedowngradetask"), true);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("packageUpgradedowngradetask"), true);
        } else {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("packageUpgradedowngradetask"), false);
        }
        if (DeviceTableUtil.isDevDomain(this.m_oDeviceTable, 4) && TaskModelUtil.isSupportedForDeviceTypes(3, arrDeviceTypes, iDeviceIdLst)) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("NewTask"), this.oPrivilegeInfo.isNewTaskPrivilege());
            MenuUtil.visibleMenuItem(this.getMenuItemForID("MimcPackageUpgrade"), true);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("MimcPackageUpgrade"), true);
        } else {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("MimcPackageUpgrade"), false);
        }
        Vector<Integer> oDomainListVector = new Vector<Integer>();
        oDomainListVector.add(1);
        oDomainListVector.add(2);
        if (DeviceTableUtil.isMultipleDevDomain(this.m_oDeviceTable, oDomainListVector) && TaskModelUtil.isTaskTypeSupportedForT2000DeviceTypes(0, arrDeviceTypes, iDeviceIdLst)) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("NewTask"), this.oPrivilegeInfo.isNewTaskPrivilege());
            MenuUtil.visibleMenuItem(this.getMenuItemForID("UpgradeDowngrade"), true);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("UpgradeDowngrade"), true);
        } else {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("UpgradeDowngrade"), false);
        }
        if (TaskModelUtil.isSupportedForDeviceTypes(2, arrDeviceTypes, iDeviceIdLst)) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("NewTask"), this.oPrivilegeInfo.isNewTaskPrivilege());
            MenuUtil.visibleMenuItem(this.getMenuItemForID("PatchUpdate"), true);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("PatchUpdate"), true);
        } else {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("PatchUpdate"), false);
        }
        if (DeviceTableUtil.isMultipleDevDomain(this.m_oDeviceTable, oDomainListVector) && TaskModelUtil.isSupportedForDeviceTypes(7, arrDeviceTypes, iDeviceIdLst)) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("NewTask"), this.oPrivilegeInfo.isNewTaskPrivilege());
            MenuUtil.visibleMenuItem(this.getMenuItemForID("oltUpdate"), true);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("oltUpdate"), true);
        } else {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("oltUpdate"), false);
        }
    }

    private List<DeviceInfo> getSelectDevLst() {
        ArrayList<DeviceInfo> devList = new ArrayList<DeviceInfo>();
        int[] arrSelectedRows = this.m_oDeviceTable.getSelectedRows();
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            DeviceInfo oDevice = (DeviceInfo)this.m_oDeviceTable.getValueAt(arrSelectedRows[i], 0);
            if (null == oDevice) continue;
            devList.add(oDevice);
        }
        return devList;
    }

    private void displayDomainSpecificMenuItems(boolean bAnyT200DevicePresent, boolean bAnyBMSDevicesPresent) {
        MenuUtil.visibleMenuItem(this.getMenuItemForID("DatabaseOperation"), bAnyT200DevicePresent);
        MenuUtil.enableMenuItem((Component)this.getMenuItemForID("DatabaseOperation"), bAnyT200DevicePresent);
        if (bAnyT200DevicePresent && DCCommonUtil.isTL1Dev(this.getSelectDevLst())) {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("DeleteDatabase"), false);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("InitializeDataBase"), false);
        } else {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("DeleteDatabase"), bAnyT200DevicePresent);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("InitializeDataBase"), bAnyT200DevicePresent);
        }
        MenuUtil.visibleMenuItem(this.getMenuItemForID("Rollbackdatabase"), bAnyT200DevicePresent);
        MenuUtil.visibleMenuItem(this.getMenuItemForID("ActivationDataBase"), bAnyT200DevicePresent);
        MenuUtil.visibleMenuItem(this.getMenuItemForID("CopyDataBase"), bAnyT200DevicePresent);
        JMenuItem oAutoLoadMenu = this.getMenuItemForID("AutoLoad");
        if (null != oAutoLoadMenu) {
            if (bAnyBMSDevicesPresent && !DCFrameWorkUtil.getIsSingleClient()) {
                MenuUtil.enableMenuItem((Component)oAutoLoadMenu, this.oPrivilegeInfo.isAutoLoadParaPrivilege());
                MenuUtil.visibleMenuItem(oAutoLoadMenu, this.oPrivilegeInfo.isAutoLoadParaPrivilege());
            } else {
                MenuUtil.enableMenuItem((Component)oAutoLoadMenu, false);
                MenuUtil.visibleMenuItem(oAutoLoadMenu, false);
            }
        }
        if (DeviceTableUtil.isDevDomain(this.m_oDeviceTable, 4)) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("SoftwareStatistics"), this.oPrivilegeInfo.isSoftSatPrivilege());
            MenuUtil.visibleMenuItem(this.getMenuItemForID("SoftwareStatistics"), this.oPrivilegeInfo.isSoftSatPrivilege());
            if (!this.isOperationInProgressForAnyDevice()) {
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("setOSPFStatus"), this.oPrivilegeInfo.isSetOSPFStatusPrivilege());
                MenuUtil.visibleMenuItem(this.getMenuItemForID("setOSPFStatus"), this.oPrivilegeInfo.isSetOSPFStatusPrivilege());
            }
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("setCam"), this.oPrivilegeInfo.isSetCamPrivilege());
            MenuUtil.visibleMenuItem(this.getMenuItemForID("setCam"), this.oPrivilegeInfo.isSetCamPrivilege());
        }
    }

    private void enableTaskMenuItems() {
        int[] arrSelectedRows = this.m_oDeviceTable.getSelectedRows();
        DeviceInfo oDeviceInfo = DeviceTableUtil.getDeviceInfoForTableRow(this.m_oDeviceTable, arrSelectedRows[0]);
        if (null == oDeviceInfo) {
            return;
        }
        int[] iDeviceIdLst = new int[]{oDeviceInfo.getDevId()};
        DeviceTypeInfo[] arrDeviceTypes = new DeviceTypeInfo[]{oDeviceInfo.getDeviceTypeInfo()};
        if (null == arrDeviceTypes || 0 == arrDeviceTypes.length) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("NewTask"), false);
            return;
        }
        MenuUtil.enableMenuItem((Component)this.getMenuItemForID("NewTask"), this.oPrivilegeInfo.isNewTaskPrivilege());
        if (!this.oPrivilegeInfo.isNewTaskPrivilege()) {
            return;
        }
        if (TaskModelUtil.isTaskTypeSupportedForDeviceTypes(10, arrDeviceTypes, iDeviceIdLst)) {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("UpgradeDowngrade"), true);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("UpgradeDowngrade"), true);
        } else {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("UpgradeDowngrade"), false);
        }
        if (TaskModelUtil.isTaskTypeSupportedForDeviceTypes(2, arrDeviceTypes, iDeviceIdLst)) {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("PatchUpdate"), true);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("PatchUpdate"), true);
        } else {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("PatchUpdate"), false);
        }
        if (TaskModelUtil.isTaskTypeSupportedForDeviceTypes(3, arrDeviceTypes, iDeviceIdLst)) {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("MimcPackageUpgrade"), true);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("MimcPackageUpgrade"), true);
        } else {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("MimcPackageUpgrade"), false);
        }
        if (DeviceTableUtil.isDevDomain(this.m_oDeviceTable, 4) && TaskModelUtil.isSupportedForDeviceTypes(4, arrDeviceTypes, iDeviceIdLst)) {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("packageUpgradedowngradetask"), true);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("packageUpgradedowngradetask"), true);
        } else {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("packageUpgradedowngradetask"), false);
        }
        if (TaskModelUtil.isTaskTypeSupportedForDeviceTypes(11, arrDeviceTypes, iDeviceIdLst)) {
            if (LicenseMonitor.getInstance().isControlTran()) {
                if (LicenseMonitor.getInstance().isCurrStatusValid()) {
                    MenuUtil.visibleMenuItem(this.getMenuItemForID("packageDiffusionUpgradeDowngrade"), true);
                    MenuUtil.enableMenuItem((Component)this.getMenuItemForID("packageDiffusionUpgradeDowngrade"), true);
                } else {
                    MenuUtil.visibleMenuItem(this.getMenuItemForID("packageDiffusionUpgradeDowngrade"), false);
                }
            } else {
                MenuUtil.visibleMenuItem(this.getMenuItemForID("packageDiffusionUpgradeDowngrade"), true);
                MenuUtil.enableMenuItem((Component)this.getMenuItemForID("packageDiffusionUpgradeDowngrade"), true);
            }
        } else {
            MenuUtil.visibleMenuItem(this.getMenuItemForID("packageDiffusionUpgradeDowngrade"), false);
        }
    }

    private IViewConfiguration getViewConfig() {
        IViewConfiguration oViewConfig = null;
        IDeviceTypeConfigModel oDeviceTypeConfigModel = this.getDeviceTypeCfgModel();
        if (null != oDeviceTypeConfigModel) {
            oViewConfig = oDeviceTypeConfigModel.getViewConfiguration();
        }
        return oViewConfig;
    }

    private IDeviceTypeConfigModel getDeviceTypeCfgModel() {
        IDeviceTypeConfigModel oDeviceTypeConfigModelTmp = null;
        IDeviceTypeConfigModel oDeviceTypeConfigModel = null;
        int[] arrSelectedRows = this.m_oDeviceTable.getSelectedRows();
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            String[] arrSupportedMenuItemsId;
            String[] arrSupportedMenuItemsIdTmp;
            DeviceInfo oDeviceInfo = DeviceTableUtil.getDeviceInfoForTableRow(this.m_oDeviceTable, arrSelectedRows[i]);
            if (null == oDeviceInfo) {
                return oDeviceTypeConfigModel;
            }
            int[] iDeviceIdLst = new int[]{oDeviceInfo.getDevId()};
            DeviceTypeInfo oDeviceTypeInfo = oDeviceInfo.getDeviceTypeInfo();
            if (null == oDeviceTypeInfo) {
                return oDeviceTypeConfigModel;
            }
            oDeviceTypeConfigModelTmp = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDeviceTypeInfo, iDeviceIdLst);
            if (null == oDeviceTypeConfigModel && null != oDeviceTypeConfigModelTmp) {
                oDeviceTypeConfigModel = oDeviceTypeConfigModelTmp;
                continue;
            }
            if (null == oDeviceTypeConfigModelTmp || null == oDeviceTypeConfigModel || (arrSupportedMenuItemsIdTmp = oDeviceTypeConfigModelTmp.getViewConfiguration().getViewConfiguration(0)).length > (arrSupportedMenuItemsId = oDeviceTypeConfigModel.getViewConfiguration().getViewConfiguration(0)).length) continue;
            oDeviceTypeConfigModel = oDeviceTypeConfigModelTmp;
        }
        return oDeviceTypeConfigModel;
    }

    private void enableMenuItemsForSelectedDevicesTypes() {
        String[] arrSupportedMenuItemsId = new String[]{};
        IViewConfiguration oViewConfig = this.getViewConfig();
        if (null != oViewConfig) {
            arrSupportedMenuItemsId = oViewConfig.getViewConfiguration(0);
        }
        if (null != arrSupportedMenuItemsId) {
            this.enableSupportedMenuItems(arrSupportedMenuItemsId);
        }
    }

    public boolean isOperationInProgressForAnyDevice() {
        int[] arrSelectedRows = this.m_oDeviceTable.getSelectedRows();
        BusyDeviceObjectStore oBusyDeviceStore = BusyDeviceObjectStore.getInstance();
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            int iDeviceID = DeviceTableUtil.getDeviceIDForTableRow(this.m_oDeviceTable, arrSelectedRows[i]);
            if (!oBusyDeviceStore.isDeviceOperationInProgress(iDeviceID)) continue;
            return true;
        }
        return false;
    }

    private boolean isSupportCancelOperation() {
        int[] arrSelectedRows = this.m_oDeviceTable.getSelectedRows();
        BusyDeviceObjectStore oBusyDeviceStore = BusyDeviceObjectStore.getInstance();
        IDeviceTypeConfigModel devTypeConfigModel = this.getDeviceTypeCfgModel();
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            int iDeviceID = DeviceTableUtil.getDeviceIDForTableRow(this.m_oDeviceTable, arrSelectedRows[i]);
            OperationStatus oprStatus = oBusyDeviceStore.getDeviceProgress(iDeviceID);
            if (null == oprStatus) {
                return false;
            }
            if (3 != oprStatus.getOperationType() && 10 != oprStatus.getOperationType() || 0 < oprStatus.getTaskID()) {
                return false;
            }
            int iOperationID = -1;
            if (3 == oprStatus.getOperationType()) {
                iOperationID = 2;
            } else if (10 == oprStatus.getOperationType()) {
                iOperationID = 3;
            }
            IOperation operation = devTypeConfigModel.getOperationObj(0, iOperationID);
            if (null != operation && operation.isCancelable()) continue;
            return false;
        }
        return true;
    }

    private boolean isSupportDeleteNEFileOpr(DeviceTypeInfo oTypeInfo, DeviceInfo oDevice) {
        IOperation operation;
        IDeviceTypeConfigModel oDeviceTypeConfigModel = null;
        int[] iDeviceIdLst = new int[]{oDevice.getDevId()};
        DeviceTypeInfo oTypeInfotmp = (DeviceTypeInfo)CloneUtil.getClone(oTypeInfo);
        String strDevTypeVer = oTypeInfotmp.getDevTypeVersionName() + "_telnet";
        oTypeInfotmp.setDevTypeVersionName(strDevTypeVer);
        oDeviceTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oTypeInfotmp, iDeviceIdLst);
        if (null != oDeviceTypeConfigModel && null != (operation = oDeviceTypeConfigModel.getOperationObj(5, 41)) && oDevice.getRoleType() != 1 && oDevice.getRoleType() != 2) {
            DCDebugTracer.traceError("[HGMP]isSupportDeleteNEFileOpr:1.device=" + oDevice);
            return true;
        }
        DCDebugTracer.traceError("[HGMP]isSupportDeleteNEFileOpr:2.device=" + oDevice);
        return false;
    }

    private boolean isVisibleDeleteNEFileMenu(DeviceTypeInfo oTypeInfo, DeviceInfo oDevice) {
        IOperation operation;
        IDeviceTypeConfigModel oDeviceTypeConfigModel = null;
        int[] iDeviceIdLst = new int[]{oDevice.getDevId()};
        DeviceTypeInfo oTypeInfotmp = (DeviceTypeInfo)CloneUtil.getClone(oTypeInfo);
        String strDevTypeVer = oTypeInfotmp.getDevTypeVersionName() + "_telnet";
        oTypeInfotmp.setDevTypeVersionName(strDevTypeVer);
        oDeviceTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oTypeInfotmp, iDeviceIdLst);
        if (null != oDeviceTypeConfigModel && null != (operation = oDeviceTypeConfigModel.getOperationObj(5, 41))) {
            return true;
        }
        DCDebugTracer.traceError("[HGMP]isVisibleDeleteMemory:3.device=" + oDevice);
        return false;
    }

    public void enableAllMenuItems(boolean bFlag) {
        Iterator oMenuItemIterator = this.m_oMenuListFromXML.keySet().iterator();
        while (oMenuItemIterator.hasNext()) {
            String strMenuItemID = (String)oMenuItemIterator.next();
            JMenuItem oMenuItem = this.getMenuItemForID(strMenuItemID);
            MenuUtil.enableMenuItem((Component)oMenuItem, bFlag);
        }
        while (oMenuItemIterator.hasNext()) {
            String strSeparatorID = (String)oMenuItemIterator.next();
            JSeparator oSeparator = this.getSeparatorForID(strSeparatorID);
            if (null == oSeparator) continue;
            oSeparator.setEnabled(bFlag);
        }
    }

    public JMenuItem getMenuItemForID(String strMenuItemID) {
        JMenuItem tempMenu = null;
        if (null != this.m_oMenuListFromXML.get(strMenuItemID)) {
            tempMenu = (JMenuItem)this.m_oMenuListFromXML.get(strMenuItemID);
        } else {
            DCDebugTracer.traceError("[menu] get Menu Item  : " + strMenuItemID + " failed, please check devicetablepopupmenu.xml file. ");
            tempMenu = new JMenuItem();
        }
        return tempMenu;
    }

    public JSeparator getSeparatorForID(String strSeparatorID) {
        return (JSeparator)this.m_oSeparatorListFromXML.get(strSeparatorID);
    }

    public void enableMenuItem(String strMenuItemID, boolean bFlag) {
        JMenuItem oMenuItem = this.getMenuItemForID(strMenuItemID);
        MenuUtil.enableMenuItem((Component)oMenuItem, bFlag);
    }

    public void enableSupportedMenuItems(String[] arrSupportedMenuItemsId) {
        Map<String, Boolean> menuItemPrivilegeMap = this.oPrivilegeInfo.getMenuItemPrivilegeMap();
        for (int i = 0; i < arrSupportedMenuItemsId.length; ++i) {
            JMenuItem oMenuItem = this.getMenuItemForID(arrSupportedMenuItemsId[i]);
            if (null == oMenuItem) continue;
            if (null != menuItemPrivilegeMap.get(arrSupportedMenuItemsId[i])) {
                oMenuItem.setEnabled(menuItemPrivilegeMap.get(arrSupportedMenuItemsId[i]));
            } else {
                oMenuItem.setEnabled(true);
            }
            if (oMenuItem.isVisible() || !oMenuItem.isEnabled()) continue;
            oMenuItem.setVisible(true);
        }
    }

    public void checkUserPrivileges() {
        this.oPrivilegeInfo.checkUserPrivileges();
    }
}

