/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceview.devicetable;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.dialog.CommonProgressDlg;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceTablePanel;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommController;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;

public class ConfigOSPFSetDlg
extends DCModalDialog {
    private static final long serialVersionUID = 1L;
    private JLabel m_oOperationTypeLbl = null;
    private JRadioButton m_oOpenRadBtn = null;
    private JRadioButton m_oCloseRadBtn = null;
    private ButtonGroup oRadBtnOption = null;
    private List<Integer> m_oDevIDLst = null;
    private DeviceTablePanel m_oDeviceTablePanel = null;

    public ConfigOSPFSetDlg(DeviceTablePanel oDeviceTablePanel, List<Integer> devIDLst) {
        this.m_oDeviceTablePanel = oDeviceTablePanel;
        this.m_oDevIDLst = devIDLst;
        this.initGUI();
    }

    private void initGUI() {
        ResourceManager resMg = ResourceManager.getInstance();
        this.setTitle(resMg.getResString("TITLE_OSPF_DLG_SET_OSPF"));
        this.setSize(410, 120);
        JPanel mainPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        mainPanel.setLayout(gridBagLayout);
        mainPanel.add((Component)this.getRadioPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)this.getBtnPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 0, 0, 12), 0, 0));
        this.getContentPane().add(mainPanel);
        DCHelpManager.getInstance().enableF1HelpKey(mainPanel, this.getCurrentContext());
    }

    private JPanel getBtnPanel() {
        ResourceManager resMg = ResourceManager.getInstance();
        JPanel m_oBtnPanel = new JPanel();
        FlowLayout jPaneLayout = new FlowLayout(2, 5, 0);
        m_oBtnPanel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        m_oBtnPanel.setLayout(jPaneLayout);
        m_oBtnPanel.setPreferredSize(new Dimension(410, 2));
        m_oBtnPanel.setMinimumSize(new Dimension(410, 25));
        this.m_oOKBtn.setText(resMg.getResString("OK_BUTTON"));
        this.m_oOKBtn.setPreferredSize(new Dimension(80, 20));
        this.m_oOKBtn.setMinimumSize(new Dimension(80, 20));
        this.m_oCancelBtn.setText(resMg.getResString("CANCEL_BUTTON"));
        this.m_oCancelBtn.setPreferredSize(new Dimension(80, 20));
        this.m_oCancelBtn.setMinimumSize(new Dimension(80, 20));
        m_oBtnPanel.add(this.m_oCancelBtn);
        m_oBtnPanel.add(this.m_oOKBtn);
        return m_oBtnPanel;
    }

    private JPanel getRadioPanel() {
        ResourceManager resMg = ResourceManager.getInstance();
        this.m_oOperationTypeLbl = new JLabel(resMg.getResString("LBL_OSPF_OPRATION_TYPE"));
        this.m_oOperationTypeLbl.setPreferredSize(new Dimension(100, 20));
        this.m_oOperationTypeLbl.setMinimumSize(new Dimension(100, 20));
        this.m_oOpenRadBtn = new JRadioButton();
        this.m_oOpenRadBtn.setName("ConfigOSPFSetDlg_m_oOpenRadBtn");
        this.m_oOpenRadBtn.setText(resMg.getResString("RAD_OSPF_TYPE_OPEN"));
        this.m_oOpenRadBtn.setSelected(true);
        this.m_oOpenRadBtn.setPreferredSize(new Dimension(100, 20));
        this.m_oOpenRadBtn.setMinimumSize(new Dimension(100, 20));
        this.m_oCloseRadBtn = new JRadioButton();
        this.m_oCloseRadBtn.setName("ConfigOSPFSetDlg_m_oCloseRadBtn");
        this.m_oCloseRadBtn.setText(resMg.getResString("RAD_OSPF_TYPE_CLOSE"));
        this.m_oCloseRadBtn.setPreferredSize(new Dimension(100, 20));
        this.m_oCloseRadBtn.setMinimumSize(new Dimension(100, 20));
        this.oRadBtnOption = new ButtonGroup();
        this.oRadBtnOption.add(this.m_oOpenRadBtn);
        this.oRadBtnOption.add(this.m_oCloseRadBtn);
        JPanel radioPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        radioPanel.setLayout(gridBagLayout);
        radioPanel.setPreferredSize(new Dimension(410, 20));
        radioPanel.add((Component)this.m_oOperationTypeLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        radioPanel.add((Component)this.m_oOpenRadBtn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        radioPanel.add((Component)this.m_oCloseRadBtn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        return radioPanel;
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_DEVICE_SET_OSPF";
    }

    @Override
    protected void oKButton_ActionPerformed() {
        boolean bOpenCmd = this.m_oOpenRadBtn.isSelected();
        String sDlgTitle = ResourceManager.getInstance().getResString("TITLE_OSPF_DLG_OPEN");
        if (!bOpenCmd) {
            sDlgTitle = ResourceManager.getInstance().getResString("TITLE_OSPF_DLG_CLOSE");
        }
        int iReqId = DCFrameWorkUtil.generateRequestId();
        final CommonProgressDlg commonFileCheckResultDlg = new CommonProgressDlg(44005, this.m_oDevIDLst);
        commonFileCheckResultDlg.setProgressDlgId(iReqId);
        commonFileCheckResultDlg.setTitle(sDlgTitle);
        try {
            TaskAsynCommController.getInstance().setOSPFStatus(iReqId, bOpenCmd, this.m_oDevIDLst);
            this.m_oDeviceTablePanel.setCommonProgressDlg(commonFileCheckResultDlg);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    commonFileCheckResultDlg.setVisible(true);
                }
            });
        }
        catch (DCException e) {
            commonFileCheckResultDlg.dispose();
            DCOptionPane.showMessageDialog(null, e.getMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
        }
        this.dispose();
    }
}

