/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceview.devicetable;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.DCGUIUtil;
import com.huawei.dc.common.MyMouseMotionAdapter;
import com.huawei.dc.common.asndatacenter.AsnCheckUpgradeDevInfo;
import com.huawei.dc.common.asndatacenter.AsnDevSetInfo;
import com.huawei.dc.common.asndatacenter.AsnDevSetInfoLst;
import com.huawei.dc.common.asndatacenter.AsnDevUpgrModeInfo;
import com.huawei.dc.common.asndatacenter.AsnDevUpgrModeInfoLst;
import com.huawei.dc.common.asndatacenter.AsnGetDevUpgradeModeRsp;
import com.huawei.dc.common.components.devicetreepanel.DeviceTreePanel;
import com.huawei.dc.common.components.dialog.CommonProgressDlg;
import com.huawei.dc.common.components.dialog.ProgressDlg;
import com.huawei.dc.common.components.dialog.SimpleProgressDlg;
import com.huawei.dc.common.components.treetable.model.DCTreeTableModel;
import com.huawei.dc.common.components.treetable.model.DeviceTreeTableModel;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.components.treetable.view.DeviceTreeTableCellRenderer;
import com.huawei.dc.common.components.treetable.view.JSortTreeTable;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpForErrCodeUtil;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.common.util.StatusBarManager;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.deviceinfo.DeviceVersionInfo;
import com.huawei.dc.devicemanagement.deviceoperation.DeviceCommonManualOpr;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.DeleteDeviceFileDialog;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.DeviceMemoryInfo;
import com.huawei.dc.devicemanagement.deviceview.DeviceMainPanel;
import com.huawei.dc.devicemanagement.deviceview.common.DeviceIDDataObject;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.DeviceSelectionEvent;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.IDeviceInfoSelectionListener;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceManagementPopupMenuManager;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceTableButtonPanel;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceTableManager;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceTablePanelUtil;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceTableUtil;
import com.huawei.dc.devicemanagement.deviceview.devicetable.devicesearch.IColumnInfo;
import com.huawei.dc.devicemanagement.deviceview.devicetable.devicesearch.ISearchManager;
import com.huawei.dc.devicemanagement.model.CommonDevColumnInfo;
import com.huawei.dc.devicemanagement.model.deviceinfo.VisualData;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.deviceoperation.IDeviceOperationManager;
import com.huawei.dc.deviceoperation.util.OperationStatus;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.standalone.IManualOperation;
import com.huawei.dc.standalone.INEManagement;
import com.huawei.dc.standalone.controller.IDCStandAloneSyncCtrller;
import com.huawei.dc.standalone.controller.StandAloneSyncCtrller;
import com.huawei.dc.standalone.model.T2000DevInfo;
import com.huawei.dc.standalone.view.ModifyGatewayDevDlg;
import com.huawei.dc.taskmgmt.TaskManagementMainPanel;
import com.huawei.dc.taskmgmt.controller.ITaskNotificationListener;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommController;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommForSpecificConfInfoNotify;
import com.huawei.dc.taskmgmt.controller.TaskEvent;
import com.huawei.dc.taskmgmt.controller.TaskInfoNotifier;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.common.CreateTaskDialog;
import com.huawei.dc.taskmgmt.view.createtask.ViewCommandResultDialog;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTablePanel;
import com.huawei.u2000.component.table.customize.TableCustomizer;
import com.swimap.iview.templates.filtertreetable.TreeTableModel;
import com.swimap.iview.util.DebugTracer;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;

public abstract class AbstractDeviceTablePanel
extends JPanel
implements ITaskNotificationListener,
ISearchManager,
IManualOperation,
INEManagement {
    public static final int DEVICE_IP_COLUMN = 2;
    public static final int ICON_COLUMN_INDEX = 0;
    public static final int OPERATION_STATUS_INDEX = 6;
    public static final int RESOURCE_IP_INDEX = 2;
    public static final int RESOURCE_NAME_INDEX = 1;
    public static final int RESOURCE_TYPE_INDEX = 3;
    public static final int RESOURCE_VERSION_INDEX = 4;
    public static final int DEVICE_PATCH_VERSION_INDEX = 5;
    private static final long serialVersionUID = -473721387633922916L;
    DeviceTableButtonPanel m_oButtonPanel = null;
    protected boolean isExportDevTemplate = false;
    protected boolean m_bCancelPressed = false;
    protected boolean m_bFirstOpenFromDevPanel = false;
    protected boolean m_bGettingDevInfo = false;
    protected boolean m_bNeedNotify = true;
    protected int iNeedToSendCmdCodeCount = 0;
    protected CommonDevColumnInfo m_devInfoColumnInfo = new CommonDevColumnInfo();
    protected ProgressDlg m_dlg = null;
    protected int[] m_iArrdeviceIds;
    protected boolean m_isCurrentPanel = true;
    protected DeviceInfo[] m_oArrDevInfo;
    protected CommonProgressDlg m_oCommonProgressDlg = null;
    protected DeviceCommonManualOpr m_oDevCommonManualOpr;
    protected IDeviceInfoManager m_oDeviceInfoMgr;
    protected DeviceMainPanel m_oDeviceMainPanel;
    protected HashMap<Integer, DeviceMemoryInfo> m_oDeviceMemoryInfoMap = null;
    protected IDeviceOperationManager m_oDeviceOperationMgr;
    protected JScrollPane m_oDeviceTableScrollPane;
    protected JTree m_oDeviceTree;
    protected DCSortableTreeTable m_oDeviceTreeTable;
    protected DeviceTreeTableModel m_oDeviceTreeTableModel;
    protected SimpleProgressDlg m_oGettingDevtProgressDlg = null;
    protected List<IDeviceInfoSelectionListener> m_oListeners;
    protected List<Resource> m_oResList = null;
    protected ResourceManager m_oResourceMgr;
    protected byte[] m_oSyncModeObject;
    protected byte[] m_oSyncObject = new byte[0];
    protected DeviceTableManager m_oTableManager;
    protected TableMouseListener m_oTableMouseListener = null;
    protected TableSelectionListener m_oTableSelectionListener = null;
    protected MyKeyAdapter m_oTableKeyAdapter = null;
    protected SimpleProgressDlg m_oValidationProgressDlg = null;

    public AbstractDeviceTablePanel(IDeviceInfoManager oDeviceInfoManager, IDeviceOperationManager oDeviceOperationManager, DeviceMainPanel oDeviceMainPanel) {
        this.m_oSyncModeObject = new byte[0];
        this.m_oDeviceMainPanel = oDeviceMainPanel;
        this.m_oListeners = new ArrayList<IDeviceInfoSelectionListener>(2);
        this.m_oDeviceInfoMgr = oDeviceInfoManager;
        this.m_oDeviceInfoMgr.registManualOprMessage(this);
        this.m_oResourceMgr = ResourceManager.getInstance();
        this.m_oDeviceOperationMgr = oDeviceOperationManager;
        this.jInit();
        this.m_oDevCommonManualOpr = new DeviceCommonManualOpr(this);
    }

    public void addDevInfoSelectionListener(IDeviceInfoSelectionListener eventListener) {
        if (null != eventListener && !this.m_oListeners.contains(eventListener)) {
            this.m_oListeners.add(eventListener);
        }
    }

    @Override
    public void addNewProxyNode() {
    }

    private void addTableSelectionListener() {
        if (null == this.m_oTableSelectionListener) {
            this.m_oTableSelectionListener = new TableSelectionListener();
        }
        if (null == this.m_oTableMouseListener) {
            this.m_oTableMouseListener = new TableMouseListener();
        }
        if (null == this.m_oTableKeyAdapter) {
            this.m_oTableKeyAdapter = new MyKeyAdapter();
        }
        this.m_oDeviceTreeTable.addMouseListener(this.m_oTableMouseListener);
        this.m_oDeviceTreeTable.getSelectionModel().addListSelectionListener(this.m_oTableSelectionListener);
        this.m_oDeviceTreeTable.addKeyListener(this.m_oTableKeyAdapter);
    }

    protected boolean checkOtherTaskIsCreating() {
        if (!CreateTaskDialog.isCreatingTask()) {
            return false;
        }
        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("EXIST_TASK_CREATING_NOW"), DCFrameWorkUtil.getLocalizedString("SUGGESTION"), 1);
        this.openTaskMainPanelFromDevicepanel();
        DCFrameWorkUtil.defaultCursor();
        return true;
    }

    public void closeGettingDevProgressDlg() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            DCDebugTracer.trace(ex);
        }
        this.m_bGettingDevInfo = false;
        DCFrameWorkUtil.enableComponent(DCFrameWorkUtil.getToolBarButton("refreshTree"), true);
        if (DCFrameWorkUtil.getIsSingleClient()) {
            DCFrameWorkUtil.getDCModuleManager().checkXFTPStatus();
            return;
        }
        DCDebugTracer.trace("close getting ne progress dialog");
        if (null == this.m_oGettingDevtProgressDlg) {
            DebugTracer.trace((String)"AbstractDeviceTablePanel#closeGettingDevProgressDlg#m_oGettingDevtProgressDlg is NULL");
        }
        if (null != this.m_oGettingDevtProgressDlg) {
            this.m_oGettingDevtProgressDlg.dispose();
            if (null != this.m_oGettingDevtProgressDlg && this.m_oGettingDevtProgressDlg.isVisible()) {
                DCDebugTracer.trace("dispose failed.try set to null.");
                this.m_oGettingDevtProgressDlg.setVisible(false);
            }
            DCDebugTracer.trace("set ne progress dialog null");
        }
        DCFrameWorkUtil.getDCModuleManager().checkXFTPStatus();
    }

    protected void createTreeTable() {
        this.m_oDeviceTreeTable = new DCSortableTreeTable(this.m_oDeviceTreeTableModel);
        this.m_oDeviceTreeTable.setName("DeviceView_DeviceTablePanel_m_oDeviceTreeTable");
        this.m_oDeviceTreeTable.setOpaque(false);
        this.m_oDeviceTreeTableModel.setFlag("device_main_table");
        this.m_oDeviceTreeTable.getColumnModel().getColumn(0).setMaxWidth(40);
        this.m_oDeviceTreeTable.getSelectionModel().setSelectionMode(2);
        this.setCloumnWinth();
        this.m_oDeviceTree = this.m_oDeviceTreeTable.getTree();
        this.m_oDeviceTree.setName("DeviceView_DevicetablePanel_m_oDeviceTree");
        this.m_oDeviceTree.setToggleClickCount(2);
        this.initializeTree();
        this.addTableSelectionListener();
    }

    protected void createTreeTableModel() {
        String[] arrHeaderFields = new String[]{this.m_oResourceMgr.getResString("DEVICE_TABLE_HEADER_ICON_COLUMN"), this.m_oResourceMgr.getResString("DEVICE_TABLE_HEADER_RESOURCE_NAME"), this.m_oResourceMgr.getResString("DEVICE_TABLE_HEADER_RESOURCE_IP"), this.m_oResourceMgr.getResString("DEVICE_TABLE_HEADER_RESOURCE_TYPE"), this.m_oResourceMgr.getResString("DEVICE_TABLE_HEADER_RESOURCE_VERSION"), this.m_oResourceMgr.getResString("DEVICE_TABLE_HEADER_RESOURCE_PATCH_VERSION"), this.m_oResourceMgr.getResString("DEVICE_TABLE_HEADER_OPERATION_STATUS")};
        Class[] arrColumnTypes = new Class[]{TreeTableModel.class, String.class, VisualData.class, String.class, String.class, String.class, String.class, String.class};
        boolean[] arrSortableColumns = new boolean[]{false, true, true, true, true, true, true};
        boolean[] arrEditableColumns = new boolean[]{true, false, false, false, false, false, false};
        this.m_oDeviceTreeTableModel = new DeviceTreeTableModel(arrHeaderFields, arrColumnTypes, arrSortableColumns, arrEditableColumns);
    }

    private void deviceTable_MousePressed(MouseEvent oMouseEvent) {
        int iColumn;
        int iSelectedRow;
        Object oValue;
        DeviceInfo oDevTypeInfo;
        int iClickedRow = this.m_oDeviceTreeTable.rowAtPoint(oMouseEvent.getPoint());
        IDeviceTypeConfigModel oDeviceTypeConfigModel = null;
        boolean bIsClickedRowSelected = false;
        int[] nRows = this.m_oDeviceTreeTable.getSelectedRows();
        if (this.m_oDeviceTreeTable.getRowCount() == 0) {
            if (1 == oMouseEvent.getButton()) {
                return;
            }
            DeviceManagementPopupMenuManager oDevOperationPopupMenuMgr = this.m_oButtonPanel.getDevOperationPopupMenuMgr();
            JPopupMenu oDevOperationPopupMenu = oDevOperationPopupMenuMgr.loadMenu();
            oDevOperationPopupMenu.show((Component)((Object)this.m_oDeviceTreeTable), oMouseEvent.getX(), oMouseEvent.getY());
            this.refreshNEManageButtonStatus(true);
            return;
        }
        if (iClickedRow == -1) {
            this.m_oDeviceTreeTable.getSelectionModel().setSelectionInterval(0, 0);
            this.refreshNEManageButtonStatus(true);
            iClickedRow = 0;
        }
        if (nRows.length > 0) {
            for (int i = 0; i < nRows.length; ++i) {
                if (nRows[i] != iClickedRow) continue;
                bIsClickedRowSelected = true;
                oDevTypeInfo = DeviceTableUtil.getDeviceInfoForTableRow(this.m_oDeviceTreeTable, iClickedRow);
                oDeviceTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDevTypeInfo.getDeviceTypeInfo(), new int[]{oDevTypeInfo.getDevId()});
                if (null == oDeviceTypeConfigModel && DCFrameWorkUtil.getIsNeedToSendCmdCode() && oDevTypeInfo.getDeviceTypeInfo().isBMSDomain()) {
                    TaskAsynCommForSpecificConfInfoNotify.getInstance().updateDeviceStatusToBusy(oDevTypeInfo);
                    DCFrameWorkUtil.setIsNeedToSendCmdCode(false);
                    this.updateUI();
                    break;
                }
                TaskAsynCommForSpecificConfInfoNotify.getInstance().clearDeviceStatusToIdle(oDevTypeInfo);
                this.updateUI();
                break;
            }
        }
        if (!bIsClickedRowSelected && 0 != (4 & oMouseEvent.getModifiers())) {
            ListSelectionModel oSelectionModel = this.m_oDeviceTreeTable.getSelectionModel();
            oSelectionModel.setSelectionInterval(iClickedRow, iClickedRow);
            oDevTypeInfo = DeviceTableUtil.getDeviceInfoForTableRow(this.m_oDeviceTreeTable, iClickedRow);
            if (null == oDevTypeInfo) {
                return;
            }
            oDeviceTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDevTypeInfo.getDeviceTypeInfo(), new int[]{oDevTypeInfo.getDevId()});
            if (null == oDeviceTypeConfigModel && DCFrameWorkUtil.getIsNeedToSendCmdCode() && oDevTypeInfo.getDeviceTypeInfo().isBMSDomain()) {
                TaskAsynCommForSpecificConfInfoNotify.getInstance().updateDeviceStatusToBusy(oDevTypeInfo);
            } else {
                TaskAsynCommForSpecificConfInfoNotify.getInstance().clearDeviceStatusToIdle(oDevTypeInfo);
            }
        }
        if (0 != (0x10 & oMouseEvent.getModifiers()) && (oValue = this.m_oDeviceTreeTable.getValueAt(iSelectedRow = this.m_oDeviceTreeTable.rowAtPoint(oMouseEvent.getPoint()), iColumn = this.m_oDeviceTreeTable.columnAtPoint(oMouseEvent.getPoint()))) instanceof OperationStatus) {
            OperationStatus oOperationStatus = (OperationStatus)oValue;
            if (oOperationStatus.getIsProgress()) {
                return;
            }
            if (999293081 == oOperationStatus.getIFailureReason()) {
                ViewCommandResultDialog dialog = new ViewCommandResultDialog(oOperationStatus.getFailureReason());
                dialog.setTitle(DCFrameWorkUtil.getLocalizedString("OPERATION_RESULT"));
                dialog.getContentTextArea().setLineWrap(true);
                dialog.setVisible(true);
            } else if (995098636 == oOperationStatus.getIFailureReason()) {
                DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(0));
            } else {
                DCHelpForErrCodeUtil.showHelp(this, oOperationStatus.getIFailureReason());
            }
        }
        if (0 != (4 & oMouseEvent.getModifiers())) {
            try {
                if (!bIsClickedRowSelected && iClickedRow == -1) {
                    this.m_oDeviceTreeTable.getTree().clearSelection();
                } else if (null != oDeviceTypeConfigModel) {
                    DeviceManagementPopupMenuManager oDevOperationPopupMenuMgr = this.m_oButtonPanel.getDevOperationPopupMenuMgr();
                    JPopupMenu oDevOperationPopupMenu = oDevOperationPopupMenuMgr.loadMenu();
                    oDevOperationPopupMenu.show((Component)((Object)this.m_oDeviceTreeTable), oMouseEvent.getX(), oMouseEvent.getY());
                    this.refreshNEManageButtonStatus(true);
                } else if (bIsClickedRowSelected) {
                    this.refreshNEManageButtonStatus(false);
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("XML_CONF_FILE_NO_FOUND"), ResourceManager.getInstance().getResString("INFORMATION"), 1);
                }
            }
            catch (Exception e) {
                DCDebugTracer.traceError("[menu] popup menu load fail error detail : ");
                DCDebugTracer.trace(e);
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("POPUP_MENU_LOAD_FAIL_ERROR"), ResourceManager.getInstance().getResString("ERROR"), 0);
            }
        }
    }

    private void deviceTableHeader_MousePressed(MouseEvent oMouseEvent) {
        if (0 == (0x10 & oMouseEvent.getModifiers())) {
            return;
        }
        if (this.m_oDeviceTree.getRowCount() <= 0) {
            return;
        }
        int iCurrentColumn = this.m_oDeviceTreeTable.getTableHeader().columnAtPoint(oMouseEvent.getPoint());
        Point point = oMouseEvent.getPoint();
        int iHeaderTable = -1;
        Rectangle r = this.m_oDeviceTreeTable.getCellRect(iHeaderTable, iCurrentColumn, true);
        if (point.x <= r.x + r.width / 2 - 20 || point.x >= r.x + r.width / 2 + 20) {
            return;
        }
        if (!this.m_oDeviceTreeTableModel.isColumnSortable(iCurrentColumn)) {
            return;
        }
        ArrayList<DeviceInfo> oSelectedResourceList = this.getSelectedDevices();
        this.refreshTable(oSelectedResourceList);
        DCFrameWorkUtil.setCursor(this.m_oDeviceTreeTable.getTableHeader(), Cursor.getDefaultCursor());
    }

    private void deviceTableHeader_doubleClick(MouseEvent oMouseEvent) {
        if (0 == (0x10 & oMouseEvent.getModifiers())) {
            return;
        }
        if (this.m_oDeviceTree.getRowCount() <= 0) {
            return;
        }
        Point point = new Point(){
            private static final long serialVersionUID = 1L;
        };
        point.x = oMouseEvent.getX() - 3;
        point.y = oMouseEvent.getY();
        int iCurCol = this.m_oDeviceTreeTable.getTableHeader().columnAtPoint(point);
        Rectangle r = this.m_oDeviceTreeTable.getCellRect(-1, iCurCol, true);
        if (point.x < r.x - 3 || point.x - 3 > r.x && point.x < r.x + r.width - 6 || point.x > r.x + r.width) {
            return;
        }
        if (!this.m_oDeviceTreeTableModel.isColumnSortable(iCurCol)) {
            return;
        }
        int iCurColWidth = this.getCurColMaxWitdh(iCurCol);
        this.m_oDeviceTreeTable.getColumnModel().getColumn(iCurCol).setPreferredWidth(iCurColWidth + 20);
    }

    public void displayStatusbarMessageForNoDevice() {
        StringBuffer szBuf = new StringBuffer(10);
        szBuf.append(0).append(' ').append(this.m_oResourceMgr.getResString("DEVICEINFOPAN_NOOFDEVICES")).append(' ');
        if (null == DCFrameWorkUtil.getStatusBarManager()) {
            StatusBarManager m_statusBarManager = new StatusBarManager(new JPanel());
            m_statusBarManager.setIPAddress(DCFrameWorkUtil.getServerIP());
            DCFrameWorkUtil.setStatusBarManager(m_statusBarManager);
        }
        DCFrameWorkUtil.getStatusBarManager().setComment(szBuf.toString());
        this.m_oButtonPanel.refreshDevCountLabel(0, 0);
        this.updateTableUI();
        DeviceSelectionEvent oEvent = new DeviceSelectionEvent((Object)this.m_oDeviceTreeTable);
        oEvent.setSelectedDevIds(null);
        this.notifyEvent(oEvent);
    }

    @Override
    public void exportCheckItemTemp() {
    }

    private ActionListener generateKeyListenerAdapter() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent oEvent) {
                if (0 < AbstractDeviceTablePanel.this.m_oDeviceTreeTable.getSelectedRowCount()) {
                    AbstractDeviceTablePanel.this.deleteDevices();
                }
            }
        };
    }

    MouseAdapter generateMouseAdapterForTable() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent oMouseEvent) {
                AbstractDeviceTablePanel.this.deviceTable_MousePressed(oMouseEvent);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Cursor cur = new Cursor(0);
                DCFrameWorkUtil.setCursor(AbstractDeviceTablePanel.this.getParent(), cur);
            }
        };
    }

    private MouseAdapter generateMouseAdapterForTableHeader() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    AbstractDeviceTablePanel.this.deviceTableHeader_MousePressed(e);
                } else if (e.getClickCount() == 2) {
                    AbstractDeviceTablePanel.this.deviceTableHeader_doubleClick(e);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Cursor cur = new Cursor(0);
                DCFrameWorkUtil.setCursor(AbstractDeviceTablePanel.this.getParent(), cur);
            }
        };
    }

    public JPanel getButtonPanel() {
        if (null == this.m_oButtonPanel) {
            this.m_oButtonPanel = new DeviceTableButtonPanel(this.m_oDeviceTreeTable, this);
        }
        return this.m_oButtonPanel;
    }

    @Override
    public IColumnInfo getColumnInfoForSearch() {
        return this.m_devInfoColumnInfo;
    }

    public CommonProgressDlg getCommonProgressDlg() {
        return this.m_oCommonProgressDlg;
    }

    public ProgressDlg getCurrentProgressDlg() {
        return this.m_dlg;
    }

    public DeviceManagementPopupMenuManager getDevicePopupMgr() {
        return this.m_oButtonPanel.getDevOperationPopupMenuMgr();
    }

    public DeviceTableManager getDeviceTableManager() {
        return this.m_oTableManager;
    }

    public TreeTableNode getDeviceTableRoot() {
        return this.m_oDeviceTreeTableModel.getRoot();
    }

    public DeviceTreePanel getDeviceTreePanel() {
        return this.m_oDeviceMainPanel.getDeviceTreePanel();
    }

    public JSortTreeTable getDeviceTreeTable() {
        return this.m_oDeviceTreeTable;
    }

    public DeviceTreeTableModel getDeviceTreeTableModel() {
        return this.m_oDeviceTreeTableModel;
    }

    protected DefaultMutableTreeNode getRowForDeviceID(int iDevId) {
        DeviceIDDataObject oID = new DeviceIDDataObject();
        oID.setDeviceID(iDevId);
        TreeTableNode oNode = this.m_oDeviceTreeTableModel.getNodeForCellInColumn(oID, 0);
        return oNode;
    }

    protected int getRowIndex(int iDeviceId) {
        DeviceInfo oDeviceInfo = null;
        for (int index = 0; index < this.m_oDeviceTreeTable.getRowCount(); ++index) {
            oDeviceInfo = (DeviceInfo)this.m_oDeviceTreeTable.getValueAt(index, 0);
            if (iDeviceId != oDeviceInfo.getDevId()) continue;
            return index;
        }
        return -1;
    }

    public ArrayList<DeviceInfo> getSelectedDevices() {
        ArrayList<DeviceInfo> oDeviceList = new ArrayList<DeviceInfo>(0);
        int iLength = 0;
        int[] arrRows = new int[]{};
        if (null != this.m_oDeviceTreeTable) {
            arrRows = this.m_oDeviceTreeTable.getSelectedRows();
            iLength = arrRows.length;
        }
        DeviceInfo oDeviceInfo = null;
        for (int index = 0; index < iLength; ++index) {
            oDeviceInfo = (DeviceInfo)this.m_oDeviceTreeTable.getValueAt(arrRows[index], 0);
            if (null == oDeviceInfo) continue;
            oDeviceList.add(oDeviceInfo);
        }
        return oDeviceList;
    }

    public int getCurColMaxWitdh(int iCurColumn) {
        String strMaxStr = null;
        if (null != this.m_oDeviceTreeTable.getTableHeader().getColumnModel().getColumn(iCurColumn)) {
            strMaxStr = this.m_oDeviceTreeTable.getTableHeader().getColumnModel().getColumn(iCurColumn).getHeaderValue().toString();
        }
        Font font = this.m_oDeviceTreeTable.getFont();
        FontMetrics metrics = new FontMetrics(font){
            private static final long serialVersionUID = 1L;
        };
        Rectangle2D bounds = metrics.getStringBounds(strMaxStr, null);
        String strCurValue = strMaxStr;
        int iMaxLengthInCurColumn = (int)bounds.getWidth();
        int iCurLength = 0;
        for (int i = 0; i < this.m_oDeviceTreeTable.getRowCount(); ++i) {
            strCurValue = this.m_oDeviceTreeTable.getValueAt(i, iCurColumn).toString();
            bounds = metrics.getStringBounds(strCurValue, null);
            iCurLength = (int)bounds.getWidth();
            if (iCurLength <= iMaxLengthInCurColumn) continue;
            iMaxLengthInCurColumn = iCurLength;
        }
        return iMaxLengthInCurColumn;
    }

    public void setAllColWidthInAppro() {
        int iTableHeaderLength = this.m_oDeviceTreeTable.getTableHeader().getColumnModel().getColumnCount();
        int iMaxLengthInCurColumn = 0;
        for (int iCurColumn = 1; iCurColumn < iTableHeaderLength; ++iCurColumn) {
            iMaxLengthInCurColumn = this.getCurColMaxWitdh(iCurColumn);
            this.m_oDeviceTreeTable.getColumnModel().getColumn(iCurColumn).setPreferredWidth(iMaxLengthInCurColumn + 20);
        }
        int treeTableWidth = this.m_oDeviceTreeTable.getPreferredSize().width;
        int mainPanelMaxWidth = 1464;
        if (treeTableWidth < mainPanelMaxWidth) {
            int operationStatusColumnWidth = this.m_oDeviceTreeTable.getColumnModel().getColumn(6).getPreferredWidth();
            int width = mainPanelMaxWidth - treeTableWidth;
            this.m_oDeviceTreeTable.getColumnModel().getColumn(6).setPreferredWidth(operationStatusColumnWidth + width);
        }
    }

    public ListSelectionModel getTableSelectionModel() {
        return this.m_oDeviceTreeTable.getSelectionModel();
    }

    @Override
    public JSortTreeTable getTreeTable() {
        return this.m_oDeviceTreeTable;
    }

    @Override
    public DCTreeTableModel getTreeTableModel() {
        return this.m_oDeviceTreeTableModel;
    }

    public synchronized void handleButtonForProgress(int iDevId, boolean isEnabled) {
    }

    private void initializeCellRenderers() {
        DeviceTreeTableCellRenderer oDefaultCellRenderer = new DeviceTreeTableCellRenderer(this.m_oDeviceTreeTable, 0);
        int iColumnCount = this.m_oDeviceTreeTable.getColumnModel().getColumnCount();
        for (int i = 0; i < iColumnCount; ++i) {
            this.m_oDeviceTreeTable.getColumnModel().getColumn(i).setCellRenderer(oDefaultCellRenderer);
        }
    }

    private void initializeKeyAdapters() {
        if (DCFrameWorkUtil.getIsSingleClient()) {
            KeyStroke oDeleteKeyStroke = KeyStroke.getKeyStroke(127, 0);
            this.m_oDeviceTreeTable.registerKeyboardAction(this.generateKeyListenerAdapter(), oDeleteKeyStroke, 0);
        }
    }

    private void initializeMouseAdapters() {
        this.m_oDeviceTreeTable.getTableHeader().addMouseListener(this.generateMouseAdapterForTableHeader());
        this.m_oDeviceTreeTable.addMouseListener(this.generateMouseAdapterForTable());
        this.m_oDeviceTreeTable.addMouseMotionListener(new MyMouseMotionAdapter(this.m_oDeviceTreeTable));
    }

    protected void initializeProgressDialog(int iReqId, DeviceInfo[] oDeviceInfos, int iCmdCode) {
        int iNosOfDevs = oDeviceInfos.length;
        int[] iArrdeviceIds = new int[iNosOfDevs];
        for (int i = 0; i < oDeviceInfos.length; ++i) {
            iArrdeviceIds[i] = oDeviceInfos[i].getDevId();
        }
        this.m_iArrdeviceIds = iArrdeviceIds;
        if (43829 == iCmdCode) {
            String[] columnNames = new String[]{ResourceManager.getInstance().getResString("RESOURCE_NAME"), ResourceManager.getInstance().getResString("OPERATE_RESULT"), ResourceManager.getInstance().getResString("ERROR_INFO")};
            this.m_dlg = new ProgressDlg(iCmdCode, iArrdeviceIds, columnNames);
        } else {
            this.m_dlg = new ProgressDlg(iCmdCode, iArrdeviceIds);
        }
        this.m_dlg.setName("DeviceView_DeviceTablePanel_m_dlg");
        String strTitle = "";
        if (43829 == iCmdCode) {
            strTitle = ResourceManager.getInstance().getResString("VERSION_INFO_DLG_TITLE");
            this.m_dlg.customizeTableForTelnetError();
        } else if (43974 == iCmdCode) {
            strTitle = ResourceManager.getInstance().getResString("SET_AUTO_LOAD_TITLE");
        }
        this.m_dlg.setTitle(strTitle);
        this.m_dlg.setDefaultCloseOperation(2);
        this.m_dlg.setModal(true);
        this.m_dlg.setProgressDlgId(iReqId);
    }

    private void initializeTree() {
        this.initializeMouseAdapters();
        this.initializeKeyAdapters();
        this.initializeCellRenderers();
    }

    public boolean isCurrentPanel() {
        return this.m_isCurrentPanel;
    }

    public boolean isFirstOpenFromDevPanel() {
        return this.m_bFirstOpenFromDevPanel;
    }

    public boolean isGettingDevInfo() {
        return this.m_bGettingDevInfo;
    }

    protected void jInit() {
        this.createTreeTableModel();
        this.createTreeTable();
        this.m_oDeviceTableScrollPane = new JScrollPane((Component)((Object)this.m_oDeviceTreeTable));
        this.m_oDeviceTableScrollPane.setHorizontalScrollBarPolicy(30);
        this.m_oDeviceTableScrollPane.setVerticalScrollBarPolicy(20);
        this.m_oDeviceTableScrollPane.getVerticalScrollBar().setAutoscrolls(true);
        this.m_oDeviceTableScrollPane.getViewport().addMouseListener(this.generateMouseAdapterForTable());
        DCHelpManager.getInstance().enableF1HelpKey(this, "HELP_TOPIC_VIEW_DEVICE_TABLE_PANEL");
        this.addTableSelectionListener();
        TableCustomizer oTableCustomizer = new TableCustomizer((JTable)((Object)this.m_oDeviceTreeTable), "conf/dc/device_table.xml");
        TableColumn[] oTableColumns = new TableColumn[2];
        oTableColumns[0] = this.m_oDeviceTreeTable.getColumnModel().getColumn(0);
        oTableColumns[1] = this.m_oDeviceTreeTable.getColumnModel().getColumn(1);
        oTableCustomizer.setNotAllowCustomizedColumns(Arrays.asList(oTableColumns));
        this.setLayout(new GridLayout());
        this.add(this.m_oDeviceTableScrollPane);
        this.setMinimumSize(new Dimension(540, 100));
        this.setPreferredSize(new Dimension(540, 400));
    }

    @Override
    public void makeRowVisible(int row) {
        this.showRow(row);
    }

    protected void modifyT2000Device(DeviceInfo[] arrDevInfo) {
        ArrayList<Integer> iDevTypeIdLst = new ArrayList<Integer>();
        ArrayList<Integer> iVersionIdLst = new ArrayList<Integer>();
        ArrayList<Integer> iDevIDLst = new ArrayList<Integer>();
        DeviceTypeInfo oDevTypeInfo = null;
        for (int index = 0; index < arrDevInfo.length; ++index) {
            oDevTypeInfo = arrDevInfo[index].getDeviceTypeInfo();
            iDevIDLst.add(index, arrDevInfo[index].getDevId());
            iDevTypeIdLst.add(index, oDevTypeInfo.getDevTypeID());
            iVersionIdLst.add(index, oDevTypeInfo.getDevTypeVersionId());
        }
        List<T2000DevInfo> oT2000DevInfoLst = new ArrayList<T2000DevInfo>();
        IDCStandAloneSyncCtrller oStandAloneSyncCtrller = StandAloneSyncCtrller.getInstance();
        ArrayList<Integer> oDevIDLst = new ArrayList<Integer>();
        for (int index = 0; index < arrDevInfo.length; ++index) {
            oDevIDLst.add(index, arrDevInfo[index].getDevId());
        }
        boolean bNeedToGetUserNameAndPwd = oDevIDLst.size() <= 1;
        try {
            for (int index = 0; index < arrDevInfo.length; ++index) {
                oT2000DevInfoLst = oStandAloneSyncCtrller.getT2000DevInfoLst(oDevIDLst, bNeedToGetUserNameAndPwd);
            }
        }
        catch (DCException ex) {
            DCDebugTracer.trace(ex);
            return;
        }
        ModifyGatewayDevDlg oModifyDlg = new ModifyGatewayDevDlg(oT2000DevInfoLst, iDevIDLst, iDevTypeIdLst, iVersionIdLst);
        oModifyDlg.setVisible(true);
    }

    public void notifyEvent() {
        this.updateTableUI();
        ArrayList<DeviceInfo> selectedDevInfos = this.getSelectedDevices();
        int[] iSelectedDevIds = new int[selectedDevInfos.size()];
        for (int i = 0; i < iSelectedDevIds.length; ++i) {
            iSelectedDevIds[i] = selectedDevInfos.get(i).getDevId();
        }
        DeviceSelectionEvent oEvent = new DeviceSelectionEvent((Object)this.m_oDeviceTreeTable);
        oEvent.setSelectedDevIds(iSelectedDevIds);
        this.notifyEvent(oEvent);
    }

    public void notifyEvent(DeviceSelectionEvent oEvent) {
        if (this.m_isCurrentPanel && this.m_bNeedNotify) {
            int iCount = 0;
            if (null != this.m_oListeners) {
                iCount = this.m_oListeners.size();
            }
            for (int index = 0; index < iCount; ++index) {
                IDeviceInfoSelectionListener eventListener = this.m_oListeners.get(index);
                eventListener.onDeviceInfoSelection(oEvent);
            }
        }
    }

    @Override
    public void onTaskNotification(TaskEvent oEvent) {
        if (null == oEvent) {
            return;
        }
        Object oSource = oEvent.getSource();
        AsnGetDevUpgradeModeRsp asnGetDevUpgradeModeRsp = null;
        if (!(oSource instanceof AsnGetDevUpgradeModeRsp)) {
            return;
        }
        asnGetDevUpgradeModeRsp = (AsnGetDevUpgradeModeRsp)oSource;
        AsnDevUpgrModeInfoLst oDevUpgrModeInfoLst = asnGetDevUpgradeModeRsp.oDevUpgrModeInfoLst;
        AsnDevUpgrModeInfo asnDevUpgrModeInfo = null;
        int iUpMode = -1;
        AsnCheckUpgradeDevInfo oCheckUpgradeDevInfo = null;
        AsnDevSetInfoLst oDevSetInfoLst = null;
        AsnDevSetInfo asnDevSetInfo = null;
        int iDevID = -1;
        IDeviceInfoManager oDeviceInfoMgr = DeviceInfoManagerImpl.getInstance();
        DeviceInfo oDevInfo = null;
        for (int i = 0; i < oDevUpgrModeInfoLst.size(); ++i) {
            asnDevUpgrModeInfo = (AsnDevUpgrModeInfo)oDevUpgrModeInfoLst.get(i);
            iUpMode = asnDevUpgrModeInfo.iUpgradeMode == null ? -1 : asnDevUpgrModeInfo.iUpgradeMode.intValue();
            oCheckUpgradeDevInfo = asnDevUpgrModeInfo.oCheckUpgradeDevInfo;
            oDevSetInfoLst = oCheckUpgradeDevInfo.oDevSetInfoLst;
            for (int j = 0; j < oDevSetInfoLst.size(); ++j) {
                asnDevSetInfo = (AsnDevSetInfo)oDevSetInfoLst.get(j);
                if (null == asnDevSetInfo || null == (oDevInfo = oDeviceInfoMgr.getDevice(iDevID = asnDevSetInfo.iDevId != null ? asnDevSetInfo.iDevId.intValue() : -1))) continue;
                oDevInfo.setUpgradeMode(iUpMode);
            }
        }
        this.m_oValidationProgressDlg.dispose();
    }

    public void openGettingDevProgressDlg(boolean bRefresh) {
        this.m_bGettingDevInfo = true;
        if (DCFrameWorkUtil.getIsSingleClient() || DCFrameWorkUtil.getDCModuleManager().isHaveOpenedDC() && !bRefresh) {
            return;
        }
        DCFrameWorkUtil.getToolBarButton("refreshTree").setEnabled(false);
        this.m_oGettingDevtProgressDlg = new SimpleProgressDlg(ResourceManager.getInstance().getResString("TLE_GET_NE_INFORMATION"), true, ResourceManager.getInstance().getResString("GETTING_TLE_GET_NE_INFORMATION")){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancelRollBtnActionPerformed() {
                if (null == AbstractDeviceTablePanel.this.m_oGettingDevtProgressDlg) {
                    return;
                }
                AbstractDeviceTablePanel.this.m_oGettingDevtProgressDlg.dispose();
                this.doCleanUp();
            }
        };
        this.m_oGettingDevtProgressDlg.setLocationRelativeTo(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null != AbstractDeviceTablePanel.this.m_oGettingDevtProgressDlg && AbstractDeviceTablePanel.this.m_bGettingDevInfo) {
                    DCDebugTracer.trace("open progress dialog");
                    AbstractDeviceTablePanel.this.m_oGettingDevtProgressDlg.setVisible(true);
                } else {
                    if (null != AbstractDeviceTablePanel.this.m_oGettingDevtProgressDlg) {
                        AbstractDeviceTablePanel.this.m_oGettingDevtProgressDlg.dispose();
                    }
                    DCDebugTracer.trace("do not show progress dialog");
                }
            }
        });
    }

    protected void openTaskMainPanelFromDevicepanel() {
        TaskManagementMainPanel oTaskMgrPanel;
        DCFrameWorkUtil.waitCursor();
        TaskTablePanel oTaskTablePanel = DCFrameWorkUtil.getTaskTablePanel();
        if (null != oTaskTablePanel) {
            oTaskTablePanel.closeGettingTaskLstProgressDlg();
        }
        if (null == (oTaskMgrPanel = DCFrameWorkUtil.getDCModuleManager().getTaskMgrMainPanel())) {
            this.m_bFirstOpenFromDevPanel = true;
        }
        DCFrameWorkUtil.getDCModuleManager().taskManagement();
        this.m_bFirstOpenFromDevPanel = false;
    }

    protected void refreshDeviceOperationResult(int iDeviceID, int iOperationType, int iErrorCode, String strErrMsg) {
        DefaultMutableTreeNode oNode = this.getRowForDeviceID(iDeviceID);
        if (null == oNode) {
            DCDebugTracer.trace("found no device to refresh ospf status " + iDeviceID + strErrMsg);
            return;
        }
        DeviceInfo oRowData = (DeviceInfo)oNode.getUserObject();
        if (null != oRowData) {
            OperationStatus oOperationStatus = oRowData.getDeviceOperationStatus();
            oOperationStatus.setOperationType(iOperationType);
            String strFailureReason = "";
            oOperationStatus.setIFailureReason(iErrorCode);
            if (0 == iErrorCode) {
                strFailureReason = ResourceManager.getInstance().getResString("OPERTION_SUCCESS");
                oOperationStatus.setIOperationResultStatus(0);
            } else {
                strFailureReason = ResourceManager.getInstance().getResString("OPERTION_FAILED");
                strFailureReason = strFailureReason + " " + ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode));
                oOperationStatus.setIOperationResultStatus(1);
            }
            oOperationStatus.setFailureReason(strFailureReason);
        }
        this.updateDeviceTableUI();
    }

    public void refreshNEManageMenuStatus() {
        this.m_oButtonPanel.refreshNEManageMenuStatus();
    }

    public void refreshNEManageButtonStatus(boolean enable) {
        this.m_oButtonPanel.refreshNEManageButtonStatus(enable);
    }

    protected void refreshProgressDlg(int devID, String sOperationName) {
        DeviceInfo devInfo = DeviceInfoManagerImpl.getInstance().getDevice(devID);
        if (null == devInfo || null == this.m_oCommonProgressDlg) {
            return;
        }
        int iDevID = devInfo.getDevId();
        String devName = devInfo.getDevName();
        String devIP = devInfo.getDevIPAddress();
        String sDisplayName = devName + "(" + devIP + ")";
        this.m_oCommonProgressDlg.setProgress(iDevID, sDisplayName, sOperationName);
    }

    public void refreshSelectedDevCountLabel() {
        if (null != this.m_oButtonPanel) {
            this.m_oButtonPanel.refreshSelectedDevCountLabel();
        }
    }

    public void refreshTable() {
        this.notifyEvent();
        if (null != this.m_oButtonPanel) {
            this.refreshSelectedDevCountLabel();
        }
    }

    public void refreshTable(final ArrayList<DeviceInfo> oSelectedResourceList) {
        switch (this.m_oDeviceTreeTableModel.getRowCount()) {
            case 0: {
                break;
            }
            case 1: {
                this.setDefaultSelection();
                break;
            }
            default: {
                if (this.m_oDeviceTreeTable.getSelectedRowCount() == 0) {
                    this.setDefaultSelection();
                    break;
                }
                if (this.m_oDeviceTreeTable.getSelectedRowCount() == this.m_oDeviceTreeTable.getRowCount()) {
                    this.m_oDeviceTreeTable.getSelectionModel().setSelectionInterval(0, this.m_oDeviceTreeTable.getRowCount() - 1);
                    break;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractDeviceTablePanel.this.m_oDeviceTreeTable.getTableHeader().updateUI();
                        AbstractDeviceTablePanel.this.m_oDeviceTreeTable.updateUI();
                        AbstractDeviceTablePanel.this.m_oDeviceTree.updateUI();
                        DeviceTablePanelUtil.retainPreviousSelection(oSelectedResourceList, AbstractDeviceTablePanel.this.m_oDeviceTreeTable);
                    }
                });
            }
        }
        this.notifyEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean refreshUpmode(final DeviceInfo[] arrDevInfo) {
        int idevDomain = arrDevInfo[0].getDeviceTypeInfo().getDevDomain();
        if (idevDomain != 2) {
            return false;
        }
        TaskInfoNotifier.getInstance().addTaskNotificationListener(this);
        this.m_oValidationProgressDlg = new SimpleProgressDlg(ResourceManager.getInstance().getResString("TLE_GET_CONFIG_FILE"), true, ResourceManager.getInstance().getResString("GETTING_TLE_GET_CONFIG_FILE")){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancelButtonActionPerformed() {
                AbstractDeviceTablePanel.this.m_bCancelPressed = true;
            }
        };
        byte[] byArray = this.m_oSyncModeObject;
        synchronized (this.m_oSyncModeObject) {
            Thread oUpModeTread = new Thread(){

                @Override
                public void run() {
                    try {
                        TaskAsynCommController.getInstance();
                        TaskSyncCommController.getInstance().updateDevUpgradeMode(arrDevInfo);
                    }
                    catch (DCException e) {
                        DCDebugTracer.trace(e);
                    }
                }
            };
            oUpModeTread.start();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.m_oValidationProgressDlg.setVisible(true);
            TaskInfoNotifier.getInstance().removeTaskNotificationListener(this);
            DeviceInfo oTmpDevInfo = null;
            for (DeviceInfo oDevInfo : arrDevInfo) {
                oTmpDevInfo = DeviceInfoManagerImpl.getInstance().getDevice(oDevInfo.getDevId());
                if (!DeviceInfoUtil.isSupportUpgradeMode(oTmpDevInfo, 4096)) continue;
                return true;
            }
            return false;
        }
    }

    public void removeDevInfoSelectionListener(IDeviceInfoSelectionListener eventListener) {
        if (null != eventListener && this.m_oListeners.contains(eventListener)) {
            this.m_oListeners.remove(eventListener);
        }
    }

    public void resetTableSelection() {
        this.m_oDeviceTableScrollPane.getVerticalScrollBar().setValue(0);
        this.m_oDeviceTreeTable.getSelectionModel().setSelectionInterval(0, 0);
    }

    @Override
    public void saveDevInfoLst() {
    }

    private void setCloumnWinth() {
        if (!DCFrameWorkUtil.getIsSingleClient() && !DCFrameWorkUtil.checkIsBmsMiniNMS()) {
            this.m_oDeviceTreeTable.setAutoResizeMode(0);
            this.m_oDeviceTreeTable.getColumnModel().getColumn(1).setPreferredWidth(160);
            this.m_oDeviceTreeTable.getColumnModel().getColumn(2).setPreferredWidth(160);
            this.m_oDeviceTreeTable.getColumnModel().getColumn(3).setPreferredWidth(160);
            this.m_oDeviceTreeTable.getColumnModel().getColumn(4).setPreferredWidth(200);
            this.m_oDeviceTreeTable.getColumnModel().getColumn(5).setPreferredWidth(200);
            this.m_oDeviceTreeTable.getColumnModel().getColumn(6).setPreferredWidth(320);
            this.m_oDeviceTreeTable.getColumnModel().getColumn(6).setPreferredWidth(800);
        }
    }

    public void setCommonProgressDlg(CommonProgressDlg commonProgressDlg) {
        this.m_oCommonProgressDlg = commonProgressDlg;
    }

    protected void setDefaultSelection() {
        if (null == this.m_oDeviceTreeTable) {
            return;
        }
        this.setTableSelection(0, 0);
    }

    public void setIsCurrentPanel(boolean isCurrentPanel) {
        this.m_isCurrentPanel = isCurrentPanel;
    }

    public synchronized void setNeedNotify(boolean bNeedNotify) {
        this.m_bNeedNotify = bNeedNotify;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRowSelectionOngetVersion() {
        int iRowIndex = -1;
        if (this.isCurrentPanel()) {
            this.m_oDeviceTreeTable.removeRowSelectionInterval(0, 0);
        }
        if (null == this.m_oArrDevInfo) {
            return;
        }
        DefaultListSelectionModel selectionModel = (DefaultListSelectionModel)this.m_oDeviceTreeTable.getSelectionModel();
        ListSelectionListener[] oLstSltLst = selectionModel.getListSelectionListeners();
        int index = 0;
        try {
            if (null != oLstSltLst) {
                for (ListSelectionListener oListener : oLstSltLst) {
                    selectionModel.removeListSelectionListener(oListener);
                }
            }
            while (index < this.m_oArrDevInfo.length - 1) {
                iRowIndex = this.getRowIndex(this.m_oArrDevInfo[index].getDevId());
                if (-1 != iRowIndex) {
                    this.m_oDeviceTreeTable.addRowSelectionInterval(iRowIndex, iRowIndex);
                }
                ++index;
            }
        }
        finally {
            if (null != oLstSltLst) {
                for (ListSelectionListener oListener : oLstSltLst) {
                    selectionModel.addListSelectionListener(oListener);
                }
            }
        }
        iRowIndex = this.getRowIndex(this.m_oArrDevInfo[index].getDevId());
        if (-1 != iRowIndex) {
            this.m_oDeviceTreeTable.addRowSelectionInterval(iRowIndex, iRowIndex);
        }
    }

    public void setTableSelection(int iStartRow, int iEndRow) {
        if (this.m_oDeviceTreeTable.getRowCount() > 0 && iEndRow >= iStartRow && iStartRow >= 0) {
            this.m_oDeviceTreeTable.getSelectionModel().setSelectionInterval(iStartRow, iEndRow);
            this.m_oDeviceTree.setSelectionInterval(iStartRow, iEndRow);
        }
    }

    protected int showConfirmationDlg(String strMsg) {
        int iVal = DCOptionPane.showConfirmDialog((Component)this, ResourceManager.getInstance().getResString(strMsg), ResourceManager.getInstance().getResString("CONFIRM"), 0);
        return iVal;
    }

    protected void showDeleteDeviceFileDialog() {
        DeviceMemoryInfo oDevMemoryInfo = this.m_oDeviceMemoryInfoMap.get(this.m_oResList.get(0).getDeviceID());
        DeleteDeviceFileDialog oDeleteDeviceFileDialog = new DeleteDeviceFileDialog(this.m_oResList.get(0), oDevMemoryInfo);
        oDeleteDeviceFileDialog.setVisible(true);
    }

    protected void showMessageDialog(String oMessage, String strMessageType, int iMessageType) {
        DCOptionPane.showMessageDialog((Component)this, oMessage, strMessageType, iMessageType);
    }

    public void showRow(int iRow) {
        this.m_oDeviceTableScrollPane.validate();
        JScrollBar vScroll = this.m_oDeviceTableScrollPane.getVerticalScrollBar();
        vScroll.setValue(DCGUIUtil.calculateScrollValue(iRow, vScroll.getMaximum(), this.m_oDeviceTree.getRowCount()));
        DCFrameWorkUtil.updateUI(vScroll);
        DCFrameWorkUtil.updateUI(this.m_oDeviceTableScrollPane);
    }

    protected void updateDeviceTableUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractDeviceTablePanel.this.m_oDeviceTreeTable.updateUI();
                AbstractDeviceTablePanel.this.m_oButtonPanel.setRefreshDateTime();
            }
        });
    }

    protected void updateDevStatus(DeviceInfo[] arrSelectedDevInfo, int iDeviceOperation) {
        for (int i = 0; i < arrSelectedDevInfo.length; ++i) {
            this.setOperationStartedStatusForDevice(arrSelectedDevInfo[i], iDeviceOperation);
        }
        this.updateTable();
    }

    public void updateTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractDeviceTablePanel.this.m_oDeviceTreeTable.repaint();
            }
        });
    }

    public void updateTableUI() {
        this.updateDeviceTableUI();
    }

    public void updateVersionInfo(DeviceVersionInfo oVersionInfo) {
        DeviceInfo oDeviceInfo;
        if (oVersionInfo == null) {
            return;
        }
        DeviceIDDataObject oDeviceIDDataObject = new DeviceIDDataObject(oVersionInfo.getDevId());
        TreeTableNode oTableNode = this.m_oDeviceTreeTableModel.getNodeForCellInColumn(oDeviceIDDataObject, 0);
        if (null != oTableNode && oTableNode.getUserObject() instanceof DeviceInfo && null != (oDeviceInfo = (DeviceInfo)oTableNode.getUserObject())) {
            oDeviceInfo.setDevVersion(oVersionInfo);
        }
    }

    private void notifyEventForChangeSelection() {
        DeviceTypeInfo oDeviceTypeInfo;
        ArrayList<DeviceInfo> selectedDevInfos = this.getSelectedDevices();
        int[] iSelectedDevIds = new int[selectedDevInfos.size()];
        for (int i = 0; i < iSelectedDevIds.length; ++i) {
            iSelectedDevIds[i] = selectedDevInfos.get(i).getDevId();
        }
        DeviceSelectionEvent oEvent = new DeviceSelectionEvent((Object)this.m_oDeviceTreeTable);
        oEvent.setEventType(1);
        oEvent.setSelectedDevIds(iSelectedDevIds);
        IDeviceTypeConfigModel oDeviceTypeConfigModel = null;
        DeviceInfo oDeviceInfo = null;
        if (iSelectedDevIds.length > 0) {
            oDeviceInfo = DeviceInfoManagerImpl.getInstance().getDevice(iSelectedDevIds[0]);
        }
        if (null != oDeviceInfo && null != (oDeviceTypeInfo = oDeviceInfo.getDeviceTypeInfo())) {
            oDeviceTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDeviceTypeInfo, iSelectedDevIds);
            if (null == oDeviceTypeConfigModel && DCFrameWorkUtil.getIsNeedToSendCmdCode() && oDeviceTypeInfo.isBMSDomain()) {
                this.refreshNEManageButtonStatus(false);
                TaskAsynCommForSpecificConfInfoNotify.getInstance().updateDeviceStatusToBusy(oDeviceInfo);
                DCFrameWorkUtil.setIsNeedToSendCmdCode(false);
                this.updateUI();
            } else if (null != oDeviceTypeConfigModel) {
                TaskAsynCommForSpecificConfInfoNotify.getInstance().clearDeviceStatusToIdle(oDeviceInfo);
                this.refreshNEManageButtonStatus(true);
                this.updateUI();
            }
        }
        this.notifyEvent(oEvent);
    }

    class MyKeyAdapter
    extends KeyAdapter {
        MyKeyAdapter() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            int iKeyCode = e.getKeyCode();
            if (65 == iKeyCode && 2 == e.getModifiers()) {
                AbstractDeviceTablePanel.this.notifyEventForChangeSelection();
            } else if (38 == iKeyCode || 40 == iKeyCode) {
                AbstractDeviceTablePanel.this.notifyEventForChangeSelection();
            } else {
                DCDebugTracer.trace("dc won't handle the other key.");
            }
        }
    }

    class TableSelectionListener
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent arg0) {
            AbstractDeviceTablePanel.this.refreshSelectedDevCountLabel();
        }
    }

    class TableMouseListener
    extends MouseAdapter {
        @Override
        public void mouseReleased(MouseEvent e) {
            DCFrameWorkUtil.setIsNeedToSendCmdCode(true);
            ++AbstractDeviceTablePanel.this.iNeedToSendCmdCodeCount;
            if (AbstractDeviceTablePanel.this.iNeedToSendCmdCodeCount > 1) {
                AbstractDeviceTablePanel.this.iNeedToSendCmdCodeCount = 0;
                DCFrameWorkUtil.setIsNeedToSendCmdCode(false);
            }
            AbstractDeviceTablePanel.this.notifyEventForChangeSelection();
        }
    }
}

