/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceview.deviceinfo.boardinfo;

import com.huawei.dc.common.asndatacenter.AsnDCBoardInfo;
import com.huawei.dc.common.asndatacenter.AsnDCBoardList;
import com.huawei.dc.common.asndatacenter.AsnDCFrameInfo;
import com.huawei.dc.common.asndatacenter.AsnDCFrameList;
import com.huawei.dc.common.components.treetable.model.DCTreeTableModel;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableNodeCellData;
import com.huawei.dc.common.components.treetable.view.DCTreeTableCellRenderer;
import com.huawei.dc.common.components.treetable.view.JSortTreeTable;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.common.util.WindowStyleButton;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.controller.BoardInfoManager;
import com.huawei.dc.devicemanagement.deviceoperation.controller.BusyDeviceObjectStore;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.DeviceSelectionEvent;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.IDeviceInfoSelectionListener;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.boardinfo.AutoProgressDlg;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.boardinfo.BordInfoComparator;
import com.huawei.dc.framework.ErrorCodeReader;
import com.swimap.iview.templates.filtertreetable.TreeTableModel;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class BoardInfoPanel
extends JPanel
implements IDeviceInfoSelectionListener {
    private static final int MAX_SLOT_INDEX = 65535;
    private static final String FRAMENODE_LEAF_GIF = "framenode_leaf.gif";
    private static final String FRAMENODE_OPEN_GIF_ICON = "framenode_open.gif";
    private static final String FRAMENODE_CLOSED_GIF_ICON = "framenode_closed.gif";
    private static final int DEVICE_ID_COL_INDEX = 0;
    private static final int LOCATION_COL_INDEX = 0;
    private static final int NAME_COL_INDEX = 1;
    private static final int NO_OF_COLS = 3;
    private static final long serialVersionUID = 1L;
    private static final int VERSION_COL_INDEX = 2;
    private boolean m_bThreadStop;
    private IDeviceInfoManager m_deviceInfoManager;
    private JLabel m_oBoardInfoLabel;
    private JSortTreeTable m_oBoardInfoTreeTable;
    private DCTreeTableModel m_oBoardInfoTreeTableModel;
    private JScrollPane m_oDeviceTableScrollPane;
    private AutoProgressDlg m_oprogressDlg = null;
    private TreeTableNode m_oRootNode;
    private ResourceManager oRes = ResourceManager.getInstance();
    private JPanel btnPanel;
    private WindowStyleButton expandBtn;
    private WindowStyleButton collapseBtn;
    private JButton queryBtn;
    private static final int WIDTH = 1300;
    private boolean isShowingBoardInfo = false;
    private boolean isShowBoardComponent = true;
    private int[] m_iSelectedDevIDs = null;
    private ProgressBar m_oProgressbar = null;

    public BoardInfoPanel() {
        this.m_deviceInfoManager = DCFrameWorkUtil.getDeviceInfoManager();
        this.m_oBoardInfoLabel = new JLabel("");
        this.m_oBoardInfoLabel.setPreferredSize(new Dimension(1300, 15));
        this.m_oBoardInfoLabel.setMinimumSize(new Dimension(1300, 15));
        this.constructTree();
    }

    private void addChildNode(String[] parseBoardVersion, TreeTableNode oNode) {
        if (null == parseBoardVersion || parseBoardVersion.length == 0) {
            return;
        }
        for (int boardVersionIndex = 0; boardVersionIndex < parseBoardVersion.length; ++boardVersionIndex) {
            String strBoardVersionInfo = parseBoardVersion[boardVersionIndex].trim();
            if (strBoardVersionInfo.length() == 0) continue;
            TreeTableNode childNode = this.getChildNodeRow(new String[]{"", "", strBoardVersionInfo});
            oNode.add(childNode);
        }
    }

    private void addLable() {
        if (null != this.m_oDeviceTableScrollPane) {
            this.remove(this.m_oDeviceTableScrollPane);
        }
        this.isShowingBoardInfo = false;
        this.add((Component)this.m_oBoardInfoLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(12, 0, 0, 0), 0, 0));
    }

    private void addScrollpane() {
        if (null != this.m_oBoardInfoLabel) {
            this.remove(this.m_oBoardInfoLabel);
        }
        this.add((Component)this.m_oDeviceTableScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(12, 0, 0, 0), 0, 0));
    }

    private void constructTree() {
        this.m_oBoardInfoTreeTableModel = this.initTreeTableModel();
        this.m_oBoardInfoTreeTable = this.initTreeTable(this.m_oBoardInfoTreeTableModel);
        this.m_oBoardInfoTreeTable.setName("DeviceView_BoardInfoPanel_m_oBoardInfoTreeTable");
        this.m_oDeviceTableScrollPane = new JScrollPane((Component)((Object)this.m_oBoardInfoTreeTable));
        this.m_oBoardInfoTreeTableModel.setComparator(new BordInfoComparator());
        this.m_oRootNode = this.m_oBoardInfoTreeTableModel.getRoot();
        this.initTableRenderer();
        this.initTableColSize();
        this.initializeButtonPanel();
        GridBagLayout mainLayout = new GridBagLayout();
        this.setLayout(mainLayout);
        this.add((Component)this.btnPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_oBoardInfoLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_oDeviceTableScrollPane.getViewport().setBackground(this.m_oBoardInfoTreeTable.getBackground());
    }

    private void expandTree(JTree tree, DefaultMutableTreeNode start, boolean isExpand) {
        Enumeration<TreeNode> children = start.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode dtm = (DefaultMutableTreeNode)children.nextElement();
            if (dtm.isLeaf()) continue;
            TreePath tp = new TreePath(dtm.getPath());
            if (isExpand) {
                tree.expandPath(tp);
            } else {
                tree.collapsePath(tp);
            }
            this.expandTree(tree, dtm, isExpand);
        }
    }

    private void getBoardInfo() {
        int iSelectedDeviceID = this.getSelectedDeviceID();
        BusyDeviceObjectStore oBusyDeviceStore = BusyDeviceObjectStore.getInstance();
        DeviceInfo oDeviceInfo = DCFrameWorkUtil.getDeviceInfoManager().getDevice(iSelectedDeviceID);
        oDeviceInfo.getDeviceTypeInfo().getDevDomain();
        if (oDeviceInfo.getDeviceTypeInfo().getDevDomain() == 4 && oBusyDeviceStore.isDeviceOperationInProgress(iSelectedDeviceID)) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("INFO_FOR_PART_DEVICES_IN_PROGRESS_NOTICE"));
            return;
        }
        if (-1 != iSelectedDeviceID) {
            int errorcode = 0;
            if (this.m_deviceInfoManager != null) {
                errorcode = this.m_deviceInfoManager.getBoardVersion(iSelectedDeviceID);
            }
            this.startProcessBar(errorcode);
        }
    }

    private TreeTableNode getChildNodeRow(String[] data) {
        Vector<String> oRow = new Vector<String>(3);
        oRow.add(0, data[0]);
        oRow.add(1, data[1]);
        oRow.add(2, data[2]);
        return new TreeTableNode(oRow);
    }

    private TableColumnModel getColumnModel() {
        return this.m_oBoardInfoTreeTable.getColumnModel();
    }

    private TreeTableNode getParentNode(String[] data) {
        Vector<Object> oRow = new Vector<Object>(3);
        TreeTableNodeCellData oNodeData = new TreeTableNodeCellData(data[0]);
        oNodeData.setNodeClosedIcon(FRAMENODE_CLOSED_GIF_ICON);
        oNodeData.setNodeOpenedIcon(FRAMENODE_OPEN_GIF_ICON);
        oNodeData.setNodeLeafIcon(FRAMENODE_LEAF_GIF);
        oRow.add(0, oNodeData);
        oRow.add(1, data[1]);
        oRow.add(2, data[2]);
        TreeTableNode oNode = new TreeTableNode(oRow);
        oNodeData.setAttachedTreeNode(oNode);
        return oNode;
    }

    private int getSelectedDeviceID() {
        if (null != this.m_iSelectedDevIDs && 0 < this.m_iSelectedDevIDs.length) {
            return this.m_iSelectedDevIDs[0];
        }
        return -1;
    }

    private void initTableColSize() {
        this.getColumnModel().getColumn(0).setMinWidth(120);
        this.getColumnModel().getColumn(1).setMinWidth(100);
        this.getColumnModel().getColumn(2).setMinWidth(100);
    }

    private void initTableRenderer() {
        DCTreeTableCellRenderer treeTableCellRenderer = new DCTreeTableCellRenderer(this.m_oBoardInfoTreeTable);
        treeTableCellRenderer.setBorder(BorderFactory.createEmptyBorder());
        this.getColumnModel().getColumn(0).setCellRenderer(treeTableCellRenderer);
        this.getColumnModel().getColumn(1).setCellRenderer(treeTableCellRenderer);
        this.getColumnModel().getColumn(2).setCellRenderer(treeTableCellRenderer);
    }

    private JSortTreeTable initTreeTable(DCTreeTableModel treeTableModel) {
        JSortTreeTable odeviceTreeTable = new JSortTreeTable(treeTableModel, true);
        odeviceTreeTable.setOpaque(false);
        odeviceTreeTable.getTableHeader().setReorderingAllowed(false);
        odeviceTreeTable.getTree().setToggleClickCount(1);
        return odeviceTreeTable;
    }

    private DCTreeTableModel initTreeTableModel() {
        String[] arrHeaderFields = new String[]{this.oRes.getResString("BOARD_INFO_TABLE_BOARD_LOCATION_COLUMN"), this.oRes.getResString("BOARD_INFO_TABLE_BOARD_NAME_COLUMN"), this.oRes.getResString("BOARD_INFO_TABLE_BOARD_VERSION_COLUMN")};
        Class[] arrColumnTypes = new Class[]{TreeTableModel.class, String.class, String.class};
        boolean[] arrSortableColumns = new boolean[]{true, false, false};
        boolean[] arrEditableColumns = new boolean[]{true, false, false};
        return new DCTreeTableModel(arrHeaderFields, arrColumnTypes, arrSortableColumns, arrEditableColumns);
    }

    public final void notifyBoardInformation(AsnDCFrameList asnFrameList, int errorCode) {
        this.m_bThreadStop = true;
        if (null != this.m_oprogressDlg) {
            DCDebugTracer.trace("Method BoardInfoPanel#notifyBoardInformation dispose");
            this.m_oprogressDlg.dispose();
        }
        if (errorCode != 0) {
            this.setLableInfo(ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(errorCode)));
            this.addLable();
            this.queryBtn.setEnabled(true);
            this.setShowingBoardInfo(false);
        } else {
            this.queryBtn.setEnabled(true);
            this.setShowingBoardInfo(true);
            AsnDCFrameList oCloneFrameLst = (AsnDCFrameList)asnFrameList.clone();
            DeviceInfo oDevInfo = this.getSelectedDeviceInfo();
            BoardInfoManager.getInstance().addBoardInfo(oDevInfo, oCloneFrameLst);
            this.updateTree(asnFrameList);
        }
    }

    @Override
    public final void onDeviceInfoSelection(DeviceSelectionEvent oEvent) {
        this.m_iSelectedDevIDs = oEvent.getSelectedDevIds();
        if (null == this.m_iSelectedDevIDs) {
            this.removeAllComponent();
            this.updateUI();
        }
        DeviceInfo oDevInfo = this.getSelectedDeviceInfo();
        if (this.m_iSelectedDevIDs.length > 0) {
            this.queryBtn.setEnabled(true);
        } else {
            this.queryBtn.setEnabled(false);
        }
        if (!this.isShowBoardComponent) {
            this.add((Component)this.btnPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        int iSelRowCount = 0;
        int[] iSelDevIDs = oEvent.getSelectedDevIds();
        if (null != iSelDevIDs) {
            iSelRowCount = iSelDevIDs.length;
        }
        if (iSelRowCount > 1 || iSelRowCount == 0) {
            this.removeAllComponent();
            this.updateUI();
            return;
        }
        AsnDCFrameList asnDCFrameList = BoardInfoManager.getInstance().getFrameLst(oDevInfo);
        if (null == asnDCFrameList || asnDCFrameList.size() == 0) {
            this.setLableInfo(this.oRes.getResString("DEVICE_BOARDS_NOT_PRESENT"));
            this.setShowingBoardInfo(false);
            this.addLable();
            this.updateTreeUI();
            return;
        }
        this.setShowingBoardInfo(true);
        this.updateTree(asnDCFrameList);
    }

    private String[] parseBoardVersion(String strInput) {
        strInput = strInput.trim().replaceAll("\n\r", "#");
        strInput = strInput.replaceAll("\r\n", "#");
        String[] split = strInput.split("#");
        return split;
    }

    private void setLableInfo(String info) {
        this.m_oBoardInfoLabel.setText(info);
        this.updateUI();
        this.repaint();
    }

    protected void startProcessBar(int errorcode) {
        DCDebugTracer.trace("Method BoardInfoPanel#startProcessBar ErrorCode:" + errorcode);
        if (0 != errorcode) {
            String strBoardVersionInfo = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(errorcode));
            this.setLableInfo(strBoardVersionInfo);
        } else {
            this.setLableInfo(this.oRes.getResString("MULTIPLE_BOARDS_PROGRESS"));
            this.m_oprogressDlg = new AutoProgressDlg(this);
            this.m_oprogressDlg.setName("DeviceView_BoardInfoPanel_m_oprogressDlg");
            this.m_oprogressDlg.setTitle(this.oRes.getResString("MULTIPLE_BOARDS_PROGRESS"));
            this.m_oprogressDlg.setInfomation(this.oRes.getResString("MULTIPLE_BOARDS_PROGRESS"));
            this.m_bThreadStop = false;
            this.m_oProgressbar = new ProgressBar(this.m_oprogressDlg.getProgressBar());
            this.m_oProgressbar.setName("DeviceView_BoardInfoPanel_m_oProgressbar");
            this.m_oProgressbar.start();
            this.m_oprogressDlg.setVisible(true);
        }
    }

    protected void stopProcessBar() {
        this.m_oProgressbar.interrupt();
    }

    private void updateFrameInfo(AsnDCFrameInfo asnFrameInfo) {
        DeviceInfoManagerImpl oDeviceInfoMgr = (DeviceInfoManagerImpl)DeviceInfoManagerImpl.getInstance();
        String strBoardVersionInfo = "";
        String strBoardName = "";
        String strBoardLocation = "";
        AsnDCBoardList asnBoards = asnFrameInfo.oBoardList;
        int boardListCount = asnBoards.size();
        Comparator comp = new Comparator(){

            public int compare(Object o1, Object o2) {
                AsnDCBoardInfo p1 = (AsnDCBoardInfo)o1;
                AsnDCBoardInfo p2 = (AsnDCBoardInfo)o2;
                if (p1.iSlotId.intValue() > p2.iSlotId.intValue()) {
                    return 1;
                }
                return 0;
            }
        };
        if (boardListCount > 1) {
            Collections.sort(asnBoards, comp);
        }
        String boardName = null;
        for (int boardIndex = 0; boardIndex < boardListCount; ++boardIndex) {
            int maxSlotIndex;
            AsnDCBoardInfo asnBoardInfo = (AsnDCBoardInfo)asnBoards.elementAt(boardIndex);
            int iSlotIndex = asnBoardInfo.iSlotId.intValue();
            if (iSlotIndex > (maxSlotIndex = 65535)) {
                iSlotIndex -= maxSlotIndex;
            }
            strBoardLocation = asnFrameInfo.iFrameId.intValue() < 0 ? ((boardName = oDeviceInfoMgr.getBoardNameForT2000(iSlotIndex)).indexOf("-") != -1 ? this.oRes.getResString("SLOT_LBL") + boardName : boardName.trim()) : this.oRes.getResString("SLOT_LBL") + asnFrameInfo.iFrameId.toString() + "-" + iSlotIndex;
            strBoardName = null == asnBoardInfo.strSlotLabel ? "" : new String(asnBoardInfo.strSlotLabel);
            strBoardVersionInfo = new String(asnBoardInfo.strBoardVersion);
            if (StringUtils.isNullOrEmptyStr(strBoardVersionInfo)) {
                strBoardVersionInfo = "";
            } else {
                boolean isNumber = true;
                int length = strBoardVersionInfo.trim().length();
                for (int index = 0; index < length; ++index) {
                    if (Character.isDigit(strBoardVersionInfo.charAt(index))) continue;
                    isNumber = false;
                    break;
                }
                int iErrorInfo = 0;
                if (isNumber) {
                    try {
                        iErrorInfo = Integer.parseInt(strBoardVersionInfo);
                    }
                    catch (NumberFormatException e) {
                        strBoardVersionInfo = "";
                    }
                }
                if (0 != iErrorInfo) {
                    strBoardVersionInfo = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorInfo));
                }
            }
            String[] parseBoardVersion = this.parseBoardVersion(strBoardVersionInfo);
            TreeTableNode oNode = this.getParentNode(new String[]{strBoardLocation, strBoardName, " ", ""});
            this.addChildNode(parseBoardVersion, oNode);
            this.m_oRootNode.add(oNode);
        }
    }

    private void updateTree(AsnDCFrameList asnFrameList) {
        AsnDCFrameList oFrameList = asnFrameList;
        if (null == asnFrameList || 0 == oFrameList.size()) {
            this.setLableInfo(this.oRes.getResString("DEVICE_BOARDS_NOT_PRESENT"));
            this.addLable();
            return;
        }
        int iTotalFrames = oFrameList.size();
        this.m_oRootNode.removeAllChildren();
        int frameListCount = asnFrameList.size();
        Comparator comp = new Comparator(){

            public int compare(Object o1, Object o2) {
                AsnDCFrameInfo p1 = (AsnDCFrameInfo)o1;
                AsnDCFrameInfo p2 = (AsnDCFrameInfo)o2;
                if (p1.iFrameId.intValue() > p2.iFrameId.intValue()) {
                    return 1;
                }
                return 0;
            }
        };
        if (frameListCount > 1) {
            Collections.sort(asnFrameList, comp);
        }
        for (int frameIndex = 0; frameIndex < iTotalFrames; ++frameIndex) {
            AsnDCFrameInfo asnFrameInfo = (AsnDCFrameInfo)oFrameList.elementAt(frameIndex);
            this.updateFrameInfo(asnFrameInfo);
        }
        this.addScrollpane();
        this.updateTreeUI();
    }

    private void updateTreeUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BoardInfoPanel.this.m_oBoardInfoTreeTable.getTableHeader().updateUI();
                BoardInfoPanel.this.m_oBoardInfoTreeTable.updateUI();
                BoardInfoPanel.this.m_oBoardInfoTreeTable.getTree().updateUI();
                BoardInfoPanel.this.m_oDeviceTableScrollPane.updateUI();
                BoardInfoPanel.this.expandTree(BoardInfoPanel.this.m_oBoardInfoTreeTable.getTree(), BoardInfoPanel.this.m_oRootNode, true);
                BoardInfoPanel.this.updateUI();
            }
        });
    }

    public void disposePanel() {
        this.m_deviceInfoManager = null;
        this.m_oBoardInfoLabel = null;
        this.m_oBoardInfoTreeTable = null;
        this.m_oBoardInfoTreeTableModel = null;
        this.m_oDeviceTableScrollPane = null;
        this.m_oprogressDlg = null;
        this.m_oRootNode = null;
        this.oRes = null;
    }

    private JPanel getButtonPanel() {
        ResourceManager oResourceManager = ResourceManager.getInstance();
        this.expandBtn = new WindowStyleButton();
        this.initializeButtonToDefaultSettings(this.expandBtn);
        this.expandBtn.setIcon(oResourceManager.getImage("expand_tasks.gif"));
        this.expandBtn.setToolTipText(oResourceManager.getResString("EXPAND_TOOL_TIP"));
        this.expandBtn.setVerifyInputWhenFocusTarget(true);
        this.expandBtn.setEnabled(false);
        this.expandBtn.setPreferredSize(new Dimension(50, 25));
        this.expandBtn.setMinimumSize(new Dimension(50, 25));
        this.expandBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent oEvent) {
                BoardInfoPanel.this.expandButton_ActionPerformed();
            }
        });
        this.collapseBtn = new WindowStyleButton();
        this.initializeButtonToDefaultSettings(this.collapseBtn);
        this.collapseBtn.setIcon(oResourceManager.getImage("collapse_tasks.gif"));
        this.collapseBtn.setToolTipText(oResourceManager.getResString("COLLAPSE_TOOL_TIP"));
        this.collapseBtn.setVerifyInputWhenFocusTarget(true);
        this.collapseBtn.setEnabled(false);
        this.collapseBtn.setPreferredSize(new Dimension(50, 25));
        this.collapseBtn.setMinimumSize(new Dimension(50, 25));
        this.collapseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent oEvent) {
                BoardInfoPanel.this.collapseButton_ActionPerformed();
            }
        });
        this.queryBtn = new JButton();
        this.initializeButtonToDefaultSettings(this.queryBtn);
        this.queryBtn.setMinimumSize(new Dimension(80, 25));
        this.queryBtn.setPreferredSize(new Dimension(80, 25));
        this.queryBtn.setText(oResourceManager.getResString("BUTTON_QUERY_BOARDINFO"));
        this.queryBtn.setToolTipText(oResourceManager.getResString("REFRESH_TOOL_TIP"));
        this.queryBtn.setVerifyInputWhenFocusTarget(true);
        this.queryBtn.setEnabled(true);
        this.queryBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent oEvent) {
                BoardInfoPanel.this.getBoardInfo();
            }
        });
        this.btnPanel = new JPanel();
        FlowLayout jPaneLayout = new FlowLayout(0, 5, 0);
        this.btnPanel.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.btnPanel.setLayout(jPaneLayout);
        JSeparator oSeparator = new JSeparator(1);
        this.btnPanel.add(this.queryBtn);
        this.btnPanel.add(oSeparator);
        this.btnPanel.add(this.expandBtn);
        this.btnPanel.add(this.collapseBtn);
        this.btnPanel.setVisible(true);
        this.btnPanel.setSize(800, 30);
        this.btnPanel.setPreferredSize(new Dimension(1300, 30));
        this.btnPanel.setMinimumSize(new Dimension(1300, 30));
        return this.btnPanel;
    }

    protected void expandButton_ActionPerformed() {
        this.expandTree(this.m_oBoardInfoTreeTable.getTree(), this.m_oRootNode, true);
    }

    protected void collapseButton_ActionPerformed() {
        this.expandTree(this.m_oBoardInfoTreeTable.getTree(), this.m_oRootNode, false);
    }

    private void initializeButtonToDefaultSettings(JButton oButton) {
        Dimension oDefaultDimension = new Dimension(50, 25);
        oButton.setPreferredSize(oDefaultDimension);
        oButton.setMaximumSize(oDefaultDimension);
        oButton.setMinimumSize(oDefaultDimension);
        oButton.setBorder(null);
        oButton.repaint();
    }

    private void initializeButtonPanel() {
        if (null == this.btnPanel) {
            this.btnPanel = this.getButtonPanel();
        }
    }

    private DeviceInfo getSelectedDeviceInfo() {
        DeviceInfo oDevInfo = null;
        if (null == this.m_iSelectedDevIDs || 0 >= this.m_iSelectedDevIDs.length) {
            return null;
        }
        IDeviceInfoManager oDeviceInfoManager = DCFrameWorkUtil.getDeviceInfoManager();
        oDevInfo = oDeviceInfoManager.getDevice(this.m_iSelectedDevIDs[0]);
        return oDevInfo;
    }

    public void setShowingBoardInfo(boolean bShowingBoardInfo) {
        this.isShowingBoardInfo = bShowingBoardInfo;
        this.expandBtn.setEnabled(this.isShowingBoardInfo);
        this.collapseBtn.setEnabled(this.isShowingBoardInfo);
    }

    public void setRefreshBtnStatus(boolean bEnable) {
        this.queryBtn.setEnabled(bEnable);
    }

    public void removeAllComponent() {
        this.removeAll();
        if (null != this.m_oRootNode) {
            this.m_oRootNode.removeAllChildren();
        }
        this.isShowingBoardInfo = false;
        this.isShowBoardComponent = false;
    }

    class ProgressBar
    extends Thread {
        private static final int MAXVALUE = 100;
        private static final int MILLISECONDS = 100;
        private static final int TIMEOUT = 100;
        private final int DELAY = 100;
        private JProgressBar oProgressBar;

        public ProgressBar(JProgressBar bar) {
            this.oProgressBar = bar;
        }

        @Override
        public void run() {
            int minimum = this.oProgressBar.getMinimum();
            int maximum = this.oProgressBar.getMaximum();
            try {
                for (int count = minimum; count < maximum; ++count) {
                    if (!BoardInfoPanel.this.m_bThreadStop) {
                        int value = this.oProgressBar.getValue();
                        this.oProgressBar.setValue(value + 1);
                        if (count == maximum - 1) {
                            Thread.sleep(1000L);
                            BoardInfoPanel.this.m_oprogressDlg.dispose();
                            BoardInfoPanel.this.m_deviceInfoManager = DCFrameWorkUtil.getDeviceInfoManager();
                            if (BoardInfoPanel.this.m_deviceInfoManager != null) {
                                BoardInfoPanel.this.m_deviceInfoManager.unRegisterForNotification(43850);
                            }
                            BoardInfoPanel.this.setLableInfo(BoardInfoPanel.this.oRes.getResString("SEND_FAIL"));
                            continue;
                        }
                        Thread.sleep(100L);
                        continue;
                    }
                    return;
                }
            }
            catch (InterruptedException ignoredException) {
                DCDebugTracer.trace("BoardInfoPanel InterruptedException");
                BoardInfoPanel.this.setLableInfo(BoardInfoPanel.this.oRes.getResString("DEVICE_BOARDS_NOT_PRESENT"));
                return;
            }
        }
    }
}

