/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceview.deviceinfo.boardinfo;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.DeviceInfoTabPanel;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.boardinfo.BoardInfoPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class AutoProgressDlg
extends DCModalDialog {
    private static final long serialVersionUID = 1L;
    private JProgressBar m_progressBar = null;
    private JButton m_oCancelButton;
    private BoardInfoPanel boardInfoPanel = null;
    private JLabel progressLabel = new JLabel("");

    public AutoProgressDlg(BoardInfoPanel boardInfoPanel) {
        super(DCFrameWorkUtil.getMainFrame(), true);
        this.boardInfoPanel = boardInfoPanel;
        this.jbInit();
    }

    private void jbInit() {
        this.initDialog();
        this.initLabel();
        this.initProgressbar();
        this.initCancelButton();
        this.getContentPane().add((Component)this.progressLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 12, 5, 12), 0, 0));
        this.getContentPane().add((Component)this.m_progressBar, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 12, 0, 12), 0, 0));
        this.getContentPane().add((Component)this.m_oCancelButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 12, 0, 12), 0, 0));
        this.setDefaultCloseOperation(2);
    }

    private void initDialog() {
        this.setSize(378, 90);
        this.setResizable(false);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        this.getContentPane().setLayout(null);
    }

    private void initLabel() {
        this.progressLabel.setBounds(10, 10, 255, 21);
        this.progressLabel.setPreferredSize(new Dimension(255, 21));
        this.progressLabel.setPreferredSize(new Dimension(255, 21));
    }

    private void initProgressbar() {
        this.m_progressBar = new JProgressBar(0, 0, 6000);
        this.m_progressBar.setName("DeviceView_AutoProgressDlg_m_progressBar");
        this.m_progressBar.setOpaque(true);
        this.m_progressBar.setBounds(10, 30, 255, 21);
        this.m_progressBar.setPreferredSize(new Dimension(255, 21));
        this.m_progressBar.setMinimumSize(new Dimension(255, 21));
        this.m_progressBar.setBackground(this.getBackground());
        this.m_progressBar.setForeground(new Color(0, 0, 116));
        this.m_progressBar.setValue(0);
        this.m_progressBar.setStringPainted(true);
        this.m_progressBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Color.gray));
    }

    private void initCancelButton() {
        this.m_oCancelButton = new JButton();
        this.m_oCancelButton.setName("DeviceView_AutoProgressDlg_m_oCancelButton");
        this.m_oCancelButton.setBounds(270, 30, 80, 21);
        this.m_oCancelButton.setPreferredSize(new Dimension(80, 21));
        this.m_oCancelButton.setMinimumSize(new Dimension(80, 21));
        this.m_oCancelButton.setText(ResourceManager.getInstance().getResString("MDP_SETTING_CANCEL_BTN"));
        this.m_oCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AutoProgressDlg.this.closeDialog();
            }
        });
        this.getContentPane().add((Component)this.m_oCancelButton, null);
    }

    public void setInfomation(String info) {
        this.progressLabel.setText(info);
    }

    @Override
    public void closeDialog() {
        if (null == this.boardInfoPanel) {
            return;
        }
        this.boardInfoPanel.stopProcessBar();
        IDeviceInfoManager oDeviceManager = DCFrameWorkUtil.getDeviceInfoManager();
        oDeviceManager.unRegisterForNotification(43850);
        this.changeTabSelection();
        this.dispose();
        this.boardInfoPanel = null;
    }

    private void changeTabSelection() {
        DeviceInfoTabPanel deviceInfoTabbedPanel = this.getInfoTabbedPanel();
        if (null != deviceInfoTabbedPanel && deviceInfoTabbedPanel.getSelectedComponent() == this.boardInfoPanel) {
            deviceInfoTabbedPanel.setSelectedIndex(deviceInfoTabbedPanel.getBoardInfoTabIndex());
        }
    }

    private DeviceInfoTabPanel getInfoTabbedPanel() {
        DeviceInfoTabPanel deviceInfoTabPanel = null;
        Container parent = this.boardInfoPanel.getParent();
        if (parent instanceof DeviceInfoTabPanel) {
            deviceInfoTabPanel = (DeviceInfoTabPanel)parent;
        }
        return deviceInfoTabPanel;
    }

    JProgressBar getProgressBar() {
        return this.m_progressBar;
    }

    @Override
    protected String getCurrentContext() {
        return null;
    }
}

