/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.FileOperationUtils;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.BackupFileContentDlg;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.BackupFilesProgressDlg;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.BackupInfoPanel;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.IProgressbarNotification;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.framework.ClientFileOperations;
import java.awt.Component;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.security.SecureRandom;
import java.text.Collator;
import java.util.Calendar;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class ViewFile
implements IProgressbarNotification,
IDCObjectDeallocator {
    private static int m_iOpRequestId = -1;
    private volatile boolean m_bThreadStop = false;
    private static boolean m_bCancelSelected = false;
    private static final int BACKUP_FILE_TABLE_FILEPATH = 1;
    public DCSortableTreeTable m_oBackupFileInfoTreeTable;
    public BackupFilesProgressDlg m_oprogressDlg;
    public ProgressBar m_oProgressbar;
    private static String m_strTempDirectory = null;
    private static int m_iErrorcode = -1;
    private static ViewFile m_oViewFile;
    private BackupInfoPanel m_oBackupInfoPanel = null;
    private final String m_strSystemTempPath = DCConstants.CLIENT_TEMP_DIRECTORY;
    private static byte[] m_oSyncObj;
    private int m_iSelectedDevId = -1;
    private SecureRandom ran = new SecureRandom();

    ViewFile(BackupInfoPanel oBackupInfoPanel) {
        DCSortableTreeTable oBackupFileInfoTreeTable = oBackupInfoPanel.getBackupInfoTable();
        this.m_oBackupInfoPanel = oBackupInfoPanel;
        this.m_oBackupFileInfoTreeTable = oBackupFileInfoTreeTable;
        m_iOpRequestId = this.generateReqId();
        this.m_bThreadStop = false;
        m_bCancelSelected = false;
        int[] iSelectedDevIds = this.m_oBackupInfoPanel.getSelectedDevIDs();
        if (null != iSelectedDevIds && 1 == iSelectedDevIds.length) {
            this.m_iSelectedDevId = iSelectedDevIds[0];
        }
        this.viewBackupFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void operationCancelled() {
        m_bCancelSelected = true;
        this.m_bThreadStop = true;
        byte[] byArray = m_oSyncObj;
        synchronized (m_oSyncObj) {
            m_oSyncObj.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private ViewFile() {
    }

    private double getRandomNum() {
        return this.ran.nextDouble();
    }

    public static synchronized ViewFile getInstance() {
        if (null == m_oViewFile) {
            m_oViewFile = new ViewFile();
        }
        return m_oViewFile;
    }

    public boolean checkIfRequestExists(int iRequestId) {
        boolean bIsExists = false;
        if (m_iOpRequestId == iRequestId) {
            bIsExists = true;
        }
        return bIsExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyFileTransferProgress(int iErrorCode) {
        m_iErrorcode = iErrorCode;
        byte[] byArray = m_oSyncObj;
        synchronized (m_oSyncObj) {
            m_oSyncObj.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void viewBackupFile() {
        boolean bisZipFile = false;
        ContentType oContentType = null;
        String strBackupFilePath = DCConstants.CLIENT_TEMP_DIRECTORY;
        m_strTempDirectory = strBackupFilePath + "/temp";
        m_strTempDirectory = FileUtil.getUnifyPath(m_strTempDirectory);
        int iRowSelected = this.m_oBackupFileInfoTreeTable.getSelectedRow();
        Object oContentTypeData = this.m_oBackupFileInfoTreeTable.getValueAt(iRowSelected, 3);
        if (oContentTypeData instanceof ContentType) {
            oContentType = (ContentType)oContentTypeData;
        }
        String oString = this.m_oBackupInfoPanel.getFileType(iRowSelected);
        int cellvalue = Integer.parseInt(oString);
        if (oContentType == null) {
            oContentType = new ContentType(cellvalue, "zip File Manually Made");
        }
        Object infoTableObject = this.m_oBackupFileInfoTreeTable.getValueAt(iRowSelected, 1);
        String strSelectedFilePath = infoTableObject.toString();
        boolean oboolean = strSelectedFilePath.endsWith("zip");
        if (cellvalue != 0 && -2 != cellvalue && !oboolean) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("BACKUP_FILE_VIEW_COMPARE_ERROR"), ResourceManager.getInstance().getResString("INFORMATION"), 1);
            return;
        }
        String strLocation = this.m_oBackupFileInfoTreeTable.getValueAt(iRowSelected, 1).toString();
        String strLocal = ResourceManager.getInstance().getResString("BACKUP_CLIENT");
        String strFilePath = this.m_oBackupFileInfoTreeTable.getValueAt(iRowSelected, 1).toString();
        boolean bClientServerOnSameMachine = this.isServerOnSameMachine();
        if (Collator.getInstance().equals(strLocal, strLocation) || bClientServerOnSameMachine) {
            this.openingProgressDlg();
            if (strFilePath.endsWith("zip")) {
                File oFile = FileOperationUtils.unZipFile(strFilePath);
                strFilePath = oFile.toString();
                bisZipFile = true;
            }
            new ViewClientFileContent(strFilePath, bisZipFile);
        } else {
            File oDeleteTempFile = new File(m_strTempDirectory);
            this.deleteTempDirectory(oDeleteTempFile);
            new ViewFileTransferThread();
            this.openingProgressDlg();
        }
    }

    private boolean deleteTempDirectory(File path) {
        block9: {
            if (null != path && path.exists()) {
                String strTempPath;
                String strPath = path.getPath();
                if ((strPath = strPath.replace('\\', '/')).startsWith(strTempPath = this.m_strSystemTempPath.replace('\\', '/'))) {
                    try {
                        File[] files = path.listFiles();
                        for (int i = 0; i < files.length; ++i) {
                            if (files[i].isDirectory()) {
                                this.deleteTempDirectory(files[i]);
                                continue;
                            }
                            if (files[i].delete()) continue;
                            DCDebugTracer.trace("DC::" + this.getClass() + ".deleteTempDirectory(fail to delete " + files[i] + ")");
                        }
                    }
                    catch (Exception e) {
                        if (path.delete()) break block9;
                        DCDebugTracer.trace("DC::" + this.getClass() + ".deleteTempDirectory(fail to delete " + path + ")");
                    }
                }
            }
        }
        boolean isDelete = false;
        if (null != path) {
            String strBackupFilePath = DCConstants.CLIENT_TEMP_DIRECTORY + "/temp";
            if ((strBackupFilePath = strBackupFilePath.replace('/', '\\')).equals(path.toString())) {
                return true;
            }
            isDelete = path.delete();
            if (!isDelete) {
                DCDebugTracer.trace("DC::" + this.getClass() + ".deleteTempDirectory(fail to delete " + path + ")");
            }
        }
        return isDelete;
    }

    private int generateReqId() {
        Calendar oCal = Calendar.getInstance();
        StringBuffer strReqId = new StringBuffer();
        strReqId.append(oCal.get(10));
        strReqId.append(oCal.get(12));
        strReqId.append(oCal.get(13));
        return Integer.parseInt(strReqId.toString());
    }

    public void openingProgressDlg() {
        this.m_oprogressDlg = new BackupFilesProgressDlg(this);
        this.m_oprogressDlg.setName("DeviceView_ViewFile_m_oprogressDlg");
        this.m_oprogressDlg.setTitle(ResourceManager.getInstance().getResString("BACKUP_FILE_PROGRESSDLG_TITLE"));
        this.m_oprogressDlg.setInfomation(ResourceManager.getInstance().getResString("BACKUP_FILE_PROGRESSDLG_TITLE"));
        this.m_oProgressbar = new ProgressBar(this.m_oprogressDlg.getProgressBar());
        this.m_oProgressbar.start();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewFile.this.m_oprogressDlg.setVisible(true);
            }
        });
    }

    private boolean isServerOnSameMachine() {
        return DCFrameWorkUtil.isServerOnSameMachine(ResourceManager.getInstance().getResString("BACKUP_FILES_UNABLE_TO_TRACE_SERVER"));
    }

    @Override
    public void setToNULL() {
        m_bCancelSelected = true;
        if (null != this.m_oProgressbar && null != this.m_oprogressDlg) {
            this.m_oprogressDlg.setVisible(false);
            this.m_oprogressDlg.closeDialog();
            this.m_oprogressDlg = null;
            this.m_oProgressbar = null;
        }
        this.m_oBackupFileInfoTreeTable = null;
        this.m_oBackupInfoPanel = null;
    }

    static {
        m_oSyncObj = new byte[0];
    }

    class ViewClientFileContent
    extends Thread {
        private String strFilePath;
        private boolean bisZipFile;

        public ViewClientFileContent(String strViewFilePath, boolean bisClientZipFile) {
            this.strFilePath = strViewFilePath;
            this.bisZipFile = bisClientZipFile;
            this.start();
        }

        @Override
        public void run() {
            if (!m_bCancelSelected) {
                ViewFile.this.m_bThreadStop = true;
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ViewFile.this.m_oprogressDlg.dispose();
                        }
                    });
                    Thread.sleep(100L);
                    new BackupFileContentDlg(this.strFilePath, this.bisZipFile, ViewFile.this.m_iSelectedDevId);
                }
                catch (DCException e) {
                    DCDebugTracer.trace(e);
                }
                catch (InterruptedException e) {
                    DCDebugTracer.trace(e);
                }
            } else {
                ViewFile.this.m_bThreadStop = true;
                ViewFile.this.m_oprogressDlg.dispose();
            }
        }
    }

    class ViewFileTransferThread
    extends Thread {
        private int iRowSelected;
        private String strtempDirectory;
        private String strFilePath;
        private ClientFileOperations clientFileOperations;
        private String strFileName;
        private String strRootDir = "";

        public ViewFileTransferThread() {
            SystemManager oSystemInfo = new SystemManager();
            if (null != oSystemInfo) {
                this.strRootDir = oSystemInfo.getSystemServerFTPRoot();
            }
            this.init();
            this.start();
        }

        public void init() {
            this.iRowSelected = ViewFile.this.m_oBackupFileInfoTreeTable.getSelectedRow();
            this.strFilePath = ViewFile.this.m_oBackupFileInfoTreeTable.getValueAt(this.iRowSelected, 1).toString();
            int iTitleIndex = this.strFilePath.lastIndexOf("/") + 1;
            this.strFileName = this.strFilePath.substring(iTitleIndex);
            this.strtempDirectory = m_strTempDirectory;
            this.clientFileOperations = new ClientFileOperations();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block20: {
                boolean bIsFolderCreated = false;
                try {
                    this.strtempDirectory = this.strtempDirectory + File.separator + ViewFile.this.getRandomNum();
                    this.strtempDirectory = FileUtil.getUnifyPath(this.strtempDirectory);
                    File oTempDir = new File(this.strtempDirectory);
                    bIsFolderCreated = oTempDir.exists() ? true : new File(this.strtempDirectory).mkdirs();
                }
                catch (Exception e) {
                    bIsFolderCreated = false;
                }
                if (!bIsFolderCreated) {
                    ViewFile.this.m_bThreadStop = true;
                    ViewFile.this.m_oprogressDlg.dispose();
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("BACKUP_FILES_UNABLE_TO_CREATE_TEMP_FOLDER"), ResourceManager.getInstance().getResString("ERROR"), 0);
                    return;
                }
                int iFileIndex = this.strRootDir.length();
                this.strFilePath = this.strFilePath.substring(iFileIndex);
                if (this.strFilePath.startsWith("/")) {
                    this.strFilePath = this.strFilePath.substring(1);
                }
                this.clientFileOperations.getFileFromServer(this.strFilePath, this.strtempDirectory, m_iOpRequestId, 3);
                byte[] byArray = m_oSyncObj;
                synchronized (byArray) {
                    try {
                        m_oSyncObj.wait(DCConstants.DEFAULT_WAIT_TIME);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                String strViewBackupFilePath = this.strtempDirectory + File.separator + this.strFileName;
                strViewBackupFilePath = FileUtil.getUnifyPath(strViewBackupFilePath);
                if (!m_bCancelSelected) {
                    if (0 == m_iErrorcode) {
                        if (!m_bCancelSelected) {
                            try {
                                ViewFile.this.m_bThreadStop = true;
                                ViewFile.this.m_oprogressDlg.setVisible(false);
                                ViewFile.this.m_oprogressDlg.dispose();
                                boolean bisZipFile = false;
                                if (this.strFileName.endsWith("zip")) {
                                    strViewBackupFilePath = FileOperationUtils.unZipFile(strViewBackupFilePath).toString();
                                    bisZipFile = true;
                                    new BackupFileContentDlg(strViewBackupFilePath, bisZipFile, ViewFile.this.m_iSelectedDevId);
                                    break block20;
                                }
                                new BackupFileContentDlg(strViewBackupFilePath, bisZipFile, ViewFile.this.m_iSelectedDevId);
                                Thread.sleep(1000L);
                                File oDeleteTempFile1 = new File(m_strTempDirectory);
                                ViewFile.this.deleteTempDirectory(oDeleteTempFile1);
                            }
                            catch (DCException e) {
                                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("INITIALISE_FAILED"), ResourceManager.getInstance().getResString("ERROR"), 0);
                            }
                            catch (InterruptedException e) {
                                DCDebugTracer.trace(e);
                            }
                        }
                    } else {
                        ViewFile.this.m_bThreadStop = true;
                        ViewFile.this.m_oprogressDlg.setVisible(false);
                        ViewFile.this.m_oprogressDlg.dispose();
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), m_iErrorcode, ResourceManager.getInstance().getResString("BACKUP_FILES_SFTP_ERROR"), 0);
                    }
                } else {
                    File oFile = new File(strViewBackupFilePath);
                    ViewFile.this.deleteTempDirectory(oFile);
                }
            }
        }
    }

    class ProgressBar
    extends Thread {
        private static final int TIMEOUT = 80;
        private static final int MILLISECONDS = 6000;
        private JProgressBar oProgressBar;
        private static final int MAXVALUE = 100;
        private static final int DELAY = 4800;

        public ProgressBar(JProgressBar bar) {
            this.oProgressBar = bar;
        }

        @Override
        public void run() {
            int minimum = this.oProgressBar.getMinimum();
            int maximum = this.oProgressBar.getMaximum();
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    if (ViewFile.this.m_bThreadStop) {
                        return;
                    }
                    int value = ProgressBar.this.oProgressBar.getValue();
                    ProgressBar.this.oProgressBar.setValue(value + 1);
                }
            };
            try {
                for (int i = minimum; i < maximum; ++i) {
                    SwingUtilities.invokeAndWait(runner);
                    if (!ViewFile.this.m_bThreadStop) {
                        Thread.sleep(4800L);
                        if (maximum - 1 != i || ViewFile.this.m_bThreadStop) continue;
                        ViewFile.this.m_oprogressDlg.setVisible(false);
                        ViewFile.this.m_oprogressDlg.dispose();
                        m_iOpRequestId = -1;
                        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("OPERATION_TIME_OUT"), ResourceManager.getInstance().getResString("ERROR_MESSAGE_TITLE"), 0);
                        continue;
                    }
                    return;
                }
            }
            catch (InterruptedException ignoredException) {
                return;
            }
            catch (InvocationTargetException ignoredException) {
                return;
            }
        }
    }
}

