/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.asndatacenter.AsnBackUpFileListResp;
import com.huawei.dc.common.asndatacenter.AsnDCFile;
import com.huawei.dc.common.components.dialog.SaveBackupFilesProgressDlg;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCFileChooser;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.common.util.IOStreamClose;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.IBackupFileNotification;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.SaveBackupFileNotifier;
import com.huawei.dc.framework.ClientFileOperations;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class SaveBackupFiles
implements IBackupFileNotification {
    private static byte[] m_oSyncObj = new byte[0];
    private SaveBackupFilesProgressDlg m_oProgressDlg = null;
    private int m_iErrorCode = -1;
    private boolean m_bCloseFlag = false;
    private DCFileChooser m_oSaveasFileChooser = null;
    private SaveBackupFiles m_oSaveBackupFiles = this;
    private List<Integer> m_oDevIdLst;
    private int m_iFileCount = 0;
    private int m_iDevCount = 0;
    private int m_iCompletedDevCount = 0;

    public SaveBackupFiles(List<Integer> oDevIDList) {
        this.m_oDevIdLst = oDevIDList;
        this.m_iDevCount = this.m_oDevIdLst.size();
    }

    public void saveAsBackupFiles() {
        int returnValue = this.showFileChooserDialog();
        if (0 != returnValue) {
            return;
        }
        this.m_oProgressDlg = new SaveBackupFilesProgressDlg();
        this.m_oProgressDlg.setTitle(ResourceManager.getInstance().getResString("SAVE_BACKUP_FILES"));
        this.setCloseFlag(false);
        SaveBackupFileNotifier.getInstance().addNotificationListener(this.m_oSaveBackupFiles);
        Thread oThread = new Thread(new Runnable(){

            @Override
            public void run() {
                int iDevCount = 0;
                int iCompletedDevCount = 0;
                int iErrorCode = 0;
                ArrayList<BigInteger> oTmpDevIDLst = new ArrayList<BigInteger>();
                for (Integer iDevId : SaveBackupFiles.this.m_oDevIdLst) {
                    ++iCompletedDevCount;
                    oTmpDevIDLst.add(BigInteger.valueOf(iDevId.intValue()));
                    if (++iDevCount == 100) {
                        iErrorCode = SaveBackupFiles.this.doSaveAs(oTmpDevIDLst);
                        if (0 != iErrorCode) break;
                        iDevCount = 0;
                        oTmpDevIDLst.clear();
                    }
                    if (!SaveBackupFiles.this.m_oProgressDlg.getisCancelButtonClicked()) continue;
                    SaveBackupFiles.this.setCloseFlag(true);
                    break;
                }
                if (0 == iErrorCode && 0 < iDevCount) {
                    iErrorCode = SaveBackupFiles.this.doSaveAs(oTmpDevIDLst);
                    iDevCount = 0;
                    oTmpDevIDLst.clear();
                }
                if (0 != iErrorCode) {
                    SaveBackupFiles.this.showMessage(iErrorCode);
                } else if (0 == SaveBackupFiles.this.m_iFileCount) {
                    DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("NO_BACKUP_FILES_IN_SELECTED_DEVICES"));
                } else if (!SaveBackupFiles.this.m_oProgressDlg.getisCancelButtonClicked()) {
                    DCDebugTracer.trace("close progress dialog");
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SAVE_SUCCESS"), ResourceManager.getInstance().getResString("INFO"), 1);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SaveBackupFiles.this.m_oProgressDlg.dispose();
                    }
                });
                SaveBackupFiles.this.setCloseFlag(true);
            }
        });
        oThread.start();
        if (!this.isCloseFlag()) {
            this.m_oProgressDlg.setVisible(true);
        }
        SaveBackupFileNotifier.getInstance().removeNotificationListener(this.m_oSaveBackupFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setErrorCode(int mIErrorCode) {
        byte[] byArray = m_oSyncObj;
        synchronized (m_oSyncObj) {
            DCDebugTracer.trace(" SaveBackupFiles#setErrorCode --> mIErrorCode : " + mIErrorCode);
            this.m_iErrorCode = mIErrorCode;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private int doSaveAs(List<BigInteger> oDevIDList) {
        int iErrorCode = 0;
        int iDevCount = oDevIDList.size();
        AsnBackUpFileListResp oAsnBackUpFileListResp = new AsnBackUpFileListResp();
        iErrorCode = DCFrameWorkUtil.getDeviceInfoManager().getSaveAsBackupFileList(oDevIDList, oAsnBackUpFileListResp);
        if (0 != iErrorCode) return iErrorCode;
        int iNoOfFiles = oAsnBackUpFileListResp.oAsnDCFileLst.size();
        if (0 == iNoOfFiles) {
            this.m_iCompletedDevCount += iDevCount;
            this.updateProgress(this.m_iCompletedDevCount);
            return iErrorCode;
        }
        int iTmpFileCount = this.m_iFileCount;
        this.m_iFileCount += iNoOfFiles;
        boolean bIsSameMachine = SaveBackupFiles.isServerOnSameMachine();
        String strFile = "";
        SaveBackupFilesThread oSaveBackupFilesThread = null;
        DCDebugTracer.trace("is same machine " + bIsSameMachine);
        int i = 0;
        while (true) {
            if (i >= iNoOfFiles) {
                this.m_iCompletedDevCount += iDevCount;
                return iErrorCode;
            }
            AsnDCFile oAsnDCFile = (AsnDCFile)oAsnBackUpFileListResp.oAsnDCFileLst.get(i);
            strFile = new String(oAsnDCFile.strTimeOrFileName);
            if (this.checkIfFile(strFile)) {
                strFile = strFile.substring(0, strFile.lastIndexOf("/"));
            }
            String strTmp = strFile;
            strTmp = FileUtil.getUnifyPath(strTmp);
            String[] strArr = strTmp.split("ftproot/dc/", 2);
            String strDstString = this.m_oSaveasFileChooser.getSelectedFile().getAbsolutePath() + "/" + strArr[1];
            strDstString = FileUtil.getUnifyPath(strDstString);
            if (bIsSameMachine) {
                this.copyLocalData(strFile, strDstString);
            } else {
                oSaveBackupFilesThread = new SaveBackupFilesThread(strDstString, strFile);
                oSaveBackupFilesThread.start();
                byte[] byArray = m_oSyncObj;
                // MONITORENTER : m_oSyncObj
                try {
                    m_oSyncObj.wait(DCConstants.DEFAULT_WAIT_TIME);
                }
                catch (InterruptedException e) {
                    DCDebugTracer.trace(e);
                }
                byArray = m_oSyncObj;
                // MONITORENTER : m_oSyncObj
                if (0 != this.m_iErrorCode) {
                    DCDebugTracer.traceStack();
                    boolean bState = true;
                    if (i > 0) {
                        bState = false;
                    }
                    this.deleteFilesOnFailure(bState, strArr[1]);
                    // MONITOREXIT : byArray
                    return this.m_iErrorCode;
                }
                // MONITOREXIT : byArray
            }
            this.m_oProgressDlg.setFileCount(iTmpFileCount + i + 1);
            oSaveBackupFilesThread = null;
            strTmp = null;
            strArr = null;
            strDstString = null;
            if (this.m_oProgressDlg.getisCancelButtonClicked()) {
                this.setCloseFlag(true);
                return iErrorCode;
            }
            this.updateProgress((i + 1) * iDevCount / iNoOfFiles + this.m_iCompletedDevCount);
            ++i;
        }
    }

    private int showFileChooserDialog() {
        this.m_oSaveasFileChooser = new DCFileChooser();
        this.m_oSaveasFileChooser.setTitle(DCFrameWorkUtil.getLocalizedString("SAVE_AS"));
        this.m_oSaveasFileChooser.setFileSelectionMode(1);
        int returnValue = this.m_oSaveasFileChooser.showDialog(DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("OK"));
        return returnValue;
    }

    private void showMessage(int iErrorCode) {
        DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyFileTransferProgress(int iErrorCode) {
        this.setErrorCode(iErrorCode);
        byte[] byArray = m_oSyncObj;
        synchronized (m_oSyncObj) {
            m_oSyncObj.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static boolean isServerOnSameMachine() {
        return DCFrameWorkUtil.isServerOnSameMachine(ResourceManager.getInstance().getResString("BACKUP_FILES_UNABLE_TO_TRACE_SERVER"));
    }

    private boolean checkIfFile(String strFilePath) {
        boolean isDirectory = false;
        int iFileExtnIndex = strFilePath.lastIndexOf(".");
        if (-1 != iFileExtnIndex) {
            isDirectory = true;
        }
        return isDirectory;
    }

    private void copyLocalData(String strPath, String strSaveasFileName) {
        DCDebugTracer.trace("copyLocalData " + strPath + " destFile " + strSaveasFileName);
        File oDestination = new File(strSaveasFileName);
        if (!oDestination.mkdirs()) {
            DCDebugTracer.trace("DC::" + this.getClass() + ".copyLocalData(fail to make dir <" + oDestination + ">)");
        }
        File oSourceDir = new File(strPath);
        File[] oSourceFiles = oSourceDir.listFiles();
        int iNosFiles = oSourceFiles.length;
        for (int i = 0; i < iNosFiles; ++i) {
            String strDestinationPath = oDestination.getAbsolutePath();
            File oSourceFilePath = oSourceFiles[i];
            int iIndex = oSourceFilePath.getAbsolutePath().lastIndexOf(File.separator);
            String strDestinationFileName = oSourceFilePath.getAbsolutePath().substring(iIndex);
            strDestinationPath = strDestinationPath + strDestinationFileName;
            if (!oSourceFilePath.isFile()) continue;
            this.copyfile(oSourceFilePath.getAbsolutePath(), strDestinationPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyfile(String strSrcPath, String strDestainationPath) {
        block7: {
            String strSrcFileName = null;
            String strSrcDirectory = null;
            String strDestinationFileName = null;
            String strDesinationDirectory = null;
            File oSrcFile = null;
            File oDestinationFile = null;
            strSrcFileName = new File(strSrcPath).getName();
            strSrcDirectory = new File(strSrcPath).getParentFile().getAbsolutePath();
            strDestinationFileName = new File(strDestainationPath).getName();
            strDesinationDirectory = new File(strDestainationPath).getParentFile().getAbsolutePath();
            FileInputStream oInputStream = null;
            FileOutputStream oOutputStream = null;
            try {
                oSrcFile = new File(strSrcDirectory, strSrcFileName);
                oDestinationFile = new File(strDesinationDirectory, strDestinationFileName);
                if (!oDestinationFile.exists() && !oDestinationFile.createNewFile()) {
                    DCDebugTracer.trace("DC::" + this.getClass() + ".copyfile(fail to create " + oDestinationFile + ")");
                }
                oInputStream = new FileInputStream(oSrcFile);
                oOutputStream = new FileOutputStream(oDestinationFile);
                byte[] buf = new byte[(int)oSrcFile.length()];
                int ilen = ((InputStream)oInputStream).read(buf);
                while (ilen > 0) {
                    ((OutputStream)oOutputStream).write(buf, 0, ilen);
                    ilen = ((InputStream)oInputStream).read(buf);
                }
                IOStreamClose.closeOutputStream(oOutputStream);
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SAVE_AS_OPERATION_FAILED"), ResourceManager.getInstance().getResString("ERROR"), 0);
                break block7;
            }
            finally {
                IOStreamClose.closeOutputStream(oOutputStream);
                IOStreamClose.closeInputStream(oInputStream);
            }
            IOStreamClose.closeInputStream(oInputStream);
        }
    }

    private void updateProgress(int iFilesCompleted) {
        int iProgressPercent = iFilesCompleted * 100 / this.m_iDevCount;
        this.m_oProgressDlg.setProgress(iProgressPercent);
    }

    private void deleteFilesOnFailure(boolean bIsDeleteFromRootDir, String strPath) {
        if (!bIsDeleteFromRootDir) {
            String[] strArr = strPath.split("/", 4);
            strPath = this.m_oSaveasFileChooser.getSelectedFile().getAbsolutePath() + "/" + strArr[1] + "/" + strArr[2];
            this.deleteDir(new File(strPath));
        }
    }

    private boolean deleteDir(File oDestinationpath) {
        if (oDestinationpath.isDirectory()) {
            String[] strSubFiles = oDestinationpath.list();
            for (int i = 0; i < strSubFiles.length; ++i) {
                boolean bSuccess = this.deleteDir(new File(oDestinationpath, strSubFiles[i]));
                if (bSuccess) continue;
                return false;
            }
        }
        return oDestinationpath.delete();
    }

    public boolean isCloseFlag() {
        return this.m_bCloseFlag;
    }

    public synchronized void setCloseFlag(boolean m_bCloseFlag) {
        this.m_bCloseFlag = m_bCloseFlag;
    }

    class SaveBackupFilesThread
    extends Thread {
        private String m_strFilePath;
        private ClientFileOperations oclientFileOperations;
        private String strSaveasFilepath;

        public SaveBackupFilesThread(String strDestinationFilename, String strFilePath) {
            this.strSaveasFilepath = strDestinationFilename;
            this.m_strFilePath = strFilePath;
            this.oclientFileOperations = new ClientFileOperations();
        }

        @Override
        public void run() {
            File oTempDestinationPath = new File(this.strSaveasFilepath);
            if (!oTempDestinationPath.mkdirs()) {
                DCDebugTracer.trace("DC::" + this.getClass() + ".run(fail to make dir <" + oTempDestinationPath + ">)");
            }
            SystemManager sysMgr = new SystemManager();
            String strRoot = sysMgr.getSystemServerFTPRoot();
            this.m_strFilePath = this.m_strFilePath.substring(strRoot.length());
            if (this.m_strFilePath.startsWith("/")) {
                this.m_strFilePath = this.m_strFilePath.substring(1);
            }
            this.oclientFileOperations.getFileForSaveasFolder(oTempDestinationPath.getAbsolutePath(), this.m_strFilePath, -1);
        }
    }
}

