/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.ConfigurationInfo;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCFileChooser;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.BackupFilesProgressDlg;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.BackupInfoPanel;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.IBackupFileNotification;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.IProgressbarNotification;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.SaveBackupFileNotifier;
import com.huawei.dc.framework.ClientFileOperations;
import gnu.trove.TIntObjectHashMap;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class SaveAsBackupFile
implements IDCObjectDeallocator,
IProgressbarNotification,
IBackupFileNotification {
    private DCSortableTreeTable m_oBoardInfoTreeTable = null;
    public SaveasFileTransferThread m_oSaveasFileTransferThread = null;
    private BackupFilesProgressDlg m_oprogressDlg;
    private static byte[] m_oSyncObj = new byte[0];
    private TIntObjectHashMap m_ReqidCancelSelectedMap = new TIntObjectHashMap();
    private volatile boolean m_bThreadStop = false;
    private int m_iOpRequestId = -1;
    private static SaveAsBackupFile m_oSaveAsBackupFile;
    public int m_iOperationType = -1;
    private BackupInfoPanel m_oBackupInfoPanel = null;
    public int m_iErrorcode = -1;
    private DCFileChooser oSaveasFileChooser = null;

    void setBackupInfoPanel(BackupInfoPanel backupInfoPanel) {
        this.m_oBackupInfoPanel = backupInfoPanel;
        this.m_oBoardInfoTreeTable = this.m_oBackupInfoPanel.getBackupInfoTable();
    }

    public static synchronized SaveAsBackupFile getInstance() {
        if (null == m_oSaveAsBackupFile) {
            m_oSaveAsBackupFile = new SaveAsBackupFile();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oSaveAsBackupFile);
            SaveBackupFileNotifier.getInstance().addNotificationListener(m_oSaveAsBackupFile);
        }
        return m_oSaveAsBackupFile;
    }

    @Override
    public void setToNULL() {
        if (null != this.oSaveasFileChooser && this.oSaveasFileChooser.isVisible()) {
            this.oSaveasFileChooser.setVisible(false);
            this.oSaveasFileChooser = null;
        }
        if (null != this.m_oSaveasFileTransferThread && this.m_oSaveasFileTransferThread.isAlive()) {
            try {
                this.operationCancelled();
                this.m_oSaveasFileTransferThread.interrupt();
                this.m_oSaveasFileTransferThread.stop();
                this.m_oSaveasFileTransferThread = null;
            }
            catch (Exception e) {
                DCDebugTracer.trace(e);
            }
        }
        if (this.m_oprogressDlg != null && this.m_oprogressDlg.isVisible()) {
            this.m_oprogressDlg.dispose();
            this.m_oprogressDlg = null;
        }
        if (null != this.m_ReqidCancelSelectedMap) {
            this.m_ReqidCancelSelectedMap.clear();
            this.m_ReqidCancelSelectedMap = null;
        }
        SaveBackupFileNotifier.getInstance().removeNotificationListener(m_oSaveAsBackupFile);
        m_oSaveAsBackupFile = null;
    }

    private static boolean isServerOnSameMachine() {
        return DCFrameWorkUtil.isServerOnSameMachine(ResourceManager.getInstance().getResString("BACKUP_FILES_UNABLE_TO_TRACE_SERVER"));
    }

    private DCFileChooser showFileChooser(String strFilePath, String sFileFullName, boolean isFileSelected) {
        String strPath = ConfigurationInfo.getInstance().getAbsoluteBaseDirectory() + File.separator + "report/";
        File fileDoc = new File(strPath);
        if (!fileDoc.exists()) {
            try {
                fileDoc.mkdir();
            }
            catch (Exception ex) {
                DCDebugTracer.trace(ex);
                return null;
            }
        }
        this.oSaveasFileChooser = new DCFileChooser(strPath, false);
        this.oSaveasFileChooser.setTitle(DCFrameWorkUtil.getLocalizedString("SAVE_AS"));
        this.oSaveasFileChooser.setFileSelectionMode(1);
        return this.oSaveasFileChooser;
    }

    private String getSelectedBackupFilePath() {
        String strFilePath = null;
        int iRowSelected = this.m_oBoardInfoTreeTable.getSelectedRow();
        DCDebugTracer.trace("The row of backup file selected" + iRowSelected);
        if (-1 != iRowSelected) {
            strFilePath = (String)this.m_oBoardInfoTreeTable.getValueAt(iRowSelected, 1);
        }
        DCDebugTracer.trace("The path of backup file selected" + strFilePath);
        if (null == strFilePath) {
            strFilePath = "";
        }
        return strFilePath;
    }

    public void saveBackupFile() {
        DCFileChooser oSaveasFileChooser;
        int iRtnValue;
        String strFilePath;
        String sFielFullName = strFilePath = this.getSelectedBackupFilePath();
        if (strFilePath.toLowerCase().indexOf(".dat") != -1 || strFilePath.toLowerCase().indexOf(".cfg") != -1 || strFilePath.toLowerCase().indexOf(".zip") != -1 || strFilePath.toLowerCase().indexOf(".pkg") != -1 || strFilePath.toLowerCase().indexOf(".txt") != -1) {
            File tempFile = new File(strFilePath);
            strFilePath = tempFile.getParent();
        }
        if ((iRtnValue = (oSaveasFileChooser = this.showFileChooser(strFilePath, sFielFullName, this.checkIfFile(strFilePath))).showDialog(DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("OK"))) != 0) {
            return;
        }
        File oBackupFilePath = oSaveasFileChooser.getCurrentDirectory();
        String strSaveasFilePath = oBackupFilePath.getPath();
        String strSaveasFileName = oSaveasFileChooser.getFullFileName();
        DCHelpManager.getInstance().enableF1HelpKey((Component)((Object)oSaveasFileChooser), "HELP_TOPIC_SAVE_NE");
        if (null == strSaveasFileName) {
            if (!oSaveasFileChooser.isDirectorySelectionEnabled()) {
                m_oSaveAsBackupFile = null;
                return;
            }
            strSaveasFileName = strSaveasFilePath;
        }
        if (SaveAsBackupFile.isServerOnSameMachine()) {
            this.doLocalFileCopy(strSaveasFilePath, strSaveasFileName);
        } else {
            strFilePath = strFilePath.replace("\\", "/");
            this.m_oSaveasFileTransferThread = new SaveasFileTransferThread(strSaveasFileName, strFilePath);
            this.openingProgressDlg();
        }
    }

    private boolean checkIfFile(String strFilePath) {
        boolean isDirectory = false;
        int iFileExtnIndex = strFilePath.lastIndexOf(".");
        if (-1 != iFileExtnIndex) {
            isDirectory = true;
        }
        return isDirectory;
    }

    private void doLocalFileCopy(String strSaveasFilePath, String strSaveasFileName) {
        DCDebugTracer.trace("doLocalFileCopy " + strSaveasFilePath + " " + strSaveasFileName);
        String strFilePath = this.getSelectedBackupFilePath();
        DCDebugTracer.trace("filepath = " + strFilePath);
        if (!new File(strFilePath).exists()) {
            this.deleteFileInTable(strSaveasFileName);
        } else if (new File(strFilePath).isDirectory()) {
            this.copyDirectory(strFilePath, strSaveasFileName);
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SAVE_SUCCESS"), ResourceManager.getInstance().getResString("INFO"), 1);
        } else {
            String strDCInfoFileName;
            String parentPath;
            File oDCInfoFile;
            String sBackupParentCatalog = this.getBackupParentCatalog(strFilePath);
            String sSaveFile = strSaveasFileName + "/" + sBackupParentCatalog;
            boolean isSuccess = this.copyfile(strFilePath, sSaveFile);
            if (isSuccess) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SAVE_SUCCESS"), ResourceManager.getInstance().getResString("OPERATE_RESULT"), 1);
            }
            if ((oDCInfoFile = new File(parentPath = new File(strFilePath).getParentFile().getAbsolutePath(), strDCInfoFileName = "DCInfo_" + new File(strFilePath).getName())).exists()) {
                this.copyfile(oDCInfoFile.getAbsolutePath(), strSaveasFilePath + File.separatorChar + "DCInfo_" + new File(strSaveasFileName).getName());
            }
        }
    }

    private void copyDirectory(String strDirPath, String strSaveasFileName) {
        SimpleDateFormat oTimeStampFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        Date oTimeStampFolder = new Date();
        String strCreateFolder = strSaveasFileName + File.separator + oTimeStampFormat.format(oTimeStampFolder);
        File oDestination = new File(strCreateFolder);
        if (!oDestination.mkdirs()) {
            DCDebugTracer.trace("DC::" + this.getClass() + ".copyDirectory(fail to make dir< " + oDestination + ">)");
        }
        File oSourceDir = new File(strDirPath);
        File[] oSourceFiles = oSourceDir.listFiles();
        int iNosFiles = oSourceFiles.length;
        String sTmpPath = strDirPath.replace("\\", "/");
        String sBackupParentCatalog = this.getBackupParentCatalog(sTmpPath);
        for (int i = 0; i < iNosFiles; ++i) {
            String strDestinationPath = oDestination.getAbsolutePath();
            File oSourceFilePath = oSourceFiles[i];
            int iIndex = oSourceFilePath.getAbsolutePath().lastIndexOf(File.separator);
            String strDestinationFileName = oSourceFilePath.getAbsolutePath().substring(iIndex);
            strDestinationPath = strDestinationPath + "/" + sBackupParentCatalog + "/" + strDestinationFileName;
            if (!oSourceFilePath.isFile()) continue;
            this.copyfile(oSourceFilePath.getAbsolutePath(), strDestinationPath);
        }
    }

    private void deleteFileInTable(String strSaveasFileName) {
        DCDebugTracer.trace("backup file not found SaveAsBackupFile.deleteFileInTable() " + strSaveasFileName);
        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("BACKUP_FILE_ALREADY_DELETED"), ResourceManager.getInstance().getResString("ERROR"), 0);
        if (!new File(strSaveasFileName).delete()) {
            DCDebugTracer.trace("DC::" + this.getClass() + ".deleteFileInTable(fail to delete " + strSaveasFileName + ")");
        }
        this.m_oBoardInfoTreeTable.deleteTableRow(new int[]{this.m_oBoardInfoTreeTable.getSelectedRow()});
        this.m_oBoardInfoTreeTable.refereshTable();
        this.m_oBackupInfoPanel.showErrorIfNoRowFound();
    }

    public void openingProgressDlg() {
        this.m_oprogressDlg = new BackupFilesProgressDlg(this);
        this.m_oprogressDlg.setTitle(ResourceManager.getInstance().getResString("BACKUP_FILE_PROGRESSDLG_TITLE"));
        this.m_oprogressDlg.setInfomation(ResourceManager.getInstance().getResString("BACKUP_FILE_PROGRESSDLG_TITLE"));
        ProgressBar m_oProgressbar = new ProgressBar(this.m_oprogressDlg.getProgressBar());
        m_oProgressbar.start();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SaveAsBackupFile.this.m_oprogressDlg.setVisible(true);
            }
        });
    }

    @Override
    public void operationCancelled() {
        this.m_bThreadStop = true;
        this.m_oprogressDlg.setVisible(false);
        this.m_ReqidCancelSelectedMap.put(Integer.valueOf(this.m_iOpRequestId).intValue(), (Object)Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyFileTransferProgress(int iErrorCode) {
        DCDebugTracer.trace("DC::SaveAsBackupFile::iErrorCode::" + iErrorCode);
        this.m_iErrorcode = iErrorCode;
        byte[] byArray = m_oSyncObj;
        synchronized (m_oSyncObj) {
            m_oSyncObj.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyfile(String strSrcPath, String strDestainationPath) {
        DCDebugTracer.trace("copy file strSrcPath=" + strSrcPath + " strDestainationPath=" + strDestainationPath);
        String strSrcFileName = null;
        String strSrcDirectory = null;
        String strDestinationFileName = null;
        String strDesinationDirectory = null;
        File osrcFile = null;
        File oDestinationFile = null;
        strSrcFileName = new File(strSrcPath).getName();
        strSrcDirectory = new File(strSrcPath).getParentFile().getAbsolutePath();
        strDestinationFileName = new File(strDestainationPath).getName();
        strDesinationDirectory = new File(strDestainationPath).getParentFile().getAbsolutePath();
        DCDebugTracer.trace("strDesinationDirectory=" + strDesinationDirectory + " strDestinationFileName=" + strDestinationFileName);
        InputStream oInputStream = null;
        OutputStream oOutputStream = null;
        try {
            osrcFile = new File(strSrcDirectory, strSrcFileName);
            String sSrcFileName = osrcFile.getName();
            DCDebugTracer.trace("sSrcFileName=" + sSrcFileName);
            oDestinationFile = new File(strDesinationDirectory, strDestinationFileName);
            String sTimeInfo = this.generateFileName();
            strDestinationFileName = strDestinationFileName + "/" + sTimeInfo;
            oDestinationFile = new File(strDesinationDirectory, strDestinationFileName);
            if (!oDestinationFile.exists() && !oDestinationFile.mkdirs()) {
                DCDebugTracer.trace("failed to make dir " + strDesinationDirectory + "/" + strDestinationFileName);
            }
            if (!(oDestinationFile = new File(strDesinationDirectory, strDestinationFileName = strDestinationFileName + "/" + sSrcFileName)).createNewFile()) {
                DCDebugTracer.trace("DC::" + this.getClass() + ".copyfile(fail to create " + oDestinationFile + ")");
            }
            oInputStream = new FileInputStream(osrcFile);
            oOutputStream = new FileOutputStream(oDestinationFile);
            byte[] buf = new byte[(int)osrcFile.length()];
            int ilen = oInputStream.read(buf);
            while (ilen > 0) {
                oOutputStream.write(buf, 0, ilen);
                ilen = oInputStream.read(buf);
            }
        }
        catch (IOException e) {
            DCDebugTracer.trace("copyfile->osrcFile :" + osrcFile);
            DCDebugTracer.trace("copyfile->oDestinationFile : " + oDestinationFile);
            DCDebugTracer.trace(e);
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SAVE_AS_OPERATION_FAILED"), ResourceManager.getInstance().getResString("ERROR"), 0);
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != oInputStream) {
                try {
                    oInputStream.close();
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
            }
            if (null != oOutputStream) {
                try {
                    oOutputStream.close();
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
            }
        }
        return true;
    }

    private String generateFileName() {
        SimpleDateFormat oTimeStampFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        Date oTimeStampFolder = new Date();
        return oTimeStampFormat.format(oTimeStampFolder);
    }

    private String getBackupParentCatalog(String sBackupFilePath) {
        String[] strTemps = sBackupFilePath.split("backup", -2);
        String strTransact = strTemps[strTemps.length - 1];
        String[] sTmps = strTransact.split("/");
        return sTmps[1];
    }

    class ProgressBar
    extends Thread {
        private static final int TIMEOUT = 40;
        private static final int MILLISECONDS = 6000;
        private JProgressBar oProgressBar;
        private static final int MAXVALUE = 100;
        private static final int DELAY = 2400;

        public ProgressBar(JProgressBar bar) {
            this.oProgressBar = bar;
        }

        @Override
        public void run() {
            int minimum = this.oProgressBar.getMinimum();
            int maximum = this.oProgressBar.getMaximum();
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    if (SaveAsBackupFile.this.m_bThreadStop) {
                        return;
                    }
                    int value = ProgressBar.this.oProgressBar.getValue();
                    ProgressBar.this.oProgressBar.setValue(value + 1);
                }
            };
            try {
                for (int i = minimum; i < maximum; ++i) {
                    SwingUtilities.invokeAndWait(runner);
                    if (!SaveAsBackupFile.this.m_bThreadStop) {
                        Thread.sleep(2400L);
                        if (maximum - 1 != i || SaveAsBackupFile.this.m_bThreadStop) continue;
                        SaveAsBackupFile.this.m_oprogressDlg.setVisible(false);
                        SaveAsBackupFile.this.m_oprogressDlg.dispose();
                        SaveAsBackupFile.this.m_iOpRequestId = -1;
                        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("OPERATION_TIME_OUT"), ResourceManager.getInstance().getResString("ERROR_MESSAGE_TITLE"), 0);
                        continue;
                    }
                    return;
                }
            }
            catch (InterruptedException ignoredException) {
                return;
            }
            catch (InvocationTargetException ignoredException) {
                return;
            }
        }
    }

    class SaveasFileTransferThread
    extends Thread {
        private String m_strFilePath;
        private ClientFileOperations oclientFileOperations;
        private String strRootDir = "";
        private String strSaveasFileName;
        private String strParentPath = "";

        public SaveasFileTransferThread(String strDestinationFilename, String strFilePath) {
            String strParentdir;
            this.strSaveasFileName = strDestinationFilename;
            String strTemp = this.m_strFilePath = strFilePath;
            this.strParentPath = strParentdir = SaveAsBackupFile.this.getBackupParentCatalog(strTemp);
            SaveAsBackupFile.this.m_iOperationType = 36;
            this.oclientFileOperations = new ClientFileOperations();
            this.start();
        }

        @Override
        public void run() {
            this.handleDirectoryCopy();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleDirectoryCopy() {
            SimpleDateFormat oTimeStampFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            Date oTimeStampFolder = new Date();
            String strCreateFolder = this.strSaveasFileName + File.separator + this.strParentPath + File.separator + oTimeStampFormat.format(oTimeStampFolder);
            File oTempDestinationPath = new File(strCreateFolder);
            if (!oTempDestinationPath.mkdirs()) {
                DCDebugTracer.trace("DC::" + this.getClass() + ".deleteFolder(fail to make dir < " + oTempDestinationPath + ">)");
            }
            int iBackupFileErrorcode = 0;
            boolean bCancelSelected = false;
            int iOperationRequestId = SaveAsBackupFile.this.m_iOpRequestId;
            SystemManager systemManager = new SystemManager();
            this.strRootDir = systemManager.getSystemServerFTPRoot();
            int iFileIndex = this.strRootDir.length();
            this.m_strFilePath = this.m_strFilePath.substring(iFileIndex);
            if (this.m_strFilePath.startsWith("/")) {
                this.m_strFilePath = this.m_strFilePath.substring(1);
            }
            SaveAsBackupFile.this.m_ReqidCancelSelectedMap.put(Integer.valueOf(iOperationRequestId).intValue(), (Object)Boolean.FALSE);
            this.oclientFileOperations.getFileForSaveasFolder(oTempDestinationPath.getAbsolutePath(), this.m_strFilePath, SaveAsBackupFile.this.m_iOpRequestId);
            byte[] byArray = m_oSyncObj;
            synchronized (byArray) {
                try {
                    m_oSyncObj.wait(DCConstants.DEFAULT_WAIT_TIME);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            iBackupFileErrorcode = SaveAsBackupFile.this.m_iErrorcode;
            bCancelSelected = (Boolean)SaveAsBackupFile.this.m_ReqidCancelSelectedMap.get(Integer.valueOf(iOperationRequestId).intValue());
            if (!bCancelSelected) {
                if (0 == iBackupFileErrorcode) {
                    if (!bCancelSelected) {
                        try {
                            SaveAsBackupFile.this.m_bThreadStop = true;
                            SaveAsBackupFile.this.m_oprogressDlg.setVisible(false);
                            SaveAsBackupFile.this.m_oprogressDlg.dispose();
                            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SAVE_SUCCESS"), ResourceManager.getInstance().getResString("INFO"), 1);
                        }
                        catch (Exception e) {
                            DCDebugTracer.trace(e);
                            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("INITIALISE_FAILED"), ResourceManager.getInstance().getResString("ERROR"), 0);
                        }
                    } else {
                        SaveAsBackupFile.this.m_bThreadStop = true;
                        this.deleteFolder(oTempDestinationPath);
                    }
                } else {
                    SaveAsBackupFile.this.m_bThreadStop = true;
                    SaveAsBackupFile.this.m_oprogressDlg.setVisible(false);
                    SaveAsBackupFile.this.m_oprogressDlg.dispose();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (SaveAsBackupFile.this.m_iErrorcode == 0) {
                        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SAVE_SUCCESS"), ResourceManager.getInstance().getResString("INFO"), 1);
                    } else {
                        DCDebugTracer.trace("[FTP]  handleDirectoryCopy : ");
                        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), SaveAsBackupFile.this.m_iErrorcode, ResourceManager.getInstance().getResString("BACKUP_FILES_SFTP_ERROR"), 0);
                    }
                    DCDebugTracer.trace("m_iErrorcode" + SaveAsBackupFile.this.m_iErrorcode);
                    this.deleteFolder(oTempDestinationPath);
                }
            } else {
                this.deleteFolder(oTempDestinationPath);
            }
            SaveAsBackupFile.this.m_ReqidCancelSelectedMap.remove(Integer.valueOf(iOperationRequestId).intValue());
        }

        private void deleteFolder(File oDestinationpath) {
            File[] oFiles;
            boolean isDeleted = oDestinationpath.delete();
            if (!isDeleted && null != (oFiles = oDestinationpath.listFiles())) {
                int iCountOfFiles = oFiles.length;
                for (int i = 0; i < iCountOfFiles; ++i) {
                    if (oFiles[i].delete()) continue;
                    DCDebugTracer.trace("DC::" + this.getClass() + ".deleteFolder(fail to delete " + oFiles[i] + ")");
                }
                if (!oDestinationpath.delete()) {
                    DCDebugTracer.trace("DC::" + this.getClass() + ".deleteFolder(fail to delete " + oDestinationpath + ")");
                }
            }
        }
    }
}

