/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo;

import com.huawei.dc.common.asndatacenter.AsnBackUpFileList;
import com.huawei.dc.common.asndatacenter.AsnDCBackUpFileInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDeleteFileInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDeleteFileListResp;
import com.huawei.dc.common.asndatacenter.AsnDeleteBackUpFileReq;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.controller.DeviceInfoManagerImplHelper;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.FileListError;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.BackupInfoPanel;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.view.common.TaskOperationResultDialog;
import java.awt.Component;
import java.math.BigInteger;
import java.util.Vector;

public class DeleteBackupFile
implements IDCObjectDeallocator {
    private DCSortableTreeTable m_oBackFileInfoTreeTable = null;
    private IDeviceInfoManager m_oDeviceInfoManager = DCFrameWorkUtil.getDeviceInfoManager();
    private static DeleteBackupFile m_oDeleteBackupFile = null;
    private static final int DEFAULT_DEVICE_ID = 0;
    private BackupInfoPanel m_oBackupInfoPanel;

    private DeleteBackupFile() {
    }

    @Override
    public void setToNULL() {
        if (null != m_oDeleteBackupFile) {
            m_oDeleteBackupFile = null;
        }
    }

    public static synchronized DeleteBackupFile getInstance() {
        if (null == m_oDeleteBackupFile) {
            m_oDeleteBackupFile = new DeleteBackupFile();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oDeleteBackupFile);
        }
        return m_oDeleteBackupFile;
    }

    void setBackupInfoPanel(BackupInfoPanel oBackupInfoPanel) {
        this.m_oBackupInfoPanel = oBackupInfoPanel;
        this.m_oBackFileInfoTreeTable = oBackupInfoPanel.getBackupInfoTable();
    }

    void deleteBackupFile() {
        int iConfirmOutput = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("BACKUP_FILES_CONFIRM_DELETE_FILES"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
        if (0 != iConfirmOutput) {
            return;
        }
        int[] iarrSelectedRows = this.m_oBackFileInfoTreeTable.getSelectedRows();
        DCDebugTracer.trace("DC::deleteBackupFile iDevIDs#" + this.m_oBackupInfoPanel.getSelectedDevIDs()[0]);
        if (null != iarrSelectedRows && iarrSelectedRows.length > 0) {
            AsnDeleteBackUpFileReq oAsnDeleteBackUpFileReq = new AsnDeleteBackUpFileReq();
            AsnBackUpFileList oAsnBackUpFileList = this.getSelectedBackupFileList(iarrSelectedRows);
            DCDebugTracer.trace("DC::deleteBackupFile# count of rows  selected: " + iarrSelectedRows.length + "; count of files added to asn" + oAsnBackUpFileList.size());
            oAsnDeleteBackUpFileReq.oAsnFilesPathLst = oAsnBackUpFileList;
            int[] iDevIDs = this.m_oBackupInfoPanel.getSelectedDevIDs();
            oAsnDeleteBackUpFileReq.iDeviceID = null == iDevIDs ? BigInteger.valueOf(0L) : BigInteger.valueOf(iDevIDs[0]);
            DCDebugTracer.trace("DC::deleteBackupFile iDevIDs for delFile#" + oAsnDeleteBackUpFileReq.iDeviceID);
            AsnDCDeleteFileListResp asnDCDeleteFileListResp = new AsnDCDeleteFileListResp();
            int iErrorcode = this.m_oDeviceInfoManager.deleteBackupFiles(oAsnDeleteBackUpFileReq, asnDCDeleteFileListResp);
            if (iErrorcode != 0) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorcode, ResourceManager.getInstance().getResString("ERROR"), 0);
            } else {
                FileListError[] fileListError = this.getFileListErrorInfo(iarrSelectedRows, asnDCDeleteFileListResp);
                this.displayResults(fileListError);
                int[] arrDeletedRow = this.getSuccessfullyDeletedRow(fileListError, iarrSelectedRows);
                this.m_oBackFileInfoTreeTable.deleteTableRow(arrDeletedRow);
                this.m_oBackupInfoPanel.setDefaultSelection(-1);
            }
        } else {
            DCDebugTracer.trace("DC::deleteBackupFile failed:RowCount#" + this.m_oBackFileInfoTreeTable.getDataModel().getRowCount());
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("OPERATIONFAILED"));
        }
    }

    private int[] getSuccessfullyDeletedRow(FileListError[] fileListError, int[] iarrSelectedRows) {
        FileListError oFileListErrorInfo = null;
        int[] arrDeletedRow = new int[iarrSelectedRows.length];
        int iDeletedRowIndex = 0;
        block0: for (int iFileListErrorIndex = 0; iFileListErrorIndex < fileListError.length; ++iFileListErrorIndex) {
            oFileListErrorInfo = fileListError[iFileListErrorIndex];
            String strFilePath = oFileListErrorInfo.getFilePath();
            for (int iSelectedRowIndex = 0; iSelectedRowIndex < iarrSelectedRows.length; ++iSelectedRowIndex) {
                String strRowFileName = (String)this.m_oBackFileInfoTreeTable.getValueAt(iarrSelectedRows[iSelectedRowIndex], 1);
                if (0 != oFileListErrorInfo.getErrorNo() || !strFilePath.equalsIgnoreCase(strRowFileName)) continue;
                arrDeletedRow[iDeletedRowIndex++] = iarrSelectedRows[iSelectedRowIndex];
                continue block0;
            }
        }
        if (iDeletedRowIndex != arrDeletedRow.length) {
            int[] iarrTempArray = new int[iDeletedRowIndex];
            System.arraycopy(arrDeletedRow, 0, iarrTempArray, 0, iDeletedRowIndex);
            return iarrTempArray;
        }
        return arrDeletedRow;
    }

    private FileListError[] getFileListErrorInfo(int[] iarrSelectedRows, AsnDCDeleteFileListResp asnDCDeleteFileListResp) {
        FileListError[] fileListError = new FileListError[iarrSelectedRows.length];
        int iLength = asnDCDeleteFileListResp.oDeleteFileList.size();
        int iCount = 0;
        for (int j = 0; j < iLength; ++j) {
            fileListError[iCount++] = DeviceInfoManagerImplHelper.getDeleteFileListResult((AsnDCDeleteFileInfo)asnDCDeleteFileListResp.oDeleteFileList.elementAt(j));
        }
        return fileListError;
    }

    private void displayResults(FileListError[] oFileListError) {
        int iFailed = 0;
        int iSuccess = 0;
        int iSize = 0;
        String strDlgTitle = DCFrameWorkUtil.getLocalizedString("OPERATE_RESULT");
        String[] strColumns = new String[]{DCFrameWorkUtil.getLocalizedString("BACKUP_INFO_TABLE_FILE_NAME"), DCFrameWorkUtil.getLocalizedString("OPERATION_RESULT")};
        TaskOperationResultDialog oDlg = new TaskOperationResultDialog(strDlgTitle, 0, true, strColumns);
        if (null != oFileListError && oFileListError.length > 0) {
            iSize = oFileListError.length;
            for (int i = 0; i < iSize; ++i) {
                Vector<Object> oRowData = new Vector<Object>(0);
                oRowData.add(oFileListError[i].getFilePath());
                oRowData.add(ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(oFileListError[i].getErrorNo())));
                if (0 != oFileListError[i].getErrorNo()) {
                    ++iFailed;
                } else {
                    ++iSuccess;
                }
                oDlg.addRowInModel(oRowData);
            }
            String strMessage = "";
            strMessage = iSize == iSuccess ? DCFrameWorkUtil.getLocalizedString("FILE_DELETE_SUCCESS_RESULT") : (iSize == iFailed ? DCFrameWorkUtil.getLocalizedString("FILE_DELETE_FAILED_RESULT") : DCFrameWorkUtil.getLocalizedString("FILE_DELETE_SOME_FAIL_RESULT"));
            oDlg.setMessage(strMessage);
            oDlg.setVisible(true);
        }
    }

    private AsnBackUpFileList getSelectedBackupFileList(int[] iarrSelectedRows) {
        AsnBackUpFileList oAsnBackUpFileList = new AsnBackUpFileList();
        AsnDCBackUpFileInfo oAsnDCBackUpFileInfo = null;
        for (int iIndex = 0; iIndex < iarrSelectedRows.length; ++iIndex) {
            oAsnDCBackUpFileInfo = new AsnDCBackUpFileInfo();
            String strFileName = (String)this.m_oBackFileInfoTreeTable.getValueAt(iarrSelectedRows[iIndex], 1);
            DCDebugTracer.trace("getSelectedBackupFileList#" + strFileName);
            oAsnDCBackUpFileInfo.strFileName = strFileName.getBytes();
            oAsnBackUpFileList.add((Object)oAsnDCBackUpFileInfo);
        }
        return oAsnBackUpFileList;
    }
}

