/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.asndatacenter.AsnDCFile;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.FileOperationUtils;
import com.huawei.dc.common.util.LocalDiskDriveDetails;
import com.huawei.dc.compare.CompareFileDialog;
import com.huawei.dc.devicemanagement.deviceoperation.controller.DeviceOperationProgressController;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.BackupFilesProgressDlg;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.BackupInfoPanel;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.IBackupFileOperation;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.IProgressbarNotification;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceTablePanel;
import com.huawei.dc.devicemanagement.event.DeviceInfoEvent;
import com.huawei.dc.devicemanagement.event.IDeviceInfoListener;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.deviceoperation.util.OperationStatus;
import com.huawei.dc.framework.ClientFileOperations;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.HashMap;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class CompareNEStdAloneFile
implements IDeviceInfoListener,
IProgressbarNotification,
IDCObjectDeallocator {
    private DCSortableTreeTable m_oBackupFileInfoTreeTable;
    private int m_iOpRequestId = -1;
    private boolean bBackupOpSuccess = false;
    private String m_strTempDirectory = null;
    private byte[] m_oSyncObj = new byte[0];
    private CompareToNEStdAloneThread oCompareToNEStdAloneThread = null;
    private BackupFilesProgressDlg m_oprogressDlg = null;
    private volatile boolean m_bThreadStop = false;
    private ProgressBar m_oProgressbar;
    private int m_iDeviceID;
    private static final int BACKUP_FILE_TABLE_FILEPATH = 1;
    private static final int BACKUP_FILES_TABLE_FILESIZE = 4;
    private static final int BACKUP_FILES_TABLE_CONTENTTYPE = 2;
    private boolean m_bCancelSelected = false;
    private String m_strBckFilePathOfNE = null;
    private HashMap m_ReqidCancelSelectedMap = new HashMap(4);
    String strBackupFilePath = null;
    private static CompareNEStdAloneFile m_oCompareStdAloneNEFile = null;
    private BackupInfoPanel m_oBackupInfoPanel;
    private IBackupFileOperation m_oBackupFileOperation = null;
    private static final String COMPARE_TO_MENU_ID = "CompareTo";
    private static final int BACKUP_OPERATION = 3;
    private int iContentTypeValue;
    private int m_iRowSelected = -1;
    private final String m_strSystemTempPath = DCConstants.CLIENT_TEMP_DIRECTORY;
    private SystemManager m_sysMgr;
    private final long firstOpenClientTime = System.nanoTime();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.firstOpenClientTime ^ this.firstOpenClientTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompareNEStdAloneFile other = (CompareNEStdAloneFile)obj;
        return this.firstOpenClientTime == other.firstOpenClientTime;
    }

    private CompareNEStdAloneFile() {
        try {
            this.m_sysMgr = new SystemManager();
            this.jInit();
        }
        catch (Exception e) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("INITIALISE_FAILED"), ResourceManager.getInstance().getResString("ERROR"), 0);
        }
    }

    public void setTableObject(BackupInfoPanel oBackupInfoPanel, int iDevId) {
        this.m_iDeviceID = iDevId;
        this.m_oBackupFileInfoTreeTable = oBackupInfoPanel.getBackupInfoTable();
        this.m_oBackupInfoPanel = oBackupInfoPanel;
    }

    public static synchronized CompareNEStdAloneFile getInstance() {
        if (null == m_oCompareStdAloneNEFile) {
            m_oCompareStdAloneNEFile = new CompareNEStdAloneFile();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oCompareStdAloneNEFile);
        }
        return m_oCompareStdAloneNEFile;
    }

    public boolean checkIfRequestExists(int iRequestId) {
        boolean bIsExists = false;
        if (this.m_iOpRequestId == iRequestId) {
            bIsExists = true;
        }
        return bIsExists;
    }

    private void jInit() {
        this.m_bThreadStop = false;
        this.m_bCancelSelected = false;
        this.strBackupFilePath = DCConstants.CLIENT_TEMP_DIRECTORY;
        this.m_strTempDirectory = this.strBackupFilePath + "/temp";
    }

    public void resetReqIdOnCancel() {
        this.m_bCancelSelected = true;
        this.m_ReqidCancelSelectedMap.put(this.m_iOpRequestId, this.m_bCancelSelected);
        this.m_iOpRequestId = -1;
    }

    public void setThreadStop() {
        this.m_bThreadStop = true;
    }

    @Override
    public void operationCancelled() {
        this.m_bCancelSelected = true;
        this.m_bThreadStop = true;
        this.m_ReqidCancelSelectedMap.put(this.m_iOpRequestId, this.m_bCancelSelected);
    }

    private int generateReqId() {
        Calendar oCal = Calendar.getInstance();
        StringBuffer strReqId = new StringBuffer(100);
        strReqId.append(oCal.get(10));
        strReqId.append(oCal.get(12));
        strReqId.append(oCal.get(13));
        return Integer.parseInt(strReqId.toString());
    }

    public void compareToNEStdAloneFile() {
        this.m_iOpRequestId = this.generateReqId();
        this.bBackupOpSuccess = false;
        ContentType oContentType = null;
        DCSortableTreeTable oBackupFilesTable = this.m_oBackupFileInfoTreeTable;
        this.m_bCancelSelected = false;
        this.m_bThreadStop = false;
        this.m_iRowSelected = oBackupFilesTable.getSelectedRow();
        this.m_ReqidCancelSelectedMap.put(this.m_iOpRequestId, this.m_bCancelSelected);
        Object oContentTypeData = oBackupFilesTable.getValueAt(this.m_iRowSelected, 2);
        if (oContentTypeData instanceof ContentType) {
            oContentType = (ContentType)oContentTypeData;
        }
        int iFileTypeSelected = Integer.parseInt(this.m_oBackupInfoPanel.getFileType(this.m_iRowSelected));
        if (oContentType == null) {
            AsnDCFile oAsnDCFile = this.m_oBackupInfoPanel.getAsnDCFile();
            oContentType = new ContentType(oAsnDCFile.iContentType.intValue(), "zip File Manually Made");
        }
        Object infoTableObject = this.m_oBackupFileInfoTreeTable.getValueAt(this.m_iRowSelected, 1);
        String strSelectedFilePath = infoTableObject.toString();
        boolean bIsZipFile = strSelectedFilePath.endsWith("zip");
        if (iFileTypeSelected != 0 && !bIsZipFile) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("BACKUP_FILE_VIEW_COMPARE_ERROR"), ResourceManager.getInstance().getResString("INFORMATION"), 1);
            return;
        }
        File oFilePath = new File(strSelectedFilePath);
        if (!oFilePath.exists()) {
            this.m_oBackupFileInfoTreeTable.updateUI();
            DCDebugTracer.trace("dc dev backup file not found CompareNEStdAloneFile.compareToNEStdAloneFile()" + strSelectedFilePath);
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("BACKUP_FILE_ALREADY_DELETED"), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        this.iContentTypeValue = oContentType.getContentTypeCode();
        String Property = System.getProperty("os.name");
        if (null != Property && Property.startsWith("Win")) {
            LocalDiskDriveDetails oDiskDriveDetails = LocalDiskDriveDetails.getInstance();
            long lFreeMemoryAvail = oDiskDriveDetails.getFreeMemoryAvail(this.strBackupFilePath);
            Object objectInstance = this.m_oBackupFileInfoTreeTable.getValueAt(this.m_iRowSelected, 4);
            String strFileSize = objectInstance.toString();
            long lFileSize = -1L;
            try {
                lFileSize = NumberFormat.getIntegerInstance().parse(strFileSize).longValue();
            }
            catch (ParseException e) {
                DCDebugTracer.trace("Exception occured while parsing file size string");
                return;
            }
            if (lFreeMemoryAvail < lFileSize) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("BACKUP_FILES_INSUFFICIENT_MEMORY"), ResourceManager.getInstance().getResString("ERROR"), 0);
                return;
            }
        }
        ClientFileOperations oClientFileOperations = new ClientFileOperations();
        DeviceOperationProgressController.getInstance().addDeviceNotificationListener(this);
        int iErrorCode = oClientFileOperations.getNEFileForStdAloneCmp(this.m_iDeviceID, this.iContentTypeValue, this.m_iOpRequestId);
        if (0 != iErrorCode) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorCode, ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        this.compareToNEStdAloneOperation();
        this.openingProgressDlg();
    }

    public void compareToNEStdAloneOperation() {
        try {
            if (!this.m_bCancelSelected) {
                this.oCompareToNEStdAloneThread = new CompareToNEStdAloneThread();
                this.oCompareToNEStdAloneThread.start();
            } else if (this.bBackupOpSuccess) {
                int iRowSelected = this.m_oBackupFileInfoTreeTable.getSelectedRow();
                String strSelectedFilePath = this.m_oBackupFileInfoTreeTable.getValueAt(iRowSelected, 1).toString();
                String oCompareNEFilePath = strSelectedFilePath.substring(0, strSelectedFilePath.lastIndexOf(47));
                File oCompareTempFile = new File(oCompareNEFilePath);
                String oCompareNEDirPath = oCompareTempFile.getParent();
                File otempFile = new File(oCompareNEDirPath);
                String[] fileList = otempFile.list();
                String oCompareToNEFilePath = oCompareNEDirPath + File.separator + fileList[fileList.length - 1];
                File m_oCompareNEStdAloneFile = new File(oCompareToNEFilePath);
                File[] compareFiles = m_oCompareNEStdAloneFile.listFiles();
                String strCompareToFilePath = compareFiles[compareFiles.length - 1].toString();
                strCompareToFilePath = strCompareToFilePath.replace('\\', '/');
                this.deleteDirectory(new File(strCompareToFilePath));
                this.deleteDirectory(new File(strCompareToFilePath).getParentFile());
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyBackupProgress() {
        byte[] byArray = this.m_oSyncObj;
        synchronized (this.m_oSyncObj) {
            this.m_oSyncObj.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            DeviceOperationProgressController.getInstance().removeDeviceNotificationListener(this);
            return;
        }
    }

    @Override
    public void setToNULL() {
        this.m_bCancelSelected = true;
        if (null != this.m_oProgressbar && null != this.m_oprogressDlg) {
            this.m_oprogressDlg.setVisible(false);
            this.m_oprogressDlg.closeDialog();
            this.m_oprogressDlg = null;
            this.m_oProgressbar = null;
        }
    }

    public void openingProgressDlg() {
        this.m_oprogressDlg = new BackupFilesProgressDlg(this);
        this.m_oprogressDlg.setName("DeviceView_CompareNEStdAloneFile_m_oprogressDlg");
        this.m_oprogressDlg.setTitle(ResourceManager.getInstance().getResString("BACKUP_FILE_PROGRESSDLG_TITLE"));
        this.m_oprogressDlg.setInfomation(ResourceManager.getInstance().getResString("BACKUP_FILE_PROGRESSDLG_TITLE"));
        this.m_oProgressbar = new ProgressBar(this.m_oprogressDlg.getProgressBar());
        this.m_oProgressbar.start();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CompareNEStdAloneFile.this.m_oprogressDlg.setVisible(true);
            }
        });
    }

    private void deleteFileFromBackupInfoTable(String strPath) {
        int iRowCount = this.m_oBackupFileInfoTreeTable.getRowCount();
        int[] iDeletedRows = new int[iRowCount];
        int iDeletedRowCount = 0;
        String strDeletePath = strPath.replaceAll("\\\\", "/");
        for (int i = 0; i < iRowCount; ++i) {
            String strFilePath = (String)this.m_oBackupFileInfoTreeTable.getValueAt(i, 1);
            if (0 != strFilePath.indexOf(strDeletePath)) continue;
            iDeletedRows[iDeletedRowCount++] = i;
        }
        if (0 < iDeletedRowCount) {
            int[] iTmpDeletedRows = new int[iDeletedRowCount];
            System.arraycopy(iDeletedRows, 0, iTmpDeletedRows, 0, iDeletedRowCount);
            this.m_oBackupFileInfoTreeTable.deleteTableRow(iTmpDeletedRows);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteDirectory(File path) {
        if (DCFrameWorkUtil.getIsSingleClient()) {
            boolean isDeleted = true;
            String strRootDir = this.m_sysMgr.getSystemRootDirectory();
            String strBackupPath = strRootDir + File.separatorChar + "backup";
            isDeleted = this.deleteFilesForStdAlone(path, strBackupPath);
            return isDeleted;
        }
        if (null != path && path.exists() && this.bBackupOpSuccess && path.getAbsolutePath().startsWith(this.m_strSystemTempPath)) {
            File isDeleted = path;
            synchronized (isDeleted) {
                block10: {
                    try {
                        File[] files = path.listFiles();
                        for (int i = 0; i < files.length; ++i) {
                            if (files[i].isDirectory()) {
                                this.deleteDirectory(files[i]);
                                continue;
                            }
                            if (files[i].delete()) continue;
                            DCDebugTracer.trace("DC::" + this.getClass() + ".deleteDirectory(fail to delete " + files[i] + ")");
                        }
                    }
                    catch (Exception e) {
                        if (path.delete()) break block10;
                        DCDebugTracer.trace("DC::" + this.getClass() + ".deleteDirectory(fail to delete " + path + ")");
                    }
                }
            }
            DeviceTablePanel oDeviceTablePanel = DCFrameWorkUtil.getDeviceTablePanel();
            if (null != oDeviceTablePanel) {
                oDeviceTablePanel.notifyEvent();
            }
            return path.delete();
        }
        return false;
    }

    private boolean deleteFilesForStdAlone(File oPath, String strBackupPath) {
        if (null != oPath) {
            DCDebugTracer.trace("dc delete file " + oPath.toString());
        }
        if (null != oPath && oPath.exists() && this.bBackupOpSuccess && !oPath.getAbsolutePath().equals(strBackupPath)) {
            File[] files = oPath.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.deleteDirectory(files[i]);
                    continue;
                }
                if (files[i].delete()) continue;
                DCDebugTracer.trace("DC::" + this.getClass() + ".deleteFilesForStdAlone(fail to delete " + files[i] + ")");
            }
            DeviceTablePanel oDeviceTablePanel = DCFrameWorkUtil.getDeviceTablePanel();
            if (null != oDeviceTablePanel) {
                oDeviceTablePanel.notifyEvent();
                this.deleteFileFromBackupInfoTable(oPath.getPath());
            } else {
                this.deleteFileFromBackupInfoTable(oPath.getPath());
            }
            boolean bSuc = oPath.delete();
            if (!bSuc) {
                DCDebugTracer.trace("dc failed to delete file " + oPath.toString());
            }
            return bSuc;
        }
        return false;
    }

    public String getDestinationPath() {
        if (!new File(this.m_strTempDirectory).mkdirs()) {
            DCDebugTracer.trace("DC::" + this.getClass() + ".getDestinationPath(fail to make dir< " + this.m_strTempDirectory + ">)");
        }
        return this.m_strTempDirectory;
    }

    @Override
    public void onDeviceNotification(DeviceInfoEvent oEvent) {
        if (null == oEvent || 2 != oEvent.getEventType()) {
            return;
        }
        Object oEventSrc = oEvent.getSource();
        if (!(oEventSrc instanceof OperationStatus) || 3 != ((OperationStatus)oEventSrc).getOperationType() || this.m_iDeviceID != oEvent.getDeviceID()) {
            return;
        }
        if (!((OperationStatus)oEventSrc).getIsProgress()) {
            if (0 != ((OperationStatus)oEventSrc).getIFailureReason()) {
                if (this.m_oprogressDlg.getProgressBar().getValue() < 90) {
                    this.m_oprogressDlg.getProgressBar().setValue(88);
                }
                this.m_oprogressDlg.setVisible(false);
                this.bBackupOpSuccess = false;
                this.m_bCancelSelected = true;
                this.m_bThreadStop = true;
                this.m_ReqidCancelSelectedMap.put(this.m_iOpRequestId, this.m_bCancelSelected);
                this.m_oprogressDlg.dispose();
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ((OperationStatus)oEventSrc).getFailureReason(), ResourceManager.getInstance().getResString("ERROR"), 0);
                this.notifyBackupProgress();
            } else {
                this.bBackupOpSuccess = true;
                if (this.m_oprogressDlg.getProgressBar().getValue() < 50) {
                    this.m_oprogressDlg.getProgressBar().setValue(48);
                }
                this.notifyBackupProgress();
            }
        }
    }

    private void registerForHelp(CompareFileDialog oDlg) {
        DCHelpManager.getInstance().enableF1HelpKey(oDlg.getContentPane(), "HELP_TOPIC_COMPARE_TO_NE");
    }

    class CompareToNEStdAloneThread
    extends Thread {
        private String strSelectedFilePath;
        String strCompareFilePath;
        String strCompareToFilePath;
        private boolean bisCompareBackupFileZip = false;
        private boolean bisNEBackupFileZip = false;

        public CompareToNEStdAloneThread() {
            this.init();
        }

        public void init() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            byte[] byArray = CompareNEStdAloneFile.this.m_oSyncObj;
            synchronized (byArray) {
                block42: {
                    try {
                        CompareNEStdAloneFile.this.m_oSyncObj.wait(DCConstants.DEFAULT_WAIT_TIME);
                        if (CompareNEStdAloneFile.this.bBackupOpSuccess) {
                            String oCompareNEFilePath = "";
                            this.strSelectedFilePath = CompareNEStdAloneFile.this.m_oBackupFileInfoTreeTable.getValueAt(CompareNEStdAloneFile.this.m_iRowSelected, 1).toString();
                            if (null == this.strSelectedFilePath) {
                                DCDebugTracer.trace("CompareToNEStdAloneThread::run:strSelectedFilePath == null");
                                return;
                            }
                            this.strCompareFilePath = this.strSelectedFilePath;
                            DCDebugTracer.trace("strSelectedFilePath =" + this.strSelectedFilePath);
                            oCompareNEFilePath = this.strSelectedFilePath.substring(0, this.strSelectedFilePath.lastIndexOf(47));
                            DCDebugTracer.trace("oCompareNEFilePath=" + oCompareNEFilePath);
                            File oCompareTempFile = new File(oCompareNEFilePath);
                            String oCompareNEDirPath = oCompareTempFile.getParent();
                            File otempFile = new File(oCompareNEDirPath);
                            String[] fileList = otempFile.list();
                            String oCompareToNEFilePath = oCompareNEDirPath + File.separator + fileList[fileList.length - 1];
                            File m_oCompareNEStdAloneFile = new File(oCompareToNEFilePath);
                            File[] compareFiles = m_oCompareNEStdAloneFile.listFiles();
                            if (null == compareFiles) {
                                DCDebugTracer.trace("oCompareToNEFilePath : " + oCompareToNEFilePath);
                            } else {
                                this.strCompareToFilePath = compareFiles[compareFiles.length - 1].toString();
                                this.strCompareToFilePath = this.strCompareToFilePath.replace('\\', '/');
                            }
                            DCDebugTracer.trace("strCompareToFilePath=" + this.strCompareToFilePath);
                            if (CompareNEStdAloneFile.this.m_bCancelSelected) {
                                File delDir = new File(this.strCompareToFilePath);
                                CompareNEStdAloneFile.this.deleteDirectory(new File(delDir.getParent()));
                                return;
                            }
                            File oFilePath = new File(this.strCompareFilePath);
                            if (!oFilePath.exists()) {
                                this.strCompareToFilePath = "";
                                CompareNEStdAloneFile.this.m_bThreadStop = true;
                                CompareNEStdAloneFile.this.m_oprogressDlg.setVisible(false);
                                CompareNEStdAloneFile.this.m_oprogressDlg.dispose();
                                CompareNEStdAloneFile.this.m_oBackupFileInfoTreeTable.updateUI();
                                DCDebugTracer.trace("backup file not found COmpareNEStandaloneFile.run() " + this.strCompareFilePath);
                                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("BACKUP_FILES_ALREADY_DELETED"), ResourceManager.getInstance().getResString("ERROR"), 0);
                                return;
                            }
                            if (!CompareNEStdAloneFile.this.m_bCancelSelected) {
                                int reqID = CompareNEStdAloneFile.this.m_iOpRequestId;
                                CompareFileDialog dialog = new CompareFileDialog((Frame)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("COMPARE_DLG_TITLE"), true);
                                dialog.setLeftFileInfo(ResourceManager.getInstance().getResString("COMPARE_BACKUP_FILE"));
                                dialog.setRightFileInfo(ResourceManager.getInstance().getResString("COMPARE_NE_FILE"));
                                CompareNEStdAloneFile.this.registerForHelp(dialog);
                                if (null != this.strCompareFilePath && null != this.strCompareToFilePath) {
                                    if (this.strCompareFilePath.endsWith("zip")) {
                                        this.handleZipfile();
                                    }
                                    if (this.strCompareToFilePath.endsWith("zip")) {
                                        this.handleZipfile1();
                                    }
                                }
                                if (0 == dialog.setFilePathNE(new File(this.strCompareFilePath).getAbsolutePath(), new File(this.strCompareToFilePath).getAbsolutePath())) {
                                    this.processfile(reqID, dialog);
                                    dialog = null;
                                    break block42;
                                }
                                this.deleteFile();
                                this.strCompareToFilePath = "";
                                CompareNEStdAloneFile.this.m_bThreadStop = true;
                                CompareNEStdAloneFile.this.m_oprogressDlg.setVisible(false);
                                CompareNEStdAloneFile.this.m_oprogressDlg.dispose();
                                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("COMPARE_DLG_INVALID_PATH"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
                                return;
                            }
                            File delDir = new File(this.strCompareToFilePath);
                            CompareNEStdAloneFile.this.deleteDirectory(new File(delDir.getParent()));
                            return;
                        }
                        this.strCompareToFilePath = "";
                        CompareNEStdAloneFile.this.m_bThreadStop = true;
                        return;
                    }
                    catch (InterruptedException e) {
                        CompareNEStdAloneFile.this.m_bThreadStop = true;
                        CompareNEStdAloneFile.this.m_oprogressDlg.dispose();
                        DCDebugTracer.trace(e);
                        return;
                    }
                    finally {
                        File delFile = new File(this.strCompareToFilePath);
                        if (CompareNEStdAloneFile.this.bBackupOpSuccess && delFile.exists()) {
                            try {
                                CompareNEStdAloneFile.this.deleteDirectory(new File(delFile.getParent()));
                            }
                            catch (Exception e) {
                                DCDebugTracer.trace(e);
                            }
                        }
                    }
                }
                return;
            }
        }

        private void deleteFile() {
            if (this.bisCompareBackupFileZip && !new File(this.strCompareFilePath).delete()) {
                DCDebugTracer.trace("DC::" + this.getClass() + ".deleteFile(fail to delete " + this.strCompareFilePath + ")");
            }
            if (this.bisNEBackupFileZip && !new File(this.strCompareToFilePath).delete()) {
                DCDebugTracer.trace("DC::" + this.getClass() + ".deleteFile(fail to delete " + this.strCompareToFilePath + ")");
            }
        }

        private void processfile(int reqID, CompareFileDialog dialog) {
            File oFile;
            if (this.bisCompareBackupFileZip && !(oFile = new File(this.strCompareFilePath)).delete()) {
                DCDebugTracer.trace("DC::" + this.getClass() + ".processfile(fail to delete " + oFile + ")");
            }
            if (reqID == CompareNEStdAloneFile.this.m_iOpRequestId) {
                CompareNEStdAloneFile.this.m_bThreadStop = true;
                CompareNEStdAloneFile.this.m_oprogressDlg.dispose();
                CompareNEStdAloneFile.this.m_oprogressDlg = null;
                dialog.setVisible(true);
            }
            int iFileNameIndex = 0;
            if (this.bisNEBackupFileZip) {
                for (int i = 0; i < 2; ++i) {
                    iFileNameIndex = this.strCompareToFilePath.lastIndexOf("/");
                    if (-1 == iFileNameIndex) continue;
                    this.strCompareToFilePath = this.strCompareToFilePath.substring(0, iFileNameIndex);
                }
            }
            if (-1 != iFileNameIndex) {
                File delDir = new File(this.strCompareToFilePath);
                CompareNEStdAloneFile.this.deleteDirectory(new File(delDir.getParent()));
                this.strCompareToFilePath = "";
            }
        }

        private void handleZipfile1() {
            this.bisNEBackupFileZip = true;
            if (new File(this.strCompareToFilePath).exists()) {
                File oFile = FileOperationUtils.unZipFile(this.strCompareToFilePath);
                this.strCompareToFilePath = null != oFile ? oFile.toString() : null;
            }
        }

        private void handleZipfile() {
            this.bisCompareBackupFileZip = true;
            if (new File(this.strCompareFilePath).exists()) {
                File oFile = FileOperationUtils.unZipFile(this.strCompareFilePath);
                this.strCompareFilePath = null != oFile ? oFile.toString() : null;
            }
        }
    }

    public class ProgressBar
    extends Thread {
        private static final int TIMEOUT = 80;
        private static final int MILLISECONDS = 5000;
        private JProgressBar oProgressBar;
        private static final int MAXVALUE = 100;
        private static final int DELAY = 4000;

        public ProgressBar(JProgressBar bar) {
            this.oProgressBar = bar;
        }

        @Override
        public void run() {
            int minimum = this.oProgressBar.getMinimum();
            int maximum = this.oProgressBar.getMaximum();
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    if (CompareNEStdAloneFile.this.m_bThreadStop) {
                        return;
                    }
                    int value = ProgressBar.this.oProgressBar.getValue();
                    ProgressBar.this.oProgressBar.setValue(value + 2);
                }
            };
            try {
                for (int i = minimum; i < maximum; ++i) {
                    SwingUtilities.invokeAndWait(runner);
                    if (!CompareNEStdAloneFile.this.m_bThreadStop) {
                        Thread.sleep(4000L);
                        if (maximum != this.oProgressBar.getValue() || CompareNEStdAloneFile.this.m_bThreadStop) continue;
                        CompareNEStdAloneFile.this.m_oprogressDlg.setVisible(false);
                        CompareNEStdAloneFile.this.m_oprogressDlg.dispose();
                        CompareNEStdAloneFile.this.m_iOpRequestId = -1;
                        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("OPERATION_TIME_OUT"), ResourceManager.getInstance().getResString("ERROR_MESSAGE_TITLE"), 0);
                        CompareNEStdAloneFile.this.notifyBackupProgress();
                        break;
                    }
                    return;
                }
            }
            catch (InterruptedException ignoredException) {
                return;
            }
            catch (InvocationTargetException ignoredException) {
                return;
            }
        }
    }
}

