/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.FileOperationUtils;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.compare.CompareFileDialog;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.BackupFilePopupMenuMgr;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.BackupFilesProgressDlg;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.BackupInfoPanel;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.IBackupFileOperation;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.IProgressbarNotification;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.deviceoperation.DevOpObjectStore;
import com.huawei.dc.framework.ClientFileOperations;
import gnu.trove.TIntObjectHashMap;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Calendar;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class CompareNEFile
implements IProgressbarNotification,
IDCObjectDeallocator {
    private DCSortableTreeTable m_oBackupFileInfoTreeTable;
    private int m_iOpRequestId = -1;
    private String m_strTempDirectory = null;
    public static final byte[] m_oSyncObj = new byte[0];
    private CompareToNEFileTransferFileThread oCompareToNEFileTransferFileThread = null;
    private CompareToNEOperation oCompareToNEOperation = null;
    private BackupFilesProgressDlg m_oprogressDlg = null;
    private volatile boolean m_bThreadStop = false;
    private ProgressBar m_oProgressbar;
    private int m_iErrorcode = -1;
    private int m_iDeviceID;
    private static final int BACKUP_FILE_TABLE_FILEPATH = 1;
    private static final int BACKUP_FILES_TABLE_CONTENTTYPE = 2;
    private boolean m_bCancelSelected = false;
    private String m_strBckFilePathOfNE = null;
    private int m_iCompToNeErrorCoder = -1;
    private TIntObjectHashMap m_ReqidCancelSelectedMap = new TIntObjectHashMap(4);
    private String strSourceFileDir = "";
    String strBackupFilePath = null;
    private static CompareNEFile m_oCompareNEFile = null;
    private BackupInfoPanel m_oBackupInfoPanel;
    private BackupFilePopupMenuMgr oBackupFilePopupMenuMgr = null;
    private IBackupFileOperation m_oBackupFileOperation = null;
    private static final String COMPARE_TO_MENU_ID = "compareToNEFile";
    private final String m_strSystemTempPath = DCConstants.CLIENT_TEMP_DIRECTORY;
    private SecureRandom ran;

    private CompareNEFile() {
        try {
            this.ran = new SecureRandom();
            this.JInit();
        }
        catch (Exception e) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("INITIALISE_FAILED"), ResourceManager.getInstance().getResString("ERROR"), 0);
        }
    }

    private double getRandomNum() {
        return this.ran.nextDouble();
    }

    public void setTableObject(BackupInfoPanel oBackupInfoPanel, int iDevId) {
        this.m_iDeviceID = iDevId;
        this.m_oBackupFileInfoTreeTable = oBackupInfoPanel.getBackupInfoTable();
        this.m_oBackupInfoPanel = oBackupInfoPanel;
    }

    public static synchronized CompareNEFile getInstance() {
        if (null == m_oCompareNEFile) {
            m_oCompareNEFile = new CompareNEFile();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oCompareNEFile);
        }
        return m_oCompareNEFile;
    }

    public boolean checkIfRequestExists(int iRequestId) {
        boolean bIsExists = false;
        if (this.m_iOpRequestId == iRequestId) {
            bIsExists = true;
        }
        return bIsExists;
    }

    private void JInit() {
        this.m_iOpRequestId = this.generateReqId();
        this.m_bThreadStop = false;
        this.m_bCancelSelected = false;
        this.strBackupFilePath = DCConstants.CLIENT_TEMP_DIRECTORY;
        this.m_strTempDirectory = this.strBackupFilePath + "/temp";
    }

    public void resetReqIdOnCancel() {
        this.m_bCancelSelected = true;
        this.m_ReqidCancelSelectedMap.put(Integer.valueOf(this.m_iOpRequestId).intValue(), (Object)this.m_bCancelSelected);
        this.m_iOpRequestId = -1;
    }

    public void setThreadStop() {
        this.m_bThreadStop = true;
    }

    @Override
    public void operationCancelled() {
        this.m_bCancelSelected = true;
        this.m_bThreadStop = true;
        this.m_ReqidCancelSelectedMap.put(Integer.valueOf(this.m_iOpRequestId).intValue(), (Object)this.m_bCancelSelected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyFileTransferProgress(int iErrorCode) {
        this.m_iErrorcode = iErrorCode;
        byte[] byArray = m_oSyncObj;
        synchronized (m_oSyncObj) {
            m_oSyncObj.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private int generateReqId() {
        Calendar oCal = Calendar.getInstance();
        StringBuffer strReqId = new StringBuffer(100);
        strReqId.append(oCal.get(10));
        strReqId.append(oCal.get(12));
        strReqId.append(oCal.get(13));
        return Integer.parseInt(strReqId.toString());
    }

    public void compareToNEFile() {
        ClientFileOperations clientFileOperations;
        int iErrorCode;
        File oFilePath;
        ContentType oContentType = null;
        DCSortableTreeTable oBackupFilesTable = this.m_oBackupFileInfoTreeTable;
        this.m_bCancelSelected = false;
        this.m_bThreadStop = false;
        this.setoBackupFilePopupMenuMgr(BackupFilePopupMenuMgr.getInstance(this.m_oBackupFileOperation));
        int iRowSelected = oBackupFilesTable.getSelectedRow();
        this.m_ReqidCancelSelectedMap.put(Integer.valueOf(this.m_iOpRequestId).intValue(), (Object)this.m_bCancelSelected);
        Object oContentTypeData = oBackupFilesTable.getValueAt(iRowSelected, 2);
        if (oContentTypeData instanceof ContentType) {
            oContentType = (ContentType)oContentTypeData;
        }
        int iFileTypeSelected = Integer.parseInt(this.m_oBackupInfoPanel.getFileType(iRowSelected));
        if (oContentType == null) {
            oContentType = new ContentType(iFileTypeSelected, "zip File Manually Made");
        }
        Object infoTableObject = this.m_oBackupFileInfoTreeTable.getValueAt(iRowSelected, 1);
        String strSelectedFilePath = infoTableObject.toString();
        boolean bIsZipFile = strSelectedFilePath.endsWith("zip");
        if (iFileTypeSelected != 0 && !bIsZipFile) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("BACKUP_FILE_VIEW_COMPARE_ERROR"), ResourceManager.getInstance().getResString("INFORMATION"), 1);
            return;
        }
        boolean bClientServerOnSameMachine = this.isServerOnSameMachine();
        String strContentType = this.m_oBackupFileInfoTreeTable.getValueAt(iRowSelected, 2).toString();
        if (strContentType.equals("")) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("BACKUP_FILES_CONTENTTYPE_NOT_AVAILABLE"), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        if (bClientServerOnSameMachine && !(oFilePath = new File(strSelectedFilePath)).exists()) {
            this.m_oBackupFileInfoTreeTable.updateUI();
            DCDebugTracer.trace("backup file not found CompareNEFile.compareToNEFile() " + strSelectedFilePath);
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("BACKUP_FILE_ALREADY_DELETED"), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        int iContentTypeValue = oContentType.getContentTypeCode();
        try {
            SystemManager oSystemInfo = new SystemManager();
            this.strSourceFileDir = oSystemInfo.getSystemServerFTPRoot();
            this.strSourceFileDir = strSelectedFilePath.substring(this.strSourceFileDir.length());
            if (this.strSourceFileDir.startsWith("/")) {
                this.strSourceFileDir = this.strSourceFileDir.substring(1);
            }
        }
        catch (Exception e) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("BACKUP_FILES_UNABLE_TO_CREATE_TEMP_FOLDER"), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        String strClientPath = DCConstants.CLIENT_TEMP_DIRECTORY + "/NEFile/" + this.getRandomNum();
        this.m_strTempDirectory = this.strBackupFilePath + "/temp/server" + this.getRandomNum();
        strClientPath = FileUtil.getUnifyPath(strClientPath);
        this.m_strTempDirectory = FileUtil.getUnifyPath(this.m_strTempDirectory);
        if (!new File(this.m_strTempDirectory).mkdirs()) {
            DCDebugTracer.trace("DC::CompareNEFile.compareToNEFile(fail to make dir <" + this.m_strTempDirectory + ">)");
        }
        if (!new File(strClientPath).mkdirs()) {
            DCDebugTracer.trace("DC::CompareNEFile.compareToNEFile(fail to make dir <" + strClientPath + ">)");
        }
        this.m_strBckFilePathOfNE = strClientPath;
        DevOpObjectStore o_devOpObjectStore = DevOpObjectStore.getInstance();
        o_devOpObjectStore.putObjectInstance(this.m_iDeviceID, strClientPath);
        File oDeleteTempDirectory = new File(this.m_strTempDirectory);
        File oClientPathDirectory = new File(strClientPath);
        if (!bClientServerOnSameMachine) {
            this.deleteTempDirectory(oDeleteTempDirectory);
        }
        if (0 != (iErrorCode = (clientFileOperations = new ClientFileOperations()).getNEFileForCmp(this.m_iDeviceID, iContentTypeValue, this.m_iOpRequestId))) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorCode, ResourceManager.getInstance().getResString("ERROR"), 0);
            this.deleteTempDirectory(oDeleteTempDirectory.getParentFile());
            this.deleteTempDirectory(oClientPathDirectory.getParentFile());
            return;
        }
        this.openingProgressDlg();
        this.oCompareToNEOperation = new CompareToNEOperation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackupFilePathForNE(String strFilePath, int iErrorCode) {
        try {
            byte[] byArray = m_oSyncObj;
            synchronized (m_oSyncObj) {
                if (null != strFilePath) {
                    DCDebugTracer.trace("DataCenter::ComapreToNE::setBackupFilePathForNE::" + strFilePath);
                    this.m_strBckFilePathOfNE = strFilePath;
                }
                this.m_iCompToNeErrorCoder = iErrorCode;
                m_oSyncObj.notifyAll();
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
        {
            return;
        }
    }

    @Override
    public void setToNULL() {
        this.m_bCancelSelected = true;
        if (null != this.m_oProgressbar && null != this.m_oprogressDlg) {
            this.m_oprogressDlg.setVisible(false);
            this.m_oprogressDlg.closeDialog();
            this.m_oprogressDlg = null;
            this.m_oProgressbar = null;
        }
        try {
            if (null != this.oCompareToNEFileTransferFileThread && this.oCompareToNEFileTransferFileThread.isAlive()) {
                this.oCompareToNEFileTransferFileThread.interrupt();
                this.oCompareToNEFileTransferFileThread.stop();
                this.oCompareToNEFileTransferFileThread = null;
            }
            if (null != this.oCompareToNEOperation && this.oCompareToNEOperation.isAlive()) {
                this.oCompareToNEOperation.interrupt();
                this.oCompareToNEOperation.stop();
                this.oCompareToNEOperation = null;
            }
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
    }

    public void openingProgressDlg() {
        this.m_oprogressDlg = new BackupFilesProgressDlg(this);
        this.m_oprogressDlg.setName("DeviceView_CompareNEFile_m_oprogressDlg");
        this.m_oprogressDlg.setTitle(ResourceManager.getInstance().getResString("BACKUP_FILE_PROGRESSDLG_TITLE"));
        this.m_oprogressDlg.setInfomation(ResourceManager.getInstance().getResString("BACKUP_FILE_PROGRESSDLG_TITLE"));
        this.m_oProgressbar = new ProgressBar(this.m_oprogressDlg.getProgressBar());
        this.m_oProgressbar.setName("DeviceView_CompareNEFile_m_oProgressbar");
        this.m_oProgressbar.start();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CompareNEFile.this.m_oprogressDlg.setVisible(true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteTempDirectory(File path) {
        if (null != path && path.exists()) {
            String strTempPath;
            String strPath = path.getPath();
            if ((strPath = strPath.replace('\\', '/')).startsWith(strTempPath = this.m_strSystemTempPath.replace('\\', '/'))) {
                File file = path;
                synchronized (file) {
                    try {
                        File[] files = path.listFiles();
                        for (int i = 0; i < files.length; ++i) {
                            if (files[i].isDirectory()) {
                                this.deleteTempDirectory(files[i]);
                                continue;
                            }
                            if (files[i].delete()) continue;
                            DCDebugTracer.trace("DC::CompareNEFile.deleteTempDirectory(fail to delete " + files[i] + ")");
                        }
                    }
                    catch (Exception e) {
                        DCDebugTracer.trace("DataCenter::CompareToNE::deleteTempDirectory::" + path.getAbsolutePath());
                    }
                }
                return path.delete();
            }
        }
        return false;
    }

    public boolean isServerOnSameMachine() {
        return DCFrameWorkUtil.isServerOnSameMachine(ResourceManager.getInstance().getResString("BACKUP_FILES_UNABLE_TO_TRACE_SERVER"));
    }

    public String getDestinationPath() {
        if (!new File(this.m_strTempDirectory).mkdirs()) {
            DCDebugTracer.trace("DC::CompareNEFile.getDestinationPath(fail to make dir <" + this.m_strTempDirectory + ">)");
        }
        return this.m_strTempDirectory;
    }

    public String getSourcePath() {
        return this.strSourceFileDir;
    }

    private void registerForHelp(CompareFileDialog oDlg) {
        DCHelpManager.getInstance().enableF1HelpKey(oDlg.getContentPane(), "HELP_TOPIC_COMPARE_TO_NE");
    }

    public void setoBackupFilePopupMenuMgr(BackupFilePopupMenuMgr oBackupFilePopupMenuMgr) {
        this.oBackupFilePopupMenuMgr = oBackupFilePopupMenuMgr;
    }

    public BackupFilePopupMenuMgr getoBackupFilePopupMenuMgr() {
        return this.oBackupFilePopupMenuMgr;
    }

    class CompareToNEFileTransferFileThread
    extends Thread {
        private ClientFileOperations clientFileOperations;
        private String strtempDirectory;
        private String strSelectedFilePath;
        private String strServerFilePath;
        String strCompareFilePath;
        private String strRootDir = "";
        private boolean bisCompareBackupFileZip = false;
        private boolean bisNEBackupFileZip = false;

        public CompareToNEFileTransferFileThread() {
            try {
                SystemManager oSystemInfo = new SystemManager();
                this.strRootDir = oSystemInfo.getSystemServerFTPRoot();
            }
            catch (Exception e) {
                CompareNEFile.this.m_bThreadStop = true;
                CompareNEFile.this.m_oprogressDlg.dispose();
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("BACKUP_FILES_UNABLE_TO_CREATE_TEMP_FOLDER"), ResourceManager.getInstance().getResString("ERROR"), 0);
                return;
            }
            this.init();
            this.start();
        }

        public void init() {
            this.strtempDirectory = CompareNEFile.this.m_strTempDirectory;
            this.strtempDirectory = FileUtil.getUnifyPath(this.strtempDirectory);
            int iRowSelected = CompareNEFile.this.m_oBackupFileInfoTreeTable.getSelectedRow();
            this.strCompareFilePath = this.strSelectedFilePath = CompareNEFile.this.m_oBackupFileInfoTreeTable.getValueAt(iRowSelected, 1).toString();
            this.strCompareFilePath = FileUtil.getUnifyPath(this.strCompareFilePath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int handleServerOnDifferentMachine() {
            int iFileIndex = this.strRootDir.length();
            if (iFileIndex != -1) {
                this.strServerFilePath = this.strSelectedFilePath.substring(iFileIndex);
            }
            int iTitleIndex = this.strServerFilePath.lastIndexOf("/") + 1;
            String strServerFileName = null;
            if (iTitleIndex != -1) {
                strServerFileName = this.strServerFilePath.substring(iTitleIndex);
            }
            if (this.strServerFilePath.startsWith("/")) {
                this.strServerFilePath = this.strServerFilePath.substring(1);
            }
            this.strServerFilePath = FileUtil.getUnifyPath(this.strServerFilePath);
            this.clientFileOperations = new ClientFileOperations();
            this.clientFileOperations.getFileFromServer(this.strServerFilePath, this.strtempDirectory, CompareNEFile.this.m_iOpRequestId, 6);
            byte[] byArray = m_oSyncObj;
            synchronized (m_oSyncObj) {
                try {
                    m_oSyncObj.wait(DCConstants.DEFAULT_WAIT_TIME);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                CompareNEFile.this.m_bCancelSelected = (Boolean)CompareNEFile.this.m_ReqidCancelSelectedMap.get(Integer.valueOf(CompareNEFile.this.m_iOpRequestId).intValue());
                if (!CompareNEFile.this.m_bCancelSelected) {
                    if (0 != CompareNEFile.this.m_iErrorcode) {
                        CompareNEFile.this.m_bThreadStop = true;
                        CompareNEFile.this.m_oprogressDlg.dispose();
                        DCDebugTracer.trace("[FTP]  handleServerOnDifferentMachine : ");
                        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), BigInteger.valueOf(CompareNEFile.this.m_iErrorcode), ResourceManager.getInstance().getResString("BACKUP_FILES_SFTP_ERROR"), 0);
                        if (!CompareNEFile.this.isServerOnSameMachine()) {
                            File oDeleteTempDirectory = new File(CompareNEFile.this.m_strTempDirectory);
                            int intFileNameIndex = CompareNEFile.this.m_strBckFilePathOfNE.lastIndexOf("/");
                            if (-1 != intFileNameIndex) {
                                String strBackUpDir = CompareNEFile.this.m_strBckFilePathOfNE.substring(0, intFileNameIndex + 1);
                                oDeleteTempDirectory = new File(strBackUpDir);
                                CompareNEFile.this.deleteTempDirectory(oDeleteTempDirectory);
                            }
                        }
                        return CompareNEFile.this.m_iErrorcode;
                    }
                    this.strCompareFilePath = this.strtempDirectory + "/" + strServerFileName;
                }
                return CompareNEFile.this.m_iErrorcode;
            }
        }

        @Override
        public void run() {
            try {
                if (CompareNEFile.this.m_bCancelSelected) {
                    CompareNEFile.this.deleteTempDirectory(new File(CompareNEFile.this.m_strTempDirectory).getParentFile());
                    CompareNEFile.this.deleteTempDirectory(new File(CompareNEFile.this.m_strBckFilePathOfNE).getParentFile().getParentFile().getParentFile());
                    return;
                }
                if (!CompareNEFile.this.isServerOnSameMachine()) {
                    if (0 != this.handleServerOnDifferentMachine()) {
                        return;
                    }
                } else {
                    File oFilePath = new File(this.strCompareFilePath);
                    if (!oFilePath.exists()) {
                        CompareNEFile.this.m_strBckFilePathOfNE = "";
                        CompareNEFile.this.m_bThreadStop = true;
                        CompareNEFile.this.m_oprogressDlg.setVisible(false);
                        CompareNEFile.this.m_oprogressDlg.dispose();
                        CompareNEFile.this.m_oBackupFileInfoTreeTable.updateUI();
                        Thread.sleep(500L);
                        DCDebugTracer.trace("backup file not found CompareNEFile.run() " + this.strCompareFilePath);
                        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("BACKUP_FILES_ALREADY_DELETED"), ResourceManager.getInstance().getResString("ERROR"), 0);
                        return;
                    }
                }
                if (0 == CompareNEFile.this.m_iCompToNeErrorCoder) {
                    if (!CompareNEFile.this.m_bCancelSelected) {
                        File oFile;
                        int reqID = CompareNEFile.this.m_iOpRequestId;
                        CompareFileDialog dialog = new CompareFileDialog((Frame)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("COMPARE_DLG_TITLE"), true);
                        dialog.setLeftFileInfo(ResourceManager.getInstance().getResString("COMPARE_BACKUP_FILE"));
                        dialog.setRightFileInfo(ResourceManager.getInstance().getResString("COMPARE_NE_FILE"));
                        CompareNEFile.this.registerForHelp(dialog);
                        if (null != this.strCompareFilePath && null != CompareNEFile.this.m_strBckFilePathOfNE) {
                            DCDebugTracer.trace("DC::strCompareFilePath 1" + this.strCompareFilePath);
                            DCDebugTracer.trace("DC::m_strBckFilePathOfNE 1" + CompareNEFile.this.m_strBckFilePathOfNE);
                            if (this.strCompareFilePath.endsWith("zip")) {
                                this.bisCompareBackupFileZip = true;
                                if (new File(this.strCompareFilePath).exists()) {
                                    oFile = FileOperationUtils.unZipFile(this.strCompareFilePath);
                                    String string = this.strCompareFilePath = null != oFile ? oFile.toString() : null;
                                }
                            }
                            if (CompareNEFile.this.m_strBckFilePathOfNE.endsWith("zip")) {
                                this.bisNEBackupFileZip = true;
                                if (new File(CompareNEFile.this.m_strBckFilePathOfNE).exists()) {
                                    oFile = FileOperationUtils.unZipFile(CompareNEFile.this.m_strBckFilePathOfNE);
                                    CompareNEFile.this.m_strBckFilePathOfNE = null != oFile ? oFile.toString() : null;
                                }
                            }
                        }
                        if (0 == dialog.setFilePathNE(new File(this.strCompareFilePath).getAbsolutePath(), new File(CompareNEFile.this.m_strBckFilePathOfNE).getAbsolutePath())) {
                            DCDebugTracer.trace("DC::bisCompareBackupFileZip 2" + this.bisCompareBackupFileZip);
                            DCDebugTracer.trace("DC::bisNEBackupFileZip 2" + this.bisNEBackupFileZip);
                            if (this.bisCompareBackupFileZip && !(oFile = new File(this.strCompareFilePath)).delete()) {
                                DCDebugTracer.trace("DC::" + this.getClass() + ".run(fail to delete " + oFile + ")");
                            }
                            if (this.bisNEBackupFileZip && !(oFile = new File(CompareNEFile.this.m_strBckFilePathOfNE)).delete()) {
                                DCDebugTracer.trace("DC::" + this.getClass() + ".run(fail to delete " + oFile + ")");
                            }
                            if (reqID == CompareNEFile.this.m_iOpRequestId) {
                                CompareNEFile.this.m_bThreadStop = true;
                                CompareNEFile.this.m_oprogressDlg.dispose();
                                CompareNEFile.this.m_oprogressDlg = null;
                                dialog.setVisible(true);
                            }
                            int iFileNameIndex = 0;
                            for (int i = 0; i < 3; ++i) {
                                iFileNameIndex = CompareNEFile.this.m_strBckFilePathOfNE.lastIndexOf("/");
                                if (iFileNameIndex == -1) continue;
                                CompareNEFile.this.m_strBckFilePathOfNE = CompareNEFile.this.m_strBckFilePathOfNE.substring(0, iFileNameIndex);
                            }
                            if (-1 != iFileNameIndex) {
                                File oDeleteTempDirectory = new File(CompareNEFile.this.m_strBckFilePathOfNE);
                                CompareNEFile.this.deleteTempDirectory(oDeleteTempDirectory);
                                CompareNEFile.this.deleteTempDirectory(new File(CompareNEFile.this.m_strTempDirectory));
                                CompareNEFile.this.m_strBckFilePathOfNE = "";
                            }
                        } else {
                            DCDebugTracer.trace("DC::bisCompareBackupFileZip " + this.bisCompareBackupFileZip);
                            DCDebugTracer.trace("DC::m_strBckFilePathOfNE " + CompareNEFile.this.m_strBckFilePathOfNE);
                            if (this.bisCompareBackupFileZip && !new File(this.strCompareFilePath).delete()) {
                                DCDebugTracer.trace("DC::" + this.getClass() + ".run(fail to delete " + this.strCompareFilePath + ")");
                            }
                            if (this.bisNEBackupFileZip && !new File(CompareNEFile.this.m_strBckFilePathOfNE).delete()) {
                                DCDebugTracer.trace("DC::" + this.getClass() + ".run(fail to delete " + CompareNEFile.this.m_strBckFilePathOfNE + ")");
                            }
                            if (CompareNEFile.this.isServerOnSameMachine()) {
                                File oDeleteTempDirectory = new File(CompareNEFile.this.m_strTempDirectory);
                                CompareNEFile.this.deleteTempDirectory(oDeleteTempDirectory);
                            }
                            CompareNEFile.this.m_strBckFilePathOfNE = CompareNEFile.this.m_strBckFilePathOfNE.replace('\\', "/".charAt(0));
                            int intFileNameIndex = CompareNEFile.this.m_strBckFilePathOfNE.lastIndexOf("/");
                            if (-1 != intFileNameIndex) {
                                String strBackUpDir = CompareNEFile.this.m_strBckFilePathOfNE.substring(0, intFileNameIndex + 1);
                                File oDeleteTempDirectory = new File(strBackUpDir);
                                CompareNEFile.this.deleteTempDirectory(oDeleteTempDirectory);
                            }
                            CompareNEFile.this.m_strBckFilePathOfNE = "";
                            CompareNEFile.this.m_bThreadStop = true;
                            CompareNEFile.this.m_oprogressDlg.setVisible(false);
                            CompareNEFile.this.m_oprogressDlg.dispose();
                            Thread.sleep(500L);
                            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("COMPARE_DLG_INVALID_PATH"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
                            return;
                        }
                        dialog = null;
                    }
                    if (!CompareNEFile.this.isServerOnSameMachine()) {
                        File oDeleteTempDirectory = new File(CompareNEFile.this.m_strTempDirectory);
                        CompareNEFile.this.deleteTempDirectory(oDeleteTempDirectory);
                    }
                }
            }
            catch (InterruptedException e) {
                CompareNEFile.this.m_bThreadStop = true;
                CompareNEFile.this.m_oprogressDlg.dispose();
                File oDeleteTempDirectory = new File(CompareNEFile.this.m_strTempDirectory);
                CompareNEFile.this.deleteTempDirectory(oDeleteTempDirectory);
                return;
            }
        }
    }

    class CompareToNEOperation
    extends Thread {
        public CompareToNEOperation() {
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            byte[] byArray = m_oSyncObj;
            synchronized (m_oSyncObj) {
                block8: {
                    try {
                        m_oSyncObj.wait(DCConstants.DEFAULT_WAIT_TIME);
                        if (!CompareNEFile.this.m_bCancelSelected) {
                            if (0 != CompareNEFile.this.m_iCompToNeErrorCoder) {
                                CompareNEFile.this.m_bThreadStop = true;
                                CompareNEFile.this.m_oprogressDlg.setVisible(false);
                                CompareNEFile.this.m_oprogressDlg.dispose();
                                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), CompareNEFile.this.m_iCompToNeErrorCoder, ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
                                CompareNEFile.this.deleteTempDirectory(new File(CompareNEFile.this.m_strTempDirectory).getParentFile());
                                CompareNEFile.this.deleteTempDirectory(new File(CompareNEFile.this.m_strBckFilePathOfNE).getParentFile());
                                // ** MonitorExit[var1_1] (shouldn't be in output)
                                return;
                            }
                            CompareNEFile.this.oCompareToNEFileTransferFileThread = new CompareToNEFileTransferFileThread();
                            break block8;
                        }
                        if (0 == CompareNEFile.this.m_iCompToNeErrorCoder) {
                            CompareNEFile.this.deleteTempDirectory(new File(CompareNEFile.this.m_strTempDirectory));
                            CompareNEFile.this.deleteTempDirectory(new File(CompareNEFile.this.m_strBckFilePathOfNE).getParentFile().getParentFile().getParentFile());
                        } else {
                            CompareNEFile.this.deleteTempDirectory(new File(CompareNEFile.this.m_strTempDirectory).getParentFile());
                            CompareNEFile.this.deleteTempDirectory(new File(CompareNEFile.this.m_strBckFilePathOfNE).getParentFile());
                        }
                    }
                    catch (Exception e) {
                        DCDebugTracer.trace(e);
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    public class ProgressBar
    extends Thread {
        private static final int TIMEOUT = 80;
        private static final int MILLISECONDS = 6000;
        private JProgressBar oProgressBar;
        private static final int MAXVALUE = 100;
        private static final int DELAY = 4800;

        public ProgressBar(JProgressBar bar) {
            this.oProgressBar = bar;
        }

        @Override
        public void run() {
            int minimum = this.oProgressBar.getMinimum();
            int maximum = this.oProgressBar.getMaximum();
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    if (CompareNEFile.this.m_bThreadStop) {
                        return;
                    }
                    int value = ProgressBar.this.oProgressBar.getValue();
                    ProgressBar.this.oProgressBar.setValue(value + 1);
                }
            };
            try {
                for (int i = minimum; i < maximum; ++i) {
                    SwingUtilities.invokeAndWait(runner);
                    if (!CompareNEFile.this.m_bThreadStop) {
                        Thread.sleep(4800L);
                        if (maximum - 1 != i || CompareNEFile.this.m_bThreadStop) continue;
                        CompareNEFile.this.m_oprogressDlg.setVisible(false);
                        CompareNEFile.this.m_oprogressDlg.dispose();
                        CompareNEFile.this.m_iOpRequestId = -1;
                        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("OPERATION_TIME_OUT"), ResourceManager.getInstance().getResString("ERROR_MESSAGE_TITLE"), 0);
                        continue;
                    }
                    return;
                }
            }
            catch (InterruptedException ignoredException) {
                return;
            }
            catch (InvocationTargetException ignoredException) {
                return;
            }
        }
    }
}

