/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo;

import com.huawei.dc.common.asndatacenter.AsnBackUpFileListResp;
import com.huawei.dc.common.asndatacenter.AsnDCFile;
import com.huawei.dc.common.asndatacenter.AsnDCFileLst;
import com.huawei.dc.common.components.table.renderer.DCTableNumberCellRenderer;
import com.huawei.dc.common.components.treetable.model.DCTreeTableModel;
import com.huawei.dc.common.components.treetable.model.TreeTableComparator;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.components.treetable.view.DCTreeTableCellRenderer;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ParamUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCTimeDateUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.IDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.IParaList;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.DeviceInfoImp;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.DeviceSelectionEvent;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.IDeviceInfoSelectionListener;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.BackupFileOperation;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.BackupFilePopupMenuMgr;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.IBackupFileOperation;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IOperationConfig;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.standalone.StandAloneDomainInfo;
import com.huawei.dc.standalone.view.RouterDevInfoPanel;
import com.swimap.iview.commstyle.resource.ResourceMng;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import java.text.Collator;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;

public class BackupInfoPanel
extends JPanel
implements IDeviceInfoSelectionListener {
    private static final long serialVersionUID = 1L;
    private static final int SL_NO_INDEX = 0;
    public static final int FILE_NAME_INDEX = 1;
    private static final int MODIFIED_TIME = 5;
    public static final int SIZE_INDEX = 4;
    private static final int VERSION_INDEX = 3;
    public static final int CONTENT_TYPE_INDEX = 2;
    private static final String EMPTY_CONTENT_TYPE = "           -";
    private static final int NO_OF_COLS = 6;
    private DCTreeTableModel m_oBackupFileInfoTreeTableModel;
    private DCSortableTreeTable m_oBackupFileInfoTreeTable;
    private JScrollPane m_oBackupFileTableScrollPane;
    private TreeTableNode m_oRootNode;
    private JLabel m_oBackFileErrorInfoLabel;
    private ResourceManager m_oResMgr = ResourceManager.getInstance();
    private BackupFilePopupMenuMgr m_oBackupFilePopupMenuMgr;
    private IDeviceInfoManager m_oDeviceInfoManager = DCFrameWorkUtil.getDeviceInfoManager();
    private ParamUtil m_oParaUtil = ParamUtil.getInstance();
    private JPopupMenu m_oPopupMenu;
    private AsnDCFile m_oAsnDCFile;
    private transient IBackupFileOperation m_oBackupFileOperation;
    public HashMap oColumnHashMap = new HashMap(15);
    private int[] m_iSelectedDevIDs = null;
    private static TreeTableComparator oComparator = new TreeTableComparator(){

        @Override
        public int compare(TreeTableNode oFirstObject, TreeTableNode oSecondObject) {
            if (null == oFirstObject || null == oSecondObject) {
                return 0;
            }
            if (!(oFirstObject instanceof TreeTableNode) || !(oSecondObject instanceof TreeTableNode)) {
                return 0;
            }
            TreeTableNode oFirstNode = oFirstObject;
            TreeTableNode oSecondNode = oSecondObject;
            Object oFirstUserObject = oFirstNode.getUserObject();
            Object oSecondUserObject = oSecondNode.getUserObject();
            if (oFirstUserObject instanceof Vector && oSecondUserObject instanceof Vector) {
                Vector oFirstRow = (Vector)oFirstUserObject;
                Vector oSecondRow = (Vector)oSecondUserObject;
                if (null != oFirstRow.get(this.m_iColumnIndex) && null != oSecondRow.get(this.m_iColumnIndex)) {
                    Object oFirstObj = oFirstRow.get(this.m_iColumnIndex);
                    Object oSecondObj = oSecondRow.get(this.m_iColumnIndex);
                    int iReturnValue = 0;
                    if (this.m_iColumnIndex == 5) {
                        Date oFirstDate = ((Calendar)oFirstObj).getTime();
                        Date oSecondDate = ((Calendar)oSecondObj).getTime();
                        iReturnValue = this.compareDate(oFirstDate, oSecondDate);
                    } else {
                        iReturnValue = this.compareByNumberAndString(oFirstObj.toString(), oSecondObj.toString());
                    }
                    return this.m_iDirection * iReturnValue;
                }
            }
            return this.m_iDirection * Collator.getInstance().compare(oFirstObject.toString(), oSecondObject.toString());
        }
    };

    public BackupInfoPanel() {
        this.m_oBackFileErrorInfoLabel = new JLabel("");
        this.constructBackupTreeTable();
        this.m_oBackupFileOperation = new BackupFileOperation(this);
        this.m_oBackupFilePopupMenuMgr = BackupFilePopupMenuMgr.getInstance(this.m_oBackupFileOperation);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
                BackupInfoPanel.this.onComponentHidden();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        KeyStroke oDeleteKeyStroke = KeyStroke.getKeyStroke(127, 0);
        this.m_oBackupFileInfoTreeTable.registerKeyboardAction(this.generateKeyListenerAdapter(), oDeleteKeyStroke, 2);
        DCHelpManager.getInstance().enableF1HelpKey(this, "HELP_TOPIC_BACKUP_FILE_INFO");
    }

    private ActionListener generateKeyListenerAdapter() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent oEvent) {
                BackupInfoPanel.this.m_oBackupFileOperation.deleteBackupFile();
            }
        };
    }

    private void onComponentHidden() {
        if (null != this.m_oPopupMenu) {
            if (this.m_oPopupMenu.isVisible()) {
                this.m_oPopupMenu.setVisible(false);
            }
            this.m_oBackupFileOperation.onComponentHidden();
        }
    }

    public DCSortableTreeTable getBackupInfoTable() {
        return this.m_oBackupFileInfoTreeTable;
    }

    private void constructBackupTreeTable() {
        this.m_oBackupFileInfoTreeTableModel = this.initTreeTableModel();
        this.m_oBackupFileInfoTreeTable = this.initTreeTable(this.m_oBackupFileInfoTreeTableModel);
        this.m_oBackupFileInfoTreeTable.setName("DeviceView_BackupInfoPanel_m_oBackupFileInfoTreeTable");
        this.m_oBackupFileTableScrollPane = new JScrollPane((Component)((Object)this.m_oBackupFileInfoTreeTable));
        this.setLayout(new BorderLayout());
        this.m_oBackupFileInfoTreeTableModel.setComparator(oComparator);
        this.m_oRootNode = this.m_oBackupFileInfoTreeTableModel.getRoot();
        this.initRenderer();
        this.initTableColSize();
        this.initializeMouseAdapters();
        this.addLable();
        this.addScrollpane();
    }

    private void initRenderer() {
        DCTreeTableCellRenderer oDefaultRenderer = new DCTreeTableCellRenderer(this.m_oBackupFileInfoTreeTable);
        for (int i = 0; i < 6; ++i) {
            if (i == 4) continue;
            this.getColumnModel().getColumn(i).setCellRenderer(oDefaultRenderer);
        }
        this.getColumnModel().getColumn(4).setCellRenderer(new DCTableNumberCellRenderer());
        this.getColumnModel().getColumn(0).setCellRenderer(this.getRenderer());
    }

    private DCTreeTableCellRenderer getRenderer() {
        return new DCTreeTableCellRenderer(this.m_oBackupFileInfoTreeTable){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component tableCellRendererComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (tableCellRendererComponent instanceof JLabel) {
                    JLabel oLable = (JLabel)tableCellRendererComponent;
                    String strName = "" + (row + 1);
                    oLable.setText(strName);
                    oLable.setToolTipText(strName);
                    return oLable;
                }
                return tableCellRendererComponent;
            }
        };
    }

    private void setLableInfo(String info) {
        this.m_oBackFileErrorInfoLabel.setText(info);
        this.updateUI();
        this.repaint();
    }

    private void addLable() {
        int count = this.getComponentCount();
        if (count == 1) {
            Component component = this.getComponent(0);
            if (component instanceof JScrollPane) {
                this.remove(component);
            }
            if (!(component instanceof JLabel)) {
                this.addComponent(this.m_oBackFileErrorInfoLabel, "North");
            }
        } else if (count == 0) {
            this.addComponent(this.m_oBackFileErrorInfoLabel, "North");
        }
    }

    private void initializeMouseAdapters() {
        this.m_oBackupFileInfoTreeTable.addMouseListener(this.generateMouseAdapter());
    }

    private void triggerPopupMenu(MouseEvent oMouseEvent) {
        if (0 == (0x10 & oMouseEvent.getModifiers())) {
            int iClickedRow = this.m_oBackupFileInfoTreeTable.rowAtPoint(oMouseEvent.getPoint());
            boolean bIsClickedRowSelected = false;
            int[] nRows = this.m_oBackupFileInfoTreeTable.getSelectedRows();
            if (nRows.length > 1) {
                for (int i = 0; i < nRows.length; ++i) {
                    if (nRows[i] != iClickedRow) continue;
                    bIsClickedRowSelected = true;
                    break;
                }
            }
            if (!bIsClickedRowSelected) {
                ListSelectionModel selectionModel = this.m_oBackupFileInfoTreeTable.getSelectionModel();
                selectionModel.setSelectionInterval(iClickedRow, iClickedRow);
            }
            if (oMouseEvent.isPopupTrigger()) {
                this.m_oPopupMenu = this.m_oBackupFilePopupMenuMgr.getMenu(this);
                this.showPopUpMenu(oMouseEvent.getX(), oMouseEvent.getY());
            }
        }
    }

    protected void showPopUpMenu(int x, int y) {
        this.m_oPopupMenu.show((Component)((Object)this.m_oBackupFileInfoTreeTable), x, y);
    }

    private MouseAdapter generateMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BackupInfoPanel.this.triggerPopupMenu(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                BackupInfoPanel.this.triggerPopupMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                BackupInfoPanel.this.triggerPopupMenu(e);
            }
        };
    }

    private void initTableColSize() {
        this.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.getColumnModel().getColumn(4).setPreferredWidth(65);
        this.getColumnModel().getColumn(1).setPreferredWidth(250);
        this.getColumnModel().getColumn(5).setPreferredWidth(200);
        this.getColumnModel().getColumn(2).setPreferredWidth(120);
        this.getColumnModel().getColumn(3).setPreferredWidth(75);
    }

    private DCSortableTreeTable initTreeTable(DCTreeTableModel treeTableModel) {
        DCSortableTreeTable odeviceTreeTable = new DCSortableTreeTable(treeTableModel);
        odeviceTreeTable.setOpaque(false);
        odeviceTreeTable.getTableHeader().setReorderingAllowed(false);
        odeviceTreeTable.getTree().setToggleClickCount(1);
        return odeviceTreeTable;
    }

    private DCTreeTableModel initTreeTableModel() {
        String[] arrHeaderFields = new String[]{this.m_oResMgr.getResString("SL_NO"), this.m_oResMgr.getResString("BACKUP_INFO_TABLE_FILE_NAME"), this.m_oResMgr.getResString("CONTENT_TYPE"), this.m_oResMgr.getResString("BACKUP_INFO_TABLE_VERSION"), this.m_oResMgr.getResString("BACKUPFILESTABLE_SIZE"), this.m_oResMgr.getResString("BACKUP_FILESTABLE_TIME")};
        Class[] arrColumnTypes = new Class[]{String.class, String.class, ContentType.class, String.class, String.class, Calendar.class};
        boolean[] arrSortableColumns = new boolean[]{false, true, true, true, true, true};
        boolean[] arrEditableColumns = new boolean[]{false, false, false, false, false, false};
        return new DCTreeTableModel(arrHeaderFields, arrColumnTypes, arrSortableColumns, arrEditableColumns){
            private static final long serialVersionUID = 1L;

            @Override
            public Object getValueAt(Object node, int column) {
                Object rowObj;
                if (node instanceof TreeTableNode && (rowObj = ((TreeTableNode)node).getUserObject()) instanceof Vector) {
                    Vector rowVector = (Vector)rowObj;
                    if (column == 5 && rowVector.get(column) instanceof Calendar) {
                        Calendar calendar = (Calendar)rowVector.get(column);
                        return DCTimeDateUtil.getLocaleDisplayTime(calendar);
                    }
                    if (column == 2 && rowVector.get(column) instanceof ContentType) {
                        ContentType oContentType = (ContentType)rowVector.get(column);
                        return oContentType;
                    }
                    return rowVector.get(column).toString();
                }
                return null;
            }
        };
    }

    private TableColumnModel getColumnModel() {
        return this.m_oBackupFileInfoTreeTable.getColumnModel();
    }

    private void addScrollpane() {
        int count = this.getComponentCount();
        if (count == 1) {
            Component component = this.getComponent(0);
            if (component instanceof JLabel) {
                this.remove(component);
            }
            if (!(component instanceof JScrollPane)) {
                this.addComponent(this.m_oBackupFileTableScrollPane, "Center");
            }
        } else if (count == 0) {
            this.addComponent(this.m_oBackupFileTableScrollPane, "Center");
        }
    }

    private void addComponent(JComponent component, String layout) {
        this.add((Component)component, layout);
        this.updateUI();
    }

    @Override
    public void onDeviceInfoSelection(DeviceSelectionEvent oEvent) {
        if (oEvent.getEventType() == 1) {
            this.m_iSelectedDevIDs = oEvent.getSelectedDevIds();
        } else if (oEvent.getEventType() == 2) {
            if (!this.bEquals(this.m_iSelectedDevIDs, oEvent.getSelectedDevIds())) {
                return;
            }
        } else {
            DCDebugTracer.trace("unknow DeviceSelectionEvent " + oEvent.getEventType());
            return;
        }
        int iSelRowCount = 0;
        int[] iSelDevIDs = oEvent.getSelectedDevIds();
        if (null != iSelDevIDs) {
            iSelRowCount = iSelDevIDs.length;
        }
        if (iSelRowCount > 1 || iSelRowCount == 0) {
            this.removeAllComponent();
            this.updateUI();
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BackupInfoPanel.this.populateTable();
            }
        });
    }

    private void populateTable() {
        if (null == this.m_oRootNode) {
            this.constructBackupTreeTable();
        }
        this.m_oRootNode.removeAllChildren();
        int[] m_iSelectedDevIDs = null;
        if (StandAloneDomainInfo.getInstance().getSelectedDomain() == 2 && DCFrameWorkUtil.getIsSingleClient()) {
            RouterDevInfoPanel oDevPanel = DCFrameWorkUtil.getRouterDevInfoPanel();
            DeviceInfoImp[] selDevLst = DCFrameWorkUtil.getSelDevLstInSA();
            m_iSelectedDevIDs = oDevPanel.getSelectedDevIds();
        } else {
            ArrayList<DeviceInfo> oDeviceList = DCFrameWorkUtil.getDeviceTablePanel().getSelectedDevices();
            m_iSelectedDevIDs = new int[oDeviceList.size()];
            for (int i = 0; i < oDeviceList.size(); ++i) {
                m_iSelectedDevIDs[i] = oDeviceList.get(i).getDevId();
            }
        }
        if (null != m_iSelectedDevIDs && 0 < m_iSelectedDevIDs.length && this.m_oDeviceInfoManager != null) {
            int iErrorCode = 0;
            AsnBackUpFileListResp asnBackUpFileListResp = new AsnBackUpFileListResp();
            int iDeviceID = m_iSelectedDevIDs[0];
            DeviceInfo devInfo = DeviceInfoManagerImpl.getInstance().getDevice(iDeviceID);
            if (null == devInfo || StringUtils.isNullOrEmptyStr(devInfo.getDevIPAddress())) {
                DCDebugTracer.trace("BackupInfoPanel#populateTable The Device is null or do not assign IP, do not need get backup file list.");
                return;
            }
            DCDebugTracer.trace("BackupInfoPanel#populateTable The Device is " + devInfo);
            iErrorCode = this.m_oDeviceInfoManager.getBackupFileList(iDeviceID, asnBackUpFileListResp);
            this.updateBackupInfo(iErrorCode, asnBackUpFileListResp, iDeviceID);
        } else if (null != m_iSelectedDevIDs && 0 == m_iSelectedDevIDs.length) {
            this.showErrorIfNoRowFound(true);
        }
    }

    private void updateBackupInfo(int iErrorCode, AsnBackUpFileListResp asnBackUpFileListResp, int iDeviceID) {
        if (0 != iErrorCode) {
            DCDebugTracer.trace("BackupInfoPanel#updateBackupInfo Failed:" + iErrorCode);
            String strBoardVersionInfo = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode));
            this.setLableInfo(strBoardVersionInfo);
            this.addLable();
        } else {
            this.updateTable(asnBackUpFileListResp, iDeviceID);
        }
    }

    public void showErrorIfNoRowFound(boolean isNoSelectedNE) {
        if (isNoSelectedNE && null != this.m_oRootNode && this.m_oRootNode.getChildCount() == 0) {
            this.setLableInfo("");
            this.addLable();
        }
    }

    public void showErrorIfNoRowFound() {
        if (null != this.m_oRootNode && this.m_oRootNode.getChildCount() == 0) {
            this.setLableInfo(this.m_oResMgr.getResString("NO_BACKUP_FILE_FOUND"));
            this.addLable();
        }
    }

    private void updateTable(AsnBackUpFileListResp asnBackUpFileListResp, int iDeviceID) {
        DCDebugTracer.trace("BackupInfoPanel#updateTable Start:");
        AsnDCFileLst osnDCFileLst = asnBackUpFileListResp.oAsnDCFileLst;
        int iTotalBackupFiles = osnDCFileLst.size();
        if (0 == iTotalBackupFiles) {
            this.showErrorIfNoRowFound();
            return;
        }
        Object[] contentTypeList = this.getContentTypeList(iDeviceID);
        int iSelRow = this.m_oBackupFileInfoTreeTable.getSelectedRow();
        this.m_oRootNode.removeAllChildren();
        this.oColumnHashMap.clear();
        for (int oBackFileIndex = 0; oBackFileIndex < iTotalBackupFiles; ++oBackFileIndex) {
            AsnDCFile oAsnDCFile = (AsnDCFile)osnDCFileLst.elementAt(oBackFileIndex);
            TreeTableNode oNode = this.getNode(oAsnDCFile, oBackFileIndex + 1, contentTypeList);
            this.setAsnDCFile(oAsnDCFile);
            this.m_oRootNode.add(oNode);
        }
        this.addScrollpane();
        this.m_oBackupFileInfoTreeTable.updateUI();
        this.setDefaultSelection(iSelRow);
        DCDebugTracer.trace("BackupInfoPanel#updateTable End:");
    }

    private void setAsnDCFile(AsnDCFile asnDCFile) {
        this.m_oAsnDCFile = asnDCFile;
    }

    public AsnDCFile getAsnDCFile() {
        return this.m_oAsnDCFile;
    }

    void setDefaultSelection(int iSelectedRow) {
        if (this.m_oBackupFileInfoTreeTable.getRowCount() > 0) {
            if (0 > iSelectedRow) {
                this.m_oBackupFileInfoTreeTable.getSelectionModel().setSelectionInterval(0, 0);
            } else {
                this.m_oBackupFileInfoTreeTable.getSelectionModel().setSelectionInterval(iSelectedRow, iSelectedRow);
            }
        }
    }

    private Object[] getContentTypeList(int iDeviceID) {
        DeviceInfo device = this.m_oDeviceInfoManager.getDevice(iDeviceID);
        if (null == device || null == device.getDeviceTypeInfo()) {
            return null;
        }
        int[] iDeviceIdLst = new int[]{iDeviceID};
        IDeviceTypeConfigModel deviceTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(device.getDeviceTypeInfo(), iDeviceIdLst);
        IParaList oPerationParaList = null;
        if (null != deviceTypeConfigModel) {
            IOperationConfig operationConfiguration = deviceTypeConfigModel.getOperationConfiguration();
            IDeviceOperation deviceOperation = operationConfiguration.getDeviceOperation(2);
            if (null != deviceOperation) {
                oPerationParaList = deviceOperation.getoPerationParaList();
            }
            return this.m_oParaUtil.getContentTypeList(oPerationParaList);
        }
        return null;
    }

    private TreeTableNode getNode(AsnDCFile oAsnDCFile, int iSlNo, Object[] contentTypeList) {
        Vector<Object> oRow = new Vector<Object>(6);
        oRow.add(0, "" + iSlNo);
        oRow.add(1, new String(oAsnDCFile.strTimeOrFileName));
        ContentType oContentType = this.m_oParaUtil.getContentType(contentTypeList, oAsnDCFile.iContentType.intValue());
        if (null == oContentType) {
            if (null == oAsnDCFile.strContentType) {
                oRow.add(2, EMPTY_CONTENT_TYPE);
            } else {
                oRow.add(2, this.m_oResMgr.getResString(new String(oAsnDCFile.strContentType)));
            }
        } else {
            oRow.add(2, oContentType);
        }
        if (null != oAsnDCFile.strVersion) {
            oRow.add(3, new String(oAsnDCFile.strVersion));
        } else {
            oRow.add(3, "");
        }
        Locale oLocal = ResourceMng.getInstance().getLocale();
        NumberFormat oNumberFormat = NumberFormat.getNumberInstance(oLocal);
        String strFileSize = oNumberFormat.format(Integer.parseInt(oAsnDCFile.iFileSize.toString()));
        oRow.add(4, strFileSize);
        oRow.add(5, oAsnDCFile.time);
        this.oColumnHashMap.put(new String(oAsnDCFile.strTimeOrFileName), oAsnDCFile.iFileType.toString());
        TreeTableNode oNode = new TreeTableNode(oRow);
        return oNode;
    }

    public String getFileType(int iRowIndex) {
        String strFileName = (String)this.m_oBackupFileInfoTreeTable.getValueAt(iRowIndex, 1);
        return this.oColumnHashMap.get(strFileName).toString();
    }

    public void disposePanel() {
        this.m_oBackupFileInfoTreeTableModel = null;
        this.m_oBackupFileInfoTreeTable = null;
        this.m_oBackupFileTableScrollPane = null;
        this.m_oRootNode = null;
        this.m_oBackFileErrorInfoLabel = null;
        this.m_oResMgr = null;
        this.m_oBackupFilePopupMenuMgr = null;
        this.m_oDeviceInfoManager = null;
        this.m_oParaUtil = null;
        this.m_oPopupMenu = null;
        this.m_oAsnDCFile = null;
        this.m_oBackupFileOperation.doCleanUp();
        this.m_oBackupFileOperation = null;
        this.oColumnHashMap.clear();
        this.oColumnHashMap = null;
    }

    public int[] getSelectedDevIDs() {
        return this.m_iSelectedDevIDs;
    }

    private boolean bEquals(int[] iSourceArray, int[] iDestArray) {
        if (null == iSourceArray || null == iDestArray) {
            return false;
        }
        if (iSourceArray.length != iDestArray.length) {
            return false;
        }
        for (int i = 0; i < iSourceArray.length; ++i) {
            if (iSourceArray[i] == iDestArray[i]) continue;
            return false;
        }
        return true;
    }

    public void removeAllComponent() {
        this.removeAll();
        if (null != this.m_oRootNode) {
            this.m_oRootNode.removeAllChildren();
        }
    }
}

