/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo;

import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.PopupMenuManager;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.BackupInfoPanel;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.IBackupFileOperation;
import java.awt.Component;
import java.util.HashMap;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class BackupFilePopupMenuMgr
implements IDCObjectDeallocator {
    private static final String COMPARE_TO_N_E_FILE_MENU_ID = "compareToNEFile";
    private static final String SELECT_LEFT_SIDE_TO_COMPARE_MENU_ID = "selectLeftSideToCompare";
    private static final String COMPARE_TO_MENU_ID = "CompareTo";
    private static final String COMPARE_TWO_FILES = "compareFiles";
    private static final String VIEW_FILE_MENU_ID = "ViewFile";
    private static final String SAVE_AS = "saveBackupFile";
    private static final String DELETE_MENU_ID = "Delete";
    private static final String BACKUPFILESTABLEPOPUPMENU = "backupfilestablepopupmenu";
    private static BackupFilePopupMenuMgr m_oBackupFilePopupMenuMgr = null;
    private JPopupMenu m_oBackFilePopupMenu = null;
    private HashMap m_oMenuItemMap = null;
    boolean m_hasBackupPrivilege = true;
    boolean m_hasDelBackupPrivilege = true;

    public void checkUserPrivileges() {
        if (DCFrameWorkUtil.getIsSingleClient()) {
            return;
        }
        this.setPrivilege();
    }

    public void setPrivilege() {
        boolean bckaupToServerPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(43823);
        boolean bckaupToTHIRDPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(44095);
        this.m_hasBackupPrivilege = bckaupToServerPrivilege || bckaupToTHIRDPrivilege;
        this.m_hasDelBackupPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(43857);
    }

    private BackupFilePopupMenuMgr(IBackupFileOperation oIBackupFileOperation) {
        PopupMenuManager oPopupMenuMgr = PopupMenuManager.getInstance();
        this.m_oBackFilePopupMenu = oPopupMenuMgr.load(oIBackupFileOperation, BACKUPFILESTABLEPOPUPMENU);
        this.m_oMenuItemMap = (HashMap)oPopupMenuMgr.getMenuItemMap().clone();
        JMenuItem compareToMenu = (JMenuItem)this.m_oMenuItemMap.get(COMPARE_TO_MENU_ID);
        compareToMenu.setEnabled(false);
        this.checkUserPrivileges();
    }

    @Override
    public void setToNULL() {
        if (null != this.m_oMenuItemMap) {
            this.m_oMenuItemMap.clear();
            this.m_oMenuItemMap = null;
        }
        m_oBackupFilePopupMenuMgr = null;
    }

    public static synchronized BackupFilePopupMenuMgr getInstance(IBackupFileOperation oIBackupFileOperation) {
        if (null == m_oBackupFilePopupMenuMgr) {
            m_oBackupFilePopupMenuMgr = new BackupFilePopupMenuMgr(oIBackupFileOperation);
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oBackupFilePopupMenuMgr);
        }
        return m_oBackupFilePopupMenuMgr;
    }

    private void enableMenuItem(String strMenuItemId, boolean bFlag) {
        Object oMenuItem = this.m_oMenuItemMap.get(strMenuItemId);
        if (oMenuItem instanceof JMenuItem) {
            ((JMenuItem)oMenuItem).setEnabled(bFlag);
        }
    }

    private void displayMenuItem(String strMenuItemId, boolean bFlag) {
        Object oMenuItem = this.m_oMenuItemMap.get(strMenuItemId);
        if (oMenuItem instanceof JMenuItem) {
            ((JMenuItem)oMenuItem).setVisible(bFlag);
        }
    }

    public JPopupMenu getMenu(BackupInfoPanel oBackupInfoPanel) {
        int[] arr_SelectedRows;
        DCSortableTreeTable oBackupFileInfoTreeTable = oBackupInfoPanel.getBackupInfoTable();
        boolean bIsTextFile = false;
        int iFileType = 0;
        int[] arrSelectedRows = oBackupFileInfoTreeTable.getSelectedRows();
        if (null != arrSelectedRows && 0 < arrSelectedRows.length) {
            bIsTextFile = true;
            for (int i = 0; i < arrSelectedRows.length; ++i) {
                String oString = oBackupInfoPanel.getFileType(arrSelectedRows[i]);
                int cellvalue = Integer.parseInt(oString);
                if (cellvalue == 0) continue;
                iFileType = cellvalue;
                bIsTextFile = false;
                break;
            }
        }
        if (null == (arr_SelectedRows = oBackupFileInfoTreeTable.getSelectedRows()) || 0 == arr_SelectedRows.length) {
            this.enableAllMenuItem(false);
            return this.m_oBackFilePopupMenu;
        }
        if (1 < arr_SelectedRows.length) {
            this.enableAllMenuItem(false);
            this.enableMenuItem(DELETE_MENU_ID, true);
            this.displayMenuItem(COMPARE_TO_MENU_ID, false);
            this.displayMenuItem(COMPARE_TO_N_E_FILE_MENU_ID, false);
            this.displayMenuItem(SELECT_LEFT_SIDE_TO_COMPARE_MENU_ID, false);
            if (2 == arr_SelectedRows.length) {
                this.displayMenuItem(COMPARE_TWO_FILES, true);
                this.getSeparator(this.m_oBackFilePopupMenu, 2).setVisible(true);
                this.enableMenuItem(COMPARE_TWO_FILES, bIsTextFile);
            } else {
                this.displayMenuItem(COMPARE_TWO_FILES, false);
                this.getSeparator(this.m_oBackFilePopupMenu, 2).setVisible(false);
            }
        } else {
            this.displayMenuItem(COMPARE_TO_MENU_ID, true);
            this.displayMenuItem(COMPARE_TWO_FILES, false);
            this.displayMenuItem(COMPARE_TO_N_E_FILE_MENU_ID, true);
            this.displayMenuItem(SELECT_LEFT_SIDE_TO_COMPARE_MENU_ID, true);
            this.getSeparator(this.m_oBackFilePopupMenu, 2).setVisible(true);
            if (DCFrameWorkUtil.getIsSingleClient()) {
                this.enableMenuItem(SAVE_AS, false);
            } else {
                this.enableMenuItem(SAVE_AS, true);
            }
            if (bIsTextFile) {
                this.enableMenuItem(VIEW_FILE_MENU_ID, true);
                this.enableMenuItem(COMPARE_TO_N_E_FILE_MENU_ID, true);
                this.enableMenuItem(SELECT_LEFT_SIDE_TO_COMPARE_MENU_ID, true);
            } else {
                if (-2 == iFileType) {
                    this.enableMenuItem(VIEW_FILE_MENU_ID, true);
                } else {
                    this.enableMenuItem(VIEW_FILE_MENU_ID, false);
                }
                this.enableMenuItem(COMPARE_TO_N_E_FILE_MENU_ID, false);
                this.enableMenuItem(SELECT_LEFT_SIDE_TO_COMPARE_MENU_ID, false);
            }
        }
        if (!this.m_hasBackupPrivilege) {
            this.enableAllMenuItem(false);
        }
        this.enableMenuItem(DELETE_MENU_ID, this.m_hasDelBackupPrivilege);
        return this.m_oBackFilePopupMenu;
    }

    public JMenuItem getMenuItem(String strMenuItemId, boolean bFlag) {
        JMenuItem oJMenuItem = (JMenuItem)this.m_oMenuItemMap.get(strMenuItemId);
        if (oJMenuItem instanceof JMenuItem) {
            oJMenuItem.setEnabled(bFlag);
        }
        return oJMenuItem;
    }

    private void enableAllMenuItem(boolean bIsEnabled) {
        Set keySet = this.m_oMenuItemMap.keySet();
        for (Object oMenuItemId : keySet) {
            this.m_oMenuItemMap.get(oMenuItemId);
            JMenuItem oMenuItem = (JMenuItem)this.m_oMenuItemMap.get(oMenuItemId);
            if (!(oMenuItem instanceof JMenuItem)) continue;
            oMenuItem.setEnabled(bIsEnabled);
        }
    }

    public JSeparator getSeparator(JPopupMenu oMenu, int iSeperatorIndex) {
        if (null == oMenu || 0 > iSeperatorIndex) {
            return null;
        }
        int iCompCount = oMenu.getComponentCount();
        int iCurrentIndex = 0;
        Component oComponent = null;
        for (int i = 0; i < iCompCount; ++i) {
            oComponent = oMenu.getComponent(i);
            if (!(oComponent instanceof JSeparator) || iSeperatorIndex != ++iCurrentIndex) continue;
            return (JSeparator)oComponent;
        }
        return null;
    }
}

