/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo;

import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.BackupInfoPanel;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.CompareNEFile;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.CompareNEStdAloneFile;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.CompareToFiles;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.DeleteBackupFile;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.IBackupFileOperation;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.SaveAsBackupFile;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.ViewFile;
import java.awt.Component;

public class BackupFileOperation
implements IBackupFileOperation {
    private BackupInfoPanel m_oBackupInfoPanel = null;

    public DCSortableTreeTable getBackupFileTable() {
        return this.m_oBackupInfoPanel.getBackupInfoTable();
    }

    public BackupFileOperation(BackupInfoPanel backupInfoPanel) {
        this.m_oBackupInfoPanel = backupInfoPanel;
    }

    @Override
    public void deleteBackupFile() {
        try {
            DCDebugTracer.trace("DC::deleteBackupFile Start");
            DeleteBackupFile instance = DeleteBackupFile.getInstance();
            instance.setBackupInfoPanel(this.m_oBackupInfoPanel);
            instance.deleteBackupFile();
            this.m_oBackupInfoPanel.showErrorIfNoRowFound();
            DCDebugTracer.trace("DC::deleteBackupFile End");
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    @Override
    public void saveBackupFile() {
        try {
            SaveAsBackupFile instance = SaveAsBackupFile.getInstance();
            instance.setBackupInfoPanel(this.m_oBackupInfoPanel);
            instance.saveBackupFile();
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    @Override
    public void viewBackupFile() {
        new ViewFile(this.m_oBackupInfoPanel);
    }

    @Override
    public void compareToNEFile() {
        int[] iDevIds = this.m_oBackupInfoPanel.getSelectedDevIDs();
        if (null == iDevIds || 0 >= iDevIds.length) {
            return;
        }
        int iDevId = iDevIds[0];
        DeviceInfo oDevInfo = DCFrameWorkUtil.getDeviceInfoManager().getDevice(iDevId);
        if (oDevInfo.getDeviceOperationStatus().getIsProgress()) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("DEVICE_OPERATION_IN_PROGRESS"), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        if (!DCFrameWorkUtil.getIsSingleClient()) {
            CompareNEFile instance = CompareNEFile.getInstance();
            instance.setTableObject(this.m_oBackupInfoPanel, iDevId);
            instance.compareToNEFile();
        } else {
            CompareNEStdAloneFile instance = CompareNEStdAloneFile.getInstance();
            instance.setTableObject(this.m_oBackupInfoPanel, iDevId);
            instance.compareToNEStdAloneFile();
        }
    }

    @Override
    public void selectLeftSideToCompare() {
        CompareToFiles oCompareToFiles = CompareToFiles.getInstance();
        oCompareToFiles.setCompareToFiles(this.m_oBackupInfoPanel);
        oCompareToFiles.selectLeftSideToCompare();
    }

    @Override
    public void compareToPreviousFile() {
        CompareToFiles oCompareToFiles = CompareToFiles.getInstance();
        oCompareToFiles.setCompareToFiles(this.m_oBackupInfoPanel);
        oCompareToFiles.compareToPreviousFile();
    }

    public void compareFiles() {
        CompareToFiles oCompareToFiles = CompareToFiles.getInstance();
        oCompareToFiles.setCompareToFiles(this.m_oBackupInfoPanel);
        oCompareToFiles.compareTwoFiles();
    }

    @Override
    public void onComponentHidden() {
        SaveAsBackupFile oSaveInstance = SaveAsBackupFile.getInstance();
        oSaveInstance.setToNULL();
        DeleteBackupFile oDeleteInstance = DeleteBackupFile.getInstance();
        oDeleteInstance.setToNULL();
        CompareNEFile oCompareNEFile = CompareNEFile.getInstance();
        oCompareNEFile.setToNULL();
        DCFrameWorkUtil.closeModalDialogs();
    }

    @Override
    public void doCleanUp() {
        SaveAsBackupFile oSaveInstance = SaveAsBackupFile.getInstance();
        oSaveInstance.setToNULL();
        DeleteBackupFile oDeleteInstance = DeleteBackupFile.getInstance();
        oDeleteInstance.setToNULL();
        CompareNEFile oCompareNEFile = CompareNEFile.getInstance();
        oCompareNEFile.setToNULL();
        this.m_oBackupInfoPanel = null;
    }
}

