/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.BackupFileTask;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public final class BackupFileContentDlg
extends DCModalDialog {
    private JTextArea filecontentTextArea = null;
    private JScrollPane displayContentScrPan;
    private Thread workerThread;
    private boolean m_bisZipFile;
    private String m_strBackupFilePath;

    public BackupFileContentDlg(String strFilePath, boolean bisZipFile, int iSelectedDevId) throws DCException {
        super(DCFrameWorkUtil.getMainFrame(), true);
        if (bisZipFile) {
            this.m_strBackupFilePath = strFilePath;
        }
        this.m_bisZipFile = bisZipFile;
        File oFile = new File(strFilePath);
        if (!oFile.exists()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
            DCDebugTracer.trace("backup file not found BackupFileContentDlg.BackupFileContentDlg() " + strFilePath);
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("BACKUP_FILE_ALREADY_DELETED"), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        this.setSize(715, 558);
        String strTitle = ResourceManager.getInstance().getResString("VIEW_FILE_DLG_TITLE");
        this.setTitle(strTitle);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        this.setResizable(false);
        try {
            this.jbInit();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BackupFileContentDlg.this.setVisible(true);
                }
            });
            Thread.sleep(50L);
            this.readFile(strFilePath);
        }
        catch (Exception e1) {
            throw new DCException(e1.getMessage());
        }
    }

    private void jbInit() throws DCException {
        JPanel mainPanel = new JPanel(null);
        mainPanel.setBounds(0, 0, 700, 600);
        this.displayContentScrPan = new JScrollPane();
        this.displayContentScrPan.setBounds(12, 12, 685, 470);
        this.filecontentTextArea = new JTextArea();
        this.filecontentTextArea.setEditable(false);
        this.displayContentScrPan.getViewport().add((Component)this.filecontentTextArea, null);
        mainPanel.add(this.displayContentScrPan);
        this.m_oCancelBtn.setBounds(new Rectangle(311, 494, 80, 21));
        this.m_oCancelBtn.setText(ResourceManager.getInstance().getResString("TASK_STATISTICS_CLOSE_BUTTON"));
        mainPanel.add(this.m_oCancelBtn);
        this.getContentPane().add(mainPanel);
        this.setDefaultCloseOperation(2);
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
    }

    @Override
    public void cancelButton_ActionPerformed() {
        this.doCleanUp();
    }

    public void readFile(final String strFilePath) {
        BackupFileTask task = new BackupFileTask(){

            @Override
            public void finish() {
                BackupFileContentDlg.this.workerThread = null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void work() {
                BufferedReader oBufferedReader = null;
                try {
                    oBufferedReader = new BufferedReader(new FileReader(strFilePath));
                    BackupFileContentDlg.this.filecontentTextArea.setText("");
                    String strLine = null;
                    strLine = oBufferedReader.readLine();
                    while (!Thread.currentThread().isInterrupted() && strLine != null) {
                        BackupFileContentDlg.this.filecontentTextArea.append(strLine);
                        BackupFileContentDlg.this.filecontentTextArea.append(System.getProperty("line.separator"));
                        strLine = oBufferedReader.readLine();
                    }
                }
                catch (FileNotFoundException ex) {
                    DCDebugTracer.trace("backup file not found BackupContentDlg.readFile() " + strFilePath);
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("BACKUP_FILE_ALREADY_DELETED"), ResourceManager.getInstance().getResString("ERROR"), 0);
                }
                catch (IOException ex) {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("CONFIG_ERROR"), ResourceManager.getInstance().getResString("ERROR"), 0);
                }
                finally {
                    try {
                        if (oBufferedReader != null) {
                            oBufferedReader.close();
                        }
                    }
                    catch (IOException ex) {
                        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("CONFIG_ERROR"), ResourceManager.getInstance().getResString("ERROR"), 0);
                    }
                }
            }
        };
        this.workerThread = new Thread(task);
        this.workerThread.start();
    }

    private boolean deleteTempDirectory(File path) {
        block6: {
            if (path.exists()) {
                try {
                    File[] files = path.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        if (files[i].isDirectory()) {
                            this.deleteTempDirectory(files[i]);
                            continue;
                        }
                        if (files[i].delete()) continue;
                        DCDebugTracer.trace("DC::BackupFileContentDlg.deleteTempDirectory(fail to delete " + files[i] + ")");
                    }
                }
                catch (Exception e) {
                    if (path.delete()) break block6;
                    DCDebugTracer.trace("DC::BackupFileContentDlg.deleteTempDirectory(fail to delete " + path + ")");
                }
            }
        }
        String strBackupFilePath = DCConstants.CLIENT_TEMP_DIRECTORY;
        String strBackupFilePathTmp = strBackupFilePath + "\\temp";
        if (strBackupFilePath.equals(path.toString()) || strBackupFilePathTmp.equals(path.toString())) {
            return true;
        }
        return path.delete();
    }

    @Override
    public void doCleanUp() {
        File oFile1;
        this.dispose();
        if (this.workerThread != null) {
            this.workerThread.interrupt();
            this.workerThread = null;
        }
        String strBackupFilePath = DCConstants.CLIENT_TEMP_DIRECTORY;
        File oFile = new File(strBackupFilePath);
        this.deleteTempDirectory(oFile);
        if (this.m_bisZipFile && !(oFile1 = new File(this.m_strBackupFilePath)).delete()) {
            DCDebugTracer.trace("DC::BackupFileContentDlg.doCleanup(fail to delete " + oFile1 + ")");
        }
        this.filecontentTextArea = null;
        this.displayContentScrPan = null;
        this.m_strBackupFilePath = null;
        this.getContentPane().removeAll();
    }

    public void helpDisplay() {
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_BACKUP_FILE_INFO";
    }
}

