/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceview.deviceinfo;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.components.treetable.view.JSortTreeTable;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.event.DCEventObject;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.IOperation;
import com.huawei.dc.devicemanagement.deviceoperation.IOtherOperation;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.AbstractCustomOperationTab;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.CustomOperationEngine;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.DeviceInfoImp;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.ICustomOperationEngine;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.ICustomOperationInfo;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.IDeviceInfo;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.DeviceInfoTabChangeListener;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.DeviceSelectionEvent;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.IDeviceInfoSelectionListener;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.BackupInfoPanel;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.boardinfo.BoardInfoPanel;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IOperationConfig;
import com.huawei.dc.devicemanagement.model.xmlconfig.IViewConfiguration;
import com.huawei.dc.standalone.StandAloneDomainInfo;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class DeviceInfoTabPanel
extends JTabbedPane
implements IDeviceInfoSelectionListener {
    private static final long serialVersionUID = 1L;
    private int iSelectedTab;
    private int BOARD_INFO_TAB_INDEX = -1;
    private int BACKUP_FILE_INFO_TAB_INDEX = 1;
    private CustomOperationPanel m_oLastSelectedCustomOperationPanel;
    private BoardInfoPanel m_oBoardInfoPanel;
    private BackupInfoPanel m_oBackupInfoPanel;
    private int[] m_iSelectedDevIDs = null;
    private DeviceSelectionEvent m_oEvent = null;

    public DeviceInfoTabPanel() {
        if (DCFrameWorkUtil.getIsSingleClient() || DCFrameWorkUtil.checkIsBmsMiniNMS()) {
            this.BOARD_INFO_TAB_INDEX = 0;
            this.BACKUP_FILE_INFO_TAB_INDEX = 1;
        }
        this.init();
    }

    private void init() {
        if (DCFrameWorkUtil.getIsSingleClient() && 2 == StandAloneDomainInfo.getInstance().getSelectedDomain()) {
            this.BOARD_INFO_TAB_INDEX = -1;
            this.BACKUP_FILE_INFO_TAB_INDEX = 0;
        } else {
            this.BOARD_INFO_TAB_INDEX = 0;
            this.initBoardInfo();
        }
        if (!DCFrameWorkUtil.isForiTec()) {
            this.initBackupInfoInfo();
        } else {
            this.BACKUP_FILE_INFO_TAB_INDEX = -1;
        }
        this.addChangeListener(new DeviceInfoTabChangeListener(this));
        this.setFocusable(false);
        this.setTabLayoutPolicy(1);
        DCDebugTracer.trace("DC::DeviceInfoTabPanel.init()");
        this.enableAllTabs(false);
    }

    private void initBackupInfoInfo() {
        this.m_oBackupInfoPanel = new BackupInfoPanel();
        this.m_oBackupInfoPanel.setName("DeviceManagement_DeviceInfoTabPanel_oBackupInfoPanel");
        this.addTab(ResourceManager.getInstance().getResString("BACKUP_INFO"), this.m_oBackupInfoPanel);
    }

    private void initBoardInfo() {
        this.m_oBoardInfoPanel = new BoardInfoPanel();
        this.m_oBoardInfoPanel.setName("DeviceManagement_DeviceInfoTabPanel_boardInfoPanel");
        this.addTab(ResourceManager.getInstance().getResString("BOARD_INFO"), this.m_oBoardInfoPanel);
        DCFrameWorkUtil.setBoardInfoPanel(this.m_oBoardInfoPanel);
    }

    private IDeviceTypeConfigModel getDeviceTypeCfgModel() {
        IDeviceTypeConfigModel oDeviceTypeConfigModel = null;
        if (null == this.m_iSelectedDevIDs || 0 >= this.m_iSelectedDevIDs.length) {
            return null;
        }
        DeviceInfo oDeviceInfo = DeviceInfoManagerImpl.getInstance().getDevice(this.m_iSelectedDevIDs[0]);
        if (null == oDeviceInfo) {
            return oDeviceTypeConfigModel;
        }
        DeviceTypeInfo oDeviceTypeInfo = oDeviceInfo.getDeviceTypeInfo();
        if (null == oDeviceTypeInfo) {
            return oDeviceTypeConfigModel;
        }
        oDeviceTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDeviceInfo.getDeviceTypeInfo(), this.m_iSelectedDevIDs);
        return oDeviceTypeConfigModel;
    }

    private synchronized void addCustomOpTab() {
        IDeviceTypeConfigModel oDeviceTypeCfgModel = this.getDeviceTypeCfgModel();
        if (null != oDeviceTypeCfgModel) {
            IOperationConfig oOpConfiguration = oDeviceTypeCfgModel.getOperationConfiguration();
            List oCustomOperationList = oOpConfiguration.getCustomOperationList(1);
            IViewConfiguration oViewConfiguration = oDeviceTypeCfgModel.getViewConfiguration();
            List<String> oCustomTabOpList = oViewConfiguration.getViewConfiguration(3, 4);
            int iSize = oCustomOperationList.size();
            for (int i = 0; i < iSize; ++i) {
                ICustomOperationInfo oCustomOperationInfo = (ICustomOperationInfo)oCustomOperationList.get(i);
                if (!oCustomTabOpList.contains(oCustomOperationInfo.getOperationIdString())) continue;
                CustomOperationPanel oCustomOperationPanel = new CustomOperationPanel();
                oCustomOperationPanel.setCustomOperationInfo(oCustomOperationInfo);
                ICustomOperationEngine.CustomOpTab oTab = this.getCustomOpTab(oCustomOperationInfo);
                if (null != oTab.customTab) {
                    oCustomOperationPanel.add(oTab.customTab);
                    oCustomOperationPanel.setCustomTab(oTab.customTab);
                    if (oCustomOperationInfo.getOperationIdString().equals("GetDeviceMapProgramInfo")) {
                        DCHelpManager.getInstance().enableF1HelpKey(oTab.customTab, "HELP_TOPIC_MIRRORING_INFO");
                    }
                } else {
                    oCustomOperationPanel.add(new JLabel(oTab.strErrorCode));
                }
                this.addTab(oCustomOperationInfo.getOperationName(), oCustomOperationPanel);
                oCustomOperationPanel.setLayout(new GridLayout(0, 1));
            }
        }
    }

    private Integer getSelectedDevID() {
        int iDevId = -1;
        if (null != this.m_iSelectedDevIDs && 1 == this.m_iSelectedDevIDs.length) {
            iDevId = this.m_iSelectedDevIDs[0];
        }
        return iDevId;
    }

    private ICustomOperationEngine.CustomOpTab getCustomOpTab(ICustomOperationInfo customOperationInfo) {
        IDeviceInfo[] oArrDeviceInfo = this.getDeviceInfo();
        DCFrameWorkUtil.setSelDevLstInSA((DeviceInfoImp[])oArrDeviceInfo);
        return CustomOperationEngine.getInstance().initCustomTabOperation(customOperationInfo, oArrDeviceInfo);
    }

    private DeviceInfoImp[] getDeviceInfo() {
        int iSelectDevCount = 0;
        if (null != this.m_iSelectedDevIDs) {
            iSelectDevCount = this.m_iSelectedDevIDs.length;
        }
        DeviceInfoImp deviceInfo = null;
        ArrayList<DeviceInfoImp> deviceInfoImpLst = new ArrayList<DeviceInfoImp>(0);
        for (int i = 0; i < iSelectDevCount; ++i) {
            DeviceInfo oDeviceInfo = DeviceInfoManagerImpl.getInstance().getDevice(this.m_iSelectedDevIDs[0]);
            if (oDeviceInfo == null) continue;
            deviceInfo = new DeviceInfoImp();
            if (null != oDeviceInfo.getDevVersion()) {
                deviceInfo.setDevVersion(oDeviceInfo.getDevVersion().getDevVersion());
            }
            deviceInfo.setDevID(oDeviceInfo.getDevId());
            deviceInfo.setDevIPAddress(oDeviceInfo.getDevIPAddress());
            deviceInfo.setDevName(oDeviceInfo.getDevName());
            deviceInfo.setDevTypeID(oDeviceInfo.getDeviceTypeInfo().getDevTypeID());
            deviceInfo.setDevTypeName(oDeviceInfo.getDeviceTypeInfo().getDevTypeName());
            deviceInfo.setDevTypeVersionID(oDeviceInfo.getDevTypeVersionId());
            deviceInfoImpLst.add(deviceInfo);
        }
        return deviceInfoImpLst.toArray(new DeviceInfoImp[0]);
    }

    private synchronized void removeCustomTab() {
        int iTabCount = this.getTabCount();
        for (int i = iTabCount - 1; i > this.BACKUP_FILE_INFO_TAB_INDEX; --i) {
            CustomOperationPanel oCustomOperationPanel = (CustomOperationPanel)this.getComponentAt(i);
            AbstractCustomOperationTab oCustomTab = oCustomOperationPanel.getCustomTab();
            if (null != oCustomTab) {
                CustomOperationEngine.getInstance().removeCustomOperationListener(oCustomTab);
                oCustomOperationPanel.removeAll();
                oCustomOperationPanel.disposePanel();
            }
            this.removeTabAt(i);
        }
    }

    public synchronized void notifyEvent(DeviceSelectionEvent eventObject) {
        if (null == eventObject) {
            return;
        }
        int[] iSelDevIDs = eventObject.getSelectedDevIds();
        if (null != iSelDevIDs) {
            int iSelectRowCount = 0;
            iSelectRowCount = iSelDevIDs.length;
            if (iSelectRowCount > 1 || iSelectRowCount == 0) {
                this.removeCustomTab();
                this.enableAllTabs(false);
                if (null != this.m_oBackupInfoPanel) {
                    this.m_oBackupInfoPanel.removeAllComponent();
                    this.m_oBackupInfoPanel.updateUI();
                }
                if (null != this.m_oBoardInfoPanel) {
                    this.m_oBoardInfoPanel.removeAllComponent();
                    this.m_oBoardInfoPanel.updateUI();
                }
                return;
            }
        }
        if (eventObject instanceof DeviceSelectionEvent) {
            DeviceSelectionEvent oEventObject = eventObject;
            if (null == oEventObject.getSelectedDevIds()) {
                this.removeCustomTab();
                this.enableAllTabs(false);
                if (null != this.m_oBackupInfoPanel) {
                    this.m_oBackupInfoPanel.removeAllComponent();
                    this.m_oBackupInfoPanel.updateUI();
                }
                if (null != this.m_oBoardInfoPanel) {
                    this.m_oBoardInfoPanel.removeAllComponent();
                    this.m_oBoardInfoPanel.updateUI();
                }
                return;
            }
            if (2 == oEventObject.getEventType()) {
                if (this.BACKUP_FILE_INFO_TAB_INDEX == this.getSelectedIndex()) {
                    this.selectTabAtIndex(this.BACKUP_FILE_INFO_TAB_INDEX, false);
                }
                return;
            }
        }
        this.iSelectedTab = DeviceInfoTabChangeListener.getSelectedTabIndex();
        this.enableAllTabs(true);
        this.removeCustomTab();
        this.addCustomOpTab();
        boolean isRemoveTableInfo = false;
        if (null != eventObject.getSource() && eventObject.getSource() instanceof JSortTreeTable) {
            JSortTreeTable table = (JSortTreeTable)((Object)eventObject.getSource());
            if (table.getRowCount() == 0) {
                table.clearSelection();
                DCDebugTracer.trace("DC::DeviceInfoTabPanel.notifyEvent(table.getRowCount( ) == 0)");
                this.enableAllTabs(false);
                isRemoveTableInfo = true;
            } else if (table.getSelectedRowCount() != 1) {
                DCDebugTracer.trace("DC::DeviceInfoTabPanel.notifyEvent(table.getSelectedRowCount( ) != 1)");
                this.enableAllTabs(false);
                isRemoveTableInfo = true;
            }
        } else if (null == this.m_iSelectedDevIDs || 0 == this.m_iSelectedDevIDs.length) {
            if (null == this.m_iSelectedDevIDs) {
                DCDebugTracer.trace("DC::DeviceInfoTabPanel.notifyEvent(null == m_iSelectedDevIDs)");
            } else {
                DCDebugTracer.trace("DC::DeviceInfoTabPanel.notifyEvent(m_iSelectedDevIDs.length = " + this.m_iSelectedDevIDs.length + ")");
            }
            this.enableAllTabs(false);
            isRemoveTableInfo = true;
        } else if (this.m_iSelectedDevIDs.length != 1) {
            DCDebugTracer.trace("DC::DeviceInfoTabPanel.notifyEvent(m_iSelectedDevIDs.length != 1)");
            this.enableAllTabs(false);
            isRemoveTableInfo = true;
        } else {
            int iSelDevID = this.m_iSelectedDevIDs[0];
            DeviceInfo oDevInfo = DeviceInfoManagerImpl.getInstance().getDevice(iSelDevID);
            if (null != oDevInfo && (StringUtils.isNullOrEmptyStr(oDevInfo.getDevIPAddress()) || DCConstants.UNKNOW_TYPE_ID == oDevInfo.getDeviceTypeInfo().getDevTypeID() && DCConstants.UNKNOW_TYPE_ID == oDevInfo.getDeviceTypeInfo().getDevTypeVersionId())) {
                this.enableAllTabs(false);
                isRemoveTableInfo = true;
            }
        }
        int iDefaultTabToSelect = 0;
        if (!this.isGetBoardVersionSupported(eventObject) && 0 <= this.BOARD_INFO_TAB_INDEX) {
            this.setEnabledAt(this.BOARD_INFO_TAB_INDEX, false);
        }
        if (0 > this.iSelectedTab || this.getTabCount() < this.iSelectedTab + 1) {
            this.selectTabAtIndex(iDefaultTabToSelect, isRemoveTableInfo);
            for (int i = 0; i < this.getTabCount(); ++i) {
                if (!this.isEnabledAt(i)) continue;
                this.selectTabAtIndex(i, isRemoveTableInfo);
                break;
            }
        } else if (!this.isEnabledAt(this.iSelectedTab)) {
            if (DCFrameWorkUtil.getIsSingleClient()) {
                if (!this.isEnabledAt(iDefaultTabToSelect)) {
                    this.selectTabAtIndex(this.iSelectedTab, true);
                } else {
                    this.selectTabAtIndex(iDefaultTabToSelect, isRemoveTableInfo);
                }
            } else {
                for (int i = 0; i < this.getTabCount(); ++i) {
                    this.m_oBackupInfoPanel.onDeviceInfoSelection(this.m_oEvent);
                    if (!this.isEnabledAt(i)) continue;
                    this.selectTabAtIndex(i, isRemoveTableInfo);
                    break;
                }
            }
        } else {
            this.selectTabAtIndex(this.iSelectedTab, isRemoveTableInfo);
        }
    }

    private void selectTabAtIndex(int iTabIndex, boolean isRemoveTableInfo) {
        int iCurrentSelectedIndex = this.getSelectedIndex();
        if (iTabIndex != iCurrentSelectedIndex) {
            if (0 <= iCurrentSelectedIndex) {
                this.setSelectedIndex(iTabIndex);
            }
            return;
        }
        if (this.BOARD_INFO_TAB_INDEX == iTabIndex) {
            if (isRemoveTableInfo) {
                this.m_oBoardInfoPanel.removeAllComponent();
                this.m_oBoardInfoPanel.updateUI();
            } else {
                this.m_oBoardInfoPanel.onDeviceInfoSelection(this.m_oEvent);
            }
        } else if (this.BACKUP_FILE_INFO_TAB_INDEX == iTabIndex) {
            if (isRemoveTableInfo) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DeviceInfoTabPanel.this.m_oBackupInfoPanel.removeAll();
                        DeviceInfoTabPanel.this.m_oBackupInfoPanel.updateUI();
                    }
                });
            } else {
                this.m_iSelectedDevIDs = this.m_oEvent.getSelectedDevIds();
                if (null != this.m_iSelectedDevIDs && 0 == this.m_iSelectedDevIDs.length) {
                    this.setEnabledAt(iTabIndex, false);
                }
                this.m_oBackupInfoPanel.onDeviceInfoSelection(this.m_oEvent);
            }
        }
    }

    private void enableAllTabs(boolean flag) {
        int iTabCount = this.getTabCount();
        for (int index = 0; index < iTabCount; ++index) {
            AbstractCustomOperationTab tabModulObj;
            this.setEnabledAt(index, flag);
            Component deviceInfoObj = this.getComponentAt(index);
            if (!(deviceInfoObj instanceof CustomOperationPanel) || !((tabModulObj = ((CustomOperationPanel)deviceInfoObj).getCustomTab()) instanceof AbstractCustomOperationTab)) continue;
            tabModulObj.setRefreshBtnState(false);
        }
        if (null != this.m_oBoardInfoPanel && this.iSelectedTab == this.BOARD_INFO_TAB_INDEX) {
            this.m_oBoardInfoPanel.setRefreshBtnStatus(flag);
        }
    }

    public void onTreeInit(DCEventObject oEventObject) {
    }

    private boolean isGetBoardVersionSupported(DeviceSelectionEvent eventObject) {
        int[] iDevIDs = eventObject.getSelectedDevIds();
        if (null == iDevIDs || 0 == iDevIDs.length) {
            return false;
        }
        DeviceInfo oDeviceInfo = DeviceInfoManagerImpl.getInstance().getDevice(eventObject.getSelectedDevIds()[0]);
        if (null == oDeviceInfo) {
            return false;
        }
        IDeviceTypeConfigModel deviceTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDeviceInfo.getDeviceTypeInfo(), this.m_iSelectedDevIDs);
        if (null == deviceTypeConfigModel) {
            return false;
        }
        IOperation oGetBoardOperationObj = deviceTypeConfigModel.getOperationObj(5, 13);
        if (null == oGetBoardOperationObj) {
            return false;
        }
        return ((IOtherOperation)oGetBoardOperationObj).isSupported();
    }

    public void disposePanel() {
        if (null != this.m_oLastSelectedCustomOperationPanel) {
            this.m_oLastSelectedCustomOperationPanel.disposePanel();
            this.m_oLastSelectedCustomOperationPanel = null;
        }
        if (null != this.m_oBoardInfoPanel) {
            this.m_oBoardInfoPanel.disposePanel();
            this.m_oBoardInfoPanel = null;
        }
        if (null != this.m_oBackupInfoPanel) {
            this.m_oBackupInfoPanel.disposePanel();
            this.m_oBackupInfoPanel = null;
        }
        this.removeAll();
    }

    @Override
    public void onDeviceInfoSelection(DeviceSelectionEvent oEvent) {
        this.m_oEvent = oEvent;
        this.m_iSelectedDevIDs = oEvent.getSelectedDevIds();
        this.notifyEvent(oEvent);
    }

    public int[] getSelectedDevIds() {
        return this.m_iSelectedDevIDs;
    }

    public int getBoardInfoTabIndex() {
        return this.BOARD_INFO_TAB_INDEX;
    }

    public int getBackupFileTabIndex() {
        return this.BACKUP_FILE_INFO_TAB_INDEX;
    }

    class CustomOperationPanel
    extends JPanel
    implements IDeviceInfoSelectionListener {
        private static final long serialVersionUID = 8323456802566717551L;
        private ICustomOperationInfo m_oCustomOperationInfo;
        private AbstractCustomOperationTab m_oAbstractCustomOperationTab;
        private Integer m_oSelectedDevice = null;
        private DeviceInfoImp[] m_oDeviceInfo = null;

        CustomOperationPanel() {
        }

        public ICustomOperationInfo getCustomOperationInfo() {
            return this.m_oCustomOperationInfo;
        }

        public void setCustomOperationInfo(ICustomOperationInfo customOperationInfo) {
            this.m_oCustomOperationInfo = customOperationInfo;
        }

        public void setCustomTab(AbstractCustomOperationTab oAbstractCustomOperationTab) {
            this.m_oAbstractCustomOperationTab = oAbstractCustomOperationTab;
            this.m_oSelectedDevice = DeviceInfoTabPanel.this.getSelectedDevID();
            this.m_oDeviceInfo = DeviceInfoTabPanel.this.getDeviceInfo();
        }

        private AbstractCustomOperationTab getCustomTab() {
            return this.m_oAbstractCustomOperationTab;
        }

        private void processSelection() {
            try {
                if (null != DeviceInfoTabPanel.this.m_oLastSelectedCustomOperationPanel && ((DeviceInfoTabPanel)DeviceInfoTabPanel.this).m_oLastSelectedCustomOperationPanel.m_oAbstractCustomOperationTab instanceof AbstractCustomOperationTab) {
                    ((DeviceInfoTabPanel)DeviceInfoTabPanel.this).m_oLastSelectedCustomOperationPanel.m_oAbstractCustomOperationTab.setRefreshBtnState(true);
                }
                if (null != this.m_oAbstractCustomOperationTab && this.m_oAbstractCustomOperationTab.isShowing()) {
                    DeviceInfoTabPanel.this.m_oLastSelectedCustomOperationPanel = this;
                    CustomOperationEngine.getInstance().addCustomOperationListener(this.m_oAbstractCustomOperationTab, this.m_oSelectedDevice);
                    this.m_oAbstractCustomOperationTab.setSelectedDeviceInfo(this.m_oDeviceInfo);
                }
            }
            catch (Exception e) {
                DCDebugTracer.trace(e);
            }
        }

        @Override
        public void onDeviceInfoSelection(DeviceSelectionEvent oEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CustomOperationPanel.this.processSelection();
                }
            });
        }

        public void disposePanel() {
            this.m_oCustomOperationInfo = null;
            this.m_oAbstractCustomOperationTab = null;
            this.m_oSelectedDevice = null;
            if (null != this.m_oDeviceInfo) {
                int length = this.m_oDeviceInfo.length;
                for (int i = 0; i < length; ++i) {
                    this.m_oDeviceInfo[i] = null;
                }
                this.m_oDeviceInfo = null;
            }
        }
    }
}

