/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceview;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.components.devicetreepanel.DeviceTreeButtonInfo;
import com.huawei.dc.common.components.devicetreepanel.DeviceTreePanel;
import com.huawei.dc.common.components.devicetreepanel.DeviceTreeToolBarModel;
import com.huawei.dc.common.components.tree.devicetree.descriptor.MainDeviceTreeDescriptor;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.dcmodule.DataCenterModuleManager;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.MenuUtil;
import com.huawei.dc.devicemanagement.deviceview.DeviceMainPanel;
import com.huawei.dc.deviceoperation.IDeviceOperationManager;
import com.huawei.dc.framework.ObjectStore;
import com.swimap.mdi.ExtendedWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class DeviceOperationPanel
extends ExtendedWindow
implements IDCObjectDeallocator {
    private static final long serialVersionUID = 1L;
    private JSplitPane m_oSplitPane;
    private DeviceTreePanel m_oDeviceTreePanel;
    private DeviceMainPanel m_oRightPanel;
    private DataCenterModuleManager m_oDCModuleMgr;
    private long firstOpenClientTime = System.nanoTime();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.firstOpenClientTime ^ this.firstOpenClientTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceOperationPanel other = (DeviceOperationPanel)obj;
        return this.firstOpenClientTime == other.firstOpenClientTime;
    }

    public DeviceOperationPanel(DataCenterModuleManager dcModuleMgr) {
        this.m_oDCModuleMgr = dcModuleMgr;
        this.jbinit();
        DCObjectDestructor.getInstance().addObjectForDestructor(this);
    }

    @Override
    public void setToNULL() {
        if (null != this.m_oDeviceTreePanel) {
            this.m_oDeviceTreePanel.disposePanel();
            this.m_oDeviceTreePanel = null;
        }
        if (null != this.m_oRightPanel) {
            this.m_oRightPanel.setToNULL();
            this.m_oRightPanel = null;
        }
        this.m_oSplitPane.removeAll();
        this.m_oSplitPane = null;
        this.removeAll();
    }

    private void jbinit() {
        this.addSplitPane();
        this.initDeviceTreePanel();
        this.initDevInfoPanel();
        DeviceInfoManagerImpl.getInstance().getDeviceFromDCServerWithParent(4);
        this.setName("Componenets_DataCenterMainPanel_m_oDeviceOperationPanel");
        this.setTitle(ResourceManager.getInstance().getResString("BACKUP_RECOVER_TAB"));
    }

    private void initDeviceTreePanel() {
        MainDeviceTreeDescriptor oDescriptor = this.generateDefaultTreeDescriptor();
        DeviceTreeToolBarModel oButtonModel = this.generateMainTreeToolBarModel();
        this.m_oDeviceTreePanel = new DeviceTreePanel(oButtonModel, oDescriptor, ResourceManager.getInstance().getResString("DEVICE_TREE_PAN_ROOT_NODE"));
        this.m_oDeviceTreePanel.setMinimumSize(new Dimension(200, 200));
        this.m_oDeviceTreePanel.setPreferredSize(new Dimension(230, 200));
        this.m_oDeviceTreePanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.m_oSplitPane.add((Component)this.m_oDeviceTreePanel, "left");
        DCDebugTracer.trace("before refresh device tree");
        DCDebugTracer.trace("after refresh device tree");
    }

    private void addSplitPane() {
        this.m_oSplitPane = new JSplitPane();
        this.m_oSplitPane.setMinimumSize(new Dimension(285, 77));
        this.m_oSplitPane.setPreferredSize(new Dimension(285, 534));
        this.m_oSplitPane.setAutoscrolls(false);
        this.m_oSplitPane.setToolTipText("");
        this.m_oSplitPane.setContinuousLayout(true);
        this.m_oSplitPane.setOneTouchExpandable(false);
        this.m_oSplitPane.setDividerLocation(200);
        this.m_oSplitPane.setDividerSize(6);
        this.setLayout(new GridLayout());
        this.add(this.m_oSplitPane, null);
    }

    private void initDevInfoPanel() {
        DCDebugTracer.trace("enter into addpaneltosplitpane method");
        IDeviceInfoManager oDeviceInfoManager = DCFrameWorkUtil.getDeviceInfoManager();
        IDeviceOperationManager oDeviceOperationManager = DCFrameWorkUtil.getDeviceOperationManager();
        ObjectStore.getInstance().putObjectInstance("DeviceTreePanel", this.m_oDeviceTreePanel);
        this.m_oRightPanel = new DeviceMainPanel(oDeviceInfoManager, oDeviceOperationManager, this.m_oDeviceTreePanel);
        this.m_oRightPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.m_oRightPanel.setMinimumSize(new Dimension(750, 300));
        this.m_oSplitPane.add((Component)this.m_oRightPanel, "right");
        DCDebugTracer.trace("exit from addpaneltosplitpane method");
        DCHelpManager.getInstance().enableF1HelpKey(this.m_oDeviceTreePanel, "HELP_TOPIC_VIEW_DEVICE_INFORMATION");
    }

    private DeviceTreeToolBarModel generateMainTreeToolBarModel() {
        DeviceTreeToolBarModel oButtonModel = new DeviceTreeToolBarModel();
        if (!DCFrameWorkUtil.getIsSingleClient() || DCFrameWorkUtil.isShowSubMap()) {
            DeviceTreeButtonInfo oSubmapButton = new DeviceTreeButtonInfo(1);
            oButtonModel.addButton(oSubmapButton);
            DeviceTreeButtonInfo oDeviceButton = new DeviceTreeButtonInfo(0);
            oButtonModel.addButton(oDeviceButton);
        }
        oButtonModel.addVerticalSeperator();
        return oButtonModel;
    }

    private MainDeviceTreeDescriptor generateDefaultTreeDescriptor() {
        if (DCFrameWorkUtil.getIsSingleClient()) {
            return new MainDeviceTreeDescriptor(1);
        }
        return new MainDeviceTreeDescriptor(3);
    }

    public JPanel getSelectedTablePanel() {
        if (null != this.m_oRightPanel) {
            return this.m_oRightPanel.getSelectedTablePanel();
        }
        return null;
    }

    public DeviceMainPanel getDeviceMainPanel() {
        return this.m_oRightPanel;
    }

    public void deviceOperationRefresh() {
        DCDebugTracer.trace("method deviceOperationRefresh start ");
        boolean bIsStandAloneClient = DCFrameWorkUtil.getIsSingleClient();
        IDeviceInfoManager deviceInfoManager = DCFrameWorkUtil.getDeviceInfoManager();
        if (null != deviceInfoManager && deviceInfoManager.isBusyInGettingSubmapInfo()) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("INFORM_DEV_BUSY_GETTING_SUBMAP"), ResourceManager.getInstance().getResString("INFO"), 1);
            DCFrameWorkUtil.getToolBarButton("refreshTree").setEnabled(true);
            return;
        }
        if (bIsStandAloneClient && null != DCFrameWorkUtil.getRouterDevInfoPanel()) {
            DCFrameWorkUtil.getRouterDevInfoPanel().stopAllCellEditor();
        }
        if (null != DCFrameWorkUtil.getDeviceTablePanel()) {
            DCFrameWorkUtil.getDeviceTablePanel().openGettingDevProgressDlg(true);
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                int iErrorcode = 0;
                IDeviceInfoManager deviceInfoManager = DCFrameWorkUtil.getDeviceInfoManager();
                DCDebugTracer.trace("method refreshDevices start ");
                iErrorcode = deviceInfoManager.refreshDevices();
                DCDebugTracer.trace("method refreshDevices end.. ");
                if (iErrorcode != 0) {
                    DCDebugTracer.trace("method refreshDevices return value iErrorcode : " + iErrorcode);
                    if (iErrorcode == 99999 || iErrorcode == -1) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("INFORM_DEV_BUSY_GETTING_SUBMAP"), ResourceManager.getInstance().getResString("ERROR"), 0);
                            }
                        });
                        DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(0));
                        return;
                    }
                    if (iErrorcode == 989855797) {
                        DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(0));
                        return;
                    }
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorcode, ResourceManager.getInstance().getResString("REFRESH_DEVICE_ERROR"), 0);
                }
                DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        thread.start();
        DCDebugTracer.trace("method deviceOperationRefresh end");
    }

    public void setHelpKeyValue(String resString) {
        DCHelpManager.getInstance().enableF1HelpKey((Component)((Object)this), resString);
    }

    public void windowActivated() {
        DCDebugTracer.trace("DeviceOperationPanel.windowActivated() start");
        super.windowActivated();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DeviceOperationPanel.this.m_oDCModuleMgr.setToolBarIconVisible(true);
            }
        });
        MenuUtil.enableMenuItem(this.m_oDCModuleMgr.getDataCenterMenu(), "DeviceOperation", false);
        DCFrameWorkUtil.getToolBarButton("showDeviceInfoPan").setEnabled(false);
        DCFrameWorkUtil.getToolBarButton("refreshTree").setEnabled(true);
        if (!DCFrameWorkUtil.getIsSingleClient()) {
            boolean bFinishGetDevAndSubmap = DeviceInfoManagerImpl.getInstance().isFinishGetDevAndSubmapInfo();
            DCFrameWorkUtil.getToolBarButton("refreshTree").setEnabled(bFinishGetDevAndSubmap);
        }
        this.requestFocus();
        DCDebugTracer.trace("DeviceOperationPanel.windowActivated() end");
    }

    public void windowDeactivated() {
        DCDebugTracer.trace("DeviceOperationPanel.windowDeactivated() start");
        super.windowDeactivated();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DeviceOperationPanel.this.m_oDCModuleMgr.setToolBarIconVisible(false);
            }
        });
        MenuUtil.enableMenuItem(this.m_oDCModuleMgr.getDataCenterMenu(), "DeviceOperation", true);
        DCFrameWorkUtil.getToolBarButton("showDeviceInfoPan").setEnabled(true);
        DCDebugTracer.trace("DeviceOperationPanel.windowDeactivated() end");
    }

    public void windowClosed() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DeviceOperationPanel.this.m_oDCModuleMgr.setToolBarIconVisible(false);
            }
        });
        this.m_oDCModuleMgr.closePanel("DeviceInfoPanel");
    }

    public void windowOpened() {
        this.m_oDCModuleMgr.openPanel("DeviceInfoPanel");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DeviceOperationPanel.this.m_oDCModuleMgr.setToolBarIconVisible(true);
            }
        });
        if (!DCFrameWorkUtil.getIsSingleClient()) {
            boolean bFinishGetDevAndSubmap = DeviceInfoManagerImpl.getInstance().isFinishGetDevAndSubmapInfo();
            DCFrameWorkUtil.getToolBarButton("refreshTree").setEnabled(bFinishGetDevAndSubmap);
        }
    }

    public boolean isClosable() {
        if (DCFrameWorkUtil.getIsSingleClient()) {
            return false;
        }
        return !DCFrameWorkUtil.isPluginMode();
    }

    public DeviceTreePanel getM_oDeviceTreePanel() {
        return this.m_oDeviceTreePanel;
    }

    public Rectangle getWindowBounds() {
        return new Rectangle(0, 0, DCConstants.DC_WINDOW_WIDTH, DCConstants.DC_WINDOW_HEIGHT);
    }

    public boolean isMaximizable() {
        return true;
    }
}

