/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceview;

import com.huawei.dc.common.components.devicetreepanel.DeviceTreePanel;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.MenuUtil;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.DeviceInfoTabPanel;
import com.huawei.dc.devicemanagement.deviceview.devicetable.AbstractDeviceTablePanel;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceTablePanel;
import com.huawei.dc.devicemanagement.deviceview.devicetable.devicesearch.DeviceSearchManager;
import com.huawei.dc.devicemanagement.deviceview.devicetable.devicesearch.DeviceSearchPanel;
import com.huawei.dc.devicemanagement.patchmanagement.event.PatchInfoNotifier;
import com.huawei.dc.devicemanagement.patchmanagement.model.PatchDataModel;
import com.huawei.dc.devicemanagement.patchmanagement.view.PatchManagementPanel;
import com.huawei.dc.deviceoperation.IDeviceOperationManager;
import com.huawei.dc.standalone.StandAloneCommonOpr;
import com.huawei.dc.standalone.StandAloneDomainInfo;
import com.huawei.dc.standalone.view.RouterDevInfoPanel;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommForUpModeNotify;
import com.swimap.iview.commstyle.commini.Menu;
import com.swimap.iview.commstyle.commini.MenuItem;
import com.swimap.iview.framework.menumanagement.MenuManager;
import com.swimap.iview.templates.tabbedpane.CloseableTabbedPane;
import com.swimap.iview.templates.tabbedpane.CloseableTabbedPaneListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DeviceMainPanel
extends JPanel
implements IDCObjectDeallocator {
    private static final long serialVersionUID = -6362240146843763697L;
    private int m_helpType = 0;
    private JSplitPane m_oSplitPane;
    private DeviceSearchPanel m_oSearchPanel;
    private JPanel m_oTopPanel;
    private DeviceTablePanel m_oDeviceTablePanel;
    private JPanel m_oDeviceInfoTabbedPanel;
    private IDeviceInfoManager m_oDeviceInfoManager;
    private IDeviceOperationManager m_oDeviceOperationManager;
    private DeviceInfoTabPanel deviceInfoTabbedPane;
    private DeviceTreePanel m_oDeviceTreePanel;
    private CloseableTabbedPane m_oTabbedPane;
    private PatchManagementPanel m_oPatchManagementPanel;
    private CloseableTabbedPaneListener m_oTabCloseListener;
    private RouterDevInfoPanel m_routerDevInfoPanel;
    private int m_iDividerLocation = 300;
    private boolean m_isOpenPatchView = false;
    private static final String ROURTER_TAB_NAME = "router_tab_name";

    public DeviceMainPanel(IDeviceInfoManager oDeviceInfoManager, IDeviceOperationManager oDeviceOperationManager, DeviceTreePanel oDeviceTreePanel) {
        this.m_oDeviceInfoManager = oDeviceInfoManager;
        this.m_oDeviceOperationManager = oDeviceOperationManager;
        this.m_oDeviceTreePanel = oDeviceTreePanel;
        this.jInit();
        DCObjectDestructor.getInstance().addObjectForDestructor(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DeviceMainPanel.this.repaint();
            }
        });
    }

    @Override
    public void setToNULL() {
        if (null != this.m_oTabbedPane) {
            this.remove((Component)this.m_oTabbedPane);
            this.m_oTabbedPane.removeCloseableTabbedPaneListener(this.m_oTabCloseListener);
            this.m_oTabbedPane.removeAll();
            this.m_oTabCloseListener = null;
            this.m_oTabbedPane = null;
        }
        if (null != this.m_oDeviceTablePanel) {
            this.m_oDeviceTablePanel.disposePanel();
            this.m_oDeviceTablePanel = null;
        }
        if (null != this.deviceInfoTabbedPane) {
            this.deviceInfoTabbedPane.disposePanel();
            this.deviceInfoTabbedPane = null;
        }
        if (null != this.m_oSearchPanel) {
            this.m_oSearchPanel.setToNULL();
        }
        this.m_oDeviceInfoManager = null;
        this.m_oSplitPane = null;
        this.m_oSearchPanel = null;
        this.m_oTopPanel = null;
        this.m_oDeviceTablePanel = null;
        this.m_oDeviceInfoTabbedPanel = null;
        this.m_oDeviceOperationManager = null;
        this.m_oDeviceTreePanel = null;
        PatchInfoNotifier.getInstance().removePatchNotificationListener(this.m_oPatchManagementPanel);
        this.m_oPatchManagementPanel = null;
    }

    private void jInit() {
        this.initSplitPane();
        this.initializeTabbedPane();
        if (DCFrameWorkUtil.getIsSingleClient()) {
            if (2 == StandAloneDomainInfo.getInstance().getSelectedDomain()) {
                this.initRouterDevPanel();
            }
            this.initCommonDevPanel(true);
            if (2 == StandAloneDomainInfo.getInstance().getSelectedDomain()) {
                DCFrameWorkUtil.setNEManagement(this.m_routerDevInfoPanel);
            }
            if (null != this.m_routerDevInfoPanel) {
                this.m_routerDevInfoPanel.setIsCurrentPanel(true);
            }
            if (null != this.m_oDeviceTablePanel && 2 == StandAloneDomainInfo.getInstance().getSelectedDomain()) {
                this.m_oDeviceTablePanel.setIsCurrentPanel(false);
            }
            StandAloneCommonOpr.getInstance().updateMainMenu();
        } else {
            this.initCommonDevPanel(false);
        }
        this.initBottomPanel();
        this.initListeners();
        if (null != this.m_oDeviceTablePanel) {
            this.m_oDeviceTablePanel.requestFocusInWindow();
        }
        if (null != this.m_routerDevInfoPanel) {
            this.m_routerDevInfoPanel.updateSelectionState();
        }
        this.requestFocus();
    }

    private void initializeTabbedPane() {
        this.setLayout(new GridLayout());
        this.m_oTabbedPane = new CloseableTabbedPane(){

            public void setSelectedIndex(int index) {
                super.setSelectedIndex(index);
                String strTabTitle = DeviceMainPanel.this.m_oTabbedPane.getTitleAt(DeviceMainPanel.this.m_oTabbedPane.getSelectedIndex());
                if (!ResourceManager.getInstance().getResString("PATCH_MANAGEMENT_TAB_TITLE").equals(strTabTitle)) {
                    DCFrameWorkUtil.getToolBarButton("refreshTree").setEnabled(true);
                } else {
                    DCFrameWorkUtil.getToolBarButton("refreshTree").setEnabled(false);
                }
            }
        };
        this.m_oTabCloseListener = new TabCloseListener();
        this.m_oTabbedPane.addCloseableTabbedPaneListener(this.m_oTabCloseListener);
        this.m_oTabbedPane.setFocusable(false);
        this.m_oSplitPane.add((Component)this.m_oTabbedPane, "top");
        this.add(this.m_oSplitPane);
        this.m_oTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DeviceMainPanel.this.updatePrintMenuItems();
                DeviceMainPanel.this.setHelpKeys();
            }
        });
    }

    private void updatePrintMenuItems() {
        if (0 > this.m_oTabbedPane.getSelectedIndex()) {
            return;
        }
        String strTabTitle = this.m_oTabbedPane.getTitleAt(this.m_oTabbedPane.getSelectedIndex());
        if (ResourceManager.getInstance().getResString("PATCH_MANAGEMENT_TAB_TITLE").equals(strTabTitle)) {
            if (null != this.m_oDeviceInfoTabbedPanel) {
                this.m_iDividerLocation = this.m_oSplitPane.getDividerLocation();
                this.m_oDeviceInfoTabbedPanel.setVisible(false);
            }
            this.m_isOpenPatchView = true;
        } else {
            if (this.m_isOpenPatchView && null != this.m_oDeviceInfoTabbedPanel) {
                this.m_oSplitPane.setDividerLocation(this.m_iDividerLocation);
                this.m_oDeviceInfoTabbedPanel.setVisible(true);
            }
            this.m_isOpenPatchView = false;
            this.m_oTabbedPane.getSelectedIndex();
            Component com = this.m_oTabbedPane.getComponentAt(this.m_oTabbedPane.getSelectedIndex());
            if (ROURTER_TAB_NAME.equals(com.getName())) {
                if (null != this.m_routerDevInfoPanel) {
                    this.m_routerDevInfoPanel.setIsCurrentPanel(true);
                }
                if (null != this.m_oDeviceTablePanel) {
                    this.m_oDeviceTablePanel.setIsCurrentPanel(false);
                }
                this.updateNEMenu(2);
                if (null != this.m_routerDevInfoPanel) {
                    DCFrameWorkUtil.setNEManagement(this.m_routerDevInfoPanel);
                    this.m_routerDevInfoPanel.updateSelectionState();
                }
            } else {
                if (null != this.m_routerDevInfoPanel) {
                    this.m_routerDevInfoPanel.setIsCurrentPanel(false);
                }
                if (null != this.m_oDeviceTablePanel) {
                    this.m_oDeviceTablePanel.setIsCurrentPanel(true);
                }
                if (DCFrameWorkUtil.getIsSingleClient() && 2 == StandAloneDomainInfo.getInstance().getSelectedDomain()) {
                    this.updateNEMenu(3);
                }
                if (null != this.m_oDeviceTablePanel) {
                    DCFrameWorkUtil.setNEManagement(this.m_oDeviceTablePanel);
                    this.m_oDeviceTablePanel.refreshTable();
                    this.m_oDeviceTablePanel.requestFocusInWindow();
                    this.m_oDeviceTablePanel.refreshNEManageMenuStatus();
                }
            }
        }
    }

    private void initListeners() {
        if (null != this.m_oDeviceTablePanel) {
            this.m_oDeviceTablePanel.addDevInfoSelectionListener(this.deviceInfoTabbedPane);
        }
        if (null != this.m_routerDevInfoPanel) {
            this.m_routerDevInfoPanel.addDevInfoSelectionListener(this.deviceInfoTabbedPane);
        }
        TaskAsynCommForUpModeNotify.getInstance();
    }

    private void initCommonDevPanel(boolean isStandalone) {
        Box m_oBoxLayout = Box.createVerticalBox();
        this.m_oTopPanel = new JPanel();
        this.m_oTopPanel.setLayout(new GridLayout());
        this.m_oTopPanel.setName("DeviceManagement_DeviceMainPanel_m_oTopPanel");
        this.m_oDeviceTablePanel = new DeviceTablePanel(this.m_oDeviceInfoManager, this.m_oDeviceOperationManager, this);
        this.m_oDeviceTablePanel.setName("DeviceManagement_DeviceMainPanel_m_oDeviceTablePanel");
        DCFrameWorkUtil.setDeviceTablePanel(this.m_oDeviceTablePanel);
        DCFrameWorkUtil.setNEManagement(this.m_oDeviceTablePanel);
        this.m_oDeviceTablePanel.openGettingDevProgressDlg(false);
        JPanel buttonPane = this.m_oDeviceTablePanel.getButtonPanel();
        this.m_oDeviceTablePanel.createDeviceTableManager(this.m_oDeviceInfoManager, this.m_oDeviceOperationManager);
        this.initializeSearchPanel();
        this.m_oSearchPanel.setMaximumSize(new Dimension(1720, 40));
        m_oBoxLayout.add(this.m_oSearchPanel);
        m_oBoxLayout.add(this.m_oDeviceTablePanel);
        m_oBoxLayout.add(buttonPane);
        this.m_oTopPanel.add(m_oBoxLayout);
        if (isStandalone) {
            int selectedDomain = StandAloneDomainInfo.getInstance().getSelectedDomain();
            if (selectedDomain == 4) {
                this.m_oTabbedPane.addCloseableTab(ResourceManager.getInstance().getResString("OPTIX_PANEL_TAB_NAME"), (Component)this.m_oTopPanel, false);
            } else if (selectedDomain == 3) {
                this.m_oTabbedPane.addCloseableTab(ResourceManager.getInstance().getResString("ACCESS_PANEL_TAB_NAME"), (Component)this.m_oTopPanel, false);
            } else if (selectedDomain == 2) {
                this.m_helpType = 2;
            } else {
                DCDebugTracer.trace("not support the domain(" + selectedDomain + ")");
            }
        } else {
            this.m_oTabbedPane.addCloseableTab(ResourceManager.getInstance().getResString("DEVICE_VIEW"), (Component)this.m_oTopPanel, false);
        }
    }

    private void initRouterDevPanel() {
        if (DCFrameWorkUtil.getIsSingleClient()) {
            this.m_routerDevInfoPanel = new RouterDevInfoPanel(this);
            DCFrameWorkUtil.setNEManagement(this.m_routerDevInfoPanel);
            JPanel routerClosePanel = new JPanel();
            routerClosePanel.setName(ROURTER_TAB_NAME);
            routerClosePanel.setLayout(new BorderLayout());
            this.m_routerDevInfoPanel.setName("com.huawei.dc.devicemanagement.deviceview.m_routerDevInfoPanel");
            DeviceSearchManager oManager = new DeviceSearchManager(this.m_routerDevInfoPanel);
            DeviceSearchPanel oSearchPanel = new DeviceSearchPanel(oManager);
            oSearchPanel.setName("com.huawei.dc.devicemanagement.deviceview.oSearchPanel");
            routerClosePanel.add((Component)oSearchPanel, "North");
            routerClosePanel.add((Component)this.m_routerDevInfoPanel, "Center");
            this.m_oTabbedPane.addCloseableTab(ResourceManager.getInstance().getResString("IP_DOMAIN_DEVICE_PANEL_TAB_NAME"), (Component)routerClosePanel, false);
            if (this.m_routerDevInfoPanel.isRequestFocusEnabled()) {
                DCHelpManager.getInstance().enableF1HelpKey(this.m_oDeviceTreePanel, "HELP_TOPIC_VIEW_DEVICE_INFORMATION");
            }
        }
    }

    private void initBottomPanel() {
        this.m_oDeviceInfoTabbedPanel = new JPanel(new BorderLayout());
        this.m_oDeviceInfoTabbedPanel.setName("DeviceManagement_DeviceMainPanel_m_oDeviceInfoTabbedPanel");
        this.deviceInfoTabbedPane = new DeviceInfoTabPanel();
        this.deviceInfoTabbedPane.setName("DeviceManagement_DeviceMainPanel_deviceInfoTabbedPane");
        this.m_oDeviceInfoTabbedPanel.add(this.deviceInfoTabbedPane);
        JLabel declearLabel = new JLabel();
        declearLabel.setText(ResourceManager.getInstance().getResString("EXEMPT_RESPONSIBILITY_STATEMENT"));
        declearLabel.setToolTipText(ResourceManager.getInstance().getResString("EXEMPT_RESPONSIBILITY_STATEMENT"));
        declearLabel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        declearLabel.setFont(new Font(declearLabel.getFont().getName(), declearLabel.getFont().getStyle(), declearLabel.getFont().getSize() + 2));
        this.m_oDeviceInfoTabbedPanel.add((Component)declearLabel, "South");
        this.m_oSplitPane.add((Component)this.m_oDeviceInfoTabbedPanel, "bottom");
    }

    private void initSplitPane() {
        this.m_oSplitPane = new JSplitPane(0);
        this.m_oSplitPane.setDividerLocation(300);
        this.m_iDividerLocation = this.m_oSplitPane.getDividerLocation();
        this.m_oSplitPane.setDividerSize(6);
        this.m_oSplitPane.setMinimumSize(new Dimension(285, 77));
        this.m_oSplitPane.setPreferredSize(new Dimension(285, 534));
    }

    private void initializeSearchPanel() {
        DeviceSearchManager oManager = new DeviceSearchManager(this.m_oDeviceTablePanel);
        this.m_oSearchPanel = new DeviceSearchPanel(oManager);
        this.m_oSearchPanel.setName("DeviceManagement_DeviceMainPanel_m_oSearchPanel");
    }

    public void openPatchManagement(int[] iSelectedDevIds) {
        if (null == this.m_oPatchManagementPanel) {
            this.m_oPatchManagementPanel = new PatchManagementPanel(this.m_oDeviceTreePanel);
            this.m_oPatchManagementPanel.setName("DeviceManagement_DeviceManinPanel_m_oPatchManagementPanel");
            this.m_oDeviceTreePanel.addDCEventListener(this.m_oPatchManagementPanel);
            this.m_oTabbedPane.addCloseableTab(ResourceManager.getInstance().getResString("PATCH_MANAGEMENT_TAB_TITLE"), (Component)this.m_oPatchManagementPanel, true);
        }
        this.m_oTabbedPane.setSelectedComponent((Component)this.m_oPatchManagementPanel);
        this.m_iDividerLocation = this.m_oSplitPane.getDividerLocation();
        this.m_oDeviceInfoTabbedPanel.setVisible(false);
        DCFrameWorkUtil.getToolBarButton("refreshTree").setEnabled(false);
        this.m_oPatchManagementPanel.getPatchesForSelectedDevices(iSelectedDevIds);
    }

    private void removeComponentAtIndex(int i) {
        Component oComponent = this.m_oTabbedPane.getComponentAt(i);
        this.m_oTabbedPane.remove(i);
        if (oComponent instanceof PatchManagementPanel) {
            DCFrameWorkUtil.getToolBarButton("refreshTree").setEnabled(true);
            this.m_oDeviceTreePanel.removeDCEventListener(this.m_oPatchManagementPanel);
            this.m_oPatchManagementPanel.unregisterForNotifications();
            this.m_oPatchManagementPanel.cleanUp();
            this.m_oPatchManagementPanel = null;
            ((DCObjectDestructor)DCObjectDestructor.getInstance()).removeObjectForDestructor((PatchDataModel)PatchDataModel.getInstance());
            PatchDataModel.getInstance().clearPatches();
            ((PatchDataModel)PatchDataModel.getInstance()).setToNULL();
        }
    }

    public DeviceTreePanel getDeviceTreePanel() {
        return this.m_oDeviceTreePanel;
    }

    public AbstractDeviceTablePanel getDeviceTablePanel() {
        return this.m_oDeviceTablePanel;
    }

    public JPanel getSelectedTablePanel() {
        return (JPanel)this.m_oTabbedPane.getSelectedComponent();
    }

    private void setHelpKeys() {
        if (null != this.m_oPatchManagementPanel && this.m_oTabbedPane.getSelectedComponent() == this.m_oPatchManagementPanel) {
            this.m_oPatchManagementPanel.setHelpKeyValue("HELP_TOPIC_PATCH_MANAGEMENT");
            if (null != this.m_oDeviceTreePanel) {
                DCHelpManager.getInstance().enableF1HelpKey(this.m_oDeviceTreePanel, "HELP_TOPIC_PATCH_MANAGEMENT");
            }
        } else if (null != this.m_oDeviceTreePanel) {
            DCHelpManager.getInstance().enableF1HelpKey(this.m_oDeviceTreePanel, "HELP_TOPIC_VIEW_DEVICE_INFORMATION");
        }
    }

    private void updateNEMenu(int iDomain) {
        MenuManager oMenuManager = DCFrameWorkUtil.getDCMenuManager();
        Menu oNeMenu = oMenuManager.getMenu("neManageMenu", "neManage");
        if (2 == iDomain) {
            MenuUtil.visibleMenuItem(oNeMenu, "AddNewProxyNode", true);
            MenuUtil.visibleMenuItem(oNeMenu, "Seperator1", true);
            MenuUtil.visibleMenuItem(oNeMenu, "ModifyDevice", false);
            MenuUtil.visibleMenuItem(oNeMenu, "ImportDevices", true);
            MenuUtil.visibleMenuItem(oNeMenu, "ExportDevicesTemplate", true);
            MenuUtil.visibleMenuItem(oNeMenu, "ExportCheckItemTemp", true);
            MenuItem addMenuItem = (MenuItem)oNeMenu.getMenuItem("AddDevices");
            if (null != addMenuItem) {
                addMenuItem.setText(ResourceManager.getInstance().getResString("ADD_DEVICE_INSERT_NEW_MENU_TEXT"));
            }
        } else if (3 == iDomain) {
            MenuUtil.visibleMenuItem(oNeMenu, "AddNewProxyNode", false);
            MenuUtil.visibleMenuItem(oNeMenu, "Seperator1", false);
            MenuUtil.visibleMenuItem(oNeMenu, "ModifyDevice", true);
            MenuUtil.visibleMenuItem(oNeMenu, "ImportDevices", false);
            MenuUtil.visibleMenuItem(oNeMenu, "ExportDevicesTemplate", false);
            MenuUtil.visibleMenuItem(oNeMenu, "ExportCheckItemTemp", false);
        }
    }

    public int getM_helpType() {
        return this.m_helpType;
    }

    class TabCloseListener
    implements CloseableTabbedPaneListener {
        private static final int IP_PATCH_TAB_INDEX = 1;
        private static final int BMS_T2k_PATCH_TAB_INDEX = 1;

        TabCloseListener() {
        }

        public void tabClosed(Component component) {
        }

        public boolean tabClosing(Component component) {
            if (DCFrameWorkUtil.getIsSingleClient()) {
                if (2 == StandAloneDomainInfo.getInstance().getSelectedDomain()) {
                    DeviceMainPanel.this.removeComponentAtIndex(1);
                } else {
                    DeviceMainPanel.this.removeComponentAtIndex(1);
                }
            } else {
                DeviceMainPanel.this.removeComponentAtIndex(1);
            }
            return true;
        }
    }
}

