/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.util;

import com.huawei.dc.deviceoperation.util.OperationStatus;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class TableProgressCellRenderer
implements TableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int iRow, int iCol) {
        JLabel label = new JLabel();
        label.setOpaque(true);
        if (value instanceof OperationStatus) {
            OperationStatus operationStatus = (OperationStatus)value;
            if (operationStatus.getIsProgress()) {
                JProgressBar progressBar = new JProgressBar(0, 0, 100);
                progressBar.setString(operationStatus.toString());
                progressBar.setOpaque(true);
                progressBar.setBackground(table.getBackground());
                progressBar.setForeground(new Color(0, 0, 115));
                progressBar.setStringPainted(true);
                progressBar.setValue(operationStatus.getProgress());
                progressBar.setToolTipText(operationStatus.toString());
                return progressBar;
            }
            label.setText(operationStatus.toString());
            label.setToolTipText(operationStatus.toString());
            if (isSelected) {
                label.setBackground(table.getSelectionBackground());
                label.setForeground(table.getSelectionForeground());
            } else {
                label.setBackground(table.getBackground());
                label.setForeground(table.getForeground());
            }
            return label;
        }
        if (isSelected) {
            label.setBackground(table.getSelectionBackground());
            label.setForeground(Color.white);
        } else {
            label.setBackground(table.getBackground());
            label.setForeground(table.getForeground());
        }
        if (null != value) {
            label.setText(value.toString());
            label.setToolTipText(value.toString());
        }
        return label;
    }
}

