/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation;

import com.huawei.dc.common.components.treetable.model.DCTreeTableModel;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.view.JSortTreeTable;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.StartupConfigParam;
import com.swimap.iview.templates.filtertreetable.TreeTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ViewStartupConfigPanel
extends JPanel {
    private static final long serialVersionUID = 2887732600862869892L;
    private StartupConfigParam m_oStartupConfigParam = null;
    private JLabel m_oStartupTypeLabel = null;
    private JTextField m_oStartupTypeTextField = null;
    private JScrollPane m_oScrollPane = null;
    private JSortTreeTable m_oFileTreeTable = null;
    private DCTreeTableModel m_oFileTreeTableModel = null;
    private TreeTableNode m_oRootNode = null;

    public ViewStartupConfigPanel(StartupConfigParam oStartupConfigParam) {
        this.m_oStartupConfigParam = oStartupConfigParam;
        this.jbinit();
    }

    private void jbinit() {
        this.initPanel();
        this.initLabels();
        this.initTextFields();
        if (1 != this.m_oStartupConfigParam.getStartupType()) {
            this.initScrollPane();
        }
    }

    private void initPanel() {
        this.setLayout(new GridBagLayout());
    }

    private void initLabels() {
        this.m_oStartupTypeLabel = new JLabel(DCFrameWorkUtil.getLocalizedString("STARTUP_CONFIG_TYPE_LABEL"));
        this.m_oStartupTypeLabel.setMinimumSize(new Dimension(160, 20));
        this.m_oStartupTypeLabel.setPreferredSize(new Dimension(160, 20));
        this.add((Component)this.m_oStartupTypeLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void initTextFields() {
        this.m_oStartupTypeTextField = new JTextField();
        this.m_oStartupTypeTextField.setMinimumSize(new Dimension(200, 20));
        this.m_oStartupTypeTextField.setPreferredSize(new Dimension(200, 20));
        this.add((Component)this.m_oStartupTypeTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 7), 0, 0));
        this.m_oStartupTypeTextField.setEditable(false);
        String strStartType = "";
        if (1 == this.m_oStartupConfigParam.getStartupType()) {
            strStartType = DCFrameWorkUtil.getLocalizedString("STARTUP_LOAD_FILE");
        } else if (2 == this.m_oStartupConfigParam.getStartupType()) {
            strStartType = DCFrameWorkUtil.getLocalizedString("STARTUP_DEVICE_FILE");
        } else if (3 == this.m_oStartupConfigParam.getStartupType()) {
            strStartType = DCFrameWorkUtil.getLocalizedString("STARTUP_ISSU_FILE");
        }
        this.m_oStartupTypeTextField.setText(strStartType);
    }

    private void initScrollPane() {
        this.m_oScrollPane = new JScrollPane();
        this.m_oScrollPane.setName("TaskMgmt_StartupConfigPanel_oTableScrollPane");
        this.m_oScrollPane.setPreferredSize(new Dimension(356, 260));
        this.m_oScrollPane.setMinimumSize(new Dimension(356, 260));
        this.m_oScrollPane.setViewportView((Component)((Object)this.getTreeTable()));
        this.add((Component)this.m_oScrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.expandAll(this.m_oFileTreeTable.getTree(), new TreePath(this.m_oRootNode), true);
        this.updateTableView();
    }

    private JSortTreeTable getTreeTable() {
        this.createTreeTableModel();
        this.m_oFileTreeTable = new JSortTreeTable(this.m_oFileTreeTableModel);
        this.m_oFileTreeTable.setName("DeviceOperation_RecoverTablePanel_m_oTaskTreeTable");
        this.initializeSelectionSingleModel();
        this.initializeTreeTable();
        this.populateTreeTable();
        return this.m_oFileTreeTable;
    }

    private void populateTreeTable() {
        HashMap<Integer, List<LoadFileInfo>> oHashMap = this.m_oStartupConfigParam.getDeviceLoadFileInfoMap();
        Iterator<Map.Entry<Integer, List<LoadFileInfo>>> oFileInfoItr = oHashMap.entrySet().iterator();
        Integer oDevId = null;
        List<LoadFileInfo> oFileList = null;
        LoadFileInfo oLoadFileInfo = null;
        TreeTableNode oDevNode = null;
        TreeTableNode oFileNode = null;
        Vector<String> oDevRowData = null;
        Vector<String> oFileRowData = null;
        DeviceInfo oDevInfo = null;
        String strResourceInfo = null;
        String strFilePath = null;
        String strContentType = null;
        Map.Entry<Integer, List<LoadFileInfo>> oFileInfoEntry = null;
        while (oFileInfoItr.hasNext()) {
            oFileInfoEntry = oFileInfoItr.next();
            oDevId = oFileInfoEntry.getKey();
            oFileList = oFileInfoEntry.getValue();
            if (null == oFileList || 0 == oFileList.size()) continue;
            oDevRowData = new Vector<String>(3){

                @Override
                public String toString() {
                    return (String)this.elementAt(0);
                }
            };
            oDevInfo = DeviceInfoManagerImpl.getInstance().getDevice(oDevId);
            strResourceInfo = oDevInfo.getDevName() + '(' + oDevInfo.getDevIPAddress() + ')';
            strFilePath = "";
            strContentType = "";
            oDevRowData.add(strResourceInfo);
            oDevRowData.add(strFilePath);
            oDevRowData.add(strContentType);
            oDevNode = new TreeTableNode(oDevRowData);
            this.m_oRootNode.add(oDevNode);
            int iSize = oFileList.size();
            for (int i = 0; i < iSize; ++i) {
                oFileRowData = new Vector<String>(3){

                    @Override
                    public String toString() {
                        return (String)this.elementAt(0);
                    }
                };
                oLoadFileInfo = oFileList.get(i);
                strResourceInfo = "";
                strFilePath = oLoadFileInfo.getFileName();
                strContentType = oLoadFileInfo.getContentType().getStrContentType();
                oFileRowData.add(strResourceInfo);
                oFileRowData.add(strFilePath);
                oFileRowData.add(strContentType);
                oFileNode = new TreeTableNode(oFileRowData);
                oDevNode.add(oFileNode);
            }
        }
    }

    private void createTreeTableModel() {
        String[] strColumnNames = new String[]{ResourceManager.getInstance().getResString("UPGRADE_FEASIBILITY_RESOURCE_NAME"), ResourceManager.getInstance().getResString("TASK_FILE_PATH"), ResourceManager.getInstance().getResString("PROGRAM_SELECTION_CONTENT_TYPE")};
        Class[] arrColumnTypes = new Class[]{TreeTableModel.class, String.class, String.class};
        boolean[] arrSortableColumns = new boolean[]{false, false, false};
        boolean[] arrEditableColumns = new boolean[]{true, false, false};
        this.m_oFileTreeTableModel = new DCTreeTableModel(strColumnNames, arrColumnTypes, arrSortableColumns, arrEditableColumns);
        this.m_oRootNode = this.m_oFileTreeTableModel.getRoot();
    }

    private void initializeSelectionSingleModel() {
        DefaultListSelectionModel oTaskSelection = new DefaultListSelectionModel();
        oTaskSelection.setSelectionMode(0);
        this.m_oFileTreeTable.setSelectionModel(oTaskSelection);
    }

    private void initializeTreeTable() {
        this.m_oFileTreeTable.getTableHeader().setReorderingAllowed(false);
        this.m_oFileTreeTable.getTree().setCellRenderer(new MyCellRenderer());
        this.m_oFileTreeTable.getTree().setToggleClickCount(2);
        this.m_oFileTreeTable.setRowHeight(20);
        this.m_oFileTreeTable.setShowHorizontalLines(true);
        this.m_oFileTreeTable.setShowVerticalLines(false);
        this.m_oFileTreeTable.setColumnSelectionAllowed(false);
        this.m_oFileTreeTable.setRowSelectionAllowed(true);
    }

    public void setCellRenderer(JLabel label, Object value) {
        label.setText(value.toString());
    }

    public void updateTableView() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewStartupConfigPanel.this.m_oFileTreeTable.getTableHeader().updateUI();
                ViewStartupConfigPanel.this.m_oFileTreeTable.updateUI();
                ViewStartupConfigPanel.this.updateUI();
            }
        });
    }

    public void expandAll(JTree tree, TreePath parent, boolean expand) {
        try {
            TreeTableNode node = (TreeTableNode)parent.getLastPathComponent();
            if (node.getChildCount() >= 0) {
                Enumeration<TreeNode> e = node.children();
                while (e.hasMoreElements()) {
                    TreeTableNode n = (TreeTableNode)e.nextElement();
                    TreePath path = parent.pathByAddingChild(n);
                    this.expandAll(tree, path, expand);
                }
            }
            if (expand) {
                tree.expandPath(parent);
            } else {
                tree.collapsePath(parent);
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    class MyCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        private static final long serialVersionUID = -3905322891212088102L;

        MyCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            ViewStartupConfigPanel.this.setCellRenderer(this, value);
            return this;
        }
    }
}

