/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation;

import com.huawei.dc.common.asndatacenter.AsnSAMFileInfo;
import com.huawei.dc.common.asndatacenter.AsnSAMFileInfoLst;
import com.huawei.dc.common.asndatacenter.AsnSAMGetVersionFileLstRsp;
import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.common.util.TaskInfoUtil;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.IUpgradeOperation;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.LoadSoftwareOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.IUpgradeSubOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.PostUpgradeOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.PrepareUpgradeOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.StartupConfigParam;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.StartupConfigSubOprDialog;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.sam.SAMUtil;
import com.huawei.dc.sam.controller.SAMManager;
import com.huawei.dc.sam.model.SAMFileInfo;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.createtask.ValidateISSU;
import com.huawei.dc.taskmgmt.view.modifytask.CopyModifyTaskDialog;
import gnu.trove.THashSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.Collator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class UpgradeOpConfigPanel
extends JPanel {
    private static final long serialVersionUID = -7015908527687057925L;
    private JTable m_oOperationTable = null;
    private DefaultTableModel m_oTableModel = null;
    private JScrollPane m_oScrollPane = null;
    private static final int TABLE_MODEL_OPERATION_ID = 0;
    private static final int TABLE_OPERATION_SELECTION = 0;
    private static final int TABLE_OPERATION_NAME = 1;
    private static final int TABLE_OPERATION_CONFIGURATION = 2;
    private List<IUpgradeSubOperation> m_oSubOperationList = null;
    private List<IUpgradeSubOperation> m_oUpgradeSubOperationList = null;
    private THashSet<Resource> m_oResList = null;
    private ITask m_oTask = null;
    private IUpgradeOperation oUpgradeParent;
    private int contextType = 0;
    private Component oOPerationDlg = null;

    public UpgradeOpConfigPanel(List<IUpgradeSubOperation> oUpgradeSubOperationList, IUpgradeOperation oParent, int context) {
        this.oUpgradeParent = oParent;
        this.m_oSubOperationList = oUpgradeSubOperationList;
        this.m_oUpgradeSubOperationList = (List)CloneUtil.getClone(oUpgradeSubOperationList);
        this.contextType = context;
        this.jbinit();
    }

    private void jbinit() {
        this.initPanel();
        this.initScrollPane();
        this.populateOperationTableData();
    }

    private void initPanel() {
        Border border1 = BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134));
        TitledBorder oTitleBorder = new TitledBorder(border1, DCFrameWorkUtil.getLocalizedString("TASK_DIALOG_BORDER_TITLE"));
        this.setBorder(oTitleBorder);
        GridBagLayout tablePanLayout = new GridBagLayout();
        this.setLayout(tablePanLayout);
    }

    private void initScrollPane() {
        this.m_oScrollPane = new JScrollPane();
        this.m_oScrollPane.setName("TaskMgmt_UpgradeOpConfigPanel_oTableScrollPane");
        this.m_oScrollPane.setPreferredSize(new Dimension(300, 260));
        this.m_oScrollPane.setMinimumSize(new Dimension(300, 260));
        this.m_oScrollPane.setViewportView(this.getOperationTable());
        this.add((Component)this.m_oScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private JTable getOperationTable() {
        Object[] arrcolHeader = new String[]{"TASK_OPERATION_OBJ", "", DCFrameWorkUtil.getLocalizedString("TASK_TABLE_HEADER_OPERATION"), DCFrameWorkUtil.getLocalizedString("TASK_TABLE_HEADER_CONFIGURE_OPERATION")};
        this.m_oTableModel = new DefaultTableModel(arrcolHeader, 0){
            private static final long serialVersionUID = -6319177168985365974L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return 2 != col;
            }
        };
        this.m_oOperationTable = new JTable(this.m_oTableModel);
        this.m_oOperationTable.setName("TaskMgmt_UpgradeOpConfigPanel_m_oOperationTable");
        this.customizeOperationTable();
        this.updateTableForNoOprToBeConfigured();
        return this.m_oOperationTable;
    }

    private void updateTableForNoOprToBeConfigured() {
        int iSupOpLstSize = this.m_oUpgradeSubOperationList.size();
        boolean bConfigColumnNeeded = false;
        for (int i = 0; i < iSupOpLstSize; ++i) {
            IUpgradeSubOperation oUpgradeSubOp = this.m_oUpgradeSubOperationList.get(i);
            if (!oUpgradeSubOp.isConfigReq()) continue;
            bConfigColumnNeeded = true;
            break;
        }
        if (!bConfigColumnNeeded) {
            this.m_oOperationTable.removeColumn(this.m_oOperationTable.getColumnModel().getColumn(2));
        }
    }

    private void customizeOperationTable() {
        this.m_oOperationTable.removeColumn(this.m_oOperationTable.getColumnModel().getColumn(0));
        this.m_oOperationTable.getTableHeader().setReorderingAllowed(false);
        this.m_oOperationTable.setRowHeight(21);
        this.m_oOperationTable.getColumnModel().getColumn(0).setMaxWidth(30);
        this.m_oOperationTable.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.m_oOperationTable.getTableHeader().setPreferredSize(new Dimension(this.m_oOperationTable.getSize().width, 21));
        this.m_oOperationTable.getColumnModel().getColumn(0).setCellRenderer(new SubOperationCheckBoxRenderer());
        this.m_oOperationTable.getColumnModel().getColumn(1).setCellRenderer(new OperationNameRenderer());
        this.m_oOperationTable.getColumnModel().getColumn(2).setCellRenderer(new ConfigOpLinkRenderer());
        this.m_oOperationTable.getColumnModel().getColumn(0).setCellEditor(new SubOperationCheckBoxEditor());
        this.m_oOperationTable.getColumnModel().getColumn(2).setCellEditor(new ConfigOpLinkEditor());
        this.m_oOperationTable.addMouseMotionListener(new OperationTableMouseMotionListener());
        this.m_oOperationTable.addMouseListener(new OperationTableMouseListener());
    }

    public IUpgradeSubOperation getUpgradeSubOperation(String taskDevOpId) {
        IUpgradeSubOperation oUpgradeSubOperation = null;
        int iSize = this.m_oUpgradeSubOperationList.size();
        for (int i = 0; i < iSize; ++i) {
            oUpgradeSubOperation = this.m_oUpgradeSubOperationList.get(i);
            if (Collator.getInstance().equals(oUpgradeSubOperation.getOperationIdString(), taskDevOpId)) break;
            oUpgradeSubOperation = null;
        }
        return oUpgradeSubOperation;
    }

    public void setParentPanel(StartupConfigSubOprDialog oOPerationDlg) {
        oOPerationDlg.setParentPanel(this);
    }

    public void updateOperationTableData() {
        if (!TaskInfoUtil.bContainV8Dev(this.m_oTask)) {
            return;
        }
        this.m_oOperationTable.removeAll();
        ITaskDeviceOperation oTaskActOpr = TaskInfoUtil.getTaskOperation(this.m_oTask, 8);
        if (null != oTaskActOpr) {
            ActivationConfigPara oActivationConfigPara = (ActivationConfigPara)oTaskActOpr.getConfiguredPara();
            ITaskDeviceOperation oTaskPreUpgrade = TaskInfoUtil.getTaskOperation(this.m_oTask, 32);
            if (oActivationConfigPara.isSelISSU()) {
                int index;
                ITaskDeviceOperation oTaskLoadSoftware = TaskInfoUtil.getTaskOperation(this.m_oTask, 6);
                if (oTaskLoadSoftware instanceof LoadSoftwareOperation && oTaskPreUpgrade instanceof PrepareUpgradeOperation) {
                    PrepareUpgradeOperation oPreOper = (PrepareUpgradeOperation)oTaskPreUpgrade;
                    oPreOper.setEnabled(!oTaskLoadSoftware.isSelected());
                    this.refreshTable();
                }
                if ((index = this.bContainUpPatch()) >= 0) {
                    this.m_oTableModel.getDataVector().remove(index);
                }
            } else {
                oTaskPreUpgrade.setEnabled(true);
                Vector<Object> oRowDataVector = null;
                String oOPerationId = null;
                for (int i = 0; i < this.m_oUpgradeSubOperationList.size(); ++i) {
                    oRowDataVector = new Vector<Object>(10);
                    IUpgradeSubOperation oCloneUpgradeSubOp = this.m_oUpgradeSubOperationList.get(i);
                    oOPerationId = oCloneUpgradeSubOp.getOperationIdString();
                    if (!(this.oUpgradeParent instanceof PostUpgradeOperation) || !oOPerationId.equals("UpgradePatch") || this.bContainUpPatch() >= 0) continue;
                    oRowDataVector.add(oOPerationId);
                    oRowDataVector.add(oCloneUpgradeSubOp.isSelected());
                    oRowDataVector.add(oCloneUpgradeSubOp.getOperationName());
                    oRowDataVector.add(oCloneUpgradeSubOp.getOperationDesc());
                    this.m_oTableModel.addRow(oRowDataVector);
                }
            }
            this.refreshTable();
        }
    }

    private int bContainUpPatch() {
        Vector<Vector> oVct = this.m_oTableModel.getDataVector();
        Vector oRowVector = null;
        int index = -1;
        for (int i = 0; i < oVct.size(); ++i) {
            oRowVector = oVct.get(i);
            if (!oRowVector.get(0).toString().equals("UpgradePatch")) continue;
            index = i;
        }
        return index;
    }

    public void populateOperationTableData() {
        this.m_oOperationTable.removeAll();
        int iSupOpLstSize = this.m_oUpgradeSubOperationList.size();
        Vector<Object> oRowDataVector = null;
        String oOPerationId = null;
        for (int i = 0; i < iSupOpLstSize; ++i) {
            oRowDataVector = new Vector<Object>(10);
            IUpgradeSubOperation oCloneUpgradeSubOp = this.m_oUpgradeSubOperationList.get(i);
            IUpgradeSubOperation oUpgradeSubOp = this.m_oSubOperationList.get(i);
            oOPerationId = oCloneUpgradeSubOp.getOperationIdString();
            if (this.oUpgradeParent instanceof PostUpgradeOperation) {
                if (this.oUpgradeParent.isSelected()) {
                    oRowDataVector.add(oOPerationId);
                    oRowDataVector.add(oCloneUpgradeSubOp.isSelected());
                    oRowDataVector.add(oCloneUpgradeSubOp.getOperationName());
                    oRowDataVector.add(oCloneUpgradeSubOp.getOperationDesc());
                } else {
                    oRowDataVector.add(oOPerationId);
                    if ("UpdatePackage".equals(oOPerationId)) {
                        oCloneUpgradeSubOp.setSelected(true);
                        oUpgradeSubOp.setSelected(true);
                        oRowDataVector.add(oCloneUpgradeSubOp.isSelected());
                    } else {
                        oCloneUpgradeSubOp.setSelected(false);
                        oUpgradeSubOp.setSelected(false);
                        oRowDataVector.add(oCloneUpgradeSubOp.isSelected());
                    }
                    oRowDataVector.add(oCloneUpgradeSubOp.getOperationName());
                    oRowDataVector.add(oCloneUpgradeSubOp.getOperationDesc());
                }
            } else {
                oRowDataVector.add(oOPerationId);
                oRowDataVector.add(oCloneUpgradeSubOp.isSelected());
                oRowDataVector.add(oCloneUpgradeSubOp.getOperationName());
                oRowDataVector.add(oCloneUpgradeSubOp.getOperationDesc());
            }
            this.m_oTableModel.addRow(oRowDataVector);
        }
    }

    public boolean validateOpConfig() {
        boolean bValidationResult = true;
        boolean bl = bValidationResult = this.isAnySubOperationSelected() && this.isOperationsConfigured();
        if (bValidationResult) {
            this.m_oSubOperationList.clear();
            this.m_oSubOperationList.addAll(this.m_oUpgradeSubOperationList);
        }
        return bValidationResult;
    }

    public void refreshTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null != UpgradeOpConfigPanel.this.m_oOperationTable) {
                    UpgradeOpConfigPanel.this.m_oOperationTable.updateUI();
                }
            }
        });
    }

    private boolean isAnySubOperationSelected() {
        int iSupOpLstSize = this.m_oUpgradeSubOperationList.size();
        boolean bAnySubOprSelected = false;
        for (int i = 0; i < iSupOpLstSize; ++i) {
            IUpgradeSubOperation oUpgradeSubOp = this.m_oUpgradeSubOperationList.get(i);
            if (!oUpgradeSubOp.isSelected()) continue;
            bAnySubOprSelected = true;
            break;
        }
        if (!bAnySubOprSelected) {
            if (this.oUpgradeParent instanceof PrepareUpgradeOperation) {
                DCOptionPane.showMessageDialog((Component)this, DCFrameWorkUtil.getLocalizedString("PREPARE_UPGRADE_SELECT_ANY_OPERATION"), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
            } else {
                DCOptionPane.showMessageDialog((Component)this, DCFrameWorkUtil.getLocalizedString("POST_UPGRADE_SELECT_ANY_OPERATION"), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
            }
        }
        return bAnySubOprSelected;
    }

    private boolean isOperationsConfigured() {
        int iSupOpLstSize = this.m_oUpgradeSubOperationList.size();
        boolean bOprConfigured = true;
        for (int i = 0; i < iSupOpLstSize; ++i) {
            IUpgradeSubOperation oUpgradeSubOp = this.m_oUpgradeSubOperationList.get(i);
            if (!oUpgradeSubOp.isSelected() || !oUpgradeSubOp.isConfigReq() || null != oUpgradeSubOp.getUpgradeSubOperationConfig()) continue;
            this.showMessageForNotConfigOpr(oUpgradeSubOp);
            break;
        }
        return bOprConfigured;
    }

    private void showMessageForNotConfigOpr(IUpgradeSubOperation oUpgradeSubOp) {
        if (Collator.getInstance().equals(oUpgradeSubOp.getOperationIdString(), "StartupConfig")) {
            StartupConfigParam oStartupConfigParam = new StartupConfigParam();
            oStartupConfigParam.setParaList(oUpgradeSubOp.getoPerationParaList());
            oUpgradeSubOp.setUpgradeSubOperationConfig(oStartupConfigParam);
        }
    }

    public THashSet<Resource> getResList() {
        return this.m_oResList;
    }

    public void setResList(THashSet<Resource> oResList) {
        this.m_oResList = oResList;
    }

    public void updateDataModel() {
        this.m_oSubOperationList.clear();
        this.m_oSubOperationList.addAll(this.m_oUpgradeSubOperationList);
    }

    public void setParentTask(ITask oTask) {
        this.m_oTask = oTask;
    }

    private boolean checkSelectedLoadFiles(IUpgradeSubOperation oUpgradeSubOpr) {
        boolean bRetVal = true;
        if (null != TaskInfoUtil.getTaskOperation(this.m_oTask, 33) && TaskInfoUtil.getTaskOperation(this.m_oTask, 33).isSelected()) {
            if (Collator.getInstance().equals(oUpgradeSubOpr.getOperationIdString(), "UpgradePatch") && !oUpgradeSubOpr.isSelected()) {
                boolean bSelTargetVer;
                ITaskDeviceOperation oLoadSWOpr = TaskInfoUtil.getTaskOperation(this.m_oTask, 6);
                if (!oLoadSWOpr.isSelected()) {
                    int iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("UPDATE_PATCH_DEPEND_ON_LOAD_CONFIRM"), DCFrameWorkUtil.getLocalizedString("CONFIRM"), 0);
                    if (0 != iConfirm) {
                        return false;
                    }
                    oLoadSWOpr.setSelected(true);
                    if (this.contextType == 1) {
                        CopyModifyTaskDialog.setTableSelectPanel();
                        return true;
                    }
                }
                if (bRetVal = TaskInfoUtil.isFileSelectedForContentType(this.m_oTask, "PATCH")) {
                    return bRetVal;
                }
                String sTargetVersion = this.m_oTask.getTargetVersion();
                boolean bl = bSelTargetVer = !StringUtils.isNullOrEmptyStr(sTargetVersion);
                if (bSelTargetVer && !bRetVal) {
                    boolean bContainsPathInSam = false;
                    DeviceType oDevType = this.m_oTask.getDeviceType();
                    DeviceTypeInfo oDevTypeInfo = DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfo(oDevType.getDeviceTypeID(), oDevType.getDeviceTypeVersionID());
                    SAMFileInfo oSAMFileInfo = new SAMFileInfo();
                    oSAMFileInfo.setDeviceTypeInfo(oDevTypeInfo);
                    oSAMFileInfo.setVersion(sTargetVersion);
                    AsnSAMGetVersionFileLstRsp oAsnSAMGetVersionFileLstRsp = SAMManager.getInstance().getAsnSAMDeviceVersionFileReq(oSAMFileInfo);
                    int[] iDeviceIdLst = TaskInfoUtil.getTaskDeviceIdLst(this.m_oTask, oDevTypeInfo);
                    List oLoadPatchContentTypeLst = DeviceXMLConfigModel.getInstance().getContentTypesFromXMLConfig(oDevTypeInfo, 9, iDeviceIdLst);
                    if (null != oLoadPatchContentTypeLst && null != oAsnSAMGetVersionFileLstRsp) {
                        AsnSAMFileInfoLst oAsnFileLst = oAsnSAMGetVersionFileLstRsp.oAsnSAMFileInfoLst;
                        for (int i = 0; i < oAsnFileLst.size(); ++i) {
                            AsnSAMFileInfo oAsnFileInfo = (AsnSAMFileInfo)oAsnFileLst.get(i);
                            SAMUtil.getInstance();
                            ContentType oContentType = SAMUtil.getFileTypeObj(oDevTypeInfo, oAsnFileInfo.iFileType.intValue());
                            if (!oLoadPatchContentTypeLst.contains(oContentType)) continue;
                            bContainsPathInSam = true;
                            break;
                        }
                    }
                    if (!bContainsPathInSam) {
                        DCOptionPane.showMessageDialog((Component)this, DCFrameWorkUtil.getLocalizedString("PATCH_FILE_NOT_SELECTED_MESSAGE"), DCFrameWorkUtil.getLocalizedString("WARNING"), 2);
                    }
                }
                ITaskDeviceOperation oLoadOper = TaskInfoUtil.getTaskOperation(this.m_oTask, 6);
                boolean bSelected = oUpgradeSubOpr.isSelected();
                ITaskDeviceOperation oTaskOper = TaskInfoUtil.getTaskOperation(this.m_oTask, 33);
                if (null != oTaskOper) {
                    ((PostUpgradeOperation)oTaskOper).setSelectUpPatch("UpgradePatch", !bSelected);
                }
                if (null != oLoadOper) {
                    if (this.contextType == 1) {
                        int iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("UPDATE_PATCH_DEPEND_ON_LOAD_PATCH_CONFIRM"), DCFrameWorkUtil.getLocalizedString("CONFIRM"), 0);
                        if (0 != iConfirm) {
                            return false;
                        }
                        CopyModifyTaskDialog.setTableSelectPanel();
                    } else {
                        ((LoadSoftwareOperation)oLoadOper).reinitFileSelecion(sTargetVersion, false);
                    }
                }
                if (null != oTaskOper) {
                    ((PostUpgradeOperation)oTaskOper).setSelectUpPatch("UpgradePatch", bSelected);
                }
                oUpgradeSubOpr.setSelected(bSelected);
                boolean isSelPatch = true;
                if (this.contextType != 1) {
                    isSelPatch = TaskInfoUtil.isFileSelectedForContentType(this.m_oTask, "PATCH");
                }
                return isSelPatch;
            }
            if (Collator.getInstance().equals(oUpgradeSubOpr.getOperationIdString(), "ActiveGTL") && !oUpgradeSubOpr.isSelected()) {
                return this.isGTLLicenseFileSelected(oUpgradeSubOpr);
            }
            if (Collator.getInstance().equals(oUpgradeSubOpr.getOperationIdString(), "UpdatePackage") && !oUpgradeSubOpr.isSelected()) {
                ITaskDeviceOperation activeOpe = TaskInfoUtil.getTaskOperation(this.m_oTask, 8);
                bRetVal = activeOpe.isSelected();
                if (!activeOpe.isSelected()) {
                    DCOptionPane.showMessageDialog((Component)this, DCFrameWorkUtil.getLocalizedString("UPDATE_PACKAGE_ACTIVATE_NOT_SELECTED_MESSAGE"), DCFrameWorkUtil.getLocalizedString("WARNING"), 2);
                }
            }
        }
        if (null != TaskInfoUtil.getTaskOperation(this.m_oTask, 32) && TaskInfoUtil.getTaskOperation(this.m_oTask, 32).isSelected()) {
            if (Collator.getInstance().equals(oUpgradeSubOpr.getOperationIdString(), "UpgradeBootROM") && !oUpgradeSubOpr.isSelected()) {
                boolean bl = bRetVal = TaskInfoUtil.isFileSelectedForContentType(this.m_oTask, "PROGRAM") || this.isStartupConfigFileSelectedForContentType(this.m_oTask, "PROGRAM");
                if (!bRetVal) {
                    DCOptionPane.showMessageDialog((Component)this, DCFrameWorkUtil.getLocalizedString("PROGRAM_FILE_NOT_SELECTED_MESSAGE"), DCFrameWorkUtil.getLocalizedString("WARNING"), 2);
                }
            } else if (Collator.getInstance().equals(oUpgradeSubOpr.getOperationIdString(), "StartupConfig") && oUpgradeSubOpr.isSelected() && this.isSubOprForPreUpgradeSelected("UpgradeBootROM") && !(bRetVal = TaskInfoUtil.isFileSelectedForContentType(this.m_oTask, "PROGRAM"))) {
                bRetVal = true;
                this.updatePrepareUpgradeForSubOperation("UpgradeBootROM");
                DCOptionPane.showMessageDialog((Component)this, DCFrameWorkUtil.getLocalizedString("DESELECT_UPGRADE_BOOT_ROM_SUB_OPERTAION"), DCFrameWorkUtil.getLocalizedString("WARNING"), 2);
            }
        }
        return bRetVal;
    }

    private boolean isGTLLicenseFileSelected(IUpgradeSubOperation oUpgradeSubOpr) {
        boolean bRetVal = false;
        if (!TaskInfoUtil.checkGTLLicenseWithISSU(oUpgradeSubOpr, this.m_oTask)) {
            return false;
        }
        ITaskDeviceOperation oLoadSWOpr = TaskInfoUtil.getTaskOperation(this.m_oTask, 6);
        if (!oLoadSWOpr.isSelected()) {
            int iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("UPDATE_GTL_LICENSE_DEPEND_ON_LOAD_CONFIRM"), DCFrameWorkUtil.getLocalizedString("CONFIRM"), 0);
            if (0 != iConfirm) {
                return false;
            }
            oLoadSWOpr.setSelected(true);
            if (this.contextType == 1) {
                CopyModifyTaskDialog.setTableSelectPanel();
                return true;
            }
        }
        if (bRetVal = TaskInfoUtil.isFileSelectedForContentType(this.m_oTask, "GTLLicense")) {
            return bRetVal;
        }
        String sTargetVersion = this.m_oTask.getTargetVersion();
        ITaskDeviceOperation oLoadOper = TaskInfoUtil.getTaskOperation(this.m_oTask, 6);
        boolean bSelected = oUpgradeSubOpr.isSelected();
        ITaskDeviceOperation oTaskOper = TaskInfoUtil.getTaskOperation(this.m_oTask, 33);
        if (null != oTaskOper) {
            ((PostUpgradeOperation)oTaskOper).setSelectUpPatch("ActiveGTL", !bSelected);
        }
        if (null != oLoadOper) {
            if (this.contextType == 1) {
                int iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("UPDATE_GTL_LICENSE_DEPEND_ON_LOAD_GTL_CONFIRM"), DCFrameWorkUtil.getLocalizedString("CONFIRM"), 0);
                if (0 != iConfirm) {
                    return false;
                }
                CopyModifyTaskDialog.setTableSelectPanel();
            } else {
                ((LoadSoftwareOperation)oLoadOper).reinitFileSelecion(sTargetVersion, false);
            }
        }
        if (null != oTaskOper) {
            ((PostUpgradeOperation)oTaskOper).setSelectUpPatch("ActiveGTL", bSelected);
        }
        oUpgradeSubOpr.setSelected(bSelected);
        boolean isSelPatch = true;
        if (this.contextType != 1) {
            isSelPatch = TaskInfoUtil.isFileSelectedForContentType(this.m_oTask, "GTLLicense");
        }
        return isSelPatch;
    }

    public List<IUpgradeSubOperation> getOperationList() {
        return this.m_oUpgradeSubOperationList;
    }

    public boolean isStartupConfigFileSelectedForContentType(ITask oTask, String strContentType) {
        boolean bRetVal = false;
        IUpgradeSubOperation oSubOperation = null;
        int iSizeOfOprLst = this.m_oUpgradeSubOperationList.size();
        for (int j = 0; j < iSizeOfOprLst; ++j) {
            int iStartupType;
            StartupConfigParam oStartupConfigParam;
            oSubOperation = this.m_oUpgradeSubOperationList.get(j);
            if (!Collator.getInstance().equals(oSubOperation.getOperationIdString(), "StartupConfig") || !oSubOperation.isSelected() || null == (oStartupConfigParam = (StartupConfigParam)oSubOperation.getUpgradeSubOperationConfig()) || 2 != (iStartupType = oStartupConfigParam.getStartupType()) && 3 != iStartupType) continue;
            bRetVal = TaskInfoUtil.isFileExistForStartupConfig(oStartupConfigParam, strContentType);
        }
        return bRetVal;
    }

    public void updatePrepareUpgradeForSubOperation(String strSubOpr) {
        IUpgradeSubOperation oSubOperation = null;
        int iSizeOfOprLst = this.m_oUpgradeSubOperationList.size();
        for (int j = 0; j < iSizeOfOprLst; ++j) {
            oSubOperation = this.m_oUpgradeSubOperationList.get(j);
            if (!Collator.getInstance().equals(oSubOperation.getOperationIdString(), strSubOpr)) continue;
            oSubOperation.setSelected(false);
        }
    }

    public boolean isSubOprForPreUpgradeSelected(String strOpr) {
        boolean bRetVal = false;
        IUpgradeSubOperation oSubOperation = null;
        int iSizeOfOprLst = this.m_oUpgradeSubOperationList.size();
        for (int j = 0; j < iSizeOfOprLst; ++j) {
            oSubOperation = this.m_oUpgradeSubOperationList.get(j);
            if (!Collator.getInstance().equals(oSubOperation.getOperationIdString(), strOpr) || !oSubOperation.isSelected()) continue;
            bRetVal = true;
        }
        return bRetVal;
    }

    private IUpgradeSubOperation getSubOperation(String sOperationID) {
        int iSizeOfOprLst = this.m_oUpgradeSubOperationList.size();
        IUpgradeSubOperation oSubOperation = null;
        for (int j = 0; j < iSizeOfOprLst; ++j) {
            oSubOperation = this.m_oUpgradeSubOperationList.get(j);
            if (!Collator.getInstance().equals(oSubOperation.getOperationIdString(), sOperationID)) continue;
            return oSubOperation;
        }
        return oSubOperation;
    }

    private class SubOperationCheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 8325476268815504524L;

        private SubOperationCheckBoxRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable oOpTable, Object value, boolean bIsSelected, boolean bhasFocus, int iRow, int iColumn) {
            String oOperationID = (String)UpgradeOpConfigPanel.this.m_oTableModel.getValueAt(iRow, 0);
            IUpgradeSubOperation oUpgradeSubOperation = UpgradeOpConfigPanel.this.getUpgradeSubOperation(oOperationID);
            this.setHorizontalAlignment(0);
            this.setBackground(oOpTable.getBackground());
            this.setEnabled(true);
            this.setSelected(oUpgradeSubOperation.isSelected());
            return this;
        }
    }

    private class SubOperationCheckBoxEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private static final long serialVersionUID = -6028408129530987973L;
        private JCheckBox m_oSubOprChkBox = new JCheckBox();

        public SubOperationCheckBoxEditor() {
            this.m_oSubOprChkBox.addActionListener(this);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            String oOperationID = (String)UpgradeOpConfigPanel.this.m_oTableModel.getValueAt(row, 0);
            IUpgradeSubOperation oUpgradeSubOperation = UpgradeOpConfigPanel.this.getUpgradeSubOperation(oOperationID);
            this.m_oSubOprChkBox.setName("chk_" + oUpgradeSubOperation.getOperationIdString());
            this.m_oSubOprChkBox.setSelected(oUpgradeSubOperation.isSelected());
            this.m_oSubOprChkBox.setBackground(UpgradeOpConfigPanel.this.m_oOperationTable.getBackground());
            this.m_oSubOprChkBox.setHorizontalAlignment(0);
            return this.m_oSubOprChkBox;
        }

        @Override
        public Object getCellEditorValue() {
            int iSelectedRow = UpgradeOpConfigPanel.this.m_oOperationTable.getSelectedRow();
            String oUpgradeSubOprID = (String)UpgradeOpConfigPanel.this.m_oTableModel.getValueAt(iSelectedRow, 0);
            IUpgradeSubOperation oUpgradeSubOpr = UpgradeOpConfigPanel.this.getUpgradeSubOperation(oUpgradeSubOprID);
            return oUpgradeSubOpr.isSelected();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_oSubOprChkBox.setBackground(UpgradeOpConfigPanel.this.m_oOperationTable.getBackground());
            this.m_oSubOprChkBox.setHorizontalAlignment(0);
            int iSelectedRow = UpgradeOpConfigPanel.this.m_oOperationTable.getSelectedRow();
            String oUpgradeSubOprID = (String)UpgradeOpConfigPanel.this.m_oTableModel.getValueAt(iSelectedRow, 0);
            IUpgradeSubOperation oUpgradeSubOpr = UpgradeOpConfigPanel.this.getUpgradeSubOperation(oUpgradeSubOprID);
            boolean bSuccess = UpgradeOpConfigPanel.this.checkSelectedLoadFiles(oUpgradeSubOpr);
            if (bSuccess) {
                int iConfirmOutput;
                ITaskDeviceOperation oTaskOp;
                ValidateISSU oValidateISSU;
                boolean isSelected;
                boolean bSelected = oUpgradeSubOpr.isSelected();
                boolean bl = isSelected = !bSelected;
                if (bSelected && Collator.getInstance().equals(oUpgradeSubOprID, "UpgradeBootROM")) {
                    String sOperName = oUpgradeSubOpr.getOperationName();
                    String sInfo = ResourceManager.getInstance().getResString("CONFIRM_DESELECT_BOOTROM", new String[]{sOperName});
                    this.fireEditingStopped();
                    int iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), sInfo, ResourceManager.getInstance().getResString("CONFIRM"), 0);
                    if (0 != iConfirm) {
                        isSelected = bSelected;
                    }
                }
                if (!isSelected && DCCommonUtil.isContainsDevTypeID(UpgradeOpConfigPanel.this.m_oTask, 1332) && (oValidateISSU = new ValidateISSU(UpgradeOpConfigPanel.this.m_oTask)).isSelectISSUForATN950() && "".equals(oValidateISSU.getSelectedSoftware())) {
                    DCOptionPane.showMessageDialog((Component)UpgradeOpConfigPanel.this, ResourceManager.getInstance().getResString("CHECK_ISSU_DEPEND_ON_PREPARE_UPGRADE"), ResourceManager.getInstance().getResString("INFORMATION"), 1);
                    boolean bl2 = isSelected = !isSelected;
                }
                if (oUpgradeSubOpr.isSelected() && "StartupConfig".equals(oUpgradeSubOpr.getOperationIdString()) && null != UpgradeOpConfigPanel.this.m_oTask && (oTaskOp = TaskInfoUtil.getTaskOperation(UpgradeOpConfigPanel.this.m_oTask, 6)).isSelected() && 0 != (iConfirmOutput = DCOptionPane.showConfirmDialog((Component)UpgradeOpConfigPanel.this, ResourceManager.getInstance().getResString("DO_NOT_SELECT_STARTUP_CONFIG_PROMPT"), ResourceManager.getInstance().getResString("CONFIRM"), 0))) {
                    isSelected = !isSelected;
                }
                oUpgradeSubOpr.setManualSelect(isSelected);
            }
            if (oUpgradeSubOpr.getOperationIdString().equals("StartupConfig")) {
                TaskInfoUtil.checkLoadSoftwareWithStartupConfig(oUpgradeSubOpr, UpgradeOpConfigPanel.this.m_oTask);
            }
            this.fireEditingStopped();
            UpgradeOpConfigPanel.this.refreshTable();
        }
    }

    private class OperationTableMouseMotionListener
    extends MouseMotionAdapter {
        private OperationTableMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent oMouseEvent) {
            Point oPoint = oMouseEvent.getPoint();
            if (UpgradeOpConfigPanel.this.m_oOperationTable.columnAtPoint(oPoint) == 2) {
                TableCellRenderer oRenderer = UpgradeOpConfigPanel.this.m_oOperationTable.getCellRenderer(UpgradeOpConfigPanel.this.m_oOperationTable.rowAtPoint(oPoint), 2);
                if (oRenderer instanceof ConfigOpLinkRenderer) {
                    if (!Collator.getInstance().equals((String)UpgradeOpConfigPanel.this.m_oOperationTable.getValueAt(UpgradeOpConfigPanel.this.m_oOperationTable.rowAtPoint(oPoint), 2), "")) {
                        Cursor cur = new Cursor(12);
                        DCFrameWorkUtil.setCursor(UpgradeOpConfigPanel.this.getParent(), cur);
                    } else {
                        Cursor cur = new Cursor(0);
                        DCFrameWorkUtil.setCursor(UpgradeOpConfigPanel.this.getParent(), cur);
                    }
                } else {
                    Cursor cur = new Cursor(0);
                    DCFrameWorkUtil.setCursor(UpgradeOpConfigPanel.this.getParent(), cur);
                }
            } else {
                Cursor cur = new Cursor(0);
                DCFrameWorkUtil.setCursor(UpgradeOpConfigPanel.this.getParent(), cur);
            }
        }
    }

    private class OperationTableMouseListener
    extends MouseAdapter {
        private OperationTableMouseListener() {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Cursor cur = new Cursor(0);
            DCFrameWorkUtil.setCursor(UpgradeOpConfigPanel.this.getParent(), cur);
        }
    }

    private class OperationNameRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        private OperationNameRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String oTaskDevOpId = (String)UpgradeOpConfigPanel.this.m_oTableModel.getValueAt(row, 0);
            IUpgradeSubOperation oUpgradeSubOperation = UpgradeOpConfigPanel.this.getUpgradeSubOperation(oTaskDevOpId);
            this.setBackground(UpgradeOpConfigPanel.this.m_oOperationTable.getBackground());
            String strOpName = oUpgradeSubOperation.getOperationName();
            this.setText(strOpName);
            return this;
        }
    }

    private class ConfigOpLinkRenderer
    extends JButton
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        private ConfigOpLinkRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String oTaskDevOpId = (String)UpgradeOpConfigPanel.this.m_oTableModel.getValueAt(row, 0);
            IUpgradeSubOperation oUpgradeSubOperation = UpgradeOpConfigPanel.this.getUpgradeSubOperation(oTaskDevOpId);
            this.setBackground(UpgradeOpConfigPanel.this.m_oOperationTable.getBackground());
            String strOpDesc = oUpgradeSubOperation.getOperationDesc();
            String strOplink = "";
            strOplink = oUpgradeSubOperation.isSelected() ? "<html><a href=\"x\">" + strOpDesc + "</a>" + "</html>" : strOpDesc;
            this.setText(strOplink);
            MatteBorder oMatteBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
            this.setBorder(oMatteBorder);
            this.setHorizontalAlignment(2);
            this.setEnabled(oUpgradeSubOperation.isSelected());
            return this;
        }
    }

    private class ConfigOpLinkEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private static final long serialVersionUID = -4679417598303254962L;
        private String m_iTaskDevOpId = null;
        private JButton m_oLinkButton = new JButton();
        private IUpgradeSubOperation m_iUpgradeSubOperation = null;

        public ConfigOpLinkEditor() {
            this.m_oLinkButton.setBackground(UpgradeOpConfigPanel.this.m_oOperationTable.getBackground());
            this.m_oLinkButton.setRolloverEnabled(true);
            this.m_oLinkButton.addActionListener(this);
        }

        private void updateButtonView() {
            MatteBorder oMatteBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, UpgradeOpConfigPanel.this.m_oOperationTable.getBackground());
            this.m_oLinkButton.setBorder(oMatteBorder);
            this.m_oLinkButton.setBackground(UpgradeOpConfigPanel.this.m_oOperationTable.getBackground());
            String strOplink = "<html><a href=\"x\">" + this.m_iUpgradeSubOperation.getOperationDesc() + "</a>" + "</html>";
            this.m_oLinkButton.setText(strOplink);
            this.m_oLinkButton.setHorizontalAlignment(2);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.m_iTaskDevOpId = (String)UpgradeOpConfigPanel.this.m_oTableModel.getValueAt(row, 0);
            this.m_iUpgradeSubOperation = UpgradeOpConfigPanel.this.getUpgradeSubOperation(this.m_iTaskDevOpId);
            if (!this.m_iUpgradeSubOperation.isSelected()) {
                return null;
            }
            String strOplink = "<html><a href=\"x\">" + this.m_iUpgradeSubOperation.getOperationDesc() + "</a>" + "</html>";
            this.m_oLinkButton.setText(strOplink);
            this.m_oLinkButton.setHorizontalAlignment(2);
            this.m_oLinkButton.setEnabled(this.m_iUpgradeSubOperation.isSelected());
            return this.m_oLinkButton;
        }

        @Override
        public Object getCellEditorValue() {
            return this.m_iUpgradeSubOperation.getOperationDesc();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.m_iUpgradeSubOperation.isSelected()) {
                return;
            }
            if (null == UpgradeOpConfigPanel.this.m_oResList) {
                DCDebugTracer.trace("Resource List is Empty for Startup configuration.");
                return;
            }
            this.m_oLinkButton.setBackground(UpgradeOpConfigPanel.this.m_oOperationTable.getBackground());
            String strOplink = "<html><a href=\"x\">" + this.m_iUpgradeSubOperation.getOperationDesc() + "</a>" + "</html>";
            this.m_oLinkButton.setText(strOplink);
            int iSelectedRow = UpgradeOpConfigPanel.this.m_oOperationTable.getSelectedRow();
            String oTaskDevOpId = (String)UpgradeOpConfigPanel.this.m_oTableModel.getValueAt(iSelectedRow, 0);
            IUpgradeSubOperation oUpgradeSubOperation = UpgradeOpConfigPanel.this.getUpgradeSubOperation(oTaskDevOpId);
            IUpgradeSubOperation oBootroomOper = null;
            if (Collator.getInstance().equals(oUpgradeSubOperation.getOperationIdString(), "StartupConfig")) {
                oBootroomOper = UpgradeOpConfigPanel.this.getSubOperation("UpgradeBootROM");
                UpgradeOpConfigPanel.this.oOPerationDlg = (Component)((Object)new StartupConfigSubOprDialog((THashSet<Resource>)UpgradeOpConfigPanel.this.m_oResList, oUpgradeSubOperation, oBootroomOper, UpgradeOpConfigPanel.this.m_oTask));
                UpgradeOpConfigPanel.this.setParentPanel((StartupConfigSubOprDialog)((Object)UpgradeOpConfigPanel.this.oOPerationDlg));
            }
            if (null != UpgradeOpConfigPanel.this.oOPerationDlg) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UpgradeOpConfigPanel.this.oOPerationDlg.setVisible(true);
                    }
                });
            }
            this.fireEditingStopped();
            this.updateButtonView();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UpgradeOpConfigPanel.this.m_oOperationTable.updateUI();
                }
            });
        }
    }
}

