/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.CodeValue;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.TaskInfoUtil;
import com.huawei.dc.common.util.TaskInfoUtil2;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.IUpgradeOperation;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.IUpgradeSubOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.PrepareUpgradeOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.StartupConfigPanel;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.StartupConfigParam;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.UpgradeOpConfigPanel;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.createtask.ValidateISSU;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.TitledBorder;

public class StartupConfigSubOprDialog
extends DCModalDialog {
    private static final long serialVersionUID = 8763199162033633609L;
    private THashSet<Resource> m_oResourceList = null;
    private IUpgradeSubOperation m_oStartupConfigSubOperation = null;
    private JLabel m_oStartupTypeLabel = null;
    private ComboBoxWithToolTip m_oStartupTypeComboBox = null;
    private DefaultComboBoxModel m_oStartupTypeModel = null;
    private StartupConfigPanel m_oStartupCofigPanel = null;
    private StartupConfigParam m_oStartupConfigParam = null;
    private ContentType oConfigFileType = null;
    private IUpgradeSubOperation m_oBootroomOper = null;
    private ITask m_oTask = null;
    private UpgradeOpConfigPanel m_oParentPanel;
    private int iSelectOldIndex = -1;

    public StartupConfigSubOprDialog(THashSet<Resource> oResList, IUpgradeSubOperation oUpgradeSubOperation, IUpgradeSubOperation oBootroomOper, ITask oTask) {
        this.m_oTask = oTask;
        this.m_oResourceList = oResList;
        this.m_oStartupConfigSubOperation = oUpgradeSubOperation;
        this.m_oBootroomOper = oBootroomOper;
        this.m_oStartupConfigParam = (StartupConfigParam)oUpgradeSubOperation.getUpgradeSubOperationConfig();
        if (null == this.m_oStartupConfigParam) {
            this.m_oStartupConfigParam = new StartupConfigParam();
            this.m_oStartupConfigParam.setParaList(this.m_oStartupConfigSubOperation.getoPerationParaList());
        }
        this.configFileType();
        this.jbinit();
        DCHelpManager.getInstance().enableF1HelpKey(this.getRootPane(), this.getCurrentContext());
    }

    private void configFileType() {
        ContentType[] oContentTypeLst = (ContentType[])this.m_oStartupConfigParam.getContentTypeList();
        int index = this.indexOfConfigFile(oContentTypeLst);
        if (index > 0) {
            this.oConfigFileType = oContentTypeLst[index];
        }
    }

    private int indexOfConfigFile(ContentType[] oContentTypeLst) {
        int index = -1;
        for (int i = oContentTypeLst.length - 1; i >= 0; --i) {
            ContentType oContentType = oContentTypeLst[i];
            if (null == oContentType || !oContentType.getId().equals("CONFIGURATIONFILE")) continue;
            index = i;
            break;
        }
        return index;
    }

    private void jbinit() {
        this.initDialog();
        this.initStartupTypeLabel();
        this.initStartupConfigPanel();
        this.initStartupTypeComboBox();
        this.initButtons();
    }

    private void initDialog() {
        this.setLayout(new GridBagLayout());
        this.setTitle(DCFrameWorkUtil.getLocalizedString("STARTUP_CONFIG_OPR_DLG_TITLE"));
        this.setSize(600, 350);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
    }

    private void initButtons() {
        this.m_oOKBtn.setName("TaskMgmt_StartupConfigSubOprDialog_m_oOKBtn");
        this.m_oOKBtn.setText(DCFrameWorkUtil.getLocalizedString("OK_BTN"));
        this.m_oOKBtn.setPreferredSize(new Dimension(80, 20));
        this.m_oOKBtn.setMinimumSize(new Dimension(80, 20));
        this.m_oCancelBtn.setName("TaskMgmt_StartupConfigSubOprDialog_m_oCancelBtn");
        this.m_oCancelBtn.setText(DCFrameWorkUtil.getLocalizedString("CANCEL_BTN"));
        this.m_oOKBtn.setFocusable(true);
        this.m_oCancelBtn.setFocusable(true);
        this.m_oCancelBtn.setPreferredSize(new Dimension(80, 20));
        this.m_oCancelBtn.setMinimumSize(new Dimension(80, 20));
        this.getContentPane().add((Component)this.m_oCancelBtn, new GridBagConstraints(3, 2, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 10, 10), 0, 0));
        this.getContentPane().add((Component)this.m_oOKBtn, new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 15, 10, 10), 0, 0));
    }

    private void initStartupTypeLabel() {
        this.m_oStartupTypeLabel = new JLabel(DCFrameWorkUtil.getLocalizedString("STARTUP_CONFIG_TYPE_LABEL"));
        this.m_oStartupTypeLabel.setMinimumSize(new Dimension(160, 20));
        this.m_oStartupTypeLabel.setPreferredSize(new Dimension(160, 20));
        this.add(this.m_oStartupTypeLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(10, 10, 0, 0), 0, 0));
    }

    private void initStartupTypeComboBox() {
        CodeValue[] arrStartupType = this.initStartupType();
        this.m_oStartupTypeModel = new DefaultComboBoxModel<CodeValue>(arrStartupType);
        this.m_oStartupTypeComboBox = new ComboBoxWithToolTip((ComboBoxModel)this.m_oStartupTypeModel);
        this.m_oStartupTypeComboBox.setMinimumSize(new Dimension(220, 20));
        this.m_oStartupTypeComboBox.setPreferredSize(new Dimension(220, 20));
        this.add(this.m_oStartupTypeComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.m_oStartupTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                StartupConfigSubOprDialog.this.startupTypeDropDownStateChange();
            }
        });
        if (1 == this.m_oStartupConfigParam.getStartupType()) {
            this.m_oStartupTypeComboBox.setSelectedItem(arrStartupType[0]);
        } else if (2 == this.m_oStartupConfigParam.getStartupType()) {
            this.m_oStartupTypeComboBox.setSelectedItem(arrStartupType[1]);
        } else if (3 == this.m_oStartupConfigParam.getStartupType()) {
            this.m_oStartupTypeComboBox.setSelectedItem(arrStartupType[2]);
        }
        if (null != this.m_oStartupTypeComboBox) {
            this.iSelectOldIndex = this.m_oStartupTypeComboBox.getSelectedIndex();
        }
    }

    private CodeValue[] initStartupType() {
        if (null == this.m_oStartupConfigParam.getStartupTypeList()) {
            DCDebugTracer.trace("StartupConfigSubOprDialog#initStartupType is NULL");
            return null;
        }
        ContentType[] oStartupTypeList = (ContentType[])this.m_oStartupConfigParam.getStartupTypeList();
        CodeValue[] arrStartupType = new CodeValue[oStartupTypeList.length];
        DCDebugTracer.trace("StartupConfigSubOprDialog#StartupTypeList size:" + oStartupTypeList.length);
        block5: for (int i = 0; i < oStartupTypeList.length; ++i) {
            switch (oStartupTypeList[i].getContentTypeCode()) {
                case 1: {
                    arrStartupType[i] = IUpgradeOperation.CODEVALUE_STARTUP_TYPE_LOAD_FILE;
                    continue block5;
                }
                case 2: {
                    arrStartupType[i] = IUpgradeOperation.CODEVALUE_STARTUP_TYPE_DEVICE_FILE;
                    continue block5;
                }
                case 3: {
                    arrStartupType[i] = IUpgradeOperation.CODEVALUE_STARTUP_TYPE_ISSU_FILE;
                    continue block5;
                }
            }
        }
        return arrStartupType;
    }

    protected void startupTypeDropDownStateChange() {
        String strMsg;
        CodeValue oCodeValue = (CodeValue)this.m_oStartupTypeComboBox.getSelectedItem();
        if (1 == oCodeValue.getCode()) {
            ValidateISSU oValidateISSU = new ValidateISSU(this.m_oTask);
            if (!oValidateISSU.checkForRemoveManualAppointedStartupImage()) {
                this.m_oStartupTypeComboBox.setSelectedIndex(1);
            } else {
                this.enableStartupConfigPanel(false);
            }
        }
        if (this.m_oStartupConfigParam.getStartupType() == oCodeValue.getCode()) {
            return;
        }
        TaskInfoUtil.enableLoadSoftwareOpr(this.m_oTask, true);
        if (2 == oCodeValue.getCode()) {
            strMsg = DCFrameWorkUtil.getLocalizedString("ISSU_ACTIVATE_TYPE_NO_ISSU_FILE") + DCFrameWorkUtil.getLocalizedString("BE_CONTINUE");
            if (this.isNeedISSUInActivateType() && this.showConfirmDialog(strMsg) != 0) {
                return;
            }
            this.enableStartupConfigPanel(true);
            this.updateStartupConfigParam(oCodeValue);
        } else if (3 == oCodeValue.getCode()) {
            strMsg = DCFrameWorkUtil.getLocalizedString("NO_ISSU_ACTIVATE_AYPT_ISSU_FILE_WITH_LOADSOFTWARE") + DCFrameWorkUtil.getLocalizedString("BE_CONTINUE");
            if (!this.isSelectPreUpgrade()) {
                strMsg = DCFrameWorkUtil.getLocalizedString("NO_ISSU_ACTIVATE_AYPT_ISSU_FILE") + DCFrameWorkUtil.getLocalizedString("BE_CONTINUE");
            }
            if (this.showConfirmDialog(strMsg) != 0) {
                return;
            }
            this.enableStartupConfigPanel(true);
            this.updateStartupConfigParam(oCodeValue);
            TaskInfoUtil.checkloadSoftwareWithStartupConfig(this.m_oTask);
        }
        this.m_oStartupConfigParam.setStartupType(oCodeValue.getCode());
        this.m_oStartupCofigPanel.refreshTable();
    }

    private boolean isSelectPreUpgrade() {
        boolean bPreUpgradeSelect = false;
        ITaskDeviceOperation oTaskPreUpgrade = TaskInfoUtil.getTaskOperation(this.m_oTask, 32);
        if (oTaskPreUpgrade instanceof PrepareUpgradeOperation) {
            bPreUpgradeSelect = oTaskPreUpgrade.isSelected();
        }
        return bPreUpgradeSelect;
    }

    private int showConfirmDialog(String strMsg) {
        int iConfirm = DCOptionPane.showYesOrNoOptionDialog((Component)((Object)this), strMsg, DCFrameWorkUtil.getLocalizedString("CONFIRM"), 1, false);
        if (0 != iConfirm) {
            this.m_oStartupTypeComboBox.setSelectedIndex(this.m_oStartupConfigParam.getStartupType() - 1);
        }
        return iConfirm;
    }

    private boolean isNeedISSUInActivateType() {
        ActivationOperation m_oTaskDevOPeration;
        ActivationOperation oActivationOpr;
        boolean isISSUInActivateType = false;
        ITaskDeviceOperation oTaskActivate = TaskInfoUtil.getTaskOperation(this.m_oTask, 8);
        if (null != oTaskActivate && oTaskActivate instanceof ActivationOperation && null != (oActivationOpr = (m_oTaskDevOPeration = (ActivationOperation)oTaskActivate)).getActivateConfigPara() && oActivationOpr.getActivateConfigPara().isSelISSU()) {
            isISSUInActivateType = true;
        }
        return isISSUInActivateType;
    }

    private void updateStartupConfigParam(CodeValue oCodeValue) {
        if (this.m_oStartupConfigParam.getStartupType() != oCodeValue.getCode() && null != this.m_oStartupConfigParam.getDeviceLoadFileInfoMap()) {
            this.m_oStartupConfigParam.getDeviceLoadFileInfoMap().clear();
        }
        ContentType[] oContentTypeLst = (ContentType[])this.m_oStartupConfigParam.getContentTypeList();
        if (3 == oCodeValue.getCode() && this.indexOfConfigFile(oContentTypeLst) > 0) {
            Object[] oContentTypeDst = new ContentType[oContentTypeLst.length - 1];
            int j = 0;
            for (int i = 0; i < oContentTypeLst.length - 1; ++i) {
                if (oContentTypeLst[i].getId().equals("CONFIGURATIONFILE")) continue;
                oContentTypeDst[j] = oContentTypeLst[i];
                ++j;
            }
            this.m_oStartupConfigParam.setContentTypeList(oContentTypeDst);
            return;
        }
        if (2 == oCodeValue.getCode() && this.indexOfConfigFile(oContentTypeLst) < 0) {
            Object[] oContentTypeDst = new ContentType[oContentTypeLst.length + 1];
            for (int i = 0; i < oContentTypeLst.length; ++i) {
                oContentTypeDst[i] = oContentTypeLst[i];
            }
            oContentTypeDst[oContentTypeLst.length] = this.oConfigFileType;
            this.m_oStartupConfigParam.setContentTypeList(oContentTypeDst);
            return;
        }
    }

    private void enableStartupConfigPanel(boolean bFlag) {
        this.m_oStartupCofigPanel.setCompEnabled(bFlag);
    }

    private void initStartupConfigPanel() {
        this.m_oStartupCofigPanel = new StartupConfigPanel(this.m_oResourceList, this.m_oTask);
        this.m_oStartupCofigPanel.setStartupConfigParam(this.m_oStartupConfigParam);
        TitledBorder oStartupCofigPanelTitledBorder = new TitledBorder(DCFrameWorkUtil.getLocalizedString("SELECTED_RESOURCE_PANEL_TITLE"));
        this.m_oStartupCofigPanel.setBorder(oStartupCofigPanelTitledBorder);
        this.m_oStartupCofigPanel.setPreferredSize(new Dimension(575, 240));
        this.m_oStartupCofigPanel.setMinimumSize(new Dimension(575, 240));
        this.add(this.m_oStartupCofigPanel, new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
    }

    @Override
    protected String getCurrentContext() {
        int taskTypeId = this.m_oTask.getTaskTypeId();
        String currentContext = "";
        if (0 == taskTypeId) {
            currentContext = "HELP_TOPIC_UPGRADE_PREPARE_BEFORE";
        } else if (1 == taskTypeId) {
            currentContext = "HELP_TOPIC_DOWNGRADE_PREPARE_BEFORE";
        }
        return currentContext;
    }

    @Override
    protected void oKButton_ActionPerformed() {
        CodeValue oCodeValue = (CodeValue)this.m_oStartupTypeComboBox.getSelectedItem();
        int iStartupType = this.setStartupConfigIndex(oCodeValue);
        if (!(2 != iStartupType && 3 != iStartupType || null != this.m_oStartupConfigParam.getDeviceLoadFileInfoMap() && 0 != this.m_oStartupConfigParam.getDeviceLoadFileInfoMap().size())) {
            DCOptionPane.showMessageDialog((Component)((Object)this), DCFrameWorkUtil.getLocalizedString("STARTUP_CONFIG_OPR_ERROR"), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
            return;
        }
        if (1 == iStartupType && !TaskInfoUtil.isFileSelectedForLoad(this.m_oTask)) {
            DCOptionPane.showMessageDialog((Component)((Object)this), DCFrameWorkUtil.getLocalizedString("LOAD_NOT_CONFIGURED_FOR_STARTUP_CONFIG"), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
            return;
        }
        boolean bSelectBootroom = !this.m_oBootroomOper.isSelected();
        this.m_oStartupConfigSubOperation.setUpgradeSubOperationConfig(this.m_oStartupConfigParam);
        TaskInfoUtil2.setUpgradeBootroomSelectState(this.m_oTask, false, bSelectBootroom, (JComponent)((Object)this), this.m_oBootroomOper);
        if (this.m_oParentPanel.isSubOprForPreUpgradeSelected("UpgradeBootROM") && !TaskInfoUtil.isFileSelectedForContentType(this.m_oTask, "PROGRAM") && !TaskInfoUtil.isFileExistForStartupConfig(this.m_oStartupConfigParam, "PROGRAM")) {
            this.m_oParentPanel.updatePrepareUpgradeForSubOperation("UpgradeBootROM");
            DCOptionPane.showMessageDialog((Component)((Object)this), DCFrameWorkUtil.getLocalizedString("DESELECT_UPGRADE_BOOT_ROM_OPERTAION"), DCFrameWorkUtil.getLocalizedString("WARNING"), 2);
        }
        this.iSelectOldIndex = this.m_oStartupTypeComboBox.getSelectedIndex();
        this.dispose();
    }

    private int setStartupConfigIndex(CodeValue oCodeValue) {
        int iStartupType = -1;
        TaskInfoUtil.enableLoadSoftwareOpr(this.m_oTask, true);
        if (1 == oCodeValue.getCode()) {
            iStartupType = 1;
        } else if (2 == oCodeValue.getCode()) {
            iStartupType = 2;
        } else if (3 == oCodeValue.getCode()) {
            TaskInfoUtil.checkloadSoftwareWithStartupConfig(this.m_oTask);
            iStartupType = 3;
        }
        this.m_oStartupConfigParam.setStartupType(iStartupType);
        return iStartupType;
    }

    @Override
    protected void cancelButton_ActionPerformed() {
        this.dispose();
    }

    public void dispose() {
        int iOldIndex = this.iSelectOldIndex;
        if (iOldIndex >= 0) {
            CodeValue oCodeValue = (CodeValue)this.m_oStartupTypeComboBox.getItemAt(iOldIndex);
            this.setStartupConfigIndex(oCodeValue);
        }
        super.dispose();
    }

    public void setParentPanel(UpgradeOpConfigPanel oParentPanel) {
        this.m_oParentPanel = oParentPanel;
    }
}

