/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.SelectStartupDeviceFileDlg;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.StartupConfigParam;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.createtask.ViewCommandResultDialog;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class StartupConfigPanel
extends JPanel {
    private static final long serialVersionUID = 6389939744894240168L;
    private JTable m_oTable = null;
    private DefaultTableModel m_oTableModel = null;
    private JScrollPane m_oScrollPane = null;
    private THashSet<Resource> m_oResourceList = null;
    private static final int TABLE_RESOURCE_NAME = 0;
    private static final int TABLE_RESOURCE_IP = 1;
    private static final int TABLE_RESOURCE_VERSION = 2;
    private static final int TABLE_DEVICE_FILES = 3;
    private static final int TABLE_RESOURCE_OBJ = 4;
    private boolean m_bIsEnable = true;
    private StartupConfigParam m_oStartupConfigParam = null;
    private LoadFileInfoListParam m_oLoadFileInfoListParam = null;
    private DeviceType m_oDeviceType = null;
    private ITask m_oTask = null;
    private static int m_oDeviceId = 0;

    public StartupConfigPanel(THashSet<Resource> oResList, ITask oTask) {
        this.m_oResourceList = oResList;
        this.m_oTask = oTask;
        this.jbinit();
    }

    private void jbinit() {
        this.initPanel();
        this.initScrollPane();
        this.populateTableData();
        this.refreshTable();
    }

    private void populateTableData() {
        this.m_oTable.removeAll();
        Iterator oResItor = this.m_oResourceList.iterator();
        Resource oRes = null;
        Vector<Object> oRowDataVector = null;
        while (oResItor.hasNext()) {
            oRes = (Resource)oResItor.next();
            oRowDataVector = new Vector<Object>(10);
            if (3 == oRes.getRoleType() && -1 != oRes.getStackId()) continue;
            oRowDataVector.add(oRes.getDeviceName());
            oRowDataVector.add(oRes.getDeviceIP());
            oRowDataVector.add(oRes.getDeviceVersion());
            oRowDataVector.add(DCFrameWorkUtil.getLocalizedString("SELECT_FILES_TOOLTIP"));
            oRowDataVector.add(oRes);
            this.m_oTableModel.addRow(oRowDataVector);
        }
    }

    private void initPanel() {
        this.setLayout(new GridBagLayout());
    }

    private void initScrollPane() {
        this.m_oScrollPane = new JScrollPane();
        this.m_oScrollPane.setName("TaskMgmt_StartupConfigPanel_oTableScrollPane");
        this.m_oScrollPane.setPreferredSize(new Dimension(545, 200));
        this.m_oScrollPane.setMinimumSize(new Dimension(545, 200));
        this.m_oScrollPane.setViewportView(this.getOperationTable());
        this.add((Component)this.m_oScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private Component getOperationTable() {
        Object[] arrcolHeader = new String[]{DCFrameWorkUtil.getLocalizedString("DEVICE_TABLE_HEADER_RESOURCE_NAME"), DCFrameWorkUtil.getLocalizedString("DEVICE_TABLE_HEADER_RESOURCE_IP"), DCFrameWorkUtil.getLocalizedString("DEVICE_TABLE_HEADER_RESOURCE_VERSION"), DCFrameWorkUtil.getLocalizedString("STARTUP_CONFIG_DEVICE_FILES"), DCFrameWorkUtil.getLocalizedString("DEVICE_ID")};
        this.m_oTableModel = new DefaultTableModel(arrcolHeader, 0);
        this.m_oTable = new JTable(this.m_oTableModel);
        this.m_oTable.setName("TaskMgmt_StartupConfigPanel_m_oTable");
        this.customizeTable();
        return this.m_oTable;
    }

    private void customizeTable() {
        this.m_oTable.removeColumn(this.m_oTable.getColumnModel().getColumn(4));
        this.m_oTable.getTableHeader().setReorderingAllowed(false);
        this.m_oTable.setRowHeight(21);
        this.m_oTable.getTableHeader().setPreferredSize(new Dimension(this.m_oTable.getSize().width, 21));
        this.m_oTable.getColumnModel().getColumn(0).setCellRenderer(new MyRenderer());
        this.m_oTable.getColumnModel().getColumn(1).setCellRenderer(new MyRenderer());
        this.m_oTable.getColumnModel().getColumn(2).setCellRenderer(new MyRenderer());
        this.m_oTable.getColumnModel().getColumn(3).setCellRenderer(new ConfigOpLinkRenderer());
        this.m_oTable.getColumnModel().getColumn(3).setCellEditor(new ConfigOpLinkEditor());
        this.m_oTable.addMouseMotionListener(new OperationTableMouseMotionListener());
        this.m_oTable.addMouseListener(new OperationTableMouseListener());
    }

    public boolean isCompEnabled() {
        return this.m_bIsEnable;
    }

    public String getLinkColor(int iSelectedRow) {
        String oLinkColor = null;
        Resource oResource = (Resource)this.m_oTableModel.getValueAt(iSelectedRow, 4);
        List<LoadFileInfo> oCurrentFiles = this.m_oLoadFileInfoListParam.getLoadFileInfoList();
        if (null == oCurrentFiles || 0 == oCurrentFiles.size()) {
            return oLinkColor;
        }
        int iCurrentFileCount = oCurrentFiles.size();
        LoadFileInfo oFile = null;
        for (int index = 0; index < iCurrentFileCount; ++index) {
            oFile = oCurrentFiles.get(index);
            if (0 == oFile.getFileSelectionLevel() || 0 == oFile.getDeviceId() || null == oResource || oFile.getDeviceId() != oResource.getDeviceID()) continue;
            oLinkColor = "#800080";
            break;
        }
        return oLinkColor;
    }

    public void setCompEnabled(boolean isEnable) {
        this.m_bIsEnable = isEnable;
    }

    public void refreshTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null != StartupConfigPanel.this.m_oTable) {
                    StartupConfigPanel.this.m_oTable.updateUI();
                }
            }
        });
    }

    public void setStartupConfigParam(StartupConfigParam oStartupConfigParam) {
        this.m_oStartupConfigParam = oStartupConfigParam;
    }

    public void setDeviceLevelLoadConfigParam(LoadFileInfoListParam oLoadSoftwareParam) {
        if (null == oLoadSoftwareParam) {
            return;
        }
        List<LoadFileInfo> LoadFileInfoLst = oLoadSoftwareParam.getLoadFileInfoList();
        if (null == LoadFileInfoLst || LoadFileInfoLst.size() == 0) {
            this.m_oLoadFileInfoListParam = oLoadSoftwareParam;
            return;
        }
        Iterator<LoadFileInfo> iterator = LoadFileInfoLst.iterator();
        while (iterator.hasNext()) {
            LoadFileInfo loadFileInfo = iterator.next();
            if (loadFileInfo.getFileSelectionLevel() != 0) continue;
            iterator.remove();
        }
        this.m_oLoadFileInfoListParam = oLoadSoftwareParam;
    }

    public LoadFileInfoListParam getDeviceLevelLoadConfigParam() {
        return this.m_oLoadFileInfoListParam;
    }

    public DeviceType getDeviceType() {
        return this.m_oDeviceType;
    }

    public void setDeviceType(DeviceType deviceType) {
        this.m_oDeviceType = deviceType;
    }

    public static int getDeviceId() {
        return m_oDeviceId;
    }

    private class MyRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        private MyRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText((String)StartupConfigPanel.this.m_oTable.getValueAt(row, column));
            this.setBackground(StartupConfigPanel.this.m_oTable.getBackground());
            return this;
        }
    }

    private class ConfigOpLinkRenderer
    extends JButton
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        private ConfigOpLinkRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground(StartupConfigPanel.this.m_oTable.getBackground());
            String strOpDesc = DCFrameWorkUtil.getLocalizedString("SELECT_FILES_TOOLTIP");
            String strOplink = "";
            strOplink = StartupConfigPanel.this.isCompEnabled() ? (null != StartupConfigPanel.this.m_oLoadFileInfoListParam ? (null != StartupConfigPanel.this.getLinkColor(row) ? "<html><a href=\"x\"><font color=\"" + StartupConfigPanel.this.getLinkColor(row) + "\">" + strOpDesc + "</font></a>" + "</html>" : "<html><a href=\"x\">" + strOpDesc + "</a>" + "</html>") : "<html><a href=\"x\">" + strOpDesc + "</a>" + "</html>") : strOpDesc;
            this.setText(strOplink);
            MatteBorder oMatteBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
            this.setBorder(oMatteBorder);
            this.setHorizontalAlignment(2);
            this.setEnabled(StartupConfigPanel.this.isCompEnabled());
            return this;
        }
    }

    private class ConfigOpLinkEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private static final long serialVersionUID = -4679417598303254962L;
        private JButton m_oLinkButton = new JButton();
        String m_strOpDesc = null;

        public ConfigOpLinkEditor() {
            this.m_oLinkButton.setBackground(StartupConfigPanel.this.m_oTable.getBackground());
            this.m_oLinkButton.setRolloverEnabled(true);
            this.m_oLinkButton.addActionListener(this);
            this.m_strOpDesc = DCFrameWorkUtil.getLocalizedString("SELECT_FILES_TOOLTIP");
        }

        private void updateButtonView() {
            MatteBorder oMatteBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, StartupConfigPanel.this.m_oTable.getBackground());
            this.m_oLinkButton.setBorder(oMatteBorder);
            this.m_oLinkButton.setBackground(StartupConfigPanel.this.m_oTable.getBackground());
            String strOplink = "<html><a href=\"x\">" + this.m_strOpDesc + "</a>" + "</html>";
            this.m_oLinkButton.setText(strOplink);
            this.m_oLinkButton.setHorizontalAlignment(2);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (!StartupConfigPanel.this.isCompEnabled()) {
                return null;
            }
            String strOplink = "<html><a href=\"x\">" + this.m_strOpDesc + "</a>" + "</html>";
            this.m_oLinkButton.setText(strOplink);
            this.m_oLinkButton.setHorizontalAlignment(2);
            this.m_oLinkButton.setEnabled(StartupConfigPanel.this.isEnabled());
            return this.m_oLinkButton;
        }

        @Override
        public Object getCellEditorValue() {
            return this.m_strOpDesc;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_oLinkButton.setBackground(StartupConfigPanel.this.m_oTable.getBackground());
            String strOplink = "<html><a href=\"x\">" + this.m_strOpDesc + "</a>" + "</html>";
            this.m_oLinkButton.setText(strOplink);
            int iSelectedRow = StartupConfigPanel.this.m_oTable.getSelectedRow();
            Resource oResource = (Resource)StartupConfigPanel.this.m_oTableModel.getValueAt(iSelectedRow, 4);
            m_oDeviceId = oResource.getDeviceID();
            try {
                if (null != StartupConfigPanel.this.m_oStartupConfigParam) {
                    SelectStartupDeviceFileDlg oSelectFileDlg = new SelectStartupDeviceFileDlg(oResource, StartupConfigPanel.this.m_oStartupConfigParam, StartupConfigPanel.this.m_oTask);
                    DCDebugTracer.trace("DC::StartupConfigPanel#SelectStartupDeviceFileDlg::cancleBtn::" + oSelectFileDlg.getcancleBtn());
                    if (oSelectFileDlg.getcancleBtn() || null == oSelectFileDlg.getM_oDeviceFilesMap() || null != oSelectFileDlg.getException()) {
                        DCDebugTracer.trace("DC::StartupConfigPanel#actionPerformed::SelectStartupDeviceFileDlg::cancleBtn::" + oSelectFileDlg.getcancleBtn());
                        DCDebugTracer.trace("DC::StartupConfigPanel#actionPerformed::SelectStartupDeviceFileDlg::isDiolageClose::" + oSelectFileDlg.getException());
                        DCDebugTracer.trace("DC::StartupConfigPanel#actionPerformed::SelectStartupDeviceFileDlg::getM_oDeviceFilesMap::" + oSelectFileDlg.getM_oDeviceFilesMap());
                        oSelectFileDlg.setcancleBtn(false);
                        oSelectFileDlg.doCleanUp();
                        oSelectFileDlg.dispose();
                        oSelectFileDlg = null;
                    } else {
                        oSelectFileDlg.setVisible(true);
                    }
                } else if (null != StartupConfigPanel.this.m_oLoadFileInfoListParam) {
                    SelectStartupDeviceFileDlg oSelectFileDlg = new SelectStartupDeviceFileDlg(oResource, StartupConfigPanel.this.m_oLoadFileInfoListParam, StartupConfigPanel.this.m_oTask);
                    oSelectFileDlg.setTitle(DCFrameWorkUtil.getLocalizedString("SELECT_FILE_FOR_DEVICE_DIALOG_TITLE"));
                    oSelectFileDlg.setVisible(true);
                }
            }
            catch (DCException ex) {
                this.fireEditingStopped();
                this.updateButtonView();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StartupConfigPanel.this.m_oTable.updateUI();
                    }
                });
                DCDebugTracer.traceError(ex.getMessage());
                if (999293081 == ex.getErrorCode()) {
                    ViewCommandResultDialog dialog = new ViewCommandResultDialog(ex.getMessage());
                    dialog.setTitle(DCFrameWorkUtil.getLocalizedString("OPERATION_RESULT"));
                    dialog.getContentTextArea().setLineWrap(true);
                    dialog.setVisible(true);
                }
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ex.getMessage(), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
            }
            this.fireEditingStopped();
            this.updateButtonView();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StartupConfigPanel.this.m_oTable.updateUI();
                }
            });
        }
    }

    private class OperationTableMouseMotionListener
    extends MouseMotionAdapter {
        private OperationTableMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent oMouseEvent) {
            Point oPoint = oMouseEvent.getPoint();
            if (StartupConfigPanel.this.m_oTable.columnAtPoint(oPoint) == 3) {
                TableCellRenderer oRenderer = StartupConfigPanel.this.m_oTable.getCellRenderer(StartupConfigPanel.this.m_oTable.rowAtPoint(oPoint), 3);
                if (oRenderer instanceof ConfigOpLinkRenderer && StartupConfigPanel.this.isCompEnabled()) {
                    Cursor cur = new Cursor(12);
                    DCFrameWorkUtil.setCursor(StartupConfigPanel.this.getParent(), cur);
                } else {
                    Cursor cur = new Cursor(0);
                    DCFrameWorkUtil.setCursor(StartupConfigPanel.this.getParent(), cur);
                }
            } else {
                Cursor cur = new Cursor(0);
                DCFrameWorkUtil.setCursor(StartupConfigPanel.this.getParent(), cur);
            }
        }
    }

    private class OperationTableMouseListener
    extends MouseAdapter {
        private OperationTableMouseListener() {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Cursor cur = new Cursor(0);
            DCFrameWorkUtil.setCursor(StartupConfigPanel.this.getParent(), cur);
        }
    }
}

