/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceDirectory;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceDirectoryList;
import com.huawei.dc.common.asndatacenter.AsnDCGetDeviceFilesRsp;
import com.huawei.dc.common.asndatacenter.AsnDeviceFileList;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.dialog.SimpleProgressDlg;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.view.FileSelectionPanel;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.SelectDeviceFilePanel;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.StartupConfigPanel;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.StartupConfigParam;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.createtask.ViewCommandResultDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class SelectStartupDeviceFileDlg
extends DCModalDialog {
    private static final long serialVersionUID = 7150424400397374530L;
    private Resource m_oResource = null;
    private JLabel m_oResNameLabel = null;
    private JLabel m_oResIPLabel = null;
    private JLabel m_oResVersionLabel = null;
    private JTextField m_oResNameTextField = null;
    private JTextField m_oResIPTextField = null;
    private JTextField m_oResVersionTextField = null;
    private SelectDeviceFilePanel m_oSelectDeviceFilePanel = null;
    private FileSelectionPanel m_oFileSelectionPanel = null;
    private LinkedHashMap<String, List<String>> m_oDeviceFilesMap = null;
    private StartupConfigParam m_oStartupConfigParam = null;
    private LoadFileInfoListParam m_oLoadFileInfoListParam = null;
    private SimpleProgressDlg m_oProgressDlg = null;
    private static boolean isAlive = true;
    private static int m_ThreadDeviceID = 0;
    private DCException exception = null;
    Thread threadForGetFileLst = null;
    private ITask m_oTask = null;
    private boolean m_oCancleBtn = false;

    public SelectStartupDeviceFileDlg(Resource oRes, StartupConfigParam oStartupConfigParam, ITask oTask) throws DCException {
        this.m_oResource = oRes;
        this.m_oStartupConfigParam = oStartupConfigParam;
        this.m_oTask = oTask;
        this.jbinit();
    }

    public SelectStartupDeviceFileDlg(Resource oRes, LoadFileInfoListParam oLoadFileInfoListParam, ITask oTask) throws DCException {
        this.m_oResource = oRes;
        this.m_oLoadFileInfoListParam = oLoadFileInfoListParam;
        this.m_oTask = oTask;
        this.jbinit();
    }

    private void jbinit() throws DCException {
        this.initDialog();
        this.initLabels();
        this.initTextFields();
        this.initButtons();
        if (null != this.m_oStartupConfigParam) {
            this.initProgressDlg();
            this.threadForGetFileLst = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        SelectStartupDeviceFileDlg.this.getDeviceFilesFromServer();
                        DCDebugTracer.trace("DC#SelectStartupDeviceFileDlg#run()" + SelectStartupDeviceFileDlg.this.m_oDeviceFilesMap);
                        isAlive = false;
                    }
                    catch (DCException ex) {
                        SelectStartupDeviceFileDlg.this.exception = ex;
                        if (SelectStartupDeviceFileDlg.this.m_oDeviceFilesMap != null) {
                            SelectStartupDeviceFileDlg.this.m_oDeviceFilesMap = null;
                        }
                        DCDebugTracer.trace(ex);
                        if (999293081 == ex.getErrorCode()) {
                            ViewCommandResultDialog dialog = new ViewCommandResultDialog(ex.getMessage());
                            dialog.setTitle(DCFrameWorkUtil.getLocalizedString("OPERATION_RESULT"));
                            dialog.getContentTextArea().setLineWrap(true);
                            dialog.setVisible(true);
                        } else if (!ResourceManager.getInstance().getResString("SEND_FAIL").equals(ex.getMessage())) {
                            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ex.getMessage(), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
                        }
                        isAlive = false;
                    }
                    finally {
                        SelectStartupDeviceFileDlg.this.stopProgressDlg();
                    }
                }
            });
            DCDebugTracer.trace("DC#SelectStartupDeviceFileDlg#jbinit()#isAlive" + isAlive);
            DCDebugTracer.trace("DC#SelectStartupDeviceFileDlg#jbinit()#StartupConfigPanel.getDeviceId()" + StartupConfigPanel.getDeviceId());
            DCDebugTracer.trace("DC#SelectStartupDeviceFileDlg#jbinit()#m_ThreadDeviceID" + m_ThreadDeviceID);
            if (isAlive && StartupConfigPanel.getDeviceId() == m_ThreadDeviceID) {
                DCDebugTracer.trace("DC#SelectStartupDeviceFileDlg#jbinit()#isAlive" + isAlive);
                DCDebugTracer.trace("DC#SelectStartupDeviceFileDlg#jbinit()#StartupConfigPanel.getDeviceId()" + StartupConfigPanel.getDeviceId());
                DCDebugTracer.trace("DC#SelectStartupDeviceFileDlg#jbinit()#m_ThreadDeviceID" + m_ThreadDeviceID);
            } else {
                this.threadForGetFileLst.setName("selectdevicefilename");
                this.threadForGetFileLst.start();
            }
            this.m_oProgressDlg.setVisible(true);
            if (this.m_oDeviceFilesMap != null) {
                this.initSelectFilePanel();
            }
        } else if (null != this.m_oLoadFileInfoListParam) {
            this.initFileSelectionPanel();
        }
    }

    private void getDeviceFilesFromServer() throws DCException {
        AsnDCGetDeviceFilesRsp oAsnDCGetDeviceFilesRsp = null;
        m_ThreadDeviceID = this.m_oResource.getDeviceID();
        oAsnDCGetDeviceFilesRsp = TaskSyncCommController.getInstance().getDeviceFiles(this.m_oResource.getDeviceID());
        this.m_oDeviceFilesMap = this.getDeviceFileMap(oAsnDCGetDeviceFilesRsp);
    }

    private LinkedHashMap<String, List<String>> getDeviceFileMap(AsnDCGetDeviceFilesRsp oAsnDCGetDeviceFilesRsp) {
        LinkedHashMap<String, List<String>> oFileMap = new LinkedHashMap<String, List<String>>(10);
        ArrayList<String> oFileList = null;
        String strDirectory = null;
        String strFile = null;
        AsnDCDeviceDirectoryList oAsnDCDeviceDirectoryList = oAsnDCGetDeviceFilesRsp.oDeviceDirectoryList;
        int iSize = oAsnDCDeviceDirectoryList.size();
        AsnDCDeviceDirectory oAsnDCDeviceDirectory = null;
        AsnDeviceFileList oAsnDeviceFileList = null;
        for (int i = 0; i < iSize; ++i) {
            oFileList = new ArrayList<String>(0);
            oAsnDCDeviceDirectory = (AsnDCDeviceDirectory)oAsnDCDeviceDirectoryList.get(i);
            strDirectory = new String(oAsnDCDeviceDirectory.strDirectoryName);
            oAsnDeviceFileList = oAsnDCDeviceDirectory.oFileList;
            int iFileSize = oAsnDeviceFileList.size();
            for (int j = 0; j < iFileSize; ++j) {
                strFile = new String((byte[])oAsnDeviceFileList.get(j));
                oFileList.add(strFile);
            }
            oFileMap.put(strDirectory, oFileList);
        }
        return oFileMap;
    }

    private void initDialog() {
        this.setLayout(new GridBagLayout());
        this.setTitle(DCFrameWorkUtil.getLocalizedString("SELECT_DEVICE_FILES"));
        this.setSize(650, 400);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
    }

    private void initLabels() {
        this.m_oResNameLabel = new JLabel(DCFrameWorkUtil.getLocalizedString("DEVICE_TABLE_HEADER_RESOURCE_NAME") + " :");
        this.m_oResNameLabel.setMinimumSize(new Dimension(180, 20));
        this.m_oResNameLabel.setPreferredSize(new Dimension(180, 20));
        this.add(this.m_oResNameLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.m_oResIPLabel = new JLabel(DCFrameWorkUtil.getLocalizedString("DEVICE_TABLE_HEADER_RESOURCE_IP") + " :");
        this.m_oResIPLabel.setMinimumSize(new Dimension(180, 20));
        this.m_oResIPLabel.setPreferredSize(new Dimension(180, 20));
        this.add(this.m_oResIPLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.m_oResVersionLabel = new JLabel(DCFrameWorkUtil.getLocalizedString("DEVICE_TABLE_HEADER_RESOURCE_VERSION") + " :");
        this.m_oResVersionLabel.setMinimumSize(new Dimension(130, 20));
        this.m_oResVersionLabel.setPreferredSize(new Dimension(130, 20));
        this.add(this.m_oResVersionLabel, new GridBagConstraints(4, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(10, 10, 0, 0), 0, 0));
    }

    private void initTextFields() {
        this.m_oResNameTextField = new JTextField(this.m_oResource.getDeviceName());
        this.m_oResNameTextField.setMinimumSize(new Dimension(180, 20));
        this.m_oResNameTextField.setPreferredSize(new Dimension(180, 20));
        this.add(this.m_oResNameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.m_oResNameTextField.setEnabled(false);
        this.m_oResNameTextField.setToolTipText(this.m_oResNameTextField.getText());
        this.m_oResIPTextField = new JTextField(this.m_oResource.getDeviceIP());
        this.m_oResIPTextField.setMinimumSize(new Dimension(180, 20));
        this.m_oResIPTextField.setPreferredSize(new Dimension(180, 20));
        this.add(this.m_oResIPTextField, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.m_oResIPTextField.setEnabled(false);
        this.m_oResIPTextField.setToolTipText(this.m_oResIPTextField.getText());
        this.m_oResVersionTextField = new JTextField(this.m_oResource.getDeviceVersion());
        this.m_oResVersionTextField.setMinimumSize(new Dimension(180, 20));
        this.m_oResVersionTextField.setPreferredSize(new Dimension(180, 20));
        this.add(this.m_oResVersionTextField, new GridBagConstraints(5, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(10, 0, 0, 10), 0, 0));
        this.m_oResVersionTextField.setEnabled(false);
        this.m_oResVersionTextField.setToolTipText(this.m_oResVersionTextField.getText());
    }

    private void initSelectFilePanel() {
        this.m_oSelectDeviceFilePanel = new SelectDeviceFilePanel(this.m_oDeviceFilesMap, this.m_oStartupConfigParam.getContentTypeList(), this.m_oStartupConfigParam.getFileListFromMap(this.m_oResource.getDeviceID()), this.m_oTask);
        TitledBorder oStartupCofigPanelTitledBorder = new TitledBorder(DCFrameWorkUtil.getLocalizedString("SELECT_FILES_TOOLTIP"));
        this.m_oSelectDeviceFilePanel.setBorder(oStartupCofigPanelTitledBorder);
        this.m_oSelectDeviceFilePanel.setPreferredSize(new Dimension(625, 290));
        this.m_oSelectDeviceFilePanel.setMinimumSize(new Dimension(625, 290));
        this.add(this.m_oSelectDeviceFilePanel, new GridBagConstraints(0, 1, 6, 1, 1.0, 1.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
        DCFrameWorkUtil.updateUI((JComponent)((Object)this));
        DCDebugTracer.trace("DC#initSelectFilePanel()#m_oProgressDlg#" + (Object)((Object)this.m_oProgressDlg));
        DCDebugTracer.trace("SelectStartupDeviceFileDlg#initSelectFilePanel()#m_oCancleBtn#" + this.m_oCancleBtn);
        DCDebugTracer.trace("SelectStartupDeviceFileDlg#initSelectFilePanel()#m_oDeviceFilesMap#" + this.getM_oDeviceFilesMap());
    }

    private void initFileSelectionPanel() {
        try {
            this.m_oFileSelectionPanel = new FileSelectionPanel(5, (LoadFileInfoListParam)CloneUtil.getClone(this.m_oLoadFileInfoListParam), this.m_oTask, this.m_oResource);
            int iDeviceDomain = DeviceInfoUtil.getDeviceDomain(this.m_oTask);
            if (null != this.m_oFileSelectionPanel.getFileTreePanel()) {
                this.m_oFileSelectionPanel.getFileTreePanel().setIsDMSDevice(iDeviceDomain == 2);
            }
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog(null, e.getMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
        }
        this.m_oFileSelectionPanel.setPreferredSize(new Dimension(625, 290));
        this.m_oFileSelectionPanel.setMinimumSize(new Dimension(625, 290));
        this.add(this.m_oFileSelectionPanel, new GridBagConstraints(0, 1, 6, 1, 1.0, 1.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
    }

    private void initButtons() {
        this.m_oOKBtn.setName("TaskMgmt_StartupConfigSubOprDialog_m_oOKBtn");
        this.m_oOKBtn.setText(DCFrameWorkUtil.getLocalizedString("OK_BTN"));
        this.m_oOKBtn.setPreferredSize(new Dimension(80, 20));
        this.m_oOKBtn.setMinimumSize(new Dimension(80, 20));
        this.m_oCancelBtn.setName("TaskMgmt_StartupConfigSubOprDialog_m_oCancelBtn");
        this.m_oCancelBtn.setText(DCFrameWorkUtil.getLocalizedString("CANCEL_BTN"));
        this.m_oOKBtn.setFocusable(true);
        this.m_oCancelBtn.setFocusable(true);
        this.m_oCancelBtn.setPreferredSize(new Dimension(80, 20));
        this.m_oCancelBtn.setMinimumSize(new Dimension(80, 20));
        this.getContentPane().add((Component)this.m_oOKBtn, new GridBagConstraints(4, 2, 2, 1, 1.0, 1.0, 17, 0, new Insets(0, 7, 10, 10), 0, 0));
        this.getContentPane().add((Component)this.m_oCancelBtn, new GridBagConstraints(4, 2, 2, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 10, 10), 0, 0));
    }

    @Override
    protected String getCurrentContext() {
        return "";
    }

    @Override
    protected void oKButton_ActionPerformed() {
        if (null != this.m_oStartupConfigParam) {
            this.updateStartupConfig();
        } else if (null != this.m_oLoadFileInfoListParam) {
            this.updateLoadFileInfo();
        }
    }

    private void updateLoadFileInfo() {
        LoadFileInfo[] arrServerFiles = this.m_oFileSelectionPanel.getFileTablePanel().getFilesFromTable();
        int iDevDomain = DeviceInfoManagerImpl.getInstance().getDevice(this.m_oResource.getDeviceID()).getDeviceTypeInfo().getDevDomain();
        for (int count = 0; count < arrServerFiles.length; ++count) {
            if (Collator.getInstance().equals(arrServerFiles[count].getFileName().trim(), "")) {
                this.m_oFileSelectionPanel.getFileTablePanel().getFileTable().setRowSelectionInterval(count, count);
                DCOptionPane.showMessageDialog((Component)((Object)this), DCFrameWorkUtil.getLocalizedString("ENTER_FILE_NAME"), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
                return;
            }
            if (arrServerFiles[count].getFileName().contains(" ") && 2 == iDevDomain) {
                this.m_oFileSelectionPanel.getFileTablePanel().getFileTable().setRowSelectionInterval(count, count);
                DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("BROWSEDLG_SELECT_FILE_BLANK_SPACE"), ResourceManager.getInstance().getResString("ERROR"), 0);
                return;
            }
            if ("".intern().equals(arrServerFiles[count].getContentType().getStrContentType())) {
                this.m_oFileSelectionPanel.getFileTablePanel().getFileTable().setRowSelectionInterval(count, count);
                DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("NO_SELECT_CONTENT_TYPE"), ResourceManager.getInstance().getResString("ERROR"), 0);
                return;
            }
            arrServerFiles[count].setDeviceId(this.m_oResource.getDeviceID());
            arrServerFiles[count].setFileSelectionLevel(1);
        }
        this.m_oLoadFileInfoListParam.removeFileInfoByDevID(this.m_oResource.getDeviceID());
        this.m_oLoadFileInfoListParam.addServerFiles(arrServerFiles);
        this.dispose();
    }

    private void updateStartupConfig() {
        List<LoadFileInfo> oFileList = this.m_oSelectDeviceFilePanel.getFilesFromTable();
        if (null == oFileList) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("NO_File_SELECTED"), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        int iSlaveCCFileCount = 0;
        int iMasterCCFileCount = 0;
        int iSlavePatchFileCount = 0;
        int iMasterPatchFileCount = 0;
        for (int count = 0; count < oFileList.size(); ++count) {
            LoadFileInfo fileInfo;
            String sContentType = oFileList.get(count).getContentType().getStrContentType();
            if (sContentType.equals("".intern())) {
                DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("NO_SELECT_CONTENT_TYPE"), ResourceManager.getInstance().getResString("ERROR"), 0);
                return;
            }
            if ("PROGRAM".equals(oFileList.get(count).getContentType().getId())) {
                fileInfo = oFileList.get(count);
                if (fileInfo.getFileName().startsWith("slave#cfcard")) {
                    ++iSlaveCCFileCount;
                } else if (fileInfo.getFileName().startsWith("cfcard")) {
                    ++iMasterCCFileCount;
                } else {
                    DCDebugTracer.trace("Unknow" + fileInfo.getFileName());
                }
                if (iSlaveCCFileCount <= 1 && iMasterCCFileCount <= 1) continue;
                DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("MASTER_SLAVE_CFCARD_ONE_CC"), ResourceManager.getInstance().getResString("ERROR"), 0);
                return;
            }
            if (!"PATCH".equals(oFileList.get(count).getContentType().getId())) continue;
            fileInfo = oFileList.get(count);
            if (fileInfo.getFileName().startsWith("slave#cfcard")) {
                ++iSlavePatchFileCount;
            } else if (fileInfo.getFileName().startsWith("cfcard")) {
                ++iMasterPatchFileCount;
            } else {
                DCDebugTracer.trace("Unknow" + fileInfo.getFileName());
            }
            if (iSlavePatchFileCount <= 1 && iMasterPatchFileCount <= 1) continue;
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("MASTER_SLAVE_CFCARD_ONE_PATCH"), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        if (this.isHaveSlaveBoard()) {
            boolean bCCInfo = false;
            if (iMasterCCFileCount > 0 && iSlaveCCFileCount == 0 || iSlaveCCFileCount > 0 && iMasterCCFileCount == 0) {
                bCCInfo = true;
            }
            boolean bPatchInfo = false;
            if (iMasterPatchFileCount > 0 && iSlavePatchFileCount == 0 || iSlavePatchFileCount > 0 && iMasterPatchFileCount == 0) {
                bPatchInfo = true;
            }
            int confirm = 1;
            if (bCCInfo && bPatchInfo) {
                confirm = DCOptionPane.showConfirmDialog((Component)((Object)this), ResourceManager.getInstance().getResString("CONFIRM_SLAVE_CFCARD_CC_AND_PATCH"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
            } else if (bCCInfo) {
                confirm = DCOptionPane.showConfirmDialog((Component)((Object)this), ResourceManager.getInstance().getResString("CONFIRM_SLAVE_CFCARD_CC"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
            } else if (bPatchInfo) {
                confirm = DCOptionPane.showConfirmDialog((Component)((Object)this), ResourceManager.getInstance().getResString("CONFIRM_SLAVE_CFCARD_PATCH"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
            }
            if (confirm == 0) {
                return;
            }
        }
        this.m_oStartupConfigParam.addFileListToMap(this.m_oResource.getDeviceID(), oFileList);
        this.dispose();
    }

    private boolean isHaveSlaveBoard() {
        boolean isHaveSlaveBoard = false;
        Set<Map.Entry<String, List<String>>> devFileSet = this.m_oDeviceFilesMap.entrySet();
        Iterator<Map.Entry<String, List<String>>> devFileIte = devFileSet.iterator();
        Map.Entry<String, List<String>> devEntry = null;
        while (devFileIte.hasNext()) {
            devEntry = devFileIte.next();
            if (!devEntry.getKey().startsWith("slave#cfcard")) continue;
            isHaveSlaveBoard = true;
            break;
        }
        return isHaveSlaveBoard;
    }

    public void setM_oDeviceFilesMap() {
        if (this.m_oDeviceFilesMap != null) {
            this.m_oDeviceFilesMap = null;
        }
    }

    public LinkedHashMap<String, List<String>> getM_oDeviceFilesMap() {
        return this.m_oDeviceFilesMap;
    }

    private void initProgressDlg() {
        this.m_oProgressDlg = new SimpleProgressDlg(ResourceManager.getInstance().getResString("FILE_INFO"), true, ResourceManager.getInstance().getResString("FILE_PROGRESS_PROMPT")){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancelRollBtnActionPerformed() {
                DCDebugTracer.trace("SelectStartupDeviceFileDlg#cancelRollBtnActionPerformed()#m_oCancleBtn#" + SelectStartupDeviceFileDlg.this.m_oCancleBtn);
                SelectStartupDeviceFileDlg.this.m_oCancleBtn = true;
                if (null != SelectStartupDeviceFileDlg.this.threadForGetFileLst) {
                    SelectStartupDeviceFileDlg.this.threadForGetFileLst.interrupt();
                }
                SelectStartupDeviceFileDlg.this.stopProgressDlg();
            }
        };
        this.m_oProgressDlg.getcancelRollBtn().setText(ResourceManager.getInstance().getResString("CANCEL_BUTTON"));
        this.m_oProgressDlg.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
    }

    public void setcancleBtn(boolean isClick) {
        this.m_oCancleBtn = isClick;
    }

    public boolean getcancleBtn() {
        return this.m_oCancleBtn;
    }

    public DCException getException() {
        return this.exception;
    }

    private void stopProgressDlg() {
        DCDebugTracer.trace("DC#SelectStartupDeviceFileDlg#stopProgressDlg()" + (Object)((Object)this.m_oProgressDlg));
        if (null != this.m_oProgressDlg) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SelectStartupDeviceFileDlg.this.m_oProgressDlg.dispose();
                    SelectStartupDeviceFileDlg.this.m_oProgressDlg = null;
                }
            });
        }
    }
}

