/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.deviceoperation.util.DirAndFileInfo;
import com.huawei.dc.deviceoperation.util.FileNode;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.view.createtask.ValidateISSU;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class SelectDeviceFilePanel
extends JPanel {
    private static final long serialVersionUID = 7091220637871956768L;
    private JScrollPane m_oFileTreeScrollPane;
    private JTree m_oFileTree = new JTree();
    private DefaultTreeModel m_oFileTreeModel;
    private FileNode m_oRoot;
    private DefaultTableModel m_oFileTableModel = null;
    private JTable m_oFileTable = null;
    private JScrollPane m_oFileTableScrollPane = null;
    private JButton m_oDeleteButton = null;
    private JButton m_oSelectFileButton = null;
    private static final int FILE_NAME_COLUMN = 0;
    private static final int CONTENT_TYPE_COLUMN = 1;
    private ContentType[] m_arrContentTypes = null;
    private LinkedHashMap<String, List<String>> m_oDeviceFilesMap = null;
    public boolean m_bMessaseAlreadyShown = false;
    private static final String DEFAULT_CONTENT_TYPE = "";
    private static final int DEFAULT_CONTENT_TYPE_ID = 999;
    private ITask m_oTask;

    public SelectDeviceFilePanel(LinkedHashMap<String, List<String>> oDeviceFilesMap, Object[] oContentTypeList, List<LoadFileInfo> oFileList, ITask oTask) {
        this.m_oDeviceFilesMap = oDeviceFilesMap;
        this.m_arrContentTypes = (ContentType[])oContentTypeList;
        this.m_oTask = oTask;
        this.updateContentTypeArray();
        this.jbinit();
        if (null != oFileList) {
            this.populateTable(oFileList);
        }
        this.updateStatusOfButtons();
    }

    private void updateContentTypeArray() {
        ContentType[] arrTemp = new ContentType[this.m_arrContentTypes.length + 1];
        arrTemp[0] = new ContentType(999, DEFAULT_CONTENT_TYPE);
        for (int i = 0; i < this.m_arrContentTypes.length; ++i) {
            arrTemp[i + 1] = this.m_arrContentTypes[i];
        }
        this.m_arrContentTypes = arrTemp;
    }

    private void populateTable(List<LoadFileInfo> oFileList) {
        if (null == oFileList || 0 == oFileList.size()) {
            return;
        }
        LoadFileInfo oLoadFileInfo = null;
        Vector<Object> oRowData = null;
        for (int i = 0; i < oFileList.size(); ++i) {
            oLoadFileInfo = oFileList.get(i);
            oRowData = new Vector<Object>(2);
            boolean bFound = false;
            if (this.isFileAlreadyAdded(oLoadFileInfo.getFileName())) {
                bFound = true;
            }
            if (bFound) continue;
            oRowData.add(oLoadFileInfo.getFileName());
            oRowData.add(oLoadFileInfo.getContentType());
            this.m_oFileTableModel.addRow(oRowData);
        }
        this.updateStatusOfButtons();
        this.m_oFileTable.updateUI();
    }

    private void jbinit() {
        this.initPanel();
        this.initTreePanel();
        this.initTableScrollPane();
        this.populateTree();
        this.m_oFileTree.expandPath(new TreePath(this.m_oRoot.getPath()));
        this.m_oFileTree.setRootVisible(false);
        this.m_oFileTree.updateUI();
    }

    private void populateTree() {
        String strDirectory2 = null;
        String strFile = null;
        List<String> oFileList = null;
        String strPath = null;
        FileNode oDirNode = null;
        FileNode oFileNode = null;
        for (String strDirectory2 : this.m_oDeviceFilesMap.keySet()) {
            oDirNode = new FileNode(new DirAndFileInfo(strDirectory2, strDirectory2, false), true);
            this.m_oRoot.add(oDirNode);
            oFileList = this.m_oDeviceFilesMap.get(strDirectory2);
            int iSize = oFileList.size();
            for (int i = 0; i < iSize; ++i) {
                strFile = oFileList.get(i);
                strPath = strDirectory2 + strFile;
                oFileNode = new FileNode(new DirAndFileInfo(strPath, strFile, true), false);
                oDirNode.add(oFileNode);
            }
            this.m_oFileTree.expandPath(new TreePath(oDirNode.getPath()));
        }
    }

    private void initPanel() {
        this.setLayout(new GridBagLayout());
    }

    private void initTreePanel() {
        JPanel oTreePanel = new JPanel();
        oTreePanel.setLayout(new GridBagLayout());
        oTreePanel.setSize(220, 350);
        this.m_oFileTreeScrollPane = new JScrollPane();
        this.m_oFileTreeScrollPane.setName("TaskMgmt_StartupConfigPanel_oTableScrollPane");
        this.m_oFileTreeScrollPane.setPreferredSize(new Dimension(200, 270));
        this.m_oFileTreeScrollPane.setMinimumSize(new Dimension(200, 270));
        this.m_oFileTreeScrollPane.setViewportView(this.getFileTree());
        oTreePanel.add((Component)this.m_oFileTreeScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.m_oSelectFileButton = new JButton();
        this.m_oSelectFileButton.setName("DeviceOperation_FileSelectionPanel_oSelectBtn");
        ImageIcon oIcon = ResourceManager.getInstance().getImage("play.gif");
        this.m_oSelectFileButton.setIcon(oIcon);
        this.m_oSelectFileButton.setToolTipText(ResourceManager.getInstance().getResString("PROGRAM_SELECTION_SINGLE_BTN_TOOL_TIP"));
        this.m_oSelectFileButton.setPreferredSize(new Dimension(40, 25));
        this.m_oSelectFileButton.setMinimumSize(new Dimension(40, 25));
        oTreePanel.add((Component)this.m_oSelectFileButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_oSelectFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectDeviceFilePanel.this.selectBtnActionPerformed();
            }
        });
        this.add((Component)oTreePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    private JTree getFileTree() {
        this.m_oRoot = new FileNode(new DirAndFileInfo("A", "A", false), true);
        this.m_oFileTreeModel = new DefaultTreeModel(this.m_oRoot, true);
        this.m_oFileTree = new JTree(this.m_oFileTreeModel);
        this.m_oFileTree.setName("DeviceOperation_FileTreePanel_fileTree");
        this.m_oFileTree.setToggleClickCount(0);
        this.m_oFileTree.setCellRenderer(new FileTreeCellRenderer());
        this.m_oFileTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                SelectDeviceFilePanel.this.fileTree_MouseClicked(me);
            }
        });
        return this.m_oFileTree;
    }

    private void initTableScrollPane() {
        JPanel oTablePanel = new JPanel();
        oTablePanel.setLayout(new GridBagLayout());
        oTablePanel.setSize(350, 350);
        this.m_oFileTableScrollPane = new JScrollPane();
        this.m_oFileTableScrollPane.setName("TaskMgmt_StartupConfigPanel_oTableScrollPane");
        this.m_oFileTableScrollPane.setPreferredSize(new Dimension(320, 270));
        this.m_oFileTableScrollPane.setMinimumSize(new Dimension(320, 270));
        this.m_oFileTableScrollPane.setViewportView(this.getFileTable());
        oTablePanel.add((Component)this.m_oFileTableScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 1), 0, 0));
        this.m_oDeleteButton = new JButton();
        this.m_oDeleteButton.setName("DeviceOperation_FileSelectionPanel_oSelectBtn");
        ImageIcon oIcon = ResourceManager.getInstance().getImage("delete.gif");
        this.m_oDeleteButton.setIcon(oIcon);
        this.m_oDeleteButton.setToolTipText(ResourceManager.getInstance().getResString("PROGRAM_SELECTION_DELETE_BTN_TOOL_TIP"));
        this.m_oDeleteButton.setPreferredSize(new Dimension(25, 25));
        this.m_oDeleteButton.setMinimumSize(new Dimension(25, 25));
        oTablePanel.add((Component)this.m_oDeleteButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_oDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectDeviceFilePanel.this.deleteBtnActionPerformed();
            }
        });
        this.add((Component)oTablePanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    private Component getFileTable() {
        Object[] arrcolHeader = new String[]{DCFrameWorkUtil.getLocalizedString("TASK_FILE_PATH"), DCFrameWorkUtil.getLocalizedString("PROGRAM_SELECTION_CONTENT_TYPE")};
        this.m_oFileTableModel = new DefaultTableModel(arrcolHeader, 0){
            private static final long serialVersionUID = -6319177168985365974L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return 1 == col;
            }
        };
        this.m_oFileTable = new JTable(this.m_oFileTableModel);
        this.m_oFileTable.setName("TaskMgmt_StartupConfigPanel_m_oTable");
        this.m_oFileTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (SelectDeviceFilePanel.this.m_oFileTable.hasFocus()) {
                    SelectDeviceFilePanel.this.updateStatusOfButtons();
                }
            }
        });
        this.m_oFileTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SelectDeviceFilePanel.this.updateStatusOfButtons();
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }
        });
        this.m_oFileTable.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent event) {
                SelectDeviceFilePanel.this.updateStatusOfButtons();
            }

            @Override
            public void mouseMoved(MouseEvent event) {
                Point p = event.getPoint();
                int hitColumnIndex = SelectDeviceFilePanel.this.m_oFileTable.columnAtPoint(p);
                int hitRowIndex = SelectDeviceFilePanel.this.m_oFileTable.rowAtPoint(p);
                Object str = SelectDeviceFilePanel.this.m_oFileTable.getValueAt(hitRowIndex, hitColumnIndex);
                SelectDeviceFilePanel.this.m_oFileTable.setToolTipText(str.toString());
            }
        });
        this.m_oFileTable.getSelectionModel().setSelectionMode(1);
        this.m_oFileTable.setRowSelectionAllowed(true);
        this.m_oFileTable.getTableHeader().setReorderingAllowed(false);
        this.m_oFileTable.getTableHeader().setPreferredSize(new Dimension(this.m_oFileTable.getSize().width, 21));
        this.customizeTable();
        return this.m_oFileTable;
    }

    private void customizeTable() {
        this.m_oFileTable.getTableHeader().setReorderingAllowed(false);
        this.m_oFileTable.setRowHeight(21);
        this.m_oFileTable.getTableHeader().setPreferredSize(new Dimension(this.m_oFileTable.getSize().width, 21));
        this.m_oFileTable.getColumnModel().getColumn(1).setCellEditor(new ContentTypeCellEditor(this.m_arrContentTypes));
        this.m_oFileTable.getColumnModel().getColumn(1).setCellRenderer(new ContentTypeCellRenderer(this.m_arrContentTypes));
    }

    private void fileTree_MouseClicked(final MouseEvent me) {
        FileNode treeNode;
        int y;
        Point p = me.getPoint();
        int x = (int)p.getX();
        int row = this.m_oFileTree.getRowForLocation(x, y = (int)p.getY());
        if (-1 == row) {
            row = this.m_oFileTree.getRowForLocation((int)p.getX(), (int)p.getY());
        }
        boolean isOperation = false;
        if (-1 == row) {
            if (row < 0) {
                isOperation = true;
                x += 17;
            }
            row = this.m_oFileTree.getRowForLocation(x, (int)p.getY());
        }
        if (row < 0) {
            return;
        }
        final TreePath treepath = this.m_oFileTree.getPathForLocation(x, y);
        if (treepath != null && null != (treeNode = (FileNode)treepath.getLastPathComponent()) && (me.getClickCount() == 2 || me.getClickCount() == 1 && isOperation)) {
            Object obj = treeNode.getUserObject();
            DirAndFileInfo node = null;
            if (obj instanceof DirAndFileInfo) {
                node = (DirAndFileInfo)obj;
            }
            if (2 == me.getClickCount() && node != null && node.isFile()) {
                this.addFileToTable();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (me.getClickCount() == 2) {
                        if (SelectDeviceFilePanel.this.m_oFileTree.isCollapsed(treepath)) {
                            SelectDeviceFilePanel.this.m_oFileTree.expandPath(treepath);
                        } else {
                            SelectDeviceFilePanel.this.m_oFileTree.collapsePath(treepath);
                        }
                    }
                }
            });
            this.m_oFileTree.treeDidChange();
        }
    }

    private void addFileToTable() {
        this.setMessaseAlreadyShown(false);
        TreePath[] oTreePath = this.m_oFileTree.getSelectionPaths();
        if (oTreePath == null) {
            DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("FILE_NULL_FOR_ADD"), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        for (int i = 0; i < oTreePath.length; ++i) {
            DirAndFileInfo oDirNode;
            FileNode oTreeNode = (FileNode)oTreePath[i].getLastPathComponent();
            Object oUserObj = oTreeNode.getUserObject();
            if (!(oUserObj instanceof DirAndFileInfo) || !(oDirNode = (DirAndFileInfo)oUserObj).isFile()) continue;
            if (this.isFileAlreadyAdded(oDirNode.getPath())) {
                if (this.isMessaseAlreadyShown()) continue;
                DCOptionPane.showMessageDialog((Component)this.getParent(), ResourceManager.getInstance().getResString("FILE_ALREADY_SELECTED"), ResourceManager.getInstance().getResString("INFORMATION"), 1);
                this.setMessaseAlreadyShown(true);
                continue;
            }
            ArrayList<String> oFileList = new ArrayList<String>(0);
            oFileList.add(oDirNode.getPath());
            try {
                this.addSelectedFiles(oFileList);
                continue;
            }
            catch (DCException ex) {
                if (this.isMessaseAlreadyShown()) continue;
                DCOptionPane.showMessageDialog((Component)this.getParent(), ResourceManager.getInstance().getResString(ex.getMessage()), ResourceManager.getInstance().getResString("ERROR"), 0);
                this.setMessaseAlreadyShown(true);
            }
        }
        this.updateStatusOfButtons();
        this.m_oFileTree.clearSelection();
    }

    private boolean isFileAlreadyAdded(String strNewFileName) {
        boolean bIsFileAlreadyExistInTable = false;
        Vector<Vector> oDataVec = this.m_oFileTableModel.getDataVector();
        int iSize = oDataVec.size();
        if (0 == iSize) {
            return false;
        }
        for (int i = 0; i < iSize; ++i) {
            Vector vec = oDataVec.elementAt(i);
            String strOldFileName = (String)vec.get(0);
            if (0 != Collator.getInstance().compare(strNewFileName, strOldFileName)) continue;
            bIsFileAlreadyExistInTable = true;
            break;
        }
        return bIsFileAlreadyExistInTable;
    }

    private void addSelectedFiles(List<String> oFileList) throws DCException {
        if (null == oFileList || 0 == oFileList.size()) {
            return;
        }
        String strFileName = null;
        Vector<Object> oRowData = null;
        for (int i = 0; i < oFileList.size(); ++i) {
            strFileName = oFileList.get(i);
            oRowData = new Vector<Object>(2);
            boolean bFound = false;
            if (this.isFileAlreadyAdded(strFileName)) {
                bFound = true;
            }
            if (bFound) continue;
            oRowData.add(strFileName);
            oRowData.add(this.m_arrContentTypes[0]);
            this.m_oFileTableModel.addRow(oRowData);
        }
        this.updateStatusOfButtons();
        this.m_oFileTable.updateUI();
    }

    private void updateStatusOfButtons() {
        int[] iSelectedRows = this.m_oFileTable.getSelectedRows();
        if (iSelectedRows.length >= 1) {
            this.m_oDeleteButton.setEnabled(true);
        } else {
            this.m_oDeleteButton.setEnabled(false);
        }
        this.m_oFileTable.repaint();
    }

    private void selectBtnActionPerformed() {
        block5: {
            this.setMessaseAlreadyShown(false);
            TreePath oTreePath = this.m_oFileTree.getSelectionPath();
            if (oTreePath == null) {
                DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("LOAD_FILE_NULL"), ResourceManager.getInstance().getResString("ERROR"), 0);
                return;
            }
            FileNode oTreeNode = (FileNode)oTreePath.getLastPathComponent();
            DirAndFileInfo oDirNode = (DirAndFileInfo)oTreeNode.getUserObject();
            if (!oDirNode.isFile()) {
                return;
            }
            if (this.isFileAlreadyAdded(oDirNode.getPath()) && !this.isMessaseAlreadyShown()) {
                DCOptionPane.showMessageDialog((Component)this.getParent(), ResourceManager.getInstance().getResString("FILE_ALREADY_SELECTED"), ResourceManager.getInstance().getResString("INFORMATION"), 1);
                this.setMessaseAlreadyShown(true);
                return;
            }
            ArrayList<String> oFileList = new ArrayList<String>(0);
            oFileList.add(oDirNode.getPath());
            try {
                this.addSelectedFiles(oFileList);
            }
            catch (DCException ex) {
                if (this.isMessaseAlreadyShown()) break block5;
                DCOptionPane.showMessageDialog((Component)this.getParent(), ResourceManager.getInstance().getResString(ex.getMessage()), ResourceManager.getInstance().getResString("ERROR"), 0);
                this.setMessaseAlreadyShown(true);
            }
        }
    }

    public boolean isMessaseAlreadyShown() {
        return this.m_bMessaseAlreadyShown;
    }

    public void setMessaseAlreadyShown(boolean m_bMessaseAlreadyShown) {
        this.m_bMessaseAlreadyShown = m_bMessaseAlreadyShown;
    }

    private void deleteBtnActionPerformed() {
        int i;
        int[] arrSelectedRows = this.m_oFileTable.getSelectedRows();
        if (0 >= arrSelectedRows.length) {
            return;
        }
        ValidateISSU oValidateISSU = new ValidateISSU(this.m_oTask);
        for (i = 0; i < arrSelectedRows.length; ++i) {
            int iRow = arrSelectedRows[i];
            ContentType oContentType = (ContentType)this.m_oFileTableModel.getValueAt(iRow, 1);
            if (!"PROGRAM".equals(oContentType.getId()) || oValidateISSU.checkForRemoveManualAppointedStartupImage()) continue;
            return;
        }
        for (i = 0; i < arrSelectedRows.length; ++i) {
            int iRowIndex = arrSelectedRows[i] - i;
            this.m_oFileTableModel.removeRow(iRowIndex);
        }
        this.m_oFileTableModel.fireTableDataChanged();
        int iRowCount = this.m_oFileTable.getRowCount();
        if (iRowCount > 0) {
            if (iRowCount == arrSelectedRows[0]) {
                this.m_oFileTable.setRowSelectionInterval(arrSelectedRows[0] - 1, arrSelectedRows[0] - 1);
            } else {
                this.m_oFileTable.setRowSelectionInterval(arrSelectedRows[0], arrSelectedRows[0]);
            }
        } else {
            this.m_oDeleteButton.setEnabled(false);
        }
        this.m_oFileTable.repaint();
        this.updateStatusOfButtons();
    }

    public List<LoadFileInfo> getFilesFromTable() {
        Vector<Vector> oDataVector = this.m_oFileTableModel.getDataVector();
        if (null == oDataVector || 0 == oDataVector.size()) {
            return null;
        }
        int iSize = this.m_oFileTableModel.getDataVector().size();
        ArrayList<LoadFileInfo> oFileList = new ArrayList<LoadFileInfo>(0);
        LoadFileInfo oLoadFileInfo = null;
        for (int i = 0; i < iSize; ++i) {
            Vector vec = oDataVector.elementAt(i);
            oLoadFileInfo = new LoadFileInfo();
            oLoadFileInfo.setSequenceNo(i);
            oLoadFileInfo.setFileName(String.valueOf(vec.elementAt(0)));
            oLoadFileInfo.setContentType((ContentType)vec.elementAt(1));
            oFileList.add(oLoadFileInfo);
        }
        return oFileList;
    }

    class FileTreeCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        private static final long serialVersionUID = 5577048285009800669L;
        ImageIcon oDirIcon = ResourceManager.getInstance().getImage("folder.gif");
        ImageIcon oFileIcon = ResourceManager.getInstance().getImage("file.gif");

        public FileTreeCellRenderer() {
            super.setOpaque(true);
            this.setIconTextGap(2);
            super.setBackground(UIManager.getColor("Tree.textBackground"));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            FileNode oTreeNode;
            this.setText(String.valueOf(value));
            TreePath oTreePath = tree.getPathForRow(row);
            if (oTreePath != null && (oTreeNode = (FileNode)value).getUserObject() instanceof DirAndFileInfo) {
                DirAndFileInfo dirNode = (DirAndFileInfo)oTreeNode.getUserObject();
                if (dirNode.isFile()) {
                    this.setIcon(this.oFileIcon);
                } else {
                    this.setIcon(this.oDirIcon);
                }
            }
            if (selected) {
                this.setBackground(UIManager.getColor("Tree.selectionBackground"));
                this.setForeground(new Color(225, 225, 225));
            } else {
                this.setBackground(tree.getBackground());
                this.setForeground(tree.getForeground());
            }
            this.updateUI();
            return this;
        }
    }

    private class ContentTypeCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = -7168605748427088912L;

        public ContentTypeCellEditor(Object[] items) {
            super(new ComboBoxWithToolTip(items));
        }
    }

    public class ContentTypeCellRenderer
    extends ComboBoxWithToolTip
    implements TableCellRenderer {
        private static final long serialVersionUID = -4199488159513179661L;

        public ContentTypeCellRenderer(Object[] oContentType) {
            super(oContentType);
            this.setSelectedItem(oContentType[0]);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            if (null == value && null != SelectDeviceFilePanel.this.m_arrContentTypes && 0 < SelectDeviceFilePanel.this.m_arrContentTypes.length) {
                value = SelectDeviceFilePanel.this.m_arrContentTypes[0];
            }
            this.setSelectedItem(value);
            return this;
        }
    }
}

