/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation;

import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.TaskInfoUtil;
import com.huawei.dc.common.util.TaskInfoUtil2;
import com.huawei.dc.devicemanagement.deviceoperation.IParaList;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.IUpgradeOperation;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationOperation;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationType;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.IUpgradeSubOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.PostUpgradeSubOpr;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.UpgradeOpConfigPanel;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.UpgradeOprConfigDialog;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.ViewUpgradeOpPanel;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.ITaskSubOperation;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import java.awt.Component;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import javax.swing.border.TitledBorder;

public class PostUpgradeOperation
implements IUpgradeOperation {
    private static final long serialVersionUID = -6554971004117062384L;
    private int m_iOperationId = -1;
    private String m_strOperationName;
    private String m_strOperationIdString;
    private String m_strOperationDesc;
    private boolean m_bIsOPSelected;
    private int m_iOpDependsOnId;
    private List m_oDependentOpLst;
    private boolean m_bIsPauseB4Op;
    private boolean m_bIsEnabled = true;
    private ITask m_oParentTask;
    private int m_iOperationLevel;
    private IParaList m_oParaList;
    private List<IUpgradeSubOperation> m_oUpgradeSubOperationList = null;
    private ITaskSubOperation m_oPostUpgradeTaskSubOpr = null;
    private int iInnerTaskTypeId = -1;

    @Override
    public String getOperationDesc() {
        return this.m_strOperationDesc;
    }

    @Override
    public ArrayList getOperationIDnName() {
        ArrayList<Object> oData = null;
        if (this.isSelected()) {
            oData = new ArrayList<Object>();
            oData.add(this.getOperationName());
            oData.add(this.getOperationId());
        }
        return oData;
    }

    @Override
    public int getOperationId() {
        return this.m_iOperationId;
    }

    @Override
    public String getOperationIdString() {
        return this.m_strOperationIdString;
    }

    @Override
    public int getOperationLevel() {
        return this.m_iOperationLevel;
    }

    @Override
    public String getOperationName() {
        return this.m_strOperationName;
    }

    @Override
    public IParaList getoPerationParaList() {
        return this.m_oParaList;
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

    @Override
    public void setIsCancelable(boolean isCancelable) {
    }

    @Override
    public void setOPerationParaList(IParaList paraList) {
        this.m_oParaList = paraList;
    }

    @Override
    public void setOperationDesc(String strOperationDesc) {
        this.m_strOperationDesc = strOperationDesc;
    }

    @Override
    public void setOperationId(int operationId) {
        this.m_iOperationId = operationId;
    }

    @Override
    public void setOperationIdString(String strOperationId) {
        this.m_strOperationIdString = strOperationId;
    }

    @Override
    public void setOperationLevel(int operationLevel) {
        this.m_iOperationLevel = operationLevel;
    }

    @Override
    public void setOperationName(String strOperationName) {
        this.m_strOperationName = strOperationName;
    }

    @Override
    public List<IUpgradeSubOperation> getUpgradeSubOperationList() {
        return this.m_oUpgradeSubOperationList;
    }

    @Override
    public void setUpgradeSubOperationList(List<IUpgradeSubOperation> upgradeSubOperationList) {
        this.m_oUpgradeSubOperationList = upgradeSubOperationList;
    }

    @Override
    public Object getConfiguredPara() {
        return this.m_oUpgradeSubOperationList;
    }

    public List getDependentOperation() {
        return this.m_oDependentOpLst;
    }

    @Override
    public int getDependsOnOperation() {
        return this.m_iOpDependsOnId;
    }

    @Override
    public ITaskSubOperation getSubOperationData() {
        this.m_oPostUpgradeTaskSubOpr = new PostUpgradeSubOpr(this.m_oUpgradeSubOperationList);
        return this.m_oPostUpgradeTaskSubOpr;
    }

    @Override
    public Component getView(int context) {
        if (null == this.m_oParentTask) {
            return null;
        }
        Object oPostUpgradeOpView = null;
        switch (context) {
            case 0: {
                UpgradeOprConfigDialog oUpgradeOprConfigDialog = new UpgradeOprConfigDialog(this.m_oUpgradeSubOperationList, this.m_oParentTask.getTaskTypeId(), "PostUpgrade", this);
                oUpgradeOprConfigDialog.setTitle(DCFrameWorkUtil.getLocalizedString("POST_UPGRADE_CONFIG_DLG_TITLE"));
                oUpgradeOprConfigDialog.getUpgradeOpConfigPanel().setParentTask(this.m_oParentTask);
                oPostUpgradeOpView = oUpgradeOprConfigDialog;
                break;
            }
            case 1: {
                UpgradeOpConfigPanel oUpgradeOpConfigPanel = new UpgradeOpConfigPanel(this.m_oUpgradeSubOperationList, this, 1);
                oUpgradeOpConfigPanel.setBounds(10, 10, 600, 360);
                oUpgradeOpConfigPanel.setParentTask(this.m_oParentTask);
                oPostUpgradeOpView = oUpgradeOpConfigPanel;
                break;
            }
            case 2: {
                ViewUpgradeOpPanel oViewUpgradeOpPanel = new ViewUpgradeOpPanel(this.m_oUpgradeSubOperationList);
                TitledBorder oViewPanelTitledBorder = new TitledBorder(this.getOperationName());
                oViewUpgradeOpPanel.setBorder(oViewPanelTitledBorder);
                oViewUpgradeOpPanel.setBounds(10, 10, 600, 360);
                oPostUpgradeOpView = oViewUpgradeOpPanel;
                break;
            }
        }
        return oPostUpgradeOpView;
    }

    @Override
    public boolean isConfigReq() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return this.m_bIsEnabled;
    }

    @Override
    public boolean isPauseBeforeCurOp() {
        return this.m_bIsPauseB4Op;
    }

    @Override
    public boolean isSelected() {
        return this.m_bIsOPSelected;
    }

    public void setDependentOperation(List devDependentLst) {
        this.m_oDependentOpLst = devDependentLst;
    }

    @Override
    public void setDependsOnOperation(int devOpDependsOnId) {
        this.m_iOpDependsOnId = devOpDependsOnId;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.m_bIsEnabled = isEnabled;
    }

    @Override
    public void setIsPauseBeforeCurOp(boolean isPauseBeforeCurOp) {
        this.m_bIsPauseB4Op = isPauseBeforeCurOp;
    }

    @Override
    public void setOperationData(ITask task) {
        this.m_oParentTask = task;
    }

    @Override
    public void setSelected(boolean isSelected) {
        this.m_bIsOPSelected = isSelected;
    }

    @Override
    public void setToNullSubOperationData() {
        this.m_oPostUpgradeTaskSubOpr = null;
    }

    @Override
    public ValidationResult validateOperationConfigurations() {
        ValidationResult oResult = new ValidationResult();
        if (null == this.m_oParentTask) {
            oResult.setErrorMessage(ResourceManager.getInstance().getResString("TASK_NOT_INIT"));
            return oResult;
        }
        if (0 == oResult.getErrorCode()) {
            oResult = this.checkLoadFiles();
        }
        if (0 == oResult.getErrorCode()) {
            this.updatePostUpgradeOplist();
            oResult = this.isAnySubOperationSelected();
        }
        return oResult;
    }

    private void updatePostUpgradeOplist() {
        List<ITaskDeviceOperation> deviceOPList = this.m_oParentTask.getSupportedOperation();
        ActivationOperation activationOper = null;
        PostUpgradeOperation postUpgradeOper = null;
        for (ITaskDeviceOperation oper : deviceOPList) {
            if (oper.getOperationId() == 8) {
                activationOper = (ActivationOperation)oper;
                continue;
            }
            if (oper.getOperationId() != 33) continue;
            postUpgradeOper = (PostUpgradeOperation)oper;
        }
        ActivationType activateType = activationOper.getActivateConfigPara().getSelectedActivateType();
        if (activateType.getParaValue().getId().equals("ISSU")) {
            List<IUpgradeSubOperation> subOperList = postUpgradeOper.getUpgradeSubOperationList();
            for (int i = 0; i < subOperList.size(); ++i) {
                IUpgradeSubOperation subOper = subOperList.get(i);
                if (!subOper.getOperationIdString().equals("UpgradePatch")) continue;
                subOper.setSelected(false);
                break;
            }
        }
        DCDebugTracer.trace("PostUpgrade: " + postUpgradeOper.isSelected());
    }

    private ValidationResult checkLoadFiles() {
        ValidationResult oResult = new ValidationResult();
        IUpgradeSubOperation oUpgradeSubOperation = null;
        int iSize = this.m_oUpgradeSubOperationList.size();
        for (int i = 0; i < iSize; ++i) {
            oUpgradeSubOperation = this.m_oUpgradeSubOperationList.get(i);
            if (Collator.getInstance().equals(oUpgradeSubOperation.getOperationIdString(), "UpgradePatch") || Collator.getInstance().equals(oUpgradeSubOperation.getOperationIdString(), "ActiveGTL")) {
                oResult = this.updatePostUpgradeOpr(oUpgradeSubOperation);
                continue;
            }
            oUpgradeSubOperation = null;
        }
        return oResult;
    }

    private ValidationResult updatePostUpgradeOpr(IUpgradeSubOperation oUpgradeSubOperation) {
        ValidationResult oResult = new ValidationResult();
        if (null != oUpgradeSubOperation && oUpgradeSubOperation.isSelected()) {
            boolean bRetVal = false;
            String strContentType = "";
            String strMessage = "";
            if (Collator.getInstance().equals(oUpgradeSubOperation.getOperationIdString(), "UpgradePatch")) {
                strContentType = "PATCH";
                strMessage = "DESELECT_UPGRADE_PATCH_OPERTAION";
            } else if (Collator.getInstance().equals(oUpgradeSubOperation.getOperationIdString(), "ActiveGTL")) {
                strContentType = "GTLLicense";
                strMessage = "DESELECT_ACTIVE_GTL_OPERTAION";
            }
            bRetVal = TaskInfoUtil.isFileSelectedForContentType(this.m_oParentTask, strContentType);
            if (!bRetVal) {
                TaskInfoUtil2.updatePostUpgradeForSubOperation(this.m_oParentTask, oUpgradeSubOperation.getOperationIdString());
                oResult.setErrorCode(0);
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString(strMessage), DCFrameWorkUtil.getLocalizedString("WARNING"), 2);
            }
        }
        return oResult;
    }

    private ValidationResult isAnySubOperationSelected() {
        ValidationResult oResult = new ValidationResult();
        oResult.setErrorCode(0);
        int iSupOpLstSize = this.m_oUpgradeSubOperationList.size();
        boolean bAnySubOprSelected = false;
        for (int i = 0; i < iSupOpLstSize; ++i) {
            IUpgradeSubOperation oUpgradeSubOp = this.m_oUpgradeSubOperationList.get(i);
            if (!oUpgradeSubOp.isSelected()) continue;
            bAnySubOprSelected = true;
            break;
        }
        if (!bAnySubOprSelected) {
            oResult.setErrorCode(-1);
            oResult.setErrorMessage(ResourceManager.getInstance().getResString("POST_UPGRADE_SELECT_ANY_OPERATION"));
        }
        return oResult;
    }

    public ITask getOperationData() {
        return this.m_oParentTask;
    }

    @Override
    public String toString() {
        StringBuffer strRetVal = new StringBuffer(0);
        strRetVal.append("  ");
        strRetVal.append(DCFrameWorkUtil.getLocalizedString("SELECTED_SUB_OPR_LIST"));
        strRetVal.append("<br>");
        strRetVal.append("<ul type=\"circle\">");
        int iSize = this.m_oUpgradeSubOperationList.size();
        IUpgradeSubOperation oUpgradeSubOpr = null;
        for (int i = 0; i < iSize; ++i) {
            oUpgradeSubOpr = this.m_oUpgradeSubOperationList.get(i);
            if (!oUpgradeSubOpr.isSelected()) continue;
            strRetVal.append("<li>" + oUpgradeSubOpr.getOperationName() + "</li>");
        }
        strRetVal.append("</ul>");
        return strRetVal.toString();
    }

    public boolean isSelectSubOperationUp(String sSubOperationID) {
        if (null == this.m_oParentTask) {
            return false;
        }
        List<IUpgradeSubOperation> oSubLst = this.getUpgradeSubOperationList();
        if (null == oSubLst) {
            return false;
        }
        for (int i = 0; i < oSubLst.size(); ++i) {
            IUpgradeSubOperation oSubOper = oSubLst.get(i);
            if (null == oSubOper || !oSubOper.isSelected() || !oSubOper.getOperationIdString().equals(sSubOperationID)) continue;
            return true;
        }
        return false;
    }

    public boolean isSomeSubOperationSelected() {
        if (null == this.m_oParentTask) {
            return false;
        }
        List<IUpgradeSubOperation> oSubLst = this.getUpgradeSubOperationList();
        if (null == oSubLst) {
            return false;
        }
        for (int i = 0; i < oSubLst.size(); ++i) {
            IUpgradeSubOperation oSubOper = oSubLst.get(i);
            if (null == oSubOper || !oSubOper.isSelected()) continue;
            return true;
        }
        return false;
    }

    public IUpgradeSubOperation getUpgradeSubOperation(String strOpeID) {
        List<IUpgradeSubOperation> oSubLst = this.getUpgradeSubOperationList();
        for (IUpgradeSubOperation oUpgradeSubOperation : oSubLst) {
            if (!strOpeID.equals(oUpgradeSubOperation.getOperationIdString())) continue;
            return oUpgradeSubOperation;
        }
        return null;
    }

    public void setSelectUpPatch(String sSubOPerationID, boolean bSelected) {
        if (null == this.m_oParentTask) {
            return;
        }
        List<IUpgradeSubOperation> oSubLst = this.getUpgradeSubOperationList();
        if (null == oSubLst) {
            return;
        }
        for (int i = 0; i < oSubLst.size(); ++i) {
            IUpgradeSubOperation oSubOper = oSubLst.get(i);
            if (null == oSubOper || !oSubOper.getOperationIdString().equals(sSubOPerationID)) continue;
            oSubOper.setSelected(bSelected);
            break;
        }
    }

    @Override
    public String getCurrentContext() {
        return null;
    }

    @Override
    public String getOperationTooltip() {
        return null;
    }

    @Override
    public void setOperationTooltip(String strOperationTooltip) {
    }

    @Override
    public int getInnerTaskTypeId() {
        return this.iInnerTaskTypeId;
    }

    @Override
    public void setInnerTaskTypeId(int taskTypeId) {
        this.iInnerTaskTypeId = taskTypeId;
    }
}

