/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.updatedata;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCGetDirReq;
import com.huawei.dc.common.asndatacenter.AsnDCGetDirRsp;
import com.huawei.dc.common.asndatacenter.AsnDCGetTargetVersionDirReq;
import com.huawei.dc.common.asndatacenter.AsnDCGetTargetVersionDirRsp;
import com.huawei.dc.common.asndatacenter.AsnDCTargetVersionInfo;
import com.huawei.dc.common.asndatacenter.AsnSAMTargerVersionDirLst;
import com.huawei.dc.common.components.dialog.IBrowseDlgInterafce;
import com.huawei.dc.common.components.dialog.fileselection.FileSelectionBrowseDlg;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.updatedata.UpdateConfigParam;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.sam.controller.ISAMManager;
import com.huawei.dc.sam.controller.SAMManager;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.toolkit.client.base.util.TKCommonUtil;
import com.swimap.iview.commstyle.resource.ResourceMng;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.text.Collator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.commustru.fstru.FStruct;

public class UpdateDataPanel
extends JPanel
implements IBrowseDlgInterafce {
    private static final long serialVersionUID = 1L;
    private boolean m_bIsDefaultUpdateToolRequired;
    private boolean m_bIsUserDefinedUpdateToolRequired;
    private JTextField m_oUpdatePathTextField;
    private String strUpdatePathTextField;
    private static final String EMPTY_STRING = "";
    private ResourceManager oResourceManager = ResourceManager.getInstance();
    private JRadioButton m_DefaultRadioButton;
    private JLabel selectTheUpdatingLabel = new JLabel();
    private JLabel filePath;
    private JButton button = new JButton();
    protected UpdateConfigParam m_oConfigPara = null;
    private JLabel contentTypeLabel;
    private ITask m_oParentTask;

    public UpdateDataPanel(UpdateConfigParam oConfigPara, ITask oParentTask) {
        this.m_oConfigPara = oConfigPara;
        this.m_oParentTask = oParentTask;
        this.m_bIsDefaultUpdateToolRequired = this.m_oConfigPara.isM_bIsDefaultUpdateToolRequired();
        this.m_bIsUserDefinedUpdateToolRequired = this.m_oConfigPara.isM_bIsUserDefinedUpdateToolRequired();
        this.setLayout(null);
        this.initPanel();
        this.initDefaultValue();
    }

    private void initPanel() {
        JPanel panel = new JPanel();
        panel.setName("DeviceOperation_UpdateDataPanel_panel");
        panel.setLayout(null);
        panel.setBounds(20, 16, 295, 135);
        this.add(panel);
        this.initLabel(panel);
        if (!this.m_bIsDefaultUpdateToolRequired && !this.m_bIsUserDefinedUpdateToolRequired) {
            this.contentTypeLabel = new JLabel();
            this.contentTypeLabel.setBounds(5, 76, 270, 40);
            this.contentTypeLabel.setText(this.oResourceManager.getResString("NO_CONFIGURATION_REQUIRED"));
            panel.add(this.contentTypeLabel);
        } else {
            this.initRadioButton(panel);
            if (this.m_bIsUserDefinedUpdateToolRequired) {
                this.m_oUpdatePathTextField = new JTextField();
                this.m_oUpdatePathTextField.setName("DeviceOperation_UpdateDataPanel_m_oUpdatePathTextField");
                this.m_oUpdatePathTextField.setBounds(80, 80, 165, 20);
                this.m_oUpdatePathTextField.setEditable(false);
                panel.add(this.m_oUpdatePathTextField);
            }
            if (this.m_bIsUserDefinedUpdateToolRequired) {
                this.initBrowseButton(panel, this);
            }
        }
    }

    private void initDefaultValue() {
        String strUpdateToolPathSelected;
        if (this.m_bIsDefaultUpdateToolRequired && this.m_bIsUserDefinedUpdateToolRequired) {
            if (this.m_oConfigPara.isDefaultSelected()) {
                this.m_DefaultRadioButton.setSelected(true);
            } else {
                String strUpdateToolPathSelected2;
                this.strUpdatePathTextField = strUpdateToolPathSelected2 = this.getSAMStartingPath();
                if (null != this.m_oConfigPara.getUpdateToolPathSelected() && !this.m_oConfigPara.getUpdateToolPathSelected().equals(EMPTY_STRING)) {
                    strUpdateToolPathSelected2 = this.m_oConfigPara.getUpdateToolPathSelected();
                }
                strUpdateToolPathSelected2 = strUpdateToolPathSelected2.replace('\\', '/');
                String strRootPath = "/";
                if (strUpdateToolPathSelected2.equals(EMPTY_STRING)) {
                    strUpdateToolPathSelected2 = strRootPath;
                }
                if (null != strUpdateToolPathSelected2) {
                    this.setTextField(strUpdateToolPathSelected2);
                }
            }
        } else if (this.m_bIsUserDefinedUpdateToolRequired && null != (strUpdateToolPathSelected = this.m_oConfigPara.getUpdateToolPathSelected())) {
            this.setTextField(strUpdateToolPathSelected);
        }
    }

    protected void initLabel(JPanel panel) {
        this.selectTheUpdatingLabel.setText(this.oResourceManager.getResString("SELECT_UPDATE_TO_UPDATE"));
        this.selectTheUpdatingLabel.setBounds(5, 5, 280, 50);
        panel.add(this.selectTheUpdatingLabel);
    }

    private void initRadioButton(JPanel panel) {
        if (this.m_bIsUserDefinedUpdateToolRequired) {
            this.filePath = new JLabel(this.oResourceManager.getResString("FILE_PATH"));
            this.filePath.setName("DeviceOperation_UpdateDataPanel_oUserDefRadioButton");
            this.filePath.setBounds(20, 80, 90, 20);
            panel.add(this.filePath);
        }
    }

    public void updateDataModel(boolean isOK) {
        if (isOK) {
            this.m_oConfigPara.setSelectedUpdateType(this.m_oUpdatePathTextField.getText());
        } else {
            this.m_oConfigPara.setSelectedUpdateType(this.strUpdatePathTextField);
        }
    }

    public boolean validateInput() {
        if (this.m_bIsUserDefinedUpdateToolRequired && (null == this.m_DefaultRadioButton || !this.m_DefaultRadioButton.isSelected())) {
            if (this.m_oUpdatePathTextField.getText().equals(EMPTY_STRING)) {
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("UPDATE_DATA_OPERATION_VALIDATION_FAIL"));
                return false;
            }
            boolean isDirectory = false;
            BaseCommManager commManager = DCFrameWorkUtil.getCommManager();
            AsnDCGetDirReq dirGetReq = new AsnDCGetDirReq();
            dirGetReq.strRootPath = this.m_oUpdatePathTextField.getText().getBytes();
            AsnDCGetDirRsp dirRsp = new AsnDCGetDirRsp();
            int iErrorCode = commManager.sendSyncMsgWithSyncCommand(43842, (FStruct)dirGetReq, (FStruct)dirRsp);
            if (iErrorCode == 0 && dirRsp.oErrorInfo.iErrorNo.intValue() == 0 && (dirRsp.oDirectories.size() > 0 || dirRsp.oFiles.size() > 0)) {
                isDirectory = true;
            }
            String fileSuffix = ".zip";
            if (this.m_oUpdatePathTextField.getText().toLowerCase(ResourceMng.getInstance().getLocale()).endsWith(fileSuffix.toLowerCase(ResourceMng.getInstance().getLocale())) || isDirectory) {
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("UPDATE_DATA_OPERATION_VALIDATION_FAIL"));
                return false;
            }
        }
        boolean isValidVersion = this.validateVerSelected();
        return isValidVersion;
    }

    private boolean validateVerSelected() {
        String strUpdateToolPath = EMPTY_STRING;
        strUpdateToolPath = this.m_oUpdatePathTextField.getText();
        DeviceType oDevType = this.m_oParentTask.getSelectedDeviceType();
        String strSelTargetVersion = this.m_oParentTask.getTargetVersion();
        try {
            List oVersionLst = TaskSyncCommController.getInstance().getVersionInfoFrmServer(oDevType.getDeviceTypeID(), oDevType.getDeviceTypeVersionID(), strUpdateToolPath);
            int iVersionCount = oVersionLst.size();
            boolean bVerFound = false;
            AsnDCTargetVersionInfo oAsnDCTargetVersionInfo = null;
            for (int i = 0; i < iVersionCount; ++i) {
                oAsnDCTargetVersionInfo = (AsnDCTargetVersionInfo)oVersionLst.get(i);
                String strSerVersion = new String(oAsnDCTargetVersionInfo.strVersionName);
                if (null == strSelTargetVersion || 0 != Collator.getInstance().compare(strSelTargetVersion, strSerVersion)) continue;
                bVerFound = true;
                break;
            }
            if (!bVerFound) {
                ResourceManager oResManager = ResourceManager.getInstance();
                DCOptionPane.showMessageDialog((Component)this, oResManager.getResString(oResManager.getResString("UPDATE_OPERATION_NOT_SUPPORTED")), oResManager.getResString("ERROR_MESSAGE"), 0);
                return false;
            }
            this.handleVerResponse(oAsnDCTargetVersionInfo);
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog((Component)this, e.getMessage(), this.oResourceManager.getResString("ERROR_MESSAGE"), 0);
            DCDebugTracer.trace("DC::UpdateDataPanel::validateVerSelected::throw exception::" + e.getMessage());
            return false;
        }
        return true;
    }

    private void handleVerResponse(AsnDCTargetVersionInfo oAsnDCTargetVersionInfo) {
        ResourceManager oResManager = ResourceManager.getInstance();
        switch (oAsnDCTargetVersionInfo.enDataUpdateMode.value) {
            case 0: {
                break;
            }
            case 1: {
                DCOptionPane.showMessageDialog((Component)this, oResManager.getResString(oResManager.getResString("INTERNAL_UPDATE_SUPPORTED")), oResManager.getResString("INFORMATION"), 1);
                this.enabledDataStatus(false, 7);
                this.enabledDataStatus(false, 5);
                break;
            }
            case 2: {
                int confirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("INTERNAL_EXTERNAL_UPDATE_SUPPORTED"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
                if (confirm != 0) break;
                this.enabledDataStatus(false, 7);
                this.enabledDataStatus(false, 5);
                break;
            }
        }
    }

    private void enabledDataStatus(boolean bEnable, int iOpID) {
        List<ITaskDeviceOperation> oOperationLst = this.m_oParentTask.getSupportedOperation();
        int iOpCount = oOperationLst.size();
        for (int i = 0; i < iOpCount; ++i) {
            ITaskDeviceOperation oDevOperation = oOperationLst.get(i);
            if (iOpID != oDevOperation.getOperationId()) continue;
            oDevOperation.setEnabled(bEnable);
            if (bEnable) continue;
            oDevOperation.setSelected(bEnable);
            break;
        }
    }

    private void initBrowseButton(JPanel panel, final IBrowseDlgInterafce m_oBrowseDlgInstance) {
        this.button.setText(this.oResourceManager.getResString("BROWSE_DIALOG"));
        this.button.setBounds(260, 80, 22, 20);
        this.button.setEnabled(true);
        panel.add(this.button);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index;
                String strStartingPath = UpdateDataPanel.this.getSAMStartingPath();
                strStartingPath = strStartingPath.replace('\\', '/');
                String strRootPath = TKCommonUtil.getRootPath();
                if (!strRootPath.contains("\\") && !strRootPath.contains("/")) {
                    strRootPath = strRootPath + "/";
                }
                if (strRootPath.contains("\\")) {
                    strRootPath = strRootPath.replace('\\', '/');
                }
                if (strStartingPath.equals(UpdateDataPanel.EMPTY_STRING)) {
                    strStartingPath = strRootPath;
                }
                if (!strStartingPath.equals(strRootPath) && (index = strStartingPath.lastIndexOf("/")) > 0) {
                    strStartingPath = strStartingPath.substring(0, index);
                }
                try {
                    FileSelectionBrowseDlg browseDlg = new FileSelectionBrowseDlg(false, false, false, "UpdateData");
                    browseDlg.registBrowseDlgInterface(m_oBrowseDlgInstance);
                    browseDlg.setRootDir(strRootPath);
                    browseDlg.setDefaultPath(strStartingPath);
                    browseDlg.setVisible(true);
                }
                catch (DCException e1) {
                    DCOptionPane.showErrorDialog((Component)UpdateDataPanel.this, e1.getErrorCode());
                }
            }
        });
    }

    private String getSAMStartingPath() {
        AsnSAMTargerVersionDirLst oTargerVersionDirLst;
        String strTargetVersion = this.m_oParentTask.getTargetVersion();
        DeviceType oDeviceType = this.m_oParentTask.getDeviceType();
        DCDebugTracer.trace("UpdateDataPanel#getSAMStartingPath:" + strTargetVersion);
        AsnDCGetTargetVersionDirReq oAsnDCGetTargetVersionDirReq = new AsnDCGetTargetVersionDirReq();
        oAsnDCGetTargetVersionDirReq.iDeviceTypeId = new BigInteger(String.valueOf(oDeviceType.getDeviceTypeID()));
        oAsnDCGetTargetVersionDirReq.iDeviceTypeVersionID = new BigInteger(String.valueOf(oDeviceType.getDeviceTypeVersionID()));
        oAsnDCGetTargetVersionDirReq.strTargetVersionName = strTargetVersion.getBytes();
        oAsnDCGetTargetVersionDirReq.iFileContentType = new BigInteger(String.valueOf(-2));
        if (this.m_oParentTask.isBMSDomain()) {
            oAsnDCGetTargetVersionDirReq.strPatchVersionName = EMPTY_STRING.getBytes();
        }
        ISAMManager oSAManager = SAMManager.getInstance();
        String strPath = EMPTY_STRING;
        AsnDCGetTargetVersionDirRsp oAsnDCGetTargetVersionDirRsp = oSAManager.getAsnSAMGetTargetVersionDir(oAsnDCGetTargetVersionDirReq);
        if (oAsnDCGetTargetVersionDirRsp != null && 0 < (oTargerVersionDirLst = oAsnDCGetTargetVersionDirRsp.oTargerVersionDirLst).size()) {
            strPath = new String((byte[])oTargerVersionDirLst.get(0));
        }
        return strPath;
    }

    public void setTextField(String strPath) {
        this.m_oUpdatePathTextField.setText(strPath);
        this.m_oUpdatePathTextField.setToolTipText(strPath);
        this.m_oUpdatePathTextField.setCaretPosition(0);
        this.m_oConfigPara.setSelectedUpdateType(strPath);
    }

    public String getTextFieldPath() {
        return this.m_oUpdatePathTextField.getText();
    }

    @Override
    public void setFileOrDirectory(String strFilePath, String strVersion, boolean file) {
        this.setTextField(strFilePath);
    }
}

