/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.updatedata;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.devicemanagement.deviceoperation.updatedata.UpdateConfigParam;
import com.huawei.dc.devicemanagement.deviceoperation.updatedata.UpdateDataPanel;
import com.huawei.dc.taskmgmt.model.ITask;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class UpdateDataDlg
extends DCModalDialog {
    private static final long serialVersionUID = 1L;
    private ResourceManager oResourceManager;
    private UpdateDataPanel m_oUpdateDataPanel = null;
    private JButton cancelButton;
    private JButton okButton;
    private TitledBorder oTitledBorder = null;
    private Border oborder = null;
    private ITask m_oParentTask;

    public UpdateDataDlg(UpdateConfigParam oConfigPara, ITask oParentTask) {
        this.m_oParentTask = oParentTask;
        this.oResourceManager = ResourceManager.getInstance();
        this.m_oUpdateDataPanel = new UpdateDataPanel(oConfigPara, this.m_oParentTask);
        this.m_oUpdateDataPanel.setName("DeviceOperation_UpdataDataDlg_m_oUpdateDataPanel");
        this.m_oUpdateDataPanel.setBounds(17, 10, 336, 157);
        this.oTitledBorder = new TitledBorder(this.oborder, this.oResourceManager.getResString("SET_UPDATE_TOOL"));
        this.m_oUpdateDataPanel.setBorder(this.oTitledBorder);
        this.setTitle(this.oResourceManager.getResString("UPDATE_TOOL"));
        this.getContentPane().setLayout(null);
        this.getContentPane().add(this.m_oUpdateDataPanel);
        this.setSize(376, 241);
        this.initOKButton();
        this.initCancelButton();
        this.jInit();
    }

    private void initCancelButton() {
        this.cancelButton = new JButton();
        this.cancelButton.setName("DeviceOperation_UpdataDataDlg_cancelButton");
        this.cancelButton.setText(this.oResourceManager.getResString("CANCEL"));
        this.cancelButton.setBounds(273, 180, 80, 20);
        this.getContentPane().add(this.cancelButton);
    }

    private void initOKButton() {
        this.okButton = new JButton();
        this.okButton.setName("DeviceOperation_UpdataDataDlg_okButton");
        this.okButton.setText(this.oResourceManager.getResString("OK"));
        this.okButton.setBounds(185, 180, 80, 20);
        this.getContentPane().add(this.okButton);
    }

    public void jInit() {
        this.initializeButtonActions();
        this.initializeKeyStrokeActions();
    }

    private void initializeKeyStrokeActions() {
        ActionListener oEnterKeyHandler = this.createActionListenerForEnter();
        KeyStroke oEnterKeyStroke = KeyStroke.getKeyStroke(10, 0);
        this.registerKeyBoardActionFor(oEnterKeyStroke, oEnterKeyHandler);
    }

    private ActionListener createActionListenerForEnter() {
        ActionListener oEnterKeyHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdateDataDlg.this.okButton.doClick();
            }
        };
        return oEnterKeyHandler;
    }

    private void registerKeyBoardActionFor(KeyStroke oKeyStroke, ActionListener oKeyHandler) {
        this.rootPane.registerKeyboardAction(oKeyHandler, oKeyStroke, 2);
    }

    private void initializeButtonActions() {
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdateDataDlg.this.cancelButton_ActionPerformed();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdateDataDlg.this.oKButton_ActionPerformed();
            }
        });
    }

    @Override
    protected void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    protected void cancelButton_ActionPerformed() {
        this.m_oUpdateDataPanel.updateDataModel(false);
        this.closeDialog();
    }

    @Override
    protected void oKButton_ActionPerformed() {
        this.m_oUpdateDataPanel.updateDataModel(true);
        boolean bUpdationState = this.m_oUpdateDataPanel.validateInput();
        if (bUpdationState) {
            this.closeDialog();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UpdateDataDlg.this.m_oUpdateDataPanel.setTextField("");
                    UpdateDataDlg.this.m_oUpdateDataPanel.repaint();
                }
            });
        }
    }

    @Override
    protected String getCurrentContext() {
        return ResourceManager.getInstance().getResString("", "helpmapfile");
    }
}

