/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.save;

import com.huawei.dc.common.asndatacenter.AsnDCMultiDeviceErrLst;
import com.huawei.dc.common.asndatacenter.AsnDCOpertionRsp;
import com.huawei.dc.common.asndatacenter.AsnManualSaveInfo;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.ParaValue;
import com.huawei.dc.devicemanagement.deviceoperation.save.ManualSaveDlg;
import com.huawei.dc.devicemanagement.deviceoperation.save.ManualSaveOperation;
import com.huawei.dc.devicemanagement.deviceoperation.save.model.ManualSaveContentConfigParam;
import com.huawei.dc.devicemanagement.deviceoperation.save.model.SaveOperartionConfigInfo;
import com.huawei.dc.deviceoperation.DeviceOperationManagerImpl;
import com.huawei.dc.deviceoperation.IDeviceOperationManager;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.standalone.IManualOperation;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ManualSaveOperationPanel
extends JPanel {
    private Object[] m_oArrContentType;
    private static final long serialVersionUID = 1L;
    private static final int FIRST_NOT_EDITABLE_COL_INDEX = 0;
    private static final int CONTENT_TYPE_COL_INDEX = 3;
    private ResourceManager m_oResMgr = ResourceManager.getInstance();
    private ManualSaveOperation m_oManualSaveOperation;
    private boolean m_bIsContentTypeRequired;
    private JTable m_oTable;
    private DefaultTableModel m_oTableModel;
    private IManualOperation m_oManualOperation;
    private JScrollPane m_oScrollPane;
    private DeviceInfo[] m_arrSelectedDevInfo;
    private ManualSaveContentConfigParam m_oContentConfigParam;
    private IDeviceOperationManager m_oDevOperationMgr;
    private ManualSaveDlg m_oManualSaveDlg;
    private IDeviceInfoManager m_oDeviceInfoMgr;
    private transient TableCellRenderer tableCellRenderer = new TableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int iRow, int iCol) {
            JLabel oLabel = new JLabel();
            oLabel.setOpaque(true);
            if (isSelected) {
                oLabel.setBackground(table.getSelectionBackground());
                oLabel.setForeground(Color.white);
            } else {
                oLabel.setBackground(table.getBackground());
                oLabel.setForeground(table.getForeground());
            }
            if (null != value) {
                oLabel.setText(value.toString());
                oLabel.setToolTipText(value.toString());
            }
            return oLabel;
        }
    };

    public ManualSaveOperationPanel(ManualSaveOperation oSaveOperation, DeviceInfo[] arrSelectedDevInfo, ManualSaveContentConfigParam oSaveContentConfigParam, ManualSaveDlg oManualSaveDlg) {
        this.m_oDeviceInfoMgr = DeviceInfoManagerImpl.getInstance();
        this.m_oDevOperationMgr = oSaveOperation.getDeviceOperationManager();
        this.m_arrSelectedDevInfo = arrSelectedDevInfo;
        this.m_oManualSaveOperation = oSaveOperation;
        this.m_bIsContentTypeRequired = oSaveContentConfigParam.isContentTypeRequired();
        this.m_oContentConfigParam = oSaveContentConfigParam;
        this.m_oManualSaveDlg = oManualSaveDlg;
        this.m_oManualOperation = oSaveOperation.getManualOperation();
        this.setLayout(null);
        this.initScrollPane();
    }

    private void initScrollPane() {
        Vector oTableHeader = this.getTableHeader();
        boolean[] oarrEditableCol = this.getEditableCol(oTableHeader.size());
        this.m_oTableModel = this.getTableModel(oTableHeader, oarrEditableCol);
        this.initDataModel(this.m_oTableModel);
        this.m_oTable = this.initTable(this.m_oTableModel);
        this.m_oTable.setName("DeviceOperation_ManualSaveOperationPanel_m_oTable");
        this.initHeaderMouseListener(this.m_oTable);
        this.initTableMouseListener(this.m_oTable);
        this.initColumnWidth(this.m_oTable);
        this.initRenderer(this.m_oTable);
        this.m_oScrollPane = new JScrollPane(this.m_oTable);
        this.m_oScrollPane.setBounds(6, 8, 510, 265);
        this.add(this.m_oScrollPane);
    }

    public boolean isValidFileSelection() {
        int iRowCount = this.m_oTable.getRowCount();
        int iDataFileColumnIndex = 2;
        if (this.m_bIsContentTypeRequired) {
            ++iDataFileColumnIndex;
        }
        for (int iIndex = 0; iIndex < iRowCount; ++iIndex) {
            String strFileName = (String)this.m_oTable.getValueAt(iIndex, iDataFileColumnIndex);
            if (null != strFileName && !"".equals(strFileName.trim())) continue;
            return false;
        }
        return true;
    }

    private void initDataModel(DefaultTableModel tableModel) {
        int iRowCount = this.m_arrSelectedDevInfo.length;
        this.m_oArrContentType = this.m_oContentConfigParam.getContentTypeList();
        for (int iIndex = 0; iIndex < iRowCount; ++iIndex) {
            this.addRow(this.m_arrSelectedDevInfo[iIndex], iIndex);
        }
    }

    public void saveFilesToConfigPara() {
        int iDeviceId = -1;
        ParaValue oContentTypeParaValue = null;
        int iRowCount = -1;
        int iContentTypeId = -1;
        DeviceIPWithID oDeviceIPWithID = null;
        SaveOperartionConfigInfo oSaveOperationInfo = new SaveOperartionConfigInfo();
        this.m_oManualSaveOperation.setConfiguredParam(oSaveOperationInfo);
        iRowCount = this.m_oTable.getRowCount();
        for (int iRowIndex = 0; iRowIndex < iRowCount; ++iRowIndex) {
            if (this.m_bIsContentTypeRequired) {
                oContentTypeParaValue = (ParaValue)this.m_oTableModel.getValueAt(iRowIndex, 3);
                iContentTypeId = oContentTypeParaValue.getValue();
            }
            oDeviceIPWithID = (DeviceIPWithID)this.m_oTableModel.getValueAt(iRowIndex, 2);
            iDeviceId = oDeviceIPWithID.getDevId();
            oSaveOperationInfo.addSaveOperationInfo(iDeviceId, iContentTypeId);
        }
        this.m_oManualSaveOperation.setConfiguredParam(oSaveOperationInfo);
    }

    public void sendSaveOperationRequest() {
        SaveOperartionConfigInfo oSaveOPerationConfig = this.m_oManualSaveOperation.getConfiguredParam();
        ArrayList oSaveOperationInfo = (ArrayList)oSaveOPerationConfig.getSaveOperationInfo();
        this.m_oDevOperationMgr = DeviceOperationManagerImpl.getInstance();
        AsnDCOpertionRsp oAsnDCOperationRsp = new AsnDCOpertionRsp();
        SaveOperartionConfigInfo.SaveDeviceOperation oSaveDeviceOperation = null;
        int iContentType = -1;
        int iDeviceId = -1;
        AsnManualSaveInfo[] oArrAsnManualSaveInfo = new AsnManualSaveInfo[oSaveOperationInfo.size()];
        for (int index = 0; index < oSaveOperationInfo.size(); ++index) {
            oSaveDeviceOperation = (SaveOperartionConfigInfo.SaveDeviceOperation)oSaveOperationInfo.get(index);
            iContentType = oSaveDeviceOperation.getSelectedContentType();
            iDeviceId = oSaveDeviceOperation.getDeviceId();
            oArrAsnManualSaveInfo[index] = new AsnManualSaveInfo();
            oArrAsnManualSaveInfo[index].iDeviceID = BigInteger.valueOf(iDeviceId);
            if (!this.m_bIsContentTypeRequired) continue;
            oArrAsnManualSaveInfo[index].iContentType = BigInteger.valueOf(iContentType);
        }
        oAsnDCOperationRsp = this.m_oDevOperationMgr.save(oArrAsnManualSaveInfo);
        this.processSaveResponse(oAsnDCOperationRsp);
    }

    private void processSaveResponse(AsnDCOpertionRsp oAsnDCOperationRsp) {
        if (null != oAsnDCOperationRsp) {
            this.m_oManualSaveDlg.dispose();
            if (0 != oAsnDCOperationRsp.oErrorInfo.iErrorNo.intValue()) {
                String strMessage = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(oAsnDCOperationRsp.oErrorInfo.iErrorNo.intValue()));
                this.showMessageDialog(strMessage);
            } else {
                AsnDCMultiDeviceErrLst oAsnDCMultiDeviceErrList = oAsnDCOperationRsp.oResultOpt;
                this.updateDeviceTableForSuccessfulDevices(oAsnDCMultiDeviceErrList);
            }
        }
    }

    private void updateDeviceTableForSuccessfulDevices(AsnDCMultiDeviceErrLst asnDCMultiDeviceErrList) {
        int iNosDevices = this.m_arrSelectedDevInfo.length;
        for (int i = 0; i < iNosDevices; ++i) {
            this.m_oManualOperation.setOperationStartedStatusForDevice(this.m_arrSelectedDevInfo[i], 15);
        }
    }

    private void showMessageDialog(String strMessage) {
        DCOptionPane.showMessageDialog((Component)this, strMessage, ResourceManager.getInstance().getResString("ERROR"), 0);
    }

    private void addRow(DeviceInfo oDeviceInfo, int index) {
        Vector<Object> oRowData = new Vector<Object>(4);
        oRowData.add(++index);
        oRowData.add(oDeviceInfo.getDevName());
        DeviceIPWithID oDeviceIPWithID = new DeviceIPWithID();
        oDeviceIPWithID.setDevIp(oDeviceInfo.getDevIPAddress());
        oDeviceIPWithID.setDevId(oDeviceInfo.getDevId());
        oRowData.add(oDeviceIPWithID);
        if (0 != this.m_oArrContentType.length) {
            oRowData.add(this.m_oArrContentType[0]);
        } else {
            oRowData.add(" ");
        }
        this.m_oTableModel.addRow(oRowData);
    }

    private boolean[] getEditableCol(int iNoOfCol) {
        boolean[] obarrEditableCol = new boolean[iNoOfCol];
        int iIndex = 3;
        if (this.m_oContentConfigParam.isContentTypeRequired()) {
            obarrEditableCol[iIndex] = true;
        }
        return obarrEditableCol;
    }

    private Vector getTableHeader() {
        Vector<String> oHeaderNameList = new Vector<String>(8);
        oHeaderNameList.add(this.m_oResMgr.getResString("DEVICE_TABLE_COLUMN_SERIAL_NUMBER"));
        oHeaderNameList.add(this.m_oResMgr.getResString("DEVICE_NAME"));
        oHeaderNameList.add(this.m_oResMgr.getResString("SAVE_DEVICE_IP_COLUMN"));
        if (this.m_oContentConfigParam.isContentTypeRequired()) {
            oHeaderNameList.add(this.m_oResMgr.getResString("SAVE_CONTENT_TYPE"));
        }
        return oHeaderNameList;
    }

    private DefaultTableModel getTableModel(Vector oHeaderNameList, final boolean[] barrEditableCol) {
        return new DefaultTableModel(oHeaderNameList, 0){

            @Override
            public boolean isCellEditable(int row, int column) {
                return barrEditableCol[column];
            }
        };
    }

    private void initContentTypeCol(JTable oTable, TableColumn oContentTypeColumn) {
        if (null != this.m_oArrContentType) {
            oContentTypeColumn.setCellEditor(new ContentTypeCellEditor(this.m_oArrContentType));
            ContentTypeCellRenderer oRenderer = new ContentTypeCellRenderer(this.m_oArrContentType);
            oContentTypeColumn.setCellRenderer(oRenderer);
        }
    }

    private DefaultListSelectionModel getSelectionModel() {
        DefaultListSelectionModel odevSelection = new DefaultListSelectionModel();
        odevSelection.setSelectionMode(1);
        return odevSelection;
    }

    private JTable initTable(DefaultTableModel oDefaultTableModel) {
        JTable oDevTable = new JTable(oDefaultTableModel);
        DefaultListSelectionModel odevSelection = this.getSelectionModel();
        oDevTable.setSelectionModel(odevSelection);
        oDevTable.setFocusable(false);
        oDevTable.setRowSelectionAllowed(false);
        oDevTable.getTableHeader().setReorderingAllowed(false);
        oDevTable.setRowSelectionAllowed(true);
        oDevTable.setRowHeight(21);
        return oDevTable;
    }

    private void initColumnWidth(JTable oDevTable) {
        oDevTable.getColumnModel().getColumn(0).setMaxWidth(80);
        oDevTable.getColumnModel().getColumn(0).setMinWidth(50);
        oDevTable.getColumnModel().getColumn(0).setPreferredWidth(50);
    }

    private void initHeaderMouseListener(final JTable oDevTable) {
        oDevTable.getTableHeader().addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int oColNum = oDevTable.getColumnModel().getColumnIndexAtX(e.getX());
                if (oColNum > -1) {
                    oDevTable.getTableHeader().setToolTipText(oDevTable.getColumnName(oColNum));
                }
            }
        });
    }

    private void initTableMouseListener(final JTable oDevTable) {
        oDevTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int oColNum = oDevTable.getColumnModel().getColumnIndexAtX(e.getX());
                if (oColNum > -1) {
                    int oRowNum = oDevTable.rowAtPoint(e.getPoint());
                    ManualSaveOperationPanel.this.createCellRenderer(oDevTable, oColNum, oRowNum);
                }
            }
        });
    }

    private void createCellRenderer(JTable oDevTable, int oColNum, int oRowNum) {
        TableCellRenderer cellRenderer = oDevTable.getColumnModel().getColumn(oColNum).getCellRenderer();
        if (cellRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)cellRenderer).setToolTipText(oDevTable.getValueAt(oRowNum, oColNum).toString());
        }
    }

    private void initRenderer(JTable oDevTable) {
        for (int iColCount = 0; iColCount < 3; ++iColCount) {
            oDevTable.getColumnModel().getColumn(iColCount).setCellRenderer(this.tableCellRenderer);
        }
        int iIndex = 3;
        if (this.m_bIsContentTypeRequired) {
            TableColumn oContentTypeCol = oDevTable.getColumnModel().getColumn(iIndex++);
            this.initContentTypeCol(oDevTable, oContentTypeCol);
        }
    }

    private class DeviceIPWithID {
        private String strDevIp;
        private int iDevId;

        private DeviceIPWithID() {
        }

        public String getDevIp() {
            return this.strDevIp;
        }

        public void setDevIp(String strDevIp) {
            this.strDevIp = strDevIp;
        }

        public int getDevId() {
            return this.iDevId;
        }

        public void setDevId(int devId) {
            this.iDevId = devId;
        }

        public String toString() {
            return this.strDevIp;
        }
    }

    private class ContentTypeCellEditor
    extends DefaultCellEditor {
        public ContentTypeCellEditor(Object[] items) {
            super(new ComboBoxWithToolTip(items));
        }
    }

    public class ContentTypeCellRenderer
    extends ComboBoxWithToolTip
    implements TableCellRenderer {
        public ContentTypeCellRenderer(Object[] oContentType) {
            super(oContentType);
            this.setSelectedItem(oContentType[0]);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelectedItem(value);
            return this;
        }
    }
}

