/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.recoverdb;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCFile;
import com.huawei.dc.common.asndatacenter.AsnDCFileLst;
import com.huawei.dc.common.components.dialog.IBrowseDlgInterafce;
import com.huawei.dc.common.components.dialog.ProgressDlg;
import com.huawei.dc.common.components.dialog.fileselection.FileSelectionBrowseDlg;
import com.huawei.dc.common.components.treetable.model.DCTreeTableModel;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.view.JSortTreeTable;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.CheckBoxHeader;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.RecoverDBConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.RecoverDBRowData;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.RecoverElementInfo;
import com.huawei.dc.deviceoperation.RecoverInfoManager;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import com.huawei.dc.taskmgmt.view.common.CheckBoxOperation;
import com.huawei.dc.taskmgmt.view.common.ComboBoxOperation;
import com.swimap.iview.templates.filtertreetable.TreeTableModel;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.math.BigInteger;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class RecoverTablePanel
extends JPanel
implements IBrowseDlgInterafce {
    private static final long serialVersionUID = -290657150122496639L;
    private THashSet<Resource> m_oResourceList = null;
    private RecoverDBConfigPara m_oRecoverDBConfigPara = null;
    private ProgressDlg m_oProgressDlg = null;
    private byte[] m_oSyncObject = new byte[0];
    private HashMap<Integer, List<String>> m_oDevIDFileListMap = new HashMap(0);
    public JSortTreeTable m_oTaskTreeTable;
    private DCTreeTableModel m_oTaskTreeTableModel;
    private JScrollPane m_oScrollPane;
    private TreeTableNode m_oRootNode;
    private boolean m_bIsViewStatus = false;
    private FileSelectionBrowseDlg m_oRecoverFileBrowseDlg = null;
    private static final int DELEVE_TO_BOARD_COLUMN_INDEX = 5;
    protected CheckBoxHeader m_oCheckBoxHeader = null;
    private int m_iSelectionType = 0;

    public RecoverTablePanel(RecoverDBConfigPara oRecoverDBConfigPara, THashSet<Resource> oResList, boolean bIsView) {
        List<RecoverElementInfo> oElementInfoList;
        this.m_oResourceList = oResList;
        this.m_oRecoverDBConfigPara = oRecoverDBConfigPara;
        this.m_bIsViewStatus = bIsView;
        this.jbinit();
        if (!bIsView) {
            try {
                this.initializeRecoverManager(this.m_oResourceList);
            }
            catch (DCException e) {
                DCDebugTracer.trace(e);
            }
        }
        if ((oElementInfoList = this.m_oRecoverDBConfigPara.getRecoverElementInfoLst()) != null && oElementInfoList.size() > 0) {
            this.populateDeviceInTable(oElementInfoList);
        } else {
            this.populateDeviceInTable();
        }
        this.initializeCellRenderers();
        this.m_oTaskTreeTable.setShowVerticalLines(true);
        this.updateTableView();
    }

    public void setRecoverDBConfigPara(boolean bValue) {
        TreeTableNode rootNode = this.getRootNode();
        int devCount = rootNode.getChildCount();
        for (int i = 0; i < devCount; ++i) {
            TreeTableNode devNode = (TreeTableNode)rootNode.getChildAt(i);
            RecoverDBRowData oRecoverDBRowData = (RecoverDBRowData)devNode.getUserObject();
            CheckBoxOperation oCheckBoxOperation = oRecoverDBRowData.getDeliverToBoard();
            if (null == oCheckBoxOperation) continue;
            oCheckBoxOperation.setIsSelect(bValue);
        }
        this.updateTableView();
    }

    public void populateDeviceInTable() {
        Comparator comp = new Comparator(){

            public int compare(Object o1, Object o2) {
                Resource p1 = (Resource)o1;
                Resource p2 = (Resource)o2;
                String p1Str = p1.getDeviceName();
                String p2Str = p2.getDeviceName();
                int iReturnValue = Collator.getInstance().compare(p1Str, p2Str);
                return iReturnValue;
            }
        };
        ArrayList<Resource> oResLst = new ArrayList<Resource>();
        Iterator oResItor = this.m_oResourceList.iterator();
        Resource oRes = null;
        while (oResItor.hasNext()) {
            oRes = (Resource)oResItor.next();
            oResLst.add(oRes);
        }
        Collections.sort(oResLst, comp);
        this.m_oRootNode.removeAllChildren();
        int count = oResLst.size();
        for (int i = 0; i < count; ++i) {
            Resource oResource = (Resource)oResLst.get(i);
            CheckBoxOperation oDeviceNodeCheckBox = new CheckBoxOperation();
            oDeviceNodeCheckBox.setIsShow(true);
            oDeviceNodeCheckBox.setIsSelect(false);
            ComboBoxOperation oFilePathComboBox = new ComboBoxOperation();
            oFilePathComboBox.setIsShow(true);
            oFilePathComboBox.setComboBox(this.getComboBoxForDevID(oResource.getDeviceID(), null));
            oFilePathComboBox.setSelectedItem(null);
            RecoverDBRowData oDevNodeInfo = new RecoverDBRowData(-1, oResource, 2, oResource.getDeviceType(), oFilePathComboBox, oDeviceNodeCheckBox);
            this.setDeviceNodeCheckBoxTrue(oFilePathComboBox, oDeviceNodeCheckBox);
            TreeTableNode oDevNode = new TreeTableNode(oDevNodeInfo);
            this.m_oRootNode.add(oDevNode);
        }
    }

    private CheckBoxOperation setDeviceNodeCheckBoxTrue(ComboBoxOperation oFilePathComboBox, CheckBoxOperation oDeviceNodeCheckBox) {
        Object object;
        ComboBoxWithToolTip oComboBoxWithToolTip = oFilePathComboBox.getComboBox();
        if (null != oComboBoxWithToolTip && null != (object = oComboBoxWithToolTip.getSelectedItem()) && !object.toString().equals(" ")) {
            oDeviceNodeCheckBox.setIsSelect(true);
        }
        return oDeviceNodeCheckBox;
    }

    private void populateDeviceInTable(List<RecoverElementInfo> elementInfoList) {
        this.m_oRootNode.removeAllChildren();
        int devCount = elementInfoList.size();
        for (int j = 0; j < devCount; ++j) {
            RecoverElementInfo oElementInfo = elementInfoList.get(j);
            Resource oResource = oElementInfo.getResource();
            CheckBoxOperation oDeviceNodeCheckBox = new CheckBoxOperation();
            oDeviceNodeCheckBox.setIsShow(true);
            oDeviceNodeCheckBox.setIsSelect(oElementInfo.isDeliverToBoard());
            ComboBoxOperation oFilePathComboBox = new ComboBoxOperation();
            oFilePathComboBox.setIsShow(true);
            oFilePathComboBox.setComboBox(this.getComboBoxForDevID(oResource.getDeviceID(), oElementInfo.getRecoverFilePath()));
            oFilePathComboBox.setSelectedItem(oElementInfo.getRecoverFilePath());
            RecoverDBRowData oDevNodeInfo = new RecoverDBRowData(oElementInfo.getGroupID(), oResource, 2, oResource.getDeviceType(), oFilePathComboBox, oDeviceNodeCheckBox);
            TreeTableNode devNode = new TreeTableNode(oDevNodeInfo);
            this.m_oRootNode.add(devNode);
        }
    }

    private ComboBoxWithToolTip getComboBoxForDevID(int iDevID, String strSelectedFilePath) {
        final ComboBoxWithToolTip oComboBox = new ComboBoxWithToolTip();
        List<String> oFileList = this.m_oDevIDFileListMap.get(iDevID);
        boolean bSelectedFilePresent = false;
        String strBrowseItem = DCFrameWorkUtil.getLocalizedString("RECOVER_BROWSE_BTN");
        oComboBox.addItem(" ");
        oComboBox.addItem(strBrowseItem);
        if (null != oFileList && 0 != oFileList.size()) {
            if (null != strSelectedFilePath && oFileList.contains(strSelectedFilePath)) {
                bSelectedFilePresent = true;
            }
            for (int i = 0; i < oFileList.size(); ++i) {
                oComboBox.addItem(oFileList.get(i));
            }
        }
        if (null != strSelectedFilePath && !bSelectedFilePresent && 0 != strSelectedFilePath.trim().length()) {
            oComboBox.addItem(strSelectedFilePath);
        }
        int iComboboxcount = oComboBox.getItemCount();
        if (null != strSelectedFilePath && 0 != strSelectedFilePath.length()) {
            oComboBox.setSelectedItem(strSelectedFilePath);
        } else if (iComboboxcount <= 2) {
            oComboBox.setSelectedIndex(0);
        } else {
            oComboBox.setSelectedIndex(2);
        }
        oComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (null != oComboBox && null != oComboBox.getSelectedItem()) {
                    String strToolTip = String.valueOf(oComboBox.getSelectedItem());
                    oComboBox.setToolTipText(strToolTip);
                    if (strToolTip.equalsIgnoreCase(DCFrameWorkUtil.getLocalizedString("RECOVER_BROWSE_BTN"))) {
                        oComboBox.setSelectedIndex(0);
                        RecoverTablePanel.this.browseDlg();
                    }
                }
            }
        });
        return oComboBox;
    }

    private void browseDlg() {
        try {
            int arrSelectedRow = this.m_oTaskTreeTable.getSelectedRow();
            TreePath oTreePath = this.m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRow);
            TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            RecoverDBRowData nodeInfo = (RecoverDBRowData)oNode.getUserObject();
            int iDeviceId = nodeInfo.getDevId();
            int iDeviceDomain = this.getDeviceDomain(iDeviceId);
            this.m_oRecoverFileBrowseDlg = 4 == iDeviceDomain ? new FileSelectionBrowseDlg(false, false, false, "Recover") : new FileSelectionBrowseDlg(iDeviceDomain, false, false, "Recover", null);
            this.m_oRecoverFileBrowseDlg.setTitle(DCFrameWorkUtil.getLocalizedString("RECOVER_DLG_SELECT_FILE_TITLE"));
            this.m_oRecoverFileBrowseDlg.registBrowseDlgInterface(this);
            this.m_oRecoverFileBrowseDlg.setVisible(true);
        }
        catch (DCException oDCException) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), oDCException.getMessage(), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
        }
    }

    private int getDeviceDomain(int iDevId) {
        int iDeviceDomain = -1;
        IDeviceInfoManager oDevInfoMgr = DeviceInfoManagerImpl.getInstance();
        DeviceInfo oDeviceInfo = oDevInfoMgr.getDevice(iDevId);
        DeviceTypeInfo oDeviceTypeInfo = oDeviceInfo.getDeviceTypeInfo();
        iDeviceDomain = oDeviceTypeInfo.getDevDomain();
        return iDeviceDomain;
    }

    private void jbinit() {
        this.setLayout(new BorderLayout());
        this.createTreeTable();
        this.m_oScrollPane = new JScrollPane((Component)((Object)this.m_oTaskTreeTable));
        this.m_oScrollPane.setName("DeviceMgmt_RecoverTablePanel_m_oScrollPane");
        this.m_oScrollPane.setBounds(3, 24, 832, 365);
        this.add((Component)this.m_oScrollPane, "Center");
        this.setFocusable(true);
    }

    private void createTreeTable() {
        this.createTreeTableModel();
        this.m_oTaskTreeTable = new JSortTreeTable(this.m_oTaskTreeTableModel);
        this.m_oTaskTreeTable.setName("DeviceOperation_RecoverTablePanel_m_oTaskTreeTable");
        this.initializeSelectionSingleModel();
        this.initializeTreeTable();
    }

    private void createTreeTableModel() {
        String[] strColumnNames = this.getColumnNames();
        Class[] arrColumnTypes = this.getColumnTypes();
        boolean[] arrSortableColumns = this.getSortableColumns();
        boolean[] arrEditableColumns = this.getEditableColumns();
        this.m_oTaskTreeTableModel = new DCTreeTableModel(strColumnNames, arrColumnTypes, arrSortableColumns, arrEditableColumns, this.getMethodNames());
        this.m_oRootNode = this.m_oTaskTreeTableModel.getRoot();
    }

    public String[] getColumnNames() {
        String[] strColumnNames = new String[]{ResourceManager.getInstance().getResString("RESOURCE_NAME"), ResourceManager.getInstance().getResString("RESOURCE_TYPE"), ResourceManager.getInstance().getResString("DEVICE_IP_FOR_PACKAGE_TASK"), ResourceManager.getInstance().getResString("DEVICE_VERSION_FOR_PACKAGE_TASK"), ResourceManager.getInstance().getResString("RECOVER_FILE_PATH"), ResourceManager.getInstance().getResString("MULDEVICE_RECOVER_DLG_DELVER_TO_BOARD_REBOOT")};
        return strColumnNames;
    }

    public Class[] getColumnTypes() {
        Class[] arrColumnTypes = new Class[]{TreeTableModel.class, String.class, String.class, String.class, String.class, Boolean.TYPE};
        return arrColumnTypes;
    }

    public boolean[] getSortableColumns() {
        boolean[] arrSortableColumns = new boolean[]{false, false, false, false, false, false};
        return arrSortableColumns;
    }

    public boolean[] getEditableColumns() {
        boolean[] arrEditableColumns = new boolean[]{true, false, false, false, true, true};
        return arrEditableColumns;
    }

    public String[] getMethodNames() {
        return RecoverDBRowData.getMethodNames();
    }

    public void initializeSelectionSingleModel() {
        DefaultListSelectionModel oTaskSelection = new DefaultListSelectionModel();
        oTaskSelection.setSelectionMode(0);
        this.m_oTaskTreeTable.setSelectionModel(oTaskSelection);
    }

    private void initializeTreeTable() {
        this.m_oTaskTreeTable.getTableHeader().setReorderingAllowed(false);
        this.m_oTaskTreeTable.getTree().setCellRenderer(new MyCellRenderer());
        this.m_oTaskTreeTable.addMouseListener(this.generateMouseAdapterForTable());
        this.m_oTaskTreeTable.setRowHeight(20);
        this.m_oTaskTreeTable.setShowHorizontalLines(true);
        this.m_oTaskTreeTable.setShowVerticalLines(false);
        this.m_oTaskTreeTable.setColumnSelectionAllowed(false);
        this.m_oTaskTreeTable.setRowSelectionAllowed(true);
    }

    private MouseAdapter generateMouseAdapterForTable() {
        return new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent oMouseEvent) {
                RecoverTablePanel.this.taskTable_MouseReleased(oMouseEvent);
            }
        };
    }

    public void taskTable_MouseReleased(MouseEvent oMouseEvent) {
        int iClickedColumn;
        if (this.getViewStatus()) {
            return;
        }
        int arrSelectedRow = this.m_oTaskTreeTable.getSelectedRow();
        TreePath oTreePath = this.m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRow);
        TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
        RecoverDBRowData nodeInfo = (RecoverDBRowData)oNode.getUserObject();
        if (nodeInfo.getNodeType() == 2 && (iClickedColumn = this.m_oTaskTreeTable.columnAtPoint(oMouseEvent.getPoint())) == 5) {
            CheckBoxOperation operation = nodeInfo.getDeliverToBoard();
            if (!operation.getIsSelect()) {
                operation.setIsSelect(true);
            } else {
                operation.setIsSelect(false);
            }
            this.m_oTaskTreeTable.updateUI();
        }
    }

    public void setCellRenderer(JLabel label, Object value) {
        TreeTableNode node = (TreeTableNode)value;
        RecoverDBRowData nodeInfo = (RecoverDBRowData)node.getUserObject();
        if (nodeInfo != null) {
            ImageIcon m_oSelectIcon = nodeInfo.getNodeType() == 1 ? ResourceManager.getInstance().getImage("folderopen.gif") : ResourceManager.getInstance().getImage("ic_device.gif");
            label.setIcon(m_oSelectIcon);
        }
        label.setText(value.toString());
    }

    private void initializeCellRenderers() {
        this.m_oTaskTreeTable.setShowHorizontalLines(true);
        FileColumnRenderer oFileColumnRenderer = new FileColumnRenderer();
        ComboBoxOperation oFilePathComboBox = new ComboBoxOperation();
        oFilePathComboBox.setIsShow(false);
        oFilePathComboBox.setComboBox(new ComboBoxWithToolTip());
        oFilePathComboBox.setSelectedItem(null);
        this.m_oTaskTreeTable.getColumnModel().getColumn(4).setCellRenderer(oFileColumnRenderer);
        this.m_oTaskTreeTable.getColumnModel().getColumn(4).setCellEditor(new FileColumnEditor(oFilePathComboBox));
        this.m_oTaskTreeTable.getColumnModel().getColumn(5).setCellRenderer(new OperationSelecCheckBoxRenderer());
        this.customizeParseChhBox();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeRecoverManager(THashSet<Resource> oResList) throws DCException {
        this.m_oProgressDlg = new ProgressDlg(43821);
        this.m_oProgressDlg.setName("DeviceOperation_RecoverDlg_m_dlg");
        RecoverInfoManager.getInstance().setComponentForResponse(this, this.m_oSyncObject);
        byte[] byArray = this.m_oSyncObject;
        synchronized (this.m_oSyncObject) {
            int iReqId = DCFrameWorkUtil.generateRequestId();
            this.m_oProgressDlg.setProgressDlgId(iReqId);
            int success = RecoverInfoManager.getInstance().openRecoverDialog(iReqId, this.getDevInfoArrayFromList(oResList));
            if (0 != success) {
                throw new DCException(ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(success)));
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RecoverTablePanel.this.m_oProgressDlg.setTitle(DCFrameWorkUtil.getLocalizedString("MULDEVICE_RECOVER_DLG_PROGRESSBAR_TITLE"));
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.m_oProgressDlg.setVisible(true);
            return;
        }
    }

    private DeviceInfo[] getDevInfoArrayFromList(THashSet<Resource> oResList) {
        List<DeviceInfo> oDevInfoList = this.getDeviceInfoList(oResList);
        DeviceInfo[] oDevTypeArr = new DeviceInfo[oDevInfoList.size()];
        for (int i = 0; i < oDevInfoList.size(); ++i) {
            oDevTypeArr[i] = oDevInfoList.get(i);
        }
        return oDevTypeArr;
    }

    private List<DeviceInfo> getDeviceInfoList(THashSet<Resource> oResList) {
        ArrayList<DeviceInfo> oDevInfoList = new ArrayList<DeviceInfo>(0);
        Iterator oResItor = oResList.iterator();
        Resource oRes = null;
        while (oResItor.hasNext()) {
            oRes = (Resource)oResItor.next();
            int iDeviceId = oRes.getDeviceID();
            oDevInfoList.add(DeviceInfoManagerImpl.getInstance().getDevice(iDeviceId));
        }
        return oDevInfoList;
    }

    public void addFilesToFilePathMap(AsnDCFileLst oFileList, int iDevId) {
        int iNoOfFiles = oFileList.size();
        String strFileName = null;
        ArrayList<String> oFileListForDevId = new ArrayList<String>(0);
        for (int i = 0; i < iNoOfFiles; ++i) {
            strFileName = new String(((AsnDCFile)oFileList.get((int)i)).strTimeOrFileName);
            oFileListForDevId.add(strFileName);
        }
        this.m_oDevIDFileListMap.put(iDevId, oFileListForDevId);
    }

    public void updateProgressValue(final int iProgressValue, String strDeviceName, String strOperationResult) {
        this.m_oProgressDlg.setProgress(strDeviceName, strOperationResult, iProgressValue);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (iProgressValue == 100) {
                    RecoverTablePanel.this.m_oProgressDlg.setVisible(false);
                    RecoverTablePanel.this.m_oProgressDlg.dispose();
                }
            }
        });
    }

    public boolean getViewStatus() {
        return this.m_bIsViewStatus;
    }

    public void updateTableView() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RecoverTablePanel.this.m_oTaskTreeTable.getTableHeader().updateUI();
                RecoverTablePanel.this.m_oTaskTreeTable.updateUI();
                RecoverTablePanel.this.updateUI();
            }
        });
    }

    @Override
    public void setFileOrDirectory(String strFilePath, String strVersion, boolean file) {
        boolean bFilefound = false;
        int iSelectedRow = this.m_oTaskTreeTable.getSelectedRow();
        TreePath oTreePath = this.m_oTaskTreeTable.getTree().getPathForRow(iSelectedRow);
        TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
        RecoverDBRowData nodeInfo = (RecoverDBRowData)oNode.getUserObject();
        ComboBoxWithToolTip oComboBox = nodeInfo.getFilePathComboBox().getComboBox();
        int iFileComboBoxItemCount = oComboBox.getItemCount();
        for (int index = 0; index < iFileComboBoxItemCount; ++index) {
            String strSelectedItem = oComboBox.getItemAt(index).toString();
            if (!strSelectedItem.trim().equals(strFilePath.trim())) continue;
            oComboBox.setSelectedItem(strSelectedItem);
            bFilefound = true;
            break;
        }
        if (!bFilefound) {
            oComboBox.addItem(strFilePath);
            oComboBox.setSelectedItem(strFilePath);
        }
    }

    public TreeTableNode getRootNode() {
        return this.m_oRootNode;
    }

    public ValidationResult validateRecoverFileSelection() {
        ValidationResult oValidationResult = new ValidationResult();
        oValidationResult.setErrorCode(0);
        TreeTableNode oRootNode = this.getRootNode();
        int iCount = oRootNode.getChildCount();
        for (int i = 0; i < iCount; ++i) {
            TreeTableNode oDevNode = (TreeTableNode)oRootNode.getChildAt(i);
            RecoverDBRowData oDevNodeInfo = (RecoverDBRowData)oDevNode.getUserObject();
            String strFilePath = (String)oDevNodeInfo.getFilePathComboBox().getComboBox().getSelectedItem();
            if (null != strFilePath && 0 != strFilePath.trim().length()) continue;
            oValidationResult.setErrorCode(-1);
            oValidationResult.setErrorMessage(DCFrameWorkUtil.getLocalizedString("RECOVER_SOME_FILE_SELECTRED_ERROR"));
            return oValidationResult;
        }
        return oValidationResult;
    }

    public List<RecoverElementInfo> getRecoverElementInfoLst() {
        ArrayList<RecoverElementInfo> oElememtInfoList = new ArrayList<RecoverElementInfo>(0);
        TreeTableNode oRootNode = this.getRootNode();
        int iCount = oRootNode.getChildCount();
        for (int i = 0; i < iCount; ++i) {
            TreeTableNode oDevNode = (TreeTableNode)oRootNode.getChildAt(i);
            RecoverElementInfo oElementInfo = new RecoverElementInfo();
            RecoverDBRowData oDevNodeInfo = (RecoverDBRowData)oDevNode.getUserObject();
            oElementInfo.setGroupID(-1);
            oElementInfo.setResource(oDevNodeInfo.getResource());
            oElementInfo.setDeliverToBoard(oDevNodeInfo.getDeliverToBoard().getIsSelect());
            oElementInfo.setRecoverFilePath((String)oDevNodeInfo.getFilePathComboBox().getComboBox().getSelectedItem());
            oElementInfo.setSequenceID(-1);
            oElememtInfoList.add(oElementInfo);
        }
        return oElememtInfoList;
    }

    public void setViewStatus(boolean isViewStatus) {
        this.m_bIsViewStatus = isViewStatus;
    }

    public void deleteDevByTable(Vector<Integer> deleteDevList) {
        int count = deleteDevList.size();
        for (int i = 0; i < count; ++i) {
            int devId = deleteDevList.get(i);
            int devCount = this.m_oRootNode.getChildCount();
            for (int j = 0; j < devCount; ++j) {
                TreeTableNode devNode = (TreeTableNode)this.m_oRootNode.getChildAt(j);
                RecoverDBRowData devNodeInfo = (RecoverDBRowData)devNode.getUserObject();
                if (devId != devNodeInfo.getDevId()) continue;
                devNode.removeFromParent();
                j = devCount;
            }
        }
        this.updateTableView();
    }

    public void addDevToTable(THashSet<Resource> oResourcesLst, Vector<Integer> addDevList) {
        try {
            this.initializeRecoverManager(oResourcesLst);
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
        }
        int count = addDevList.size();
        for (int i = 0; i < count; ++i) {
            int devId = addDevList.get(i);
            TreeTableNode newDevNode = this.createDevNode(devId, oResourcesLst);
            this.m_oRootNode.add(newDevNode);
        }
        this.updateTableView();
    }

    public TreeTableNode createDevNode(int devId, THashSet<Resource> oResources) {
        TreeTableNode devNode = null;
        Iterator oResItor = oResources.iterator();
        Resource oResource = null;
        while (oResItor.hasNext()) {
            oResource = (Resource)oResItor.next();
            if (oResource.getDeviceID() != devId) continue;
            CheckBoxOperation oDeviceNodeCheckBox = new CheckBoxOperation();
            oDeviceNodeCheckBox.setIsShow(true);
            oDeviceNodeCheckBox.setIsSelect(true);
            ComboBoxOperation oFilePathComboBox = new ComboBoxOperation();
            oFilePathComboBox.setIsShow(true);
            oFilePathComboBox.setComboBox(this.getComboBoxForDevID(oResource.getDeviceID(), null));
            oFilePathComboBox.setSelectedItem(null);
            RecoverDBRowData oDevNodeInfo = new RecoverDBRowData(-1, oResource, 2, oResource.getDeviceType(), oFilePathComboBox, oDeviceNodeCheckBox);
            devNode = new TreeTableNode(oDevNodeInfo);
        }
        return devNode;
    }

    private void customizeParseChhBox() {
        TableColumn oSaveCoulmn = this.addCheckBoxForDeleveToBoardHeader(true);
        oSaveCoulmn.setHeaderRenderer(this.m_oCheckBoxHeader);
    }

    private TableColumn addCheckBoxForDeleveToBoardHeader(boolean bSetHeaderSave) {
        ChckBoxHeaderItemLstner oChckItemListener = new ChckBoxHeaderItemLstner();
        TableColumn oSaveCoulmn = this.m_oTaskTreeTable.getColumnModel().getColumn(5);
        this.m_oTaskTreeTable.getTableHeader().setPreferredSize(new Dimension(this.m_oTaskTreeTable.getSize().width, 28));
        this.m_oCheckBoxHeader = new CheckBoxHeader((ItemListener)oChckItemListener, bSetHeaderSave, this, this.m_oTaskTreeTable.getTableHeader().getBackground());
        return oSaveCoulmn;
    }

    private void setCheckBoxStatusOnDevRow() {
        this.m_iSelectionType = this.getSelectedType();
        if (2 == this.m_iSelectionType || 1 == this.m_iSelectionType) {
            this.setRecoverDBConfigPara(true);
        } else {
            this.setRecoverDBConfigPara(false);
        }
    }

    public int getSelectionType() {
        return this.m_iSelectionType;
    }

    public int getSelectedType() {
        TreeTableNode rootNode = this.getRootNode();
        int devCount = rootNode.getChildCount();
        int iAlreadySelectedParseCount = 0;
        for (int i = 0; i < devCount; ++i) {
            TreeTableNode devNode = (TreeTableNode)rootNode.getChildAt(i);
            RecoverDBRowData oRecoverDBRowData = (RecoverDBRowData)devNode.getUserObject();
            CheckBoxOperation oCheckBoxOperation = oRecoverDBRowData.getDeliverToBoard();
            if (null == oCheckBoxOperation || !oCheckBoxOperation.getIsSelect()) continue;
            ++iAlreadySelectedParseCount;
        }
        if (devCount == iAlreadySelectedParseCount && iAlreadySelectedParseCount > 0) {
            this.m_iSelectionType = 0;
        }
        if (iAlreadySelectedParseCount == 0) {
            this.m_iSelectionType = 2;
        }
        if (devCount > iAlreadySelectedParseCount && iAlreadySelectedParseCount > 0) {
            this.m_iSelectionType = 1;
        }
        return this.m_iSelectionType;
    }

    class ChckBoxHeaderItemLstner
    implements ItemListener {
        ChckBoxHeaderItemLstner() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (!(source instanceof CheckBoxHeader)) {
                return;
            }
            RecoverTablePanel.this.setCheckBoxStatusOnDevRow();
            RecoverTablePanel.this.m_oCheckBoxHeader.handleHeaderChckBxChanges();
            this.refreshTable();
        }

        public void refreshTable() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (null != RecoverTablePanel.this.m_oCheckBoxHeader) {
                        RecoverTablePanel.this.m_oCheckBoxHeader.repaint();
                        RecoverTablePanel.this.m_oCheckBoxHeader.updateUI();
                    }
                }
            });
        }
    }

    private class OperationSelecCheckBoxRenderer
    extends JLabel
    implements TableCellRenderer,
    Serializable {
        private static final long serialVersionUID = 1L;

        public OperationSelecCheckBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, UIManager.getColor("Table.gridColor")));
        }

        @Override
        public Component getTableCellRendererComponent(JTable oOpTable, Object value, boolean bIsSelected, boolean bhasFocus, int iRow, int iColumn) {
            if (value instanceof CheckBoxOperation) {
                CheckBoxOperation pause = (CheckBoxOperation)value;
                if (pause.getIsShow()) {
                    ImageIcon m_oSelectIcon = ResourceManager.getInstance().getImage("noneselect.gif");
                    if (pause.getIsSelect()) {
                        m_oSelectIcon = ResourceManager.getInstance().getImage("all.gif");
                        this.setIcon(m_oSelectIcon);
                    } else {
                        this.setIcon(m_oSelectIcon);
                    }
                    RecoverTablePanel.this.m_oCheckBoxHeader.handleHeaderChckBxChanges();
                    RecoverTablePanel.this.m_oCheckBoxHeader.refreshTable();
                } else {
                    this.setIcon(null);
                    this.setText("");
                }
            } else {
                this.setIcon(null);
                this.setText("");
                this.setBackground(RecoverTablePanel.this.m_oTaskTreeTable.getBackground());
            }
            if (bIsSelected) {
                this.setBackground(RecoverTablePanel.this.m_oTaskTreeTable.getSelectionBackground());
                this.setForeground(RecoverTablePanel.this.m_oTaskTreeTable.getSelectionForeground());
            } else {
                this.setBackground(RecoverTablePanel.this.m_oTaskTreeTable.getBackground());
                this.setForeground(RecoverTablePanel.this.m_oTaskTreeTable.getForeground());
            }
            this.updateUI();
            return this;
        }
    }

    private class FileColumnEditor
    extends DefaultCellEditor
    implements Serializable {
        private static final long serialVersionUID = 1L;
        ComboBoxWithToolTip m_oFilePathComboBox;

        FileColumnEditor(ComboBoxOperation fileComBox) {
            super(fileComBox.getComboBox());
            this.m_oFilePathComboBox = null;
            if (fileComBox.getIsShow()) {
                this.m_oFilePathComboBox = fileComBox.getComboBox();
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ComboBoxOperation oComboBox;
            ComboBoxWithToolTip oComp = null;
            JLabel oLabel = new JLabel();
            oLabel.setOpaque(true);
            if (value instanceof ComboBoxOperation && (oComboBox = (ComboBoxOperation)value).getIsShow() && !RecoverTablePanel.this.getViewStatus()) {
                oComp = oComboBox.getComboBox();
            }
            return oComp;
        }
    }

    private class FileColumnRenderer
    extends JLabel
    implements TableCellRenderer,
    Serializable {
        private static final long serialVersionUID = -3554271648648591508L;

        public FileColumnRenderer() {
            this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, UIManager.getColor("Table.gridColor")));
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent oComp;
            if (value instanceof ComboBoxOperation) {
                ComboBoxOperation oComboBox = (ComboBoxOperation)value;
                if (oComboBox.getIsShow()) {
                    if (!RecoverTablePanel.this.getViewStatus()) {
                        oComp = oComboBox.getComboBox();
                    } else {
                        this.setBackground(RecoverTablePanel.this.m_oTaskTreeTable.getBackground());
                        if (null != oComboBox.getSelectedItem()) {
                            this.setText((String)oComboBox.getSelectedItem());
                        }
                        oComp = this;
                    }
                } else {
                    this.setBackground(RecoverTablePanel.this.m_oTaskTreeTable.getBackground());
                    this.setText("");
                    oComp = this;
                }
            } else {
                this.setBackground(RecoverTablePanel.this.m_oTaskTreeTable.getBackground());
                this.setText("");
                oComp = this;
            }
            if (isSelected) {
                this.setBackground(RecoverTablePanel.this.m_oTaskTreeTable.getSelectionBackground());
                this.setForeground(RecoverTablePanel.this.m_oTaskTreeTable.getSelectionForeground());
            } else {
                this.setBackground(RecoverTablePanel.this.m_oTaskTreeTable.getBackground());
                this.setForeground(RecoverTablePanel.this.m_oTaskTreeTable.getForeground());
            }
            this.updateUI();
            return oComp;
        }
    }

    class MyCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        private static final long serialVersionUID = -3905322891212088102L;

        MyCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            RecoverTablePanel.this.setCellRenderer(this, value);
            return this;
        }
    }
}

