/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.recoverdb;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCFile;
import com.huawei.dc.common.asndatacenter.AsnDCFileLst;
import com.huawei.dc.common.components.dialog.IBrowseDlgInterafce;
import com.huawei.dc.common.components.dialog.ProgressDlg;
import com.huawei.dc.common.components.dialog.fileselection.FileSelectionBrowseDlg;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationGroupInfo;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.NewRecoverGroupDialog;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.RecoverDBConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.RecoverDBRowData;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.RecoverElementInfo;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.renderer.RecoverDBFileColumnRenderer;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.renderer.RecoverDBSelecCheckBoxRenderer;
import com.huawei.dc.deviceoperation.RecoverInfoManager;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import com.huawei.dc.taskmgmt.view.common.CheckBoxOperation;
import com.huawei.dc.taskmgmt.view.common.ComboBoxOperation;
import com.huawei.dc.taskmgmt.view.common.GroupTablePanel;
import com.swimap.iview.templates.filtertreetable.TreeTableModel;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.math.BigInteger;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class RecoverGroupTablePanel
extends GroupTablePanel
implements IBrowseDlgInterafce {
    private static final long serialVersionUID = -573134710662137274L;
    private THashSet<Resource> m_oResourceList = null;
    private RecoverDBConfigPara m_oRecoverDBConfigPara = null;
    private ProgressDlg m_oProgressDlg = null;
    private byte[] m_oSyncObject = new byte[0];
    private HashMap<Integer, List<String>> m_oDevIDFileListMap = new HashMap(0);
    private FileSelectionBrowseDlg m_oRecoverFileBrowseDlg = null;
    private Vector dataList = new Vector();
    private boolean m_bUpButtonPressed = false;
    private boolean m_bDownButtonPressed = false;

    public RecoverGroupTablePanel(RecoverDBConfigPara oRecoverDBConfigPara, THashSet<Resource> oResList, boolean bIsView) {
        this.m_oResourceList = oResList;
        this.m_oRecoverDBConfigPara = oRecoverDBConfigPara;
        this.setViewStatus(bIsView);
        if (!this.getViewStatus()) {
            try {
                this.initializeRecoverManager(this.m_oResourceList);
            }
            catch (DCException e) {
                DCDebugTracer.trace(e);
            }
        }
        List<RecoverElementInfo> oElementInfoList = this.m_oRecoverDBConfigPara.getRecoverElementInfoLst();
        List<ActivationGroupInfo> oGroupInfoList = this.m_oRecoverDBConfigPara.getActivateGroupInfoLst();
        if (oElementInfoList != null && oGroupInfoList != null && oGroupInfoList.size() > 0 && oElementInfoList.size() > 0) {
            this.populateDeviceInTable(oElementInfoList, oGroupInfoList);
        } else {
            this.populateDeviceInTable(oElementInfoList);
        }
        this.initializeCellRenderers();
        this.m_oTaskTreeTable.setShowVerticalLines(true);
        super.expandAll(super.getTaskTree(), new TreePath(super.getRootNode()), true);
        super.updateTableView();
    }

    private void initializeCellRenderers() {
        this.m_oTaskTreeTable.setShowHorizontalLines(true);
        RecoverDBFileColumnRenderer oFileColumnRenderer = new RecoverDBFileColumnRenderer(this.m_oTaskTreeTable, this.getViewStatus());
        ComboBoxOperation oFilePathComboBox = new ComboBoxOperation();
        oFilePathComboBox.setIsShow(false);
        oFilePathComboBox.setComboBox(new ComboBoxWithToolTip());
        oFilePathComboBox.setSelectedItem(null);
        this.m_oTaskTreeTable.getColumnModel().getColumn(4).setCellRenderer(oFileColumnRenderer);
        this.m_oTaskTreeTable.getColumnModel().getColumn(4).setCellEditor(new FileColumnEditor(oFilePathComboBox));
        this.m_oTaskTreeTable.getColumnModel().getColumn(5).setCellRenderer(new RecoverDBSelecCheckBoxRenderer(this.m_oTaskTreeTable));
    }

    private void browseDlg() {
        int arrSelectedRow = super.getTaskTreeTable().getSelectedRow();
        TreePath oTreePath = super.getTaskTreeTable().getTree().getPathForRow(arrSelectedRow);
        TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
        RecoverDBRowData nodeInfo = (RecoverDBRowData)oNode.getUserObject();
        int iDeviceId = nodeInfo.getDevId();
        int iDeviceDomain = DeviceInfoUtil.getDeviceDomain(iDeviceId);
        try {
            this.m_oRecoverFileBrowseDlg = new FileSelectionBrowseDlg(iDeviceDomain, false, false, "Recover", null);
            this.m_oRecoverFileBrowseDlg.setTitle(DCFrameWorkUtil.getLocalizedString("RECOVER_DLG_SELECT_FILE_TITLE"));
            this.m_oRecoverFileBrowseDlg.registBrowseDlgInterface(this);
            this.m_oRecoverFileBrowseDlg.setVisible(true);
        }
        catch (DCException e) {
            DCOptionPane.showErrorDialog((Component)this, e.getErrorCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeRecoverManager(THashSet<Resource> oResList) throws DCException {
        this.m_oProgressDlg = new ProgressDlg(43821);
        this.m_oProgressDlg.setName("DeviceOperation_RecoverDlg_m_dlg");
        RecoverInfoManager.getInstance().setComponentForResponse(this, this.m_oSyncObject);
        byte[] byArray = this.m_oSyncObject;
        synchronized (this.m_oSyncObject) {
            int iReqId = DCFrameWorkUtil.generateRequestId();
            this.m_oProgressDlg.setProgressDlgId(iReqId);
            int success = RecoverInfoManager.getInstance().openRecoverDialog(iReqId, DeviceInfoUtil.getDevInfoArrayFromList(oResList));
            if (0 != success) {
                throw new DCException(ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(success)));
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RecoverGroupTablePanel.this.m_oProgressDlg.setTitle(DCFrameWorkUtil.getLocalizedString("MULDEVICE_RECOVER_DLG_PROGRESSBAR_TITLE"));
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.m_oProgressDlg.setVisible(true);
            return;
        }
    }

    public void updateProgressValue(final int iProgressValue, String strDeviceName, String strOperationResult) {
        this.m_oProgressDlg.setProgress(strDeviceName, strOperationResult, iProgressValue);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (iProgressValue == 100) {
                    RecoverGroupTablePanel.this.m_oProgressDlg.setVisible(false);
                    RecoverGroupTablePanel.this.m_oProgressDlg.dispose();
                }
            }
        });
    }

    private void populateDeviceInTable(List<RecoverElementInfo> elementInfoList, List<ActivationGroupInfo> groupInfoList) {
        TreeTableNode rootNode = super.getRootNode();
        rootNode.removeAllChildren();
        int groupCount = groupInfoList.size();
        for (int i = 0; i < groupCount; ++i) {
            ActivationGroupInfo oActivateGroupInfo = groupInfoList.get(i);
            CheckBoxOperation oGroupNodeCheckBox = new CheckBoxOperation();
            oGroupNodeCheckBox.setIsShow(false);
            oGroupNodeCheckBox.setIsSelect(false);
            ComboBoxOperation oFilePathComboBox = new ComboBoxOperation();
            oFilePathComboBox.setIsShow(false);
            oFilePathComboBox.setComboBox(null);
            oFilePathComboBox.setSelectedItem(null);
            RecoverDBRowData oGroupNodeInfo = new RecoverDBRowData(oActivateGroupInfo.getGroupId(), null, 1, null, oFilePathComboBox, oGroupNodeCheckBox);
            TreeTableNode groupNode = new TreeTableNode(oGroupNodeInfo);
            rootNode.add(groupNode);
            int devCount = elementInfoList.size();
            for (int j = 0; j < devCount; ++j) {
                RecoverElementInfo oElementInfo = elementInfoList.get(j);
                if (oActivateGroupInfo.getGroupId() != oElementInfo.getGroupID()) continue;
                Resource oResource = oElementInfo.getResource();
                CheckBoxOperation oDeviceNodeCheckBox = new CheckBoxOperation();
                oDeviceNodeCheckBox.setIsShow(true);
                oDeviceNodeCheckBox.setIsSelect(oElementInfo.isDeliverToBoard());
                oFilePathComboBox = new ComboBoxOperation();
                oFilePathComboBox.setIsShow(true);
                oFilePathComboBox.setComboBox(this.getComboBoxForDevID(oResource.getDeviceID(), oElementInfo.getRecoverFilePath()));
                oFilePathComboBox.setSelectedItem(oElementInfo.getRecoverFilePath());
                RecoverDBRowData oDevNodeInfo = new RecoverDBRowData(oElementInfo.getGroupID(), oResource, 2, oResource.getDeviceType(), oFilePathComboBox, oDeviceNodeCheckBox);
                TreeTableNode devNode = new TreeTableNode(oDevNodeInfo);
                groupNode.add(devNode);
            }
        }
        if (this.getRootNode().getChildCount() == 1 && this.getRootNode().getChildAt(0).getChildCount() == 1) {
            this.setNewButtonEnable(false);
        } else {
            this.setNewButtonEnable(true);
        }
    }

    public void populateDeviceInTable(List<RecoverElementInfo> oElementInfoList) {
        Comparator comp = new Comparator(){

            public int compare(Object o1, Object o2) {
                Resource p1 = (Resource)o1;
                Resource p2 = (Resource)o2;
                String p1Str = p1.getDeviceName();
                String p2Str = p2.getDeviceName();
                int iReturnValue = Collator.getInstance().compare(p1Str, p2Str);
                return iReturnValue;
            }
        };
        ArrayList<Resource> oResLst = new ArrayList<Resource>();
        Iterator oResItor = this.m_oResourceList.iterator();
        Resource oRes = null;
        while (oResItor.hasNext()) {
            oRes = (Resource)oResItor.next();
            oResLst.add(oRes);
        }
        Collections.sort(oResLst, comp);
        TreeTableNode oRootNode = super.getRootNode();
        oRootNode.removeAllChildren();
        int count = oResLst.size();
        int iGroupID = 0;
        boolean bDeliverToBoard = false;
        for (int i = 0; i < count; ++i) {
            if (null != oElementInfoList) {
                bDeliverToBoard = oElementInfoList.get(i).isDeliverToBoard();
            }
            Resource oResource = (Resource)oResLst.get(i);
            CheckBoxOperation oGroupNodeCheckBox = new CheckBoxOperation();
            oGroupNodeCheckBox.setIsShow(false);
            oGroupNodeCheckBox.setIsSelect(false);
            ComboBoxOperation oFilePathComboBox = new ComboBoxOperation();
            oFilePathComboBox.setIsShow(false);
            oFilePathComboBox.setComboBox(null);
            oFilePathComboBox.setSelectedItem(null);
            iGroupID = i + 1;
            RecoverDBRowData oGroupNodeInfo = new RecoverDBRowData(iGroupID, null, 1, null, oFilePathComboBox, oGroupNodeCheckBox);
            TreeTableNode oGroupNode = new TreeTableNode(oGroupNodeInfo);
            oRootNode.add(oGroupNode);
            if (null == oElementInfoList) {
                CheckBoxOperation oDeviceNodeCheckBox = new CheckBoxOperation();
                oDeviceNodeCheckBox.setIsShow(true);
                oDeviceNodeCheckBox.setIsSelect(bDeliverToBoard);
                oFilePathComboBox = new ComboBoxOperation();
                oFilePathComboBox.setIsShow(true);
                oFilePathComboBox.setComboBox(this.getComboBoxForDevID(oResource.getDeviceID(), null));
                oFilePathComboBox.setSelectedItem(null);
                RecoverDBRowData oDevNodeInfo = new RecoverDBRowData(iGroupID, oResource, 2, oResource.getDeviceType(), oFilePathComboBox, oDeviceNodeCheckBox);
                TreeTableNode oDevNode = new TreeTableNode(oDevNodeInfo);
                oGroupNode.add(oDevNode);
                continue;
            }
            int iFileCount = oElementInfoList.size();
            for (int j = 0; j < iFileCount; ++j) {
                RecoverElementInfo oFileInfo = oElementInfoList.get(j);
                if (null == oFileInfo || oFileInfo.getGroupID() != iGroupID) continue;
                CheckBoxOperation oDeviceNodeCheckBox = new CheckBoxOperation();
                oDeviceNodeCheckBox.setIsShow(true);
                oDeviceNodeCheckBox.setIsSelect(bDeliverToBoard);
                oFilePathComboBox = new ComboBoxOperation();
                oFilePathComboBox.setIsShow(true);
                oFilePathComboBox.setComboBox(this.getComboBoxForDevID(oResource.getDeviceID(), oFileInfo.getRecoverFilePath()));
                oFilePathComboBox.setSelectedItem(oFileInfo.getRecoverFilePath());
                RecoverDBRowData oDevNodeInfo = new RecoverDBRowData(iGroupID, oResource, 2, oResource.getDeviceType(), oFilePathComboBox, oDeviceNodeCheckBox);
                TreeTableNode oDevNode = new TreeTableNode(oDevNodeInfo);
                oGroupNode.add(oDevNode);
            }
        }
        if (this.getRootNode().getChildCount() == 1 && this.getRootNode().getChildAt(0).getChildCount() == 1) {
            this.setNewButtonEnable(false);
        } else {
            this.setNewButtonEnable(true);
        }
    }

    private ComboBoxWithToolTip getComboBoxForDevID(int iDevID, String strSelectedFilePath) {
        final ComboBoxWithToolTip oComboBox = new ComboBoxWithToolTip();
        List<String> oFileList = this.m_oDevIDFileListMap.get(iDevID);
        boolean bSelectedFilePresent = false;
        String strBrowseItem = DCFrameWorkUtil.getLocalizedString("RECOVER_BROWSE_BTN");
        oComboBox.addItem(" ");
        oComboBox.addItem(strBrowseItem);
        if (null != oFileList && 0 != oFileList.size()) {
            if (null != strSelectedFilePath && oFileList.contains(strSelectedFilePath)) {
                bSelectedFilePresent = true;
            }
            for (int i = 0; i < oFileList.size(); ++i) {
                oComboBox.addItem(oFileList.get(i));
            }
        }
        if (null != strSelectedFilePath && !bSelectedFilePresent && 0 != strSelectedFilePath.trim().length()) {
            oComboBox.addItem(strSelectedFilePath);
        }
        int iComboboxcount = oComboBox.getItemCount();
        if (null != strSelectedFilePath && 0 != strSelectedFilePath.length()) {
            oComboBox.setSelectedItem(strSelectedFilePath);
        } else if (iComboboxcount <= 2) {
            oComboBox.setSelectedIndex(0);
        } else {
            oComboBox.setSelectedIndex(2);
        }
        oComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (null != oComboBox && null != oComboBox.getSelectedItem()) {
                    String strToolTip = String.valueOf(oComboBox.getSelectedItem());
                    oComboBox.setToolTipText(strToolTip);
                    if (strToolTip.equalsIgnoreCase(DCFrameWorkUtil.getLocalizedString("RECOVER_BROWSE_BTN"))) {
                        RecoverGroupTablePanel.this.browseDlg();
                    }
                }
            }
        });
        return oComboBox;
    }

    public List<RecoverElementInfo> getRecoverElementInfoLst() {
        ArrayList<RecoverElementInfo> oElememtInfoList = new ArrayList<RecoverElementInfo>(0);
        TreeTableNode oRootNode = super.getRootNode();
        int iGroupCount = oRootNode.getChildCount();
        for (int i = 0; i < iGroupCount; ++i) {
            TreeTableNode oGroupNode = (TreeTableNode)oRootNode.getChildAt(i);
            int iDevCount = oGroupNode.getChildCount();
            for (int j = 0; j < iDevCount; ++j) {
                RecoverElementInfo oElementInfo = new RecoverElementInfo();
                TreeTableNode oDevNode = (TreeTableNode)oGroupNode.getChildAt(j);
                RecoverDBRowData oDevNodeInfo = (RecoverDBRowData)oDevNode.getUserObject();
                oElementInfo.setGroupID(oDevNodeInfo.getGroupId());
                oElementInfo.setResource(oDevNodeInfo.getResource());
                oElementInfo.setDeliverToBoard(oDevNodeInfo.getDeliverToBoard().getIsSelect());
                oElementInfo.setRecoverFilePath((String)oDevNodeInfo.getFilePathComboBox().getComboBox().getSelectedItem());
                oElementInfo.setSequenceID(j + 1);
                oElememtInfoList.add(oElementInfo);
            }
        }
        return oElememtInfoList;
    }

    public List<ActivationGroupInfo> getGroupInfoLst() {
        ArrayList<ActivationGroupInfo> oGroupInfoList = new ArrayList<ActivationGroupInfo>(0);
        TreeTableNode oRootNode = super.getRootNode();
        int iGroupCount = oRootNode.getChildCount();
        for (int i = 0; i < iGroupCount; ++i) {
            ActivationGroupInfo oActivateGroupInfo = new ActivationGroupInfo();
            TreeTableNode oGroupNode = (TreeTableNode)oRootNode.getChildAt(i);
            RecoverDBRowData oGroupNodeInfo = (RecoverDBRowData)oGroupNode.getUserObject();
            oActivateGroupInfo.setGroupId(oGroupNodeInfo.getGroupId());
            oActivateGroupInfo.setGroupName(oGroupNodeInfo.getResourceName());
            oGroupInfoList.add(oActivateGroupInfo);
        }
        return oGroupInfoList;
    }

    @Override
    public String[] getMethodNames() {
        return RecoverDBRowData.getMethodNames();
    }

    @Override
    public String[] getColumnNames() {
        String[] strColumnNames = new String[]{ResourceManager.getInstance().getResString("RESOURCE_NAME"), ResourceManager.getInstance().getResString("RESOURCE_TYPE"), ResourceManager.getInstance().getResString("DEVICE_IP_FOR_PACKAGE_TASK"), ResourceManager.getInstance().getResString("DEVICE_VERSION_FOR_PACKAGE_TASK"), ResourceManager.getInstance().getResString("RECOVER_FILE_PATH"), ResourceManager.getInstance().getResString("MULDEVICE_RECOVER_DLG_DELVER_TO_BOARD_REBOOT")};
        return strColumnNames;
    }

    @Override
    public Class[] getColumnTypes() {
        Class[] arrColumnTypes = new Class[]{TreeTableModel.class, String.class, String.class, String.class, String.class, Boolean.TYPE};
        return arrColumnTypes;
    }

    @Override
    public boolean[] getSortableColumns() {
        boolean[] arrSortableColumns = new boolean[]{false, false, false, false, false, false};
        return arrSortableColumns;
    }

    @Override
    public boolean[] getEditableColumns() {
        boolean[] arrEditableColumns = new boolean[]{true, false, false, false, true, true};
        return arrEditableColumns;
    }

    @Override
    public void upLeafNode(TreeTableNode oNode, TreeTableNode parentNode) {
        this.m_bUpButtonPressed = true;
        this.m_bDownButtonPressed = false;
        RecoverDBRowData nodeInfo = (RecoverDBRowData)oNode.getUserObject();
        if (nodeInfo.getNodeType() == 2) {
            this.upLeafNodeToNextNode(oNode, parentNode);
        } else {
            DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("ONLY_BOARD_ACCESS_UP"), ResourceManager.getInstance().getResString("ERROR"), 0);
        }
    }

    public void upLeafNodeToNextNode(TreeTableNode oNode, TreeTableNode parentNode) {
        int location = this.locationByRoot(parentNode, super.getRootNode());
        TreeTableNode fatherLastNode = (TreeTableNode)super.getRootNode().getChildAt(location - 1);
        oNode.removeFromParent();
        fatherLastNode.add(oNode);
        RecoverDBRowData fatherLastNodeInfo = (RecoverDBRowData)fatherLastNode.getUserObject();
        RecoverDBRowData oNodeInfo = (RecoverDBRowData)oNode.getUserObject();
        oNodeInfo.setGroupId(fatherLastNodeInfo.getGroupId());
        if (parentNode.isLeaf()) {
            parentNode.removeFromParent();
            this.changesGroupName(location, super.getRootNode());
        }
    }

    @Override
    public void downLeafNode(TreeTableNode oNode, TreeTableNode parentNode) {
        this.m_bUpButtonPressed = false;
        this.m_bDownButtonPressed = true;
        RecoverDBRowData nodeInfo = (RecoverDBRowData)oNode.getUserObject();
        if (nodeInfo.getNodeType() == 2) {
            this.downLeafNodeToNextNode(oNode, parentNode);
        } else {
            DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("ONLY_BOARD_ACCESS_UP"), ResourceManager.getInstance().getResString("ERROR"), 0);
        }
    }

    public void downLeafNodeToNextNode(TreeTableNode oNode, TreeTableNode parentNode) {
        int location = this.locationByRoot(parentNode, super.getRootNode());
        TreeTableNode fatherLastNode = (TreeTableNode)super.getRootNode().getChildAt(location + 1);
        oNode.removeFromParent();
        fatherLastNode.add(oNode);
        RecoverDBRowData fatherLastNodeInfo = (RecoverDBRowData)fatherLastNode.getUserObject();
        RecoverDBRowData oNodeInfo = (RecoverDBRowData)oNode.getUserObject();
        oNodeInfo.setGroupId(fatherLastNodeInfo.getGroupId());
        if (parentNode.isLeaf()) {
            parentNode.removeFromParent();
            this.changesGroupName(location, super.getRootNode());
        }
    }

    @Override
    public void newButtonAction() {
        this.getDataInfoByNewGroup();
        new NewRecoverGroupDialog(this.dataList);
        this.populateNewGroupInTable();
        super.expandAll(super.getTaskTree(), new TreePath(super.getRootNode()), true);
        super.updateTableView();
    }

    private void populateNewGroupInTable() {
        TreeTableNode rootNode = super.getRootNode();
        rootNode.removeAllChildren();
        Vector groupList = (Vector)this.dataList.get(0);
        Vector devList = (Vector)this.dataList.get(1);
        for (int i = 0; i < groupList.size(); ++i) {
            TreeTableNode groupNode = (TreeTableNode)groupList.get(i);
            RecoverDBRowData groupNodeInfo = (RecoverDBRowData)groupNode.getUserObject();
            rootNode.add(groupNode);
            for (int j = 0; j < devList.size(); ++j) {
                TreeTableNode devNode = (TreeTableNode)devList.get(j);
                RecoverDBRowData devNodeInfo = (RecoverDBRowData)devNode.getUserObject();
                devNodeInfo.getFilePathComboBox().setComboBox(this.getComboBoxForDevID(devNodeInfo.getResource().getDeviceID(), null));
                if (devNodeInfo.getGroupId() != groupNodeInfo.getGroupId()) continue;
                groupNode.add(devNode);
            }
        }
        this.removeLeafNode();
    }

    private void removeLeafNode() {
        TreeTableNode rootNode = super.getRootNode();
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            TreeTableNode groupNode = (TreeTableNode)rootNode.getChildAt(i);
            if (!groupNode.isLeaf()) continue;
            groupNode.removeFromParent();
            this.changesGroupName(i, rootNode);
            --i;
        }
    }

    private void getDataInfoByNewGroup() {
        this.dataList.removeAllElements();
        TreeTableNode rootNode = super.getRootNode();
        Vector<TreeTableNode> groupList = new Vector<TreeTableNode>();
        Vector<TreeTableNode> devList = new Vector<TreeTableNode>();
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            TreeTableNode groupNode = (TreeTableNode)rootNode.getChildAt(i);
            RecoverDBRowData groupNodeInfo = (RecoverDBRowData)groupNode.getUserObject();
            RecoverDBRowData groupNodeInfoCopy = (RecoverDBRowData)CloneUtil.getClone(groupNodeInfo);
            TreeTableNode groupNodeCopy = new TreeTableNode(groupNodeInfoCopy);
            groupList.add(groupNodeCopy);
            for (int j = 0; j < groupNode.getChildCount(); ++j) {
                TreeTableNode devNode = (TreeTableNode)groupNode.getChildAt(j);
                RecoverDBRowData devpNodeInfo = (RecoverDBRowData)devNode.getUserObject();
                RecoverDBRowData devNodeInfoCopy = (RecoverDBRowData)CloneUtil.getClone(devpNodeInfo);
                TreeTableNode devNodeCopy = new TreeTableNode(devNodeInfoCopy);
                devList.add(devNodeCopy);
            }
        }
        this.dataList.add(groupList);
        this.dataList.add(devList);
    }

    @Override
    public void removeGroupNode(TreeTableNode oNode, TreeTableNode parentNode) {
        RecoverDBRowData nodeInfo = (RecoverDBRowData)oNode.getUserObject();
        if (nodeInfo.getNodeType() == 1) {
            this.removeGroupNodeToNextNode(oNode, parentNode);
        } else {
            DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("ONLY_GROUP_ACCESS_DELETE"), ResourceManager.getInstance().getResString("ERROR"), 0);
        }
    }

    private void removeGroupNodeToNextNode(TreeTableNode oNode, TreeTableNode parentNode) {
        int location = this.locationByRoot(oNode, parentNode);
        this.moveGroupNode(location + 1, parentNode, oNode);
        this.changesGroupName(location, parentNode);
    }

    private int locationByRoot(TreeTableNode oNode, TreeTableNode parentNode) {
        int location = 0;
        int childCount = 0;
        RecoverDBRowData nodeInfo = (RecoverDBRowData)oNode.getUserObject();
        childCount = parentNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            TreeTableNode brotherNode = (TreeTableNode)parentNode.getChildAt(i);
            RecoverDBRowData brotherNodeInfo = (RecoverDBRowData)brotherNode.getUserObject();
            if (brotherNodeInfo.getGroupId() != nodeInfo.getGroupId()) continue;
            location = i;
            break;
        }
        return location;
    }

    private void moveGroupNode(int location, TreeTableNode parentNode, TreeTableNode oNode) {
        int i;
        Vector<TreeTableNode> nodeList = new Vector<TreeTableNode>();
        TreeTableNode lastNode = (TreeTableNode)parentNode.getChildAt(location);
        for (i = 0; i < oNode.getChildCount(); ++i) {
            TreeTableNode childNode = (TreeTableNode)oNode.getChildAt(i);
            RecoverDBRowData childNodeInfo = (RecoverDBRowData)childNode.getUserObject();
            childNodeInfo.setGroupId(location);
            nodeList.add(childNode);
        }
        for (i = 0; i < nodeList.size(); ++i) {
            lastNode.add((TreeTableNode)nodeList.get(i));
        }
        oNode.removeFromParent();
    }

    private void changesGroupName(int location, TreeTableNode parentNode) {
        int count = parentNode.getChildCount();
        for (int i = location; i < count && location >= 0; ++i) {
            TreeTableNode childNode = (TreeTableNode)parentNode.getChildAt(i);
            RecoverDBRowData childNodeInfo = (RecoverDBRowData)childNode.getUserObject();
            childNodeInfo.setGroupId(i + 1);
            int devCount = childNode.getChildCount();
            for (int j = 0; j < devCount; ++j) {
                TreeTableNode devNode = (TreeTableNode)childNode.getChildAt(j);
                RecoverDBRowData devNodeInfo = (RecoverDBRowData)devNode.getUserObject();
                devNodeInfo.setGroupId(i + 1);
            }
            childNodeInfo.setResourceName(ResourceManager.getInstance().getResString("GROUP") + (i + 1));
        }
    }

    @Override
    public void rowToRowTow(int row, int mousePressedRow) {
        TreePath oTreeReleasedPath;
        TreeTableNode oNodeReleased;
        RecoverDBRowData nodeReleasedInfo;
        int groupIdReleased;
        if (row == mousePressedRow || mousePressedRow == -1) {
            return;
        }
        TreePath oTreePressedPath = this.getTaskTreeTable().getTree().getPathForRow(mousePressedRow);
        TreeTableNode oNodePress = (TreeTableNode)oTreePressedPath.getLastPathComponent();
        RecoverDBRowData nodePressedInfo = (RecoverDBRowData)oNodePress.getUserObject();
        int groupIdPressed = nodePressedInfo.getGroupId();
        if (groupIdPressed == (groupIdReleased = (nodeReleasedInfo = (RecoverDBRowData)(oNodeReleased = (TreeTableNode)(oTreeReleasedPath = this.getTaskTreeTable().getTree().getPathForRow(row)).getLastPathComponent()).getUserObject()).getGroupId())) {
            return;
        }
        TreeTableNode rootNode = super.getRootNode();
        TreeTableNode groupNodeReleased = (TreeTableNode)rootNode.getChildAt(groupIdReleased - 1);
        oNodePress.removeFromParent();
        groupNodeReleased.add(oNodePress);
        nodePressedInfo.setGroupId(groupIdReleased);
        TreeTableNode groupNodePressed = (TreeTableNode)rootNode.getChildAt(groupIdPressed - 1);
        if (groupNodePressed.isLeaf()) {
            groupNodePressed.removeFromParent();
            this.changesGroupName(groupIdPressed - 1, rootNode);
        }
        super.updateTableView();
    }

    @Override
    public void exchangeGroups(int iRow, int iMousePressedRow) {
        String strSrcGrpName = "";
        TreePath oTreePressedPath = this.getTaskTreeTable().getTree().getPathForRow(iMousePressedRow);
        TreeTableNode oNodePress = (TreeTableNode)oTreePressedPath.getLastPathComponent();
        RecoverDBRowData oNodePressedInfo = (RecoverDBRowData)oNodePress.getUserObject();
        strSrcGrpName = oNodePressedInfo.getGroupName();
        int iGroupIdPressed = oNodePressedInfo.getGroupId();
        TreePath oTreeReleasedPath = this.getTaskTreeTable().getTree().getPathForRow(iRow);
        TreeTableNode oNodeReleased = (TreeTableNode)oTreeReleasedPath.getLastPathComponent();
        RecoverDBRowData oNodeReleasedInfo = (RecoverDBRowData)oNodeReleased.getUserObject();
        int iGroupIdReleased = oNodeReleasedInfo.getGroupId();
        if (oNodePressedInfo.getNodeType() != oNodeReleasedInfo.getNodeType()) {
            return;
        }
        if (1 != oNodeReleasedInfo.getNodeType()) {
            return;
        }
        if (iGroupIdPressed == iGroupIdReleased) {
            return;
        }
        oNodePressedInfo.setResourceName(oNodeReleasedInfo.getGroupName());
        oNodePressedInfo.setGroupId(iGroupIdReleased);
        int iSrcGrpChildCnt = oNodePress.getChildCount();
        TreeTableNode oSrcChildNode = null;
        RecoverDBRowData oSrcChildData = null;
        for (int i = 0; i < iSrcGrpChildCnt; ++i) {
            oSrcChildNode = (TreeTableNode)oNodePress.getChildAt(i);
            oSrcChildData = (RecoverDBRowData)oSrcChildNode.getUserObject();
            oSrcChildData.setGroupId(iGroupIdReleased);
        }
        oNodeReleasedInfo.setResourceName(strSrcGrpName);
        oNodeReleasedInfo.setGroupId(iGroupIdPressed);
        int iDstGrpChildCnt = oNodeReleased.getChildCount();
        TreeTableNode oDstChildNode = null;
        RecoverDBRowData oDstChildData = null;
        for (int i = 0; i < iDstGrpChildCnt; ++i) {
            oDstChildNode = (TreeTableNode)oNodeReleased.getChildAt(i);
            oDstChildData = (RecoverDBRowData)oDstChildNode.getUserObject();
            oDstChildData.setGroupId(iGroupIdPressed);
        }
        super.updateTableView();
    }

    @Override
    public void setButtonStatus() {
        try {
            TreePath oTreePath;
            TreeTableNode oNode;
            RecoverDBRowData nodeInfo;
            if (super.getRootNode().getChildCount() == 1 && super.getRootNode().getChildAt(0).getChildCount() == 1) {
                return;
            }
            if (super.getRootNode().getChildCount() == 1) {
                this.setUpButtonEnable(false);
                this.setDownButtonEnable(false);
                this.setDeleteButtonEnable(false);
                this.setNewButtonEnable(true);
                return;
            }
            int[] arrSelectedRows = super.getTaskTreeTable().getSelectedRows();
            int selectCount = arrSelectedRows.length;
            if (selectCount < 1) {
                this.setUpButtonEnable(false);
                this.setDownButtonEnable(false);
                this.setNewButtonEnable(true);
                this.setDeleteButtonEnable(false);
                return;
            }
            int arrSelectedRow = super.getTaskTreeTable().getSelectedRow();
            int groupCount = super.getRootNode().getChildCount();
            if (this.m_bDownButtonPressed) {
                ++arrSelectedRow;
            }
            if (this.m_bUpButtonPressed) {
                --arrSelectedRow;
            }
            if ((nodeInfo = (RecoverDBRowData)(oNode = (TreeTableNode)(oTreePath = super.getTaskTreeTable().getTree().getPathForRow(arrSelectedRow)).getLastPathComponent()).getUserObject()).getNodeType() == 1) {
                if (nodeInfo.getGroupId() >= groupCount) {
                    this.setDeleteButtonEnable(false);
                } else {
                    this.setDeleteButtonEnable(true);
                }
                this.setUpButtonEnable(false);
                this.setDownButtonEnable(false);
                this.setNewButtonEnable(true);
            } else {
                if (nodeInfo.getGroupId() == 1) {
                    this.setUpButtonEnable(false);
                } else {
                    this.setUpButtonEnable(true);
                }
                if (nodeInfo.getGroupId() == groupCount) {
                    this.setDownButtonEnable(false);
                } else {
                    this.setDownButtonEnable(true);
                }
                this.setDeleteButtonEnable(false);
                this.setNewButtonEnable(true);
            }
        }
        catch (Exception e) {
            this.setUpButtonEnable(false);
            this.setDownButtonEnable(false);
            this.setDeleteButtonEnable(false);
            this.setNewButtonEnable(true);
        }
    }

    @Override
    public void setCellRenderer(JLabel label, Object value) {
        TreeTableNode node = (TreeTableNode)value;
        RecoverDBRowData nodeInfo = (RecoverDBRowData)node.getUserObject();
        if (nodeInfo != null) {
            ImageIcon m_oSelectIcon = nodeInfo.getNodeType() == 1 ? ResourceManager.getInstance().getImage("folderopen.gif") : ResourceManager.getInstance().getNeTypeImage(nodeInfo.getDevId());
            label.setIcon(m_oSelectIcon);
        }
        label.setText(value.toString());
    }

    public void deleteDevByTable(Vector deleteDevList) {
        TreeTableNode rootNode = super.getRootNode();
        int groupCount = rootNode.getChildCount();
        int count = deleteDevList.size();
        for (int l = 0; l < count; ++l) {
            int devId = deleteDevList.get(l).hashCode();
            for (int i = 0; i < groupCount; ++i) {
                TreeTableNode groupNode = (TreeTableNode)rootNode.getChildAt(i);
                int devCount = groupNode.getChildCount();
                for (int j = 0; j < devCount; ++j) {
                    TreeTableNode devNode = (TreeTableNode)groupNode.getChildAt(j);
                    RecoverDBRowData devNodeInfo = (RecoverDBRowData)devNode.getUserObject();
                    if (devId != devNodeInfo.getDevId()) continue;
                    devNode.removeFromParent();
                    j = devCount;
                    i = groupCount;
                }
            }
        }
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            TreeTableNode groupNode = (TreeTableNode)rootNode.getChildAt(i);
            if (!groupNode.isLeaf()) continue;
            groupNode.removeFromParent();
            this.changesGroupName(i, rootNode);
            --i;
        }
        super.expandAll(super.getTaskTree(), new TreePath(super.getRootNode()), true);
        super.updateTableView();
    }

    public void addDevToTable(THashSet<Resource> oResourcesLst, Vector addDevList) {
        try {
            this.initializeRecoverManager(oResourcesLst);
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
        }
        TreeTableNode rootNode = super.getRootNode();
        int groupCount = rootNode.getChildCount();
        int count = addDevList.size();
        for (int i = 0; i < count; ++i) {
            int devId = addDevList.get(i).hashCode();
            CheckBoxOperation oGroupNodeCheckBox = new CheckBoxOperation();
            oGroupNodeCheckBox.setIsShow(false);
            oGroupNodeCheckBox.setIsSelect(false);
            ComboBoxOperation oFilePathComboBox = new ComboBoxOperation();
            oFilePathComboBox.setIsShow(false);
            oFilePathComboBox.setComboBox(null);
            oFilePathComboBox.setSelectedItem(null);
            RecoverDBRowData oGroupNodeInfo = new RecoverDBRowData(groupCount + i + 1, null, 1, null, oFilePathComboBox, oGroupNodeCheckBox);
            TreeTableNode newGroupNode = new TreeTableNode(oGroupNodeInfo);
            rootNode.add(newGroupNode);
            TreeTableNode newDevNode = this.createDevNode(devId, oResourcesLst, groupCount + 1 + i);
            newGroupNode.add(newDevNode);
        }
        super.expandAll(super.getTaskTree(), new TreePath(super.getRootNode()), true);
        super.updateTableView();
    }

    public TreeTableNode createDevNode(int devId, THashSet<Resource> oResources, int groupId) {
        TreeTableNode devNode = null;
        Iterator oResItor = oResources.iterator();
        Resource oResource = null;
        int i = 0;
        while (oResItor.hasNext()) {
            oResource = (Resource)oResItor.next();
            if (oResource.getDeviceID() == devId) {
                CheckBoxOperation oDeviceNodeCheckBox = new CheckBoxOperation();
                oDeviceNodeCheckBox.setIsShow(true);
                oDeviceNodeCheckBox.setIsSelect(false);
                ComboBoxOperation oFilePathComboBox = new ComboBoxOperation();
                oFilePathComboBox.setIsShow(true);
                oFilePathComboBox.setComboBox(this.getComboBoxForDevID(oResource.getDeviceID(), null));
                oFilePathComboBox.setSelectedItem(null);
                RecoverDBRowData oDevNodeInfo = new RecoverDBRowData(i + 1, oResource, 2, oResource.getDeviceType(), oFilePathComboBox, oDeviceNodeCheckBox);
                devNode = new TreeTableNode(oDevNodeInfo);
            }
            ++i;
        }
        return devNode;
    }

    @Override
    public void taskTable_MousePressed(MouseEvent oMouseEvent) {
        this.mousePressedRow = this.getTaskTree().getRowForLocation(40, oMouseEvent.getY());
        TreePath oTreePath = this.getTaskTreeTable().getTree().getPathForRow(this.mousePressedRow);
        TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
        RecoverDBRowData oNodeInfo = (RecoverDBRowData)oNode.getUserObject();
        if (oNodeInfo.getNodeType() == 1) {
            this.m_bIsGroupNodePressed = true;
        }
    }

    @Override
    public void taskTable_MouseReleased(MouseEvent oMouseEvent) {
        int iClickedColumn;
        this.m_bUpButtonPressed = false;
        this.m_bDownButtonPressed = false;
        if (super.getRootNode().getChildCount() > 0) {
            super.getExpandButton().setEnabled(true);
            super.getCollapseButton().setEnabled(true);
        }
        if (super.getViewStatus()) {
            return;
        }
        int arrSelectedRow = this.m_oTaskTreeTable.getSelectedRow();
        TreePath oTreePath = this.m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRow);
        TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
        RecoverDBRowData nodeInfo = (RecoverDBRowData)oNode.getUserObject();
        if (nodeInfo.getNodeType() == 2 && (iClickedColumn = this.m_oTaskTreeTable.columnAtPoint(oMouseEvent.getPoint())) == 5) {
            CheckBoxOperation operation = nodeInfo.getDeliverToBoard();
            if (!operation.getIsSelect()) {
                operation.setIsSelect(true);
            } else {
                operation.setIsSelect(false);
            }
            this.m_oTaskTreeTable.updateUI();
        }
        super.taskTable_MouseReleased(oMouseEvent);
    }

    @Override
    public void deleteButtonAction() {
        this.m_bUpButtonPressed = false;
        this.m_bDownButtonPressed = false;
        super.deleteButtonAction();
    }

    public void addFilesToFilePathMap(AsnDCFileLst oFileList, int iDevId) {
        int iNoOfFiles = oFileList.size();
        String strFileName = null;
        ArrayList<String> oFileListForDevId = new ArrayList<String>(0);
        for (int i = 0; i < iNoOfFiles; ++i) {
            strFileName = new String(((AsnDCFile)oFileList.get((int)i)).strTimeOrFileName);
            oFileListForDevId.add(strFileName);
        }
        this.m_oDevIDFileListMap.put(iDevId, oFileListForDevId);
    }

    public ValidationResult validateRecoverFileSelection() {
        ValidationResult oValidationResult = new ValidationResult();
        oValidationResult.setErrorCode(0);
        TreeTableNode oRootNode = super.getRootNode();
        int iGroupCount = oRootNode.getChildCount();
        for (int i = 0; i < iGroupCount; ++i) {
            TreeTableNode oGroupNode = (TreeTableNode)oRootNode.getChildAt(i);
            int iDevCount = oGroupNode.getChildCount();
            for (int j = 0; j < iDevCount; ++j) {
                TreeTableNode oDevNode = (TreeTableNode)oGroupNode.getChildAt(j);
                RecoverDBRowData oDevNodeInfo = (RecoverDBRowData)oDevNode.getUserObject();
                String strFilePath = (String)oDevNodeInfo.getFilePathComboBox().getComboBox().getSelectedItem();
                if (null != strFilePath && 0 != strFilePath.trim().length() && !strFilePath.trim().equals(ResourceManager.getInstance().getResString("RECOVER_BROWSE_BTN"))) continue;
                oValidationResult.setErrorCode(-1);
                oValidationResult.setErrorMessage(DCFrameWorkUtil.getLocalizedString("RECOVER_SOME_FILE_SELECTRED_ERROR"));
                return oValidationResult;
            }
        }
        return oValidationResult;
    }

    @Override
    public void setFileOrDirectory(String strFilePath, String strVersion, boolean file) {
        boolean bFilefound = false;
        int iSelectedRow = super.getTaskTreeTable().getSelectedRow();
        TreePath oTreePath = super.getTaskTreeTable().getTree().getPathForRow(iSelectedRow);
        TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
        RecoverDBRowData nodeInfo = (RecoverDBRowData)oNode.getUserObject();
        ComboBoxWithToolTip oComboBox = nodeInfo.getFilePathComboBox().getComboBox();
        int iFileComboBoxItemCount = oComboBox.getItemCount();
        for (int index = 0; index < iFileComboBoxItemCount; ++index) {
            String strSelectedItem = oComboBox.getItemAt(index).toString();
            if (!strSelectedItem.trim().equals(strFilePath.trim())) continue;
            oComboBox.setSelectedItem(strSelectedItem);
            bFilefound = true;
            break;
        }
        if (!bFilefound) {
            oComboBox.addItem(strFilePath);
            oComboBox.setSelectedItem(strFilePath);
        }
    }

    @Override
    public void taskTable_KeyPressed(KeyEvent e) {
        this.m_bUpButtonPressed = false;
        this.m_bDownButtonPressed = false;
        super.taskTable_KeyPressed(e);
    }

    private class FileColumnEditor
    extends DefaultCellEditor
    implements Serializable {
        private static final long serialVersionUID = 1L;
        ComboBoxWithToolTip m_oFilePathComboBox;

        FileColumnEditor(ComboBoxOperation fileComBox) {
            super(fileComBox.getComboBox());
            this.m_oFilePathComboBox = null;
            if (fileComBox.getIsShow()) {
                this.m_oFilePathComboBox = fileComBox.getComboBox();
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ComboBoxOperation oComboBox;
            ComboBoxWithToolTip oComp = null;
            JLabel oLabel = new JLabel();
            oLabel.setOpaque(true);
            if (value instanceof ComboBoxOperation && (oComboBox = (ComboBoxOperation)value).getIsShow() && !RecoverGroupTablePanel.this.getViewStatus()) {
                oComp = oComboBox.getComboBox();
            }
            return oComp;
        }
    }
}

