/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.recoverdb;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.devicemanagement.deviceoperation.IParaList;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.OperationAdapter;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationGroupInfo;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.RecoverAndActivateDBDialog;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.RecoverAndActivateDBPanel;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.RecoverDBConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.RecoverDBSubOpr;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.RecoverElementInfo;
import com.huawei.dc.standalone.controller.IDCStandAloneSyncCtrller;
import com.huawei.dc.standalone.controller.StandAloneSyncCtrller;
import com.huawei.dc.standalone.model.T2000DevInfo;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.ITaskSubOperation;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import gnu.trove.THashSet;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class RecoverDBOperation
extends OperationAdapter
implements ITaskDeviceOperation,
Serializable {
    private static final long serialVersionUID = -4899663288809047249L;
    private List m_oDependentOpLst;
    private int m_iDependsOnId;
    private boolean m_bPauseBeforeOp = false;
    private boolean m_bIsSelected;
    private String m_strOperationDesc;
    private String m_strOperationId;
    private int m_iOperationId;
    private int m_iOperationLevel;
    private String m_strOperationName;
    private IParaList m_oParaList;
    private ITask m_oParentTask;
    private RecoverDBConfigPara m_oRecoverDBConfigParam = new RecoverDBConfigPara();
    private RecoverDBSubOpr m_oRecoverDBSubOpr = null;
    private transient Component m_oRecoverDBView = null;
    private boolean m_bIsCancelPressed = false;
    private boolean m_bIsEnabled = true;
    private int iInnerTaskTypeId = -1;

    @Override
    public Object getConfiguredPara() {
        return this.m_oRecoverDBConfigParam;
    }

    public void setConfiguredPara(RecoverDBConfigPara oRecoverDBConfigPara) {
        this.m_oRecoverDBConfigParam = oRecoverDBConfigPara;
    }

    public List getDependentOperation() {
        return this.m_oDependentOpLst;
    }

    @Override
    public int getDependsOnOperation() {
        return this.m_iDependsOnId;
    }

    @Override
    public ITaskSubOperation getSubOperationData() {
        if (null == this.m_oRecoverDBSubOpr) {
            this.m_oRecoverDBSubOpr = new RecoverDBSubOpr();
        }
        return this.m_oRecoverDBSubOpr;
    }

    @Override
    public Component getView(int context) {
        this.setCancelPressed(false);
        if (null == this.m_oParentTask) {
            return null;
        }
        if (this.m_oRecoverDBConfigParam == null) {
            this.m_oRecoverDBConfigParam = new RecoverDBConfigPara();
        }
        switch (context) {
            case 0: {
                this.m_oRecoverDBView = new RecoverAndActivateDBDialog(this);
                if (!this.m_bIsCancelPressed) break;
                return null;
            }
            case 1: {
                this.m_oRecoverDBView = new RecoverAndActivateDBPanel(this, this.m_bIsSelected);
                ((RecoverAndActivateDBPanel)this.m_oRecoverDBView).setBoundsforView(context);
                break;
            }
            case 2: {
                this.m_oRecoverDBView = new RecoverAndActivateDBPanel(this, this.m_bIsSelected, true);
                ((RecoverAndActivateDBPanel)this.m_oRecoverDBView).setDisableAllComp();
                ((RecoverAndActivateDBPanel)this.m_oRecoverDBView).setBoundsforView(context);
                break;
            }
        }
        return this.m_oRecoverDBView;
    }

    public void updateResourceList(THashSet<Resource> oResource) {
        if (this.m_oRecoverDBView instanceof RecoverAndActivateDBPanel) {
            ((RecoverAndActivateDBPanel)this.m_oRecoverDBView).updateGroupingConfiguration(oResource);
        }
    }

    @Override
    public boolean isConfigReq() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return this.m_bIsEnabled;
    }

    @Override
    public boolean isPauseBeforeCurOp() {
        return this.m_bPauseBeforeOp;
    }

    @Override
    public boolean isSelected() {
        return this.m_bIsSelected;
    }

    public void setDependentOperation(List oDevDependentLst) {
        this.m_oDependentOpLst = oDevDependentLst;
    }

    @Override
    public void setDependsOnOperation(int oDevOpDependsOnId) {
        this.m_iDependsOnId = oDevOpDependsOnId;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.m_bIsEnabled = isEnabled;
    }

    @Override
    public void setIsPauseBeforeCurOp(boolean isPauseBeforeCurOp) {
        this.m_bPauseBeforeOp = isPauseBeforeCurOp;
    }

    @Override
    public void setOperationData(ITask oTask) {
        this.m_oParentTask = oTask;
    }

    @Override
    public void setSelected(boolean isSelected) {
        this.m_bIsSelected = isSelected;
    }

    public void setSubOperationData() {
        this.m_oRecoverDBSubOpr = new RecoverDBSubOpr();
    }

    @Override
    public ValidationResult validateOperationConfigurations() {
        ValidationResult oValidationResult = new ValidationResult();
        oValidationResult.setErrorCode(0);
        if (this.m_oRecoverDBView instanceof RecoverAndActivateDBPanel) {
            RecoverAndActivateDBPanel oPanel = (RecoverAndActivateDBPanel)this.m_oRecoverDBView;
            oValidationResult = oPanel.validateGroupConfig();
            if (0 != oValidationResult.getErrorCode()) {
                return oValidationResult;
            }
            oPanel.updateRecoverConfig();
        } else if (null == this.m_oRecoverDBView) {
            oValidationResult.setErrorCode(-1);
            oValidationResult.setErrorMessage(ResourceManager.getInstance().getResString("NO_RECOVER_GROUP_ACTIVATION_CONFIG"));
        } else {
            oValidationResult = ((RecoverAndActivateDBDialog)((Object)this.m_oRecoverDBView)).validateConfig();
        }
        return oValidationResult;
    }

    @Override
    public String getOperationDesc() {
        return this.m_strOperationDesc;
    }

    @Override
    public ArrayList getOperationIDnName() {
        ArrayList<Object> oData = null;
        if (this.isSelected()) {
            oData = new ArrayList<Object>();
            oData.add(this.getOperationName());
            oData.add(this.getOperationId());
        }
        return oData;
    }

    @Override
    public int getOperationId() {
        return this.m_iOperationId;
    }

    @Override
    public String getOperationIdString() {
        return this.m_strOperationId;
    }

    @Override
    public int getOperationLevel() {
        return this.m_iOperationLevel;
    }

    @Override
    public String getOperationName() {
        return this.m_strOperationName;
    }

    @Override
    public IParaList getoPerationParaList() {
        return this.m_oParaList;
    }

    @Override
    public void setOPerationParaList(IParaList oParaList) {
        this.m_oParaList = oParaList;
    }

    @Override
    public void setOperationDesc(String strOperationDesc) {
        this.m_strOperationDesc = strOperationDesc;
    }

    @Override
    public void setOperationId(int iOperationId) {
        this.m_iOperationId = iOperationId;
    }

    @Override
    public void setOperationIdString(String strOperationId) {
        this.m_strOperationId = strOperationId;
    }

    @Override
    public void setOperationLevel(int iOperationLevel) {
        this.m_iOperationLevel = iOperationLevel;
    }

    @Override
    public void setOperationName(String strOperationName) {
        this.m_strOperationName = strOperationName;
    }

    public ITask getOperationData() {
        return this.m_oParentTask;
    }

    @Override
    public String toString() {
        StringBuffer strRetVal = new StringBuffer(0);
        if (null != this.m_oRecoverDBConfigParam.getActivateGroupInfoLst()) {
            this.appendRecoverConfig(strRetVal);
        } else {
            this.appendPTNRecoverConfig(strRetVal);
        }
        return strRetVal.toString();
    }

    private void appendRecoverConfig(StringBuffer strRetVal) {
        String[] colHead = new String[]{ResourceManager.getInstance().getResString("GROUP_NAME_COLUMN"), ResourceManager.getInstance().getResString("DEVICE_NAME_T2000"), ResourceManager.getInstance().getResString("DEVICE_IP"), ResourceManager.getInstance().getResString("RECOVER_FILE_PATH"), ResourceManager.getInstance().getResString("MULDEVICE_RECOVER_DLG_DELVER_TO_BOARD_REBOOT")};
        String tableHead = "<table cellpadding=\"0\" cellspacing=\"0\" border=\"1\"";
        String columeHead = this.createColumnHead(colHead);
        String rowsData = this.createRecoverRowsData();
        if (null == rowsData || 0 == rowsData.length()) {
            return;
        }
        String tableLast = "</table>";
        strRetVal.append(tableHead);
        strRetVal.append(columeHead);
        strRetVal.append(rowsData);
        strRetVal.append(tableLast);
    }

    private void appendPTNRecoverConfig(StringBuffer strRetVal) {
        String[] colHead = new String[]{ResourceManager.getInstance().getResString("DEVICE_NAME_T2000"), ResourceManager.getInstance().getResString("DEVICE_IP"), ResourceManager.getInstance().getResString("RECOVER_FILE_PATH"), ResourceManager.getInstance().getResString("MULDEVICE_RECOVER_DLG_DELVER_TO_BOARD_REBOOT")};
        String tableHead = "<table cellpadding=\"0\" cellspacing=\"0\" border=\"1\"";
        String columeHead = this.createColumnHead(colHead);
        String rowsData = this.createPTNRecoverRowsData();
        if (null == rowsData || 0 == rowsData.length()) {
            return;
        }
        String tableLast = "</table>";
        strRetVal.append(tableHead);
        strRetVal.append(columeHead);
        strRetVal.append(rowsData);
        strRetVal.append(tableLast);
    }

    private String createColumnHead(String[] colHead) {
        StringBuffer columeHead = new StringBuffer(0);
        columeHead.append("<dl><dd></dl><tr high = 0>");
        for (int i = 0; i < colHead.length; ++i) {
            columeHead.append("<td>" + colHead[i] + "</td>");
        }
        columeHead.append("</tr>");
        return columeHead.toString();
    }

    private String createRecoverRowsData() {
        StringBuffer oRowData = new StringBuffer(0);
        List<ActivationGroupInfo> oGroupList = this.m_oRecoverDBConfigParam.getActivateGroupInfoLst();
        List<RecoverElementInfo> oDevList = this.m_oRecoverDBConfigParam.getRecoverElementInfoLst();
        int iGroupCount = oGroupList.size();
        Vector<String> oGroupData = null;
        for (int i = 0; i < iGroupCount; ++i) {
            ActivationGroupInfo oActivateGroupInfo = oGroupList.get(i);
            oGroupData = new Vector<String>(5);
            oGroupData.add(0, oActivateGroupInfo.getGroupName());
            oGroupData.add(1, null);
            oGroupData.add(2, null);
            oGroupData.add(3, null);
            oGroupData.add(4, null);
            this.createRowData(oGroupData, oRowData);
            int iDevCount = oDevList.size();
            for (int j = 0; j < iDevCount; ++j) {
                RecoverElementInfo oElementInfo = oDevList.get(j);
                if (oActivateGroupInfo.getGroupId() != oElementInfo.getGroupID()) continue;
                Resource oResource = oElementInfo.getResource();
                Vector<String> oDevData = new Vector<String>(5);
                oDevData.add(0, null);
                oDevData.add(1, oResource.getDeviceName());
                oDevData.add(2, oResource.getDeviceIP());
                oDevData.add(3, oElementInfo.getRecoverFilePath());
                if (oElementInfo.isDeliverToBoard()) {
                    oDevData.add(4, DCFrameWorkUtil.getLocalizedString("TRUE"));
                } else {
                    oDevData.add(4, DCFrameWorkUtil.getLocalizedString("FALSE"));
                }
                this.createRowData(oDevData, oRowData);
            }
        }
        return oRowData.toString();
    }

    private String createPTNRecoverRowsData() {
        StringBuffer oRowData = new StringBuffer(0);
        List<RecoverElementInfo> oDevList = this.m_oRecoverDBConfigParam.getRecoverElementInfoLst();
        int iDevCount = oDevList.size();
        for (int j = 0; j < iDevCount; ++j) {
            RecoverElementInfo oElementInfo = oDevList.get(j);
            Resource oResource = oElementInfo.getResource();
            Vector<String> oDevData = new Vector<String>(4);
            oDevData.add(0, oResource.getDeviceName());
            oDevData.add(1, oResource.getDeviceIP());
            oDevData.add(2, oElementInfo.getRecoverFilePath());
            if (oElementInfo.isDeliverToBoard()) {
                oDevData.add(3, DCFrameWorkUtil.getLocalizedString("TRUE"));
            } else {
                oDevData.add(3, DCFrameWorkUtil.getLocalizedString("FALSE"));
            }
            this.createRowData(oDevData, oRowData);
        }
        return oRowData.toString();
    }

    private void createRowData(Vector<String> rowData, StringBuffer rowsData) {
        rowsData.append("<dl><dd></dl><tr high = 0>");
        for (int m = 0; m < rowData.size(); ++m) {
            String data = rowData.get(m);
            if (data == null) {
                rowsData.append("<td></td>");
                continue;
            }
            rowsData.append("<td>" + data + "</td>");
        }
        rowsData.append("</tr>");
    }

    public String getShowDevIdInfo(int devId) {
        T2000DevInfo oT2000DevInfo = null;
        IDCStandAloneSyncCtrller oStandAloneSyncCtrller = StandAloneSyncCtrller.getInstance();
        try {
            oT2000DevInfo = oStandAloneSyncCtrller.getT2000DeviceInfo(devId);
        }
        catch (DCException ignore) {
            return DeviceInfoUtil.parseNEIDInt(devId);
        }
        if (2 == oT2000DevInfo.getProtocolType()) {
            return DeviceInfoUtil.parseNEIDInt(oT2000DevInfo.getMMLProtocolPhyDevIdDeviceId());
        }
        return oT2000DevInfo.getTL1ProtocolDevPhyId();
    }

    @Override
    public void setToNullSubOperationData() {
        this.m_oRecoverDBSubOpr = null;
    }

    public boolean isCancelPressed() {
        return this.m_bIsCancelPressed;
    }

    public void setCancelPressed(boolean isCancelPressed) {
        this.m_bIsCancelPressed = isCancelPressed;
    }

    @Override
    public String getCurrentContext() {
        return "";
    }

    @Override
    public int getInnerTaskTypeId() {
        return this.iInnerTaskTypeId;
    }

    @Override
    public void setInnerTaskTypeId(int taskTypeId) {
        this.iInnerTaskTypeId = taskTypeId;
    }
}

