/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.recoverdb;

import com.huawei.dc.common.asndatacenter.AsnDCActivationGroupInfo;
import com.huawei.dc.common.asndatacenter.AsnDCActivationGroupLst;
import com.huawei.dc.common.asndatacenter.AsnDCDefaultActiveGroupRsp;
import com.huawei.dc.common.asndatacenter.AsnDCDefaultGroupActivateForDiffusionReq;
import com.huawei.dc.common.asndatacenter.AsnTaskTypeEnum;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.devicemanagement.deviceoperation.AutoProgressDlgForOptix;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationElementInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationGroupInfo;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.RecoverDBConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.RecoverDBOperation;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.RecoverElementInfo;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.RecoverGroupTablePanel;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.RecoverTablePanel;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.controller.ProgressBar;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommController;
import com.huawei.dc.taskmgmt.model.ActiveDevInfo;
import com.huawei.dc.taskmgmt.model.ActiveGroupInfo;
import com.huawei.dc.taskmgmt.model.ActiveInfo;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.SwitchTaskAndAsn;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class RecoverAndActivateDBPanel
extends JPanel {
    private static final long serialVersionUID = 6100039070654040148L;
    private JPanel m_oMainPanel = null;
    private JLabel m_oMessageLabel = null;
    private JLabel m_oMessageLabel2 = null;
    private RecoverGroupTablePanel m_oGroupTablePanel = null;
    private RecoverTablePanel m_oTablePanel = null;
    private RecoverDBOperation m_oRecoverDBOperation = null;
    private Vector<Integer> m_oDevToBeAdded;
    private Vector<Integer> m_oDevToBeDeleted;
    private Vector<Integer> m_oDeviceList = new Vector();
    private ActivationConfigPara m_oActivationConfigPara = null;
    private ActiveInfo m_oActiveInfo = null;
    private AutoProgressDlgForOptix m_oProgressDlg = null;
    private ProgressBar m_oProgressbar;
    private AsnDCDefaultActiveGroupRsp m_oRecoverGroupRsp;
    private AsnDCDefaultActiveGroupRsp m_oRecoverGroupRspTemp;
    private boolean m_bIsRecoverSelected = true;
    private boolean m_bIsPTNExist = false;
    private boolean m_bIsView = false;

    public RecoverAndActivateDBPanel() {
        this.setSize(890, 574);
        this.jbInit();
    }

    public RecoverAndActivateDBPanel(RecoverDBOperation oRecoverDBOperation) {
        this.m_oRecoverDBOperation = oRecoverDBOperation;
        this.setSize(880, 474);
        this.jbInit();
        this.updateDeviceList();
    }

    public RecoverAndActivateDBPanel(RecoverDBOperation oRecoverDBOperation, boolean isSelected) {
        this.m_bIsRecoverSelected = isSelected;
        this.m_oRecoverDBOperation = oRecoverDBOperation;
        this.setSize(890, 374);
        this.jbInit();
        this.updateDeviceList();
    }

    public RecoverAndActivateDBPanel(RecoverDBOperation oRecoverDBOperation, boolean isSelected, boolean bIsView) {
        this.m_bIsRecoverSelected = isSelected;
        this.m_oRecoverDBOperation = oRecoverDBOperation;
        this.m_bIsView = bIsView;
        this.setSize(890, 574);
        this.jbInit();
        this.updateDeviceList();
    }

    private void updateDeviceList() {
        THashSet<Resource> oResList = this.m_oRecoverDBOperation.getOperationData().getDeviceType().getResources();
        Iterator oResItor = oResList.iterator();
        Resource resource = null;
        while (oResItor.hasNext()) {
            resource = (Resource)oResItor.next();
            this.m_oDeviceList.add(resource.getDeviceID());
        }
    }

    public void jbInit() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (null != this.m_oRecoverDBOperation) {
            this.m_bIsPTNExist = true;
        }
        this.createCenterPan();
        this.add((Component)this.m_oMainPanel, "Center");
        if (!this.m_bIsPTNExist) {
            this.m_oMessageLabel.setVisible(true);
            this.createGroupTablePan();
            if (null != this.m_oGroupTablePanel) {
                this.m_oMainPanel.add((Component)this.m_oGroupTablePanel, "Center");
            }
        } else {
            this.m_oMessageLabel.setVisible(false);
            this.createTablePanel();
            this.m_oMainPanel.add((Component)this.m_oTablePanel, "Center");
        }
        DCHelpManager.getInstance().enableF1HelpKey(this, "HELP_TOPIC_MANUAL_RECOVER");
    }

    private void createTablePanel() {
        RecoverDBConfigPara oRecoverDBConfigPara = (RecoverDBConfigPara)this.m_oRecoverDBOperation.getConfiguredPara();
        this.m_oTablePanel = new RecoverTablePanel(oRecoverDBConfigPara, this.m_oRecoverDBOperation.getOperationData().getDeviceType().getResources(), this.m_bIsView);
        this.m_oTablePanel.setName("DeviceOperation_RecoverAndActivateDBPanel_RecoverTablePanel");
    }

    private void createCenterPan() {
        this.m_oMainPanel = new JPanel();
        this.m_oMainPanel.setName("TaskMgmt_GroupingActivePanel_centerPan");
        this.m_oMainPanel.setLayout(new BorderLayout(5, 10));
        Border oEmptyBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        TitledBorder oBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), ResourceManager.getInstance().getResString("SET_RECOVER_CONFIGURATION"));
        this.m_oMainPanel.setBorder(BorderFactory.createCompoundBorder(oBorder, oEmptyBorder));
        this.m_oMessageLabel = new JLabel();
        this.m_oMessageLabel2 = new JLabel();
        String strMessage = ResourceManager.getInstance().getResString("SET_ACTIVE_ORDER_1_NODE_ROW");
        String strMessage2 = ResourceManager.getInstance().getResString("MULDEVICE_RECOVER_DLG_DELVER_TO_BOARD_REBOOT") + " : " + ResourceManager.getInstance().getResString("CONF_SEND_TO_BOARD_LABEL");
        String strHTMLMessage = "<html><body>" + strMessage + "</body></html>";
        String strHTMLMessage2 = "<html><body><b><Font color = #C4302D>" + strMessage2 + "</body></html>";
        this.m_oMessageLabel.setText(strHTMLMessage);
        this.m_oMessageLabel2.setText(strHTMLMessage2);
        this.m_oMainPanel.add((Component)this.m_oMessageLabel, "North");
        this.m_oMainPanel.add((Component)this.m_oMessageLabel2, "South");
    }

    public void createGroupTablePan() {
        RecoverDBConfigPara oRecoverDBConfigPara = (RecoverDBConfigPara)this.m_oRecoverDBOperation.getConfiguredPara();
        if (null == oRecoverDBConfigPara.getActivateGroupInfoLst() && null == oRecoverDBConfigPara.getRecoverElementInfoLst()) {
            if (this.isActivateOperationSelectedAndConfigured()) {
                this.getDefaultGroupInfoFromActivation();
            } else if (this.m_bIsRecoverSelected) {
                this.getDefaultGroupInfoFromServer();
            }
        }
        if (this.m_oRecoverDBOperation.isCancelPressed()) {
            return;
        }
        this.m_oGroupTablePanel = new RecoverGroupTablePanel(oRecoverDBConfigPara, this.m_oRecoverDBOperation.getOperationData().getDeviceType().getResources(), this.m_bIsView);
        this.m_oGroupTablePanel.setName("DeviceOperation_RecoverAndActivateDBPanel_RecoverGroupTablePanel");
    }

    private void getDefaultGroupInfoFromServer() {
        THashSet<Resource> oResList = this.m_oRecoverDBOperation.getOperationData().getDeviceType().getResources();
        this.m_oRecoverGroupRsp = this.getRecoverGroupInfoRsp(oResList);
        if (this.m_oRecoverGroupRsp == null) {
            this.m_oRecoverDBOperation.setCancelPressed(true);
            return;
        }
        AsnDCActivationGroupLst activeGroupList = this.m_oRecoverGroupRsp.oActiveGroupLst;
        AsnDCActivationGroupInfo oAsnDCActivationGroupInfo = new AsnDCActivationGroupInfo();
        oAsnDCActivationGroupInfo.oActiveGroupLst = activeGroupList;
        ITask oTask = (ITask)CloneUtil.getClone(this.m_oRecoverDBOperation.getOperationData());
        SwitchTaskAndAsn.getSwitchTaskAndAsn().switchAsnToTaskByActive(oAsnDCActivationGroupInfo, oTask);
        this.m_oActiveInfo = oTask.getActivationInfo();
        this.getGroupConfigForBoardLevel();
    }

    private AsnDCDefaultActiveGroupRsp getRecoverGroupInfoRsp(THashSet<Resource> oResList) {
        AsnDCDefaultGroupActivateForDiffusionReq oAsnDCDeviceIdLstReq = new AsnDCDefaultGroupActivateForDiffusionReq();
        Iterator oResItor = oResList.iterator();
        Resource oDevInfo = null;
        while (oResItor.hasNext()) {
            oDevInfo = (Resource)oResItor.next();
            oAsnDCDeviceIdLstReq.arrDeviceIds.add((Object)BigInteger.valueOf(oDevInfo.getDeviceID()));
        }
        oAsnDCDeviceIdLstReq.enTaskType = new AsnTaskTypeEnum(this.m_oRecoverDBOperation.getOperationData().getTaskTypeId());
        oAsnDCDeviceIdLstReq.strPkgDiffutionFilePath = "".getBytes();
        oAsnDCDeviceIdLstReq.oReqID = BigInteger.valueOf(DCFrameWorkUtil.generateRequestId());
        this.m_oRecoverGroupRspTemp = new AsnDCDefaultActiveGroupRsp();
        this.startProcessBar();
        TaskAsynCommController.getInstance().getRecoverGroupInfo(oAsnDCDeviceIdLstReq, this);
        return this.m_oRecoverGroupRspTemp;
    }

    private void startProcessBar() {
        this.m_oProgressDlg = new AutoProgressDlgForOptix(this, ResourceManager.getInstance().getResString("GET_DEFAULT_ACTIVATION_GROUP_PROGRESS_DLG_TITLE"));
        DeviceType oSelectedDeviceType = this.m_oRecoverDBOperation.getOperationData().getSelectedDeviceType();
        THashSet<Resource> oResourceList = oSelectedDeviceType.getResources();
        int devCount = oResourceList.size();
        this.m_oProgressbar = new ProgressBar(this.m_oProgressDlg, devCount);
        this.m_oProgressbar.setName("DeviceOperation_ActivationPackagePanel_m_oProgressbar");
        this.m_oProgressbar.setThreadStop(false);
        this.m_oProgressbar.start();
    }

    private void getDefaultGroupInfoFromActivation() {
        int iTaskTypeId = this.m_oRecoverDBOperation.getOperationData().getTaskTypeId();
        if (12 == iTaskTypeId && 2 == this.m_oRecoverDBOperation.getOperationData().getUpgradeLevel()) {
            this.getGroupConfigForBoardLevel();
        } else {
            this.getGroupConfigForDeviceLevel();
        }
    }

    private void getGroupConfigForBoardLevel() {
        RecoverDBConfigPara oRecoverDBConfigPara = (RecoverDBConfigPara)this.m_oRecoverDBOperation.getConfiguredPara();
        RecoverElementInfo oRecoverElementInfo = null;
        ArrayList<RecoverElementInfo> oRecoverElementInfoList = new ArrayList<RecoverElementInfo>(0);
        ActivationGroupInfo oActivationGroupInfo = null;
        ArrayList<ActivationGroupInfo> oActivationGroupInfoList = new ArrayList<ActivationGroupInfo>(0);
        Vector<ActiveGroupInfo> oActiveGroupInfoList = this.m_oActiveInfo.getGroupList();
        ActiveGroupInfo oActiveGroupInfo = null;
        Vector oActiveDevInfoList = null;
        ActiveDevInfo oActiveDevInfo = null;
        int iGroupId = 1;
        ArrayList oDevList = new ArrayList(0);
        ArrayList<Integer> oTempDevList = null;
        for (int i = 0; i < oActiveGroupInfoList.size(); ++i) {
            oActiveGroupInfo = oActiveGroupInfoList.get(i);
            oActiveDevInfoList = oActiveGroupInfo.getActivationInfoLst();
            if (null == oActiveDevInfoList || 0 == oActiveDevInfoList.size()) continue;
            oTempDevList = new ArrayList<Integer>(0);
            for (int j = 0; j < oActiveDevInfoList.size(); ++j) {
                oActiveDevInfo = (ActiveDevInfo)oActiveDevInfoList.get(j);
                int iDeviceID = oActiveDevInfo.getDevId();
                if (oDevList.contains(iDeviceID) || null == oTempDevList) continue;
                oTempDevList.add(iDeviceID);
            }
            if (null == oTempDevList || 0 == oTempDevList.size()) continue;
            oActivationGroupInfo = new ActivationGroupInfo();
            oActivationGroupInfo.setGroupId(iGroupId);
            String strGroupName = ResourceManager.getInstance().getResString("ACTIVATION_GROUP_NAME_KEY") + '_' + iGroupId;
            oActivationGroupInfo.setGroupName(strGroupName);
            oActivationGroupInfoList.add(oActivationGroupInfo);
            for (int j = 0; j < oTempDevList.size(); ++j) {
                oRecoverElementInfo = new RecoverElementInfo();
                oRecoverElementInfo.setDeliverToBoard(true);
                oRecoverElementInfo.setGroupID(iGroupId);
                oRecoverElementInfo.setRecoverFilePath("");
                oRecoverElementInfo.setSequenceID(j + 1);
                oRecoverElementInfo.setResource(DeviceInfoManagerImpl.getInstance().getResourceForID((Integer)oTempDevList.get(j)));
                oRecoverElementInfoList.add(oRecoverElementInfo);
            }
            oDevList.addAll(oTempDevList);
            ++iGroupId;
        }
        oRecoverDBConfigPara.setActivateGroupInfoLst(oActivationGroupInfoList);
        oRecoverDBConfigPara.setRecoverElementInfoLst(oRecoverElementInfoList);
    }

    private void getGroupConfigForDeviceLevel() {
        RecoverDBConfigPara oRecoverDBConfigPara = (RecoverDBConfigPara)this.m_oRecoverDBOperation.getConfiguredPara();
        RecoverElementInfo oRecoverElementInfo = null;
        ArrayList<RecoverElementInfo> oRecoverElementInfoList = new ArrayList<RecoverElementInfo>(0);
        List oElementInfoLst = this.m_oActivationConfigPara.getElementInfoLst();
        List<ActivationGroupInfo> oGrpInfoLst = this.m_oActivationConfigPara.getActivateGroupInfoLst();
        oRecoverDBConfigPara.setActivateGroupInfoLst(oGrpInfoLst);
        for (int j = 0; j < oElementInfoLst.size(); ++j) {
            oRecoverElementInfo = new RecoverElementInfo();
            oRecoverElementInfo.setResource(((ActivationElementInfo)oElementInfoLst.get(j)).getResource());
            oRecoverElementInfo.setSequenceID(((ActivationElementInfo)oElementInfoLst.get(j)).getSequenceId());
            oRecoverElementInfo.setGroupID(((ActivationElementInfo)oElementInfoLst.get(j)).getGroupId());
            oRecoverElementInfo.setRecoverFilePath("");
            oRecoverElementInfo.setDeliverToBoard(true);
            oRecoverElementInfoList.add(oRecoverElementInfo);
        }
        oRecoverDBConfigPara.setRecoverElementInfoLst(oRecoverElementInfoList);
    }

    private boolean isActivateOperationSelectedAndConfigured() {
        boolean bActivateSelected = false;
        List<ITaskDeviceOperation> oSupportedOperationLst = this.m_oRecoverDBOperation.getOperationData().getSupportedOperation();
        int iSizeOfLst = oSupportedOperationLst.size();
        for (int i = 0; i < iSizeOfLst; ++i) {
            ITaskDeviceOperation oTaskDevOp = oSupportedOperationLst.get(i);
            if (!oTaskDevOp.isSelected() || 8 != oTaskDevOp.getOperationId()) continue;
            int iTaskTypeId = this.m_oRecoverDBOperation.getOperationData().getTaskTypeId();
            if (12 == iTaskTypeId && 2 == this.m_oRecoverDBOperation.getOperationData().getUpgradeLevel()) {
                this.m_oActiveInfo = this.m_oRecoverDBOperation.getOperationData().getActivationInfo();
                if (null == this.m_oActiveInfo || 0 == this.m_oActiveInfo.getGroupList().size()) break;
                bActivateSelected = true;
                break;
            }
            this.m_oActivationConfigPara = (ActivationConfigPara)oTaskDevOp.getConfiguredPara();
            if (null == this.m_oActivationConfigPara || null == this.m_oActivationConfigPara.getElementInfoLst() || null == this.m_oActivationConfigPara.getActivateGroupInfoLst() || 0 == this.m_oActivationConfigPara.getElementInfoLst().size() || 0 == this.m_oActivationConfigPara.getActivateGroupInfoLst().size()) break;
            bActivateSelected = true;
            break;
        }
        return bActivateSelected;
    }

    public ValidationResult validateGroupConfig() {
        ValidationResult oValidationResult = new ValidationResult();
        oValidationResult.setErrorCode(0);
        if (!this.m_bIsPTNExist) {
            if (this.m_oGroupTablePanel.getRootNode().getChildCount() == 0) {
                oValidationResult.setErrorCode(-1);
                oValidationResult.setErrorMessage(ResourceManager.getInstance().getResString("NO_GROUPING"));
                return oValidationResult;
            }
            oValidationResult = this.m_oGroupTablePanel.validateRecoverFileSelection();
        } else {
            if (this.m_oTablePanel.getRootNode().getChildCount() == 0) {
                oValidationResult.setErrorCode(-1);
                oValidationResult.setErrorMessage(ResourceManager.getInstance().getResString("NO_DEVICES"));
            }
            oValidationResult = this.m_oTablePanel.validateRecoverFileSelection();
        }
        return oValidationResult;
    }

    public void updateRecoverConfig() {
        RecoverDBConfigPara oRecoverDBConfigPara = (RecoverDBConfigPara)this.m_oRecoverDBOperation.getConfiguredPara();
        if (!this.m_bIsPTNExist) {
            oRecoverDBConfigPara.setRecoverElementInfoLst(this.m_oGroupTablePanel.getRecoverElementInfoLst());
            oRecoverDBConfigPara.setActivateGroupInfoLst(this.m_oGroupTablePanel.getGroupInfoLst());
        } else {
            oRecoverDBConfigPara.setRecoverElementInfoLst(this.m_oTablePanel.getRecoverElementInfoLst());
            oRecoverDBConfigPara.setActivateGroupInfoLst(null);
        }
    }

    public void updateGroupingConfiguration(THashSet<Resource> oResources) {
        boolean isUpdataForDel = this.isDeleteDevice(oResources);
        boolean isUpdataForAdd = this.isAddDevice(oResources);
        if (isUpdataForDel) {
            this.deleteDevByTable();
        }
        if (isUpdataForAdd) {
            this.addDevToTable(oResources);
        }
    }

    private void deleteDevByTable() {
        this.m_oDeviceList.removeAll(this.m_oDevToBeDeleted);
        if (this.m_oDevToBeDeleted.size() > 0) {
            if (!this.m_bIsPTNExist) {
                this.m_oGroupTablePanel.deleteDevByTable(this.m_oDevToBeDeleted);
            } else {
                this.m_oTablePanel.deleteDevByTable(this.m_oDevToBeDeleted);
            }
        }
    }

    private void addDevToTable(THashSet<Resource> oResourcesLst) {
        this.m_oDeviceList.addAll(this.m_oDevToBeAdded);
        if (this.m_oDevToBeAdded.size() > 0) {
            if (!this.m_bIsPTNExist) {
                this.m_oGroupTablePanel.addDevToTable(oResourcesLst, this.m_oDevToBeAdded);
            } else {
                this.m_oTablePanel.addDevToTable(oResourcesLst, this.m_oDevToBeAdded);
            }
        }
    }

    private boolean isDeleteDevice(THashSet<Resource> oResourcesLst) {
        boolean isUpdate = false;
        this.m_oDevToBeDeleted = new Vector();
        int iDevCount = this.m_oDeviceList.size();
        for (int i = 0; i < iDevCount; ++i) {
            boolean isExistDev = false;
            int iDevId = this.m_oDeviceList.get(i).hashCode();
            Iterator oResItor = oResourcesLst.iterator();
            Resource oDevInfo = null;
            while (oResItor.hasNext()) {
                oDevInfo = (Resource)oResItor.next();
                if (iDevId != oDevInfo.getDeviceID()) continue;
                isExistDev = true;
                break;
            }
            if (isExistDev) continue;
            this.m_oDevToBeDeleted.add(iDevId);
            isUpdate = true;
        }
        return isUpdate;
    }

    private boolean isAddDevice(THashSet<Resource> oResourcesLst) {
        boolean isUpdate = false;
        this.m_oDevToBeAdded = new Vector();
        Iterator oResItor = oResourcesLst.iterator();
        Resource oNewDevInfo = null;
        while (oResItor.hasNext()) {
            oNewDevInfo = (Resource)oResItor.next();
            boolean isExistDev = false;
            int iNewDevId = oNewDevInfo.getDeviceID();
            int iDevCount = this.m_oDeviceList.size();
            for (int j = 0; j < iDevCount; ++j) {
                int iDevId = this.m_oDeviceList.get(j);
                if (iNewDevId != iDevId) continue;
                isExistDev = true;
            }
            if (isExistDev) continue;
            this.m_oDevToBeAdded.add(iNewDevId);
            isUpdate = true;
        }
        return isUpdate;
    }

    public void setDisableAllComp() {
        if (!this.m_bIsPTNExist) {
            this.m_oGroupTablePanel.setViewStatus(true);
        } else {
            this.m_oTablePanel.setViewStatus(true);
        }
    }

    public void setBoundsforView(int context) {
        if (2 == context) {
            this.setSize(880, 325);
        }
    }

    public AsnDCDefaultActiveGroupRsp getRecoverGroupRspTemp() {
        return this.m_oRecoverGroupRspTemp;
    }

    public void setRecoverGroupRspTemp(AsnDCDefaultActiveGroupRsp activeGroupRspTemp) {
        this.m_oRecoverGroupRspTemp = activeGroupRspTemp;
    }

    public AutoProgressDlgForOptix getProgressDlg() {
        return this.m_oProgressDlg;
    }

    public void setThreadStop(boolean bThreadStop) {
        if (null != this.m_oProgressbar) {
            this.m_oProgressbar.setThreadStop(bThreadStop);
        }
    }

    public boolean getThreadStop() {
        if (null != this.m_oProgressbar) {
            return this.m_oProgressbar.getThreadStop();
        }
        return false;
    }

    public boolean isRecoverSelected() {
        return this.m_bIsRecoverSelected;
    }

    public void setRecoverSelected(boolean isRecoverSelected) {
        this.m_bIsRecoverSelected = isRecoverSelected;
    }
}

