/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.recoverdb;

import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.RecoverDBRowData;
import com.huawei.dc.taskmgmt.view.common.CheckBoxOperation;
import com.huawei.dc.taskmgmt.view.common.ComboBoxOperation;
import com.huawei.dc.taskmgmt.view.common.NewGroupPanel;
import com.swimap.iview.templates.filtertreetable.TreeTableModel;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.tree.TreePath;

public class NewRecoverGroupDialog
extends NewGroupPanel {
    private static final long serialVersionUID = 1L;
    private Vector oDataList = new Vector();

    public NewRecoverGroupDialog(Vector dataList) {
        this.oDataList = dataList;
        Vector groupList = (Vector)dataList.get(0);
        JTextField text = super.getGroupNameText();
        text.setName("DeviceOperation_NewGroupDlg_text");
        text.setText(ResourceManager.getInstance().getResString("GROUP") + (groupList.size() + 1));
        this.populateDataInTable();
        this.setVisible(true);
    }

    private void populateDataInTable() {
        RecoverDBRowData devicesNodeInfo = new RecoverDBRowData(-1, null, 3, "", null, null);
        TreeTableNode devicesNode = new TreeTableNode(devicesNodeInfo);
        TreeTableNode rootNode = super.getRootNode();
        rootNode.add(devicesNode);
        Vector devList = (Vector)this.oDataList.get(1);
        for (int i = 0; i < devList.size(); ++i) {
            TreeTableNode devNode = (TreeTableNode)devList.get(i);
            devicesNode.add(devNode);
        }
        super.updateTableView();
    }

    @Override
    public String[] getStrColumnNamesByTree() {
        String[] strColumnNames = new String[]{ResourceManager.getInstance().getResString("RESOURCE_NAME"), ResourceManager.getInstance().getResString("CURRENT_GROUP")};
        return strColumnNames;
    }

    @Override
    public String[] getStrColumnNamesByTable() {
        String[] strColumnNames = new String[]{ResourceManager.getInstance().getResString("DEVICE_NAME"), ResourceManager.getInstance().getResString("DEVICE_IP_FOR_PACKAGE_TASK")};
        return strColumnNames;
    }

    @Override
    public Class[] getArrColumnTypes() {
        Class[] arrColumnTypes = new Class[]{TreeTableModel.class, String.class, String.class};
        return arrColumnTypes;
    }

    @Override
    public String[] getMethodBoardTreeNames() {
        return RecoverDBRowData.getMethodBoardTreeNames();
    }

    @Override
    public boolean[] getArrSortableColumns() {
        boolean[] arrSortableColumns = new boolean[]{false, false};
        return arrSortableColumns;
    }

    @Override
    public boolean[] getArrEditableColumns() {
        boolean[] arrEditableColumns = new boolean[]{true, false};
        return arrEditableColumns;
    }

    @Override
    public String getRightTitle() {
        return ResourceManager.getInstance().getResString("DEVICE_TREE_PACKAGE_UPDATE_TASK");
    }

    @Override
    public String getLeftTitle() {
        return ResourceManager.getInstance().getResString("SELECTED_DEVICES");
    }

    @Override
    public void setCellRenderer(JLabel label, Object value) {
        TreeTableNode node = (TreeTableNode)value;
        RecoverDBRowData nodeInfo = (RecoverDBRowData)node.getUserObject();
        if (nodeInfo != null) {
            ImageIcon m_oSelectIcon = !nodeInfo.getIsSelect() ? ResourceManager.getInstance().getImage("noneselect.gif") : ResourceManager.getInstance().getImage("part.gif");
            label.setIcon(m_oSelectIcon);
        }
        label.setText(value.toString());
    }

    @Override
    public void tree_MousePressed(MouseEvent oMouseEvent) {
        int x = oMouseEvent.getX();
        int arrSelectedRow = super.getTreeTable().getSelectedRow();
        if (arrSelectedRow < 0) {
            return;
        }
        int iClickedColumn = super.getTreeTable().columnAtPoint(oMouseEvent.getPoint());
        if (iClickedColumn == 0) {
            TreePath oTreePath = super.getTreeTable().getTree().getPathForRow(arrSelectedRow);
            TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            RecoverDBRowData nodeInfo = (RecoverDBRowData)oNode.getUserObject();
            if (nodeInfo.getNodeType() == 2 ? x < 40 || x > 53 : nodeInfo.getNodeType() == 3 && (x < 19 || x > 35)) {
                return;
            }
            if (!nodeInfo.getIsSelect()) {
                if (nodeInfo.getNodeType() == 2) {
                    this.addNodeToTable(nodeInfo);
                    nodeInfo.setIsSelect(true);
                    this.checkSelectNodeByDevices();
                } else {
                    this.addAllNodeToTable(oNode);
                    nodeInfo.setIsSelect(true);
                }
            } else if (nodeInfo.getNodeType() == 2) {
                this.removeNodeByTable(nodeInfo);
                nodeInfo.setIsSelect(false);
                this.checkSelectNodeByDevices();
            } else {
                this.removeAllNodeByTable(oNode);
                nodeInfo.setIsSelect(false);
            }
            super.getTreeTable().updateUI();
        }
    }

    private void checkSelectNodeByDevices() {
        boolean isSelectAllNode = true;
        TreeTableNode rootNode = super.getRootNode();
        TreeTableNode devicesNode = (TreeTableNode)rootNode.getChildAt(0);
        RecoverDBRowData devicesNodeInfo = (RecoverDBRowData)devicesNode.getUserObject();
        int count = devicesNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            TreeTableNode node = (TreeTableNode)devicesNode.getChildAt(i);
            RecoverDBRowData nodeInfo = (RecoverDBRowData)node.getUserObject();
            if (nodeInfo.getIsSelect()) continue;
            isSelectAllNode = false;
            break;
        }
        if (isSelectAllNode) {
            devicesNodeInfo.setIsSelect(true);
        } else {
            devicesNodeInfo.setIsSelect(false);
        }
    }

    private void addAllNodeToTable(TreeTableNode oNode) {
        int count = oNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            TreeTableNode node = (TreeTableNode)oNode.getChildAt(i);
            RecoverDBRowData nodeInfo = (RecoverDBRowData)node.getUserObject();
            if (nodeInfo.getIsSelect()) continue;
            nodeInfo.setIsSelect(true);
            this.addNodeToTable(nodeInfo);
        }
    }

    private void removeAllNodeByTable(TreeTableNode oNode) {
        int count = oNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            TreeTableNode node = (TreeTableNode)oNode.getChildAt(i);
            RecoverDBRowData nodeInfo = (RecoverDBRowData)node.getUserObject();
            if (!nodeInfo.getIsSelect()) continue;
            nodeInfo.setIsSelect(false);
            this.removeNodeByTable(nodeInfo);
        }
    }

    private void addNodeToTable(RecoverDBRowData nodeInfo) {
        Vector<String> data = new Vector<String>();
        String resourceName = nodeInfo.getResourceName();
        String devIp = nodeInfo.getDevIp();
        data.add(resourceName);
        data.add(devIp);
        super.getSelectTableModel().addRow(data);
    }

    private void removeNodeByTable(RecoverDBRowData nodeInfo) {
        int count = super.getSelectTableModel().getRowCount();
        for (int i = 0; i < count; ++i) {
            String devIp = (String)super.getSelectTableModel().getValueAt(i, 1);
            String devName = (String)super.getSelectTableModel().getValueAt(i, 0);
            if (!devIp.equals(nodeInfo.getDevIp()) || !devName.equals(nodeInfo.getResourceName())) continue;
            super.getSelectTableModel().removeRow(i);
            break;
        }
    }

    @Override
    public void okButtonActionPerfromed() {
        int rowCount = super.getSelectTableModel().getRowCount();
        if (rowCount < 1) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("NEW_GROUP_DOESNOT_DATA"), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        Vector groupList = (Vector)this.oDataList.get(0);
        CheckBoxOperation oGroupNodeCheckBox = new CheckBoxOperation();
        oGroupNodeCheckBox.setIsShow(false);
        oGroupNodeCheckBox.setIsSelect(false);
        ComboBoxOperation oFilePathComboBox = new ComboBoxOperation();
        oFilePathComboBox.setIsShow(false);
        oFilePathComboBox.setComboBox(null);
        oFilePathComboBox.setSelectedItem(null);
        RecoverDBRowData newGroupNodeInfo = new RecoverDBRowData(groupList.size() + 1, null, 1, null, oFilePathComboBox, oGroupNodeCheckBox);
        TreeTableNode newGroupNode = new TreeTableNode(newGroupNodeInfo);
        groupList.add(newGroupNode);
        TreeTableNode rootNode = super.getRootNode();
        TreeTableNode devicesNode = (TreeTableNode)rootNode.getChildAt(0);
        RecoverDBRowData devicesNodeInfo = (RecoverDBRowData)devicesNode.getUserObject();
        if (devicesNodeInfo.getIsSelect()) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("NEW_GROUP_WITH_ALL_DEVICE_SELECITON"), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        int count = devicesNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            TreeTableNode devNode = (TreeTableNode)devicesNode.getChildAt(i);
            RecoverDBRowData devNodeInfo = (RecoverDBRowData)devNode.getUserObject();
            if (!devNodeInfo.getIsSelect()) continue;
            devNodeInfo.setGroupId(newGroupNodeInfo.getGroupId());
            devNodeInfo.setIsSelect(false);
        }
        this.dispose();
    }

    @Override
    protected String getCurrentContext() {
        return null;
    }

    @Override
    public void setTreeNodeVisibleBySearchContent(String strKeyWord) {
    }
}

