/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.recover.model;

import com.huawei.dc.common.components.table.model.DCList;
import com.huawei.dc.common.components.table.model.DCTableModel;
import com.huawei.dc.common.components.table.model.ITableInfo;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.devicemanagement.deviceoperation.ParaValue;
import com.huawei.dc.devicemanagement.deviceoperation.recover.RecoverFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.recover.model.DCRecoverTableRowData;

public class DCRecoverTableModel
extends DCTableModel {
    private static final long serialVersionUID = 1051647696770530803L;
    public static final int DEV_NAME_COLUMN_INDEX = 0;
    public static final int DEV_IP_COLUMN_INDEX = 1;
    public static final int CONTENT_TYPE_COLUMN_INDEX = 2;
    public static final int BOARD_TYPE_COLUMN_INDEX = 3;
    public static final int FILE_NAME_COLUMN_INDEX = 4;
    public static final int REBOOT_TYPE_COLUMN_INDEX = 5;
    public static final int DELEVE_TO_BOARD_COLUMN_INDEX = 6;
    public static final int OPERATION_STATE_COLUMN_INDEX = 7;
    private boolean[][] m_isCellEditable;

    public DCRecoverTableModel(ITableInfo oTableInfo) {
        super(oTableInfo);
    }

    public void setCellEditable(boolean[][] isCellEditable) {
        this.m_isCellEditable = isCellEditable;
    }

    public void setCellEditable(int iRow, int iColumn, boolean bEditable) {
        this.m_isCellEditable[iRow][iColumn] = bEditable;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (6 == columnIndex) {
            DCList oRebootType = (DCList)this.getValueAt(rowIndex, 5);
            DCRecoverTableRowData oRowData = (DCRecoverTableRowData)this.getRowData(rowIndex);
            int iDevID = oRowData.getDevId();
            boolean bOptixDomianDev = DeviceInfoUtil.isDomainDevice(iDevID, 4);
            DCList<RecoverFileInfo> oFileLst = oRowData.getFileLst();
            if (bOptixDomianDev && null != oFileLst.getCurrSelectedObj()) {
                String sFileName = oFileLst.getCurrSelectedObj().getFileName();
                if (null != sFileName && sFileName.endsWith(".dat")) {
                    this.m_isCellEditable[rowIndex][columnIndex] = false;
                    return false;
                }
            } else if (null != oRebootType.getCurrSelectedObj() && 0 == ((ParaValue)oRebootType.getCurrSelectedObj()).getValue()) {
                this.m_isCellEditable[rowIndex][columnIndex] = false;
                return false;
            }
        } else if (5 == columnIndex) {
            DCRecoverTableRowData oRowData = (DCRecoverTableRowData)this.getRowData(rowIndex);
            int iDevID = oRowData.getDevId();
            boolean bOptixDomianDev = DeviceInfoUtil.isDomainDevice(iDevID, 4);
            DCList<RecoverFileInfo> oFileLst = oRowData.getFileLst();
            if (bOptixDomianDev && null != oFileLst.getCurrSelectedObj()) {
                String sFileName = oFileLst.getCurrSelectedObj().getFileName();
                if (null != sFileName && sFileName.endsWith(".dat")) {
                    this.m_isCellEditable[rowIndex][columnIndex] = false;
                    return false;
                }
                this.m_isCellEditable[rowIndex][columnIndex] = true;
            }
        }
        return this.m_isCellEditable[rowIndex][columnIndex];
    }
}

