/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.recover.controller;

import com.huawei.dc.common.asndatacenter.AsnActivationTypeEnum;
import com.huawei.dc.common.asndatacenter.AsnBoard;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceProgressNotify;
import com.huawei.dc.common.asndatacenter.AsnDCManualRecoverInfo;
import com.huawei.dc.common.asndatacenter.AsnDCManualRecoverReqeust;
import com.huawei.dc.common.asndatacenter.AsnDCOpertionRsp;
import com.huawei.dc.common.asndatacenter.AsnDCProgressNotify;
import com.huawei.dc.common.components.dialog.fileselection.IUpdateDestinationListener;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.ParaValue;
import com.huawei.dc.devicemanagement.deviceoperation.recover.DCRecoverDlg;
import com.huawei.dc.devicemanagement.deviceoperation.recover.RecoverFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.recover.model.DCRecoverTableModel;
import com.huawei.dc.devicemanagement.deviceoperation.recover.model.DCRecoverTableRowData;
import com.huawei.dc.devicemanagement.deviceoperation.recover.model.RecoverModel;
import com.huawei.dc.devicemanagement.deviceoperation.recover.model.RecoverOperationData;
import com.huawei.dc.deviceoperation.DevOpObjectStore;
import com.huawei.dc.deviceoperation.IDeviceOperationManager;
import com.huawei.dc.deviceoperation.IProgressCBDialog;
import com.huawei.dc.deviceoperation.util.OperationStatus;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.framework.StClientFileTransInfo;
import com.huawei.dc.framework.XFtpManager;
import com.huawei.dc.standalone.IManualOperation;
import com.huawei.dc.standalone.StandAloneDomainInfo;
import java.awt.Component;
import java.io.File;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;

public class RecoverOperationController
implements IProgressCBDialog {
    private DCRecoverTableModel m_oRecoverTableModel;
    private RecoverModel[] m_oarrRecoverModel;
    private IDeviceOperationManager m_oDeviceOperationMgr;
    private DCRecoverDlg m_oRecoverDlg;
    private DeviceInfo[] m_arrDevInfo;
    private IManualOperation m_oManualOperation;
    private static final String INFO_FILE = "DCInfo_BackupInfo.txt";
    private Vector m_oDevIDForBusyDev = new Vector(4);
    private Vector<Integer> m_oRebootDevVector = new Vector(4);
    private long firstOpenClientTime = -1L;
    private boolean isCam = false;
    private HashMap<Integer, Integer> m_oOprTypeMap;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.firstOpenClientTime ^ this.firstOpenClientTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RecoverOperationController other = (RecoverOperationController)obj;
        return this.firstOpenClientTime == other.firstOpenClientTime;
    }

    public RecoverOperationController(RecoverModel[] oRecoverModel, RecoverOperationData oRecoverOperationData, int iFileColumnIndex) {
        this.m_oarrRecoverModel = oRecoverModel;
        this.m_arrDevInfo = oRecoverOperationData.getDeviceInfo();
        this.m_oManualOperation = oRecoverOperationData.getManualOperation();
        this.m_oDeviceOperationMgr = DCFrameWorkUtil.getDeviceOperationManager();
        this.m_oDeviceOperationMgr.registerNotification(this);
    }

    public RecoverOperationController(DCRecoverDlg oRecoverDlg, IManualOperation oManualOperation, DCRecoverTableModel oRecoverTableModel) {
        this.m_oRecoverTableModel = oRecoverTableModel;
        this.m_oRecoverDlg = oRecoverDlg;
        this.m_arrDevInfo = this.m_oRecoverDlg.getDevInfos();
        this.m_oManualOperation = oManualOperation;
        this.m_oDeviceOperationMgr = DCFrameWorkUtil.getDeviceOperationManager();
        this.m_oDeviceOperationMgr.registerNotification(this);
        this.m_oOprTypeMap = new HashMap();
    }

    private void handleResponse(AsnDCOpertionRsp operationRsp) {
        if (null == this.m_oManualOperation) {
            this.updateRecoverDlgWithRes(operationRsp);
        } else {
            this.processRecoverResponse(operationRsp);
        }
    }

    public void sendRecoverRequest() {
        this.sendRequest();
    }

    public void sendCamRecoverRequest() {
        this.sendRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequest() {
        AsnDCManualRecoverReqeust[] oRecoverRequest = this.fillAsnRecoverOperationRequest();
        IDeviceOperationManager deviceoperationMgr = DCFrameWorkUtil.getDeviceOperationManager();
        AsnDCOpertionRsp operationRsp = null;
        int iOperationType = -1;
        boolean RECOVER_FORM_SERVER_INDEX = false;
        boolean RECOVER_FORM_CLIENT_INDEX = true;
        Object object = DCFrameWorkUtil.getSynchronizedObject();
        synchronized (object) {
            AsnDCManualRecoverInfo recoverInfo;
            int i;
            this.m_oOprTypeMap.clear();
            if (0 < oRecoverRequest[0].oAsnDCManualRecoverList.size()) {
                iOperationType = this.isCam ? 42 : 10;
                for (i = 0; i < oRecoverRequest[0].oAsnDCManualRecoverList.size(); ++i) {
                    recoverInfo = (AsnDCManualRecoverInfo)oRecoverRequest[0].oAsnDCManualRecoverList.get(i);
                    this.m_oOprTypeMap.put(recoverInfo.iDeviceId.intValue(), iOperationType);
                }
                operationRsp = deviceoperationMgr.recover(oRecoverRequest[0], 0);
            }
            if (0 < oRecoverRequest[1].oAsnDCManualRecoverList.size()) {
                iOperationType = this.isCam ? 42 : 11;
                for (i = 0; i < oRecoverRequest[1].oAsnDCManualRecoverList.size(); ++i) {
                    recoverInfo = (AsnDCManualRecoverInfo)oRecoverRequest[1].oAsnDCManualRecoverList.get(i);
                    this.m_oOprTypeMap.put(recoverInfo.iDeviceId.intValue(), iOperationType);
                }
                AsnDCOpertionRsp tmpOperationRsp = deviceoperationMgr.recover(oRecoverRequest[1], 1);
                this.setRecoverFromClientPath();
                this.clientfileTransfer(tmpOperationRsp, 0);
                if (null == operationRsp) {
                    operationRsp = tmpOperationRsp;
                } else {
                    int iErrorCode = tmpOperationRsp.oErrorInfo.iErrorNo.intValue();
                    if (0 != iErrorCode) {
                        operationRsp.oErrorInfo = tmpOperationRsp.oErrorInfo;
                    }
                    operationRsp.oReqID = tmpOperationRsp.oReqID;
                    if (null != tmpOperationRsp.oResultOpt) {
                        if (null == operationRsp.oResultOpt) {
                            operationRsp.oResultOpt = tmpOperationRsp.oResultOpt;
                        } else {
                            operationRsp.oResultOpt.addAll((Collection)tmpOperationRsp.oResultOpt);
                        }
                    }
                }
            }
            this.handleResponse(operationRsp);
        }
    }

    public void setIsCam() {
        this.isCam = true;
    }

    private void updateRecoverDlgWithRes(AsnDCOpertionRsp oAsnOperationRsp) {
        int iErrorCode = -1;
        if (null != oAsnOperationRsp) {
            iErrorCode = oAsnOperationRsp.oErrorInfo.iErrorNo.intValue();
            if (0 != iErrorCode) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorCode, ResourceManager.getInstance().getResString("ERROR"), 0);
                this.m_oRecoverDlg.doCleanUp();
            } else {
                this.setRecoverProgress(oAsnOperationRsp);
            }
        } else {
            this.m_oRecoverDlg.doCleanUp();
        }
    }

    private void setRecoverProgress(AsnDCOpertionRsp oAsnOperation) {
        int iTotalDevices = this.m_arrDevInfo.length;
        for (int i = 0; i < iTotalDevices; ++i) {
            if (this.m_oDevIDForBusyDev.contains(this.m_arrDevInfo[i].getDevId())) continue;
            OperationStatus oOperationStatus = new OperationStatus();
            oOperationStatus.setOperationType(this.m_oOprTypeMap.get(this.m_arrDevInfo[i].getDevId()));
            oOperationStatus.setIsProgress(true);
            oOperationStatus.setProgress(0);
            this.m_oRecoverTableModel.setValueAt(oOperationStatus, i, 7);
            this.m_oDevIDForBusyDev.add(this.m_arrDevInfo[i].getDevId());
        }
        this.m_oRecoverDlg.btnEnableDisable(false);
    }

    private void setRecoverFromClientPath() {
        int iSelectedDeviceCount = this.m_oRecoverTableModel.getRowCount();
        int iDevId = -1;
        String filePath = "";
        for (int index = 0; index < iSelectedDeviceCount; ++index) {
            DCRecoverTableRowData oRowData = (DCRecoverTableRowData)this.m_oRecoverTableModel.getRowData(index);
            iDevId = oRowData.getDevId();
            RecoverFileInfo oRecoverFileInfo = oRowData.getFileLst().getCurrSelectedObj();
            if (null == oRecoverFileInfo || !IUpdateDestinationListener.DESTINATION_NMS_CLIENT.equals(oRecoverFileInfo.getDestination())) continue;
            String strFilePath = oRecoverFileInfo.getFileName();
            File f = new File(strFilePath);
            strFilePath = strFilePath.replace('\\', '/');
            if (!f.exists()) continue;
            if (f.isFile()) {
                int iSeperatorIndex = strFilePath.lastIndexOf("/");
                filePath = strFilePath.substring(0, iSeperatorIndex + 1);
            } else {
                filePath = strFilePath + "/";
            }
            File recoverFileDir = new File(filePath);
            File[] recoverFileArray = recoverFileDir.listFiles();
            Vector<String> oBackupFiles = new Vector<String>();
            if (this.isCam) {
                oBackupFiles.add(strFilePath);
            } else {
                for (int i = 0; i < recoverFileArray.length; ++i) {
                    File file = recoverFileArray[i];
                    if (!file.isFile()) continue;
                    oBackupFiles.add(file.getPath());
                }
            }
            DevOpObjectStore.getInstance().putObjectInstance(iDevId, oBackupFiles);
        }
    }

    private void clientfileTransfer(AsnDCOpertionRsp operationRsp, int iOperType) {
        int iNosDevices = this.m_arrDevInfo.length;
        for (int i = 0; i < iNosDevices; ++i) {
            StClientFileTransInfo oClientInfoObj = new StClientFileTransInfo();
            oClientInfoObj.m_iOperationType = iOperType;
            XFtpManager.getInstance().incrementSftpOPerationCount(this.m_arrDevInfo[i].getDevId(), oClientInfoObj);
        }
    }

    private void processRecoverResponse(AsnDCOpertionRsp oRecoverResp) {
        if (null != oRecoverResp) {
            this.m_oRecoverDlg.dispose();
        }
        if (null != oRecoverResp) {
            int iErrorCode = oRecoverResp.oErrorInfo.iErrorNo.intValue();
            if (0 == iErrorCode) {
                this.updateProgresssOnDeviceTable();
            } else {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorCode, ResourceManager.getInstance().getResString("ERROR"), 0);
                this.doCleanup();
            }
        }
    }

    private void doCleanup() {
        this.m_oRecoverDlg.dispose();
    }

    private void updateProgresssOnDeviceTable() {
        for (int iRowIndex = 0; iRowIndex < this.m_arrDevInfo.length; ++iRowIndex) {
            this.m_oManualOperation.setOperationStartedStatusForDevice(this.m_arrDevInfo[iRowIndex], this.m_oOprTypeMap.get(this.m_arrDevInfo[iRowIndex].getDevId()));
        }
    }

    private AsnDCManualRecoverReqeust[] fillAsnRecoverOperationRequest() {
        AsnDCManualRecoverReqeust oAsnDCManualRecoverFromServerReqeust = new AsnDCManualRecoverReqeust();
        oAsnDCManualRecoverFromServerReqeust.oReqID = BigInteger.valueOf(DCFrameWorkUtil.generateRequestId());
        AsnDCManualRecoverReqeust oAsnDCManualRecoverFromClientReqeust = new AsnDCManualRecoverReqeust();
        oAsnDCManualRecoverFromClientReqeust.oReqID = BigInteger.valueOf(DCFrameWorkUtil.generateRequestId());
        AsnDCManualRecoverInfo oAsnDCManualRecoverInfo = null;
        this.m_oRebootDevVector.clear();
        int iRowCount = this.m_oRecoverTableModel.getRowCount();
        this.m_oOprTypeMap.clear();
        int iUserId = DCFrameWorkUtil.getUserId();
        for (int iRowIndex = 0; iRowIndex < iRowCount; ++iRowIndex) {
            oAsnDCManualRecoverInfo = new AsnDCManualRecoverInfo();
            DCRecoverTableRowData oRowData = (DCRecoverTableRowData)this.m_oRecoverTableModel.getRowData(iRowIndex);
            oAsnDCManualRecoverInfo.iUserId = BigInteger.valueOf(iUserId);
            oAsnDCManualRecoverInfo.iDeviceId = BigInteger.valueOf(oRowData.getDevId());
            if (null != oRowData.getBoardTypeLst()) {
                oAsnDCManualRecoverInfo.oBoard = this.getASNBoardValue(oRowData.getBoardTypeLst().getCurrSelectedObj());
            }
            this.setRebootType(oAsnDCManualRecoverInfo, oRowData);
            RecoverFileInfo oTmpRecoverFileInfo = oRowData.getFileLst().getCurrSelectedObj();
            oAsnDCManualRecoverInfo.strFileName = oTmpRecoverFileInfo.getFileName().getBytes();
            oAsnDCManualRecoverInfo.bDeliverToBoardReboot = null != oRowData.getIsDeliverToBoard() ? oRowData.getIsDeliverToBoard() : false;
            oAsnDCManualRecoverInfo.iContentType = this.isCam ? BigInteger.valueOf(10L) : (null != oRowData.getContentTypeLst() ? BigInteger.valueOf(oRowData.getContentTypeLst().getCurrSelectedObj().getValue()) : BigInteger.valueOf(-1L));
            oAsnDCManualRecoverInfo._bIsByAgent = DCFrameWorkUtil.getIsSingleClient() && StandAloneDomainInfo.getInstance().getSelectedDomain() == 2 ? (oAsnDCManualRecoverInfo.bIsByAgent = oRowData.isAgent()) : (oAsnDCManualRecoverInfo.bIsByAgent = false);
            if (1 == oAsnDCManualRecoverInfo.strFileName.length) continue;
            File filepath = new File(new String(oAsnDCManualRecoverInfo.strFileName));
            oAsnDCManualRecoverInfo.bIsSupportFolder = filepath.isDirectory();
            oAsnDCManualRecoverInfo.strServerName = oTmpRecoverFileInfo.getExternalFTPServerName().getBytes();
            if (this.isCam) {
                this.m_oOprTypeMap.put(oRowData.getDevId(), 42);
            } else if (null != oTmpRecoverFileInfo.getExternalFTPServerName() && !"".equals(oTmpRecoverFileInfo.getExternalFTPServerName())) {
                this.m_oOprTypeMap.put(oRowData.getDevId(), 47);
            } else {
                this.m_oOprTypeMap.put(oRowData.getDevId(), 10);
            }
            if (IUpdateDestinationListener.DESTINATION_NMS_CLIENT.equals(oTmpRecoverFileInfo.getDestination())) {
                oAsnDCManualRecoverFromClientReqeust.oAsnDCManualRecoverList.add((Object)oAsnDCManualRecoverInfo);
                continue;
            }
            oAsnDCManualRecoverFromServerReqeust.oAsnDCManualRecoverList.add((Object)oAsnDCManualRecoverInfo);
        }
        AsnDCManualRecoverReqeust[] oAsnDCManualRecoverReqeust = new AsnDCManualRecoverReqeust[]{oAsnDCManualRecoverFromServerReqeust, oAsnDCManualRecoverFromClientReqeust};
        return oAsnDCManualRecoverReqeust;
    }

    private void setRebootType(AsnDCManualRecoverInfo oAsnDCManualRecoverInfo, DCRecoverTableRowData oRowData) {
        if (null != oRowData.getRebootTypeLst()) {
            oAsnDCManualRecoverInfo.enReboot = new AsnActivationTypeEnum(oRowData.getRebootTypeLst().getCurrSelectedObj().getValue());
        } else {
            oAsnDCManualRecoverInfo.enReboot.value = 0;
        }
    }

    private AsnBoard getASNBoardValue(ParaValue oBoardSelected) {
        AsnBoard board = new AsnBoard();
        board.value = oBoardSelected.getValue();
        return board;
    }

    @Override
    public void updateDeviceProgress(int iDeviceId, int iProgressPercentage, AsnDCProgressNotify oAsnProgressNotification, int iFailureReason, String strErrorMsg) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDeviceProgress(int iDeviceId, int iProgressPercentage, AsnDCDeviceProgressNotify oAsnprogressNotification, int iFailureReason, String strErrorMsg) {
        DCDebugTracer.trace("DC::RecoverOperationController#updateDeviceProgress start");
        int operationType = oAsnprogressNotification.enDevOperType.value;
        Integer oDevid = iDeviceId;
        if (10 == operationType || 47 == operationType || 11 == operationType || 9 == operationType) {
            Object object = DCFrameWorkUtil.getSynchronizedObject();
            synchronized (object) {
                OperationStatus operationStatus = new OperationStatus();
                operationStatus.setOperationType(operationType);
                int len = this.m_arrDevInfo.length;
                for (int i = 0; i < len; ++i) {
                    if (iDeviceId != this.m_arrDevInfo[i].getDevId()) continue;
                    if (-1 != iProgressPercentage) {
                        if (100 <= iProgressPercentage) {
                            String strSuccess = ResourceManager.getInstance().getResString("OPERTION_SUCCESS");
                            operationStatus.setIsProgress(false);
                            operationStatus.setIsInitialize(false);
                            operationStatus.setIFailureReason(0);
                            operationStatus.setFailureReason(strSuccess);
                            this.m_oRecoverTableModel.setValueAt(operationStatus, i, 7);
                            this.updateHapMaps(operationType, oDevid);
                            if (this.m_oDevIDForBusyDev.contains(oDevid)) continue;
                            this.m_oRecoverDlg.updateDeviceRecoverResult(oDevid.toString(), iFailureReason);
                            continue;
                        }
                        if (0 > iProgressPercentage) continue;
                        if (!this.m_oDevIDForBusyDev.contains(oDevid)) {
                            this.m_oDevIDForBusyDev.add(oDevid);
                        }
                        operationStatus.setIsProgress(true);
                        operationStatus.setProgress(iProgressPercentage);
                        this.m_oRecoverTableModel.setValueAt(operationStatus, i, 7);
                        continue;
                    }
                    this.updateHapMaps(operationType, oDevid);
                    if (!this.m_oDevIDForBusyDev.contains(oDevid)) {
                        this.m_oRecoverDlg.updateDeviceRecoverResult(oDevid.toString(), iFailureReason);
                    }
                    String failureReason = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iFailureReason));
                    if (null != strErrorMsg) {
                        failureReason = strErrorMsg;
                    }
                    operationStatus.setIsProgress(false);
                    operationStatus.setIsInitialize(false);
                    operationStatus.setIFailureReason(iFailureReason);
                    operationStatus.setFailureReason(failureReason);
                    this.m_oRecoverTableModel.setValueAt(operationStatus, i, 7);
                }
                if (0 == this.m_oDevIDForBusyDev.size()) {
                    this.m_oRecoverDlg.btnEnableDisable(true);
                } else {
                    this.m_oRecoverDlg.btnEnableDisable(false);
                }
            }
        }
        DCDebugTracer.trace("DC::RecoverOperationController#updateDeviceProgress end..");
    }

    private void updateHapMaps(int iOperationType, Integer oDeviceId) {
        if (this.m_oRebootDevVector.contains(oDeviceId)) {
            if (9 == iOperationType) {
                this.m_oDevIDForBusyDev.remove(oDeviceId);
                this.m_oRebootDevVector.remove(oDeviceId);
            }
        } else {
            this.m_oDevIDForBusyDev.remove(oDeviceId);
        }
        XFtpManager.getInstance().decrementSftpOPerationCount(oDeviceId);
    }
}

