/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.recover;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCFile;
import com.huawei.dc.common.asndatacenter.AsnDCFileLst;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.dialog.IBrowseDlgInterafce;
import com.huawei.dc.common.components.dialog.ProgressDlg;
import com.huawei.dc.common.components.dialog.SimpleProgressDlg;
import com.huawei.dc.common.components.dialog.fileselection.ExternalFTPFileView;
import com.huawei.dc.common.components.dialog.fileselection.FileSelectionBrowseDlg;
import com.huawei.dc.common.components.table.DCTable;
import com.huawei.dc.common.components.table.IDCTableModelListener;
import com.huawei.dc.common.components.table.editor.DCTableComboBoxCellEditor;
import com.huawei.dc.common.components.table.model.DCList;
import com.huawei.dc.common.components.table.model.DCTableModel;
import com.huawei.dc.common.components.table.model.IDCTableRowData;
import com.huawei.dc.common.components.table.renderer.DCTableCheckBoxHeader;
import com.huawei.dc.common.components.table.renderer.DCTableComboBoxCellRenderer;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.utility.CommonUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.IOperation;
import com.huawei.dc.devicemanagement.deviceoperation.ParaValue;
import com.huawei.dc.devicemanagement.deviceoperation.recover.IUpdateRecoverFile;
import com.huawei.dc.devicemanagement.deviceoperation.recover.RebootConfirmationDlg;
import com.huawei.dc.devicemanagement.deviceoperation.recover.RecoverConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.recover.RecoverFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.recover.RecoverOperation;
import com.huawei.dc.devicemanagement.deviceoperation.recover.controller.RecoverOperationController;
import com.huawei.dc.devicemanagement.deviceoperation.recover.model.DCRecoverTableInfo;
import com.huawei.dc.devicemanagement.deviceoperation.recover.model.DCRecoverTableModel;
import com.huawei.dc.devicemanagement.deviceoperation.recover.model.DCRecoverTableRowData;
import com.huawei.dc.devicemanagement.model.xmlconfig.IXMLConfigConstants;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.framework.XFtpManager;
import com.huawei.dc.standalone.IManualOperation;
import com.huawei.dc.standalone.StandAloneDomainInfo;
import com.huawei.dc.standalone.controller.StandAloneSyncCtrller;
import com.huawei.dc.standalone.model.RouterDevInfoObj;
import com.swimap.iview.framework.modulemanagement.InternalLocalMsg;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class DCRecoverDlg
extends DCModalDialog
implements IBrowseDlgInterafce,
IUpdateRecoverFile,
IDCTableModelListener {
    private static final long serialVersionUID = 3912988630181008420L;
    private HashMap<DeviceInfo, IOperation> mDevOperationMap;
    private ResourceManager mResourceMgr = ResourceManager.getInstance();
    private DCRecoverTableModel mRecoverTableModel = null;
    private DCTable mRecoverTable = null;
    private ProgressDlg mProgressDlg = new SimpleProgressDlg();
    private DeviceInfo[] mArrDevInfo;
    private HashMap<Integer, DCList<RecoverFileInfo>> mFileInfoMap;
    private InternalLocalMsg oInternalmsg = null;
    boolean isContentTypeRequired = false;
    boolean isBoardTypeRequired = false;
    boolean isFileNameRequired = false;
    boolean isRebootRequired = false;
    boolean isDeliverToBoardReboot = false;
    boolean isShowStateColumn = false;
    private FileSelectionBrowseDlg mRecoverFileBrowseDlg = null;
    private boolean mIsCAM = false;
    private IManualOperation mManualOperation;
    private Vector<Integer> mAgentDevInfoVec;
    private static final String HTML_TAG = ResourceManager.getInstance().getResString("HTML_TAG");
    private static final String HTML_BREAK = ResourceManager.getInstance().getResString("HTML_BREAK");
    private long firstOpenClientTime = System.nanoTime();
    private boolean mRebootConfirm = false;
    private boolean mAllTL1DevInRecoverDlg = true;
    private ParaValue mRebootType = null;
    private boolean m_recoverServerPrivilege = true;
    private boolean m_recoverClientPrivilege = true;
    private boolean m_recoverThirdPrivilege = true;

    public DCRecoverDlg(HashMap<DeviceInfo, IOperation> oDevOperationMap, HashMap<Integer, DCList<RecoverFileInfo>> oFileInfoMap, IManualOperation oManualOperation, boolean isCAM) throws DCException {
        this.mDevOperationMap = oDevOperationMap;
        this.mArrDevInfo = this.mDevOperationMap.keySet().toArray(new DeviceInfo[0]);
        this.mFileInfoMap = oFileInfoMap;
        this.mIsCAM = isCAM;
        this.mManualOperation = oManualOperation;
        this.setSize(665, 395);
        this.setMinimumSize(new Dimension(665, 395));
        this.setResizable(true);
        if (isCAM) {
            this.setTitle(ResourceManager.getInstance().getResString("CAM"));
        } else {
            this.setTitle(ResourceManager.getInstance().getResString("RECOVER"));
            this.checkUserPrivilege();
        }
        if (null == this.mManualOperation) {
            this.isShowStateColumn = true;
        }
        this.jbInit();
    }

    private void checkUserPrivilege() {
        if (DCFrameWorkUtil.getIsSingleClient()) {
            return;
        }
        this.m_recoverServerPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(43824);
        this.m_recoverClientPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(43868);
        this.m_recoverThirdPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(44096);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.firstOpenClientTime ^ this.firstOpenClientTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DCRecoverDlg other = (DCRecoverDlg)obj;
        return this.firstOpenClientTime == other.firstOpenClientTime;
    }

    public void updateDeviceRecoverResult(String deviceId, int result) {
        CommonUtil.updateDeviceBackupResult(this.oInternalmsg, deviceId, result);
    }

    private void jbInit() throws DCException {
        this.getContentPane().setLayout(new BorderLayout(0, 3));
        this.initAgentDevInfo();
        this.initializeTable();
        this.initializeBtnPanel();
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
    }

    private void initAgentDevInfo() throws DCException {
        this.mAgentDevInfoVec = new Vector();
        if (DCFrameWorkUtil.getIsSingleClient() && 2 == StandAloneDomainInfo.getInstance().getSelectedDomain()) {
            int iSize = this.mArrDevInfo.length;
            ArrayList<Integer> devIdLst = new ArrayList<Integer>(iSize);
            for (int i = 0; i < iSize; ++i) {
                devIdLst.add(this.mArrDevInfo[i].getDevId());
            }
            List<RouterDevInfoObj> devInfoObjLst = StandAloneSyncCtrller.getInstance().getRouterDevExtInfo(devIdLst);
            for (RouterDevInfoObj oRouterDevInfo : devInfoObjLst) {
                if (null == oRouterDevInfo.getParentDevInfoObj()) continue;
                this.mAgentDevInfoVec.add(oRouterDevInfo.getDevID());
            }
        }
    }

    private void initializeTableModel() {
        Vector<IDCTableRowData> oTableRowDataVec = new Vector<IDCTableRowData>();
        DCRecoverTableInfo oTableInfo = new DCRecoverTableInfo();
        boolean[][] isCellEditable = new boolean[this.mArrDevInfo.length][oTableInfo.getHeader().length];
        int iRow = 0;
        this.mAllTL1DevInRecoverDlg = true;
        for (DeviceInfo oDevInfo : this.mArrDevInfo) {
            boolean isTmpFileNameRequired;
            RecoverOperation oTmpRecoverOperation = (RecoverOperation)this.mDevOperationMap.get(oDevInfo);
            RecoverConfigPara oTmpConfigPara = oTmpRecoverOperation.getConfigParam();
            DCRecoverTableRowData rowData = new DCRecoverTableRowData();
            rowData.setDevId(oDevInfo.getDevId());
            rowData.setDevName(oDevInfo.getDevName());
            rowData.setDevAddress(oDevInfo.getDevIPAddress());
            if (this.mAgentDevInfoVec.contains(oDevInfo.getDevId())) {
                rowData.setIsAgent(true);
            }
            if (isTmpFileNameRequired = oTmpConfigPara.isFileNameRequired()) {
                this.isFileNameRequired = isTmpFileNameRequired;
                DCList<RecoverFileInfo> oFileLstInMap = this.mFileInfoMap.get(oDevInfo.getDevId());
                DCList<RecoverFileInfo> oFileLst = new DCList<RecoverFileInfo>();
                if (this.m_recoverServerPrivilege) {
                    oFileLst = oFileLstInMap;
                } else {
                    oFileLst.addData(oFileLstInMap.getAllDataLst().get(0));
                    oFileLst.addData(oFileLstInMap.getAllDataLst().get(1));
                }
                rowData.setFileLst(oFileLst);
                int iFileSize = rowData.getFileLst().getAllDataLst().size();
                if (2 >= iFileSize) {
                    rowData.getFileLst().setCurrSelectedIndex(0);
                } else {
                    rowData.getFileLst().setCurrSelectedIndex(2);
                }
                isCellEditable[iRow][4] = true;
            }
            this.configRecoverTableCell(isCellEditable, iRow, oDevInfo, oTmpConfigPara, rowData);
            isCellEditable[iRow][7] = false;
            oTableRowDataVec.add(rowData);
            ++iRow;
        }
        this.mRecoverTableModel = new DCRecoverTableModel(oTableInfo);
        this.mRecoverTableModel.setCellEditable(isCellEditable);
        this.mRecoverTableModel.setDataVector(oTableRowDataVec);
    }

    private void configRecoverTableCell(boolean[][] isCellEditable, int iRow, DeviceInfo oDevInfo, RecoverConfigPara oTmpConfigPara, DCRecoverTableRowData rowData) {
        if (!this.mIsCAM) {
            boolean isTmpDeliverToBoardReboot;
            boolean isTmpBoardTypeRequired;
            boolean isTmpContentTypeRequired = oTmpConfigPara.isRecoverContentTypeRequired();
            if (isTmpContentTypeRequired) {
                this.isContentTypeRequired = isTmpContentTypeRequired;
                ArrayList oContentTypeLst = (ArrayList)oTmpConfigPara.getRecoverContentTypeValueList();
                DCList<ParaValue> oContentType = new DCList<ParaValue>();
                for (ParaValue oParaValue : oContentTypeLst) {
                    oContentType.addData(oParaValue);
                }
                oContentType.setCurrSelectedIndex(0);
                rowData.setContentTypeLst(oContentType);
                isCellEditable[iRow][2] = true;
            }
            if (isTmpBoardTypeRequired = oTmpConfigPara.isBoardRequired()) {
                this.isBoardTypeRequired = isTmpBoardTypeRequired;
                ArrayList oBoardLst = (ArrayList)oTmpConfigPara.getBoardParaValueList();
                DCList<ParaValue> oBoardType = new DCList<ParaValue>();
                for (ParaValue oParaValue : oBoardLst) {
                    oBoardType.addData(oParaValue);
                }
                oBoardType.setCurrSelectedIndex(0);
                rowData.setBoardTypeLst(oBoardType);
                isCellEditable[iRow][3] = true;
            }
            boolean isRebootType = false;
            boolean isTmpRebootRequired = oTmpConfigPara.isActivationRequired();
            if (isTmpRebootRequired) {
                this.isRebootRequired = isTmpRebootRequired;
                ArrayList oRebootTypeLst = (ArrayList)oTmpConfigPara.getActivationParaValueList();
                DCList<ParaValue> oRebootType = new DCList<ParaValue>();
                ParaValue oOSSUParaValue = null;
                for (int j = 0; j < oRebootTypeLst.size(); ++j) {
                    ParaValue oParaValue = (ParaValue)oRebootTypeLst.get(j);
                    oRebootType.addData(this.getActivationId(oParaValue));
                    if (!oParaValue.getId().equals("OSSU")) continue;
                    oOSSUParaValue = oParaValue;
                }
                boolean bIsSelectOSSUbyDat = false;
                if (DeviceInfoUtil.isDomainDevice(oDevInfo.getDevId(), 4)) {
                    DCList<RecoverFileInfo> recoverFileLst = rowData.getFileLst();
                    if (null != recoverFileLst && null != recoverFileLst.getCurrSelectedObj()) {
                        RecoverFileInfo obj = recoverFileLst.getCurrSelectedObj();
                        String sFileName = obj.getFileName();
                        if (null != sFileName && sFileName.endsWith(".dat") && null != oOSSUParaValue) {
                            oRebootType.setCurrSelectedObj(oOSSUParaValue);
                            bIsSelectOSSUbyDat = true;
                        } else {
                            bIsSelectOSSUbyDat = false;
                        }
                    }
                    if (!bIsSelectOSSUbyDat) {
                        oRebootType.setCurrSelectedIndex(1);
                    }
                } else {
                    isRebootType = bIsSelectOSSUbyDat;
                    oRebootType.setCurrSelectedIndex(0);
                }
                rowData.setRebootTypeLst(oRebootType);
                isCellEditable[iRow][5] = true;
            }
            if (isTmpDeliverToBoardReboot = oTmpConfigPara.isDeliverToBoardRebootReuqired()) {
                boolean isTL1Dev;
                this.isDeliverToBoardReboot = isTmpDeliverToBoardReboot;
                DCList<ParaValue> paraValues = rowData.getRebootTypeLst();
                boolean isReboot = true;
                if (null != paraValues) {
                    isReboot = paraValues.getCurrSelectedObj().getId().equals(IXMLConfigConstants.ACTIVATE_NO_REBOOT);
                }
                if ((isTL1Dev = DeviceInfoUtil.isTL1Dev(rowData.getDevId())) && isReboot) {
                    isCellEditable[iRow][6] = false;
                } else {
                    isCellEditable[iRow][6] = isRebootType || !isReboot;
                    if (this.mAllTL1DevInRecoverDlg) {
                        this.mAllTL1DevInRecoverDlg = false;
                    }
                }
                rowData.setIsDeliverToBoard(false);
            }
        }
    }

    private void initializeTable() {
        this.initializeTableModel();
        this.mRecoverTable = new DCTable(this.mRecoverTableModel);
        this.mRecoverTable.setName("DeviceOperation_RecoverDlg_m_oRecoverTable");
        this.mRecoverTable.setRowHeight(21);
        this.mRecoverTable.getTableHeader().setPreferredSize(new Dimension(this.mRecoverTable.getSize().width, 21));
        this.mRecoverTable.getTableHeader().setReorderingAllowed(false);
        this.mRecoverTableModel.addDCTableModelListener(this);
        if (!this.isContentTypeRequired) {
            this.hideColumn(this.mResourceMgr.getResString("RECOVER_CONTENT_TYPE"));
        }
        if (!this.isBoardTypeRequired) {
            this.hideColumn(this.mResourceMgr.getResString("MULDEVICE_RECOVER_DLG_BOARD"));
        }
        String strFileNameHeader = this.mResourceMgr.getResString("MULDEVICE_RECIVER_DLG_FILE_NAME");
        if (!this.isFileNameRequired) {
            this.hideColumn(strFileNameHeader);
        } else {
            this.mRecoverTable.getColumn(strFileNameHeader).setCellRenderer(new FileInfoColumnRenderer());
            this.mRecoverTable.getColumn(strFileNameHeader).setCellEditor(new FileInfoColumnEditor(new JComboBox()));
        }
        String sRebootTypeHeader = this.mResourceMgr.getResString("MULDEVICE_RECOVER_DLG_REBOOT_DEVICE");
        if (!this.isRebootRequired) {
            this.hideColumn(sRebootTypeHeader);
        } else {
            this.mRecoverTable.getColumn(sRebootTypeHeader).setCellRenderer(new RebootColumnRenderer());
        }
        String strDeliverToBoardHeader = this.mResourceMgr.getResString("MULDEVICE_RECOVER_DLG_DELVER_TO_BOARD_REBOOT");
        if (!this.isDeliverToBoardReboot) {
            this.hideColumn(strDeliverToBoardHeader);
        } else {
            DeliverToBoardColumnHeader deliverToBoardColumnHeader = new DeliverToBoardColumnHeader(this.mRecoverTable, 6);
            this.mRecoverTable.getColumn(strDeliverToBoardHeader).setHeaderRenderer(deliverToBoardColumnHeader);
            this.mRecoverTableModel.addDCTableModelListener(deliverToBoardColumnHeader);
        }
        if (!this.isShowStateColumn) {
            this.hideColumn(this.mResourceMgr.getResString("DEVICEINFOPAN_TABLE_DEVICESTATE"));
        }
        JScrollPane scrollPane = new JScrollPane(this.mRecoverTable);
        this.getContentPane().add(Box.createVerticalStrut(12), "North");
        this.getContentPane().add(Box.createHorizontalStrut(12), "West");
        this.getContentPane().add((Component)scrollPane, "Center");
        this.getContentPane().add(Box.createHorizontalStrut(12), "East");
    }

    private void hideColumn(String strColumName) {
        TableColumn oColumn = this.mRecoverTable.getColumn(strColumName);
        if (null != oColumn) {
            oColumn.setMinWidth(0);
            oColumn.setPreferredWidth(0);
            oColumn.setMaxWidth(0);
            oColumn.setResizable(false);
        }
    }

    private void initializeBtnPanel() {
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout(2));
        this.m_oOKBtn.setText(ResourceManager.getInstance().getResString("BACKUP_START_BUTTON"));
        this.m_oOKBtn.setName("DeviceOperation_RecoverDlg_m_oStartBtn");
        this.m_oOKBtn.setMnemonic('S');
        this.m_oOKBtn.setPreferredSize(new Dimension(80, 21));
        this.m_oCancelBtn.setText(ResourceManager.getInstance().getResString("CLOSE_BUTTON"));
        this.m_oCancelBtn.setName("DeviceOperation_RecoverDlg_m_oCloseBtn");
        this.m_oCancelBtn.setPreferredSize(new Dimension(80, 21));
        btnPanel.add(this.m_oOKBtn);
        btnPanel.add(this.m_oCancelBtn);
        btnPanel.add(Box.createHorizontalStrut(2));
        this.getContentPane().add((Component)btnPanel, "South");
    }

    @Override
    protected String getCurrentContext() {
        if (this.mIsCAM) {
            return "HELP_TOPIC_NE_SCRIPT_FILE";
        }
        return "HELP_TOPIC_MANUAL_RECOVER";
    }

    @Override
    public void setFileOrDirectory(String strFilePath, String strVersion, boolean file) {
        int iSelectedRow = this.mRecoverTable.getSelectedRow();
        DCRecoverTableRowData rowData = (DCRecoverTableRowData)this.mRecoverTableModel.getRowData(iSelectedRow);
        int iDevId = rowData.getDevId();
        ArrayList<RecoverFileInfo> oList = rowData.getFileLst().getAllDataLst();
        RecoverFileInfo oRecoverFileInfo = new RecoverFileInfo();
        oRecoverFileInfo.setDevid(iDevId);
        oRecoverFileInfo.setFileName(strFilePath.trim());
        oRecoverFileInfo.setBackupVerInfo(strVersion.trim());
        oRecoverFileInfo.setDestination(this.mRecoverFileBrowseDlg.getDestination());
        oRecoverFileInfo.setExternalFTPServerName(this.mRecoverFileBrowseDlg.getExternalFTPServerName());
        if (!oList.contains(oRecoverFileInfo)) {
            rowData.getFileLst().addData(oRecoverFileInfo);
            rowData.getFileLst().setCurrSelectedIndex(oList.size() - 1);
        } else {
            int i;
            for (i = oList.size() - 1; i >= 0 && !((RecoverFileInfo)oList.get(i)).equals(oRecoverFileInfo); --i) {
            }
            rowData.getFileLst().setCurrSelectedIndex(i);
        }
        this.handelForOptixDevice(strFilePath.trim(), iSelectedRow);
        DCFrameWorkUtil.updateUI(this.mRecoverTable);
        this.mRecoverTable.repaint();
    }

    @Override
    public void addFileForDev(int iDevId, AsnDCFileLst oFileList) {
        int iNoOfFiles = oFileList.size();
        DCList<RecoverFileInfo> oRecoverFile = new DCList<RecoverFileInfo>();
        RecoverFileInfo oNonRecoverFileInfo = new RecoverFileInfo();
        oNonRecoverFileInfo.setDevid(iDevId);
        oRecoverFile.addData(oNonRecoverFileInfo);
        RecoverFileInfo oBrowseInfo = new RecoverFileInfo();
        oBrowseInfo.setDevid(iDevId);
        oBrowseInfo.setFileName(ResourceManager.getInstance().getResString("RECOVER_BROWSE_BTN"));
        oRecoverFile.addData(oBrowseInfo);
        for (int index = 0; index < iNoOfFiles; ++index) {
            AsnDCFile oFile = (AsnDCFile)oFileList.get(index);
            RecoverFileInfo oRecoverFileInfo = new RecoverFileInfo();
            oRecoverFileInfo.setDevid(iDevId);
            oRecoverFileInfo.setFileName(new String(oFile.strTimeOrFileName));
            if (null != oFile.strVersion) {
                oRecoverFileInfo.setBackupVerInfo(new String(oFile.strVersion));
            }
            oRecoverFile.addData(oRecoverFileInfo);
        }
        oRecoverFile.setCurrSelectedIndex(iNoOfFiles + 1);
        this.mFileInfoMap.put(iDevId, oRecoverFile);
    }

    @Override
    public void updateProgressValue(int iProgressValue, String strDeviceName) {
        String strOperationResult = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(0L));
        this.mProgressDlg.setProgress(strDeviceName, strOperationResult, iProgressValue);
        if (iProgressValue == 100) {
            this.mProgressDlg.setVisible(false);
            this.mProgressDlg.dispose();
        }
    }

    private int showConfirmationDialog(String strMessage, String strMessageType, int iMessageType) {
        int iConfirm = DCOptionPane.showConfirmDialog((Component)((Object)this), strMessage, strMessageType, iMessageType);
        return iConfirm;
    }

    private void showMessageDialog(String strMessage, String strMessageType, int iMessageType) {
        DCOptionPane.showMessageDialog((Component)((Object)this), strMessage, strMessageType, iMessageType);
    }

    private boolean validateSelection() {
        int iConfirm;
        int iRowCount = this.mRecoverTableModel.getRowCount();
        int iRecoverFileCount = 0;
        boolean bAreAllFilesPresent = true;
        String strSelectedFileName = "";
        boolean bIsNeedRebootByDatFile = false;
        for (int iRowIndex = 0; iRowIndex < iRowCount; ++iRowIndex) {
            DCRecoverTableRowData rowData = (DCRecoverTableRowData)this.mRecoverTableModel.getRowData(iRowIndex);
            strSelectedFileName = rowData.getFileLst().getCurrSelectedObj().getFileName();
            if ("".equals(strSelectedFileName) || strSelectedFileName.equals(ResourceManager.getInstance().getResString("RECOVER_BROWSE_BTN"))) {
                if (!bAreAllFilesPresent) continue;
                bAreAllFilesPresent = false;
                continue;
            }
            if (strSelectedFileName.endsWith(".zip") && null != rowData.getContentTypeLst()) {
                int iContentType = rowData.getContentTypeLst().getCurrSelectedObj().getValue();
                if (2 == iContentType) {
                    this.showMessageDialog(this.mResourceMgr.getResString("MSG_RECOVER_FILE_FORBID_ZIP"), this.mResourceMgr.getResString("ERROR"), 0);
                    return false;
                }
                ++iRecoverFileCount;
                continue;
            }
            if (strSelectedFileName.endsWith(".dat")) {
                if (DeviceInfoUtil.isDomainDevice(rowData.getDevId(), 4)) {
                    bIsNeedRebootByDatFile = true;
                }
                ++iRecoverFileCount;
                continue;
            }
            ++iRecoverFileCount;
        }
        if (0 == iRecoverFileCount) {
            String errorMsg = "";
            errorMsg = this.mIsCAM ? this.mResourceMgr.getResString("NO_File_SELECTED") : this.mResourceMgr.getResString("NO_RECOVER_FILE_SELECTED");
            this.showMessageDialog(errorMsg, this.mResourceMgr.getResString("ERROR"), 0);
            return false;
        }
        if (!bAreAllFilesPresent) {
            iConfirm = this.showConfirmationDialog(this.mResourceMgr.getResString("RECOVER_SOME_FILE_SELECTRED_CONFIRM"), this.mResourceMgr.getResString("CONFIRM"), 0);
            return iConfirm == 0;
        }
        if (this.isNoRebootOptionSelected()) {
            iConfirm = this.showConfirmationDialog(this.mResourceMgr.getResString("REBOOT_NOT_SELECTED_CONFIRM"), this.mResourceMgr.getResString("CONFIRMATION_DIALOG_TITLE"), 0);
            return iConfirm == 0;
        }
        if (bIsNeedRebootByDatFile) {
            iConfirm = DCOptionPane.showExtConfirmDialog((Component)((Object)this), ResourceManager.getInstance().getResString("RECOVER_MSG"), ResourceManager.getInstance().getResString("WARNING"), 0, 2);
            return iConfirm == 0;
        }
        if (!this.isNoRebootOptionSelected()) {
            iConfirm = 0;
            iConfirm = this.mIsCAM ? DCOptionPane.showExtConfirmDialog((Component)((Object)this), ResourceManager.getInstance().getResString("CAM_MSG"), ResourceManager.getInstance().getResString("WARNING"), 0, 2) : DCOptionPane.showExtConfirmDialog((Component)((Object)this), this.mResourceMgr.getResString("RECOVER_MSG_WHEN_SELECT_REBOOT"), this.mResourceMgr.getResString("WARNING"), 0, 2);
            if (iConfirm != 0) {
                return false;
            }
        }
        return true;
    }

    private boolean isNoRebootOptionSelected() {
        int iRowCount = this.mRecoverTableModel.getRowCount();
        boolean bIsNoRebootOptionSelected = false;
        for (int iRowIndex = 0; iRowIndex < iRowCount; ++iRowIndex) {
            DCRecoverTableRowData rowData = (DCRecoverTableRowData)this.mRecoverTableModel.getRowData(iRowIndex);
            if (null == rowData.getRebootTypeLst() || 0 != rowData.getRebootTypeLst().getCurrSelectedObj().getValue()) continue;
            if (null == rowData.getContentTypeLst()) {
                bIsNoRebootOptionSelected = true;
                break;
            }
            String strContentTypeId = rowData.getContentTypeLst().getCurrSelectedObj().getId();
            if ("RUNNINGCONF".equals(strContentTypeId)) continue;
            bIsNoRebootOptionSelected = true;
            break;
        }
        return bIsNoRebootOptionSelected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void oKButton_ActionPerformed() {
        if (null != this.mRecoverTable.getCellEditor()) {
            this.mRecoverTable.getCellEditor().stopCellEditing();
            DCFrameWorkUtil.updateUI(this.mRecoverTable);
        }
        if (!this.validateSelection()) {
            return;
        }
        RecoverOperationController oRecoverOperationController = new RecoverOperationController(this, this.mManualOperation, this.mRecoverTableModel);
        try {
            DCFrameWorkUtil.setCursor((Component)((Object)this), Cursor.getPredefinedCursor(3));
            if (this.mIsCAM) {
                oRecoverOperationController.setIsCam();
                oRecoverOperationController.sendCamRecoverRequest();
            } else {
                oRecoverOperationController.sendRecoverRequest();
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        finally {
            DCFrameWorkUtil.setCursor((Component)((Object)this), Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    public void doCleanUp() {
        if (null != this.mDevOperationMap) {
            this.mDevOperationMap.clear();
            this.mDevOperationMap = null;
        }
        if (null != this.mFileInfoMap) {
            this.mFileInfoMap.clear();
            this.mFileInfoMap = null;
        }
        DCFrameWorkUtil.setCursor((Component)((Object)this), Cursor.getDefaultCursor());
        if (DCFrameWorkUtil.getIsClientFrmTopo()) {
            if (DCFrameWorkUtil.getDCModuleManager().isHaveOpenedDC()) {
                return;
            }
            DCFrameWorkUtil.getSecurityManager().doLogOut();
            XFtpManager.getInstance().clientOpCleanUp();
            DCFrameWorkUtil.shutDown();
            BaseCommManager commManager = DCFrameWorkUtil.getCommManager();
            if (commManager != null) {
                commManager.stopShakeHand();
            }
            DCFrameWorkUtil.defaultCursor();
        }
    }

    private void browseDlg() {
        try {
            int iSelectedRow = this.mRecoverTable.getSelectedRow();
            DCRecoverTableRowData rowData = (DCRecoverTableRowData)this.mRecoverTableModel.getRowData(iSelectedRow);
            int iDevId = rowData.getDevId();
            DeviceInfo oDevInfo = this.getDevInfo(iDevId);
            ExternalFTPFileView FTPFileView = new ExternalFTPFileView();
            ExternalFTPFileView.getDeviceInfo(oDevInfo);
            RecoverOperation oRecoverOpr = (RecoverOperation)this.mDevOperationMap.get(oDevInfo);
            boolean bisClientOperationSupported = oRecoverOpr.getConfigParam().isRecoverFromClientRequired();
            if (bisClientOperationSupported) {
                bisClientOperationSupported = !DCFrameWorkUtil.getIsSingleClient();
            }
            boolean bisExternalFTPOperationSupported = oRecoverOpr.getConfigParam().isRecoverFromExternalFTPRequired();
            this.mRecoverFileBrowseDlg = new FileSelectionBrowseDlg(bisClientOperationSupported, bisExternalFTPOperationSupported, false, "Recover");
            this.mRecoverFileBrowseDlg.registBrowseDlgInterface(this);
            this.mRecoverFileBrowseDlg.setTitle(ResourceManager.getInstance().getResString("RECOVER_DLG_SELECT_FILE_TITLE"));
            this.visible(this.mRecoverFileBrowseDlg);
        }
        catch (DCException oDCException) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), oDCException.getMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
            DCDebugTracer.trace("DC::RecoverDlg::browseDlg()::throw exception::" + oDCException.getMessage());
        }
    }

    private void visible(final FileSelectionBrowseDlg oDlg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                oDlg.setVisible(true);
            }
        });
    }

    private DeviceInfo getDevInfo(int iDevId) {
        for (DeviceInfo oDevInfo : this.mArrDevInfo) {
            if (iDevId != oDevInfo.getDevId()) continue;
            return oDevInfo;
        }
        return null;
    }

    public DeviceInfo obtainDevInfo(int iDevId) {
        for (DeviceInfo oDevInfo : this.mArrDevInfo) {
            if (iDevId != oDevInfo.getDevId()) continue;
            return oDevInfo;
        }
        return null;
    }

    @Override
    public void tableDataChanged(TableModelEvent e) {
        int column = e.getColumn();
        if (4 == column) {
            int row = e.getFirstRow();
            String strValue = String.valueOf(((AbstractTableModel)e.getSource()).getValueAt(row, column));
            if (ResourceManager.getInstance().getResString("RECOVER_BROWSE_BTN").equals(strValue)) {
                this.browseDlg();
            } else {
                this.handelForOptixDevice(strValue, row);
                this.mRecoverTableModel.fireTableCellUpdated(row, column);
                DCFrameWorkUtil.updateUI(this.mRecoverTable.getTableHeader());
                DCFrameWorkUtil.updateUI(this.mRecoverTable);
            }
        } else if (5 == column && !this.mIsCAM) {
            if (e.getSource() instanceof DCRecoverTableModel) {
                int row = e.getFirstRow();
                DCRecoverTableRowData rowData = (DCRecoverTableRowData)this.mRecoverTableModel.getRowData(row);
                DCList<ParaValue> dcList = rowData.getRebootTypeLst();
                ParaValue oCurSelectedRebootType = null;
                if (null != dcList) {
                    oCurSelectedRebootType = rowData.getRebootTypeLst().getCurrSelectedObj();
                }
                if (null != oCurSelectedRebootType && "OSSU".equals(oCurSelectedRebootType.getId())) {
                    this.mRecoverTableModel.setCellEditable(row, 6, true);
                    if (this.mRebootConfirm) {
                        return;
                    }
                    int iRtnValue = new RebootConfirmationDlg(this).showDlg();
                    boolean bl = this.mRebootConfirm = iRtnValue == 1;
                    if (iRtnValue == -1) {
                        rowData.getRebootTypeLst().setCurrSelectedIndex(0);
                        this.mRecoverTableModel.setCellEditable(row, 6, false);
                    }
                } else if (null != oCurSelectedRebootType && IXMLConfigConstants.ACTIVATE_NO_REBOOT.equals(oCurSelectedRebootType.getId())) {
                    this.mRecoverTableModel.setValueAt(false, row, 6);
                    this.mRecoverTableModel.setCellEditable(row, 6, false);
                }
            }
            if (this.isDeliverToBoardReboot) {
                DCFrameWorkUtil.updateUI(this.mRecoverTable.getTableHeader());
                DCFrameWorkUtil.updateUI(this.mRecoverTable);
            }
        } else if (2 == column) {
            int iRow = e.getFirstRow();
            if (e.getSource() instanceof DCRecoverTableModel) {
                DCRecoverTableRowData rowData = (DCRecoverTableRowData)this.mRecoverTableModel.getRowData(iRow);
                ParaValue oContentType = rowData.getContentTypeLst().getCurrSelectedObj();
                DeviceInfo oDeviceInfo = this.getDevInfo(rowData.getDevId());
                if (null != oContentType && ResourceManager.getInstance().isSecurityDevDevType(oDeviceInfo.getDeviceTypeInfo())) {
                    DCList<ParaValue> oRebootTypeLst = rowData.getRebootTypeLst();
                    ArrayList<ParaValue> oRebootTypeDataLst = oRebootTypeLst.getAllDataLst();
                    if (oContentType.getId().equals("RUNNINGCONF")) {
                        for (int i = oRebootTypeDataLst.size() - 1; i >= 0; --i) {
                            ParaValue oRebootTypeData = oRebootTypeDataLst.get(i);
                            if (!oRebootTypeData.getId().equals("OSSU")) continue;
                            oRebootTypeDataLst.remove(i);
                            this.mRebootType = oRebootTypeData;
                            oRebootTypeLst.setAllDataLst(oRebootTypeDataLst);
                            oRebootTypeLst.setCurrSelectedIndex(0);
                            rowData.setRebootTypeLst(oRebootTypeLst);
                            break;
                        }
                    } else if (oContentType.getId().equals("STARTUPCONF") && null != this.mRebootType && !oRebootTypeDataLst.contains(this.mRebootType)) {
                        oRebootTypeDataLst.add(this.mRebootType);
                        oRebootTypeLst.setAllDataLst(oRebootTypeDataLst);
                        oRebootTypeLst.setCurrSelectedIndex(0);
                        rowData.setRebootTypeLst(oRebootTypeLst);
                    }
                    DCFrameWorkUtil.updateUI(this.mRecoverTable.getTableHeader());
                    DCFrameWorkUtil.updateUI(this.mRecoverTable);
                }
            }
        }
    }

    private boolean handelForOptixDevice(String sFileName, int iRow) {
        if (null == sFileName || !sFileName.endsWith(".dat")) {
            return false;
        }
        DCRecoverTableRowData rowData = (DCRecoverTableRowData)this.mRecoverTableModel.getRowData(iRow);
        int iDevID = rowData.getDevId();
        if (!DeviceInfoUtil.isDomainDevice(iDevID, 4)) {
            return false;
        }
        DCList<ParaValue> oRebootTypeLst = rowData.getRebootTypeLst();
        ArrayList<ParaValue> oRebootLst = oRebootTypeLst.getAllDataLst();
        ParaValue oRebootType = null;
        for (int i = 0; i < oRebootLst.size(); ++i) {
            oRebootType = oRebootLst.get(i);
            if (!oRebootType.getId().equals("OSSU")) continue;
            oRebootTypeLst.setCurrSelectedIndex(i);
            return true;
        }
        return false;
    }

    public void btnEnableDisable(boolean isEnable) {
        if (null == this.m_oOKBtn) {
            DCDebugTracer.traceError("btnEnableDisable()-m_oStartBtn is null");
            return;
        }
        this.m_oOKBtn.setEnabled(isEnable);
        DCFrameWorkUtil.updateUI(this.mRecoverTable);
    }

    public DeviceInfo[] getDevInfos() {
        return this.mArrDevInfo;
    }

    private ParaValue getActivationId(ParaValue oPara) {
        ParaValue oReturnParaValue = new ParaValue();
        oReturnParaValue.setId(oPara.getId());
        oReturnParaValue.setValue(oPara.getValue());
        oReturnParaValue.setDisplayName(oPara.getDisplayName());
        oReturnParaValue.setDestination(oPara.getDestination());
        String strActivationId = "";
        int iActivationValue = 0;
        strActivationId = oPara.getId();
        if (strActivationId.equals(IXMLConfigConstants.ACTIVATE_NO_REBOOT)) {
            iActivationValue = 0;
        } else if (strActivationId.equals("OSSU")) {
            iActivationValue = 1;
        } else if (strActivationId.equals("ISSU")) {
            iActivationValue = 2;
        } else if (strActivationId.equals("ScheduledReboot")) {
            iActivationValue = 3;
        }
        oReturnParaValue.setValue(iActivationValue);
        return oReturnParaValue;
    }

    public void setoInternalmsg(InternalLocalMsg oInternalmsg) {
        this.oInternalmsg = oInternalmsg;
        if (this.oInternalmsg.data instanceof List) {
            HashMap<Integer, Integer> devOptResult = new HashMap<Integer, Integer>();
            List oDevInfoLst = (List)oInternalmsg.data;
            int iSizeOfLst = oDevInfoLst.size();
            for (int i = 0; i < iSizeOfLst; ++i) {
                Object[] oDevInfo = (Object[])oDevInfoLst.get(i);
                devOptResult.put((Integer)oDevInfo[1], -1);
            }
            this.oInternalmsg.data = devOptResult;
        }
    }

    public InternalLocalMsg getoInternalmsg() {
        return this.oInternalmsg;
    }

    class DeliverToBoardColumnHeader
    extends DCTableCheckBoxHeader {
        private static final long serialVersionUID = -3073227035946377713L;

        public DeliverToBoardColumnHeader(DCTable table, int iColumn) {
            super(table, iColumn, DCRecoverDlg.this.mAllTL1DevInRecoverDlg);
        }

        @Override
        public void tableDataChanged(TableModelEvent e) {
            int iColumn = e.getColumn();
            if (5 == iColumn) {
                this.updateSelectState((DCTableModel)e.getSource(), 6);
            } else {
                super.tableDataChanged(e);
            }
        }
    }

    class FileInfoColumnEditor
    extends DCTableComboBoxCellEditor {
        private static final long serialVersionUID = -3876837991038810379L;
        private JTextField mfileNameTxtField;
        private DefaultCellEditor mTextFieldEditor;
        boolean isTxtField;
        private Object oValue;

        public FileInfoColumnEditor(JComboBox comboBox) {
            super(comboBox);
            this.isTxtField = false;
            this.mfileNameTxtField = new JTextField();
            this.mTextFieldEditor = new DefaultCellEditor(this.mfileNameTxtField);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.isTxtField = false;
            this.oValue = value;
            if (DCRecoverDlg.this.mAgentDevInfoVec.contains(DCRecoverDlg.this.mArrDevInfo[row].getDevId())) {
                this.isTxtField = true;
                return this.mTextFieldEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            if (this.isTxtField) {
                if (this.oValue instanceof DCList) {
                    DCList oRecoverFile = (DCList)this.oValue;
                    String strFile = String.valueOf(this.mTextFieldEditor.getCellEditorValue());
                    int iDevId = ((RecoverFileInfo)oRecoverFile.getCurrSelectedObj()).getDevid();
                    RecoverFileInfo oRecoverFileInfo = new RecoverFileInfo();
                    oRecoverFileInfo.setDevid(iDevId);
                    oRecoverFileInfo.setFileName(strFile);
                    oRecoverFile.addData(oRecoverFileInfo);
                    oRecoverFile.setCurrSelectedIndex(0);
                    return oRecoverFileInfo;
                }
                return this.mTextFieldEditor.getCellEditorValue();
            }
            return this.delegate.getCellEditorValue();
        }

        @Override
        protected String getToolTipText(Object value) {
            if (null != value && value instanceof RecoverFileInfo) {
                RecoverFileInfo fileInfo = (RecoverFileInfo)value;
                String strTooltip = HTML_TAG + fileInfo.getFileName() + HTML_BREAK + fileInfo.getBackupVerInfo();
                return strTooltip;
            }
            return super.getToolTipText(value);
        }
    }

    class RebootColumnRenderer
    extends DCTableComboBoxCellRenderer {
        private static final long serialVersionUID = 5914331049924823391L;

        RebootColumnRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (null == value) {
                JLabel label = new JLabel();
                label.setOpaque(true);
                if (isSelected) {
                    label.setForeground(table.getSelectionForeground());
                    label.setBackground(table.getSelectionBackground());
                } else {
                    label.setForeground(table.getForeground());
                    label.setBackground(table.getBackground());
                }
                label.setText("--");
                return label;
            }
            this.removeAllItems();
            this.addItem(value);
            this.setToolTipText(this.getToolTipText(value));
            boolean bEditable = DCRecoverDlg.this.mRecoverTableModel.isCellEditable(row, column);
            if (!bEditable) {
                this.setBackground(DCConstants.COLOR_GRAY);
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            return this;
        }
    }

    class FileInfoColumnRenderer
    extends DCTableComboBoxCellRenderer {
        private static final long serialVersionUID = -5321011161500305835L;
        private JTextField mFileNameTxtField = new JTextField();

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (DCRecoverDlg.this.mAgentDevInfoVec.contains(DCRecoverDlg.this.mArrDevInfo[row].getDevId())) {
                if (value instanceof DCList) {
                    String strText = String.valueOf(((DCList)value).getCurrSelectedObj());
                    this.mFileNameTxtField.setText(strText);
                    this.mFileNameTxtField.setToolTipText(ResourceManager.getInstance().getResString("ROUTER_RECOVER_FILE_PATCH_TIP"));
                }
                return this.mFileNameTxtField;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        @Override
        protected String getToolTipText(Object value) {
            if (null != value && value instanceof DCList) {
                RecoverFileInfo fileInfo = (RecoverFileInfo)((DCList)value).getCurrSelectedObj();
                String strTooltip = HTML_TAG + fileInfo.getFileName() + HTML_BREAK + fileInfo.getBackupVerInfo();
                return strTooltip;
            }
            return "";
        }
    }
}

