/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.view;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnSAMFileInfo;
import com.huawei.dc.common.asndatacenter.AsnSAMGetVersionFileLstRsp;
import com.huawei.dc.common.components.dialog.IBrowseDlgInterafce;
import com.huawei.dc.common.components.dialog.fileselection.FileSelectionBrowseDlg;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCFileSystemUtil;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.MakeTypicalPacketUtil;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.view.FileSelectionDialog;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.sam.controller.SAMManager;
import com.huawei.dc.sam.model.SAMFileInfo;
import com.huawei.dc.taskmgmt.model.ITask;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class SelectSoftwareAndPacketToolPanel
extends JPanel
implements IBrowseDlgInterafce {
    private static final long serialVersionUID = 1L;
    private ITask m_oTask;
    private FileSelectionDialog m_oSelectSoftwareFilesDlg;
    private FileSelectionBrowseDlg m_oPktToolBrowseDlg;
    private JLabel m_oPacketToolLabel = new JLabel();
    private JTextField m_oPacketToolPath;
    private JButton m_oPacketToolButton = new JButton();
    private JButton m_oClearPacketToolButton = new JButton();
    private JLabel m_oSoftwareFilesLabel = new JLabel();
    private JLabel m_oMessageLabel = new JLabel();
    private JTextField m_oSoftwareFilesPath;
    private JButton m_oSoftwareFilesButton = new JButton();
    private ResourceManager m_oResourceManager = ResourceManager.getInstance();
    public static final int LOAD_SOFTWARE_PATCH_OPERATION = 3;
    protected LoadFileInfoListParam m_oCurrentLoadFiles;
    private String m_strCurrentVersionPath;
    private boolean m_bAnySupportedFileSelected;
    private String m_strDefaultPacketTool;

    public SelectSoftwareAndPacketToolPanel(ITask oTask, LoadFileInfoListParam oConfigPara, FileSelectionDialog oSelectSoftwareFilesDlg, String strCurrentVersionPath) {
        this.m_oTask = oTask;
        this.m_oCurrentLoadFiles = oConfigPara;
        this.m_oSelectSoftwareFilesDlg = oSelectSoftwareFilesDlg;
        if (null != strCurrentVersionPath) {
            this.m_strCurrentVersionPath = strCurrentVersionPath.replace('\\', '/');
        }
        this.m_oPktToolBrowseDlg = this.createFileBrowseDlg();
        this.setLayout(null);
        this.jInit();
    }

    private void jInit() {
        this.createComponents();
        this.addComponentsToPanel();
        this.initButtons();
        this.addListenerToFileSelectionDlg();
    }

    public void initPanelWithSelectedFiles() {
        this.updatePanelWithSelectedSWFiles();
        this.refreshPacketToolFields();
    }

    public void initPanelWithPacketTool(String strTargetVersion, boolean bSetDefaultToolToField) {
        this.setDefaultPacketTool(strTargetVersion, bSetDefaultToolToField);
        if (this.m_bAnySupportedFileSelected) {
            LoadFileInfo oFileInfo = this.m_oCurrentLoadFiles.getPacketTool();
            if (null != oFileInfo) {
                this.setPktToolToTextField(oFileInfo.getFileName());
            } else if (null != this.m_strDefaultPacketTool && !"".equals(this.m_strDefaultPacketTool)) {
                this.setPacketTool(this.m_strDefaultPacketTool);
            }
        }
    }

    private void addComponentsToPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBounds(20, 72, 355, 105);
        this.add(panel);
        this.add(this.m_oMessageLabel);
        panel.add(this.m_oSoftwareFilesLabel);
        panel.add(this.m_oSoftwareFilesPath);
        panel.add(this.m_oSoftwareFilesButton);
        panel.add(this.m_oPacketToolLabel);
        panel.add(this.m_oPacketToolPath);
        panel.add(this.m_oPacketToolButton);
        panel.add(this.m_oClearPacketToolButton);
    }

    private void createComponents() {
        String strMessage = StringUtils.getHtmlString(this.m_oResourceManager.getResString("MAKE_TYPICAL_PACKET_FILE_INFO"));
        this.m_oMessageLabel = new JLabel(strMessage);
        this.m_oMessageLabel.setBounds(20, 14, 335, 65);
        this.m_oSoftwareFilesLabel = new JLabel(this.m_oResourceManager.getResString("LOAD_SOFTWARE_FILES"));
        this.m_oSoftwareFilesLabel.setBounds(0, 20, 90, 20);
        this.m_oSoftwareFilesPath = new JTextField();
        this.m_oSoftwareFilesPath.setName("DeviceOperation_SelectSoftwareAndPacketTollPanel_m_oSoftwareFilesPath");
        this.m_oSoftwareFilesPath.setBounds(94, 20, 210, 20);
        this.m_oSoftwareFilesPath.setEditable(false);
        this.m_oSoftwareFilesButton = new JButton(this.m_oResourceManager.getResString("BROWSE_DIALOG"));
        this.m_oSoftwareFilesButton.setName("DeviceOperation_SelectSoftwareAndPacketTollPanel_m_oSoftwareFilesButton");
        this.m_oSoftwareFilesButton.setBounds(308, 20, 25, 20);
        this.m_oSoftwareFilesButton.setToolTipText(this.m_oResourceManager.getResString("SELECT_FILES_TOOLTIP"));
        this.m_oPacketToolLabel = new JLabel(this.m_oResourceManager.getResString("PACKET_TOOL_LABEL"));
        this.m_oPacketToolLabel.setBounds(0, 70, 90, 20);
        this.m_oPacketToolPath = new JTextField();
        this.m_oPacketToolPath.setName("DeviceOperation_SelectSoftwareAndPacketTollPanel_m_oPacketToolPath");
        this.m_oPacketToolPath.setBounds(94, 70, 210, 20);
        this.m_oPacketToolPath.setEditable(false);
        this.m_oPacketToolButton = new JButton(this.m_oResourceManager.getResString("BROWSE_DIALOG"));
        this.m_oPacketToolButton.setName("DeviceOperation_SelectSoftwareAndPacketTollPanel_m_oPacketToolButton");
        this.m_oPacketToolButton.setBounds(308, 70, 25, 20);
        this.m_oPacketToolButton.setToolTipText(this.m_oResourceManager.getResString("SELECT_FILES_TOOLTIP"));
        this.m_oClearPacketToolButton = new JButton();
        this.m_oClearPacketToolButton.setName("DeviceOperation_SelectSoftwareAndPacketTollPanel_m_oClearPacketToolButton");
        this.m_oClearPacketToolButton.setBounds(338, 70, 15, 20);
        this.m_oClearPacketToolButton.setToolTipText(this.m_oResourceManager.getResString("CLEAR_FILE_TOOLTIP"));
        ImageIcon oClearIcon = ResourceManager.getInstance().getImage("clear.gif");
        this.m_oClearPacketToolButton.setIcon(oClearIcon);
    }

    private void initButtons() {
        this.m_oPacketToolButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (null != SelectSoftwareAndPacketToolPanel.this.m_oPktToolBrowseDlg) {
                            SelectSoftwareAndPacketToolPanel.this.m_oPktToolBrowseDlg.setVisible(true);
                        }
                    }
                });
            }
        });
        this.m_oSoftwareFilesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (null != SelectSoftwareAndPacketToolPanel.this.m_oSelectSoftwareFilesDlg) {
                            SelectSoftwareAndPacketToolPanel.this.m_oSelectSoftwareFilesDlg.setVisible(true);
                        }
                    }
                });
            }
        });
        this.m_oClearPacketToolButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectSoftwareAndPacketToolPanel.this.m_oPacketToolPath.setText("");
                LoadFileInfo oPacketTool = SelectSoftwareAndPacketToolPanel.this.m_oCurrentLoadFiles.getPacketTool();
                SelectSoftwareAndPacketToolPanel.this.m_oCurrentLoadFiles.removeFileFromList(oPacketTool);
            }
        });
    }

    private FileSelectionBrowseDlg createFileBrowseDlg() {
        FileSelectionBrowseDlg oFilePathBrowseDlg = null;
        try {
            oFilePathBrowseDlg = new FileSelectionBrowseDlg(false, false, false, "LoadSoftware");
            oFilePathBrowseDlg.registBrowseDlgInterface(this);
            oFilePathBrowseDlg.setName("DeviceOperation_SelectSoftwareAndPacketTollPanel_oFilePathBrowseDlg");
            oFilePathBrowseDlg.setTitle(ResourceManager.getInstance().getResString("SELECT_PACKET_TOOL_TITLE"));
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
        }
        return oFilePathBrowseDlg;
    }

    private void setDefaultPacketTool(String strTargetVersion, boolean bSetDefaultToolToField) {
        LoadFileInfo oPacketTool = this.m_oCurrentLoadFiles.getPacketTool();
        if (null != oPacketTool && null != oPacketTool.getFileName()) {
            String strFilePath;
            this.m_strDefaultPacketTool = strFilePath = DCFileSystemUtil.getAbsolutePath(oPacketTool.getFileName());
            this.m_oPktToolBrowseDlg.setDefaultPath(DCFileSystemUtil.getParentDirectory(strFilePath));
            return;
        }
        LoadFileInfo oDefaultPacketTool = this.getPacketToolForTypeAndVersion(this.m_oTask.getDeviceType(), strTargetVersion);
        if (null == oDefaultPacketTool) {
            this.m_oPktToolBrowseDlg.setDefaultPath(this.m_strCurrentVersionPath);
        } else {
            String strFilePath = this.m_strCurrentVersionPath + '/' + oDefaultPacketTool.getAbsoluteFilePath();
            this.m_oPktToolBrowseDlg.setDefaultPath(DCFileSystemUtil.getParentDirectory(strFilePath));
            this.m_strDefaultPacketTool = bSetDefaultToolToField ? strFilePath : "";
        }
    }

    private LoadFileInfo getPacketToolForTypeAndVersion(DeviceType oDeviceType, String strVersion) {
        DeviceTypeInfo oDeviceTypeInfo = DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfo(oDeviceType.getDeviceTypeID(), oDeviceType.getDeviceTypeVersionID());
        SAMFileInfo oSAMFileInfo = new SAMFileInfo();
        oSAMFileInfo.setDeviceTypeInfo(oDeviceTypeInfo);
        oSAMFileInfo.setVersion(strVersion);
        oSAMFileInfo.setFileType(DCConstants.PACKET_TOOL_CONTENT_TYPE);
        AsnSAMGetVersionFileLstRsp oAsnSAMGetVersionFileLstRsp = SAMManager.getInstance().getAsnSAMDeviceVersionFileReq(oSAMFileInfo);
        int iFileCount = oAsnSAMGetVersionFileLstRsp.oAsnSAMFileInfoLst.size();
        if (1 != iFileCount) {
            return null;
        }
        LoadFileInfo oPacketTool = new LoadFileInfo();
        oPacketTool.setContentType(DCConstants.PACKET_TOOL_CONTENT_TYPE);
        AsnSAMFileInfo oSAMFileInfoFromServer = (AsnSAMFileInfo)oAsnSAMGetVersionFileLstRsp.oAsnSAMFileInfoLst.get(0);
        oPacketTool.setFileName(new String(oSAMFileInfoFromServer.strFileName));
        return oPacketTool;
    }

    private void addListenerToFileSelectionDlg() {
        final LoadFileInfoListParam oFileDlgConfigPara = this.m_oSelectSoftwareFilesDlg.getConfigPara();
        this.m_oSelectSoftwareFilesDlg.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                if (null != oFileDlgConfigPara) {
                    SelectSoftwareAndPacketToolPanel.this.updatePanelWithSelectedSWFiles();
                    if (!SelectSoftwareAndPacketToolPanel.this.m_bAnySupportedFileSelected) {
                        SelectSoftwareAndPacketToolPanel.this.setPacketTool("");
                    }
                }
            }
        });
    }

    private void refreshPacketToolFields() {
        if (this.m_bAnySupportedFileSelected || 0 == this.m_oCurrentLoadFiles.getNumberOfFiles()) {
            this.m_oPacketToolLabel.setForeground(Color.black);
            this.m_oPacketToolPath.setText(DCFileSystemUtil.getPathRelativeToRoot(this.m_strDefaultPacketTool));
            this.m_oPacketToolButton.setEnabled(true);
            this.m_oPacketToolPath.setEnabled(true);
            this.m_oClearPacketToolButton.setEnabled(true);
        } else {
            this.m_oPacketToolLabel.setForeground(Color.gray);
            this.m_oPacketToolPath.setText("");
            this.m_oPacketToolButton.setEnabled(false);
            this.m_oPacketToolPath.setEnabled(false);
            this.m_oClearPacketToolButton.setEnabled(false);
        }
    }

    public boolean validateInput() {
        String strSoftwareFiles = this.m_oSoftwareFilesPath.getText();
        if (null == strSoftwareFiles || 0 == strSoftwareFiles.trim().length()) {
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("NO_LOAD_SW_FILE_SELECTED"));
            return false;
        }
        if (!this.m_bAnySupportedFileSelected) {
            return true;
        }
        String strPacketTool = this.m_oPacketToolPath.getText();
        if (null == strPacketTool || 0 == strPacketTool.trim().length()) {
            int iOption = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("NO_PACKET_TOOL_SELECTED_WARNING"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
            return 0 == iOption;
        }
        return true;
    }

    private void setPacketTool(String strPath) {
        if (null == strPath || "".equals(strPath)) {
            this.setPktToolToTextField("");
            LoadFileInfo oPacketTool = this.m_oCurrentLoadFiles.getPacketTool();
            this.m_oCurrentLoadFiles.removeFileFromList(oPacketTool);
        } else {
            this.m_strDefaultPacketTool = strPath;
            strPath = DCFileSystemUtil.getPathRelativeToRoot(strPath);
            LoadFileInfo oPacketTool = new LoadFileInfo();
            oPacketTool.setFileName(strPath);
            oPacketTool.setContentType(DCConstants.PACKET_TOOL_CONTENT_TYPE);
            this.m_oCurrentLoadFiles.addPacketTool(oPacketTool);
            this.setPktToolToTextField(strPath);
        }
    }

    private void setPktToolToTextField(String strPath) {
        this.m_oPacketToolPath.setText(strPath);
        this.m_oPacketToolPath.setToolTipText(strPath);
    }

    public String getTextFieldPath() {
        return this.m_oPacketToolPath.getText();
    }

    @Override
    public void setFileOrDirectory(String strFilePath, String strVersion, boolean file) {
        this.setPacketTool(strFilePath);
    }

    private void updatePanelWithSelectedSWFiles() {
        LoadFileInfo[] arrSelectedFiles = this.getSelectedSoftwareFiles();
        LoadFileInfo oFileInfo = null;
        StringBuffer strFileNames = new StringBuffer(0);
        String strSeparator = " ,";
        this.m_bAnySupportedFileSelected = false;
        for (int i = 0; i < arrSelectedFiles.length; ++i) {
            oFileInfo = arrSelectedFiles[i];
            if (null != oFileInfo && !DCConstants.PACKET_TOOL_CONTENT_TYPE.equals(oFileInfo.getContentType())) {
                if (0 < strFileNames.length()) {
                    strFileNames.append(" ,");
                }
                strFileNames.append(oFileInfo.getFileName());
            }
            if (null == oFileInfo || this.m_bAnySupportedFileSelected || !MakeTypicalPacketUtil.isOperationSupportedForFile(this.m_oTask, oFileInfo.getContentType())) continue;
            this.m_bAnySupportedFileSelected = true;
        }
        if (0 < strFileNames.length()) {
            this.m_oSoftwareFilesPath.setText(strFileNames.toString());
        }
    }

    private LoadFileInfo[] getSelectedSoftwareFiles() {
        LoadFileInfo[] arrSelectedFiles = this.m_oSelectSoftwareFilesDlg.getSelectedFiles();
        if (0 < arrSelectedFiles.length) {
            LoadFileInfo oPacketTool = this.m_oCurrentLoadFiles.getPacketTool();
            this.m_oCurrentLoadFiles.clearAllFilesFromList();
            this.m_oCurrentLoadFiles.addServerFiles(arrSelectedFiles);
            this.m_oCurrentLoadFiles.addPacketTool(oPacketTool);
            return arrSelectedFiles;
        }
        List<LoadFileInfo> oLoadFileList = this.m_oCurrentLoadFiles.getLoadFileInfoList();
        if (null == oLoadFileList || 0 >= oLoadFileList.size()) {
            return new LoadFileInfo[0];
        }
        return oLoadFileList.toArray(new LoadFileInfo[0]);
    }

    public void setConfigPara(LoadFileInfoListParam oLoadFileParam) {
        this.m_oCurrentLoadFiles = oLoadFileParam;
        this.m_oSelectSoftwareFilesDlg.setConfigPara(oLoadFileParam);
    }
}

