/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.ASNDCFileInfoStruct;
import com.huawei.dc.common.asndatacenter.AsnDCGetDirReq;
import com.huawei.dc.common.asndatacenter.AsnDCGetDirRsp;
import com.huawei.dc.common.asndatacenter.AsnDCTargetFileServerTypeEnum;
import com.huawei.dc.common.asndatacenter.AsnSAMFileInfo;
import com.huawei.dc.common.asndatacenter.AsnSAMGetVersionFileLstRsp;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.view.FileTablePanel;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.deviceoperation.util.DirAndFileInfo;
import com.huawei.dc.deviceoperation.util.FileNode;
import com.huawei.dc.deviceoperation.util.FileNodeComparator;
import com.huawei.dc.framework.ObjectStore;
import com.huawei.dc.sam.SAMUtil;
import com.huawei.dc.sam.controller.ISAMManager;
import com.huawei.dc.sam.controller.SAMManager;
import com.huawei.dc.sam.model.SAMFileInfo;
import com.huawei.dc.taskmgmt.controller.TaskSrcDstVersionCheck;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.util.SyncCommand;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.math.BigInteger;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import net.commustru.fstru.FStruct;

public class FileTreePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String strFileFilter = "DCInfo_";
    private boolean isEmptyLoadDir = false;
    private boolean m_bIsClientEmptyDir = false;
    private JScrollPane scrollPane;
    private JTree fileTree = new JTree();
    private DefaultTreeModel treeModel;
    private FileNode oRoot;
    private String strCurrentPath = "";
    private FileTablePanel fileTablePanel;
    public boolean m_bIsClient = false;
    public boolean m_bMessaseAlreadyShown = false;
    public boolean m_bSpaceMessaseAlreadyShown = false;
    public LoadFileInfoListParam m_oLoadFileInfoLstPara = null;
    private FileNodeComparator fileNodeComparator;
    private boolean bIsDMSDevice = false;
    private List<DeviceTypeInfo> m_oSlaveDeviceTypeInfoList;
    private boolean m_bSelectThirdPartyFTP = false;

    public FileTreePanel(LoadFileInfoListParam oLoadFileInfoLstParam, boolean isSelcetThirdPartyFTP) throws DCException {
        ObjectStore.getInstance().putObjectInstance("FileTreePanel", this);
        this.setLayout(new BorderLayout());
        this.m_oLoadFileInfoLstPara = oLoadFileInfoLstParam;
        this.fileNodeComparator = new FileNodeComparator(true);
        this.m_bSelectThirdPartyFTP = isSelcetThirdPartyFTP;
        this.jbInit();
    }

    private void jbInit() throws DCException {
        this.scrollPane = new JScrollPane();
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.strCurrentPath = FileUtil.getRootDir(this.m_bSelectThirdPartyFTP);
        this.oRoot = new FileNode(new DirAndFileInfo(this.strCurrentPath, this.strCurrentPath, false));
    }

    public void initializeTree(boolean IsClient) throws DCException {
        this.m_bIsClient = IsClient;
        if (!IsClient) {
            int iGetResult = this.getDirectoryFromServer(this.strCurrentPath, this.oRoot);
            if (0 != iGetResult) {
                DCOptionPane.showMessageDialog(null, BigInteger.valueOf(iGetResult), ResourceManager.getInstance().getResString("ERROR"), 0);
            }
            if (this.isEmptyLoadDir) {
                DCOptionPane.showMessageDialog(null, ResourceManager.getInstance().getResString("PROGRAM_SELECTION_NO_PROGRAM_EXIST"), ResourceManager.getInstance().getResString("ERROR"), 0);
            }
        } else {
            this.oRoot = new FileNode(new DirAndFileInfo(this.strCurrentPath, this.strCurrentPath, false));
            this.getDirectoryFrmClient(this.strCurrentPath, this.oRoot);
            if (this.m_bIsClientEmptyDir) {
                throw new DCException(ResourceManager.getInstance().getResString("PROGRAM_SELECTION_NO_PROGRAM_EXIST"));
            }
        }
        this.fileTree = this.createFileTree(this.oRoot);
        this.fileTree.setBackground(new Color(255, 255, 255));
        this.fileTree.updateUI();
        this.scrollPane.updateUI();
        this.scrollPane.getViewport().add(this.fileTree);
        this.add((Component)this.scrollPane, "Center");
    }

    public void setTreePath(String strPath, DeviceType oDeviceType, String strVersion, boolean bisPatchTask, boolean bSelUpPatch) {
        FileNode oNode = this.oRoot;
        DirAndFileInfo oNodeInfo = null;
        StringTokenizer oToken = null;
        if (strPath.length() >= this.oRoot.toString().length()) {
            oToken = new StringTokenizer(strPath.substring(this.oRoot.toString().length()), File.separator);
        }
        while (null != oToken && oToken.hasMoreTokens()) {
            String strToken = oToken.nextToken();
            DCDebugTracer.trace("FileTreePanel:setTreePath#strToken->" + strToken);
            if (null == (oNode = (FileNode)this.getNode(oNode, strToken))) continue;
            DCDebugTracer.trace("FileTreePanel:setTreePath#oNode->" + oNode.toString());
            oNodeInfo = (DirAndFileInfo)oNode.getUserObject();
            if (null == oNodeInfo) continue;
            this.getFiles(oNodeInfo.getPath(), oNode);
        }
        if (null == oNode || 0 == oNode.getPath().length) {
            DCDebugTracer.trace("FileTreePanel:setTreePath#oNode is NULL");
            return;
        }
        TreePath oTreePath = new TreePath(oNode.getPath());
        this.fileTree.setSelectionPath(oTreePath);
        DCDebugTracer.trace("FileTreePanel:setTreePath#oTreePath->" + oTreePath.toString());
        DCDebugTracer.trace("FileTreePanel:setTreePath#strVersion->" + strVersion);
        if (!strVersion.equals("")) {
            this.addSelectedVersionFiles(oDeviceType, strVersion, bisPatchTask, bSelUpPatch);
        }
        this.fileTree.expandPath(oTreePath);
        this.scrollPane.validate();
        DCFrameWorkUtil.updateUI(this.scrollPane.getVerticalScrollBar());
        DCFrameWorkUtil.updateUI(this.scrollPane);
    }

    private void addSelectedVersionFiles(DeviceType oDeviceType, String strVersion, boolean bisPatchTask, boolean bSelUpPatch) {
        List<Object> oDevTypeList = new ArrayList<DeviceTypeInfo>(0);
        if (null == this.m_oSlaveDeviceTypeInfoList || 0 == this.m_oSlaveDeviceTypeInfoList.size()) {
            oDevTypeList.add(DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfo(oDeviceType.getDeviceTypeID(), oDeviceType.getDeviceTypeVersionID()));
        } else {
            oDevTypeList = this.m_oSlaveDeviceTypeInfoList;
        }
        try {
            ISAMManager oSAMManager = SAMManager.getInstance();
            int iSize = oDevTypeList.size();
            for (int i = 0; i < iSize; ++i) {
                DeviceTypeInfo oDeviceTypeInfo = (DeviceTypeInfo)oDevTypeList.get(i);
                SAMFileInfo oSAMFileInfo = new SAMFileInfo();
                oSAMFileInfo.setDeviceTypeInfo(oDeviceTypeInfo);
                if (bisPatchTask) {
                    if (oDeviceTypeInfo.isBMSDomain()) {
                        oSAMFileInfo.setVersion(strVersion);
                        oSAMFileInfo.setPatchVer("");
                    } else {
                        String[] versionInfo = DCCommonUtil.breakPatchTargetVersion(strVersion);
                        if (null == versionInfo) {
                            oSAMFileInfo.setVersion("");
                        } else {
                            oSAMFileInfo.setVersion(versionInfo[0]);
                            if (versionInfo.length > 1) {
                                oSAMFileInfo.setPatchVer(versionInfo[1]);
                            } else {
                                oSAMFileInfo.setPatchVer("");
                            }
                        }
                    }
                } else {
                    oSAMFileInfo.setVersion(strVersion);
                    oSAMFileInfo.setPatchVer("");
                }
                AsnSAMGetVersionFileLstRsp oAsnSAMGetVersionFileLstRsp = oSAMManager.getAsnSAMDeviceVersionFileReq(oSAMFileInfo);
                int iNoOfFile = oAsnSAMGetVersionFileLstRsp.oAsnSAMFileInfoLst.size();
                DCDebugTracer.trace("SAMGetVersionFileLstRsp:size->" + iNoOfFile);
                if (0 == iNoOfFile) continue;
                LoadFileInfo[] oArrLoadFileInfo = new LoadFileInfo[iNoOfFile];
                String strFilePath = "";
                TreePath oTreePath = null;
                FileNode oFileNode = null;
                int[] iDeviceIdLst = oDeviceType.getDeviceIdlst(oDeviceType);
                List oLoadSoftwareContentTypeLst = DeviceXMLConfigModel.getInstance().getContentTypesFromXMLConfig(oDeviceType, 6, iDeviceIdLst);
                List oLoadPatchContentTypeLst = DeviceXMLConfigModel.getInstance().getContentTypesFromXMLConfig(oDeviceType, 9, iDeviceIdLst);
                for (int index = 0; index < iNoOfFile; ++index) {
                    AsnSAMFileInfo oSAMFileInfoFromServer = (AsnSAMFileInfo)oAsnSAMGetVersionFileLstRsp.oAsnSAMFileInfoLst.get(index);
                    ContentType oContentType = SAMUtil.getInstance().getContentType(oDeviceTypeInfo, oSAMFileInfoFromServer.iFileType.intValue(), bisPatchTask, iDeviceIdLst);
                    if (null == oContentType) {
                        DCDebugTracer.trace("SAMGetVersionFileLstRsp:oContentType is NULL->" + index);
                        continue;
                    }
                    if (!bisPatchTask && !oLoadSoftwareContentTypeLst.contains(oContentType)) {
                        DCDebugTracer.trace("SAMGetVersionFileLstRsp:oLoadSoftwareContentTypeLst  is not contain oContentType and is not PatchTask->" + index);
                        continue;
                    }
                    if (bisPatchTask && !oLoadPatchContentTypeLst.contains(oContentType)) {
                        DCDebugTracer.trace("SAMGetVersionFileLstRsp:oLoadPatchContentTypeLst  is not contain oContentType and is PatchTask->" + index);
                        continue;
                    }
                    if (!bisPatchTask && !bSelUpPatch && null != oLoadPatchContentTypeLst && oLoadPatchContentTypeLst.contains(oContentType)) {
                        DCDebugTracer.trace("SAMGetVersionFileLstRsp:oLoadPatchContentTypeLst  is not contain oContentType and is not PatchTask and is not bSelUpPatch->" + index);
                        continue;
                    }
                    if (!bisPatchTask && (DeviceInfoUtil.isStackDevicePresent(oDeviceType.getResources(), 3) || oDeviceType.isUpgradeModeSupportedByAllDevices(1) && DeviceInfoUtil.isAllClusterChildDevice(oDeviceType.getResources())) && "PATCH".equalsIgnoreCase(oContentType.getId())) {
                        DCDebugTracer.trace("SAMGetVersionFileLstRsp:oLoadPatchContentTypeLst is Patch" + index);
                        continue;
                    }
                    oArrLoadFileInfo[index] = new LoadFileInfo();
                    oArrLoadFileInfo[index].setContentType(oContentType);
                    oArrLoadFileInfo[index].setDeviceTypeInfo(oDeviceTypeInfo);
                    oTreePath = this.fileTree.getSelectionPath();
                    oFileNode = (FileNode)oTreePath.getLastPathComponent();
                    Object oUserObject = oFileNode.getUserObject();
                    if (oUserObject instanceof DirAndFileInfo) {
                        DirAndFileInfo oDirAndFileInfo = (DirAndFileInfo)oUserObject;
                        strFilePath = oDirAndFileInfo.getPath();
                        strFilePath = strFilePath + "/" + new String(oSAMFileInfoFromServer.strFileName);
                        DCDebugTracer.trace("SAMGetVersionFileLstRsp:fileLst->" + strFilePath);
                    }
                    oArrLoadFileInfo[index].setFileName(strFilePath);
                    oArrLoadFileInfo[index].setSequenceNo(index + 1);
                }
                this.fileTablePanel.addSelectedFiles(oArrLoadFileInfo, FileUtil.getRootDir(this.m_bSelectThirdPartyFTP));
            }
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
        }
    }

    private void getFiles(String strPath, FileNode oFileNode) {
        if (!this.m_bIsClient) {
            this.getDirectoryFromServer(strPath, oFileNode);
        } else {
            this.getDirectoryFrmClient(strPath, oFileNode);
        }
    }

    private DefaultMutableTreeNode getNode(DefaultMutableTreeNode oNode, String strNode) {
        if (null == oNode) {
            return null;
        }
        boolean bWinOS = true;
        if (oNode.toString().startsWith("/")) {
            bWinOS = false;
        }
        DefaultMutableTreeNode oChildNode = null;
        int iNodeCount = oNode.getChildCount();
        Collator oEquals = Collator.getInstance();
        String strChildNode = null;
        for (int index = 0; index < iNodeCount; ++index) {
            oChildNode = (DefaultMutableTreeNode)oNode.getChildAt(index);
            strChildNode = oChildNode.toString();
            if (bWinOS) {
                strChildNode = oChildNode.toString().toLowerCase();
            }
            if (oEquals.equals(strChildNode, strNode)) break;
        }
        return oChildNode;
    }

    public int getDirectoryFromServer(String strPath, FileNode treeNode) {
        int i;
        int returnCode;
        String path = "";
        if (strPath.equals(this.strCurrentPath)) {
            path = "";
        } else {
            path = strPath + "/";
            strPath = this.m_bSelectThirdPartyFTP && StringUtils.isIPV4(this.strCurrentPath) ? "/" + strPath : this.strCurrentPath + "/" + strPath;
        }
        final BaseCommManager commManager = DCFrameWorkUtil.getCommManager();
        final AsnDCGetDirReq dirGetReq = new AsnDCGetDirReq();
        dirGetReq.strRootPath = this.m_bSelectThirdPartyFTP && StringUtils.isIPV4(strPath) ? "/".getBytes() : strPath.getBytes();
        dirGetReq.oDeviceOperationType.value = 8;
        if (this.m_bSelectThirdPartyFTP) {
            dirGetReq.oTargetFileServerType = new AsnDCTargetFileServerTypeEnum(1);
            if (null != TaskSrcDstVersionCheck.getInstance().getThirdFTPServerName()) {
                dirGetReq.strTargetFileServerName = TaskSrcDstVersionCheck.getInstance().getThirdFTPServerName().getBytes();
            }
        }
        final AsnDCGetDirRsp dirRsp = new AsnDCGetDirRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                int errorcode = commManager.sendSyncMsg(BaseCommManager.getMSGHead(43842), (FStruct)dirGetReq, (FStruct)dirRsp);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (syncCommand.getResult() != null && (returnCode = ((Integer)syncCommand.getResult()).intValue()) != 0) {
            return returnCode;
        }
        if (dirRsp.oErrorInfo.iErrorNo.intValue() != 0) {
            return dirRsp.oErrorInfo.iErrorNo.intValue();
        }
        boolean isCreateNode = false;
        if (treeNode != null) {
            treeNode.removeAllChildren();
            isCreateNode = true;
        }
        if (0 < dirRsp.oDirectories.size()) {
            for (i = 0; i < dirRsp.oDirectories.size(); ++i) {
                String strName = new String((byte[])dirRsp.oDirectories.elementAt(i));
                String filePath = path + strName;
                if (isCreateNode) {
                    DirAndFileInfo dir = new DirAndFileInfo(filePath, strName, false);
                    FileNode node = new FileNode(dir, true);
                    if (null == treeNode || !treeNode.getAllowsChildren()) continue;
                    treeNode.add(node);
                    continue;
                }
                this.getDirectoryFromServer(filePath, null);
            }
        }
        if (0 < dirRsp.oFiles.size()) {
            for (i = 0; i < dirRsp.oFiles.size(); ++i) {
                ASNDCFileInfoStruct oFileInfoStruct = (ASNDCFileInfoStruct)dirRsp.oFiles.elementAt(i);
                String strName = new String(oFileInfoStruct.strFilename);
                if (strName.toLowerCase(ResourceMng.getInstance().getLocale()).startsWith(strFileFilter.toLowerCase(ResourceMng.getInstance().getLocale()))) continue;
                String filePath = path + strName;
                if (isCreateNode) {
                    DirAndFileInfo dir = new DirAndFileInfo(filePath, strName, true);
                    FileNode node = new FileNode(dir, false);
                    if (null == treeNode || !treeNode.getAllowsChildren()) continue;
                    treeNode.add(node);
                    continue;
                }
                if (this.fileTablePanel.isFileAlreadyAdded(filePath)) {
                    if (this.m_bMessaseAlreadyShown) continue;
                    DCOptionPane.showMessageDialog((Component)this.getParent(), ResourceManager.getInstance().getResString("FILE_ALREADY_SELECTED"), ResourceManager.getInstance().getResString("INFORMATION"), 1);
                    this.m_bMessaseAlreadyShown = true;
                    continue;
                }
                LoadFileInfo[] serverFile = new LoadFileInfo[]{new LoadFileInfo()};
                serverFile[0].setFileName(filePath);
                try {
                    this.fileTablePanel.addSelectedFiles(serverFile, FileUtil.getRootDir(this.m_bSelectThirdPartyFTP));
                    continue;
                }
                catch (DCException ex) {
                    return 0;
                }
            }
        }
        if (isCreateNode) {
            if (0 >= dirRsp.oDirectories.size() + dirRsp.oFiles.size()) {
                this.isEmptyLoadDir = true;
            } else {
                this.isEmptyLoadDir = false;
                treeNode.sort(this.fileNodeComparator, false);
            }
        }
        return 0;
    }

    public boolean getDirectoryFrmClient(String strSelectedPath, FileNode treeNode) {
        int iNosDirectories;
        this.m_bSpaceMessaseAlreadyShown = false;
        String path = "";
        boolean bRootDir = false;
        String strRootDir = null;
        if (Collator.getInstance().equals(strSelectedPath, this.strCurrentPath)) {
            path = "";
            String strOSName = System.getProperty("os.name");
            if (null != strOSName && strOSName.startsWith("Win")) {
                File[] oSystemDrives = File.listRoots();
                int iNosDrives = oSystemDrives.length;
                for (int i = 0; i < iNosDrives; ++i) {
                    if (!oSystemDrives[i].toString().startsWith(strSelectedPath)) continue;
                    bRootDir = true;
                    strRootDir = oSystemDrives[i].toString().replace('\\', '/');
                }
            }
        } else {
            path = strSelectedPath + "/";
            strSelectedPath = this.strCurrentPath + "/" + strSelectedPath;
        }
        ArrayList<String> oDirectories = new ArrayList<String>();
        ArrayList<String> oFiles = new ArrayList<String>();
        File oAllFiles = null;
        oAllFiles = bRootDir ? new File(strRootDir) : new File(strSelectedPath);
        if (null != oAllFiles.list()) {
            String[] strSelecDirFiles = oAllFiles.list();
            for (int i = 0; i < strSelecDirFiles.length; ++i) {
                String checkPath = strSelectedPath + "/" + strSelecDirFiles[i];
                File oDirTest = new File(checkPath);
                if (oDirTest.isDirectory()) {
                    oDirectories.add(strSelecDirFiles[i]);
                    continue;
                }
                oFiles.add(strSelecDirFiles[i]);
            }
        }
        boolean isCreateNode = false;
        if (treeNode != null) {
            treeNode.removeAllChildren();
            isCreateNode = true;
        }
        if (0 < (iNosDirectories = oDirectories.size())) {
            for (int i = 0; i < iNosDirectories; ++i) {
                String strName = oDirectories.get(i).toString();
                String filePath = path + strName;
                if (isCreateNode) {
                    DirAndFileInfo dir = new DirAndFileInfo(filePath, strName, false);
                    FileNode node = new FileNode(dir, true);
                    if (null == treeNode) continue;
                    treeNode.add(node);
                    continue;
                }
                this.getDirectoryFrmClient(filePath, null);
            }
        }
        int iNosofFiles = oFiles.size();
        if (0 < oFiles.size()) {
            for (int i = 0; i < iNosofFiles; ++i) {
                String strName = oFiles.get(i).toString();
                String filePath = path + strName;
                if (isCreateNode) {
                    DirAndFileInfo dir = new DirAndFileInfo(filePath, strName, true);
                    FileNode node = new FileNode(dir, false);
                    if (null == treeNode) continue;
                    treeNode.add(node);
                    continue;
                }
                if (this.fileTablePanel.isFileAlreadyAdded(filePath)) {
                    if (this.m_bMessaseAlreadyShown) continue;
                    DCOptionPane.showMessageDialog((Component)this.getParent(), ResourceManager.getInstance().getResString("FILE_ALREADY_SELECTED"), ResourceManager.getInstance().getResString("INFORMATION"), 1);
                    this.m_bMessaseAlreadyShown = true;
                    continue;
                }
                if (filePath.contains(" ")) {
                    if (this.m_bSpaceMessaseAlreadyShown || !this.bIsDMSDevice) continue;
                    DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("BROWSEDLG_SELECT_FILE_BLANK_SPACE"), ResourceManager.getInstance().getResString("ERROR"), 0);
                    this.m_bSpaceMessaseAlreadyShown = true;
                    continue;
                }
                LoadFileInfo[] serverFile = new LoadFileInfo[]{new LoadFileInfo()};
                serverFile[0].setFileName(filePath);
                try {
                    this.fileTablePanel.addSelectedFiles(serverFile, FileUtil.getRootDir(this.m_bSelectThirdPartyFTP));
                    continue;
                }
                catch (DCException ex) {
                    return false;
                }
            }
        }
        if (isCreateNode) {
            if (0 >= iNosDirectories + iNosofFiles) {
                this.m_bIsClientEmptyDir = true;
            } else {
                this.m_bIsClientEmptyDir = false;
                if (null != treeNode) {
                    treeNode.sort(this.fileNodeComparator, false);
                }
            }
        }
        return true;
    }

    public boolean getSelectedFile() {
        this.m_bSpaceMessaseAlreadyShown = false;
        TreePath[] treePath = this.fileTree.getSelectionPaths();
        if (treePath == null) {
            return false;
        }
        for (int i = 0; i < treePath.length; ++i) {
            FileNode treeNode = (FileNode)treePath[i].getLastPathComponent();
            Object obj = treeNode.getUserObject();
            if (!(obj instanceof DirAndFileInfo)) continue;
            DirAndFileInfo dirNode = (DirAndFileInfo)obj;
            if (dirNode.isFile()) {
                if (this.fileTablePanel.isFileAlreadyAdded(dirNode.getPath())) {
                    if (this.m_bMessaseAlreadyShown) continue;
                    DCOptionPane.showMessageDialog((Component)this.getParent(), ResourceManager.getInstance().getResString("FILE_ALREADY_SELECTED"), ResourceManager.getInstance().getResString("INFORMATION"), 1);
                    this.m_bMessaseAlreadyShown = true;
                    continue;
                }
                if (dirNode.getPath().contains(" ") && this.bIsDMSDevice) {
                    if (this.m_bSpaceMessaseAlreadyShown) continue;
                    DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("BROWSEDLG_SELECT_FILE_BLANK_SPACE"), ResourceManager.getInstance().getResString("ERROR"), 0);
                    this.m_bSpaceMessaseAlreadyShown = true;
                    continue;
                }
                LoadFileInfo[] serverFile = new LoadFileInfo[]{new LoadFileInfo()};
                serverFile[0].setFileName(dirNode.getPath());
                try {
                    this.fileTablePanel.addSelectedFiles(serverFile, FileUtil.getRootDir(this.m_bSelectThirdPartyFTP));
                    continue;
                }
                catch (DCException ex) {
                    if (!this.m_bMessaseAlreadyShown) {
                        DCOptionPane.showMessageDialog((Component)this.getParent(), ResourceManager.getInstance().getResString(ex.getMessage()), ResourceManager.getInstance().getResString("ERROR"), 0);
                        DCDebugTracer.trace("DC::FileTreePanel::getSelectedFile()::throw exception::" + ex.getMessage());
                        this.m_bMessaseAlreadyShown = true;
                    }
                    return true;
                }
            }
            int iBeforeRowCount = this.fileTablePanel.getRowCount();
            if (!this.m_bIsClient) {
                this.getDirectoryFromServer(dirNode.getPath(), null);
            } else {
                this.getDirectoryFrmClient(dirNode.getPath(), null);
            }
            int iAfterRowCount = this.fileTablePanel.getRowCount();
            if (iBeforeRowCount != iAfterRowCount || this.m_bMessaseAlreadyShown) continue;
            DCOptionPane.showMessageDialog((Component)this.getParent(), ResourceManager.getInstance().getResString("FILE_TREE_PANEL_NO_FILE"), ResourceManager.getInstance().getResString("ERROR"), 0);
            this.m_bMessaseAlreadyShown = true;
        }
        this.fileTree.clearSelection();
        return true;
    }

    private JTree createFileTree(FileNode oRoot) {
        this.treeModel = new DefaultTreeModel(oRoot, true);
        this.fileTree = new JTree(this.treeModel);
        this.fileTree.setName("DeviceOperation_FileTreePanel_fileTree");
        this.fileTree.setToggleClickCount(0);
        this.fileTree.setCellRenderer(new FileTreeCellRenderer());
        this.fileTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                FileTreePanel.this.fileTree_MouseClicked(me);
            }
        });
        return this.fileTree;
    }

    public void updateTree() {
        this.fileTree.treeDidChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileToTable() {
        this.m_bMessaseAlreadyShown = false;
        try {
            DCFrameWorkUtil.setCursor(new Cursor(3));
            if (!this.getSelectedFile()) {
                DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("LOAD_FILE_NULL"), ResourceManager.getInstance().getResString("ERROR"), 0);
            }
        }
        finally {
            DCFrameWorkUtil.setCursor(new Cursor(0));
        }
    }

    public boolean updateTree(boolean bIsClient, int iOperationType) throws DCException {
        this.m_bIsClientEmptyDir = false;
        this.m_bIsClient = bIsClient;
        if (!bIsClient) {
            this.strCurrentPath = FileUtil.getRootDir(this.m_bSelectThirdPartyFTP);
            this.oRoot = new FileNode(new DirAndFileInfo(this.strCurrentPath, this.strCurrentPath, false));
            this.getDirectoryFromServer(this.strCurrentPath, this.oRoot);
            if (this.isEmptyLoadDir) {
                String strErrorMsg = null;
                if (3 == iOperationType) {
                    strErrorMsg = ResourceManager.getInstance().getResString("PROGRAM_SELECTION_NO_SERVER_PROGRAM_EXIST");
                }
                if (4 == iOperationType) {
                    strErrorMsg = ResourceManager.getInstance().getResString("PROGRAM_SELECTION_NO_SERVER_PATCH_EXIST");
                }
                throw new DCException(strErrorMsg);
            }
        } else {
            this.oRoot = new FileNode(new DirAndFileInfo(this.strCurrentPath, this.strCurrentPath, false));
            this.getDirectoryFrmClient(this.strCurrentPath, this.oRoot);
            if (this.isEmptyLoadDir) {
                String strErrorMsg = null;
                if (3 == iOperationType) {
                    throw new DCException(ResourceManager.getInstance().getResString("PROGRAM_SELECTION_NO_PROGRAM_EXIST"));
                }
                if (4 == iOperationType) {
                    throw new DCException(ResourceManager.getInstance().getResString("NO_PATCH_EXIST"));
                }
                throw new DCException(strErrorMsg);
            }
            String strErrorMsg = null;
            if (3 == iOperationType) {
                strErrorMsg = ResourceManager.getInstance().getResString("PROGRAM_SELECTION_NO_CLIENT_PROGRAM_EXIST");
            }
            if (4 == iOperationType) {
                strErrorMsg = ResourceManager.getInstance().getResString("PROGRAM_SELECTION_NO_CLIENT_PATCH_EXIST");
            }
            DCOptionPane.showMessageDialog((Component)this.getParent(), strErrorMsg, ResourceManager.getInstance().getResString("ERROR"), 0);
            return false;
        }
        this.fileTree = this.createFileTree(this.oRoot);
        this.fileTree.setBackground(new Color(255, 255, 255));
        this.scrollPane.updateUI();
        this.scrollPane.updateUI();
        this.scrollPane.getViewport().add(this.fileTree);
        return true;
    }

    public JTree getFileTree() {
        return this.fileTree;
    }

    public void setFileTablePanel(FileTablePanel fileTablePanel) {
        this.fileTablePanel = fileTablePanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileTree_MouseClicked(final MouseEvent me) {
        FileNode treeNode;
        int y;
        Point p = me.getPoint();
        int x = (int)p.getX();
        int row = this.fileTree.getRowForLocation(x, y = (int)p.getY());
        if (-1 == row) {
            row = this.fileTree.getRowForLocation((int)p.getX(), (int)p.getY());
        }
        boolean isOperation = false;
        if (-1 == row) {
            if (row < 0) {
                isOperation = true;
                x += 17;
            }
            row = this.fileTree.getRowForLocation(x, (int)p.getY());
        }
        if (row < 0) {
            return;
        }
        final TreePath treepath = this.fileTree.getPathForLocation(x, y);
        if (treepath != null && null != (treeNode = (FileNode)treepath.getLastPathComponent()) && (me.getClickCount() == 2 || me.getClickCount() == 1 && isOperation)) {
            Object obj = treeNode.getUserObject();
            DirAndFileInfo node = null;
            if (obj instanceof DirAndFileInfo) {
                node = (DirAndFileInfo)obj;
            }
            try {
                DCFrameWorkUtil.setCursor(new Cursor(3));
                if (null != node) {
                    if (!this.m_bIsClient) {
                        this.getDirectoryFromServer(node.getPath(), treeNode);
                    } else {
                        this.getDirectoryFrmClient(node.getPath(), treeNode);
                    }
                }
            }
            finally {
                DCFrameWorkUtil.setCursor(new Cursor(0));
            }
            if (2 == me.getClickCount() && null != node && node.isFile()) {
                this.addFileToTable();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (me.getClickCount() == 2) {
                        if (FileTreePanel.this.fileTree.isCollapsed(treepath)) {
                            FileTreePanel.this.fileTree.expandPath(treepath);
                        } else {
                            FileTreePanel.this.fileTree.collapsePath(treepath);
                        }
                    }
                }
            });
            this.updateTree();
        }
    }

    public void setIsDMSDevice(boolean b) {
        this.bIsDMSDevice = b;
    }

    public void setSlaveDeviceTypeInfoList(List<DeviceTypeInfo> oDevTypeInfoList) {
        this.m_oSlaveDeviceTypeInfoList = oDevTypeInfoList;
    }

    public JTree getTree() {
        return this.fileTree;
    }

    class FileTreeCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        private static final long serialVersionUID = -4472575686073019343L;
        ImageIcon dirIcon = ResourceManager.getInstance().getImage("folder.gif");
        ImageIcon fileIcon = ResourceManager.getInstance().getImage("file.gif");

        public FileTreeCellRenderer() {
            super.setOpaque(true);
            this.setIconTextGap(2);
            super.setBackground(UIManager.getColor("Tree.textBackground"));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            FileNode treeNode;
            this.setText(String.valueOf(value));
            TreePath treePath = tree.getPathForRow(row);
            if (treePath != null && (treeNode = (FileNode)value).getUserObject() instanceof DirAndFileInfo) {
                DirAndFileInfo dirNode = (DirAndFileInfo)treeNode.getUserObject();
                if (dirNode.isFile()) {
                    this.setIcon(this.fileIcon);
                } else {
                    this.setIcon(this.dirIcon);
                }
            }
            if (selected) {
                this.setBackground(UIManager.getColor("Tree.selectionBackground"));
                this.setForeground(new Color(225, 225, 225));
            } else {
                this.setBackground(FileTreePanel.this.fileTree.getBackground());
                this.setForeground(Color.BLACK);
            }
            this.updateUI();
            return this;
        }
    }
}

