/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.view;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnSAMFileInfo;
import com.huawei.dc.common.asndatacenter.AsnSAMGetVersionFileLstRsp;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.common.util.TaskInfoUtil;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.IOperation;
import com.huawei.dc.devicemanagement.deviceoperation.IOperationPara;
import com.huawei.dc.devicemanagement.deviceoperation.IParaList;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.deviceoperation.ParaValue;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.view.EscapeKeyHandlerForLoadDialog;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.view.FileSelectionPanel;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.PostUpgradeOperation;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.devicemanagement.model.ContentTypeMgr;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.devicemanagement.model.IContentType;
import com.huawei.dc.devicemanagement.model.SoftwareType;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.sam.SAMUtil;
import com.huawei.dc.sam.controller.SAMManager;
import com.huawei.dc.sam.model.SAMFileInfo;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.text.Collator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class FileTablePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int ROW_NUM_COLUMN = 0;
    private static final int FILE_NAME_COLUMN = 1;
    private static final int CONTENT_TYPE_COLUMN = 2;
    private static final int DEVICE_TYPE_INFO_COLUMN = 3;
    private DefaultTableModel m_oFileTableModel = null;
    private JTable m_oFileTable = null;
    private JScrollPane m_oFileTableScrPan = null;
    private int m_iOperationType = 0;
    private JButton m_oMoveUpButton = null;
    private JButton m_oMoveDownButton = null;
    private JButton m_oDeleteButton = null;
    private JButton m_oMoveToBottomButton = null;
    private JButton m_oMoveToTopButton = null;
    private JButton m_oAddRowButton = null;
    private JPanel m_oButtonPanel = null;
    private JLabel m_oFileCountLabel;
    private int m_iLoadFileCount = 0;
    private DeviceType m_oDeviceType;
    private IContentType m_oContentType;
    private LoadFileInfoListParam m_oLoadFileInfoListParam;
    private ContentType[] m_arrContentTypes;
    private List<DeviceTypeInfo> m_oDevTypeInfo = null;
    private DeviceTypeInfo[] m_arrDeviceTypeInfo;
    public static final String DEFAULT_CONTENT_TYPE = "";
    private static final int DEFAULT_CONTENT_TYPE_ID = 999;
    private Resource m_oResource = null;
    int taskTypeId = -1;
    private FileSelectionPanel m_oFileSelectionPanel;
    private ITask m_oTask = null;
    private final String SERIAL = DCFrameWorkUtil.getLocalizedString("DEVICE_SEQ_NO");
    private boolean isFileSelectOk = true;
    private int iImageFileCount = 0;
    private static final int IMAGEFILEMAX = 2;
    private boolean isNeedToCheckImageFile = false;
    private int hitRowIndex = 0;

    public FileTablePanel(int iOperationType, LoadFileInfoListParam oLoadSoftwareParam, ITask oTask) throws DCException {
        this.m_oTask = oTask;
        this.m_iOperationType = iOperationType;
        this.m_oDeviceType = oTask.getSelectedDeviceType();
        this.taskTypeId = oTask.getTaskTypeId();
        this.initializeContentType();
        this.setLayout(new BorderLayout());
        this.m_oLoadFileInfoListParam = oLoadSoftwareParam;
        this.updatePara();
        this.jbInit();
        this.checkResourceType();
        this.addCurrentFilesToTable(0);
    }

    public FileTablePanel(int iOperationType, LoadFileInfoListParam oLoadSoftwareParam, List<DeviceTypeInfo> oDevTypeInfoLst, ITask oTask) throws DCException {
        this.m_oTask = oTask;
        this.m_iOperationType = iOperationType;
        this.m_oDeviceType = oTask.getSelectedDeviceType();
        this.taskTypeId = oTask.getTaskTypeId();
        this.initializeContentType();
        this.setLayout(new BorderLayout());
        this.m_oLoadFileInfoListParam = oLoadSoftwareParam;
        this.m_oDevTypeInfo = oDevTypeInfoLst;
        this.updatePara();
        this.jbInit();
        this.addCurrentFilesToTable(0);
    }

    public FileTablePanel(int iOperationType, LoadFileInfoListParam oLoadSoftwareParam, Resource oSelectedResource, ITask oTask) throws DCException {
        this.m_oTask = oTask;
        this.m_iOperationType = iOperationType;
        this.m_oDeviceType = oTask.getSelectedDeviceType();
        this.taskTypeId = oTask.getTaskTypeId();
        this.m_oResource = oSelectedResource;
        this.m_oLoadFileInfoListParam = oLoadSoftwareParam;
        this.m_oLoadFileInfoListParam.setDeviceTypeInfoRequired(false);
        this.initializeContentType();
        this.setLayout(new BorderLayout());
        this.updatePara();
        this.jbInit();
        this.addCurrentFilesToTable(1);
    }

    private void updatePara() {
        if (null != this.m_oContentType && 0 < this.m_oContentType.getContentDataTypes().size()) {
            this.m_oLoadFileInfoListParam.setContentTypeRequired(true);
        }
    }

    private void initializeContentType() throws DCException {
        ContentTypeMgr oContentTypeMgr = this.m_oDeviceType.getContentTypeMgr();
        if (null == oContentTypeMgr) {
            oContentTypeMgr = this.updateContentTypeManager();
        }
        if (4 == this.m_iOperationType) {
            this.m_oContentType = oContentTypeMgr.getConfigData();
        } else if (3 == this.m_iOperationType) {
            this.m_oContentType = oContentTypeMgr.getSoftwareType();
        } else if (5 == this.m_iOperationType) {
            this.m_oContentType = this.updateContentTypeManager().getSoftwareType();
        }
    }

    private ContentTypeMgr updateContentTypeManager() {
        List parameterValueList;
        int iSize;
        IOperationPara oDeviceLevelLoadParameter;
        IParaList oParaList;
        IOperation oOperationObj;
        if (null == this.m_oResource) {
            return new ContentTypeMgr();
        }
        ContentTypeMgr oMger = new ContentTypeMgr();
        SoftwareType oSW = new SoftwareType();
        DeviceTypeInfo oDeviceTypeInfo = DeviceInfoManagerImpl.getInstance().getDevice(this.m_oResource.getDeviceID()).getDeviceTypeInfo();
        int[] iDeviceIdLst = new int[]{this.m_oResource.getDeviceID()};
        if (0 != (this.m_oResource.getUpgradeMode() & 0x1000) && oDeviceTypeInfo.getDevDomain() == 2) {
            oDeviceTypeInfo = DCFrameWorkUtil.addPostFixTelnet(oDeviceTypeInfo);
        }
        IDeviceTypeConfigModel deviceTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDeviceTypeInfo, iDeviceIdLst);
        oDeviceTypeInfo = DCFrameWorkUtil.removePostFixTelnet(oDeviceTypeInfo);
        if (null != deviceTypeConfigModel && null != (oOperationObj = deviceTypeConfigModel.getOperationObj(1, 6)) && null != (oParaList = oOperationObj.getoPerationParaList()) && 0 != oParaList.getNumOfParam() && null != (oDeviceLevelLoadParameter = oParaList.getParameter("SelectFileForEachDevice")) && 0 < (iSize = (parameterValueList = oDeviceLevelLoadParameter.getParameterValueList()).size())) {
            oSW.addContentDataType(999, DEFAULT_CONTENT_TYPE, DEFAULT_CONTENT_TYPE);
            for (int iParaValueIndex = 0; iParaValueIndex < iSize; ++iParaValueIndex) {
                String strContentTypeName = ((ParaValue)parameterValueList.get(iParaValueIndex)).getDisplayName();
                int value = ((ParaValue)parameterValueList.get(iParaValueIndex)).getValue();
                String strId = ((ParaValue)parameterValueList.get(iParaValueIndex)).getId();
                oSW.addContentDataType(value, strContentTypeName, strId);
            }
        }
        oMger.setSoftwareType(oSW);
        return oMger;
    }

    private void jbInit() {
        ResourceManager oResManager = ResourceManager.getInstance();
        this.createTableModel(oResManager);
        this.createTable();
        this.createButtonsInPanel(oResManager);
        this.m_oFileTableScrPan = new JScrollPane(this.m_oFileTable);
        this.m_oFileTableScrPan.setName("DeviceOperation_FileTablePanel_m_oFileTableScrPan");
        this.m_oFileTableScrPan.getViewport().setBackground(new Color(227, 232, 233));
        this.add((Component)this.m_oFileTableScrPan, "Center");
    }

    private void createTable() {
        this.m_oFileTable = new JTable(this.m_oFileTableModel);
        this.m_oFileTable.setName("DeviceOperation_FileTablePanel_m_oFileTable");
        this.m_oFileTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                Object fileType;
                Object file;
                if (null != FileTablePanel.this.m_oDeviceType && 2 != FileTablePanel.this.m_oDeviceType.getDeviceDomain()) {
                    return;
                }
                int hitColumnIndex = e.getColumn();
                if (2 != hitColumnIndex) {
                    return;
                }
                FileTablePanel.this.hitRowIndex = e.getLastRow();
                Object str = FileTablePanel.this.m_oFileTable.getValueAt(FileTablePanel.this.hitRowIndex, hitColumnIndex);
                if (2 == hitColumnIndex && null != str && !str.toString().equals(FileTablePanel.DEFAULT_CONTENT_TYPE)) {
                    file = FileTablePanel.this.m_oFileTable.getValueAt(FileTablePanel.this.hitRowIndex, 1);
                    fileType = FileTablePanel.this.m_oFileTable.getValueAt(FileTablePanel.this.hitRowIndex, 2);
                    FileTablePanel.this.valativateLicFile(file.toString(), fileType.toString());
                }
                if (2 == hitColumnIndex && null != str && !str.toString().equals(FileTablePanel.DEFAULT_CONTENT_TYPE)) {
                    file = FileTablePanel.this.m_oFileTable.getValueAt(FileTablePanel.this.hitRowIndex, 1);
                    fileType = FileTablePanel.this.m_oFileTable.getValueAt(FileTablePanel.this.hitRowIndex, 2);
                    FileTablePanel.this.valativatePatchFile(file.toString(), fileType.toString());
                }
                if (FileTablePanel.this.isNeedToCheckImageFile) {
                    FileTablePanel.this.iImageFileCount = 0;
                    DefaultTableModel obj = (DefaultTableModel)e.getSource();
                    Vector<Vector> data = obj.getDataVector();
                    for (int index = 0; index < data.size() && FileTablePanel.this.isFileSelectOk; ++index) {
                        str = FileTablePanel.this.m_oFileTable.getValueAt(FileTablePanel.this.hitRowIndex, hitColumnIndex);
                        if (2 != hitColumnIndex || null == str || str.toString().equals(FileTablePanel.DEFAULT_CONTENT_TYPE)) continue;
                        Object file2 = FileTablePanel.this.m_oFileTable.getValueAt(index, 1);
                        Object fileType2 = FileTablePanel.this.m_oFileTable.getValueAt(index, 2);
                        FileTablePanel.this.valativateIMAGEFile(file2.toString(), fileType2.toString());
                    }
                }
            }
        });
        this.m_oFileTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (FileTablePanel.this.m_oFileTable.hasFocus()) {
                    FileTablePanel.this.updateStatusOfButtons();
                }
            }
        });
        this.m_oFileTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FileTablePanel.this.updateStatusOfButtons();
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }
        });
        this.m_oFileTable.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent event) {
                FileTablePanel.this.updateStatusOfButtons();
            }

            @Override
            public void mouseMoved(MouseEvent event) {
                Point p = event.getPoint();
                int hitColumnIndex = FileTablePanel.this.m_oFileTable.columnAtPoint(p);
                int hitRowIndex = FileTablePanel.this.m_oFileTable.rowAtPoint(p);
                Object str = FileTablePanel.this.m_oFileTable.getValueAt(hitRowIndex, hitColumnIndex);
                FileTablePanel.this.m_oFileTable.setToolTipText(str.toString());
            }
        });
        this.m_oFileTable.addKeyListener(new EscapeKeyHandlerForLoadDialog());
        this.m_oFileTable.setRowHeight(21);
        TableColumn rowNumColumn = this.m_oFileTable.getColumnModel().getColumn(0);
        rowNumColumn.setPreferredWidth(40);
        rowNumColumn.setMaxWidth(40);
        if (this.m_oLoadFileInfoListParam.isContentTypeRequired()) {
            TableColumn contentTypeColumn = this.m_oFileTable.getColumnModel().getColumn(2);
            List oContentTypeList = this.m_oContentType.getContentDataTypes();
            boolean bisPatchTask = 2 == this.taskTypeId;
            Iterator iterator = oContentTypeList.iterator();
            ContentType contentType = null;
            while (iterator.hasNext()) {
                contentType = (ContentType)iterator.next();
                if (bisPatchTask || !DeviceInfoUtil.isStackDevicePresent(this.m_oDeviceType.getResources(), 3) || !"PATCH".equals(contentType.getId())) continue;
                iterator.remove();
            }
            this.m_arrContentTypes = oContentTypeList.toArray(new ContentType[0]);
            ComboBoxWithToolTip oFileTypeComboBox = new ComboBoxWithToolTip(this.m_arrContentTypes);
            contentTypeColumn.setCellEditor(new DefaultCellEditor(oFileTypeComboBox));
            contentTypeColumn.setCellRenderer(new ContentTypeCellRenderer(this.m_arrContentTypes));
            contentTypeColumn.setPreferredWidth(145);
            contentTypeColumn.setMaxWidth(145);
        }
        if (this.m_oLoadFileInfoListParam.isDeviceTypeInfoRequired()) {
            TableColumn devTypeColumn = this.m_oFileTable.getColumnModel().getColumn(3);
            if (null != this.m_oDevTypeInfo) {
                this.m_arrDeviceTypeInfo = this.m_oDevTypeInfo.toArray(new DeviceTypeInfo[0]);
                devTypeColumn.setCellEditor(new DeviceTypeInfoCellEditor(this.m_arrDeviceTypeInfo));
                devTypeColumn.setCellRenderer(new DeviceTypeInfoCellRenderer(this.m_arrDeviceTypeInfo));
                devTypeColumn.setPreferredWidth(145);
                devTypeColumn.setMaxWidth(145);
            }
        }
        this.m_oFileTable.getSelectionModel().setSelectionMode(1);
        this.m_oFileTable.setRowSelectionAllowed(true);
        this.m_oFileTable.getTableHeader().setReorderingAllowed(false);
        this.m_oFileTable.getTableHeader().setPreferredSize(new Dimension(this.m_oFileTable.getSize().width, 21));
    }

    private String[] populateTableColumns(ResourceManager oResManager) {
        int iNosColumn = 2;
        if (this.m_oLoadFileInfoListParam.isContentTypeRequired()) {
            ++iNosColumn;
        }
        if (this.m_oLoadFileInfoListParam.isDeviceTypeInfoRequired()) {
            ++iNosColumn;
        }
        String[] fileListTableColumns = new String[iNosColumn];
        fileListTableColumns[0] = oResManager.getResString("DEVICE_SEQ_NO");
        if (this.m_oLoadFileInfoListParam.isContentTypeRequired()) {
            fileListTableColumns[2] = oResManager.getResString("PROGRAM_SELECTION_CONTENT_TYPE");
        }
        if (this.m_oLoadFileInfoListParam.isDeviceTypeInfoRequired()) {
            fileListTableColumns[3] = oResManager.getResString("PROGRAM_SELECTION_DEVICE_TYPE");
        }
        fileListTableColumns[1] = this.m_iOperationType == 4 ? oResManager.getResString("PROGRAM_SELECTION_PATCH") : oResManager.getResString("PROGRAM_SELECTION_PROGRAM");
        return fileListTableColumns;
    }

    private void createTableModel(ResourceManager oResManager) {
        Object[] fileListTableColumns = this.populateTableColumns(oResManager);
        this.m_oFileTableModel = new DefaultTableModel(fileListTableColumns, 0){
            private static final long serialVersionUID = -1107166984345503238L;

            @Override
            public boolean isCellEditable(int row, int col) {
                if (2 == col || 3 == col || 1 == col && null != FileTablePanel.this.m_oAddRowButton) {
                    FileTablePanel.this.m_oFileTable.setRowSelectionInterval(row, row);
                    FileTablePanel.this.updateStatusOfButtons();
                    return true;
                }
                return false;
            }
        };
    }

    private void createButtonsInPanel(ResourceManager oResManager) {
        this.createMoveUpButton(oResManager);
        this.createMoveDownButton(oResManager);
        this.createMoveToTopButton(oResManager);
        this.createMoveToBottomButton(oResManager);
        this.createDeleteButton(oResManager);
        this.createFileCountLabel();
        this.m_oButtonPanel = new JPanel();
        this.m_oButtonPanel.setPreferredSize(new Dimension(27, 299));
        this.m_oButtonPanel.setLayout(null);
        this.m_oButtonPanel.add((Component)this.m_oMoveToTopButton, null);
        this.m_oButtonPanel.add((Component)this.m_oMoveUpButton, null);
        this.m_oButtonPanel.add((Component)this.m_oMoveDownButton, null);
        this.m_oButtonPanel.add((Component)this.m_oMoveToBottomButton, null);
        this.m_oButtonPanel.add((Component)this.m_oDeleteButton, null);
        this.m_oButtonPanel.add((Component)this.m_oFileCountLabel, null);
        this.add((Component)this.m_oButtonPanel, "East");
    }

    private void createMoveUpButton(ResourceManager oResManager) {
        this.m_oMoveUpButton = new JButton();
        this.m_oMoveUpButton.setName("DeviceOperation_FileTablePanel_m_oMoveUpButton");
        ImageIcon moveUpIcon = ResourceManager.getInstance().getImage("autoupgrade_moveup.gif");
        this.m_oMoveUpButton.setIcon(moveUpIcon);
        this.m_oMoveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTablePanel.this.moveUpButton_ActionPerformed();
            }
        });
        this.m_oMoveUpButton.setBounds(new Rectangle(3, 27, 23, 23));
        this.m_oMoveUpButton.setToolTipText(oResManager.getResString("PROGRAM_SELECTION_MOVE_UP_BTN_TOOL_TIP"));
        this.m_oMoveUpButton.setEnabled(false);
    }

    private void createMoveDownButton(ResourceManager oResManager) {
        this.m_oMoveDownButton = new JButton();
        this.m_oMoveDownButton.setName("DeviceOperation_FileTablePanel_m_oMoveDownButton");
        ImageIcon moveDownIcon = ResourceManager.getInstance().getImage("autoupgrade_movedown.gif");
        this.m_oMoveDownButton.setIcon(moveDownIcon);
        this.m_oMoveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTablePanel.this.moveDownButton_ActionPerformed();
            }
        });
        this.m_oMoveDownButton.setBounds(new Rectangle(3, 54, 23, 23));
        this.m_oMoveDownButton.setToolTipText(oResManager.getResString("PROGRAM_SELECTION_MOVE_DOWN_BTN_TOOL_TIP"));
        this.m_oMoveDownButton.setEnabled(false);
    }

    private void createMoveToTopButton(ResourceManager oResManager) {
        this.m_oMoveToTopButton = new JButton();
        this.m_oMoveToTopButton.setName("DeviceOperation_FileTablePanel_m_oMoveToTopButton");
        this.m_oMoveToTopButton.setBounds(new Rectangle(3, 0, 23, 23));
        this.m_oMoveToTopButton.setToolTipText(oResManager.getResString("AUTO_UPGRADE_MOVE_UPMOST_BUTTON"));
        this.m_oMoveToTopButton.setVerifyInputWhenFocusTarget(true);
        this.m_oMoveToTopButton.setMnemonic('F');
        this.m_oMoveToTopButton.setEnabled(false);
        ImageIcon upMostIcon = ResourceManager.getInstance().getImage("movetofirst.gif");
        this.m_oMoveToTopButton.setIcon(upMostIcon);
        this.m_oMoveToTopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTablePanel.this.moveToTopButton_ActionPerformed();
            }
        });
    }

    private void createMoveToBottomButton(ResourceManager oResManager) {
        this.m_oMoveToBottomButton = new JButton();
        this.m_oMoveToBottomButton.setName("DeviceOperation_FileTablePanel_m_oMoveToBottomButton");
        this.m_oMoveToBottomButton.setBounds(new Rectangle(3, 81, 23, 23));
        this.m_oMoveToBottomButton.setToolTipText(oResManager.getResString("AUTO_UPGRADE_MOVE_DOWNMOST_BUTTON"));
        this.m_oMoveToBottomButton.setMnemonic('L');
        this.m_oMoveToBottomButton.setEnabled(false);
        ImageIcon downMostIcon = ResourceManager.getInstance().getImage("movetolast.gif");
        this.m_oMoveToBottomButton.setIcon(downMostIcon);
        this.m_oMoveToBottomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTablePanel.this.moveToBottomButton_ActionPerformed();
            }
        });
    }

    private void createDeleteButton(ResourceManager oResManager) {
        this.m_oDeleteButton = new JButton();
        this.m_oDeleteButton.setName("DeviceOperation_FileTablePanel_m_oDeleteButton");
        this.m_oDeleteButton.setMnemonic('D');
        ImageIcon deleteIcon = ResourceManager.getInstance().getImage("delete.gif");
        this.m_oDeleteButton.setIcon(deleteIcon);
        this.m_oDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTablePanel.this.deleteButton_ActionPerformed();
            }
        });
        this.m_oDeleteButton.setBounds(new Rectangle(3, 108, 23, 23));
        this.m_oDeleteButton.setToolTipText(oResManager.getResString("PROGRAM_SELECTION_DELETE_BTN_TOOL_TIP"));
        this.m_oDeleteButton.setEnabled(false);
    }

    public void createAddButton() {
        this.m_oAddRowButton = new JButton();
        this.m_oAddRowButton.setName("DeviceOperation_FileTablePanel_m_oDeleteButton");
        this.m_oAddRowButton.setMnemonic('A');
        ImageIcon deleteIcon = ResourceManager.getInstance().getImage("addrow.gif");
        this.m_oAddRowButton.setIcon(deleteIcon);
        this.m_oAddRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTablePanel.this.addButton_ActionPerformed();
            }
        });
        this.m_oAddRowButton.setBounds(new Rectangle(3, 0, 23, 23));
        this.m_oAddRowButton.setToolTipText(DCFrameWorkUtil.getLocalizedString("PROGRAM_SELECTION_SINGLE_BTN_TOOL_TIP"));
        this.m_oAddRowButton.setEnabled(true);
        this.m_oButtonPanel.add((Component)this.m_oAddRowButton, null);
        this.m_oDeleteButton.setBounds(new Rectangle(3, 27, 23, 23));
        this.m_oMoveToTopButton.setBounds(new Rectangle(3, 54, 23, 23));
        this.m_oMoveUpButton.setBounds(new Rectangle(3, 81, 23, 23));
        this.m_oMoveDownButton.setBounds(new Rectangle(3, 108, 23, 23));
        this.m_oMoveToBottomButton.setBounds(new Rectangle(3, 135, 23, 23));
    }

    protected void addButton_ActionPerformed() {
        Vector<Object> oRowVector = new Vector<Object>(0);
        oRowVector.add(this.m_oFileTableModel.getRowCount() + 1);
        oRowVector.add(DEFAULT_CONTENT_TYPE);
        ContentType oContentType = this.m_arrContentTypes[0];
        oRowVector.add(oContentType);
        if (this.m_oLoadFileInfoListParam.isDeviceTypeInfoRequired()) {
            DeviceTypeInfo oDevTypeInfo = this.m_arrDeviceTypeInfo[0];
            oRowVector.add(oDevTypeInfo);
        }
        this.m_oFileTableModel.addRow(oRowVector);
        this.m_oFileTable.setRowSelectionInterval(this.m_oFileTableModel.getRowCount() - 1, this.m_oFileTableModel.getRowCount() - 1);
        this.m_oFileTable.repaint();
        this.updateStatusOfButtons();
    }

    private void createFileCountLabel() {
        this.m_oFileCountLabel = new JLabel();
        this.m_oFileCountLabel.setMaximumSize(new Dimension(175, 25));
        this.m_oFileCountLabel.setMinimumSize(new Dimension(175, 25));
        this.m_oFileCountLabel.setPreferredSize(new Dimension(175, 25));
        this.m_oFileCountLabel.setHorizontalAlignment(4);
    }

    private void deleteButton_ActionPerformed() {
        int[] selectedRows = this.m_oFileTable.getSelectedRows();
        if (0 >= selectedRows.length) {
            return;
        }
        for (int i = 0; i < selectedRows.length; ++i) {
            int iRowIndex = selectedRows[i] - i;
            this.removeFileFromParam(iRowIndex);
            this.m_oFileTableModel.removeRow(iRowIndex);
        }
        this.m_iLoadFileCount -= selectedRows.length;
        this.m_oFileCountLabel.setText(ResourceManager.getInstance().getResString("SELECT_LOAD_FILE_LABEL_LEFT_TEXT") + this.m_iLoadFileCount + ' ' + ResourceManager.getInstance().getResString("SELECT_LOAD_FILE_LABEL_RIGHT_TEXT"));
        this.m_oFileTableModel.fireTableDataChanged();
        int rowCount = this.m_oFileTable.getRowCount();
        if (rowCount > 0) {
            if (rowCount == selectedRows[0]) {
                this.m_oFileTable.setRowSelectionInterval(selectedRows[0] - 1, selectedRows[0] - 1);
            } else {
                this.m_oFileTable.setRowSelectionInterval(selectedRows[0], selectedRows[0]);
            }
            if (rowCount == 1) {
                this.m_oMoveUpButton.setEnabled(false);
                this.m_oMoveDownButton.setEnabled(false);
            }
        } else {
            this.m_oMoveUpButton.setEnabled(false);
            this.m_oMoveDownButton.setEnabled(false);
            this.m_oDeleteButton.setEnabled(false);
            this.m_oFileCountLabel.setText(DEFAULT_CONTENT_TYPE);
        }
        this.updateRowSequence();
        this.m_oFileTable.repaint();
        this.updateStatusOfButtons();
    }

    private void removeFileFromParam(int iRowIndex) {
        Vector<Vector> dataVec = this.m_oFileTableModel.getDataVector();
        Vector vec = dataVec.elementAt(iRowIndex);
        LoadFileInfo oFile = new LoadFileInfo();
        oFile.setSequenceNo((Integer)vec.elementAt(0));
        oFile.setFileName(String.valueOf(vec.elementAt(1)));
        if (this.m_oLoadFileInfoListParam.isContentTypeRequired()) {
            oFile.setContentType((ContentType)vec.elementAt(2));
        }
        this.m_oLoadFileInfoListParam.removeFileFromList(oFile);
    }

    protected void moveToTopButton_ActionPerformed() {
        int[] ArrRows = this.m_oFileTable.getSelectedRows();
        if (0 == ArrRows.length) {
            return;
        }
        int iLastRow = ArrRows[ArrRows.length - 1];
        int iFirstRow = ArrRows[0];
        if (0 != ArrRows[0]) {
            this.m_oFileTableModel.moveRow(ArrRows[0], ArrRows[ArrRows.length - 1], 0);
            this.m_oFileTable.setColumnSelectionAllowed(false);
            this.m_oFileTable.setRowSelectionAllowed(true);
            this.m_oFileTable.setRowSelectionInterval(0, iLastRow - iFirstRow);
            JScrollBar oVertScrollBar = this.m_oFileTableScrPan.getVerticalScrollBar();
            oVertScrollBar.setValue(oVertScrollBar.getMinimum());
            this.updateRowSequence();
            this.m_oFileTable.repaint();
            this.updateStatusOfButtons();
        }
    }

    private void moveUpButton_ActionPerformed() {
        int[] ArrRows = this.m_oFileTable.getSelectedRows();
        if (0 == ArrRows.length) {
            return;
        }
        int iCount = ArrRows[0];
        if (0 == iCount) {
            return;
        }
        int iLastCount = ArrRows[ArrRows.length - 1];
        this.m_oFileTableModel.moveRow(ArrRows[0], ArrRows[ArrRows.length - 1], iCount - 1);
        this.m_oFileTable.setColumnSelectionAllowed(false);
        this.m_oFileTable.setRowSelectionAllowed(true);
        this.m_oFileTable.setRowSelectionInterval(iCount - 1, iLastCount - 1);
        Rectangle oRect = this.m_oFileTable.getCellRect(iCount - 1, 0, true);
        this.m_oFileTable.scrollRectToVisible(oRect);
        this.updateRowSequence();
        this.m_oFileTable.repaint();
        this.updateStatusOfButtons();
    }

    private void moveDownButton_ActionPerformed() {
        int[] ArrRows = this.m_oFileTable.getSelectedRows();
        int iCount = ArrRows.length;
        if (0 == iCount) {
            return;
        }
        int iFirstRow = ArrRows[0];
        if (ArrRows[ArrRows.length - 1] == this.m_oFileTable.getRowCount() - 1) {
            return;
        }
        this.m_oFileTableModel.moveRow(ArrRows[0], ArrRows[ArrRows.length - 1], iFirstRow + 1);
        this.m_oFileTable.setColumnSelectionAllowed(false);
        this.m_oFileTable.setRowSelectionAllowed(true);
        this.m_oFileTable.setRowSelectionInterval(iFirstRow + 1, iCount + iFirstRow);
        Rectangle oRect = this.m_oFileTable.getCellRect(iCount + iFirstRow, 0, true);
        this.m_oFileTable.scrollRectToVisible(oRect);
        this.updateRowSequence();
        this.m_oFileTable.repaint();
        this.updateStatusOfButtons();
    }

    protected void moveToBottomButton_ActionPerformed() {
        int[] ArrRows = this.m_oFileTable.getSelectedRows();
        if (0 == ArrRows.length) {
            return;
        }
        int iLastRow = ArrRows[ArrRows.length - 1];
        int iFirstRow = ArrRows[0];
        if (this.m_oFileTable.getRowCount() - 1 != ArrRows[ArrRows.length - 1]) {
            if (ArrRows[0] == ArrRows[ArrRows.length - 1]) {
                this.m_oFileTableModel.moveRow(ArrRows[0], ArrRows[ArrRows.length - 1], this.m_oFileTable.getRowCount() - 1);
            } else {
                this.m_oFileTableModel.moveRow(ArrRows[0], ArrRows[ArrRows.length - 1], this.m_oFileTable.getRowCount() - ArrRows.length);
            }
            this.m_oFileTable.setColumnSelectionAllowed(false);
            this.m_oFileTable.setRowSelectionAllowed(true);
            this.m_oFileTable.setRowSelectionInterval(this.m_oFileTable.getRowCount() - 1, iFirstRow + (this.m_oFileTable.getRowCount() - 1 - iLastRow));
            JScrollBar oVertScrollBar = this.m_oFileTableScrPan.getVerticalScrollBar();
            oVertScrollBar.setValue(oVertScrollBar.getMaximum());
            this.updateRowSequence();
            this.m_oFileTable.repaint();
            this.updateStatusOfButtons();
        }
    }

    private void updateRowSequence() {
        int rowCount = this.m_oFileTable.getRowCount();
        if (rowCount > 0) {
            for (int rowId = 0; rowId < rowCount; ++rowId) {
                this.m_oFileTable.setValueAt(rowId + 1, rowId, 0);
            }
        }
    }

    private void updateStatusOfButtons() {
        int[] updatedrows = this.m_oFileTable.getSelectedRows();
        int iRowCount = this.m_oFileTable.getRowCount();
        if (updatedrows.length >= 1) {
            this.m_oDeleteButton.setEnabled(true);
            this.m_oMoveDownButton.setEnabled(true);
            this.m_oMoveToBottomButton.setEnabled(true);
            this.m_oMoveUpButton.setEnabled(true);
            this.m_oMoveToTopButton.setEnabled(true);
            if (iRowCount >= 1) {
                int iLastSelectedRowIndex = updatedrows[updatedrows.length - 1];
                if (iRowCount - 1 == iLastSelectedRowIndex) {
                    this.m_oMoveDownButton.setEnabled(false);
                    this.m_oMoveToBottomButton.setEnabled(false);
                }
                if (0 == updatedrows[0]) {
                    this.m_oMoveUpButton.setEnabled(false);
                    this.m_oMoveToTopButton.setEnabled(false);
                }
            }
        } else {
            this.m_oMoveUpButton.setEnabled(false);
            this.m_oMoveToTopButton.setEnabled(false);
            this.m_oMoveDownButton.setEnabled(false);
            this.m_oMoveToBottomButton.setEnabled(false);
            this.m_oDeleteButton.setEnabled(false);
        }
        this.m_oFileTable.repaint();
    }

    public void addSelectedFiles(LoadFileInfo[] fileList, String strRootPath) throws DCException {
        int rowCount = this.m_oFileTableModel.getRowCount();
        Vector<Object> v = null;
        int iRowIndex = 0;
        for (int i = 0; i < fileList.length; ++i) {
            if (null == fileList[i]) continue;
            v = new Vector<Object>(3);
            boolean bFound = false;
            while (iRowIndex < rowCount) {
                if (this.isRowExist(fileList[i], strRootPath)) {
                    DCOptionPane.showMessageDialog((Component)this.getParent(), ResourceManager.getInstance().getResString("FILE_ALREADY_SELECTED"), ResourceManager.getInstance().getResString("INFORMATION"), 1);
                    return;
                }
                if (this.m_oFileTableModel.getValueAt(iRowIndex, 1).equals(fileList[i].getFileName())) {
                    bFound = true;
                    break;
                }
                ++iRowIndex;
            }
            if (!bFound) {
                v.add(++iRowIndex);
                String strFullPath = this.getFullFileName(strRootPath, fileList[i].getFileName());
                v.add(strFullPath);
                if (this.m_oLoadFileInfoListParam.isContentTypeRequired() && null == this.m_oContentType.getContentDataTypes() && 0 == this.m_oContentType.getContentDataTypes().size()) {
                    throw new DCException("NO_PROGRAM_CONTENT_TYPE_FOR_DEVICE_TYPE");
                }
                if (this.m_oLoadFileInfoListParam.isContentTypeRequired()) {
                    if (null != fileList[i].getContentType()) {
                        v.add(fileList[i].getContentType());
                    } else if (null != this.m_arrContentTypes && 0 < this.m_arrContentTypes.length) {
                        v.add(this.m_arrContentTypes[0]);
                    }
                }
                if (this.m_oLoadFileInfoListParam.isDeviceTypeInfoRequired()) {
                    if (null != fileList[i].getDeviceTypeInfo()) {
                        v.add(fileList[i].getDeviceTypeInfo());
                    } else if (null != this.m_arrDeviceTypeInfo && 0 < this.m_arrDeviceTypeInfo.length) {
                        v.add(this.m_arrDeviceTypeInfo[0]);
                    }
                }
                this.m_oFileTableModel.addRow(v);
                ++this.m_iLoadFileCount;
                this.m_oFileCountLabel.setText(ResourceManager.getInstance().getResString("SELECT_LOAD_FILE_LABEL_LEFT_TEXT") + this.m_iLoadFileCount + ' ' + ResourceManager.getInstance().getResString("SELECT_LOAD_FILE_LABEL_RIGHT_TEXT"));
                this.m_oFileTableScrPan.getVerticalScrollBar().setValue(this.m_oFileTableScrPan.getVerticalScrollBar().getMaximum());
            }
            v = null;
        }
        this.updateStatusOfButtons();
        this.m_oFileTable.updateUI();
    }

    private boolean isRowExist(LoadFileInfo oFileInfo, String strRootPath) {
        int iRowCount = this.m_oFileTableModel.getRowCount();
        int FILENAME_COLUMN_INDEX = 1;
        String strFilePath = DEFAULT_CONTENT_TYPE;
        String strFileFromTree = DEFAULT_CONTENT_TYPE;
        boolean bisFileExists = false;
        Collator oEquals = Collator.getInstance();
        for (int index = 0; index < iRowCount; ++index) {
            strFilePath = this.m_oFileTableModel.getValueAt(index, FILENAME_COLUMN_INDEX).toString();
            strFilePath = strFilePath.replace("\\", File.pathSeparator);
            strFileFromTree = strRootPath + "/" + oFileInfo.getFileName();
            if (!oEquals.equals(strFilePath, strFileFromTree = strFileFromTree.replace("\\", File.pathSeparator))) continue;
            bisFileExists = true;
        }
        if (this.m_oLoadFileInfoListParam.isDeviceTypeInfoRequired()) {
            bisFileExists = false;
        }
        return bisFileExists;
    }

    public LoadFileInfo[] getFilesFromTable() {
        Vector<Vector> oDataVector = this.m_oFileTableModel.getDataVector();
        if (null == oDataVector || 0 == oDataVector.size()) {
            return new LoadFileInfo[0];
        }
        if (this.m_oFileTable.isEditing()) {
            this.m_oFileTable.getCellEditor().stopCellEditing();
        }
        int iSize = this.m_oFileTableModel.getDataVector().size();
        LoadFileInfo[] fileList = new LoadFileInfo[iSize];
        for (int i = 0; i < iSize; ++i) {
            Vector vec = oDataVector.elementAt(i);
            fileList[i] = new LoadFileInfo();
            fileList[i].setSequenceNo((Integer)vec.elementAt(0));
            fileList[i].setFileName(String.valueOf(vec.elementAt(1)));
            if (this.m_oLoadFileInfoListParam.isContentTypeRequired()) {
                fileList[i].setContentType((ContentType)vec.elementAt(2));
            }
            if (!this.m_oLoadFileInfoListParam.isDeviceTypeInfoRequired()) continue;
            fileList[i].setDeviceTypeInfo((DeviceTypeInfo)vec.elementAt(3));
        }
        return fileList;
    }

    public int getRowCount() {
        return this.m_oFileTableModel.getRowCount();
    }

    private void addCurrentFilesToTable(int fileSelectLevel) {
        List<LoadFileInfo> oLoadFileLst = this.m_oLoadFileInfoListParam.getLoadFileInfoList();
        if (null == oLoadFileLst || 0 == oLoadFileLst.size()) {
            return;
        }
        List<LoadFileInfo> oCurrentFiles = DCCommonUtil.getLoadFileInfo(this.m_oLoadFileInfoListParam, fileSelectLevel);
        int iCurrentFileCount = oCurrentFiles.size();
        Vector<Object> v = null;
        Integer oSequenceNumber = null;
        LoadFileInfo oFile = null;
        DeviceType oDevType = this.m_oTask.getDeviceType();
        DeviceTypeInfo oTmpDevTypeInfo = DeviceInfoManagerImpl.getInstance().getDeviceTypeInfo(oDevType.getDeviceTypeID(), oDevType.getDeviceTypeVersionID());
        int[] iDeviceIdLst = TaskInfoUtil.getTaskDeviceIdLst(this.m_oTask, oTmpDevTypeInfo);
        List oLoadPatchContentTypeLst = DeviceXMLConfigModel.getInstance().getContentTypesFromXMLConfig(oTmpDevTypeInfo, 9, iDeviceIdLst);
        boolean bContansPatch = false;
        for (int index = 0; index < iCurrentFileCount; ++index) {
            oFile = oCurrentFiles.get(index);
            if (5 != this.m_iOperationType && 0 != oFile.getFileSelectionLevel() || 5 == this.m_iOperationType && 0 == oFile.getFileSelectionLevel() || 5 == this.m_iOperationType && 0 != oFile.getFileSelectionLevel() && (0 == oFile.getDeviceId() || null == this.m_oResource || oFile.getDeviceId() != this.m_oResource.getDeviceID()) || DCConstants.PACKET_TOOL_CONTENT_TYPE.equals(oFile.getContentType())) continue;
            v = new Vector<Object>(0);
            oSequenceNumber = oFile.getSequenceNo();
            v.add(oSequenceNumber);
            v.add(oFile.getFileName());
            ContentType oContentType = oFile.getContentType();
            if (null == oContentType && null != this.m_arrContentTypes && 0 < this.m_arrContentTypes.length) {
                oContentType = this.m_arrContentTypes[0];
            }
            v.add(oContentType);
            if (null != oLoadPatchContentTypeLst && !bContansPatch && oLoadPatchContentTypeLst.contains(oContentType)) {
                bContansPatch = true;
            }
            if (this.m_oLoadFileInfoListParam.isDeviceTypeInfoRequired()) {
                DeviceTypeInfo oDevTypeInfo = oFile.getDeviceTypeInfo();
                if (null == oDevTypeInfo && null != this.m_arrDeviceTypeInfo && 0 < this.m_arrDeviceTypeInfo.length) {
                    oDevTypeInfo = this.m_arrDeviceTypeInfo[0];
                }
                v.add(oDevTypeInfo);
            }
            this.m_oFileTableModel.addRow(v);
        }
        String sTargetVer = this.m_oTask.getTargetVersion();
        if (bContansPatch || StringUtils.isNullOrEmptyStr(sTargetVer)) {
            return;
        }
        ITaskDeviceOperation oTaskOper = TaskInfoUtil.getTaskOperation(this.m_oTask, 33);
        if (null == oTaskOper) {
            return;
        }
        PostUpgradeOperation oPostUpOper = (PostUpgradeOperation)oTaskOper;
        boolean bSelUpPatch = oPostUpOper.isSelectSubOperationUp("UpgradePatch");
        if (oPostUpOper.isSelected()) {
            if (!bSelUpPatch) {
                return;
            }
        } else {
            return;
        }
        if (this.m_iOperationType == 5 && 1 == fileSelectLevel) {
            return;
        }
        SAMFileInfo oSAMFileInfo = new SAMFileInfo();
        oSAMFileInfo.setDeviceTypeInfo(oTmpDevTypeInfo);
        oSAMFileInfo.setVersion(sTargetVer);
        AsnSAMGetVersionFileLstRsp oAsnSAMGetVersionFileLstRsp = SAMManager.getInstance().getAsnSAMDeviceVersionFileReq(oSAMFileInfo);
        int iFileSize = oAsnSAMGetVersionFileLstRsp.oAsnSAMFileInfoLst.size();
        boolean bisPatchTask = this.m_oTask.getTaskTypeId() == 2;
        SystemManager sysMgr = new SystemManager();
        String sRootPath = sysMgr.getFTSInfo().getRootDirectory();
        String sFullFileName = DEFAULT_CONTENT_TYPE;
        for (int i = 0; i < iFileSize; ++i) {
            AsnSAMFileInfo oAsnFile = (AsnSAMFileInfo)oAsnSAMGetVersionFileLstRsp.oAsnSAMFileInfoLst.get(i);
            ContentType oContentType = SAMUtil.getInstance().getContentType(oTmpDevTypeInfo, oAsnFile.iFileType.intValue(), bisPatchTask, iDeviceIdLst);
            if (null == oLoadPatchContentTypeLst || !oLoadPatchContentTypeLst.contains(oContentType)) continue;
            Vector<Object> oRowVct = new Vector<Object>(0);
            oSequenceNumber = oSequenceNumber + 1;
            oRowVct.add(oSequenceNumber);
            String fullFileName = DEFAULT_CONTENT_TYPE;
            fullFileName = sRootPath.startsWith("/") ? DCConstants.SAM_PATH_NOWIN + "/" + new String(oAsnFile.strFileName) : DCConstants.SAM_PATH + "/" + new String(oAsnFile.strFileName);
            sFullFileName = this.getFullFileName(sRootPath, fullFileName);
            oRowVct.add(sFullFileName);
            oRowVct.add(oContentType);
            this.m_oFileTableModel.addRow(oRowVct);
        }
    }

    public boolean isFileAlreadyAdded(String newFileName) {
        boolean bIsFileAlreadyExistInTable = false;
        Vector<Vector> dataVec = this.m_oFileTableModel.getDataVector();
        int size = dataVec.size();
        if (0 == size) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            Vector vec = dataVec.elementAt(i);
            String oldFileName = (String)vec.get(1);
            if (0 != Collator.getInstance().compare(newFileName, oldFileName)) continue;
            bIsFileAlreadyExistInTable = true;
            break;
        }
        return bIsFileAlreadyExistInTable;
    }

    public void removeAllRows() {
        while (this.m_oFileTable.getRowCount() != 0) {
            this.m_oFileTableModel.removeRow(0);
        }
    }

    public JTable getFileTable() {
        return this.m_oFileTable;
    }

    public void setFileSelectionPanel(FileSelectionPanel oFileSelectionPanel) {
        this.m_oFileSelectionPanel = oFileSelectionPanel;
    }

    private String getFullFileName(String sRootPath, String sFileName) {
        String sFullFileName = DEFAULT_CONTENT_TYPE;
        sFullFileName = sRootPath.contains(":") ? (sRootPath.endsWith("/") ? sRootPath + sFileName : sRootPath + "/" + sFileName) : (sRootPath.endsWith("/") || sRootPath.endsWith("\\") ? sRootPath + sFileName : (this.m_oTask.isThirdPartySupported() && StringUtils.isIPV4(sRootPath) ? "/" + sFileName : sRootPath + "/" + sFileName));
        sFullFileName = sFullFileName.replace('\\', '/');
        return sFullFileName;
    }

    private void valativateLicFile(String file, String fileType) {
        if (file.equals(DEFAULT_CONTENT_TYPE) || fileType.equals(DEFAULT_CONTENT_TYPE)) {
            return;
        }
        String strGTLLicense = ResourceManager.getInstance().getResFromDomainProperties(2, "GTLLicense");
        String strLicense = ResourceManager.getInstance().getResFromDomainProperties(2, "LICENSE");
        if (fileType.equals(strGTLLicense) && !file.toLowerCase().contains(".dat")) {
            this.isFileSelectOk = false;
            String errMsg = ResourceManager.getInstance().getResString("INVALID_LICENSE_FILE");
            DCOptionPane.showMessageDialog((Component)this, errMsg, ResourceManager.getInstance().getResString("WARNING"), 2);
            this.m_oFileTableModel.setValueAt(this.m_arrContentTypes[0], this.hitRowIndex, 2);
        } else if (fileType.equals(strLicense) && !file.toLowerCase().contains(".txt")) {
            this.isFileSelectOk = false;
            String errMsg = ResourceManager.getInstance().getResString("INVALID_LICENSE_FILE");
            DCOptionPane.showMessageDialog((Component)this, errMsg, ResourceManager.getInstance().getResString("WARNING"), 2);
            this.m_oFileTableModel.setValueAt(this.m_arrContentTypes[0], this.hitRowIndex, 2);
        }
    }

    private void valativatePatchFile(String file, String fileType) {
        if (file.equals(DEFAULT_CONTENT_TYPE) || fileType.equals(DEFAULT_CONTENT_TYPE)) {
            return;
        }
        String strPatFile = ResourceManager.getInstance().getResString("PROGRAM_SELECTION_PATCH");
        if (fileType.contains(strPatFile) && !file.toLowerCase().contains(".pat")) {
            this.isFileSelectOk = false;
            String errMsg = this.SERIAL + (this.hitRowIndex + 1) + ":" + ResourceManager.getInstance().getResString("INVALID_PATCH_FILE");
            DCOptionPane.showMessageDialog((Component)this, errMsg, ResourceManager.getInstance().getResString("WARNING"), 2);
            if (2 == this.m_oTask.getTaskTypeId()) {
                this.m_oFileTableModel.removeRow(this.hitRowIndex);
            } else {
                this.m_oFileTableModel.setValueAt(this.m_arrContentTypes[0], this.hitRowIndex, 2);
            }
            this.updateStatusOfButtons();
        }
    }

    private void valativateIMAGEFile(String file, String fileType) {
        if (file.equals(DEFAULT_CONTENT_TYPE) || fileType.equals(DEFAULT_CONTENT_TYPE)) {
            return;
        }
        String strProgram = ResourceManager.getInstance().getResFromDomainProperties(2, "PROGRAM");
        if (fileType.contains(strProgram)) {
            ++this.iImageFileCount;
        } else {
            return;
        }
        if (this.iImageFileCount >= 2) {
            this.iImageFileCount = 0;
            this.isFileSelectOk = false;
            String errMsg = this.SERIAL + (this.hitRowIndex + 1) + ":" + ResourceManager.getInstance().getResString("ONLY_SUPPORT_ONE_IMAGE_FILE");
            DCOptionPane.showMessageDialog((Component)this, errMsg, ResourceManager.getInstance().getResString("WARNING"), 2);
            this.m_oFileTableModel.setValueAt(this.m_arrContentTypes[0], this.hitRowIndex, 2);
        }
    }

    private void checkResourceType() {
        this.isNeedToCheckImageFile = false;
        DeviceType oDeviceType = this.m_oTask.getDeviceType();
        THashSet<Resource> oResLst = oDeviceType.getResources();
        Iterator oResItor = oResLst.iterator();
        Resource oResource = null;
        DeviceInfo oDeviceInfo = null;
        DeviceTypeInfo oDeviceTypeInfo = null;
        while (oResItor.hasNext()) {
            oResource = (Resource)oResItor.next();
            oDeviceInfo = DCFrameWorkUtil.getDeviceInfoManager().getDevice(oResource.getDeviceID());
            if (null != oDeviceInfo) {
                oDeviceTypeInfo = oDeviceInfo.getDeviceTypeInfo();
            }
            if (null == oDeviceTypeInfo || oDeviceTypeInfo.getDevDomain() != 2 || oResource.getRoleType() != 0) continue;
            this.isNeedToCheckImageFile = true;
            break;
        }
    }

    private class DeviceTypeInfoCellEditor
    extends DefaultCellEditor {
        public DeviceTypeInfoCellEditor(Object[] items) {
            super(new ComboBoxWithToolTip(items));
        }
    }

    public class DeviceTypeInfoCellRenderer
    extends ComboBoxWithToolTip
    implements TableCellRenderer {
        public DeviceTypeInfoCellRenderer(Object[] oDeviceTypeInfo) {
            super(oDeviceTypeInfo);
            this.setSelectedItem(oDeviceTypeInfo[0]);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            if (null == value && null != FileTablePanel.this.m_arrDeviceTypeInfo && 0 < FileTablePanel.this.m_arrDeviceTypeInfo.length) {
                value = FileTablePanel.this.m_arrDeviceTypeInfo[0];
            }
            this.setSelectedItem(value);
            return this;
        }
    }

    private class ContentTypeCellEditor
    extends DefaultCellEditor {
        public ContentTypeCellEditor(Object[] items) {
            super(new ComboBoxWithToolTip(items));
        }
    }

    public class ContentTypeCellRenderer
    extends ComboBoxWithToolTip
    implements TableCellRenderer {
        public ContentTypeCellRenderer(Object[] oContentType) {
            super(oContentType);
            this.setSelectedItem(oContentType[0]);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            if (null == value && null != FileTablePanel.this.m_arrContentTypes && 0 < FileTablePanel.this.m_arrContentTypes.length) {
                value = FileTablePanel.this.m_arrContentTypes[0];
            }
            if (!FileTablePanel.this.isFileSelectOk && FileTablePanel.this.hitRowIndex == row) {
                FileTablePanel.this.isFileSelectOk = true;
                value = FileTablePanel.this.m_arrContentTypes[0];
            }
            this.setSelectedItem(value);
            return this;
        }
    }
}

